/*
 * Decompiled with CFR 0.152.
 */
package sfs3;

import certutil.AESUtil;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import key.ExchangeKey;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import sfs3.EncryptedXML;

public class PHPEncryptedXML
extends EncryptedXML {
    private static final Logger logger = Logger.getLogger(PHPEncryptedXML.class);
    private final String xml;
    private String phpresponse;

    public PHPEncryptedXML(String url, String sessionid, String useragent, String xml, String cookie_sch_id) {
        super(url, sessionid, useragent, cookie_sch_id);
        this.xml = xml;
        this.init();
    }

    public String getPhpresponse() {
        return this.phpresponse;
    }

    public void setPhpresponse(String phpresponse) {
        this.phpresponse = phpresponse;
    }

    @Override
    protected final void init() {
        this.getDHKey();
        this.setPhppk(this.performKeyExchangePost());
        this.performPostXML();
    }

    private void performPostXML() {
        Object output = null;
        try {
            byte[] servSecret = ExchangeKey.generateShareKey(this.getPhppk(), this.getServParamSpec(), this.getServKP());
            logger.debug((Object)("Server Secret Key:" + Base64.encodeBase64String(servSecret)));
            this.setAeskey(ExchangeKey.generateAESKey(servSecret));
            String aeskey = this.getAeskey();
            logger.debug((Object)("AES KEY : " + aeskey));
            ArrayList<BasicNameValuePair> pair = new ArrayList<BasicNameValuePair>();
            pair.add(new BasicNameValuePair("sid", this.getSessionid()));
            pair.add(new BasicNameValuePair("getkey", "false"));
            pair.add(new BasicNameValuePair("encryption_xml", AESUtil.encrypt(this.xml, aeskey)));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pair, "UTF-8");
            HttpPost httpPost = PHPEncryptedXML.getHttpPost();
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpClient demo = PHPEncryptedXML.getDemo();
            HttpClientContext clientContext = HttpClientContext.create();
            clientContext.setAttribute("http.protocol.content-charset", (Object)"UTF-8");
            CloseableHttpResponse response = demo.execute((HttpUriRequest)httpPost, (HttpContext)clientContext);
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"Big5");
            logger.debug((Object)("PHP Response 2 :" + responseString));
            this.setPhpresponse(responseString);
        }
        catch (InvalidKeyException ex) {
            logger.error((Object)ex);
            this.init();
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | InvalidKeySpecException | ParseException ex) {
            logger.info((Object)ex);
        }
    }
}

