/*
 * Decompiled with CFR 0.152.
 */
package tasks;

import java.util.Iterator;
import java.util.List;
import key.ExchangeDataTypes;
import org.apache.log4j.Logger;
import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.tcedu.Xcaexchange;
import org.tcedu.Xcaexchange_Service;
import sfs3.exchangedata;

public class SFS3DecryptedAutoPullBackTask
extends Task<exchangedata> {
    private static final Logger logger = Logger.getLogger(SFS3DecryptedAutoPullBackTask.class);
    private final String in_school_id;
    private final String out_school_id;
    private final String pincode;
    private final String matchable_name;
    private final String matchable_pid;
    private final String matchable_birthday;

    public SFS3DecryptedAutoPullBackTask(String in_school_id, String out_school_id, String pincode, String matchable_name, String matchable_pid, String matchable_birthday) {
        this.in_school_id = in_school_id;
        this.out_school_id = out_school_id;
        this.pincode = pincode;
        this.matchable_name = matchable_name;
        this.matchable_pid = matchable_pid;
        this.matchable_birthday = matchable_birthday;
    }

    public exchangedata execute() throws TaskExecutionException {
        exchangedata data = this.parseExchangeData(SFS3DecryptedAutoPullBackTask.doQueryXML(this.in_school_id, this.out_school_id));
        return data;
    }

    private exchangedata parseExchangeData(List<String> queryxml) {
        Iterator<String> it = queryxml.iterator();
        while (it.hasNext()) {
            exchangedata data = new exchangedata(it.next(), it.next(), it.next(), it.next(), it.next(), it.next(), it.next(), it.next(), this.pincode, this.matchable_name, this.matchable_pid, this.matchable_birthday);
            data.setUpload_time(it.next());
            if (data.getMatch().equalsIgnoreCase("true")) {
                logger.debug((Object)("\u6bd4\u5c0d\u6210\u529f,\u5b78\u7c4d\u4ea4\u63dbSOAP\u8cc7\u6599\n" + data.toString()));
                return data;
            }
            switch (data.getDecryptedData().get((Object)ExchangeDataTypes.AESKEY)) {
                case "no aes key": 
                case "pin error": {
                    return data;
                }
            }
        }
        return new exchangedata();
    }

    private static List<String> doQueryXML(String toschoolid, String fromschoolid) {
        Xcaexchange_Service service = new Xcaexchange_Service();
        Xcaexchange port = service.getXcaexchangePort();
        return port.doQueryXML(toschoolid, fromschoolid);
    }
}

