/*
 * Decompiled with CFR 0.152.
 */
package tasks;

import certutil.CertFromXCA;
import certutil.serialFromXCA;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.tcedu.Xcaexchange;
import org.tcedu.Xcaexchange_Service;
import tw.com.chttl.Token;

public class regXCATask
extends Task<Boolean> {
    private static final Logger logger = Logger.getLogger(regXCATask.class);
    private final String schoolid;

    public regXCATask(String schoolid) {
        this.schoolid = schoolid;
    }

    public Boolean execute() throws TaskExecutionException {
        Boolean success = Boolean.FALSE;
        try {
            final String serial = AccessController.doPrivileged(new serialFromXCA());
            logger.debug((Object)("XCA\u6191\u8b49\u5e8f\u865f : " + serial));
            X509Certificate cryptcert = AccessController.doPrivileged(new CertFromXCA(Token.ID_ENCRYPT));
            X509Certificate signcert = AccessController.doPrivileged(new CertFromXCA(Token.ID_SIGN));
            final String signcertsn = signcert.getSerialNumber().toString(16).toUpperCase();
            final String cryptcertsn = cryptcert.getSerialNumber().toString(16).toUpperCase();
            final String b64cryptcert = Base64.encodeBase64String(cryptcert.getEncoded());
            final String b64signcert = Base64.encodeBase64String(signcert.getEncoded());
            logger.debug((Object)("==\u7c3d\u7ae0\u6191\u8b49 ==\n" + signcertsn + "\n" + b64signcert));
            logger.debug((Object)("==\u52a0\u89e3\u5bc6\u6191\u8b49 ==\n" + cryptcertsn + "\n" + b64cryptcert));
            String dn = cryptcert.getSubjectDN().toString().split(",")[0];
            logger.debug((Object)("DN : " + dn));
            String sch = "";
            if (dn.contains("\u9ad8\u7d1a\u4e2d\u5b78")) {
                sch = dn.substring(dn.indexOf("=") + 3, dn.indexOf("\u9ad8\u7d1a\u4e2d\u5b78"));
                if (dn.contains("\u9678\u8208")) {
                    sch = "\u9678\u8208";
                }
            } else {
                sch = dn.substring(dn.indexOf("=") + 1, dn.indexOf("\u570b"));
                if (sch.contains("\u74e6") && this.schoolid.equals("134785")) {
                    sch = "\u74e6\u7464";
                }
            }
            final String schoolname = sch;
            logger.debug((Object)("\u6191\u8b49\u4e2d\u7684DN : " + schoolname));
            int upload = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                @Override
                public Integer run() {
                    return regXCATask.doRegXCA(regXCATask.this.schoolid, schoolname, serial, signcertsn, b64signcert, cryptcertsn, b64cryptcert);
                }
            });
            if (upload == 1) {
                success = Boolean.TRUE;
            }
        }
        catch (CertificateEncodingException ex) {
            logger.error((Object)ex);
        }
        return success;
    }

    private static int doRegXCA(String schoolid, String schoolname, String xcaSerial, String xcaSignserial, String xcaSigncert, String xcaCryptserial, String xcaCryptcert) {
        Xcaexchange_Service service = new Xcaexchange_Service();
        Xcaexchange port = service.getXcaexchangePort();
        return port.doRegXCA(schoolid, schoolname, xcaSerial, xcaSignserial, xcaSigncert, xcaCryptserial, xcaCryptcert);
    }
}

