/*
 * Decompiled with CFR 0.152.
 */
package ui;

import java.net.URL;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import key.ExchangeDataTypes;
import org.apache.log4j.Logger;
import org.apache.pivot.beans.Bindable;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Map;
import org.apache.pivot.util.Resources;
import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.util.concurrent.TaskListener;
import org.apache.pivot.wtk.ActivityIndicator;
import org.apache.pivot.wtk.Alert;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.ListButton;
import org.apache.pivot.wtk.ListButtonSelectionListener;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.TabPane;
import org.apache.pivot.wtk.TaskAdapter;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.TextInputContentListener;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.content.ButtonDataRenderer;
import sfs3.exchangedata;
import tasks.CheckCardTask;
import tasks.CheckXCARegTask;
import tasks.PHPEncryptedTask;
import tasks.QueryXCAInfoTask;
import tasks.ReadCardTask;
import tasks.SFS3DecryptedAutoPullBackTask;
import tasks.connectSQLite;
import tasks.regXCATask;
import tw.com.chttl.CertUtil;
import tw.com.chttl.Token;

public class XMLDownload
extends Window
implements Bindable {
    private static final Logger logger = Logger.getLogger(XMLDownload.class);
    private ActivityIndicator activityIndicator = null;
    private TabPane tabPane = null;
    private Label lblstud_id = null;
    private Label lblstud_name = null;
    private Label lblstud_pid = null;
    private Label lblstud_birthday = null;
    private Label lblstud_in_class = null;
    private Label lblin_school_eduno = null;
    private Label lblout_school_info = null;
    private ListButton lbCity = null;
    private ListButton lbDistrict = null;
    private ListButton lbType = null;
    private ListButton lbSchool = null;
    private PushButton btnQueryXML = null;
    private TextInput txtPIN = null;
    private PushButton btnImport = null;
    private String pincode;
    private List<exchangedata> aryExchangeData;
    private exchangedata _exchangedata;
    private exchangedata coorespondExchangeData;
    private final String importSuccess = "Applet Import Success!";
    private String sessionid;
    private String cookie_sch_id;
    private String useragent;
    private String targetpage;
    private String stud_id;
    private String stud_name;
    private String stud_pid;
    private String stud_birthday;
    private String stud_in_class;
    private String out_school_info;
    private String stud_out_school;
    private String stud_out_city;
    private String out_school_eduno;
    private String in_school_eduno;
    private String in_school_name;
    private Connection dbConnection = null;
    private PushButton btnReadXCA = null;
    private PushButton btnEnroll = null;
    private PushButton btnViewRegXCA = null;

    public void initialize(Map<String, Object> map, URL url, Resources rsrcs) {
        this.activityIndicator = (ActivityIndicator)map.get((Object)"activityIndicator");
        this.tabPane = (TabPane)map.get((Object)"tabPane");
        this.tabPane.setEnabled(false);
        this.lblstud_id = (Label)map.get((Object)"stud_id");
        this.lblstud_name = (Label)map.get((Object)"stud_name");
        this.lblstud_pid = (Label)map.get((Object)"stud_pid");
        this.lblstud_birthday = (Label)map.get((Object)"stud_birthday");
        this.lblstud_in_class = (Label)map.get((Object)"stud_in_class");
        this.lblin_school_eduno = (Label)map.get((Object)"in_school_eduno");
        this.lblout_school_info = (Label)map.get((Object)"out_school_info");
        this.lbCity = (ListButton)map.get((Object)"lbCity");
        this.lbDistrict = (ListButton)map.get((Object)"lbDistrict");
        this.lbType = (ListButton)map.get((Object)"lbType");
        this.lbSchool = (ListButton)map.get((Object)"lbSchool");
        this.lbDistrict.setEnabled(false);
        this.lbType.setEnabled(false);
        this.lbSchool.setEnabled(false);
        this.btnReadXCA = (PushButton)map.get((Object)"btnReadXCA");
        this.btnEnroll = (PushButton)map.get((Object)"btnEnroll");
        this.btnViewRegXCA = (PushButton)map.get((Object)"btnViewRegXCA");
        this.btnQueryXML = (PushButton)map.get((Object)"btnQueryXML");
        class ButtonDataWrap
        extends ButtonDataRenderer {
            public ButtonDataWrap() {
                this.label.getStyles().put("wrapText", (Object)true);
            }
        }
        this.btnQueryXML.setDataRenderer((Button.DataRenderer)new ButtonDataWrap());
        this.btnQueryXML.setEnabled(false);
        this.txtPIN = (TextInput)map.get((Object)"txtPIN");
        this.txtPIN.setPassword(true);
        this.txtPIN.setEnabled(false);
        this.btnImport = (PushButton)map.get((Object)"btnImport");
        this.btnImport.setDataRenderer((Button.DataRenderer)new ButtonDataWrap());
        this.btnImport.setEnabled(false);
        this.btnQueryXML.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                if (!XMLDownload.this.txtPIN.getText().isEmpty()) {
                    XMLDownload.this.btnQueryXML.setEnabled(false);
                    XMLDownload.this.activityIndicator.setActive(true);
                    SFS3DecryptedAutoPullBackTask task = new SFS3DecryptedAutoPullBackTask(XMLDownload.this.in_school_eduno, XMLDownload.this.out_school_eduno, XMLDownload.this.pincode, XMLDownload.this.stud_name, XMLDownload.this.stud_pid, XMLDownload.this.stud_birthday);
                    TaskListener<exchangedata> tasklistener = new TaskListener<exchangedata>(){

                        public void taskExecuted(Task<exchangedata> task) {
                            String aes;
                            XMLDownload.this._exchangedata = (exchangedata)task.getResult();
                            switch (aes = XMLDownload.this._exchangedata.getDecryptedData().get((Object)ExchangeDataTypes.AESKEY)) {
                                case "no aes key": {
                                    Alert.alert((MessageType)MessageType.WARNING, (String)"\u60a8\u8a3b\u8a18\u7684\u8f49\u5b78\u8cc7\u6599\u548c\u5b78\u7c4d\r\n\u4ea4\u63dbXML\u6a94\u6848\u5167\u5bb9\u4e0d\u540c", (Window)XMLDownload.this);
                                    XMLDownload.this.btnQueryXML.setEnabled(true);
                                    break;
                                }
                                case "pin error": {
                                    Alert.alert((MessageType)MessageType.ERROR, (String)("PIN\u78bc\u8f38\u5165\u932f\u8aa4\uff01\r\n\u60a8\u8f38\u5165\u7684\u662f[" + XMLDownload.this.pincode + "]"), (Window)XMLDownload.this);
                                    XMLDownload.this.btnQueryXML.setEnabled(true);
                                    XMLDownload.this.txtPIN.requestFocus();
                                    break;
                                }
                                case "empty record": {
                                    Alert.alert((MessageType)MessageType.ERROR, (String)"\u8f49\u51fa\u6821\u5c1a\u672a\u4e0a\u50b3\r\n\u5b78\u7c4d\u4ea4\u63dbXML\u6a94\u6848", (Window)XMLDownload.this);
                                    XMLDownload.this.btnQueryXML.setEnabled(true);
                                    break;
                                }
                                default: {
                                    Alert.alert((MessageType)MessageType.INFO, (String)"\u5b78\u7c4d\u4ea4\u63dbXML\u6a94\u6848\u67e5\u8a62\u6210\u529f", (Window)XMLDownload.this);
                                    XMLDownload.this.btnImport.setEnabled(true);
                                }
                            }
                            XMLDownload.this.activityIndicator.setActive(false);
                        }

                        public void executeFailed(Task<exchangedata> task) {
                            XMLDownload.this.activityIndicator.setActive(false);
                            Alert.alert((MessageType)MessageType.ERROR, (String)"\u5b78\u7c4d\u4ea4\u63dbXML\u6a94\u6848\u67e5\u8a62\u5931\u6557", (Window)XMLDownload.this);
                        }
                    };
                    task.execute((TaskListener)new TaskAdapter((TaskListener)tasklistener));
                } else {
                    Alert.alert((MessageType)MessageType.WARNING, (String)"\u8acb\u8f38\u5165PIN\u78bc", (Window)XMLDownload.this);
                    XMLDownload.this.txtPIN.requestFocus();
                }
            }
        });
        this.txtPIN.getTextInputContentListeners().add((Object)new TextInputContentListener.Adapter(){

            public void textInserted(TextInput textInput, int index, int count) {
                XMLDownload.this.btnQueryXML.setEnabled(true);
                XMLDownload.this.pincode = XMLDownload.this.txtPIN.getText();
                logger.debug((Object)("PIN CODE : " + XMLDownload.this.pincode));
            }
        });
        this.btnImport.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                XMLDownload.this.activityIndicator.setActive(true);
                logger.debug((Object)("\u5f9eSOAP\u53d6\u5f97\u4e26\u89e3\u5bc6\u7684XML :\n" + XMLDownload.this._exchangedata.getDescryptedXML()));
                PHPEncryptedTask task = new PHPEncryptedTask(XMLDownload.this.getTargetpage(), XMLDownload.this.getSessionid(), XMLDownload.this.getUseragent(), XMLDownload.this._exchangedata.getDescryptedXML(), XMLDownload.this.getCookie_sch_id());
                TaskListener<String> tasklistener = new TaskListener<String>(){

                    public void taskExecuted(Task<String> task) {
                        String result = (String)task.getResult();
                        logger.debug((Object)("\u4e0a\u50b3XML\u81f3SFS3\u7d50\u679c :\n" + result));
                        if (result.contains("Applet Import Success!")) {
                            Alert.alert((MessageType)MessageType.INFO, (String)"\u6210\u529f\u532f\u5165\u5b78\u7c4d\u4ea4\u63dbXML\u6a94\u6848", (Window)XMLDownload.this);
                        } else {
                            Alert.alert((MessageType)MessageType.ERROR, (String)"\u7121\u6cd5\u532f\u5165\u5b78\u7c4d\u4ea4\u63dbXML\u6a94\u6848", (Window)XMLDownload.this);
                        }
                        XMLDownload.this.activityIndicator.setActive(false);
                    }

                    public void executeFailed(Task<String> task) {
                        XMLDownload.this.activityIndicator.setActive(false);
                        Alert.alert((MessageType)MessageType.ERROR, (String)"\u7121\u6cd5\u6b63\u78ba\u5c07XML\u6a94\u532f\u5165\u81f3SFS3", (Window)XMLDownload.this);
                    }
                };
                task.execute((TaskListener)new TaskAdapter((TaskListener)tasklistener));
            }
        });
        this.btnReadXCA.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                XMLDownload.this.activityIndicator.setActive(true);
                ReadCardTask task = new ReadCardTask();
                TaskListener<Map<Integer, X509Certificate>> tasklistener = new TaskListener<Map<Integer, X509Certificate>>(){

                    public void taskExecuted(Task<Map<Integer, X509Certificate>> task) {
                        XMLDownload.this.activityIndicator.setActive(false);
                        Map result = (Map)task.getResult();
                        Alert.alert((MessageType)MessageType.INFO, (String)XMLDownload.this.showCertInfo((Map<Integer, X509Certificate>)result), (Window)XMLDownload.this);
                    }

                    public void executeFailed(Task<Map<Integer, X509Certificate>> task) {
                        XMLDownload.this.activityIndicator.setActive(false);
                    }
                };
                task.execute((TaskListener)new TaskAdapter((TaskListener)tasklistener));
            }
        });
        this.btnEnroll.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                XMLDownload.this.activityIndicator.setActive(true);
                logger.debug((Object)("\u8a3b\u518aXCA\u6191\u8b49\u5361\u7247\u5e8f\u865f : " + XMLDownload.this.in_school_eduno));
                regXCATask task = new regXCATask(XMLDownload.this.in_school_eduno);
                TaskListener<Boolean> tasklistener = new TaskListener<Boolean>(){

                    public void taskExecuted(Task<Boolean> task) {
                        XMLDownload.this.activityIndicator.setActive(false);
                        Boolean result = (Boolean)task.getResult();
                        if (result.booleanValue()) {
                            Alert.alert((MessageType)MessageType.INFO, (String)"\u8a3b\u518aXCA\u6191\u8b49\u6210\u529f", (Window)XMLDownload.this);
                        } else {
                            Alert.alert((MessageType)MessageType.INFO, (String)"\u8a3b\u518aXCA\u6191\u8b49\u5931\u6557", (Window)XMLDownload.this);
                        }
                    }

                    public void executeFailed(Task<Boolean> task) {
                        XMLDownload.this.activityIndicator.setActive(false);
                    }
                };
                task.execute((TaskListener)new TaskAdapter((TaskListener)tasklistener));
            }
        });
        this.btnViewRegXCA.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                XMLDownload.this.activityIndicator.setActive(true);
                QueryXCAInfoTask task = new QueryXCAInfoTask(XMLDownload.this.in_school_eduno, XMLDownload.this.in_school_name);
                TaskListener<String> tasklistener = new TaskListener<String>(){

                    public void taskExecuted(Task<String> task) {
                        String result = (String)task.getResult();
                        Alert.alert((MessageType)MessageType.INFO, (String)result, (Window)XMLDownload.this);
                        XMLDownload.this.activityIndicator.setActive(false);
                    }

                    public void executeFailed(Task<String> task) {
                        XMLDownload.this.activityIndicator.setActive(false);
                        Alert.alert((MessageType)MessageType.ERROR, (String)"\u7dda\u4e0a\u67e5\u8a62XCA\u6191\u8b49\u8cc7\u8a0a\u5931\u6557", (Window)XMLDownload.this);
                    }
                };
                task.execute((TaskListener)new TaskAdapter((TaskListener)tasklistener));
            }
        });
        Container.setEventDispatchThreadChecker(null);
        this.connectDb();
        this.checkCard();
    }

    private void connectDb() {
        connectSQLite task = new connectSQLite();
        this.activityIndicator.setActive(true);
        TaskListener<Connection> tasklistener = new TaskListener<Connection>(){

            public void taskExecuted(Task<Connection> task) {
                XMLDownload.this.dbConnection = (Connection)task.getResult();
                XMLDownload.this.lbCity.setListData(XMLDownload.this.getCityList());
                XMLDownload.this.lbCity.getListButtonSelectionListeners().add((Object)new ListButtonSelectionListener(){

                    public void selectedIndexChanged(ListButton lb, int i) {
                    }

                    public void selectedItemChanged(ListButton lb, Object o) {
                        Object selectedItem = lb.getSelectedItem();
                        if (selectedItem != null) {
                            XMLDownload.this.lbDistrict.setEnabled(true);
                            XMLDownload.this.lbDistrict.setListData(XMLDownload.this.getDistrictList((String)selectedItem));
                        }
                    }
                });
                XMLDownload.this.lbDistrict.getListButtonSelectionListeners().add((Object)new ListButtonSelectionListener(){

                    public void selectedIndexChanged(ListButton lb, int i) {
                    }

                    public void selectedItemChanged(ListButton lb, Object o) {
                        Object selectedItem = lb.getSelectedItem();
                        if (selectedItem != null) {
                            XMLDownload.this.lbType.setEnabled(true);
                            logger.debug(selectedItem);
                            XMLDownload.this.lbType.setListData(XMLDownload.this.getTypeList((String)XMLDownload.this.lbCity.getSelectedItem(), XMLDownload.this.getCode((String)selectedItem)));
                        }
                    }
                });
                XMLDownload.this.lbType.getListButtonSelectionListeners().add((Object)new ListButtonSelectionListener(){

                    public void selectedIndexChanged(ListButton lb, int i) {
                    }

                    public void selectedItemChanged(ListButton lb, Object o) {
                        Object selectedItem = lb.getSelectedItem();
                        if (selectedItem != null) {
                            XMLDownload.this.lbSchool.setEnabled(true);
                            XMLDownload.this.lbSchool.setListData(XMLDownload.this.getSchoolList((String)XMLDownload.this.lbCity.getSelectedItem(), (String)selectedItem, XMLDownload.this.getCode((String)XMLDownload.this.lbDistrict.getSelectedItem())));
                        }
                    }
                });
                XMLDownload.this.lbSchool.getListButtonSelectionListeners().add((Object)new ListButtonSelectionListener(){

                    public void selectedIndexChanged(ListButton lb, int i) {
                        if ((String)lb.getSelectedItem() != null) {
                            this.checkInSchoolName((String)lb.getSelectedItem());
                        }
                    }

                    public void selectedItemChanged(ListButton lb, Object o) {
                        if ((String)lb.getSelectedItem() != null) {
                            this.checkInSchoolName((String)lb.getSelectedItem());
                        }
                    }

                    private void checkInSchoolName(String in) {
                        logger.debug((Object)("SFS\u50b3\u4f86\u4e4b\u539f\u5c31\u8b80\u5b78\u6821\u540d\u7a31 : " + XMLDownload.this.stud_out_school));
                        logger.debug((Object)("SFS\u50b3\u4f86\u4e4b\u539f\u5c31\u8b80\u5b78\u6821\u7e23\u5e02 : " + XMLDownload.this.stud_out_city));
                        logger.debug((Object)("SFS\u50b3\u4f86\u4e4b\u539f\u5c31\u8b80\u5b78\u6821\u4ee3\u78bc : " + XMLDownload.this.out_school_eduno));
                        logger.debug((Object)("Applet\u9078\u64c7\u4e4b\u5b78\u6821\u540d\u7a31 : " + in.substring(0, in.indexOf("("))));
                        logger.debug((Object)("Applet\u9078\u64c7\u4e4b\u5b78\u6821\u4ee3\u78bc : " + XMLDownload.this.getCode(in)));
                        if (!XMLDownload.this.getCode(in).equals(XMLDownload.this.out_school_eduno)) {
                            Alert.alert((MessageType)MessageType.WARNING, (String)"\u5b78\u52d9\u7cfb\u7d71\u4e2d\u8a3b\u8a18\u4e4b\u539f\u5c31\u8b80\u5b78\u6821\u4ee3\u78bc\n\u548c\u4ea4\u63db\u5e73\u53f0\u7684\u8a18\u9304\u4e0d\u540c\uff0c\u60a8\u53ef\u4ee5\u7e7c\n\u7e8c\u532f\u5165\u4e26\u4e14\u5f8c\u7e8c\u518d\u9032\u884c\u4fee\u6b63\uff01", (Window)XMLDownload.this);
                        }
                        XMLDownload.this.out_school_eduno = XMLDownload.this.getCode(in);
                        XMLDownload.this.txtPIN.setEnabled(true);
                    }
                });
            }

            public void executeFailed(Task<Connection> task) {
                XMLDownload.this.activityIndicator.setActive(false);
                throw new RuntimeException("\u7121\u6cd5\u8f09\u5165Derby Database");
            }
        };
        task.execute((TaskListener)tasklistener);
    }

    private String longestSubstring(String str1, String str2) {
        StringBuilder sb = new StringBuilder();
        if (str1 == null || str1.isEmpty() || str2 == null || str2.isEmpty()) {
            return "";
        }
        str1 = str1.toLowerCase();
        str2 = str2.toLowerCase();
        int[][] num = new int[str1.length()][str2.length()];
        int maxlen = 0;
        int lastSubsBegin = 0;
        for (int i = 0; i < str1.length(); ++i) {
            for (int j = 0; j < str2.length(); ++j) {
                if (str1.charAt(i) != str2.charAt(j)) continue;
                num[i][j] = i == 0 || j == 0 ? 1 : 1 + num[i - 1][j - 1];
                if (num[i][j] <= maxlen) continue;
                maxlen = num[i][j];
                int thisSubsBegin = i - num[i][j] + 1;
                if (lastSubsBegin == thisSubsBegin) {
                    sb.append(str1.charAt(i));
                    continue;
                }
                lastSubsBegin = thisSubsBegin;
                sb = new StringBuilder();
                sb.append(str1.substring(lastSubsBegin, i + 1));
            }
        }
        return sb.toString();
    }

    private String getCode(String item) {
        int prefix = item.indexOf("(");
        int postfix = item.indexOf(")");
        String result = item.substring(prefix + 1, postfix);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.pivot.collections.List<String> getCityList() {
        ArrayList city = new ArrayList();
        try {
            Statement stmt = this.dbConnection.createStatement();
            ResultSet result = stmt.executeQuery("select distinct city from school");
            while (result.next()) {
                String s = result.getString(1);
                city.add((Object)s);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            return city;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.pivot.collections.List<String> getDistrictList(String city) {
        ArrayList district = new ArrayList();
        try {
            String sql = "select district,zipcode from zip where city = ?";
            PreparedStatement stmt = this.dbConnection.prepareStatement(sql);
            stmt.setString(1, city);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                String d = result.getString(1);
                String z = result.getString(2).trim();
                String s = d.concat("(").concat(z).concat(")");
                district.add((Object)s);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            return district;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.pivot.collections.List<String> getTypeList(String city, String zip) {
        ArrayList type = new ArrayList();
        try {
            String sql = "select distinct schooltype from school where city = ? and zip = ?";
            PreparedStatement stmt = this.dbConnection.prepareStatement(sql);
            stmt.setString(1, city);
            stmt.setString(2, zip);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                String s = result.getString(1);
                if (s.isEmpty()) continue;
                type.add((Object)s);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            return type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.pivot.collections.List<String> getSchoolList(String city, String type, String zip) {
        ArrayList school = new ArrayList();
        try {
            String sql = "select id,name from school where city = ? and schooltype = ? and zip = ?";
            PreparedStatement stmt = this.dbConnection.prepareStatement(sql);
            stmt.setString(1, city);
            stmt.setString(2, type);
            stmt.setString(3, zip);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                String id = result.getString(1);
                String name = result.getString(2);
                String s = name.concat("(").concat(id).concat(")");
                school.add((Object)s);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            return school;
        }
    }

    private void checkCard() {
        this.activityIndicator.setActive(true);
        CheckCardTask task = new CheckCardTask();
        TaskListener<Integer> tasklistener = new TaskListener<Integer>(){

            public void taskExecuted(Task<Integer> task) {
                try {
                    int result = (Integer)task.execute();
                    switch (result) {
                        case 0: 
                        case 1: 
                        case 3: {
                            Alert.alert((MessageType)MessageType.ERROR, (String)"\u8b80\u5361\u6a5f\u8b80\u53d6\u932f\u8aa4\uff0c\u8acb\u78ba\u5b9a\u5df2\u63d2\u5165XCA\u5361\u7247", (Window)XMLDownload.this);
                            break;
                        }
                        case 2: {
                            XMLDownload.this.activityIndicator.setActive(false);
                            XMLDownload.this.tabPane.setEnabled(true);
                        }
                    }
                }
                catch (TaskExecutionException ex) {
                    logger.error((Object)ex);
                }
            }

            public void executeFailed(Task<Integer> task) {
                Alert.alert((MessageType)MessageType.ERROR, (String)"\u7121\u6cd5\u627e\u5230\u8b80\u5361\u6a5f", (Window)XMLDownload.this);
            }
        };
        task.execute((TaskListener)new TaskAdapter((TaskListener)tasklistener));
    }

    private boolean checkDataEqual(String name, String pid, String birthday) {
        return name.equals(this.stud_name) && pid.equals(this.stud_pid) && birthday.equals(this.stud_birthday);
    }

    private void checkInFormComplete() {
        if (this.out_school_eduno == null || this.out_school_eduno.isEmpty()) {
            Alert.alert((MessageType)MessageType.WARNING, (String)"\u539f\u5c31\u8b80\u5b78\u6821\u6559\u80b2\u90e8\u4ee3\u78bc\u6c92\u6709\u586b", (Window)this);
        }
        if (this.stud_out_city == null || this.stud_out_city.isEmpty()) {
            Alert.alert((MessageType)MessageType.WARNING, (String)"\u539f\u5c31\u8b80\u5b78\u6821\u6240\u5c6c\u7e23\u5e02\u6c92\u6709\u586b", (Window)this);
        }
        if (this.stud_out_school == null || this.stud_out_school.isEmpty()) {
            Alert.alert((MessageType)MessageType.WARNING, (String)"\u539f\u5c31\u8b80\u5b78\u6821\u540d\u7a31\u6c92\u6709\u586b", (Window)this);
        }
    }

    public String getCookie_sch_id() {
        return this.cookie_sch_id;
    }

    public void setCookie_sch_id(String cookie_sch_id) {
        this.cookie_sch_id = cookie_sch_id;
    }

    public String getSessionid() {
        return this.sessionid;
    }

    public void setSessionid(String sessionid) {
        this.sessionid = sessionid;
    }

    public String getUseragent() {
        return this.useragent;
    }

    public void setUseragent(String useragent) {
        this.useragent = useragent;
    }

    public String getTargetpage() {
        return this.targetpage;
    }

    public void setTargetpage(String targetpage) {
        this.targetpage = targetpage;
    }

    public void setPara(String sn) {
        String[] s = sn.split(";");
        this.stud_id = s[0];
        this.stud_name = s[1];
        this.stud_pid = s[2];
        this.stud_birthday = s[3];
        this.stud_in_class = s[4];
        String[] ary_out_school_info = s[5].split("-");
        this.out_school_info = s[5];
        try {
            this.out_school_eduno = ary_out_school_info[0].trim();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.out_school_eduno = "";
        }
        try {
            this.stud_out_city = ary_out_school_info[1].trim();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.stud_out_city = "";
        }
        try {
            this.stud_out_school = ary_out_school_info[2].trim();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.stud_out_school = "";
        }
        this.in_school_eduno = s[6];
        this.in_school_eduno = s[6].substring(s[6].lastIndexOf("(") + 1, s[6].lastIndexOf(")"));
        this.in_school_name = s[6].substring(0, s[6].lastIndexOf("("));
        logger.debug((Object)("\u8f49\u51fa\u6821\u77ed\u7a31:" + this.in_school_name + ";\u4ee3\u78bc:" + this.in_school_eduno));
        this.initReview();
    }

    private void initReview() {
        this.lblstud_name.setText(this.stud_name);
        this.lblstud_id.setText(this.stud_id);
        this.lblstud_pid.setText(this.stud_pid);
        this.lblstud_birthday.setText(this.stud_birthday);
        this.lblstud_in_class.setText(this.stud_in_class);
        this.lblin_school_eduno.setText(this.in_school_eduno);
        this.lblout_school_info.setText(this.out_school_info);
        this.checkIsRegister();
    }

    private void checkIsRegister() {
        CheckXCARegTask task = new CheckXCARegTask(this.in_school_eduno, this.in_school_name);
        TaskListener<String> tasklistener = new TaskListener<String>(){

            public void taskExecuted(Task<String> task) {
                String result = (String)task.getResult();
            }

            public void executeFailed(Task<String> task) {
            }
        };
        task.execute((TaskListener)new TaskAdapter((TaskListener)tasklistener));
    }

    private String showCertInfo(Map<Integer, X509Certificate> certs) {
        StringBuilder sb = new StringBuilder();
        X509Certificate signcert = (X509Certificate)certs.get((Object)Token.ID_SIGN);
        sb.append("== \u7c3d\u7ae0XCA\u6191\u8b49 ==");
        sb.append("\r\n");
        sb.append("\u5e8f\u865f : " + signcert.getSerialNumber().toString(16).toUpperCase());
        sb.append("\r\n");
        sb.append("\u672c\u6191\u8b49\u578b\u5f0f : " + CertUtil.getSubjectType(signcert));
        sb.append("\r\n");
        sb.append("OCSP : " + CertUtil.getOCSP(signcert));
        sb.append("\r\n");
        sb.append("\u5168\u929c : " + signcert.getSubjectDN());
        sb.append("\r\n");
        String oid = CertUtil.getOrgOID(signcert);
        sb.append("\u7d44\u7e54OID : " + oid);
        sb.append("\r\n");
        sb.append(this.parseDN(signcert.getSubjectDN().getName()));
        return sb.toString();
    }

    private String parseDN(String dn) {
        String[] dns = dn.split(",");
        String result = "";
        logger.debug((Object)("Original DN :\n" + dn));
        if (dns.length == 3) {
            String schoolname = dns[0];
            String city = dns[1];
            result = "\u5b78\u6821\u5168\u929c : " + schoolname.substring(schoolname.indexOf("=") + 1) + ";" + city.substring(city.indexOf("=") + 1) + ";" + schoolname.substring(schoolname.indexOf("\u9ad8\u7d1a"));
            String shortname = schoolname.substring(schoolname.indexOf("=") + 3);
            logger.debug((Object)("shortname : " + shortname));
            int end = shortname.indexOf("\u9ad8\u7d1a\u4e2d\u5b78");
            logger.debug((Object)end);
            logger.debug((Object)("\u7d9c\u5408\u9ad8\u4e2d:" + shortname.substring(0, end)));
        } else {
            String schoolname = dns[0];
            String district = dns[1];
            String city = dns[2];
            result = "\u5b78\u6821\u5168\u929c : " + schoolname.substring(schoolname.indexOf("=") + 1) + ";" + district.substring(district.indexOf("=") + 1) + ";" + city.substring(city.indexOf("=") + 1) + ";" + schoolname.substring(schoolname.indexOf("\u570b"));
        }
        logger.debug((Object)result);
        return result;
    }
}

