/*
 * Decompiled with CFR 0.152.
 */
package ui;

import certutil.AESUtil;
import certutil.CertFromWeb;
import certutil.DecryptFromXCA;
import certutil.SignFromXCA;
import java.io.StringReader;
import java.net.URL;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import key.ExchangeKey;
import key.ExchangeKeyTypes;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.pivot.beans.Bindable;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.util.Resources;
import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.util.concurrent.TaskListener;
import org.apache.pivot.wtk.ActivityIndicator;
import org.apache.pivot.wtk.Alert;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.ListButton;
import org.apache.pivot.wtk.ListButtonSelectionListener;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.TabPane;
import org.apache.pivot.wtk.TaskAdapter;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.TextInputContentListener;
import org.apache.pivot.wtk.Window;
import org.tcedu.Xcaexchange;
import org.tcedu.Xcaexchange_Service;
import sfs3.XMLParser;
import tasks.CheckCardTask;
import tasks.CheckXCARegTask;
import tasks.QueryXCAInfoTask;
import tasks.ReadCardTask;
import tasks.SFS3EncryptedTask;
import tasks.connectSQLite;
import tasks.regXCATask;
import tw.com.chttl.CertUtil;
import tw.com.chttl.CryptoUtil;
import tw.com.chttl.Token;

public class XMLUpload
extends Window
implements Bindable {
    private BoxPane cornerBoxPane = null;
    private TabPane tabPane = null;
    private PushButton btnUpload = null;
    private PushButton btnCrypt = null;
    private TextInput txtPIN = null;
    private String pinpass;
    private ActivityIndicator activityIndicator = null;
    private ActivityIndicator signIndicator = null;
    private ActivityIndicator cryptIndicator = null;
    private ListButton lbCity = null;
    private ListButton lbDistrict = null;
    private ListButton lbType = null;
    private ListButton lbSchool = null;
    private Connection dbConnection = null;
    private final String derbyDriver = "org.apache.derby.jdbc.EmbeddedDriver";
    private final String connectionString = "jdbc:derby:classpath:xcaexchange;user=xca;password=xca";
    private String sessionid;
    private String cookie_sch_id;
    private String useragent;
    private String targetpage;
    private String currseme;
    private String studentsn;
    private String stud_id;
    private String stud_name;
    private String stud_class;
    private String stud_new_school;
    private String stud_ori_school;
    private Label lblstud_id = null;
    private Label lblstud_name = null;
    private Label lblstud_class = null;
    private Label lblstud_new_school = null;
    private Label lblstud_ori_school = null;
    private PushButton btnReadXCA = null;
    private PushButton btnEnroll = null;
    private PushButton btnViewRegXCA = null;
    private String out_school_name;
    private static final Logger logger = Logger.getLogger(XMLUpload.class);
    private String aeskey;
    private String encStudName;
    private String encStudPid;
    private String encStudBirthday;
    private String signCert;
    private String cryptCert;
    private String signSN;
    private String cryptSN;
    private String uploadOutEduNo;
    private String uploadInEduNo;
    private String InSchoolName;
    private String uploadEncStName;
    private String uploadEncStBirthday;
    private String uploadEncStPID;
    private String uploadEncAesKey;
    private String uploadXML;
    private String uploadSigXML;

    public void setInSchoolName(String name) {
        this.InSchoolName = name;
    }

    public String getInSchoolName() {
        return this.InSchoolName;
    }

    public void setUploadOutEduNo(String outno) {
        this.uploadOutEduNo = outno;
    }

    public String getUploadOutEduNo() {
        return this.uploadOutEduNo;
    }

    public void setUploadInEduNo(String inno) {
        this.uploadInEduNo = inno;
    }

    public String getUploadInEduNo() {
        return this.uploadInEduNo;
    }

    public void setUploadEncAesKey(String encaeskey) {
        this.uploadEncAesKey = encaeskey;
    }

    public String getUploadEncAesKey() {
        return this.uploadEncAesKey;
    }

    public void setUploadEncStName(String name) {
        this.uploadEncStName = name;
    }

    public String getUploadEncStName() {
        return this.uploadEncStName;
    }

    public void setUploadEncStBirthday(String birthday) {
        this.uploadEncStBirthday = birthday;
    }

    public String getUploadEncStBirthday() {
        return this.uploadEncStBirthday;
    }

    public void setUploadEncStPID(String pid) {
        this.uploadEncStPID = pid;
    }

    public String getUploadEncStPID() {
        return this.uploadEncStPID;
    }

    public void setSigncert(X509Certificate cert) {
    }

    public void setUploadSigXml(String sigxml) {
        this.uploadSigXML = sigxml;
    }

    public String getUploadSigXml() {
        return this.uploadSigXML;
    }

    public void setAeskey(String aes) {
        this.aeskey = aes;
    }

    public String getAeskey() {
        return this.aeskey;
    }

    public String getUploadXml() {
        return this.uploadXML;
    }

    public void setUploadXml(String xml) {
        this.uploadXML = xml;
    }

    public void setPara(String sn) {
        String[] s = sn.split(";");
        this.studentsn = s[0];
        this.currseme = s[1];
        this.stud_id = s[2];
        this.stud_name = s[3];
        this.stud_class = s[4];
        this.InSchoolName = s[5];
        this.uploadOutEduNo = s[6].substring(s[6].lastIndexOf("(") + 1, s[6].lastIndexOf(")"));
        this.out_school_name = s[6].substring(0, s[6].lastIndexOf("("));
        logger.debug((Object)("\u8f49\u51fa\u6821\u77ed\u7a31:" + this.out_school_name + ";\u4ee3\u78bc:" + this.uploadOutEduNo));
        this.initReview();
    }

    private void initReview() {
        this.lblstud_id.setText(this.getStudid());
        this.lblstud_name.setText(this.getStudname());
        this.lblstud_class.setText(this.getStudclass());
        this.lblstud_new_school.setText(this.getInSchoolName());
        this.lblstud_ori_school.setText(this.getUploadOutEduNo());
        this.checkIsRegister();
    }

    private void checkIsRegister() {
        CheckXCARegTask task = new CheckXCARegTask(this.getUploadOutEduNo(), this.getOut_school_name());
        TaskListener<String> tasklistener = new TaskListener<String>(){

            public void taskExecuted(Task<String> task) {
                String result = (String)task.getResult();
            }

            public void executeFailed(Task<String> task) {
            }
        };
        task.execute((TaskListener)new TaskAdapter((TaskListener)tasklistener));
    }

    public String getOut_school_name() {
        return this.out_school_name;
    }

    public void setOut_school_name(String out_school_name) {
        this.out_school_name = out_school_name;
    }

    public String getStudorischool() {
        return this.stud_ori_school;
    }

    public String getStudnewschool() {
        return this.stud_new_school;
    }

    public String getStudid() {
        return this.stud_id;
    }

    public String getStudname() {
        return this.stud_name;
    }

    public String getStudclass() {
        return this.stud_class;
    }

    public String getSeme() {
        return this.currseme;
    }

    public String getStudentsn() {
        return this.studentsn;
    }

    public void setTargetpage(String page) {
        this.targetpage = page;
    }

    public String getTargetpage() {
        return this.targetpage;
    }

    public void setUseragent(String useragent) {
        this.useragent = useragent;
    }

    public String getUseragent() {
        return this.useragent;
    }

    public void setSessionid(String sessionid) {
        this.sessionid = sessionid;
    }

    public String getSessionid() {
        return this.sessionid;
    }

    private void connectDb() {
        connectSQLite task = new connectSQLite();
        this.activityIndicator.setActive(true);
        TaskListener<Connection> tasklistener = new TaskListener<Connection>(){

            public void taskExecuted(Task<Connection> task) {
                XMLUpload.this.dbConnection = (Connection)task.getResult();
                XMLUpload.this.lbCity.setListData(XMLUpload.this.getCityList());
                XMLUpload.this.lbCity.getListButtonSelectionListeners().add((Object)new ListButtonSelectionListener(){

                    public void selectedIndexChanged(ListButton lb, int i) {
                    }

                    public void selectedItemChanged(ListButton lb, Object o) {
                        Object selectedItem = lb.getSelectedItem();
                        if (selectedItem != null) {
                            XMLUpload.this.lbDistrict.setEnabled(true);
                            XMLUpload.this.lbDistrict.setListData(XMLUpload.this.getDistrictList((String)selectedItem));
                        }
                    }
                });
                XMLUpload.this.lbDistrict.getListButtonSelectionListeners().add((Object)new ListButtonSelectionListener(){

                    public void selectedIndexChanged(ListButton lb, int i) {
                    }

                    public void selectedItemChanged(ListButton lb, Object o) {
                        Object selectedItem = lb.getSelectedItem();
                        if (selectedItem != null) {
                            XMLUpload.this.lbType.setEnabled(true);
                            logger.debug(selectedItem);
                            XMLUpload.this.lbType.setListData(XMLUpload.this.getTypeList((String)XMLUpload.this.lbCity.getSelectedItem(), XMLUpload.this.getCode((String)selectedItem)));
                        }
                    }
                });
                XMLUpload.this.lbType.getListButtonSelectionListeners().add((Object)new ListButtonSelectionListener(){

                    public void selectedIndexChanged(ListButton lb, int i) {
                    }

                    public void selectedItemChanged(ListButton lb, Object o) {
                        Object selectedItem = lb.getSelectedItem();
                        if (selectedItem != null) {
                            XMLUpload.this.lbSchool.setEnabled(true);
                            XMLUpload.this.lbSchool.setListData(XMLUpload.this.getSchoolList((String)XMLUpload.this.lbCity.getSelectedItem(), (String)selectedItem, XMLUpload.this.getCode((String)XMLUpload.this.lbDistrict.getSelectedItem())));
                        }
                    }
                });
                XMLUpload.this.lbSchool.getListButtonSelectionListeners().add((Object)new ListButtonSelectionListener(){

                    public void selectedIndexChanged(ListButton lb, int i) {
                        if ((String)lb.getSelectedItem() != null) {
                            this.checkInSchoolName((String)lb.getSelectedItem());
                        }
                    }

                    public void selectedItemChanged(ListButton lb, Object o) {
                        if ((String)lb.getSelectedItem() != null) {
                            this.checkInSchoolName((String)lb.getSelectedItem());
                        }
                    }

                    private void checkInSchoolName(String in) {
                        try {
                            logger.debug((Object)("SFS\u50b3\u4f86\u4e4b\u8f49\u5165\u5b78\u6821\u540d\u7a31 : " + XMLUpload.this.getInSchoolName().substring(0, XMLUpload.this.getInSchoolName().indexOf("\u570b"))));
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            logger.debug((Object)("SFS\u50b3\u4f86\u4e4b\u8f49\u5165\u5b78\u6821\u540d\u7a31 : " + XMLUpload.this.getInSchoolName()));
                        }
                        logger.debug((Object)("Applet\u9078\u64c7\u4e4b\u5b78\u6821\u540d\u7a31 : " + in.substring(0, in.lastIndexOf("("))));
                        try {
                            if (in.substring(0, in.lastIndexOf("(")).contains(XMLUpload.this.getInSchoolName().substring(0, XMLUpload.this.getInSchoolName().indexOf("\u570b")))) {
                                XMLUpload.this.txtPIN.setEnabled(true);
                            } else {
                                Alert.alert((MessageType)MessageType.ERROR, (String)"\u8f49\u5165\u5b78\u6821\u4e0d\u7b26\uff0c\u8acb\u91cd\u65b0\u6aa2\u67e5\uff01", (Window)XMLUpload.this);
                            }
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            if (in.substring(0, in.lastIndexOf("(")).contains(XMLUpload.this.getInSchoolName())) {
                                XMLUpload.this.txtPIN.setEnabled(true);
                            }
                            Alert.alert((MessageType)MessageType.ERROR, (String)"\u8f49\u5165\u5b78\u6821\u4e0d\u7b26\uff0c\u8acb\u91cd\u65b0\u6aa2\u67e5\uff01", (Window)XMLUpload.this);
                        }
                    }
                });
            }

            public void executeFailed(Task<Connection> task) {
                XMLUpload.this.activityIndicator.setActive(false);
                throw new RuntimeException("\u7121\u6cd5\u8f09\u5165Derby Database");
            }
        };
        task.execute((TaskListener)tasklistener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getCityList() {
        ArrayList city = new ArrayList();
        try {
            Statement stmt = this.dbConnection.createStatement();
            ResultSet result = stmt.executeQuery("select distinct city from school");
            while (result.next()) {
                String s = result.getString(1);
                city.add((Object)s);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            return city;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getDistrictList(String city) {
        ArrayList district = new ArrayList();
        try {
            String sql = "select district,zipcode from zip where city = ?";
            PreparedStatement stmt = this.dbConnection.prepareStatement(sql);
            stmt.setString(1, city);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                String d = result.getString(1);
                String z = result.getString(2).trim();
                String s = d.concat("(").concat(z).concat(")");
                district.add((Object)s);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            return district;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getTypeList(String city, String zip) {
        ArrayList type = new ArrayList();
        try {
            String sql = "select distinct schooltype from school where city = ? and zip = ?";
            PreparedStatement stmt = this.dbConnection.prepareStatement(sql);
            stmt.setString(1, city);
            stmt.setString(2, zip);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                String s = result.getString(1);
                if (s.isEmpty()) continue;
                type.add((Object)s);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            return type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getSchoolList(String city, String type, String zip) {
        ArrayList school = new ArrayList();
        try {
            String sql = "select id,name from school where city = ? and schooltype = ? and zip = ?";
            PreparedStatement stmt = this.dbConnection.prepareStatement(sql);
            stmt.setString(1, city);
            stmt.setString(2, type);
            stmt.setString(3, zip);
            ResultSet result = stmt.executeQuery();
            while (result.next()) {
                String id = result.getString(1);
                String name = result.getString(2);
                String s = name.concat("(").concat(id).concat(")");
                school.add((Object)s);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            return school;
        }
    }

    public void initialize(org.apache.pivot.collections.Map<String, Object> map, URL url, Resources rsrcs) {
        this.tabPane = (TabPane)map.get((Object)"tabPane");
        this.tabPane.setEnabled(false);
        this.txtPIN = (TextInput)map.get((Object)"txtPIN");
        this.activityIndicator = (ActivityIndicator)map.get((Object)"activityIndicator");
        this.cornerBoxPane = (BoxPane)map.get((Object)"cornerBoxPane");
        this.btnUpload = (PushButton)map.get((Object)"btnUpload");
        this.lbCity = (ListButton)map.get((Object)"lbCity");
        this.lbDistrict = (ListButton)map.get((Object)"lbDistrict");
        this.lbType = (ListButton)map.get((Object)"lbType");
        this.lbSchool = (ListButton)map.get((Object)"lbSchool");
        this.lbDistrict.setEnabled(false);
        this.lbType.setEnabled(false);
        this.lbSchool.setEnabled(false);
        this.txtPIN.setEnabled(false);
        this.txtPIN.setPassword(true);
        this.btnUpload.setEnabled(false);
        this.lblstud_id = (Label)map.get((Object)"stud_id");
        this.lblstud_class = (Label)map.get((Object)"stud_class");
        this.lblstud_name = (Label)map.get((Object)"stud_name");
        this.lblstud_new_school = (Label)map.get((Object)"stud_new_school");
        this.lblstud_ori_school = (Label)map.get((Object)"stud_ori_school");
        this.btnReadXCA = (PushButton)map.get((Object)"btnReadXCA");
        this.btnEnroll = (PushButton)map.get((Object)"btnEnroll");
        this.btnViewRegXCA = (PushButton)map.get((Object)"btnViewRegXCA");
        Container.setEventDispatchThreadChecker(null);
        this.connectDb();
        this.checkCard();
        this.txtPIN.getTextInputContentListeners().add((Object)new TextInputContentListener.Adapter(){

            public void textInserted(TextInput textInput, int index, int count) {
                XMLUpload.this.btnUpload.setEnabled(true);
            }
        });
        this.btnUpload.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                if (!XMLUpload.this.txtPIN.getText().isEmpty()) {
                    XMLUpload.this.activityIndicator.setActive(true);
                    XMLUpload.this.txtPIN.setEditable(false);
                    XMLUpload.this.pinpass = XMLUpload.this.txtPIN.getText();
                    logger.debug((Object)("\u8f38\u5165\u7684XCA\u6191\u8b49\u5bc6\u78bc\u662f : " + XMLUpload.this.pinpass));
                    String selectedSchool = (String)XMLUpload.this.lbSchool.getSelectedItem();
                    XMLUpload.this.setUploadInEduNo(XMLUpload.this.getCode(selectedSchool));
                    logger.debug((Object)("\u8f49\u5165\u6821 Edu Code : " + XMLUpload.this.getUploadInEduNo()));
                    XMLUpload.this.setInSchoolName(selectedSchool.substring(0, selectedSchool.indexOf("(")));
                    logger.debug((Object)("\u8f49\u5165\u6821\u6821\u540d : " + XMLUpload.this.getInSchoolName()));
                    java.util.ArrayList<String> sts = new java.util.ArrayList<String>();
                    sts.add(XMLUpload.this.getStudentsn());
                    SFS3EncryptedTask task = new SFS3EncryptedTask(XMLUpload.this.getTargetpage(), XMLUpload.this.sessionid, XMLUpload.this.useragent, XMLUpload.this.currseme, sts, XMLUpload.this.getCookie_sch_id());
                    TaskListener<Map<ExchangeKeyTypes, String>> tasklistener = new TaskListener<Map<ExchangeKeyTypes, String>>(){

                        public void taskExecuted(Task<Map<ExchangeKeyTypes, String>> task) {
                            Map result = (Map)task.getResult();
                            XMLUpload.this.setAeskey((String)result.get((Object)ExchangeKeyTypes.ShareAESKey));
                            logger.debug((Object)("AES Key : " + XMLUpload.this.getAeskey()));
                            XMLUpload.this.setUploadXml((String)result.get((Object)ExchangeKeyTypes.EncryptedXML));
                            logger.debug((Object)("EncryptedXML : " + XMLUpload.this.getUploadXml()));
                            try {
                                String output = ExchangeKey.generateDecryptedXML(XMLUpload.this.getUploadXml(), XMLUpload.this.getAeskey().getBytes());
                                XMLParser xmlparser = new XMLParser(new StringReader(output));
                                XMLUpload.this.setUploadEncStName(AESUtil.encrypt(xmlparser.getName(), XMLUpload.this.getAeskey()));
                                XMLUpload.this.setUploadEncStBirthday(AESUtil.encrypt(xmlparser.getBirthday(), XMLUpload.this.getAeskey()));
                                XMLUpload.this.setUploadEncStPID(AESUtil.encrypt(xmlparser.getPid(), XMLUpload.this.getAeskey()));
                                logger.debug((Object)("\u5b78\u751f\u59d3\u540d : " + XMLUpload.this.getUploadEncStName() + " - \u89e3\u5bc6\u5f8c : " + AESUtil.decrypt(XMLUpload.this.getUploadEncStName(), XMLUpload.this.getAeskey())));
                                logger.debug((Object)("\u5b78\u751f\u6027\u5225 : " + xmlparser.getSex()));
                                logger.debug((Object)("\u5b78\u751f\u751f\u65e5 : " + XMLUpload.this.getUploadEncStBirthday() + " - \u89e3\u5bc6\u5f8c : " + AESUtil.decrypt(XMLUpload.this.getUploadEncStBirthday(), XMLUpload.this.getAeskey())));
                                logger.debug((Object)("\u5b78\u751f\u8eab\u4efd\u8b49 : " + XMLUpload.this.getUploadEncStPID() + " - \u89e3\u5bc6\u5f8c : " + AESUtil.decrypt(XMLUpload.this.getUploadEncStPID(), XMLUpload.this.getAeskey())));
                            }
                            catch (Exception ex) {
                                logger.error((Object)ex);
                            }
                            try {
                                String inXCACryptSerial = XMLUpload.doQueryCryptCertSerial(XMLUpload.this.getUploadInEduNo(), XMLUpload.this.getInSchoolName());
                                if (inXCACryptSerial.isEmpty()) {
                                    Alert.alert((MessageType)MessageType.ERROR, (String)(XMLUpload.this.getInSchoolName() + "\u6c92\u6709\u4e0a\u50b3XCA\u6191\u8b49"), (Window)XMLUpload.this);
                                    throw new RuntimeException(XMLUpload.this.getInSchoolName() + "\u6c92\u6709\u4e0a\u50b3XCA\u6191\u8b49");
                                }
                                logger.debug((Object)("\u8f49\u5165\u6821\u52a0\u89e3\u5bc6\u6191\u8b49\u5e8f\u865f : " + inXCACryptSerial));
                                X509Certificate x509 = CertFromWeb.getX509Certificate(inXCACryptSerial);
                                logger.debug((Object)("\u539f\u59cbAES Key : " + XMLUpload.this.getAeskey()));
                                byte[] aesenc = CryptoUtil.wrap(x509, XMLUpload.this.getAeskey().getBytes());
                                XMLUpload.this.setUploadEncAesKey(Base64.encodeBase64String(aesenc));
                                logger.debug((Object)("\u52a0\u5bc6\u5f8cAES Key : " + XMLUpload.this.getUploadEncAesKey()));
                            }
                            catch (Exception ex) {
                                logger.error((Object)ex);
                            }
                            String aesEncXML = AccessController.doPrivileged(new SignFromXCA(XMLUpload.this.pinpass, XMLUpload.this.getUploadXml()));
                            if (aesEncXML == null) {
                                Alert.alert((MessageType)MessageType.ERROR, (String)("PIN\u78bc\u8f38\u5165\u932f\u8aa4\uff01\r\n\u60a8\u8f38\u5165\u7684\u662f[" + XMLUpload.this.pinpass + "]"), (Window)XMLUpload.this);
                                XMLUpload.this.activityIndicator.setActive(false);
                                XMLUpload.this.btnUpload.setEnabled(false);
                                XMLUpload.this.txtPIN.requestFocus();
                                throw new RuntimeException(XMLUpload.this.getInSchoolName() + "PIN\u78bc\u8f38\u5165\u932f\u8aa4!");
                            }
                            XMLUpload.this.setUploadSigXml(aesEncXML);
                            logger.debug((Object)("\u52a0\u7c3d\u5f8cXML : " + XMLUpload.this.getUploadSigXml()));
                            String inXCASN = XMLUpload.doQueryXCASerial(XMLUpload.this.getUploadInEduNo(), XMLUpload.this.getInSchoolName());
                            if (inXCASN.isEmpty()) {
                                Alert.alert((MessageType)MessageType.ERROR, (String)(XMLUpload.this.getInSchoolName() + "\u6c92\u6709\u4e0a\u50b3XCA\u6191\u8b49"), (Window)XMLUpload.this);
                                XMLUpload.this.activityIndicator.setActive(false);
                                XMLUpload.this.btnUpload.setEnabled(false);
                                XMLUpload.this.txtPIN.requestFocus();
                                throw new RuntimeException(XMLUpload.this.getInSchoolName() + "\u6c92\u6709\u4e0a\u50b3XCA\u6191\u8b49");
                            }
                            int uploaded = XMLUpload.doUploadEncXML(XMLUpload.this.getUploadOutEduNo(), XMLUpload.this.getUploadInEduNo(), XMLUpload.this.getUploadEncStName(), XMLUpload.this.getUploadEncStPID(), XMLUpload.this.getUploadEncStBirthday(), XMLUpload.this.getUploadEncAesKey(), XMLUpload.this.getUploadXml(), XMLUpload.this.getUploadSigXml(), inXCASN);
                            if (uploaded == 1) {
                                Alert.alert((MessageType)MessageType.INFO, (String)"\u5b78\u7c4dXML\u6a94\u6848\u52a0\u5bc6\u4e0a\u50b3\u6210\u529f", (Window)XMLUpload.this);
                            } else {
                                Alert.alert((MessageType)MessageType.ERROR, (String)"\u5b78\u7c4dXML\u6a94\u6848\u52a0\u5bc6\u4e0a\u50b3\u5931\u6557", (Window)XMLUpload.this);
                            }
                            XMLUpload.this.activityIndicator.setActive(false);
                        }

                        public void executeFailed(Task<Map<ExchangeKeyTypes, String>> task) {
                            XMLUpload.this.activityIndicator.setActive(false);
                            Alert.alert((MessageType)MessageType.WARNING, (String)"\u7a0b\u5f0f\u7121\u6cd5\u6b63\u5e38\u57f7\u884c", (Window)XMLUpload.this);
                        }
                    };
                    task.execute((TaskListener)new TaskAdapter((TaskListener)tasklistener));
                } else {
                    Alert.alert((MessageType)MessageType.WARNING, (String)"\u8acb\u8f38\u5165PIN\u78bc", (Window)XMLUpload.this);
                    XMLUpload.this.txtPIN.requestFocus();
                }
            }
        });
        this.btnReadXCA.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                XMLUpload.this.activityIndicator.setActive(true);
                ReadCardTask task = new ReadCardTask();
                TaskListener<org.apache.pivot.collections.Map<Integer, X509Certificate>> tasklistener = new TaskListener<org.apache.pivot.collections.Map<Integer, X509Certificate>>(){

                    public void taskExecuted(Task<org.apache.pivot.collections.Map<Integer, X509Certificate>> task) {
                        XMLUpload.this.activityIndicator.setActive(false);
                        org.apache.pivot.collections.Map result = (org.apache.pivot.collections.Map)task.getResult();
                        Alert.alert((MessageType)MessageType.INFO, (String)XMLUpload.this.showCertInfo((org.apache.pivot.collections.Map<Integer, X509Certificate>)result), (Window)XMLUpload.this);
                    }

                    public void executeFailed(Task<org.apache.pivot.collections.Map<Integer, X509Certificate>> task) {
                        XMLUpload.this.activityIndicator.setActive(false);
                    }
                };
                task.execute((TaskListener)new TaskAdapter((TaskListener)tasklistener));
            }
        });
        this.btnEnroll.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                XMLUpload.this.activityIndicator.setActive(true);
                logger.debug((Object)("\u8a3b\u518aXCA\u6191\u8b49\u5361\u7247\u5e8f\u865f : " + XMLUpload.this.getUploadOutEduNo()));
                regXCATask task = new regXCATask(XMLUpload.this.getUploadOutEduNo());
                TaskListener<Boolean> tasklistener = new TaskListener<Boolean>(){

                    public void taskExecuted(Task<Boolean> task) {
                        XMLUpload.this.activityIndicator.setActive(false);
                        Boolean result = (Boolean)task.getResult();
                        if (result.booleanValue()) {
                            Alert.alert((MessageType)MessageType.INFO, (String)"\u8a3b\u518aXCA\u6191\u8b49\u6210\u529f", (Window)XMLUpload.this);
                        } else {
                            Alert.alert((MessageType)MessageType.INFO, (String)"\u8a3b\u518aXCA\u6191\u8b49\u5931\u6557", (Window)XMLUpload.this);
                        }
                    }

                    public void executeFailed(Task<Boolean> task) {
                        XMLUpload.this.activityIndicator.setActive(false);
                    }
                };
                task.execute((TaskListener)new TaskAdapter((TaskListener)tasklistener));
            }
        });
        this.btnViewRegXCA.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                XMLUpload.this.activityIndicator.setActive(true);
                QueryXCAInfoTask task = new QueryXCAInfoTask(XMLUpload.this.getUploadOutEduNo(), XMLUpload.this.getOut_school_name());
                TaskListener<String> tasklistener = new TaskListener<String>(){

                    public void taskExecuted(Task<String> task) {
                        String result = (String)task.getResult();
                        Alert.alert((MessageType)MessageType.INFO, (String)result, (Window)XMLUpload.this);
                        XMLUpload.this.activityIndicator.setActive(false);
                    }

                    public void executeFailed(Task<String> task) {
                        XMLUpload.this.activityIndicator.setActive(false);
                        Alert.alert((MessageType)MessageType.ERROR, (String)"\u7dda\u4e0a\u67e5\u8a62XCA\u6191\u8b49\u8cc7\u8a0a\u5931\u6557", (Window)XMLUpload.this);
                    }
                };
                task.execute((TaskListener)new TaskAdapter((TaskListener)tasklistener));
            }
        });
    }

    public String getCookie_sch_id() {
        return this.cookie_sch_id;
    }

    public void setCookie_sch_id(String cookie_sch_id) {
        this.cookie_sch_id = cookie_sch_id;
    }

    private void parseSchoolName() {
    }

    private String showCertInfo(org.apache.pivot.collections.Map<Integer, X509Certificate> certs) {
        StringBuilder sb = new StringBuilder();
        X509Certificate signcert = (X509Certificate)certs.get((Object)Token.ID_SIGN);
        sb.append("== \u7c3d\u7ae0XCA\u6191\u8b49 ==");
        sb.append("\u5e8f\u865f : " + signcert.getSerialNumber().toString(16).toUpperCase());
        sb.append("\u672c\u6191\u8b49\u578b\u5f0f : " + CertUtil.getSubjectType(signcert));
        sb.append("OCSP : " + CertUtil.getOCSP(signcert));
        sb.append("\u5168\u929c : " + signcert.getSubjectDN());
        String oid = CertUtil.getOrgOID(signcert);
        sb.append("\u7d44\u7e54OID : " + oid);
        sb.append(this.parseDN(signcert.getSubjectDN().getName()));
        X509Certificate cryptcert = (X509Certificate)certs.get((Object)Token.ID_ENCRYPT);
        if (logger.isDebugEnabled()) {
            try {
                String test = "This is a test!";
                X509Certificate x509 = CertFromWeb.getX509Certificate(cryptcert.getSerialNumber().toString(16).toUpperCase());
                byte[] enc = CryptoUtil.wrap(x509, test.getBytes());
                logger.info((Object)("\u4ee5\u7db2\u8def\u64f7\u53d6\u4e4bXCA\u6191\u8b49\u9032\u884c\u52a0\u5bc6 : " + Base64.encodeBase64String(enc)));
                logger.info((Object)("\u4ee5XCA\u89e3\u5bc6\u6e2c\u8a66 : " + AccessController.doPrivileged(new DecryptFromXCA(this.pinpass, Base64.encodeBase64String(enc)))));
                logger.info((Object)("\u539f\u59cbAES Key : " + this.getAeskey()));
                byte[] aesenc = CryptoUtil.wrap(x509, this.getAeskey().getBytes());
                logger.info((Object)("\u52a0\u5bc6\u5f8cAES Key : " + Base64.encodeBase64String(aesenc)));
                String aesdec = AccessController.doPrivileged(new DecryptFromXCA(this.pinpass, Base64.encodeBase64String(aesenc)));
                logger.info((Object)("\u4ee5XCA\u89e3\u5bc6\u5f8c\u7684AES Key : " + aesdec));
                logger.info((Object)("\u5b78\u751f\u59d3\u540d : " + this.getUploadEncStName() + " - \u89e3\u5bc6\u5f8c : " + AESUtil.decrypt(this.getUploadEncStName(), aesdec)));
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        sb.append("== XCA\u52a0\u89e3\u5bc6\u6191\u8b49 ==");
        sb.append("\r\n");
        sb.append("\u5e8f\u865f : " + cryptcert.getSerialNumber().toString(16).toUpperCase());
        sb.append("\r\n");
        sb.append("\u672c\u6191\u8b49\u578b\u5f0f : " + CertUtil.getSubjectType(cryptcert));
        sb.append("\r\n");
        sb.append("OCSP : " + CertUtil.getOCSP(cryptcert));
        sb.append("\r\n");
        sb.append("\u5168\u929c : " + cryptcert.getSubjectDN());
        sb.append("\r\n");
        oid = CertUtil.getOrgOID(cryptcert);
        sb.append("\u7d44\u7e54OID : " + oid);
        sb.append("\r\n");
        sb.append(this.parseDN(cryptcert.getSubjectDN().getName()));
        return sb.toString();
    }

    private String parseDN(String dn) {
        String[] dns = dn.split(",");
        String result = "";
        logger.debug((Object)("Original DN :\n" + dn));
        if (dns.length == 3) {
            String schoolname = dns[0];
            String city = dns[1];
            result = "\u5b78\u6821\u5168\u929c : " + schoolname.substring(schoolname.indexOf("=") + 1) + ";" + city.substring(city.indexOf("=") + 1) + ";" + schoolname.substring(schoolname.indexOf("\u9ad8\u7d1a"));
            int end = schoolname.indexOf("\u9ad8\u7d1a\u4e2d\u5b78");
            logger.debug((Object)("\u5b8c\u5168\u4e2d\u5b78:" + schoolname.indexOf(2, end - 2)));
        } else {
            String schoolname = dns[0];
            String district = dns[1];
            String city = dns[2];
            result = "\u5b78\u6821\u5168\u929c : " + schoolname.substring(schoolname.indexOf("=") + 1) + ";" + district.substring(district.indexOf("=") + 1) + ";" + city.substring(city.indexOf("=") + 1) + ";" + schoolname.substring(schoolname.indexOf("\u570b"));
        }
        logger.debug((Object)result);
        return result;
    }

    private String getCode(String item) {
        int prefix = item.indexOf("(");
        int postfix = item.indexOf(")");
        String result = item.substring(prefix + 1, postfix);
        return result;
    }

    private void checkCard() {
        this.activityIndicator.setActive(true);
        CheckCardTask task = new CheckCardTask();
        TaskListener<Integer> tasklistener = new TaskListener<Integer>(){

            public void taskExecuted(Task<Integer> task) {
                try {
                    int result = (Integer)task.execute();
                    switch (result) {
                        case 0: 
                        case 1: 
                        case 3: {
                            Alert.alert((MessageType)MessageType.ERROR, (String)"\u8b80\u5361\u6a5f\u8b80\u53d6\u932f\u8aa4\uff0c\u8acb\u78ba\u5b9a\u5df2\u63d2\u5165XCA\u5361\u7247", (Window)XMLUpload.this);
                            break;
                        }
                        case 2: {
                            XMLUpload.this.activityIndicator.setActive(false);
                            XMLUpload.this.tabPane.setEnabled(true);
                        }
                    }
                }
                catch (TaskExecutionException ex) {
                    logger.error((Object)ex);
                }
            }

            public void executeFailed(Task<Integer> task) {
                Alert.alert((MessageType)MessageType.ERROR, (String)"\u7121\u6cd5\u627e\u5230\u8b80\u5361\u6a5f", (Window)XMLUpload.this);
            }
        };
        task.execute((TaskListener)new TaskAdapter((TaskListener)tasklistener));
    }

    private static String doQueryXCASerial(String schoolid, String schoolname) {
        Xcaexchange_Service service = new Xcaexchange_Service();
        Xcaexchange port = service.getXcaexchangePort();
        return port.doQueryXCASerial(schoolid, schoolname);
    }

    private static int doUploadEncXML(String fromschoolid, String toschoolid, String encstname, String encstpid, String encstbirthday, String encaeskey, String encxml, String encsignxml, String toschoolxcasn) {
        Xcaexchange_Service service = new Xcaexchange_Service();
        Xcaexchange port = service.getXcaexchangePort();
        return port.doUploadEncXML(fromschoolid, toschoolid, encstname, encstpid, encstbirthday, encaeskey, encxml, encsignxml, toschoolxcasn);
    }

    private static String doQueryCryptCertSerial(String schoolid, String schoolname) {
        Xcaexchange_Service service = new Xcaexchange_Service();
        Xcaexchange port = service.getXcaexchangePort();
        return port.doQueryCryptCertSerial(schoolid, schoolname);
    }
}

