/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;

class PlayerPrims
extends Primitives {
    static Synthesizer midiSynth;
    static boolean midiSynthInitialized;
    static int[] sensorValues;
    static final String[] primlist;
    static final String[] primclasses;

    PlayerPrims() {
    }

    public String[] primlist() {
        return primlist;
    }

    public Object dispatch(int n, Object[] objectArray, LContext lContext) {
        switch (n) {
            case 0: {
                lContext.canvas.redraw_all();
                return null;
            }
            case 1: {
                lContext.canvas.redraw_invalid();
                return null;
            }
            case 2: {
                return this.prim_drawrect(objectArray[0], objectArray[1], objectArray[2], objectArray[3], lContext);
            }
            case 3: {
                return lContext.canvas.stage == null ? new Object[]{} : lContext.canvas.stage;
            }
            case 4: {
                return this.prim_setstage(objectArray[0], lContext);
            }
            case 5: {
                return lContext.canvas.sprites;
            }
            case 6: {
                lContext.canvas.sprites = (Object[])objectArray[0];
                return null;
            }
            case 7: {
                return this.prim_readprojfile(objectArray[0], lContext);
            }
            case 8: {
                return this.prim_readprojurl(lContext);
            }
            case 9: {
                return new Boolean(true);
            }
            case 10: {
                return new Boolean(objectArray[0] instanceof String || objectArray[0] instanceof Symbol);
            }
            case 11: {
                return new Boolean(objectArray[0] instanceof Sprite);
            }
            case 12: {
                return new Boolean(objectArray[0] instanceof Color);
            }
            case 13: {
                return new Double(lContext.canvas.mouseX);
            }
            case 14: {
                return new Double(lContext.canvas.mouseY);
            }
            case 15: {
                return new Boolean(lContext.canvas.mouseIsDown);
            }
            case 16: {
                return this.prim_mouseclick(lContext);
            }
            case 17: {
                return this.prim_keystroke(lContext);
            }
            case 18: {
                return this.prim_keydown(objectArray[0], lContext);
            }
            case 19: {
                lContext.canvas.clearkeys();
                return null;
            }
            case 20: {
                return this.prim_midisetinstrument(objectArray[0], objectArray[1], lContext);
            }
            case 21: {
                return this.prim_midinoteon(objectArray[0], objectArray[1], objectArray[2], lContext);
            }
            case 22: {
                return this.prim_midinoteoff(objectArray[0], objectArray[1], lContext);
            }
            case 23: {
                return this.prim_midicontrol(objectArray[0], objectArray[1], objectArray[2], lContext);
            }
            case 24: {
                lContext.canvas.updatePenTrails();
                return null;
            }
            case 25: {
                return new Double(lContext.canvas.soundLevel());
            }
            case 26: {
                return this.prim_jpegDecode(objectArray[0], lContext);
            }
            case 27: {
                return new Double(Runtime.getRuntime().totalMemory());
            }
            case 28: {
                return new Double(Runtime.getRuntime().freeMemory());
            }
            case 29: {
                Runtime.getRuntime().gc();
                return null;
            }
            case 30: {
                lContext.canvas.clearall(lContext);
                return null;
            }
            case 31: {
                lContext.canvas.requestFocus();
                return null;
            }
            case 32: {
                lContext.canvas.setMessage(Logo.aString(objectArray[0], lContext));
                return null;
            }
            case 33: {
                return this.prim_getSensorValue(objectArray[0], lContext);
            }
            case 34: {
                return new Boolean(lContext.autostart);
            }
            case 35: {
                return new Boolean(objectArray[0] instanceof QuotedSymbol);
            }
            case 36: {
                return ((QuotedSymbol)objectArray[0]).sym;
            }
        }
        return null;
    }

    static synchronized LContext startup(String string, String string2, Container container, boolean bl) {
        LContext lContext = new LContext();
        Logo.setupPrims(primclasses, lContext);
        lContext.codeBase = string;
        lContext.projectURL = string2;
        lContext.autostart = bl;
        PlayerCanvas playerCanvas = new PlayerCanvas();
        playerCanvas.lc = lContext;
        lContext.canvas = playerCanvas;
        Skin.readSkin(playerCanvas);
        SoundPlayer.startPlayer();
        container.add((Component)playerCanvas, "Center");
        LogoCommandRunner.startLogoThread("load \"startup startup", lContext);
        return lContext;
    }

    static synchronized void shutdown(LContext lContext) {
        if (lContext != null) {
            LogoCommandRunner.stopLogoThread(lContext);
            lContext.canvas.clearall(lContext);
        }
        SoundPlayer.stopSoundsForApplet(lContext);
        sensorValues = new int[16];
        for (int i = 3; i < 8; ++i) {
            PlayerPrims.sensorValues[i] = 1000;
        }
    }

    static void stopMIDINotes() {
        if (midiSynth == null) {
            return;
        }
        MidiChannel[] midiChannelArray = midiSynth.getChannels();
        for (int i = 0; i < midiChannelArray.length; ++i) {
            if (midiChannelArray[i] == null) continue;
            midiChannelArray[i].allNotesOff();
            midiChannelArray[i].programChange(0);
        }
    }

    Object prim_drawrect(Object object, Object object2, Object object3, Object object4, LContext lContext) {
        int n = Logo.anInt(object, lContext);
        int n2 = Logo.anInt(object2, lContext);
        int n3 = Logo.anInt(object3, lContext);
        int n4 = Logo.anInt(object4, lContext);
        lContext.canvas.drawRect(n, n2, n3, n4);
        return null;
    }

    Object prim_setstage(Object object, LContext lContext) {
        if (!(object instanceof Sprite)) {
            return null;
        }
        Sprite sprite = (Sprite)object;
        sprite.y = 0.0;
        sprite.x = 0.0;
        lContext.canvas.stage = sprite;
        return null;
    }

    Object prim_readprojfile(Object object, LContext lContext) {
        Object[][] objectArray;
        FileInputStream fileInputStream;
        Object[] objectArray2 = new Object[]{};
        lContext.canvas.startLoading();
        try {
            fileInputStream = new FileInputStream(object.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logo.error("File not found: " + object, lContext);
            return objectArray2;
        }
        lContext.canvas.loadingProgress(0.5);
        try {
            ObjReader objReader = new ObjReader(fileInputStream);
            objectArray = objReader.readObjects(lContext);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return objectArray2;
        }
        lContext.canvas.stopLoading();
        return objectArray;
    }

    Object prim_readprojurl(LContext lContext) {
        Object[][] objectArray;
        URL uRL;
        Object[] objectArray2 = new Object[]{};
        if (lContext.projectURL == null) {
            return objectArray2;
        }
        try {
            uRL = new URL(lContext.projectURL);
        }
        catch (MalformedURLException malformedURLException) {
            Logo.error("Bad project URL: " + lContext.projectURL, lContext);
            return objectArray2;
        }
        try {
            lContext.canvas.startLoading();
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.connect();
            int n = uRLConnection.getContentLength();
            byte[] byArray = new byte[n];
            InputStream inputStream = uRLConnection.getInputStream();
            int n2 = 0;
            int n3 = 0;
            while (n2 >= 0 && n3 < n) {
                n2 = inputStream.read(byArray, n3, n - n3);
                if (n2 > 0) {
                    lContext.canvas.loadingProgress((double)(n3 += n2) / (double)n);
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            inputStream.close();
            ObjReader objReader = new ObjReader(new ByteArrayInputStream(byArray));
            objectArray = objReader.readObjects(lContext);
        }
        catch (IOException iOException) {
            Logo.error("Problem reading project from URL: " + lContext.projectURL, lContext);
            return objectArray2;
        }
        lContext.canvas.stopLoading();
        return objectArray;
    }

    Object prim_mouseclick(LContext lContext) {
        if (lContext.canvas.mouseclicks.isEmpty()) {
            return new Object[0];
        }
        return lContext.canvas.mouseclicks.remove(0);
    }

    Object prim_keystroke(LContext lContext) {
        if (lContext.canvas.keystrokes.isEmpty()) {
            return new Object[0];
        }
        return lContext.canvas.keystrokes.remove(0);
    }

    Object prim_keydown(Object object, LContext lContext) {
        int n = Logo.anInt(object, lContext);
        if (n > 255) {
            return new Boolean(false);
        }
        return new Boolean(lContext.canvas.keydown[n]);
    }

    Object prim_midisetinstrument(Object object, Object object2, LContext lContext) {
        this.init_midi(lContext);
        if (midiSynth == null) {
            return null;
        }
        int n = Logo.anInt(object, lContext) - 1 & 0xF;
        int n2 = Logo.anInt(object2, lContext) - 1 & 0x7F;
        midiSynth.getChannels()[n].programChange(n2);
        return null;
    }

    Object prim_midinoteon(Object object, Object object2, Object object3, LContext lContext) {
        this.init_midi(lContext);
        if (midiSynth == null) {
            return null;
        }
        int n = Logo.anInt(object, lContext) - 1 & 0xF;
        int n2 = Logo.anInt(object2, lContext) & 0x7F;
        int n3 = Logo.anInt(object3, lContext) & 0x7F;
        midiSynth.getChannels()[n].noteOn(n2, n3);
        return null;
    }

    Object prim_midinoteoff(Object object, Object object2, LContext lContext) {
        this.init_midi(lContext);
        if (midiSynth == null) {
            return null;
        }
        int n = Logo.anInt(object, lContext) - 1 & 0xF;
        int n2 = Logo.anInt(object2, lContext) & 0x7F;
        midiSynth.getChannels()[n].noteOff(n2);
        return null;
    }

    Object prim_midicontrol(Object object, Object object2, Object object3, LContext lContext) {
        this.init_midi(lContext);
        if (midiSynth == null) {
            return null;
        }
        int n = Logo.anInt(object, lContext) - 1 & 0xF;
        int n2 = Logo.anInt(object2, lContext) & 0x7F;
        int n3 = Logo.anInt(object3, lContext) & 0x7F;
        midiSynth.getChannels()[n].controlChange(n2, n3);
        return null;
    }

    void init_midi(LContext lContext) {
        Object object;
        if (midiSynthInitialized) {
            return;
        }
        midiSynthInitialized = true;
        try {
            midiSynth = MidiSystem.getSynthesizer();
            midiSynth.open();
            if (midiSynth.getDefaultSoundbank() == null) {
                lContext.canvas.setMessage("Reading sound bank from server. Please wait...");
                object = new URL(lContext.codeBase + "soundbank.gm");
                Soundbank soundbank = MidiSystem.getSoundbank((URL)object);
                if (soundbank != null) {
                    midiSynth.loadAllInstruments(soundbank);
                    lContext.canvas.setMessage("");
                } else {
                    midiSynth.close();
                    midiSynth = null;
                }
            }
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
            midiSynth = null;
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            midiSynth = null;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            midiSynth = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            midiSynth = null;
        }
        catch (AccessControlException accessControlException) {
            accessControlException.printStackTrace();
            midiSynth = null;
        }
        if (midiSynth != null) {
            object = midiSynth.getChannels();
            for (int i = 0; i < ((MidiChannel[])object).length; ++i) {
                if (object[i] == null) continue;
                object[i].programChange(0);
            }
        } else {
            lContext.canvas.setMessage("No soundbank; note & drum commands disabled.");
        }
    }

    Object prim_jpegDecode(Object object, LContext lContext) {
        if (!(object instanceof byte[])) {
            return null;
        }
        byte[] byArray = (byte[])object;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage(byArray);
        MediaTracker mediaTracker = new MediaTracker(lContext.canvas);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (image == null) {
            return null;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, n, n2, null);
        graphics.dispose();
        return bufferedImage;
    }

    Object prim_getSensorValue(Object object, LContext lContext) {
        int n = Logo.anInt(object, lContext) - 1;
        if (n < 0 || n > 15) {
            return new Double(123.0);
        }
        return new Double((double)sensorValues[n] / 10.0);
    }

    static {
        midiSynthInitialized = false;
        sensorValues = new int[]{0, 0, 0, 1000, 1000, 1000, 1000, 1000, 0, 0, 0, 0, 0, 0, 0, 0};
        primlist = new String[]{"redrawall", "0", "redraw", "0", "drawrect", "4", "stage", "0", "setstage", "1", "sprites", "0", "setsprites", "1", "readprojfile", "1", "readprojurl", "0", "applet?", "0", "string?", "1", "sprite?", "1", "color?", "1", "mouseX", "0", "mouseY", "0", "mouseIsDown", "0", "mouseClick", "0", "keystroke", "0", "keydown?", "1", "clearkeys", "0", "midisetinstrument", "2", "midinoteon", "3", "midinoteoff", "2", "midicontrol", "3", "updatePenTrails", "0", "soundLevel", "0", "jpegDecode", "1", "memTotal", "0", "memFree", "0", "gc", "0", "clearall", "0", "requestFocus", "0", "setMessage", "1", "getSensorValue", "1", "autostart?", "0", "quoted?", "1", "unquote", "1"};
        primclasses = new String[]{"SystemPrims", "MathPrims", "ControlPrims", "DefiningPrims", "WordListPrims", "FilePrims", "PlayerPrims", "SpritePrims"};
    }
}

