/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.json.JSON;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.CalendarDate;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.Resources;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonGroup;
import org.apache.pivot.wtk.ButtonGroupListener;
import org.apache.pivot.wtk.Calendar;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Spinner;
import org.apache.pivot.wtk.SpinnerSelectionListener;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.content.ButtonDataRenderer;
import org.apache.pivot.wtk.content.NumericSpinnerData;
import org.apache.pivot.wtk.content.SpinnerItemRenderer;
import org.apache.pivot.wtk.skin.ButtonSkin;
import org.apache.pivot.wtk.skin.CalendarSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraCalendarSkin
extends CalendarSkin {
    private TablePane calendarTablePane;
    private Spinner monthSpinner;
    private Spinner yearSpinner;
    private DateButton[][] dateButtons = new DateButton[6][7];
    private ButtonGroup dateButtonGroup;
    private Button.DataRenderer dateButtonDataRenderer = new DateButtonDataRenderer();
    private int weekdayCharacterIndex;
    private CalendarDate today = null;
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color selectionColor;
    private Color selectionBackgroundColor;
    private Color highlightColor;
    private Color highlightBackgroundColor;
    private Color dividerColor;
    private int padding = 4;
    private Color selectionBevelColor;

    public TerraCalendarSkin() {
        Resources resources;
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.font = theme.getFont();
        this.color = theme.getColor(1);
        this.disabledColor = theme.getColor(7);
        this.selectionColor = theme.getColor(4);
        this.selectionBackgroundColor = theme.getColor(14);
        this.highlightColor = theme.getColor(1);
        this.highlightBackgroundColor = theme.getColor(10);
        this.dividerColor = theme.getColor(9);
        this.selectionBevelColor = TerraTheme.brighten(this.selectionBackgroundColor);
        this.calendarTablePane = new TablePane();
        for (int i = 0; i < 7; ++i) {
            this.calendarTablePane.getColumns().add(new TablePane.Column(1, true));
        }
        this.monthSpinner = new Spinner();
        this.monthSpinner.setSpinnerData((List)new NumericSpinnerData(0, 11));
        this.monthSpinner.setItemRenderer((Spinner.ItemRenderer)new MonthSpinnerItemRenderer());
        this.monthSpinner.setCircular(true);
        this.monthSpinner.getStyles().put("sizeToContent", (Object)true);
        this.monthSpinner.getSpinnerSelectionListeners().add((Object)new SpinnerSelectionListener.Adapter(){

            public void selectedItemChanged(Spinner spinner, Object previousSelectedItem) {
                Calendar calendar = (Calendar)TerraCalendarSkin.this.getComponent();
                calendar.setMonth(((Integer)spinner.getSelectedItem()).intValue());
            }
        });
        this.yearSpinner = new Spinner();
        this.yearSpinner.setSpinnerData((List)new NumericSpinnerData(0, Short.MAX_VALUE));
        this.yearSpinner.getSpinnerSelectionListeners().add((Object)new SpinnerSelectionListener.Adapter(){

            public void selectedItemChanged(Spinner spinner, Object previousSelectedItem) {
                Calendar calendar = (Calendar)TerraCalendarSkin.this.getComponent();
                calendar.setYear(((Integer)spinner.getSelectedItem()).intValue());
            }
        });
        ComponentMouseButtonListener.Adapter spinnerMouseButtonListener = new ComponentMouseButtonListener.Adapter(){

            public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
                return true;
            }
        };
        this.monthSpinner.getComponentMouseButtonListeners().add((Object)spinnerMouseButtonListener);
        this.yearSpinner.getComponentMouseButtonListeners().add((Object)spinnerMouseButtonListener);
        TablePane monthYearTablePane = new TablePane();
        monthYearTablePane.getStyles().put("padding", (Object)3);
        monthYearTablePane.getStyles().put("horizontalSpacing", (Object)4);
        monthYearTablePane.getColumns().add(new TablePane.Column(1, true));
        monthYearTablePane.getColumns().add(new TablePane.Column(-1));
        TablePane.Row monthYearRow = new TablePane.Row(-1);
        monthYearTablePane.getRows().add(monthYearRow);
        monthYearRow.add((Component)this.monthSpinner);
        monthYearRow.add((Component)this.yearSpinner);
        TablePane.Row calendarRow = new TablePane.Row();
        calendarRow.add((Component)monthYearTablePane);
        this.calendarTablePane.getRows().add(calendarRow);
        TablePane.setColumnSpan((Component)monthYearTablePane, (int)7);
        calendarRow = new TablePane.Row();
        Font labelFont = theme.getFont();
        labelFont = labelFont.deriveFont(1);
        for (int i = 0; i < 7; ++i) {
            Label label = new Label();
            label.getStyles().put("font", (Object)labelFont);
            label.getStyles().put("padding", (Object)new Insets(2, 2, 4, 2));
            label.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.CENTER);
            calendarRow.add((Component)label);
        }
        this.calendarTablePane.getRows().add(calendarRow);
        this.dateButtonGroup = new ButtonGroup();
        this.dateButtonGroup.getButtonGroupListeners().add((Object)new ButtonGroupListener.Adapter(){

            public void selectionChanged(ButtonGroup buttonGroup, Button previousSelection) {
                Calendar calendar = (Calendar)TerraCalendarSkin.this.getComponent();
                Button selection = buttonGroup.getSelection();
                if (selection == null) {
                    CalendarDate selectedDate = calendar.getSelectedDate();
                    if (selectedDate == null || selectedDate.year == TerraCalendarSkin.this.yearSpinner.getSelectedIndex() && selectedDate.month == TerraCalendarSkin.this.monthSpinner.getSelectedIndex()) {
                        calendar.setSelectedDate((CalendarDate)null);
                    }
                } else {
                    calendar.setSelectedDate((CalendarDate)selection.getButtonData());
                }
            }
        });
        for (int j = 0; j < 6; ++j) {
            calendarRow = new TablePane.Row(1, true);
            for (int i = 0; i < 7; ++i) {
                DateButton dateButton;
                this.dateButtons[j][i] = dateButton = new DateButton();
                dateButton.setButtonGroup(this.dateButtonGroup);
                calendarRow.add((Component)dateButton);
            }
            this.calendarTablePane.getRows().add(calendarRow);
        }
        try {
            resources = new Resources(TerraCalendarSkin.class.getName());
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        catch (SerializationException exception) {
            throw new RuntimeException(exception);
        }
        this.weekdayCharacterIndex = JSON.getInt((Object)resources, (String)"weekdayCharacterIndex");
    }

    public void install(Component component) {
        super.install(component);
        Calendar calendar = (Calendar)component;
        calendar.add((Component)this.calendarTablePane);
        this.yearSpinner.setSelectedIndex(calendar.getYear());
        this.monthSpinner.setSelectedIndex(calendar.getMonth());
        this.updateLabels();
        this.updateCalendar();
    }

    public int getPreferredWidth(int height) {
        return this.calendarTablePane.getPreferredWidth(height);
    }

    public int getPreferredHeight(int width) {
        return this.calendarTablePane.getPreferredHeight(width);
    }

    public Dimensions getPreferredSize() {
        return this.calendarTablePane.getPreferredSize();
    }

    public int getBaseline(int width, int height) {
        return this.calendarTablePane.getBaseline(width, height);
    }

    public void layout() {
        this.calendarTablePane.setSize(this.getWidth(), this.getHeight());
        this.calendarTablePane.setLocation(0, 0);
    }

    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        int width = this.getWidth();
        Bounds monthYearRowBounds = this.calendarTablePane.getRowBounds(0);
        graphics.setColor(this.highlightBackgroundColor);
        graphics.fillRect(monthYearRowBounds.x, monthYearRowBounds.y, monthYearRowBounds.width, monthYearRowBounds.height);
        Bounds labelRowBounds = this.calendarTablePane.getRowBounds(1);
        graphics.setColor(this.dividerColor);
        int dividerY = labelRowBounds.y + labelRowBounds.height - 2;
        GraphicsUtilities.drawLine((Graphics2D)graphics, (int)2, (int)dividerY, (int)Math.max(0, width - 4), (Orientation)Orientation.HORIZONTAL);
    }

    private void updateLabels() {
        TablePane.Row row = this.calendarTablePane.getRows().get(1);
        Calendar calendar = (Calendar)this.getComponent();
        Locale locale = calendar.getLocale();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        SimpleDateFormat monthFormat = new SimpleDateFormat("E", locale);
        int firstDayOfWeek = gregorianCalendar.getFirstDayOfWeek();
        for (int i = 0; i < 7; ++i) {
            Label label = (Label)row.get(i);
            gregorianCalendar.set(7, firstDayOfWeek + i);
            String text = monthFormat.format(gregorianCalendar.getTime());
            text = Character.toString(text.charAt(this.weekdayCharacterIndex));
            label.setText(text);
        }
    }

    private void updateCalendar() {
        Calendar calendar = (Calendar)this.getComponent();
        int month = calendar.getMonth();
        int year = calendar.getYear();
        Filter disabledDateFilter = calendar.getDisabledDateFilter();
        this.monthSpinner.setSelectedIndex(month);
        this.yearSpinner.setSelectedIndex(year);
        Locale locale = calendar.getLocale();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        gregorianCalendar.set(year, month, 1);
        int firstIndex = (7 + gregorianCalendar.get(7) - gregorianCalendar.getFirstDayOfWeek()) % 7;
        int lastIndex = firstIndex + gregorianCalendar.getActualMaximum(5);
        gregorianCalendar.add(2, -1);
        int daysLastMonth = gregorianCalendar.getActualMaximum(5);
        for (int j = 0; j < 6; ++j) {
            for (int i = 0; i < 7; ++i) {
                int day;
                month = calendar.getMonth();
                year = calendar.getYear();
                int k = j * 7 + i;
                DateButton dateButton = this.dateButtons[j][i];
                boolean enabled = false;
                if (k < firstIndex) {
                    if (--month < 0) {
                        month = 11;
                        --year;
                    }
                    day = daysLastMonth - (firstIndex - k);
                } else if (k >= lastIndex) {
                    if (++month > 11) {
                        month = 0;
                        ++year;
                    }
                    day = k - lastIndex;
                } else {
                    day = k - firstIndex;
                    enabled = true;
                }
                CalendarDate buttonData = new CalendarDate(year, month, day);
                dateButton.setButtonData(buttonData);
                dateButton.setEnabled(enabled && (disabledDateFilter == null || !disabledDateFilter.include((Object)buttonData)));
            }
        }
        CalendarDate lastWeekStartDate = (CalendarDate)this.dateButtons[5][0].getButtonData();
        boolean visible = lastWeekStartDate.month == calendar.getMonth();
        for (Component component : this.calendarTablePane.getRows().get(7)) {
            component.setVisible(visible);
        }
        this.today = new CalendarDate();
        this.updateSelection(calendar.getSelectedDate());
    }

    private void updateSelection(CalendarDate selectedDate) {
        Calendar calendar = (Calendar)this.getComponent();
        Button selection = this.dateButtonGroup.getSelection();
        if (selectedDate == null) {
            if (selection != null) {
                selection.setSelected(false);
            }
        } else {
            int year = selectedDate.year;
            int month = selectedDate.month;
            if (year == calendar.getYear() && month == calendar.getMonth()) {
                int day = selectedDate.day;
                int cellIndex = TerraCalendarSkin.getCellIndex(year, month, day, calendar.getLocale());
                int rowIndex = cellIndex / 7;
                int columnIndex = cellIndex % 7;
                TablePane.Row row = this.calendarTablePane.getRows().get(rowIndex + 2);
                DateButton dateButton = (DateButton)row.get(columnIndex);
                dateButton.setSelected(true);
            } else if (selection != null) {
                selection.setSelected(false);
            }
        }
    }

    private static int getCellIndex(int year, int month, int day, Locale locale) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        gregorianCalendar.set(year, month, 1);
        int firstDay = (gregorianCalendar.get(7) - gregorianCalendar.getFirstDayOfWeek() + 7) % 7;
        int cellIndex = firstDay + day;
        return cellIndex;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.monthSpinner.getStyles().put("font", (Object)font);
        this.yearSpinner.getStyles().put("font", (Object)font);
        TablePane.Row row = this.calendarTablePane.getRows().get(1);
        for (int i = 0; i < 7; ++i) {
            Label label = (Label)row.get(i);
            label.getStyles().put("font", (Object)font);
        }
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraCalendarSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public final void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        if (selectionColor == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.selectionColor = selectionColor;
        this.repaintComponent();
    }

    public final void setSelectionColor(String selectionColor) {
        if (selectionColor == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.setSelectionColor(GraphicsUtilities.decodeColor((String)selectionColor));
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color selectionBackgroundColor) {
        if (selectionBackgroundColor == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.selectionBackgroundColor = selectionBackgroundColor;
        this.selectionBevelColor = TerraTheme.brighten(selectionBackgroundColor);
        this.repaintComponent();
    }

    public final void setSelectionBackgroundColor(String selectionBackgroundColor) {
        if (selectionBackgroundColor == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.setSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)selectionBackgroundColor));
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        if (highlightColor == null) {
            throw new IllegalArgumentException("highlightColor is null.");
        }
        this.highlightColor = highlightColor;
        this.repaintComponent();
    }

    public final void setHighlightColor(String highlightColor) {
        if (highlightColor == null) {
            throw new IllegalArgumentException("highlightColor is null.");
        }
        this.setHighlightColor(GraphicsUtilities.decodeColor((String)highlightColor));
    }

    public Color getHighlightBackgroundColor() {
        return this.highlightBackgroundColor;
    }

    public void setHighlightBackgroundColor(Color highlightBackgroundColor) {
        if (highlightBackgroundColor == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.highlightBackgroundColor = highlightBackgroundColor;
        this.repaintComponent();
    }

    public final void setHighlightBackgroundColor(String highlightBackgroundColor) {
        if (highlightBackgroundColor == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.setHighlightBackgroundColor(GraphicsUtilities.decodeColor((String)highlightBackgroundColor));
    }

    public Color getDividerColor() {
        return this.dividerColor;
    }

    public void setDividerColor(Color dividerColor) {
        if (dividerColor == null) {
            throw new IllegalArgumentException("dividerColor is null.");
        }
        this.dividerColor = dividerColor;
        this.repaintComponent();
    }

    public final void setDividerColor(String dividerColor) {
        if (dividerColor == null) {
            throw new IllegalArgumentException("dividerColor is null.");
        }
        this.setDividerColor(GraphicsUtilities.decodeColor((String)dividerColor));
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        if (padding < 0) {
            throw new IllegalArgumentException("padding is negative.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public void yearChanged(Calendar calendar, int previousYear) {
        this.yearSpinner.setSelectedIndex(calendar.getYear());
        this.updateCalendar();
    }

    public void monthChanged(Calendar calendar, int previousMonth) {
        this.monthSpinner.setSelectedIndex(calendar.getMonth());
        this.updateCalendar();
    }

    public void localeChanged(Calendar calendar, Locale previousLocale) {
        this.invalidateComponent();
        this.updateLabels();
        this.updateCalendar();
    }

    public void disabledDateFilterChanged(Calendar calendar, Filter<CalendarDate> previousDisabledDateFilter) {
        this.updateCalendar();
    }

    public void selectedDateChanged(Calendar calendar, CalendarDate previousSelectedDate) {
        this.updateSelection(calendar.getSelectedDate());
    }

    private static class DateButtonDataRenderer
    extends ButtonDataRenderer {
        private DateButtonDataRenderer() {
        }

        public void render(Object data, Button button, boolean highlighted) {
            CalendarDate date = (CalendarDate)data;
            super.render((Object)(date.day + 1), button, highlighted);
            if (button.isSelected()) {
                this.label.getStyles().put("color", button.getStyles().get("selectionColor"));
            }
        }
    }

    public class MonthSpinnerItemRenderer
    extends SpinnerItemRenderer {
        public void render(Object item, Spinner spinner) {
            Calendar calendar = (Calendar)TerraCalendarSkin.this.getComponent();
            CalendarDate date = new CalendarDate(2000, ((Integer)item).intValue(), 0);
            SimpleDateFormat monthFormat = new SimpleDateFormat("MMMM", calendar.getLocale());
            String itemFromFormat = monthFormat.format(date.toCalendar().getTime());
            super.render((Object)itemFromFormat, spinner);
        }
    }

    public class DateButtonSkin
    extends ButtonSkin {
        public void install(Component component) {
            super.install(component);
            component.setCursor(Cursor.DEFAULT);
        }

        public int getPreferredWidth(int height) {
            DateButton dateButton = (DateButton)this.getComponent();
            int preferredWidth = 0;
            Button.DataRenderer dataRenderer = dateButton.getDataRenderer();
            dataRenderer.render(dateButton.getButtonData(), (Button)dateButton, false);
            preferredWidth = dataRenderer.getPreferredWidth(height) + TerraCalendarSkin.this.padding * 2;
            return preferredWidth;
        }

        public int getPreferredHeight(int width) {
            int preferredHeight = 0;
            DateButton dateButton = (DateButton)this.getComponent();
            Button.DataRenderer dataRenderer = dateButton.getDataRenderer();
            dataRenderer.render(dateButton.getButtonData(), (Button)dateButton, false);
            preferredHeight = dataRenderer.getPreferredHeight(width) + TerraCalendarSkin.this.padding * 2;
            return preferredHeight;
        }

        public Dimensions getPreferredSize() {
            DateButton dateButton = (DateButton)this.getComponent();
            Button.DataRenderer dataRenderer = dateButton.getDataRenderer();
            dataRenderer.render(dateButton.getButtonData(), (Button)dateButton, false);
            Dimensions preferredSize = dataRenderer.getPreferredSize();
            return new Dimensions(preferredSize.width + TerraCalendarSkin.this.padding * 2, preferredSize.height + TerraCalendarSkin.this.padding * 2);
        }

        public void paint(Graphics2D graphics) {
            DateButton dateButton = (DateButton)this.getComponent();
            int width = this.getWidth();
            int height = this.getHeight();
            if (dateButton.isSelected()) {
                graphics.setPaint(new GradientPaint((float)width / 2.0f, 0.0f, TerraCalendarSkin.this.selectionBevelColor, (float)width / 2.0f, height, TerraCalendarSkin.this.selectionBackgroundColor));
                graphics.fillRect(0, 0, width, height);
            } else if (this.highlighted) {
                graphics.setColor(TerraCalendarSkin.this.highlightBackgroundColor);
                graphics.fillRect(0, 0, width, height);
            }
            CalendarDate date = (CalendarDate)dateButton.getButtonData();
            if (date.equals((Object)TerraCalendarSkin.this.today)) {
                graphics.setColor(TerraCalendarSkin.this.dividerColor);
                GraphicsUtilities.drawRect((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height);
            }
            Button.DataRenderer dataRenderer = dateButton.getDataRenderer();
            dataRenderer.render((Object)date, (Button)dateButton, this.highlighted);
            dataRenderer.setSize(Math.max(width - TerraCalendarSkin.this.padding * 2, 0), Math.max(height - TerraCalendarSkin.this.padding * 2, 0));
            graphics.translate(TerraCalendarSkin.this.padding, TerraCalendarSkin.this.padding);
            dataRenderer.paint(graphics);
        }

        public Font getFont() {
            return TerraCalendarSkin.this.font;
        }

        public Color getColor() {
            return TerraCalendarSkin.this.color;
        }

        public Color getDisabledColor() {
            return TerraCalendarSkin.this.disabledColor;
        }

        public Color getSelectionColor() {
            return TerraCalendarSkin.this.selectionColor;
        }

        public void focusedChanged(Component component, Component obverseComponent) {
            this.highlighted = component.isFocused();
            super.focusedChanged(component, obverseComponent);
        }

        public void mouseOver(Component component) {
            super.mouseOver(component);
            Calendar calendar = (Calendar)TerraCalendarSkin.this.getComponent();
            if (calendar.containsFocus()) {
                component.requestFocus();
            }
        }

        public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
            boolean consumed = super.mouseClick(component, button, x, y, count);
            DateButton dateButton = (DateButton)this.getComponent();
            dateButton.requestFocus();
            dateButton.press();
            return consumed;
        }

        public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            boolean consumed = false;
            DateButton dateButton = (DateButton)this.getComponent();
            if (keyCode == 10) {
                dateButton.press();
            } else if (keyCode == 38 || keyCode == 40 || keyCode == 37 || keyCode == 39) {
                CalendarDate date = (CalendarDate)dateButton.getButtonData();
                Calendar calendar = (Calendar)TerraCalendarSkin.this.getComponent();
                int cellIndex = TerraCalendarSkin.getCellIndex(date.year, date.month, date.day, calendar.getLocale());
                int rowIndex = cellIndex / 7;
                int columnIndex = cellIndex % 7;
                switch (keyCode) {
                    case 38: {
                        TablePane.Row row;
                        Component nextButton;
                        do {
                            if (--rowIndex >= 0) continue;
                            rowIndex = 5;
                        } while (!(nextButton = (row = TerraCalendarSkin.this.calendarTablePane.getRows().get(rowIndex + 2)).get(columnIndex)).isEnabled());
                        nextButton.requestFocus();
                        break;
                    }
                    case 40: {
                        TablePane.Row row;
                        Component nextButton;
                        do {
                            if (++rowIndex <= 5) continue;
                            rowIndex = 0;
                        } while (!(nextButton = (row = TerraCalendarSkin.this.calendarTablePane.getRows().get(rowIndex + 2)).get(columnIndex)).isEnabled());
                        nextButton.requestFocus();
                        break;
                    }
                    case 37: {
                        Component nextButton;
                        TablePane.Row row = TerraCalendarSkin.this.calendarTablePane.getRows().get(rowIndex + 2);
                        do {
                            if (--columnIndex >= 0) continue;
                            columnIndex = 6;
                        } while (!(nextButton = row.get(columnIndex)).isEnabled());
                        nextButton.requestFocus();
                        break;
                    }
                    case 39: {
                        Component nextButton;
                        TablePane.Row row = TerraCalendarSkin.this.calendarTablePane.getRows().get(rowIndex + 2);
                        do {
                            if (++columnIndex <= 6) continue;
                            columnIndex = 0;
                        } while (!(nextButton = row.get(columnIndex)).isEnabled());
                        nextButton.requestFocus();
                        break;
                    }
                }
                consumed = true;
            } else {
                consumed = super.keyPressed(component, keyCode, keyLocation);
            }
            return consumed;
        }

        public boolean keyReleased(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            boolean consumed = false;
            DateButton dateButton = (DateButton)this.getComponent();
            if (keyCode == 32) {
                dateButton.press();
                consumed = true;
            } else {
                consumed = super.keyReleased(component, keyCode, keyLocation);
            }
            return consumed;
        }
    }

    public class DateButton
    extends Button {
        public DateButton() {
            super(null);
            super.setToggleButton(true);
            this.setDataRenderer(TerraCalendarSkin.this.dateButtonDataRenderer);
            this.setSkin((Skin)new DateButtonSkin());
        }

        public void press() {
            this.setSelected(true);
            super.press();
        }

        public void setToggleButton(boolean toggleButton) {
            throw new UnsupportedOperationException();
        }

        public void setTriState(boolean triState) {
            throw new UnsupportedOperationException();
        }
    }
}

