/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.io.File;
import java.io.IOException;
import org.apache.pivot.beans.BXML;
import org.apache.pivot.beans.BXMLSerializer;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableList;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.FileBrowser;
import org.apache.pivot.wtk.FileBrowserListener;
import org.apache.pivot.wtk.FileBrowserSheet;
import org.apache.pivot.wtk.FileBrowserSheetListener;
import org.apache.pivot.wtk.Form;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.Sheet;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.TextInputContentListener;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.terra.TerraSheetSkin;

public class TerraFileBrowserSheetSkin
extends TerraSheetSkin
implements FileBrowserSheetListener {
    @BXML
    private TablePane tablePane = null;
    @BXML
    private BoxPane saveAsBoxPane = null;
    @BXML
    private TextInput saveAsTextInput = null;
    @BXML
    private FileBrowser fileBrowser = null;
    @BXML
    private PushButton okButton = null;
    @BXML
    private PushButton cancelButton = null;
    private boolean updatingSelection = false;
    private int selectedDirectoryCount = 0;

    public TerraFileBrowserSheetSkin() {
        this.setResizable(true);
    }

    @Override
    public void install(Component component) {
        Component content;
        super.install(component);
        final FileBrowserSheet fileBrowserSheet = (FileBrowserSheet)component;
        fileBrowserSheet.setMinimumWidth(360);
        fileBrowserSheet.setMinimumHeight(180);
        BXMLSerializer bxmlSerializer = new BXMLSerializer();
        try {
            content = (Component)bxmlSerializer.readObject(TerraFileBrowserSheetSkin.class, "terra_file_browser_sheet_skin.bxml", true);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        catch (SerializationException exception) {
            throw new RuntimeException(exception);
        }
        fileBrowserSheet.setContent(content);
        bxmlSerializer.bind((Object)this, TerraFileBrowserSheetSkin.class);
        this.fileBrowser.setRootDirectory(fileBrowserSheet.getRootDirectory());
        this.saveAsTextInput.getTextInputContentListeners().add((Object)new TextInputContentListener.Adapter(){

            public void textChanged(TextInput textInput) {
                Form.clearFlag((Component)TerraFileBrowserSheetSkin.this.saveAsBoxPane);
                TerraFileBrowserSheetSkin.this.updateOKButtonState();
            }
        });
        this.fileBrowser.getFileBrowserListeners().add((Object)new FileBrowserListener.Adapter(){

            public void rootDirectoryChanged(FileBrowser fileBrowserArgument, File previousRootDirectory) {
                TerraFileBrowserSheetSkin.this.updatingSelection = true;
                fileBrowserSheet.setRootDirectory(fileBrowserArgument.getRootDirectory());
                TerraFileBrowserSheetSkin.this.updatingSelection = false;
                TerraFileBrowserSheetSkin.this.selectedDirectoryCount = 0;
                TerraFileBrowserSheetSkin.this.updateOKButtonState();
            }

            public void selectedFileAdded(FileBrowser fileBrowserArgument, File file) {
                if (file.isDirectory()) {
                    TerraFileBrowserSheetSkin.this.selectedDirectoryCount++;
                }
                TerraFileBrowserSheetSkin.this.updateOKButtonState();
            }

            public void selectedFileRemoved(FileBrowser fileBrowserArgument, File file) {
                if (file.isDirectory()) {
                    TerraFileBrowserSheetSkin.this.selectedDirectoryCount--;
                }
                TerraFileBrowserSheetSkin.this.updateOKButtonState();
            }

            public void selectedFilesChanged(FileBrowser fileBrowserArgument, Sequence<File> previousSelectedFiles) {
                File selectedFile;
                TerraFileBrowserSheetSkin.this.selectedDirectoryCount = 0;
                ImmutableList selectedFiles = fileBrowserArgument.getSelectedFiles();
                int n = selectedFiles.getLength();
                for (int i = 0; i < n; ++i) {
                    File selectedFile2 = (File)selectedFiles.get(i);
                    if (!selectedFile2.isDirectory()) continue;
                    TerraFileBrowserSheetSkin.this.selectedDirectoryCount++;
                }
                if (!fileBrowserArgument.isMultiSelect() && (selectedFile = fileBrowserArgument.getSelectedFile()) != null && !selectedFile.isDirectory()) {
                    TerraFileBrowserSheetSkin.this.saveAsTextInput.setText(selectedFile.getName());
                }
                TerraFileBrowserSheetSkin.this.updateOKButtonState();
            }
        });
        this.fileBrowser.getComponentMouseButtonListeners().add((Object)new ComponentMouseButtonListener.Adapter(){
            private File file = null;

            public boolean mouseClick(Component componentArgument, Mouse.Button button, int x, int y, int count) {
                File fileLocal;
                boolean consumed = super.mouseClick(componentArgument, button, x, y, count);
                FileBrowserSheet.Mode mode = fileBrowserSheet.getMode();
                if (count == 1) {
                    this.file = TerraFileBrowserSheetSkin.this.fileBrowser.getFileAt(x, y);
                } else if (count == 2 && (fileLocal = TerraFileBrowserSheetSkin.this.fileBrowser.getFileAt(x, y)) != null && this.file != null && fileLocal.equals(this.file) && TerraFileBrowserSheetSkin.this.fileBrowser.isFileSelected(fileLocal) && (mode == FileBrowserSheet.Mode.OPEN || mode == FileBrowserSheet.Mode.OPEN_MULTIPLE) && !fileLocal.isDirectory()) {
                    fileBrowserSheet.close(true);
                    consumed = true;
                }
                return consumed;
            }
        });
        this.okButton.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                fileBrowserSheet.close(true);
            }
        });
        this.cancelButton.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                fileBrowserSheet.close(false);
            }
        });
        fileBrowserSheet.getFileBrowserSheetListeners().add((Object)this);
        this.modeChanged(fileBrowserSheet, null);
        this.rootDirectoryChanged(fileBrowserSheet, null);
        this.selectedFilesChanged(fileBrowserSheet, null);
    }

    public boolean isHideDisabledFiles() {
        return (Boolean)this.fileBrowser.getStyles().get("hideDisabledFiles");
    }

    public void setHideDisabledFiles(boolean hideDisabledFiles) {
        this.fileBrowser.getStyles().put("hideDisabledFiles", (Object)hideDisabledFiles);
    }

    public boolean getShowOKButtonFirst() {
        Container parent = this.okButton.getParent();
        return parent.indexOf((Component)this.okButton) < parent.indexOf((Component)this.cancelButton);
    }

    public void setShowOKButtonFirst(boolean showOKButtonFirst) {
        if (showOKButtonFirst != this.getShowOKButtonFirst()) {
            Container parent = this.okButton.getParent();
            parent.remove((Component)this.okButton);
            parent.remove((Component)this.cancelButton);
            if (showOKButtonFirst) {
                parent.add((Component)this.okButton);
                parent.add((Component)this.cancelButton);
            } else {
                parent.add((Component)this.cancelButton);
                parent.add((Component)this.okButton);
            }
        }
    }

    @Override
    public void windowOpened(Window window) {
        super.windowOpened(window);
        window.requestFocus();
    }

    @Override
    public Vote previewSheetClose(Sheet sheet, boolean result) {
        Vote vote = null;
        if (result && !this.okButton.isEnabled()) {
            vote = Vote.DENY;
        } else {
            if (result) {
                this.updatingSelection = true;
                FileBrowserSheet fileBrowserSheet = (FileBrowserSheet)sheet;
                FileBrowserSheet.Mode mode = fileBrowserSheet.getMode();
                switch (mode) {
                    case OPEN: 
                    case OPEN_MULTIPLE: 
                    case SAVE_TO: {
                        fileBrowserSheet.setSelectedFiles((Sequence)this.fileBrowser.getSelectedFiles());
                        break;
                    }
                    case SAVE_AS: {
                        String fileName = this.saveAsTextInput.getText();
                        File selectedFile = new File(fileName);
                        selectedFile = !selectedFile.isAbsolute() && !fileName.startsWith(File.separator) ? new File(this.fileBrowser.getRootDirectory(), fileName) : selectedFile.getAbsoluteFile();
                        if (selectedFile.exists() && selectedFile.isDirectory()) {
                            try {
                                File root = selectedFile.getCanonicalFile();
                                fileBrowserSheet.setRootDirectory(root);
                                this.fileBrowser.setRootDirectory(root);
                                this.saveAsTextInput.setText("");
                            }
                            catch (IOException ioe) {
                                Form.setFlag((Component)this.saveAsBoxPane, (Form.Flag)new Form.Flag());
                            }
                            selectedFile = null;
                            vote = Vote.DENY;
                        } else {
                            File root = selectedFile.getParentFile();
                            if (root != null && root.exists() && root.isDirectory()) {
                                try {
                                    fileBrowserSheet.setRootDirectory(root.getCanonicalFile());
                                    selectedFile = new File(selectedFile.getName());
                                }
                                catch (IOException ioe) {
                                    Form.setFlag((Component)this.saveAsBoxPane, (Form.Flag)new Form.Flag());
                                    selectedFile = null;
                                    vote = Vote.DENY;
                                }
                            } else {
                                Form.setFlag((Component)this.saveAsBoxPane, (Form.Flag)new Form.Flag());
                                selectedFile = null;
                                vote = Vote.DENY;
                            }
                        }
                        if (selectedFile == null) break;
                        fileBrowserSheet.setSelectedFiles((Sequence)new ArrayList((Object[])new File[]{selectedFile}));
                        break;
                    }
                }
                this.updatingSelection = false;
            }
            if (vote == null) {
                vote = super.previewSheetClose(sheet, result);
            }
        }
        return vote;
    }

    public void modeChanged(FileBrowserSheet fileBrowserSheet, FileBrowserSheet.Mode previousMode) {
        FileBrowserSheet.Mode mode = fileBrowserSheet.getMode();
        this.fileBrowser.getStyles().put("keyboardFolderTraversalEnabled", (Object)(mode != FileBrowserSheet.Mode.SAVE_TO ? 1 : 0));
        switch (mode) {
            case OPEN: {
                this.saveAsBoxPane.setVisible(false);
                this.fileBrowser.setMultiSelect(false);
                break;
            }
            case OPEN_MULTIPLE: {
                this.saveAsBoxPane.setVisible(false);
                this.fileBrowser.setMultiSelect(true);
                break;
            }
            case SAVE_AS: {
                this.saveAsBoxPane.setVisible(true);
                this.fileBrowser.setMultiSelect(false);
                break;
            }
            case SAVE_TO: {
                this.saveAsBoxPane.setVisible(false);
                this.fileBrowser.setMultiSelect(false);
                break;
            }
        }
        this.updateDisabledFileFilter();
        this.updateOKButtonState();
    }

    public void rootDirectoryChanged(FileBrowserSheet fileBrowserSheet, File previousRootDirectory) {
        if (!this.updatingSelection) {
            this.fileBrowser.setRootDirectory(fileBrowserSheet.getRootDirectory());
        }
    }

    public void selectedFilesChanged(FileBrowserSheet fileBrowserSheet, Sequence<File> previousSelectedFiles) {
        if (!this.updatingSelection) {
            ImmutableList selectedFiles = fileBrowserSheet.getSelectedFiles();
            this.fileBrowser.setSelectedFiles((Sequence)selectedFiles);
            if (this.fileBrowser.getSelectedFiles().getLength() == 0 && selectedFiles.getLength() == 1) {
                File selectedFile = (File)selectedFiles.get(0);
                File rootDirectory = this.fileBrowser.getRootDirectory();
                if (rootDirectory.equals(selectedFile.getParentFile())) {
                    this.saveAsTextInput.setText(selectedFile.getName());
                }
            }
        }
    }

    public void disabledFileFilterChanged(FileBrowserSheet fileBrowserSheet, Filter<File> previousDisabledFileFilter) {
        this.updateDisabledFileFilter();
    }

    private void updateDisabledFileFilter() {
        FileBrowserSheet fileBrowserSheet = (FileBrowserSheet)this.getComponent();
        Filter disabledFileFilter = fileBrowserSheet.getDisabledFileFilter();
        FileBrowserSheet.Mode mode = fileBrowserSheet.getMode();
        if (mode == FileBrowserSheet.Mode.SAVE_TO) {
            disabledFileFilter = new SaveToFileFilter((Filter<File>)disabledFileFilter);
        }
        this.fileBrowser.setDisabledFileFilter(disabledFileFilter);
    }

    private void updateOKButtonState() {
        FileBrowserSheet fileBrowserSheet = (FileBrowserSheet)this.getComponent();
        FileBrowserSheet.Mode mode = fileBrowserSheet.getMode();
        ImmutableList selectedFiles = this.fileBrowser.getSelectedFiles();
        switch (mode) {
            case OPEN: 
            case OPEN_MULTIPLE: {
                this.okButton.setEnabled(selectedFiles.getLength() > 0 && this.selectedDirectoryCount == 0);
                break;
            }
            case SAVE_AS: {
                this.okButton.setEnabled(this.saveAsTextInput.getCharacterCount() > 0);
                break;
            }
            case SAVE_TO: {
                this.okButton.setEnabled(this.selectedDirectoryCount > 0);
                break;
            }
        }
    }

    public void addComponent(Component component) {
        TablePane.Row row = new TablePane.Row(-1);
        row.add(component);
        TablePane.RowSequence rows = this.tablePane.getRows();
        rows.insert((Object)row, rows.getLength() - 1);
    }

    private static class SaveToFileFilter
    implements Filter<File> {
        public final Filter<File> sourceFilter;

        public SaveToFileFilter(Filter<File> sourceFilter) {
            this.sourceFilter = sourceFilter;
        }

        public boolean include(File file) {
            return !file.isDirectory() || this.sourceFilter != null && this.sourceFilter.include((Object)file);
        }
    }
}

