/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Form;
import org.apache.pivot.wtk.FormAttributeListener;
import org.apache.pivot.wtk.FormListener;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Separator;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.DropShadowDecorator;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraFormSkin
extends ContainerSkin
implements FormListener,
FormAttributeListener {
    private ArrayList<Separator> separators = new ArrayList();
    private ArrayList<ArrayList<Label>> labels = new ArrayList();
    private Label flagMessageLabel = new Label();
    private Window flagMessageWindow = new Window((Component)this.flagMessageLabel);
    private Insets padding;
    private int horizontalSpacing = 6;
    private int verticalSpacing = 6;
    private int flagIconOffset = 4;
    private boolean fill = false;
    private boolean showFlagIcons = true;
    private boolean showFlagHighlight = true;
    private boolean showFlagMessagesInline = false;
    private boolean leftAlignLabels = false;
    private String delimiter = ":";
    private Image errorIcon = null;
    private Color errorMessageColor = null;
    private Color errorMessageBackgroundColor = null;
    private Color errorHighlightColor = null;
    private Image warningIcon = null;
    private Color warningMessageColor = null;
    private Color warningMessageBackgroundColor = null;
    private Color warningHighlightColor = null;
    private Image questionIcon = null;
    private Color questionMessageColor = null;
    private Color questionMessageBackgroundColor = null;
    private Color questionHighlightColor = null;
    private Image infoIcon = null;
    private Color infoMessageColor = null;
    private Color infoMessageBackgroundColor = null;
    private Color infoHighlightColor = null;
    private Color separatorColor = null;
    private Color separatorHeadingColor = null;
    private int maximumFlagImageWidth = 0;
    private ComponentMouseListener fieldMouseListener = new ComponentMouseListener.Adapter(){

        public void mouseOver(Component component) {
            String message;
            Form.Flag flag;
            if (!TerraFormSkin.this.showFlagMessagesInline && (flag = Form.getFlag((Component)component)) != null && (message = flag.getMessage()) != null) {
                TerraFormSkin.this.flagMessageLabel.setText(message);
                MessageType messageType = flag.getMessageType();
                Color color = null;
                Color backgroundColor = null;
                switch (messageType) {
                    case ERROR: {
                        color = TerraFormSkin.this.errorMessageColor;
                        backgroundColor = TerraFormSkin.this.errorMessageBackgroundColor;
                        break;
                    }
                    case WARNING: {
                        color = TerraFormSkin.this.warningMessageColor;
                        backgroundColor = TerraFormSkin.this.warningMessageBackgroundColor;
                        break;
                    }
                    case QUESTION: {
                        color = TerraFormSkin.this.questionMessageColor;
                        backgroundColor = TerraFormSkin.this.questionMessageBackgroundColor;
                        break;
                    }
                    case INFO: {
                        color = TerraFormSkin.this.infoMessageColor;
                        backgroundColor = TerraFormSkin.this.infoMessageBackgroundColor;
                        break;
                    }
                }
                TerraFormSkin.this.flagMessageLabel.getStyles().put("color", (Object)color);
                TerraFormSkin.this.flagMessageWindow.getStyles().put("backgroundColor", (Object)backgroundColor);
                Point location = component.mapPointToAncestor((Container)component.getDisplay(), 0, component.getHeight());
                int y = location.y + 6 - 4;
                if (TerraFormSkin.this.showFlagHighlight) {
                    y += 2;
                }
                TerraFormSkin.this.flagMessageWindow.setLocation(location.x, y);
                TerraFormSkin.this.flagMessageWindow.open(component.getWindow());
            }
        }

        public void mouseOut(Component component) {
            TerraFormSkin.this.flagMessageWindow.close();
        }
    };
    private static final int FLAG_HIGHLIGHT_PADDING = 2;
    private static final int POPUP_FIELD_INDICATOR_WIDTH = 13;
    private static final int POPUP_FIELD_INDICATOR_HEIGHT = 6;
    private static final int POPUP_FIELD_INDICATOR_OFFSET = 10;
    private static final int HIDE_POPUP_MESSAGE_DELAY = 3500;
    private static final int INLINE_FIELD_INDICATOR_WIDTH = 9;
    private static final String DEFAULT_DELIMITER = ":";

    public TerraFormSkin() {
        this.padding = new Insets(4);
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.errorIcon = theme.getSmallMessageIcon(MessageType.ERROR);
        this.errorMessageColor = theme.getColor(4);
        this.errorMessageBackgroundColor = theme.getColor(22);
        this.errorHighlightColor = theme.getColor(21);
        this.warningIcon = theme.getSmallMessageIcon(MessageType.WARNING);
        this.warningMessageColor = theme.getColor(1);
        this.warningMessageBackgroundColor = theme.getColor(19);
        this.warningHighlightColor = theme.getColor(18);
        this.questionIcon = theme.getSmallMessageIcon(MessageType.QUESTION);
        this.questionMessageColor = theme.getColor(4);
        this.questionMessageBackgroundColor = theme.getColor(14);
        this.questionHighlightColor = theme.getColor(13);
        this.infoIcon = theme.getSmallMessageIcon(MessageType.INFO);
        this.infoMessageColor = theme.getColor(1);
        this.infoMessageBackgroundColor = theme.getColor(10);
        this.infoHighlightColor = theme.getColor(9);
        this.separatorColor = theme.getColor(7);
        this.separatorHeadingColor = theme.getColor(12);
        this.maximumFlagImageWidth = Math.max(this.maximumFlagImageWidth, this.errorIcon.getWidth());
        this.maximumFlagImageWidth = Math.max(this.maximumFlagImageWidth, this.warningIcon.getWidth());
        this.maximumFlagImageWidth = Math.max(this.maximumFlagImageWidth, this.questionIcon.getWidth());
        this.maximumFlagImageWidth = Math.max(this.maximumFlagImageWidth, this.infoIcon.getWidth());
        this.flagMessageLabel.getStyles().put("padding", (Object)new Insets(3, 4, 3, 4));
        this.flagMessageWindow.getDecorators().add((Decorator)new DropShadowDecorator(3, 3, 3));
        this.flagMessageWindow.getDecorators().add((Decorator)new PopupFieldIndicatorDecorator());
        this.flagMessageWindow.getWindowStateListeners().add((Object)new WindowStateListener.Adapter(){
            private ApplicationContext.ScheduledCallback scheduledHideFlagMessageCallback = null;

            public void windowOpened(Window window) {
                Runnable hideFlagMessageCallback = new Runnable(){

                    @Override
                    public void run() {
                        TerraFormSkin.this.flagMessageWindow.close();
                    }
                };
                this.scheduledHideFlagMessageCallback = ApplicationContext.scheduleCallback((Runnable)hideFlagMessageCallback, (long)3500L);
            }

            public void windowClosed(Window window, Display display, Window owner) {
                this.scheduledHideFlagMessageCallback.cancel();
            }
        });
    }

    public void install(Component component) {
        super.install(component);
        Form form = (Form)component;
        form.getFormListeners().add((Object)this);
        form.getFormAttributeListeners().add((Object)this);
        Form.SectionSequence sections = form.getSections();
        int n = sections.getLength();
        for (int i = 0; i < n; ++i) {
            this.insertSection(sections.get(i), i);
        }
        form.getDecorators().add((Decorator)new InlineFlagMessageDecorator());
    }

    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        int maximumLabelWidth = 0;
        int maximumFieldWidth = 0;
        int maximumSeparatorWidth = 0;
        Form form = (Form)this.getComponent();
        Form.SectionSequence sections = form.getSections();
        int sectionCount = sections.getLength();
        for (int sectionIndex = 0; sectionIndex < sectionCount; ++sectionIndex) {
            Form.Section section = sections.get(sectionIndex);
            if (sectionIndex > 0 || section.getHeading() != null) {
                Separator separator = (Separator)this.separators.get(sectionIndex);
                maximumSeparatorWidth = Math.max(maximumSeparatorWidth, separator.getPreferredWidth());
            }
            int fieldCount = section.getLength();
            for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
                String message;
                Form.Flag flag;
                Component field = section.get(fieldIndex);
                if (!field.isVisible()) continue;
                Label label = (Label)((ArrayList)this.labels.get(sectionIndex)).get(fieldIndex);
                maximumLabelWidth = Math.max(maximumLabelWidth, label.getPreferredWidth());
                int fieldWidth = field.getPreferredWidth();
                if (this.showFlagMessagesInline && (flag = Form.getFlag((Component)field)) != null && (message = flag.getMessage()) != null) {
                    this.flagMessageLabel.setText(message);
                    fieldWidth += 7 + this.flagMessageLabel.getPreferredWidth();
                }
                maximumFieldWidth = Math.max(maximumFieldWidth, fieldWidth);
            }
        }
        preferredWidth = maximumLabelWidth + this.horizontalSpacing + maximumFieldWidth;
        if (this.showFlagIcons) {
            preferredWidth += this.maximumFlagImageWidth + this.flagIconOffset;
        }
        preferredWidth = Math.max(preferredWidth + this.padding.left + this.padding.right, maximumSeparatorWidth);
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        Form form = (Form)this.getComponent();
        Form.SectionSequence sections = form.getSections();
        int fieldWidth = this.fill && width != -1 ? this.getFieldWidth(width) : -1;
        int sectionCount = sections.getLength();
        for (int sectionIndex = 0; sectionIndex < sectionCount; ++sectionIndex) {
            Form.Section section = sections.get(sectionIndex);
            if (sectionIndex > 0 || section.getHeading() != null) {
                Separator separator = (Separator)this.separators.get(sectionIndex);
                preferredHeight += separator.getPreferredHeight(width);
                preferredHeight += this.verticalSpacing;
            }
            int fieldCount = section.getLength();
            for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
                Component field = section.get(fieldIndex);
                if (!field.isVisible()) continue;
                Label label = (Label)((ArrayList)this.labels.get(sectionIndex)).get(fieldIndex);
                Dimensions labelSize = label.getPreferredSize();
                int labelAscent = label.getBaseline(labelSize.width, labelSize.height);
                int labelDescent = labelSize.height - labelAscent;
                Dimensions fieldSize = this.fill && fieldWidth != -1 ? new Dimensions(fieldWidth, field.getPreferredHeight(fieldWidth)) : field.getPreferredSize();
                int fieldAscent = field.getBaseline(fieldSize.width, fieldSize.height);
                if (fieldAscent == -1) {
                    fieldAscent = fieldSize.height;
                }
                int fieldDescent = fieldSize.height - fieldAscent;
                int maximumAscent = Math.max(labelAscent, fieldAscent);
                int maximumDescent = Math.max(labelDescent, fieldDescent);
                int rowHeight = maximumAscent + maximumDescent;
                preferredHeight += rowHeight;
                if (fieldIndex <= 0) continue;
                preferredHeight += this.verticalSpacing;
            }
        }
        return preferredHeight += this.padding.top + this.padding.bottom;
    }

    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    public int getBaseline(int width, int height) {
        int baseline = -1;
        Form form = (Form)this.getComponent();
        Form.SectionSequence sections = form.getSections();
        int fieldWidth = this.fill ? this.getFieldWidth(width) : -1;
        int sectionCount = sections.getLength();
        int rowY = 0;
        for (int sectionIndex = 0; sectionIndex < sectionCount && baseline == -1; ++sectionIndex) {
            Form.Section section = sections.get(sectionIndex);
            if (sectionIndex > 0 || section.getHeading() != null) {
                Separator separator = (Separator)this.separators.get(sectionIndex);
                rowY += separator.getPreferredHeight(width);
                rowY += this.verticalSpacing;
            }
            int fieldCount = section.getLength();
            for (int fieldIndex = 0; fieldIndex < fieldCount && baseline == -1; ++fieldIndex) {
                Component field = section.get(fieldIndex);
                if (!field.isVisible()) continue;
                Label label = (Label)((ArrayList)this.labels.get(sectionIndex)).get(fieldIndex);
                Dimensions labelSize = label.getPreferredSize();
                int labelAscent = label.getBaseline(labelSize.width, labelSize.height);
                Dimensions fieldSize = this.fill && fieldWidth != -1 ? new Dimensions(fieldWidth, field.getPreferredHeight(fieldWidth)) : field.getPreferredSize();
                int fieldAscent = field.getBaseline(fieldSize.width, fieldSize.height);
                if (fieldAscent == -1) {
                    fieldAscent = labelAscent;
                }
                int maximumAscent = Math.max(labelAscent, fieldAscent);
                baseline = rowY + maximumAscent;
            }
        }
        return baseline += this.padding.top;
    }

    private int getFieldWidth(int width) {
        int maximumLabelWidth = 0;
        int maximumFlagMessageWidth = 0;
        Form form = (Form)this.getComponent();
        Form.SectionSequence sections = form.getSections();
        int sectionCount = sections.getLength();
        for (int sectionIndex = 0; sectionIndex < sectionCount; ++sectionIndex) {
            Form.Section section = sections.get(sectionIndex);
            int fieldCount = section.getLength();
            for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
                String message;
                Form.Flag flag;
                Component field = section.get(fieldIndex);
                if (!field.isVisible()) continue;
                Label label = (Label)((ArrayList)this.labels.get(sectionIndex)).get(fieldIndex);
                maximumLabelWidth = Math.max(maximumLabelWidth, label.getPreferredWidth());
                if (!this.showFlagMessagesInline || (flag = Form.getFlag((Component)field)) == null || (message = flag.getMessage()) == null) continue;
                this.flagMessageLabel.setText(message);
                maximumFlagMessageWidth = Math.max(maximumFlagMessageWidth, this.flagMessageLabel.getPreferredWidth());
            }
        }
        int fieldWidth = Math.max(0, width - (maximumLabelWidth + this.horizontalSpacing));
        if (this.showFlagIcons) {
            fieldWidth = Math.max(0, fieldWidth - (this.maximumFlagImageWidth + this.flagIconOffset));
        }
        if (this.showFlagMessagesInline) {
            fieldWidth = Math.max(0, fieldWidth - (maximumFlagMessageWidth + 7));
        }
        fieldWidth = Math.max(0, fieldWidth - (this.padding.left + this.padding.right));
        return fieldWidth;
    }

    public void layout() {
        Form form = (Form)this.getComponent();
        Form.SectionSequence sections = form.getSections();
        int maximumLabelWidth = 0;
        int maximumFlagMessageWidth = 0;
        int sectionCount = sections.getLength();
        for (int sectionIndex = 0; sectionIndex < sectionCount; ++sectionIndex) {
            Form.Section section = sections.get(sectionIndex);
            int fieldCount = section.getLength();
            for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
                String message;
                Form.Flag flag;
                Component field = section.get(fieldIndex);
                if (!field.isVisible()) continue;
                Label label = (Label)((ArrayList)this.labels.get(sectionIndex)).get(fieldIndex);
                maximumLabelWidth = Math.max(maximumLabelWidth, label.getPreferredWidth());
                if (!this.showFlagMessagesInline || (flag = Form.getFlag((Component)field)) == null || (message = flag.getMessage()) == null) continue;
                this.flagMessageLabel.setText(message);
                maximumFlagMessageWidth = Math.max(maximumFlagMessageWidth, this.flagMessageLabel.getPreferredWidth());
            }
        }
        int width = this.getWidth();
        int fieldWidth = Math.max(0, width - (maximumLabelWidth + this.horizontalSpacing));
        if (this.showFlagIcons) {
            fieldWidth = Math.max(0, fieldWidth - (this.maximumFlagImageWidth + this.flagIconOffset));
        }
        if (this.showFlagMessagesInline) {
            fieldWidth = Math.max(0, fieldWidth - (maximumFlagMessageWidth + 7));
        }
        fieldWidth = Math.max(0, fieldWidth - (this.padding.left + this.padding.right));
        int rowY = this.padding.top;
        int sectionCount2 = sections.getLength();
        for (int sectionIndex = 0; sectionIndex < sectionCount2; ++sectionIndex) {
            Form.Section section = sections.get(sectionIndex);
            Separator separator = (Separator)this.separators.get(sectionIndex);
            if (sectionIndex > 0 || section.getHeading() != null) {
                int separatorWidth = Math.max(width - (this.padding.left + this.padding.right), 0);
                separator.setVisible(true);
                separator.setSize(separatorWidth, separator.getPreferredHeight(separatorWidth));
                separator.setLocation(this.padding.left, rowY);
                rowY += separator.getHeight();
            } else {
                separator.setVisible(false);
            }
            int fieldCount = section.getLength();
            for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
                Label label = (Label)((ArrayList)this.labels.get(sectionIndex)).get(fieldIndex);
                Component field = section.get(fieldIndex);
                if (field.isVisible()) {
                    label.setVisible(true);
                    Dimensions labelSize = label.getPreferredSize();
                    label.setSize(labelSize);
                    int labelAscent = label.getBaseline(labelSize.width, labelSize.height);
                    int labelDescent = labelSize.height - labelAscent;
                    Dimensions fieldSize = this.fill ? new Dimensions(fieldWidth, field.getPreferredHeight(fieldWidth)) : field.getPreferredSize();
                    field.setSize(fieldSize);
                    int fieldAscent = field.getBaseline(fieldSize.width, fieldSize.height);
                    if (fieldAscent == -1) {
                        fieldAscent = labelAscent;
                    }
                    int fieldDescent = fieldSize.height - fieldAscent;
                    int maximumAscent = Math.max(labelAscent, fieldAscent);
                    int maximumDescent = Math.max(labelDescent, fieldDescent);
                    int baseline = maximumAscent;
                    int rowHeight = maximumAscent + maximumDescent;
                    int labelX = this.padding.left;
                    if (!this.leftAlignLabels) {
                        labelX += maximumLabelWidth - label.getWidth();
                    }
                    if (this.showFlagIcons) {
                        labelX += this.maximumFlagImageWidth + this.flagIconOffset;
                    }
                    int labelY = rowY + (baseline - labelAscent);
                    label.setLocation(labelX, labelY);
                    int fieldX = this.padding.left + maximumLabelWidth + this.horizontalSpacing;
                    if (this.showFlagIcons) {
                        fieldX += this.maximumFlagImageWidth + this.flagIconOffset;
                    }
                    int fieldY = rowY + (baseline - fieldAscent);
                    field.setLocation(fieldX, fieldY);
                    rowY += rowHeight + this.verticalSpacing;
                    continue;
                }
                label.setVisible(false);
            }
        }
    }

    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Form form = (Form)this.getComponent();
        Form.SectionSequence sections = form.getSections();
        int sectionCount = sections.getLength();
        for (int sectionIndex = 0; sectionIndex < sectionCount; ++sectionIndex) {
            Form.Section section = sections.get(sectionIndex);
            int fieldCount = section.getLength();
            for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
                MessageType messageType;
                Form.Flag flag;
                Component field = section.get(fieldIndex);
                if (!field.isVisible() || (flag = Form.getFlag((Component)field)) == null) continue;
                if (this.showFlagIcons) {
                    messageType = flag.getMessageType();
                    Image flagIcon = null;
                    switch (messageType) {
                        case ERROR: {
                            flagIcon = this.errorIcon;
                            break;
                        }
                        case WARNING: {
                            flagIcon = this.warningIcon;
                            break;
                        }
                        case QUESTION: {
                            flagIcon = this.questionIcon;
                            break;
                        }
                        case INFO: {
                            flagIcon = this.infoIcon;
                            break;
                        }
                        default: {
                            flagIcon = this.infoIcon;
                        }
                    }
                    Label label = (Label)((ArrayList)this.labels.get(sectionIndex)).get(fieldIndex);
                    int flagIconX = label.getX() - (flagIcon.getWidth() + this.flagIconOffset);
                    int flagIconY = label.getY() + (label.getHeight() - flagIcon.getHeight()) / 2;
                    graphics.translate(flagIconX, flagIconY);
                    flagIcon.paint(graphics);
                    graphics.translate(-flagIconX, -flagIconY);
                }
                if (!this.showFlagHighlight) continue;
                messageType = flag.getMessageType();
                Color highlightColor = null;
                switch (messageType) {
                    case ERROR: {
                        highlightColor = this.errorHighlightColor;
                        break;
                    }
                    case WARNING: {
                        highlightColor = this.warningHighlightColor;
                        break;
                    }
                    case QUESTION: {
                        highlightColor = this.questionHighlightColor;
                        break;
                    }
                    case INFO: {
                        highlightColor = this.infoHighlightColor;
                        break;
                    }
                }
                Bounds fieldBounds = field.getBounds();
                graphics.setColor(highlightColor);
                graphics.setStroke(new BasicStroke(1.0f));
                graphics.drawRect(fieldBounds.x - 2, fieldBounds.y - 2, fieldBounds.width + 4 - 1, fieldBounds.height + 4 - 1);
            }
        }
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)padding));
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        if (horizontalSpacing < 0) {
            throw new IllegalArgumentException("horizontalSpacing is negative.");
        }
        this.horizontalSpacing = horizontalSpacing;
        this.invalidateComponent();
    }

    public final void setHorizontalSpacing(Number horizontalSpacing) {
        if (horizontalSpacing == null) {
            throw new IllegalArgumentException("horizontalSpacing is null.");
        }
        this.setHorizontalSpacing(horizontalSpacing.intValue());
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(int verticalSpacing) {
        if (verticalSpacing < 0) {
            throw new IllegalArgumentException("verticalSpacing is negative.");
        }
        this.verticalSpacing = verticalSpacing;
        this.invalidateComponent();
    }

    public final void setVerticalSpacing(Number verticalSpacing) {
        if (verticalSpacing == null) {
            throw new IllegalArgumentException("verticalSpacing is null.");
        }
        this.setVerticalSpacing(verticalSpacing.intValue());
    }

    public int getFlagIconOffset() {
        return this.flagIconOffset;
    }

    public void setFlagIconOffset(int flagIconOffset) {
        if (flagIconOffset < 0) {
            throw new IllegalArgumentException("flagIconOffset is negative.");
        }
        this.flagIconOffset = flagIconOffset;
        this.invalidateComponent();
    }

    public final void setFlagIconOffset(Number flagIconOffset) {
        if (flagIconOffset == null) {
            throw new IllegalArgumentException("flagIconOffset is null.");
        }
        this.setFlagIconOffset(flagIconOffset.intValue());
    }

    public boolean getFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
        this.invalidateComponent();
    }

    public boolean getShowFlagIcons() {
        return this.showFlagIcons;
    }

    public void setShowFlagIcons(boolean showFlagIcons) {
        this.showFlagIcons = showFlagIcons;
        this.invalidateComponent();
    }

    public boolean getShowFlagHighlight() {
        return this.showFlagHighlight;
    }

    public void setShowFlagHighlight(boolean showFlagHighlight) {
        this.showFlagHighlight = showFlagHighlight;
        this.invalidateComponent();
    }

    public boolean getShowFlagMessagesInline() {
        return this.showFlagMessagesInline;
    }

    public void setShowFlagMessagesInline(boolean showFlagMessagesInline) {
        this.showFlagMessagesInline = showFlagMessagesInline;
        this.invalidateComponent();
    }

    public boolean getLeftAlignLabels() {
        return this.leftAlignLabels;
    }

    public void setLeftAlignLabels(boolean leftAlignLabels) {
        this.leftAlignLabels = leftAlignLabels;
        this.invalidateComponent();
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        if (delimiter == null) {
            throw new IllegalArgumentException("delimiter is null.");
        }
        this.delimiter = delimiter;
        Form form = (Form)this.getComponent();
        Form.SectionSequence sections = form.getSections();
        int n = sections.getLength();
        for (int i = 0; i < n; ++i) {
            Form.Section section = sections.get(i);
            int m = section.getLength();
            for (int j = 0; j < m; ++j) {
                this.updateFieldLabel(section, j);
            }
        }
        this.invalidateComponent();
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color separatorColor) {
        this.separatorColor = separatorColor;
        for (Separator separator : this.separators) {
            separator.getStyles().put("color", (Object)separatorColor);
        }
    }

    public final void setSeparatorColor(String separatorColor) {
        if (separatorColor == null) {
            throw new IllegalArgumentException("separatorColor is null.");
        }
        this.setSeparatorColor(GraphicsUtilities.decodeColor((String)separatorColor));
    }

    public Color getSeparatorHeadingColor() {
        return this.separatorHeadingColor;
    }

    public void setSeparatorHeadingColor(Color separatorHeadingColor) {
        this.separatorHeadingColor = separatorHeadingColor;
        for (Separator separator : this.separators) {
            separator.getStyles().put("headingColor", (Object)separatorHeadingColor);
        }
    }

    public final void setSeparatorHeadingColor(String separatorHeadingColor) {
        if (separatorHeadingColor == null) {
            throw new IllegalArgumentException("separatorHeadingColor is null.");
        }
        this.setSeparatorHeadingColor(GraphicsUtilities.decodeColor((String)separatorHeadingColor));
    }

    public void sectionInserted(Form form, int index) {
        this.insertSection(form.getSections().get(index), index);
    }

    public void sectionsRemoved(Form form, int index, Sequence<Form.Section> removed) {
        this.removeSections(index, removed);
    }

    public void sectionHeadingChanged(Form.Section section) {
        this.updateSectionHeading(section);
    }

    public void fieldInserted(Form.Section section, int index) {
        this.insertField(section, section.get(index), index);
    }

    public void fieldsRemoved(Form.Section section, int index, Sequence<Component> fields) {
        Form form = (Form)this.getComponent();
        this.removeFields(form.getSections().indexOf(section), index, fields);
    }

    public void labelChanged(Form form, Component field, String previousLabel) {
        Form.Section section = Form.getSection((Component)field);
        this.updateFieldLabel(section, section.indexOf(field));
    }

    public void requiredChanged(Form form, Component field) {
    }

    public void flagChanged(Form form, Component field, Form.Flag previousFlag) {
        if (this.showFlagMessagesInline) {
            this.invalidateComponent();
        } else {
            this.repaintComponent();
        }
    }

    private void insertSection(Form.Section section, int index) {
        Form form = (Form)this.getComponent();
        Separator separator = new Separator(section.getHeading());
        separator.getStyles().put("color", (Object)this.separatorColor);
        separator.getStyles().put("headingColor", (Object)this.separatorHeadingColor);
        this.separators.insert((Object)separator, index);
        form.add((Component)separator);
        ArrayList sectionLabels = new ArrayList();
        this.labels.insert((Object)sectionLabels, index);
        int n = section.getLength();
        for (int i = 0; i < n; ++i) {
            this.insertField(section, section.get(i), i);
        }
        this.invalidateComponent();
    }

    private void removeSections(int index, Sequence<Form.Section> removed) {
        Form form = (Form)this.getComponent();
        int count = removed.getLength();
        for (int i = 0; i < count; ++i) {
            this.removeFields(index + i, 0, (Sequence<Component>)((Sequence)removed.get(i)));
        }
        this.labels.remove(index, count);
        Sequence removedSeparators = this.separators.remove(index, count);
        for (int i = 0; i < count; ++i) {
            form.remove((Component)removedSeparators.get(i));
        }
        this.invalidateComponent();
    }

    private void insertField(Form.Section section, Component field, int index) {
        Form form = (Form)this.getComponent();
        int sectionIndex = form.getSections().indexOf(section);
        Label label = new Label();
        ((ArrayList)this.labels.get(sectionIndex)).insert((Object)label, index);
        form.add((Component)label);
        field.getComponentMouseListeners().add((Object)this.fieldMouseListener);
        this.updateFieldLabel(section, index);
        this.invalidateComponent();
    }

    private void removeFields(int sectionIndex, int index, Sequence<Component> removed) {
        Form form = (Form)this.getComponent();
        int count = removed.getLength();
        Sequence removedLabels = ((ArrayList)this.labels.get(sectionIndex)).remove(index, count);
        for (int i = 0; i < count; ++i) {
            form.remove((Component)removedLabels.get(i));
            Component field = (Component)removed.get(i);
            field.getComponentMouseListeners().remove((Object)this.fieldMouseListener);
        }
        this.invalidateComponent();
    }

    private void updateSectionHeading(Form.Section section) {
        Form form = (Form)this.getComponent();
        int sectionIndex = form.getSections().indexOf(section);
        Separator separator = (Separator)this.separators.get(sectionIndex);
        separator.setHeading(section.getHeading());
    }

    private void updateFieldLabel(Form.Section section, int fieldIndex) {
        Form form = (Form)this.getComponent();
        Component field = section.get(fieldIndex);
        int sectionIndex = form.getSections().indexOf(section);
        Label label = (Label)((ArrayList)this.labels.get(sectionIndex)).get(fieldIndex);
        String labelText = Form.getLabel((Component)field);
        label.setText(labelText == null ? "" : labelText + this.delimiter);
    }

    private class InlineFlagMessageDecorator
    implements Decorator {
        private Graphics2D graphics = null;

        private InlineFlagMessageDecorator() {
        }

        public Graphics2D prepare(Component component, Graphics2D graphicsArgument) {
            this.graphics = graphicsArgument;
            return graphicsArgument;
        }

        public void update() {
            if (TerraFormSkin.this.showFlagMessagesInline) {
                Form form = (Form)TerraFormSkin.this.getComponent();
                Form.SectionSequence sections = form.getSections();
                int sectionCount = sections.getLength();
                for (int sectionIndex = 0; sectionIndex < sectionCount; ++sectionIndex) {
                    Form.Section section = sections.get(sectionIndex);
                    int fieldCount = section.getLength();
                    for (int fieldIndex = 0; fieldIndex < fieldCount; ++fieldIndex) {
                        Form.Flag flag;
                        Component field = section.get(fieldIndex);
                        if (!field.isVisible() || (flag = Form.getFlag((Component)field)) == null) continue;
                        String message = flag.getMessage();
                        MessageType messageType = flag.getMessageType();
                        Color messageColor = null;
                        Color messageBackgroundColor = null;
                        switch (messageType) {
                            case ERROR: {
                                messageColor = TerraFormSkin.this.errorMessageColor;
                                messageBackgroundColor = TerraFormSkin.this.errorMessageBackgroundColor;
                                break;
                            }
                            case WARNING: {
                                messageColor = TerraFormSkin.this.warningMessageColor;
                                messageBackgroundColor = TerraFormSkin.this.warningMessageBackgroundColor;
                                break;
                            }
                            case QUESTION: {
                                messageColor = TerraFormSkin.this.questionMessageColor;
                                messageBackgroundColor = TerraFormSkin.this.questionMessageBackgroundColor;
                                break;
                            }
                            case INFO: {
                                messageColor = TerraFormSkin.this.infoMessageColor;
                                messageBackgroundColor = TerraFormSkin.this.infoMessageBackgroundColor;
                                break;
                            }
                        }
                        TerraFormSkin.this.flagMessageLabel.setText(message);
                        TerraFormSkin.this.flagMessageLabel.setSize(TerraFormSkin.this.flagMessageLabel.getPreferredSize());
                        TerraFormSkin.this.flagMessageLabel.validate();
                        TerraFormSkin.this.flagMessageLabel.getStyles().put("color", (Object)messageColor);
                        TerraFormSkin.this.flagMessageLabel.getStyles().put("backgroundColor", (Object)messageBackgroundColor);
                        int flagMessageX = field.getX() + field.getWidth() + 9 - 2;
                        int flagMessageY = field.getY() - field.getBaseline() + TerraFormSkin.this.flagMessageLabel.getBaseline();
                        this.graphics.translate(flagMessageX, flagMessageY);
                        TerraFormSkin.this.flagMessageLabel.paint(this.graphics);
                        GeneralPath arrow = new GeneralPath(0);
                        arrow.moveTo(0.0f, 0.0f);
                        arrow.lineTo(-9.0f, (float)TerraFormSkin.this.flagMessageLabel.getHeight() / 2.0f);
                        arrow.lineTo(0.0f, TerraFormSkin.this.flagMessageLabel.getHeight());
                        arrow.closePath();
                        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        this.graphics.setColor(messageBackgroundColor);
                        this.graphics.fill(arrow);
                        this.graphics.translate(-flagMessageX, -flagMessageY);
                    }
                }
            }
            this.graphics = null;
        }

        public Bounds getBounds(Component component) {
            return new Bounds(0, 0, component.getWidth(), component.getHeight());
        }

        public AffineTransform getTransform(Component component) {
            return new AffineTransform();
        }
    }

    private class PopupFieldIndicatorDecorator
    implements Decorator {
        private Graphics2D graphics = null;

        private PopupFieldIndicatorDecorator() {
        }

        public Graphics2D prepare(Component component, Graphics2D graphicsArgument) {
            this.graphics = graphicsArgument;
            return graphicsArgument;
        }

        public void update() {
            GeneralPath arrow = new GeneralPath(0);
            arrow.moveTo(10.0f, 0.0f);
            arrow.lineTo(16.0f, -6.0f);
            arrow.lineTo(23.0f, 0.0f);
            arrow.closePath();
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.graphics.setStroke(new BasicStroke(0.0f));
            this.graphics.setColor((Color)TerraFormSkin.this.flagMessageWindow.getStyles().get("backgroundColor"));
            this.graphics.draw(arrow);
            this.graphics.fill(arrow);
            this.graphics = null;
        }

        public Bounds getBounds(Component component) {
            return new Bounds(10, -6, 13, 6);
        }

        public AffineTransform getTransform(Component component) {
            return new AffineTransform();
        }
    }
}

