/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Border;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.ListButton;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.Panorama;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.DropShadowDecorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.skin.ListButtonSkin;
import org.apache.pivot.wtk.skin.terra.FadeWindowTransition;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraListButtonSkin
extends ListButtonSkin {
    private WindowStateListener listViewPopupStateListener = new WindowStateListener.Adapter(){

        public void windowOpened(Window window) {
            ListButton listButton = (ListButton)TerraListButtonSkin.this.getComponent();
            int listSize = listButton.getListSize();
            if (listSize == -1) {
                TerraListButtonSkin.this.listViewBorder.setPreferredHeight(-1);
            } else if (!TerraListButtonSkin.this.listViewBorder.isPreferredHeightSet()) {
                ListView.ItemRenderer itemRenderer = TerraListButtonSkin.this.listView.getItemRenderer();
                int borderHeight = itemRenderer.getPreferredHeight(-1) * listSize + 2;
                if (TerraListButtonSkin.this.listViewBorder.getPreferredHeight() > borderHeight) {
                    TerraListButtonSkin.this.listViewBorder.setPreferredHeight(borderHeight);
                } else {
                    TerraListButtonSkin.this.listViewBorder.setPreferredHeight(-1);
                }
            }
            Display display = listButton.getDisplay();
            Dimensions displaySize = display.getSize();
            Point buttonLocation = listButton.mapPointToAncestor((Container)display, 0, 0);
            window.setLocation(buttonLocation.x, buttonLocation.y + TerraListButtonSkin.this.getHeight() - 1);
            int width = TerraListButtonSkin.this.getWidth();
            window.setMinimumWidth(width - 14 - 1);
            int popupWidth = window.getPreferredWidth();
            if (buttonLocation.x + popupWidth > displaySize.width) {
                window.setX(buttonLocation.x + width - popupWidth);
            }
            window.setMaximumHeight(Integer.MAX_VALUE);
            int popupHeight = window.getPreferredHeight();
            int maximumHeight = displaySize.height - window.getY();
            if (popupHeight > maximumHeight && buttonLocation.y > maximumHeight) {
                window.setMaximumHeight(buttonLocation.y);
                window.setY(buttonLocation.y - window.getPreferredHeight() + 1);
            } else {
                window.setMaximumHeight(maximumHeight);
            }
            TerraListButtonSkin.this.repaintComponent();
            ApplicationContext.queueCallback((Runnable)new Runnable(){

                @Override
                public void run() {
                    int selectedIndex = TerraListButtonSkin.this.listView.getSelectedIndex();
                    if (selectedIndex >= 0) {
                        Bounds itemBounds = TerraListButtonSkin.this.listView.getItemBounds(selectedIndex);
                        TerraListButtonSkin.this.listView.scrollAreaToVisible(itemBounds);
                    }
                }
            });
        }

        public Vote previewWindowClose(final Window window) {
            Vote vote = Vote.APPROVE;
            if (TerraListButtonSkin.this.closeTransition == null) {
                TerraListButtonSkin.this.closeTransition = (Transition)new FadeWindowTransition((Component)window, TerraListButtonSkin.this.closeTransitionDuration, TerraListButtonSkin.this.closeTransitionRate, TerraListButtonSkin.this.dropShadowDecorator);
                TerraListButtonSkin.this.closeTransition.start(new TransitionListener(){

                    public void transitionCompleted(Transition transition) {
                        window.close();
                    }
                });
                vote = Vote.DEFER;
            } else {
                vote = TerraListButtonSkin.this.closeTransition.isRunning() ? Vote.DEFER : Vote.APPROVE;
            }
            return vote;
        }

        public void windowCloseVetoed(Window window, Vote reason) {
            if (reason == Vote.DENY && TerraListButtonSkin.this.closeTransition != null) {
                TerraListButtonSkin.this.closeTransition.stop();
                TerraListButtonSkin.this.closeTransition = null;
            }
            TerraListButtonSkin.this.repaintComponent();
        }

        public void windowClosed(Window window, Display display, Window owner) {
            TerraListButtonSkin.this.closeTransition = null;
            TerraListButtonSkin.this.repaintComponent();
        }
    };
    private Panorama listViewPanorama;
    private Border listViewBorder;
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color backgroundColor;
    private Color disabledBackgroundColor;
    private Color borderColor;
    private Color disabledBorderColor;
    private Insets padding;
    private int closeTransitionDuration = 250;
    private int closeTransitionRate = 30;
    private Color bevelColor;
    private Color pressedBevelColor;
    private Color disabledBevelColor;
    private Transition closeTransition = null;
    private DropShadowDecorator dropShadowDecorator = null;
    private static final int CORNER_RADIUS = 4;
    private static final int TRIGGER_WIDTH = 14;
    private static final int DEFAULT_CLOSE_TRANSITION_DURATION = 250;
    private static final int DEFAULT_CLOSE_TRANSITION_RATE = 30;

    public TerraListButtonSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.font = theme.getFont();
        this.color = theme.getColor(1);
        this.disabledColor = theme.getColor(7);
        this.backgroundColor = theme.getColor(10);
        this.disabledBackgroundColor = theme.getColor(10);
        this.borderColor = theme.getColor(7);
        this.disabledBorderColor = theme.getColor(7);
        this.padding = new Insets(2, 3, 2, 3);
        this.bevelColor = TerraTheme.brighten(this.backgroundColor);
        this.pressedBevelColor = TerraTheme.darken(this.backgroundColor);
        this.disabledBevelColor = this.disabledBackgroundColor;
        this.listViewPopup.getWindowStateListeners().add((Object)this.listViewPopupStateListener);
        this.listViewPanorama = new Panorama((Component)this.listView);
        this.listViewPanorama.getStyles().put("buttonBackgroundColor", this.listView.getStyles().get("backgroundColor"));
        this.listViewPanorama.getStyles().put("alwaysShowScrollButtons", (Object)true);
        this.listViewBorder = new Border((Component)this.listViewPanorama);
        this.listViewBorder.getStyles().put("padding", (Object)0);
        this.listViewBorder.getStyles().put("color", (Object)this.borderColor);
        this.listViewPopup.setContent((Component)this.listViewBorder);
        this.dropShadowDecorator = new DropShadowDecorator(3, 3, 3);
        this.listViewPopup.getDecorators().add((Decorator)this.dropShadowDecorator);
    }

    public int getPreferredWidth(int height) {
        ListButton listButton = (ListButton)this.getComponent();
        Button.DataRenderer dataRenderer = listButton.getDataRenderer();
        dataRenderer.render(listButton.getButtonData(), (Button)listButton, false);
        int preferredWidth = dataRenderer.getPreferredWidth(-1);
        List listData = listButton.getListData();
        for (Object item : listData) {
            dataRenderer.render(item, (Button)listButton, false);
            preferredWidth = Math.max(preferredWidth, dataRenderer.getPreferredWidth(-1));
        }
        return preferredWidth += 14 + this.padding.left + this.padding.right + 2;
    }

    public int getPreferredHeight(int width) {
        ListButton listButton = (ListButton)this.getComponent();
        Button.DataRenderer dataRenderer = listButton.getDataRenderer();
        dataRenderer.render(listButton.getButtonData(), (Button)listButton, false);
        int preferredHeight = dataRenderer.getPreferredHeight(-1) + this.padding.top + this.padding.bottom + 2;
        return preferredHeight;
    }

    public Dimensions getPreferredSize() {
        ListButton listButton = (ListButton)this.getComponent();
        Button.DataRenderer dataRenderer = listButton.getDataRenderer();
        dataRenderer.render(listButton.getButtonData(), (Button)listButton, false);
        Dimensions contentSize = dataRenderer.getPreferredSize();
        int preferredWidth = contentSize.width;
        int preferredHeight = contentSize.height + this.padding.top + this.padding.bottom + 2;
        List listData = listButton.getListData();
        for (Object item : listData) {
            dataRenderer.render(item, (Button)listButton, false);
            preferredWidth = Math.max(preferredWidth, dataRenderer.getPreferredWidth(-1));
        }
        return new Dimensions(preferredWidth += 14 + this.padding.left + this.padding.right + 2, preferredHeight);
    }

    public int getBaseline(int width, int height) {
        ListButton listButton = (ListButton)this.getComponent();
        Button.DataRenderer dataRenderer = listButton.getDataRenderer();
        dataRenderer.render(listButton.getButtonData(), (Button)listButton, false);
        int clientWidth = Math.max(width - (14 + this.padding.left + this.padding.right + 2), 0);
        int clientHeight = Math.max(height - (this.padding.top + this.padding.bottom + 2), 0);
        int baseline = dataRenderer.getBaseline(clientWidth, clientHeight);
        if (baseline != -1) {
            baseline += this.padding.top + 1;
        }
        return baseline;
    }

    public void layout() {
    }

    public void paint(Graphics2D graphics) {
        Point mouseLocation;
        ListButton listButton = (ListButton)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        Color colorLocal = null;
        Color backgroundColorLocal = null;
        Color bevelColorLocal = null;
        Color borderColorLocal = null;
        if (listButton.isEnabled()) {
            colorLocal = this.color;
            backgroundColorLocal = this.backgroundColor;
            bevelColorLocal = this.pressed || this.listViewPopup.isOpen() && !this.listViewPopup.isClosing() ? this.pressedBevelColor : this.bevelColor;
            borderColorLocal = this.borderColor;
        } else {
            colorLocal = this.disabledColor;
            backgroundColorLocal = this.disabledBackgroundColor;
            bevelColorLocal = this.disabledBevelColor;
            borderColorLocal = this.disabledBorderColor;
        }
        graphics.setStroke(new BasicStroke());
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(new GradientPaint((float)width / 2.0f, 0.0f, bevelColorLocal, (float)width / 2.0f, (float)height / 2.0f, backgroundColorLocal));
        graphics.fill(new RoundRectangle2D.Double(0.5, 0.5, width - 1, height - 1, 4.0, 4.0));
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Bounds contentBounds = new Bounds(0, 0, Math.max(width - 14 - 1, 0), Math.max(height - 1, 0));
        Button.DataRenderer dataRenderer = listButton.getDataRenderer();
        dataRenderer.render(listButton.getButtonData(), (Button)listButton, false);
        dataRenderer.setSize(Math.max(contentBounds.width - (this.padding.left + this.padding.right + 2) + 1, 0), Math.max(contentBounds.height - (this.padding.top + this.padding.bottom + 2) + 1, 0));
        Graphics2D contentGraphics = (Graphics2D)graphics.create();
        contentGraphics.translate(this.padding.left + 1, this.padding.top + 1);
        contentGraphics.clipRect(0, 0, dataRenderer.getWidth(), dataRenderer.getHeight());
        dataRenderer.paint(contentGraphics);
        contentGraphics.dispose();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(borderColorLocal);
        graphics.setStroke(new BasicStroke(1.0f));
        graphics.draw(new RoundRectangle2D.Double(0.5, 0.5, width - 1, height - 1, 4.0, 4.0));
        graphics.draw(new Line2D.Double(contentBounds.x + contentBounds.width, 0.5, contentBounds.x + contentBounds.width, contentBounds.height));
        if (listButton.isFocused()) {
            BasicStroke dashStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);
            graphics.setStroke(dashStroke);
            graphics.setColor(borderColorLocal);
            graphics.draw(new RoundRectangle2D.Double(2.5, 2.5, Math.max(contentBounds.width - 4, 0), Math.max(contentBounds.height - 4, 0), 2.0, 2.0));
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        GeneralPath triggerIconShape = new GeneralPath(0);
        triggerIconShape.moveTo(0.0f, 0.0f);
        triggerIconShape.lineTo(3.0f, 3.0f);
        triggerIconShape.lineTo(6.0f, 0.0f);
        triggerIconShape.closePath();
        Graphics2D triggerGraphics = (Graphics2D)graphics.create();
        triggerGraphics.setStroke(new BasicStroke(0.0f));
        triggerGraphics.setPaint(colorLocal);
        Bounds triggerBounds = this.getTriggerBounds();
        int tx = triggerBounds.x + Math.round((float)(triggerBounds.width - triggerIconShape.getBounds().width) / 2.0f) - 1;
        int ty = triggerBounds.y + Math.round((float)(triggerBounds.height - triggerIconShape.getBounds().height) / 2.0f) - 1;
        triggerGraphics.translate(tx, ty);
        triggerGraphics.draw(triggerIconShape);
        triggerGraphics.fill(triggerIconShape);
        triggerGraphics.dispose();
        if (listButton.isRepeatable() && (mouseLocation = listButton.getMouseLocation()) != null) {
            graphics.setPaint(new Color(0.0f, 0.0f, 0.0f, 0.25f));
            if (triggerBounds.contains(mouseLocation)) {
                graphics.clipRect(triggerBounds.x, triggerBounds.y, triggerBounds.width, height);
            } else {
                graphics.clipRect(0, 0, width - triggerBounds.width, height);
            }
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.fill(new RoundRectangle2D.Double(0.5, 0.5, width - 1, height - 1, 4.0, 4.0));
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public Bounds getTriggerBounds() {
        int width = this.getWidth();
        int height = this.getHeight();
        return new Bounds(Math.max(width - 15, 0), 0, 15, Math.max(height, 0));
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraListButtonSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public final void setColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setColor(theme.getColor(color));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public final void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public final void setDisabledColor(int disabledColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(theme.getColor(disabledColor));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.backgroundColor = backgroundColor;
        this.bevelColor = TerraTheme.brighten(backgroundColor);
        this.pressedBevelColor = TerraTheme.darken(backgroundColor);
        this.repaintComponent();
    }

    public final void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)backgroundColor));
    }

    public final void setBackgroundColor(int backgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(backgroundColor));
    }

    public Color getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    public void setDisabledBackgroundColor(Color disabledBackgroundColor) {
        if (disabledBackgroundColor == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.disabledBackgroundColor = disabledBackgroundColor;
        this.disabledBevelColor = disabledBackgroundColor;
        this.repaintComponent();
    }

    public final void setDisabledBackgroundColor(String disabledBackgroundColor) {
        if (disabledBackgroundColor == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.setDisabledBackgroundColor(GraphicsUtilities.decodeColor((String)disabledBackgroundColor));
    }

    public final void setDisabledBackgroundColor(int disabledBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledBackgroundColor(theme.getColor(disabledBackgroundColor));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = borderColor;
        this.listViewBorder.getStyles().put("color", (Object)borderColor);
        this.repaintComponent();
    }

    public final void setBorderColor(String borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)borderColor));
    }

    public final void setBorderColor(int borderColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBorderColor(theme.getColor(borderColor));
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color disabledBorderColor) {
        if (disabledBorderColor == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.disabledBorderColor = disabledBorderColor;
        this.repaintComponent();
    }

    public final void setDisabledBorderColor(String disabledBorderColor) {
        if (disabledBorderColor == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.setDisabledBorderColor(GraphicsUtilities.decodeColor((String)disabledBorderColor));
    }

    public final void setDisabledBorderColor(int disabledBorderColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledBorderColor(theme.getColor(disabledBorderColor));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)padding));
    }

    public int getCloseTransitionDuration() {
        return this.closeTransitionDuration;
    }

    public void setCloseTransitionDuration(int closeTransitionDuration) {
        this.closeTransitionDuration = closeTransitionDuration;
    }

    public int getCloseTransitionRate() {
        return this.closeTransitionRate;
    }

    public void setCloseTransitionRate(int closeTransitionRate) {
        this.closeTransitionRate = closeTransitionRate;
    }

    public Object getListFont() {
        return this.listView.getStyles().get("font");
    }

    public void setListFont(Object listFont) {
        this.listView.getStyles().put("font", listFont);
    }

    public Object getListColor() {
        return this.listView.getStyles().get("color");
    }

    public void setListColor(Object listColor) {
        this.listView.getStyles().put("color", listColor);
    }

    public Object getListDisabledColor() {
        return this.listView.getStyles().get("disabledColor");
    }

    public void setListDisabledColor(Object listDisabledColor) {
        this.listView.getStyles().put("disabledColor", listDisabledColor);
    }

    public Object getListBackgroundColor() {
        return this.listView.getStyles().get("backgroundColor");
    }

    public void setListBackgroundColor(Object listBackgroundColor) {
        this.listView.getStyles().put("backgroundColor", listBackgroundColor);
        this.listViewPanorama.getStyles().put("buttonBackgroundColor", listBackgroundColor);
    }

    public Object getListSelectionColor() {
        return this.listView.getStyles().get("selectionColor");
    }

    public void setListSelectionColor(Object listSelectionColor) {
        this.listView.getStyles().put("selectionColor", listSelectionColor);
    }

    public Object getListSelectionBackgroundColor() {
        return this.listView.getStyles().get("selectionBackgroundColor");
    }

    public void setListSelectionBackgroundColor(Object listSelectionBackgroundColor) {
        this.listView.getStyles().put("selectionBackgroundColor", listSelectionBackgroundColor);
    }

    public Object getListInactiveSelectionColor() {
        return this.listView.getStyles().get("inactiveSelectionColor");
    }

    public void setListInactiveSelectionColor(Object listInactiveSelectionColor) {
        this.listView.getStyles().put("inactiveSelectionColor", listInactiveSelectionColor);
    }

    public Object getListInactiveSelectionBackgroundColor() {
        return this.listView.getStyles().get("inactiveSelectionBackgroundColor");
    }

    public void setListInactiveSelectionBackgroundColor(Object listInactiveSelectionBackgroundColor) {
        this.listView.getStyles().put("inactiveSelectionBackgroundColor", listInactiveSelectionBackgroundColor);
    }

    public Object getListHighlightColor() {
        return this.listView.getStyles().get("highlightColor");
    }

    public void setListHighlightColor(Object listHighlightColor) {
        this.listView.getStyles().put("highlightColor", listHighlightColor);
    }

    public Object getListHighlightBackgroundColor() {
        return this.listView.getStyles().get("highlightBackgroundColor");
    }

    public void setListHighlightBackgroundColor(Object listHighlightBackgroundColor) {
        this.listView.getStyles().put("highlightBackgroundColor", listHighlightBackgroundColor);
    }

    public boolean mouseMove(Component component, int x, int y) {
        boolean consumed = super.mouseMove(component, x, y);
        ListButton listButton = (ListButton)component;
        if (listButton.isRepeatable()) {
            this.repaintComponent();
        }
        return consumed;
    }
}

