/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseListener;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Panorama;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Viewport;
import org.apache.pivot.wtk.ViewportListener;
import org.apache.pivot.wtk.content.ButtonDataRenderer;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ButtonSkin;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraPanoramaSkin
extends ContainerSkin
implements Viewport.Skin,
ViewportListener {
    private Color buttonColor;
    private Color buttonBackgroundColor;
    private int buttonPadding;
    private boolean alwaysShowScrollButtons = false;
    private ScrollButton northButton = new ScrollButton((Object)new NorthButtonImage());
    private ScrollButton southButton = new ScrollButton((Object)new SouthButtonImage());
    private ScrollButton eastButton = new ScrollButton((Object)new EastButtonImage());
    private ScrollButton westButton = new ScrollButton((Object)new WestButtonImage());
    private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new ButtonDataRenderer();
    private ComponentMouseListener buttonMouseListener = new ComponentMouseListener.Adapter(){

        public void mouseOver(Component component) {
            TerraPanoramaSkin.this.scrollDistance = 10.0f;
            TerraPanoramaSkin.this.scheduledScrollCallback = ApplicationContext.scheduleRecurringCallback((Runnable)TerraPanoramaSkin.this.scrollCallback, (long)50L);
        }

        public void mouseOut(Component component) {
            if (TerraPanoramaSkin.this.scheduledScrollCallback != null) {
                TerraPanoramaSkin.this.scheduledScrollCallback.cancel();
                TerraPanoramaSkin.this.scheduledScrollCallback = null;
            }
        }
    };
    private float scrollDistance = 0.0f;
    private ScrollCallback scrollCallback = new ScrollCallback();
    private ApplicationContext.ScheduledCallback scheduledScrollCallback = null;
    private static final int SCROLL_RATE = 50;
    private static final float INITIAL_SCROLL_DISTANCE = 10.0f;
    private static final float SCROLL_ACCELERATION = 1.06f;
    private static final float MAXIMUM_SCROLL_DISTANCE = 150.0f;
    private static final int BUTTON_SIZE = 7;

    public TerraPanoramaSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.buttonColor = theme.getColor(1);
        this.buttonBackgroundColor = null;
        this.buttonPadding = 4;
    }

    public void install(Component component) {
        super.install(component);
        Panorama panorama = (Panorama)component;
        panorama.getViewportListeners().add((Object)this);
        panorama.add((Component)this.northButton);
        this.northButton.getComponentMouseListeners().add((Object)this.buttonMouseListener);
        panorama.add((Component)this.southButton);
        this.southButton.getComponentMouseListeners().add((Object)this.buttonMouseListener);
        panorama.add((Component)this.eastButton);
        this.eastButton.getComponentMouseListeners().add((Object)this.buttonMouseListener);
        panorama.add((Component)this.westButton);
        this.westButton.getComponentMouseListeners().add((Object)this.buttonMouseListener);
        this.updateScrollButtonVisibility();
    }

    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        Panorama panorama = (Panorama)this.getComponent();
        Component view = panorama.getView();
        if (view != null) {
            preferredWidth = view.getPreferredWidth(height);
        }
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        Panorama panorama = (Panorama)this.getComponent();
        Component view = panorama.getView();
        if (view != null) {
            preferredHeight = view.getPreferredHeight(width);
        }
        return preferredHeight;
    }

    public Dimensions getPreferredSize() {
        Dimensions preferredSize = null;
        Panorama panorama = (Panorama)this.getComponent();
        Component view = panorama.getView();
        preferredSize = view == null ? new Dimensions(0, 0) : view.getPreferredSize();
        return preferredSize;
    }

    public void layout() {
        Panorama panorama = (Panorama)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        Component view = panorama.getView();
        if (view != null) {
            Dimensions viewSize = view.getPreferredSize();
            view.setSize(Math.max(width, viewSize.width), Math.max(height, viewSize.height));
            int viewWidth = view.getWidth();
            int viewHeight = view.getHeight();
            int maxScrollTop = this.getMaxScrollTop();
            if (panorama.getScrollTop() > maxScrollTop) {
                panorama.setScrollTop(maxScrollTop);
            }
            int maxScrollLeft = this.getMaxScrollLeft();
            if (panorama.getScrollLeft() > maxScrollLeft) {
                panorama.setScrollLeft(maxScrollLeft);
            }
            if (width < viewWidth) {
                this.eastButton.setSize(this.eastButton.getPreferredWidth(), height);
                this.eastButton.setLocation(width - this.eastButton.getWidth(), 0);
                this.westButton.setSize(this.westButton.getPreferredWidth(), height);
                this.westButton.setLocation(0, 0);
            }
            if (height < viewHeight) {
                this.northButton.setSize(width, this.northButton.getPreferredHeight());
                this.northButton.setLocation(0, 0);
                this.southButton.setSize(width, this.southButton.getPreferredHeight());
                this.southButton.setLocation(0, height - this.southButton.getHeight());
            }
        }
        this.updateScrollButtonVisibility();
    }

    public Bounds getViewportBounds() {
        int x = 0;
        int y = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.buttonBackgroundColor != null) {
            if (this.northButton.isVisible()) {
                int northButtonHeight = this.northButton.getHeight();
                y += northButtonHeight;
                height -= northButtonHeight;
            }
            if (this.southButton.isVisible()) {
                height -= this.southButton.getHeight();
            }
            if (this.eastButton.isVisible()) {
                width -= this.eastButton.getWidth();
            }
            if (this.westButton.isVisible()) {
                int westButtonWidth = this.westButton.getWidth();
                x += westButtonWidth;
                width -= westButtonWidth;
            }
        }
        return new Bounds(x, y, width, height);
    }

    public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
        boolean consumed = false;
        Panorama panorama = (Panorama)this.getComponent();
        Component view = panorama.getView();
        if (view != null) {
            if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                int previousScrollLeft = panorama.getScrollLeft();
                int newScrollLeft = previousScrollLeft + scrollAmount * wheelRotation * 10;
                if (wheelRotation > 0) {
                    int maxScrollLeft = this.getMaxScrollLeft();
                    newScrollLeft = Math.min(newScrollLeft, maxScrollLeft);
                    if (previousScrollLeft < maxScrollLeft) {
                        consumed = true;
                    }
                } else {
                    newScrollLeft = Math.max(newScrollLeft, 0);
                    if (previousScrollLeft > 0) {
                        consumed = true;
                    }
                }
                panorama.setScrollLeft(newScrollLeft);
            } else {
                int previousScrollTop = panorama.getScrollTop();
                int newScrollTop = previousScrollTop + scrollAmount * wheelRotation * 10;
                if (wheelRotation > 0) {
                    int maxScrollTop = this.getMaxScrollTop();
                    newScrollTop = Math.min(newScrollTop, maxScrollTop);
                    if (previousScrollTop < maxScrollTop) {
                        consumed = true;
                    }
                } else {
                    newScrollTop = Math.max(newScrollTop, 0);
                    if (previousScrollTop > 0) {
                        consumed = true;
                    }
                }
                panorama.setScrollTop(newScrollTop);
            }
        }
        return consumed;
    }

    public Color getButtonColor() {
        return this.buttonColor;
    }

    public void setButtonColor(Color buttonColor) {
        if (buttonColor == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.buttonColor = buttonColor;
        this.repaintComponent();
    }

    public final void setButtonColor(String buttonColor) {
        if (buttonColor == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.setButtonColor(GraphicsUtilities.decodeColor((String)buttonColor));
    }

    public Color getButtonBackgroundColor() {
        return this.buttonBackgroundColor;
    }

    public void setButtonBackgroundColor(Color buttonBackgroundColor) {
        if (buttonBackgroundColor == null) {
            throw new IllegalArgumentException("buttonBackgroundColor is null.");
        }
        this.buttonBackgroundColor = buttonBackgroundColor;
        this.repaintComponent();
    }

    public final void setButtonBackgroundColor(String buttonBackgroundColor) {
        if (buttonBackgroundColor == null) {
            throw new IllegalArgumentException("buttonBackgroundColor is null.");
        }
        this.setButtonBackgroundColor(GraphicsUtilities.decodeColor((String)buttonBackgroundColor));
    }

    public final void setButtonBackgroundColor(int buttonBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setButtonBackgroundColor(theme.getColor(buttonBackgroundColor));
    }

    public int getButtonPadding() {
        return this.buttonPadding;
    }

    public void setButtonPadding(int buttonPadding) {
        if (buttonPadding < 0) {
            throw new IllegalArgumentException("buttonPadding is negative.");
        }
        this.buttonPadding = buttonPadding;
        this.invalidateComponent();
    }

    public final void setButtonPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("buttonPadding is null.");
        }
        this.setButtonPadding(padding.intValue());
    }

    public boolean getAlwaysShowScrollButtons() {
        return this.alwaysShowScrollButtons;
    }

    public void setAlwaysShowScrollButtons(boolean alwaysShowScrollButtons) {
        this.alwaysShowScrollButtons = alwaysShowScrollButtons;
        this.updateScrollButtonVisibility();
    }

    protected int getMaxScrollTop() {
        int maxScrollTop = 0;
        Panorama panorama = (Panorama)this.getComponent();
        int height = this.getHeight();
        Component view = panorama.getView();
        if (view != null) {
            maxScrollTop = Math.max(view.getHeight() - height, 0);
        }
        return maxScrollTop;
    }

    protected int getMaxScrollLeft() {
        int maxScrollLeft = 0;
        Panorama panorama = (Panorama)this.getComponent();
        int width = this.getWidth();
        Component view = panorama.getView();
        if (view != null) {
            maxScrollLeft = Math.max(view.getWidth() - width, 0);
        }
        return maxScrollLeft;
    }

    protected void updateScrollButtonVisibility() {
        Panorama panorama = (Panorama)this.getComponent();
        boolean mouseOver = panorama.isMouseOver();
        int scrollTop = panorama.getScrollTop();
        int maxScrollTop = this.getMaxScrollTop();
        this.northButton.setVisible((this.alwaysShowScrollButtons || mouseOver) && scrollTop > 0);
        this.southButton.setVisible((this.alwaysShowScrollButtons || mouseOver) && scrollTop < maxScrollTop);
        int scrollLeft = panorama.getScrollLeft();
        int maxScrollLeft = this.getMaxScrollLeft();
        this.westButton.setVisible((this.alwaysShowScrollButtons || mouseOver) && scrollLeft > 0);
        this.eastButton.setVisible((this.alwaysShowScrollButtons || mouseOver) && scrollLeft < maxScrollLeft);
    }

    public void mouseOver(Component component) {
        super.mouseOver(component);
        this.updateScrollButtonVisibility();
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.updateScrollButtonVisibility();
    }

    public void scrollTopChanged(Viewport panorama, int previousScrollTop) {
        Component view = panorama.getView();
        if (view != null) {
            int maxScrollTop = this.getMaxScrollTop();
            int scrollTop = Math.min(panorama.getScrollTop(), maxScrollTop);
            view.setLocation(view.getX(), -scrollTop);
            this.updateScrollButtonVisibility();
        }
    }

    public void scrollLeftChanged(Viewport panorama, int previousScrollLeft) {
        Component view = panorama.getView();
        if (view != null) {
            int maxScrollLeft = this.getMaxScrollLeft();
            int scrollLeft = Math.min(panorama.getScrollLeft(), maxScrollLeft);
            view.setLocation(-scrollLeft, view.getY());
            this.updateScrollButtonVisibility();
        }
    }

    public void viewChanged(Viewport panorama, Component previousView) {
        this.invalidateComponent();
    }

    private class ScrollCallback
    implements Runnable {
        private ScrollCallback() {
        }

        @Override
        public void run() {
            Panorama panorama = (Panorama)TerraPanoramaSkin.this.getComponent();
            if (TerraPanoramaSkin.this.northButton.isMouseOver()) {
                int scrollTop = Math.max(panorama.getScrollTop() - (int)TerraPanoramaSkin.this.scrollDistance, 0);
                if (scrollTop == 0 && TerraPanoramaSkin.this.scheduledScrollCallback != null) {
                    TerraPanoramaSkin.this.scheduledScrollCallback.cancel();
                    TerraPanoramaSkin.this.scheduledScrollCallback = null;
                }
                panorama.setScrollTop(scrollTop);
            } else if (TerraPanoramaSkin.this.southButton.isMouseOver()) {
                int maxScrollTop = TerraPanoramaSkin.this.getMaxScrollTop();
                int scrollTop = Math.min(panorama.getScrollTop() + (int)TerraPanoramaSkin.this.scrollDistance, maxScrollTop);
                if (scrollTop == maxScrollTop && TerraPanoramaSkin.this.scheduledScrollCallback != null) {
                    TerraPanoramaSkin.this.scheduledScrollCallback.cancel();
                    TerraPanoramaSkin.this.scheduledScrollCallback = null;
                }
                panorama.setScrollTop(scrollTop);
            } else if (TerraPanoramaSkin.this.eastButton.isMouseOver()) {
                int maxScrollLeft = TerraPanoramaSkin.this.getMaxScrollLeft();
                int scrollLeft = Math.min(panorama.getScrollLeft() + (int)TerraPanoramaSkin.this.scrollDistance, maxScrollLeft);
                if (scrollLeft == maxScrollLeft && TerraPanoramaSkin.this.scheduledScrollCallback != null) {
                    TerraPanoramaSkin.this.scheduledScrollCallback.cancel();
                    TerraPanoramaSkin.this.scheduledScrollCallback = null;
                }
                panorama.setScrollLeft(scrollLeft);
            } else if (TerraPanoramaSkin.this.westButton.isMouseOver()) {
                int scrollLeft = Math.max(panorama.getScrollLeft() - (int)TerraPanoramaSkin.this.scrollDistance, 0);
                if (scrollLeft == 0 && TerraPanoramaSkin.this.scheduledScrollCallback != null) {
                    TerraPanoramaSkin.this.scheduledScrollCallback.cancel();
                    TerraPanoramaSkin.this.scheduledScrollCallback = null;
                }
                panorama.setScrollLeft(scrollLeft);
            }
            TerraPanoramaSkin.this.scrollDistance = Math.min(TerraPanoramaSkin.this.scrollDistance * 1.06f, 150.0f);
        }
    }

    public class ScrollButtonSkin
    extends ButtonSkin {
        public int getPreferredWidth(int height) {
            return 7 + TerraPanoramaSkin.this.buttonPadding;
        }

        public int getPreferredHeight(int width) {
            return 7 + TerraPanoramaSkin.this.buttonPadding;
        }

        public Dimensions getPreferredSize() {
            return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
        }

        public void paint(Graphics2D graphics) {
            ScrollButton scrollButton = (ScrollButton)this.getComponent();
            int width = this.getWidth();
            int height = this.getHeight();
            if (TerraPanoramaSkin.this.buttonBackgroundColor != null) {
                graphics.setColor(TerraPanoramaSkin.this.buttonBackgroundColor);
                graphics.fillRect(0, 0, width, height);
            }
            Button.DataRenderer dataRenderer = scrollButton.getDataRenderer();
            dataRenderer.render(scrollButton.getButtonData(), (Button)scrollButton, false);
            dataRenderer.setSize(width - TerraPanoramaSkin.this.buttonPadding * 2, height - TerraPanoramaSkin.this.buttonPadding * 2);
            graphics.translate(TerraPanoramaSkin.this.buttonPadding, TerraPanoramaSkin.this.buttonPadding);
            dataRenderer.paint(graphics);
        }

        public boolean isFocusable() {
            return false;
        }
    }

    protected class ScrollButton
    extends Button {
        public ScrollButton(Object buttonData) {
            super(buttonData);
            this.setDataRenderer(DEFAULT_DATA_RENDERER);
            this.setSkin((Skin)new ScrollButtonSkin());
        }

        public void setToggleButton(boolean toggleButton) {
            throw new UnsupportedOperationException("Link buttons cannot be toggle buttons.");
        }
    }

    protected class WestButtonImage
    extends ScrollButtonImage {
        protected WestButtonImage() {
        }

        @Override
        public void paint(Graphics2D graphics) {
            super.paint(graphics);
            int[] xPoints = new int[]{5, 1, 5};
            int[] yPoints = new int[]{0, 3, 6};
            graphics.fillPolygon(xPoints, yPoints, 3);
            graphics.drawPolygon(xPoints, yPoints, 3);
        }
    }

    protected class EastButtonImage
    extends ScrollButtonImage {
        protected EastButtonImage() {
        }

        @Override
        public void paint(Graphics2D graphics) {
            super.paint(graphics);
            int[] xPoints = new int[]{1, 5, 1};
            int[] yPoints = new int[]{0, 3, 6};
            graphics.fillPolygon(xPoints, yPoints, 3);
            graphics.drawPolygon(xPoints, yPoints, 3);
        }
    }

    protected class SouthButtonImage
    extends ScrollButtonImage {
        protected SouthButtonImage() {
        }

        @Override
        public void paint(Graphics2D graphics) {
            super.paint(graphics);
            int[] xPoints = new int[]{0, 3, 6};
            int[] yPoints = new int[]{1, 5, 1};
            graphics.fillPolygon(xPoints, yPoints, 3);
            graphics.drawPolygon(xPoints, yPoints, 3);
        }
    }

    protected class NorthButtonImage
    extends ScrollButtonImage {
        protected NorthButtonImage() {
        }

        @Override
        public void paint(Graphics2D graphics) {
            super.paint(graphics);
            int[] xPoints = new int[]{0, 3, 6};
            int[] yPoints = new int[]{5, 1, 5};
            graphics.fillPolygon(xPoints, yPoints, 3);
            graphics.drawPolygon(xPoints, yPoints, 3);
        }
    }

    protected abstract class ScrollButtonImage
    extends Image {
        protected ScrollButtonImage() {
        }

        public int getWidth() {
            return 7;
        }

        public int getHeight() {
            return 7;
        }

        public void paint(Graphics2D graphics) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setStroke(new BasicStroke(0.0f));
            graphics.setPaint(TerraPanoramaSkin.this.buttonColor);
        }
    }
}

