/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Rollup;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.effects.easing.Easing;
import org.apache.pivot.wtk.effects.easing.Quadratic;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.RollupSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraRollupSkin
extends RollupSkin {
    private RollupButton rollupButton = null;
    private Color buttonColor;
    private Color disabledButtonColor;
    private int spacing;
    private int buffer;
    private boolean fill;
    private boolean headingToggles;
    private int expandDuration = 250;
    private int expandRate = 30;
    private ExpandTransition expandTransition = null;
    private ComponentMouseButtonListener headingMouseButtonListener = new ComponentMouseButtonListener.Adapter(){

        public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
            boolean consumed = false;
            Rollup rollup = (Rollup)TerraRollupSkin.this.getComponent();
            if (TerraRollupSkin.this.headingToggles && rollup.isCollapsible()) {
                rollup.setExpanded(!rollup.isExpanded());
                consumed = true;
            }
            return consumed;
        }
    };
    private static final int DEFAULT_EXPAND_DURATION = 250;
    private static final int DEFAULT_EXPAND_RATE = 30;

    public TerraRollupSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.buttonColor = theme.getColor(1);
        this.disabledButtonColor = theme.getColor(7);
        this.spacing = 4;
        this.buffer = 4;
        this.fill = false;
        this.headingToggles = true;
    }

    public void install(Component component) {
        super.install(component);
        Rollup rollup = (Rollup)component;
        this.rollupButton = new RollupButton();
        rollup.add((Component)this.rollupButton);
        this.headingChanged(rollup, null);
        this.contentChanged(rollup, null);
        this.collapsibleChanged(rollup);
    }

    public int getPreferredWidth(int height) {
        Rollup rollup = (Rollup)this.getComponent();
        Component heading = rollup.getHeading();
        Component content = rollup.getContent();
        int preferredWidth = 0;
        if (heading != null) {
            preferredWidth = heading.getPreferredWidth(-1);
        }
        if (content != null && (rollup.isExpanded() || this.expandTransition != null && !this.expandTransition.isReversed())) {
            preferredWidth = Math.max(preferredWidth, content.getPreferredWidth(-1));
        }
        return preferredWidth += this.rollupButton.getPreferredWidth(-1) + this.buffer;
    }

    public int getPreferredHeight(int width) {
        Rollup rollup = (Rollup)this.getComponent();
        Component heading = rollup.getHeading();
        Component content = rollup.getContent();
        int preferredHeight = 0;
        width = this.fill && width >= 0 ? Math.max(width - this.rollupButton.getPreferredWidth(-1) - this.buffer, 0) : -1;
        if (heading != null) {
            preferredHeight += heading.getPreferredHeight(width);
        }
        if (content != null) {
            if (this.expandTransition == null) {
                if (rollup.isExpanded()) {
                    preferredHeight += this.spacing + content.getPreferredHeight(width);
                }
            } else {
                float scale = this.expandTransition.getScale();
                preferredHeight += (int)(scale * (float)(this.spacing + content.getPreferredHeight(width)));
            }
        }
        preferredHeight = Math.max(preferredHeight, this.rollupButton.getPreferredHeight(-1));
        return preferredHeight;
    }

    public int getBaseline(int width, int height) {
        Rollup rollup = (Rollup)this.getComponent();
        Component heading = rollup.getHeading();
        int baseline = -1;
        if (heading != null) {
            int headingHeight;
            int headingWidth;
            if (this.fill) {
                headingWidth = Math.max(width - this.rollupButton.getPreferredWidth(-1) - this.buffer, 0);
                headingHeight = heading.getPreferredHeight(headingWidth);
            } else {
                Dimensions headingPreferredSize = heading.getPreferredSize();
                headingWidth = headingPreferredSize.width;
                headingHeight = headingPreferredSize.height;
            }
            baseline = heading.getBaseline(headingWidth, headingHeight);
        }
        return baseline;
    }

    public void layout() {
        Rollup rollup = (Rollup)this.getComponent();
        Component heading = rollup.getHeading();
        Component content = rollup.getContent();
        Dimensions rollupButtonSize = this.rollupButton.getPreferredSize();
        this.rollupButton.setSize(rollupButtonSize.width, rollupButtonSize.height);
        int x = rollupButtonSize.width + this.buffer;
        int y = 0;
        int justifiedWidth = Math.max(this.getWidth() - rollupButtonSize.width - this.buffer, 0);
        if (heading != null) {
            int headingHeight;
            int headingWidth;
            if (this.fill) {
                headingWidth = justifiedWidth;
                headingHeight = heading.getPreferredHeight(headingWidth);
            } else {
                Dimensions headingPreferredSize = heading.getPreferredSize();
                headingWidth = headingPreferredSize.width;
                headingHeight = headingPreferredSize.height;
            }
            heading.setLocation(x, y);
            heading.setSize(headingWidth, headingHeight);
            y += headingHeight + this.spacing;
        }
        if (content != null) {
            if (rollup.isExpanded() || this.expandTransition != null && !this.expandTransition.isReversed()) {
                int contentHeight;
                int contentWidth;
                if (this.fill) {
                    contentWidth = justifiedWidth;
                    contentHeight = content.getPreferredHeight(contentWidth);
                } else {
                    Dimensions contentPreferredSize = content.getPreferredSize();
                    contentWidth = contentPreferredSize.width;
                    contentHeight = contentPreferredSize.height;
                }
                content.setLocation(x, y);
                content.setSize(contentWidth, contentHeight);
                content.setVisible(true);
            } else {
                content.setVisible(false);
            }
        }
        y = heading == null ? 0 : (heading.getHeight() - rollupButtonSize.height) / 2 + 1;
        this.rollupButton.setLocation(0, y);
    }

    public Color getButtonColor() {
        return this.buttonColor;
    }

    public final void setButtonColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setButtonColor(theme.getColor(color));
    }

    public void setButtonColor(Color buttonColor) {
        if (buttonColor == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.buttonColor = buttonColor;
        this.rollupButton.repaint();
    }

    public final void setButtonColor(String buttonColor) {
        if (buttonColor == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.setButtonColor(GraphicsUtilities.decodeColor((String)buttonColor));
    }

    public Color getDisabledButtonColor() {
        return this.disabledButtonColor;
    }

    public final void setDisabledButtonColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledButtonColor(theme.getColor(color));
    }

    public void setDisabledButtonColor(Color buttonColor) {
        if (buttonColor == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.disabledButtonColor = buttonColor;
        this.rollupButton.repaint();
    }

    public final void setDisabledButtonColor(String buttonColor) {
        if (buttonColor == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.setDisabledButtonColor(GraphicsUtilities.decodeColor((String)buttonColor));
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        if (spacing < 0) {
            throw new IllegalArgumentException("spacing is negative.");
        }
        this.spacing = spacing;
        Rollup rollup = (Rollup)this.getComponent();
        if (rollup.isExpanded()) {
            this.invalidateComponent();
        }
    }

    public int getBuffer() {
        return this.buffer;
    }

    public void setBuffer(int buffer) {
        this.buffer = buffer;
        this.invalidateComponent();
    }

    public boolean getFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
        this.invalidateComponent();
    }

    public boolean getHeadingToggles() {
        return this.headingToggles;
    }

    public void setHeadingToggles(boolean headingToggles) {
        this.headingToggles = headingToggles;
    }

    public int getExpandDuration() {
        return this.expandDuration;
    }

    public void setExpandDuration(int expandDuration) {
        this.expandDuration = expandDuration;
    }

    public int getExpandRate() {
        return this.expandRate;
    }

    public void setExpandRate(int expandRate) {
        this.expandRate = expandRate;
    }

    public void headingChanged(Rollup rollup, Component previousHeading) {
        Component heading;
        if (previousHeading != null) {
            previousHeading.getComponentMouseButtonListeners().remove((Object)this.headingMouseButtonListener);
        }
        if ((heading = rollup.getHeading()) != null) {
            heading.getComponentMouseButtonListeners().add((Object)this.headingMouseButtonListener);
        }
        this.invalidateComponent();
    }

    public void contentChanged(Rollup rollup, Component previousContent) {
        this.invalidateComponent();
    }

    public Vote previewExpandedChange(final Rollup rollup) {
        if (rollup.isShowing() && this.expandTransition == null && rollup.getContent() != null) {
            final boolean expanded = rollup.isExpanded();
            this.expandTransition = new ExpandTransition(expanded);
            this.expandTransition.start(new TransitionListener(){

                public void transitionCompleted(Transition transition) {
                    rollup.setExpanded(!expanded);
                    TerraRollupSkin.this.expandTransition = null;
                }
            });
        }
        Vote vote = this.expandTransition == null || !this.expandTransition.isRunning() ? Vote.APPROVE : Vote.DEFER;
        return vote;
    }

    public void expandedChangeVetoed(Rollup rollup, Vote reason) {
        if (reason == Vote.DENY && this.expandTransition != null) {
            this.expandTransition.stop();
            this.expandTransition = null;
            this.invalidateComponent();
        }
    }

    public void expandedChanged(Rollup rollup) {
        this.invalidateComponent();
    }

    public void collapsibleChanged(Rollup rollup) {
        if (rollup.isCollapsible()) {
            this.rollupButton.setCursor(Cursor.HAND);
        } else {
            this.rollupButton.setCursor(Cursor.DEFAULT);
        }
        this.invalidateComponent();
    }

    protected class RollupButtonSkin
    extends ComponentSkin {
        protected RollupButtonSkin() {
        }

        public boolean isFocusable() {
            return false;
        }

        public int getPreferredWidth(int height) {
            return 7;
        }

        public int getPreferredHeight(int width) {
            return 7;
        }

        public Dimensions getPreferredSize() {
            return new Dimensions(7, 7);
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics) {
            Rollup rollup = (Rollup)TerraRollupSkin.this.getComponent();
            graphics.setStroke(new BasicStroke(0.0f));
            if (rollup.isEnabled()) {
                graphics.setPaint(TerraRollupSkin.this.buttonColor);
            } else {
                graphics.setPaint(TerraRollupSkin.this.disabledButtonColor);
            }
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (rollup.isCollapsible()) {
                if (rollup.isExpanded()) {
                    int[] xPoints = new int[]{0, 3, 6};
                    int[] yPoints = new int[]{0, 6, 0};
                    graphics.fillPolygon(xPoints, yPoints, 3);
                    graphics.drawPolygon(xPoints, yPoints, 3);
                } else {
                    int[] xPoints = new int[]{0, 6, 0};
                    int[] yPoints = new int[]{0, 3, 6};
                    graphics.fillPolygon(xPoints, yPoints, 3);
                    graphics.drawPolygon(xPoints, yPoints, 3);
                }
            } else {
                RoundRectangle2D.Double shape = new RoundRectangle2D.Double(1.0, 1.0, 4.0, 4.0, 2.0, 2.0);
                graphics.draw(shape);
                graphics.fill(shape);
            }
        }

        public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
            Rollup rollup;
            rollup.setExpanded(!(rollup = (Rollup)TerraRollupSkin.this.getComponent()).isExpanded());
            return true;
        }
    }

    protected class RollupButton
    extends Component {
        public RollupButton() {
            this.setSkin((Skin)new RollupButtonSkin());
        }
    }

    public class ExpandTransition
    extends Transition {
        private Easing easing;

        public ExpandTransition(boolean reversed) {
            super(TerraRollupSkin.this.expandDuration, TerraRollupSkin.this.expandRate, false, reversed);
            this.easing = new Quadratic();
        }

        public float getScale() {
            int elapsedTime = this.getElapsedTime();
            int duration = this.getDuration();
            float scale = this.isReversed() ? this.easing.easeIn((float)elapsedTime, 0.0f, 1.0f, (float)duration) : this.easing.easeOut((float)elapsedTime, 0.0f, 1.0f, (float)duration);
            return scale;
        }

        public void start(TransitionListener transitionListener) {
            TerraRollupSkin.this.getComponent().setEnabled(false);
            super.start(transitionListener);
        }

        public void stop() {
            TerraRollupSkin.this.getComponent().setEnabled(true);
            super.stop();
        }

        protected void update() {
            TerraRollupSkin.this.invalidateComponent();
        }
    }
}

