/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Slider;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.SliderSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraSliderSkin
extends SliderSkin {
    private Thumb thumb = new Thumb();
    Point dragOffset = null;
    private Color trackColor;
    private int trackWidth;
    private Color buttonBackgroundColor;
    private Color buttonBorderColor;
    private int thumbWidth;
    private int thumbHeight;
    private int tickSpacing;
    private Color buttonBevelColor;
    public static final int DEFAULT_WIDTH = 120;
    public static final int MINIMUM_THUMB_WIDTH = 4;
    public static final int MINIMUM_THUMB_HEIGHT = 4;
    private static final BasicStroke dashStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);

    public TerraSliderSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.trackColor = theme.getColor(6);
        this.trackWidth = 2;
        this.buttonBackgroundColor = theme.getColor(10);
        this.buttonBorderColor = theme.getColor(7);
        this.buttonBevelColor = TerraTheme.brighten(this.buttonBackgroundColor);
        this.thumbWidth = 8;
        this.thumbHeight = 16;
        this.tickSpacing = -1;
    }

    public void install(Component component) {
        super.install(component);
        Slider slider = (Slider)component;
        slider.add((Component)this.thumb);
    }

    public int getPreferredWidth(int height) {
        Slider slider = (Slider)this.getComponent();
        int preferredWidth = slider.getOrientation() == Orientation.HORIZONTAL ? 120 : this.thumbHeight;
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        Slider slider = (Slider)this.getComponent();
        int preferredHeight = slider.getOrientation() == Orientation.HORIZONTAL ? this.thumbHeight : 120;
        return preferredHeight;
    }

    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    public void layout() {
        Slider slider = (Slider)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        int start = slider.getStart();
        int end = slider.getEnd();
        int value = slider.getValue();
        float ratio = (float)(value - start) / (float)(end - start);
        if (slider.getOrientation() == Orientation.HORIZONTAL) {
            this.thumb.setSize(this.thumbWidth, this.thumbHeight);
            this.thumb.setLocation((int)((float)(width - this.thumbWidth) * ratio), (height - this.thumbHeight) / 2);
        } else {
            this.thumb.setSize(this.thumbHeight, this.thumbWidth);
            this.thumb.setLocation((width - this.thumbHeight) / 2, (int)((float)(height - this.thumbWidth) * ratio));
        }
    }

    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        Slider slider = (Slider)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        graphics.setColor(this.trackColor);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (slider.getOrientation() == Orientation.HORIZONTAL) {
            graphics.fillRect(0, (height - this.trackWidth) / 2, width, this.trackWidth);
            if (this.tickSpacing > 0) {
                int start = slider.getStart();
                int end = slider.getEnd();
                for (int value = start; value <= end; value += this.tickSpacing) {
                    float ratio = (float)(value - start) / (float)(end - start);
                    int x = (int)((float)width * ratio);
                    graphics.drawLine(x, height / 3, x, height * 2 / 3);
                }
            }
        } else {
            graphics.fillRect((width - this.trackWidth) / 2, 0, this.trackWidth, height);
            if (this.tickSpacing > 0) {
                int start = slider.getStart();
                int end = slider.getEnd();
                for (int value = start; value <= end; value += this.tickSpacing) {
                    float ratio = (float)(value - start) / (float)(end - start);
                    int y = (int)((float)height * ratio);
                    graphics.drawLine(width / 3, y, width * 2 / 3, y);
                }
            }
        }
        if (this.thumb.isFocused()) {
            graphics.setStroke(dashStroke);
            graphics.setColor(this.buttonBorderColor);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawRect(0, 0, width - 1, height - 1);
        }
    }

    public Color getTrackColor() {
        return this.trackColor;
    }

    public void setTrackColor(Color trackColor) {
        if (trackColor == null) {
            throw new IllegalArgumentException("trackColor is null.");
        }
        this.trackColor = trackColor;
        this.repaintComponent();
    }

    public final void setTrackColor(String trackColor) {
        if (trackColor == null) {
            throw new IllegalArgumentException("trackColor is null");
        }
        this.setTrackColor(GraphicsUtilities.decodeColor((String)trackColor));
    }

    public int getTrackWidth() {
        return this.trackWidth;
    }

    public void setTrackWidth(int trackWidth) {
        if (trackWidth < 0) {
            throw new IllegalArgumentException("trackWidth is negative.");
        }
        this.trackWidth = trackWidth;
        this.repaintComponent();
    }

    public void setTrackWidth(Number trackWidth) {
        if (trackWidth == null) {
            throw new IllegalArgumentException("trackWidth is null.");
        }
        this.setTrackWidth(trackWidth.intValue());
    }

    public Color getButtonBackgroundColor() {
        return this.buttonBackgroundColor;
    }

    public void setButtonBackgroundColor(Color buttonBackgroundColor) {
        if (buttonBackgroundColor == null) {
            throw new IllegalArgumentException("buttonBackgroundColor is null.");
        }
        this.buttonBackgroundColor = buttonBackgroundColor;
        this.buttonBevelColor = TerraTheme.brighten(buttonBackgroundColor);
        this.repaintComponent();
    }

    public final void setButtonBackgroundColor(String buttonBackgroundColor) {
        if (buttonBackgroundColor == null) {
            throw new IllegalArgumentException("buttonBackgroundColor is null");
        }
        this.setButtonBackgroundColor(GraphicsUtilities.decodeColor((String)buttonBackgroundColor));
    }

    public Color getButtonBorderColor() {
        return this.buttonBorderColor;
    }

    public void setButtonBorderColor(Color buttonBorderColor) {
        if (buttonBorderColor == null) {
            throw new IllegalArgumentException("buttonBorderColor is null.");
        }
        this.buttonBorderColor = buttonBorderColor;
        this.repaintComponent();
    }

    public final void setButtonBorderColor(String buttonBorderColor) {
        if (buttonBorderColor == null) {
            throw new IllegalArgumentException("buttonBorderColor is null.");
        }
        this.setButtonBorderColor(GraphicsUtilities.decodeColor((String)buttonBorderColor));
    }

    public int getThumbWidth() {
        return this.thumbWidth;
    }

    public void setThumbWidth(int thumbWidth) {
        if (thumbWidth < 4) {
            throw new IllegalArgumentException("thumbWidth must be greater than or equal to 4");
        }
        this.thumbWidth = thumbWidth;
        this.invalidateComponent();
    }

    public void setThumbWidth(Number thumbWidth) {
        if (thumbWidth == null) {
            throw new IllegalArgumentException("thumbWidth is null.");
        }
        this.setThumbWidth(thumbWidth.intValue());
    }

    public int getThumbHeight() {
        return this.thumbHeight;
    }

    public void setThumbHeight(int thumbHeight) {
        if (thumbHeight < 4) {
            throw new IllegalArgumentException("thumbHeight must be greater than or equal to 4");
        }
        this.thumbHeight = thumbHeight;
        this.invalidateComponent();
    }

    public void setThumbHeight(Number thumbHeight) {
        if (thumbHeight == null) {
            throw new IllegalArgumentException("thumbHeight is null.");
        }
        this.setThumbHeight(thumbHeight.intValue());
    }

    public int getTickSpacing() {
        return this.tickSpacing;
    }

    public void setTickSpacing(int tickSpacing) {
        this.tickSpacing = tickSpacing;
        this.repaintComponent();
    }

    public void setTickSpacing(Number tickSpacing) {
        if (tickSpacing == null) {
            throw new IllegalArgumentException("tickSpacing is null.");
        }
        this.setTickSpacing(tickSpacing.intValue());
    }

    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        this.thumb.requestFocus();
        return super.mouseClick(component, button, x, y, count);
    }

    public void rangeChanged(Slider slider, int previousStart, int previousEnd) {
        this.invalidateComponent();
    }

    public void orientationChanged(Slider slider) {
        this.invalidateComponent();
    }

    public void valueChanged(Slider slider, int previousValue) {
        this.layout();
    }

    protected class ThumbSkin
    extends ComponentSkin {
        private boolean highlighted = false;

        protected ThumbSkin() {
        }

        public boolean isFocusable() {
            return true;
        }

        public int getPreferredWidth(int height) {
            return 0;
        }

        public int getPreferredHeight(int width) {
            return 0;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics) {
            int width = this.getWidth();
            int height = this.getHeight();
            graphics.setPaint(new GradientPaint((float)width / 2.0f, 0.0f, TerraSliderSkin.this.buttonBevelColor, (float)width / 2.0f, height, TerraSliderSkin.this.buttonBackgroundColor));
            graphics.fillRect(0, 0, width, height);
            float alpha = this.highlighted || TerraSliderSkin.this.dragOffset != null ? 0.25f : 0.0f;
            graphics.setPaint(new Color(0.0f, 0.0f, 0.0f, alpha));
            graphics.fillRect(0, 0, width, height);
            graphics.setPaint(TerraSliderSkin.this.buttonBorderColor);
            GraphicsUtilities.drawRect((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height);
        }

        public void enabledChanged(Component component) {
            super.enabledChanged(component);
            this.highlighted = false;
            this.repaintComponent();
        }

        public void focusedChanged(Component component, Component obverseComponent) {
            super.focusedChanged(component, obverseComponent);
            TerraSliderSkin.this.repaintComponent();
        }

        public boolean mouseMove(Component component, int x, int y) {
            boolean consumed = super.mouseMove(component, x, y);
            if (Mouse.getCapturer() == component) {
                Slider slider = (Slider)TerraSliderSkin.this.getComponent();
                if (slider.getOrientation() == Orientation.HORIZONTAL) {
                    int maxX;
                    int sliderWidth = slider.getWidth();
                    int thumbWidthLocal = TerraSliderSkin.this.thumb.getWidth();
                    Point sliderLocation = TerraSliderSkin.this.thumb.mapPointToAncestor((Container)slider, x, y);
                    int sliderX = sliderLocation.x;
                    int minX = TerraSliderSkin.this.dragOffset.x;
                    if (sliderX < minX) {
                        sliderX = minX;
                    }
                    if (sliderX > (maxX = sliderWidth - thumbWidthLocal + TerraSliderSkin.this.dragOffset.x)) {
                        sliderX = maxX;
                    }
                    float ratio = (float)(sliderX - TerraSliderSkin.this.dragOffset.x) / (float)(sliderWidth - thumbWidthLocal);
                    int start = slider.getStart();
                    int end = slider.getEnd();
                    int value = (int)((float)start + (float)(end - start) * ratio);
                    slider.setValue(value);
                } else {
                    int maxY;
                    int sliderHeight = slider.getHeight();
                    int thumbHeightLocal = TerraSliderSkin.this.thumb.getHeight();
                    Point sliderLocation = TerraSliderSkin.this.thumb.mapPointToAncestor((Container)slider, x, y);
                    int sliderY = sliderLocation.y;
                    int minY = TerraSliderSkin.this.dragOffset.y;
                    if (sliderY < minY) {
                        sliderY = minY;
                    }
                    if (sliderY > (maxY = sliderHeight - thumbHeightLocal + TerraSliderSkin.this.dragOffset.y)) {
                        sliderY = maxY;
                    }
                    float ratio = (float)(sliderY - TerraSliderSkin.this.dragOffset.y) / (float)(sliderHeight - thumbHeightLocal);
                    int start = slider.getStart();
                    int end = slider.getEnd();
                    int value = (int)((float)start + (float)(end - start) * ratio);
                    slider.setValue(value);
                }
            }
            return consumed;
        }

        public void mouseOver(Component component) {
            super.mouseOver(component);
            this.highlighted = true;
            this.repaintComponent();
        }

        public void mouseOut(Component component) {
            super.mouseOut(component);
            this.highlighted = false;
            this.repaintComponent();
        }

        public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseDown(component, button, x, y);
            component.requestFocus();
            if (button == Mouse.Button.LEFT) {
                TerraSliderSkin.this.dragOffset = new Point(x, y);
                Mouse.capture((Component)component);
                this.repaintComponent();
                consumed = true;
            }
            return consumed;
        }

        public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseUp(component, button, x, y);
            if (Mouse.getCapturer() == component) {
                TerraSliderSkin.this.dragOffset = null;
                Mouse.release();
                this.repaintComponent();
            }
            return consumed;
        }

        public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            boolean consumed = super.keyPressed(component, keyCode, keyLocation);
            Slider slider = (Slider)TerraSliderSkin.this.getComponent();
            int start = slider.getStart();
            int end = slider.getEnd();
            int length = end - start;
            int value = slider.getValue();
            int increment = length / 10;
            if (keyCode == 37 || keyCode == 40) {
                slider.setValue(Math.max(start, value - increment));
                consumed = true;
            } else if (keyCode == 39 || keyCode == 38) {
                slider.setValue(Math.min(end, value + increment));
                consumed = true;
            }
            return consumed;
        }
    }

    protected class Thumb
    extends Component {
        public Thumb() {
            this.setSkin((Skin)new ThumbSkin());
        }
    }
}

