/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonGroup;
import org.apache.pivot.wtk.ButtonGroupListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentStateListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Panorama;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.TabPane;
import org.apache.pivot.wtk.TabPaneAttributeListener;
import org.apache.pivot.wtk.TabPaneListener;
import org.apache.pivot.wtk.TabPaneSelectionListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.effects.ClipDecorator;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.effects.easing.Easing;
import org.apache.pivot.wtk.effects.easing.Quadratic;
import org.apache.pivot.wtk.skin.ButtonSkin;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraTabPaneSkin
extends ContainerSkin
implements TabPaneListener,
TabPaneSelectionListener,
TabPaneAttributeListener {
    private Panorama tabButtonPanorama = new Panorama();
    private BoxPane tabButtonBoxPane = new BoxPane();
    private ButtonGroup tabButtonGroup = new ButtonGroup();
    private Color activeTabColor;
    private Color inactiveTabColor;
    private Color borderColor;
    private Color inactiveBorderColor;
    private Insets padding;
    private Font buttonFont;
    private Color buttonColor;
    private Color disabledButtonColor;
    private Insets buttonPadding;
    private int buttonSpacing;
    private int buttonCornerRadius;
    private Color activeButtonBevelColor;
    private Color inactiveButtonBevelColor;
    private Orientation tabOrientation = Orientation.HORIZONTAL;
    private int selectionChangeDuration = 250;
    private int selectionChangeRate = 30;
    private SelectionChangeTransition selectionChangeTransition = null;
    private ClipDecorator clipDecorator = new ClipDecorator();
    private ComponentStateListener tabStateListener = new ComponentStateListener.Adapter(){

        public void enabledChanged(Component component) {
            TabPane tabPane = (TabPane)TerraTabPaneSkin.this.getComponent();
            int i = tabPane.getTabs().indexOf(component);
            TerraTabPaneSkin.this.tabButtonBoxPane.get(i).setEnabled(component.isEnabled());
        }
    };
    public static final int GRADIENT_BEVEL_THICKNESS = 8;
    private static final int CLOSE_TRIGGER_SIZE = 6;
    private static final int DEFAULT_SELECTION_CHANGE_DURATION = 250;
    private static final int DEFAULT_SELECTION_CHANGE_RATE = 30;

    public TerraTabPaneSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.activeTabColor = theme.getColor(11);
        this.inactiveTabColor = theme.getColor(9);
        this.borderColor = theme.getColor(7);
        this.inactiveBorderColor = theme.getColor(7);
        this.padding = new Insets(6);
        this.buttonFont = theme.getFont();
        this.buttonColor = theme.getColor(1);
        this.disabledButtonColor = theme.getColor(7);
        this.buttonPadding = new Insets(3, 4, 3, 4);
        this.buttonSpacing = 6;
        this.buttonCornerRadius = 4;
        this.activeButtonBevelColor = TerraTheme.brighten(this.activeTabColor);
        this.inactiveButtonBevelColor = TerraTheme.brighten(this.inactiveTabColor);
        this.tabButtonBoxPane.getStyles().put("fill", (Object)true);
        this.tabButtonPanorama.getStyles().put("buttonBackgroundColor", (Object)this.borderColor);
        this.tabButtonPanorama.getStyles().put("buttonPadding", (Object)6);
        this.tabButtonPanorama.setView((Component)this.tabButtonBoxPane);
        this.tabButtonGroup.getButtonGroupListeners().add((Object)new ButtonGroupListener.Adapter(){

            public void selectionChanged(ButtonGroup buttonGroup, Button previousSelection) {
                Button button = TerraTabPaneSkin.this.tabButtonGroup.getSelection();
                int index = button == null ? -1 : TerraTabPaneSkin.this.tabButtonBoxPane.indexOf((Component)button);
                TabPane tabPane = (TabPane)TerraTabPaneSkin.this.getComponent();
                tabPane.setSelectedIndex(index);
            }
        });
        this.setButtonSpacing(2);
    }

    public void install(Component component) {
        super.install(component);
        TabPane tabPane = (TabPane)component;
        tabPane.getTabPaneListeners().add((Object)this);
        tabPane.getTabPaneSelectionListeners().add((Object)this);
        tabPane.getTabPaneAttributeListeners().add((Object)this);
        tabPane.add((Component)this.tabButtonPanorama);
    }

    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        TabPane tabPane = (TabPane)this.getComponent();
        Component selectedTab = tabPane.getSelectedTab();
        Component corner = tabPane.getCorner();
        switch (this.tabOrientation) {
            case HORIZONTAL: {
                if (height != -1) {
                    height = corner != null ? Math.max(height - Math.max(corner.getPreferredHeight(-1), Math.max(this.tabButtonPanorama.getPreferredHeight(-1) - 1, 0)), 0) : Math.max(height - (this.tabButtonPanorama.getPreferredHeight(-1) - 1), 0);
                    height = Math.max(height - (this.padding.top + this.padding.bottom + 2), 0);
                }
                preferredWidth = this.getPreferredTabWidth(height) + (this.padding.left + this.padding.right + 2);
                int buttonAreaPreferredWidth = this.tabButtonPanorama.getPreferredWidth(-1);
                if (corner != null) {
                    buttonAreaPreferredWidth += corner.getPreferredWidth(-1);
                }
                preferredWidth = Math.max(preferredWidth, buttonAreaPreferredWidth);
                break;
            }
            case VERTICAL: {
                if (height != -1) {
                    height = Math.max(height - (this.padding.top + this.padding.bottom + 2), 0);
                }
                if (selectedTab == null && this.selectionChangeTransition == null) {
                    preferredWidth = 1;
                } else {
                    preferredWidth = this.getPreferredTabWidth(height) + (this.padding.left + this.padding.right);
                    if (this.selectionChangeTransition != null) {
                        float scale = this.selectionChangeTransition.getScale();
                        preferredWidth = (int)((float)preferredWidth * scale);
                    }
                    preferredWidth += 2;
                }
                if (corner != null) {
                    preferredWidth += Math.max(corner.getPreferredWidth(-1), Math.max(this.tabButtonPanorama.getPreferredWidth(-1) - 1, 0));
                    break;
                }
                preferredWidth += Math.max(this.tabButtonPanorama.getPreferredWidth(-1) - 1, 0);
                break;
            }
        }
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        TabPane tabPane = (TabPane)this.getComponent();
        Component selectedTab = tabPane.getSelectedTab();
        Component corner = tabPane.getCorner();
        switch (this.tabOrientation) {
            case HORIZONTAL: {
                if (width != -1) {
                    width = Math.max(width - (this.padding.left + this.padding.right + 2), 0);
                }
                if (selectedTab == null && this.selectionChangeTransition == null) {
                    preferredHeight = 1;
                } else {
                    preferredHeight = this.getPreferredTabHeight(width) + (this.padding.top + this.padding.bottom);
                    if (this.selectionChangeTransition != null) {
                        float scale = this.selectionChangeTransition.getScale();
                        preferredHeight = (int)((float)preferredHeight * scale);
                    }
                    preferredHeight += 2;
                }
                if (corner != null) {
                    preferredHeight += Math.max(corner.getPreferredHeight(-1), Math.max(this.tabButtonPanorama.getPreferredHeight(-1) - 1, 0));
                    break;
                }
                preferredHeight += Math.max(this.tabButtonPanorama.getPreferredHeight(-1) - 1, 0);
                break;
            }
            case VERTICAL: {
                if (width != -1) {
                    width = corner != null ? Math.max(width - Math.max(corner.getPreferredWidth(-1), Math.max(this.tabButtonPanorama.getPreferredWidth(-1) - 1, 0)), 0) : Math.max(width - (this.tabButtonPanorama.getPreferredWidth(-1) - 1), 0);
                    width = Math.max(width - (this.padding.left + this.padding.right + 2), 0);
                }
                preferredHeight = this.getPreferredTabHeight(width) + (this.padding.top + this.padding.bottom + 2);
                int buttonAreaPreferredHeight = this.tabButtonPanorama.getPreferredHeight(-1);
                if (corner != null) {
                    buttonAreaPreferredHeight += corner.getPreferredHeight(-1);
                }
                preferredHeight = Math.max(preferredHeight, buttonAreaPreferredHeight);
                break;
            }
        }
        return preferredHeight;
    }

    public Dimensions getPreferredSize() {
        int preferredHeight;
        int preferredWidth;
        TabPane tabPane = (TabPane)this.getComponent();
        Component selectedTab = tabPane.getSelectedTab();
        Component corner = tabPane.getCorner();
        switch (this.tabOrientation) {
            case HORIZONTAL: {
                if (selectedTab == null && this.selectionChangeTransition == null) {
                    preferredWidth = this.getPreferredTabWidth(-1) + (this.padding.left + this.padding.right + 2);
                    preferredHeight = 1;
                } else {
                    Dimensions preferredTabSize = this.getPreferredTabSize();
                    preferredWidth = preferredTabSize.width + (this.padding.left + this.padding.right + 2);
                    preferredHeight = preferredTabSize.height + (this.padding.top + this.padding.bottom);
                    if (this.selectionChangeTransition != null) {
                        float scale = this.selectionChangeTransition.getScale();
                        preferredHeight = (int)((float)preferredHeight * scale);
                    }
                    preferredHeight += 2;
                }
                int buttonAreaPreferredWidth = this.tabButtonPanorama.getPreferredWidth(-1);
                if (corner != null) {
                    buttonAreaPreferredWidth += corner.getPreferredWidth(-1);
                    preferredHeight += Math.max(corner.getPreferredHeight(-1), Math.max(this.tabButtonPanorama.getPreferredHeight(-1) - 1, 0));
                    buttonAreaPreferredWidth += 2;
                } else {
                    preferredHeight += Math.max(this.tabButtonPanorama.getPreferredHeight(-1) - 1, 0);
                }
                preferredWidth = Math.max(preferredWidth, buttonAreaPreferredWidth);
                break;
            }
            case VERTICAL: {
                if (selectedTab == null && this.selectionChangeTransition == null) {
                    preferredWidth = 1;
                    preferredHeight = this.getPreferredTabHeight(-1) + (this.padding.top + this.padding.bottom + 2);
                } else {
                    Dimensions preferredTabSize = this.getPreferredTabSize();
                    preferredWidth = preferredTabSize.width + (this.padding.left + this.padding.right);
                    preferredHeight = preferredTabSize.height + (this.padding.top + this.padding.bottom + 2);
                    if (this.selectionChangeTransition != null) {
                        float scale = this.selectionChangeTransition.getScale();
                        preferredWidth = (int)((float)preferredWidth * scale);
                    }
                    preferredWidth += 2;
                }
                int buttonAreaPreferredHeight = this.tabButtonPanorama.getPreferredHeight(-1);
                if (corner != null) {
                    buttonAreaPreferredHeight += corner.getPreferredHeight(-1);
                    preferredWidth += Math.max(corner.getPreferredWidth(-1), Math.max(this.tabButtonPanorama.getPreferredWidth(-1) - 1, 0));
                    buttonAreaPreferredHeight += 2;
                } else {
                    preferredWidth += Math.max(this.tabButtonPanorama.getPreferredWidth(-1) - 1, 0);
                }
                preferredHeight = Math.max(preferredHeight, buttonAreaPreferredHeight);
                break;
            }
            default: {
                preferredWidth = 0;
                preferredHeight = 0;
            }
        }
        return new Dimensions(preferredWidth, preferredHeight);
    }

    public int getBaseline(int width, int height) {
        int baseline = -1;
        if (this.tabOrientation == Orientation.HORIZONTAL && this.tabButtonBoxPane.getLength() > 0) {
            TabButton firstTabButton = (TabButton)this.tabButtonBoxPane.get(0);
            int buttonHeight = this.tabButtonBoxPane.getPreferredHeight();
            baseline = firstTabButton.getBaseline(firstTabButton.getPreferredWidth(buttonHeight), buttonHeight);
        }
        return baseline;
    }

    private int getPreferredTabWidth(int height) {
        int preferredTabWidth = 0;
        TabPane tabPane = (TabPane)this.getComponent();
        for (Component tab : tabPane.getTabs()) {
            preferredTabWidth = Math.max(preferredTabWidth, tab.getPreferredWidth(height));
        }
        return preferredTabWidth;
    }

    private int getPreferredTabHeight(int width) {
        int preferredTabHeight = 0;
        TabPane tabPane = (TabPane)this.getComponent();
        for (Component tab : tabPane.getTabs()) {
            preferredTabHeight = Math.max(preferredTabHeight, tab.getPreferredHeight(width));
        }
        return preferredTabHeight;
    }

    private Dimensions getPreferredTabSize() {
        int preferredTabWidth = 0;
        int preferredTabHeight = 0;
        TabPane tabPane = (TabPane)this.getComponent();
        for (Component tab : tabPane.getTabs()) {
            Dimensions preferredSize = tab.getPreferredSize();
            preferredTabWidth = Math.max(preferredTabWidth, preferredSize.width);
            preferredTabHeight = Math.max(preferredTabHeight, preferredSize.height);
        }
        return new Dimensions(preferredTabWidth, preferredTabHeight);
    }

    public void layout() {
        TabPane tabPane = (TabPane)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        int tabX = 0;
        int tabY = 0;
        int tabWidth = 0;
        int tabHeight = 0;
        Component corner = tabPane.getCorner();
        Dimensions buttonPanoramaSize = this.tabButtonPanorama.getPreferredSize();
        switch (this.tabOrientation) {
            case HORIZONTAL: {
                int cornerY;
                int cornerX;
                int buttonPanoramaWidth = Math.min(width, buttonPanoramaSize.width);
                int buttonPanoramaHeight = buttonPanoramaSize.height;
                int buttonPanoramaY = 0;
                if (corner != null) {
                    int cornerWidth = Math.max(width - buttonPanoramaWidth - 2, corner.getPreferredWidth());
                    if (cornerWidth > width - 2) {
                        cornerWidth = Math.max(width - 2, 0);
                    }
                    if (buttonPanoramaWidth + 2 + cornerWidth > width) {
                        buttonPanoramaWidth = Math.max(width - 2 - cornerWidth, 0);
                    }
                    int cornerHeight = Math.max(corner.getPreferredHeight(-1), buttonPanoramaSize.height - 1);
                    cornerX = width - cornerWidth;
                    cornerY = Math.max(buttonPanoramaHeight - cornerHeight - 1, 0);
                    buttonPanoramaY = Math.max(cornerHeight - buttonPanoramaHeight + 1, 0);
                    corner.setLocation(cornerX, cornerY);
                    corner.setSize(cornerWidth, cornerHeight);
                }
                this.tabButtonPanorama.setLocation(0, buttonPanoramaY);
                this.tabButtonPanorama.setSize(buttonPanoramaWidth, buttonPanoramaHeight);
                tabX = this.padding.left + 1;
                tabY = this.padding.top + buttonPanoramaY + buttonPanoramaHeight;
                tabWidth = Math.max(width - (this.padding.left + this.padding.right + 2), 0);
                tabHeight = Math.max(height - (this.padding.top + this.padding.bottom + buttonPanoramaY + buttonPanoramaHeight + 1), 0);
                break;
            }
            case VERTICAL: {
                int cornerY;
                int cornerX;
                int buttonPanoramaWidth = buttonPanoramaSize.width;
                int buttonPanoramaHeight = Math.min(height, buttonPanoramaSize.height);
                int buttonPanoramaX = 0;
                if (corner != null) {
                    int cornerHeight = Math.max(height - buttonPanoramaHeight - 2, corner.getPreferredHeight());
                    if (cornerHeight > height - 2) {
                        cornerHeight = Math.max(height - 2, 0);
                    }
                    if (buttonPanoramaHeight + 2 + cornerHeight > height) {
                        buttonPanoramaHeight = Math.max(height - 2 - cornerHeight, 0);
                    }
                    int cornerWidth = Math.max(corner.getPreferredWidth(-1), buttonPanoramaSize.width - 1);
                    cornerX = Math.max(buttonPanoramaWidth - cornerWidth - 1, 0);
                    cornerY = height - cornerHeight;
                    buttonPanoramaX = Math.max(cornerWidth - buttonPanoramaWidth + 1, 0);
                    corner.setLocation(cornerX, cornerY);
                    corner.setSize(cornerWidth, cornerHeight);
                }
                this.tabButtonPanorama.setLocation(buttonPanoramaX, 0);
                this.tabButtonPanorama.setSize(buttonPanoramaWidth, buttonPanoramaHeight);
                tabX = this.padding.left + buttonPanoramaX + buttonPanoramaWidth;
                tabY = this.padding.top + 1;
                tabWidth = Math.max(width - (this.padding.left + this.padding.right + buttonPanoramaX + buttonPanoramaWidth + 1), 0);
                tabHeight = Math.max(height - (this.padding.top + this.padding.bottom + 2), 0);
                break;
            }
        }
        block8: for (Component tab : tabPane.getTabs()) {
            tab.setLocation(tabX, tabY);
            if (this.selectionChangeTransition != null && this.selectionChangeTransition.isRunning()) {
                this.clipDecorator.setSize(tabWidth, tabHeight);
                switch (this.tabOrientation) {
                    case HORIZONTAL: {
                        tab.setSize(tabWidth, this.getPreferredTabHeight(tabWidth));
                        continue block8;
                    }
                    case VERTICAL: {
                        tab.setSize(this.getPreferredTabWidth(tabHeight), tabHeight);
                        continue block8;
                    }
                }
                continue;
            }
            tab.setSize(tabWidth, tabHeight);
        }
    }

    public void paint(Graphics2D graphics) {
        TabPane tabPane = (TabPane)this.getComponent();
        Bounds tabPaneBounds = tabPane.getBounds();
        super.paint(graphics);
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        switch (this.tabOrientation) {
            case HORIZONTAL: {
                x = 0;
                y = Math.max(this.tabButtonPanorama.getY() + this.tabButtonPanorama.getHeight() - 1, 0);
                width = tabPaneBounds.width;
                height = Math.max(tabPaneBounds.height - y, 0);
                break;
            }
            case VERTICAL: {
                x = Math.max(this.tabButtonPanorama.getX() + this.tabButtonPanorama.getWidth() - 1, 0);
                y = 0;
                width = Math.max(tabPaneBounds.width - x, 0);
                height = tabPaneBounds.height;
                break;
            }
        }
        TabButton activeTabButton = this.selectionChangeTransition == null ? (TabButton)this.tabButtonGroup.getSelection() : (TabButton)this.tabButtonBoxPane.get(this.selectionChangeTransition.index);
        if (activeTabButton != null) {
            Bounds contentBounds = new Bounds(x, y, width, height);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setPaint(this.activeTabColor);
            graphics.fillRect(contentBounds.x, contentBounds.y, contentBounds.width, contentBounds.height);
            double top = (double)contentBounds.y + 0.5;
            double left = (double)contentBounds.x + 0.5;
            double bottom = top + (double)contentBounds.height - 1.0;
            double right = left + (double)contentBounds.width - 1.0;
            graphics.setPaint(this.borderColor);
            graphics.draw(new Line2D.Double(right, top, right, bottom));
            graphics.draw(new Line2D.Double(left, bottom, right, bottom));
            switch (this.tabOrientation) {
                case HORIZONTAL: {
                    graphics.draw(new Line2D.Double(left, top, left, bottom));
                    Point selectedTabButtonLocation = activeTabButton.mapPointToAncestor((Container)tabPane, 0, 0);
                    graphics.draw(new Line2D.Double(left, top, (double)selectedTabButtonLocation.x + 0.5, top));
                    graphics.draw(new Line2D.Double((double)(selectedTabButtonLocation.x + activeTabButton.getWidth()) - 0.5, top, right, top));
                    break;
                }
                case VERTICAL: {
                    graphics.draw(new Line2D.Double(left, top, right, top));
                    Point selectedTabButtonLocation = activeTabButton.mapPointToAncestor((Container)tabPane, 0, 0);
                    graphics.draw(new Line2D.Double(left, top, left, (double)selectedTabButtonLocation.y + 0.5));
                    graphics.draw(new Line2D.Double(left, (double)(selectedTabButtonLocation.y + activeTabButton.getHeight()) - 0.5, left, bottom));
                    break;
                }
            }
        }
    }

    public Color getActiveTabColor() {
        return this.activeTabColor;
    }

    public void setActiveTabColor(Color activeTabColor) {
        if (activeTabColor == null) {
            throw new IllegalArgumentException("activeTabColor is null.");
        }
        this.activeTabColor = activeTabColor;
        this.activeButtonBevelColor = TerraTheme.brighten(activeTabColor);
        this.repaintComponent();
    }

    public final void setActiveTabColor(String activeTabColor) {
        if (activeTabColor == null) {
            throw new IllegalArgumentException("activeTabColor is null.");
        }
        this.setActiveTabColor(GraphicsUtilities.decodeColor((String)activeTabColor));
    }

    public final void setActiveTabColor(int activeTabColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setActiveTabColor(theme.getColor(activeTabColor));
    }

    public Color getInactiveTabColor() {
        return this.inactiveTabColor;
    }

    public void setInactiveTabColor(Color inactiveTabColor) {
        if (inactiveTabColor == null) {
            throw new IllegalArgumentException("inactiveTabColor is null.");
        }
        this.inactiveTabColor = inactiveTabColor;
        this.inactiveButtonBevelColor = TerraTheme.brighten(inactiveTabColor);
        this.repaintComponent();
    }

    public final void setInactiveTabColor(String inactiveTabColor) {
        if (inactiveTabColor == null) {
            throw new IllegalArgumentException("inactiveTabColor is null.");
        }
        this.setInactiveTabColor(GraphicsUtilities.decodeColor((String)inactiveTabColor));
    }

    public final void setInactiveTabColor(int inactiveTabColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setInactiveTabColor(theme.getColor(inactiveTabColor));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = borderColor;
        this.tabButtonPanorama.getStyles().put("buttonBackgroundColor", (Object)borderColor);
        this.repaintComponent();
    }

    public final void setBorderColor(String borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)borderColor));
    }

    public final void setBorderColor(int borderColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBorderColor(theme.getColor(borderColor));
    }

    public Color getInactiveBorderColor() {
        return this.inactiveBorderColor;
    }

    public void setInactiveBorderColor(Color inactiveBorderColor) {
        if (inactiveBorderColor == null) {
            throw new IllegalArgumentException("inactiveBorderColor is null.");
        }
        this.inactiveBorderColor = inactiveBorderColor;
        this.repaintComponent();
    }

    public final void setInactiveBorderColor(String inactiveBorderColor) {
        if (inactiveBorderColor == null) {
            throw new IllegalArgumentException("inactiveBorderColor is null.");
        }
        this.setInactiveBorderColor(GraphicsUtilities.decodeColor((String)inactiveBorderColor));
    }

    public final void setInactiveBorderColor(int inactiveBorderColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setInactiveBorderColor(theme.getColor(inactiveBorderColor));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)padding));
    }

    public Font getButtonFont() {
        return this.buttonFont;
    }

    public void setButtonFont(Font buttonFont) {
        if (buttonFont == null) {
            throw new IllegalArgumentException("buttonFont is null.");
        }
        this.buttonFont = buttonFont;
        this.invalidateComponent();
    }

    public final void setButtonFont(String buttonFont) {
        if (buttonFont == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setButtonFont(TerraTabPaneSkin.decodeFont((String)buttonFont));
    }

    public final void setButtonFont(Dictionary<String, ?> buttonFont) {
        if (buttonFont == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setButtonFont(Theme.deriveFont(buttonFont));
    }

    public Color getButtonColor() {
        return this.buttonColor;
    }

    public void setButtonColor(Color buttonColor) {
        if (buttonColor == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.buttonColor = buttonColor;
        this.repaintComponent();
    }

    public final void setButtonColor(String buttonColor) {
        if (buttonColor == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.setButtonColor(GraphicsUtilities.decodeColor((String)buttonColor));
    }

    public final void setButtonColor(int buttonColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setButtonColor(theme.getColor(buttonColor));
    }

    public Insets getButtonPadding() {
        return this.buttonPadding;
    }

    public void setButtonPadding(Insets buttonPadding) {
        if (buttonPadding == null) {
            throw new IllegalArgumentException("buttonPadding is null.");
        }
        this.buttonPadding = buttonPadding;
        this.invalidateComponent();
        for (Component tabButton : this.tabButtonBoxPane) {
            tabButton.invalidate();
        }
    }

    public final void setButtonPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("buttonPadding is null.");
        }
        this.setButtonPadding(new Insets(padding));
    }

    public final void setButtonPadding(int buttonPadding) {
        this.setButtonPadding(new Insets(buttonPadding));
    }

    public final void setButtonPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("buttonPadding is null.");
        }
        this.setButtonPadding(padding.intValue());
    }

    public final void setButtonPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("buttonPadding is null.");
        }
        this.setButtonPadding(Insets.decode((String)padding));
    }

    public int getButtonSpacing() {
        return (Integer)this.tabButtonBoxPane.getStyles().get("spacing");
    }

    public void setButtonSpacing(int buttonSpacing) {
        this.tabButtonBoxPane.getStyles().put("spacing", (Object)buttonSpacing);
    }

    public final void setButtonCornerRadius(int buttonCornerRadius) {
        this.buttonCornerRadius = buttonCornerRadius;
    }

    public final void setButtonCornerRadius(Number radius) {
        if (radius == null) {
            throw new IllegalArgumentException("buttonCornerRadius is null.");
        }
        this.setButtonCornerRadius(radius.intValue());
    }

    public final void setButtonCornerRadius(String radius) {
        if (radius == null) {
            throw new IllegalArgumentException("buttonCornerRadius is null.");
        }
        this.setButtonCornerRadius(Integer.valueOf(radius));
    }

    public Orientation getTabOrientation() {
        return this.tabOrientation;
    }

    public void setTabOrientation(Orientation tabOrientation) {
        if (tabOrientation == null) {
            throw new IllegalArgumentException("tabOrientation is null.");
        }
        this.tabOrientation = tabOrientation;
        for (Component tabButton : this.tabButtonBoxPane) {
            tabButton.invalidate();
        }
        this.tabButtonBoxPane.setOrientation(tabOrientation);
        switch (tabOrientation) {
            case HORIZONTAL: {
                this.tabButtonBoxPane.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
                break;
            }
            case VERTICAL: {
                this.tabButtonBoxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.TOP);
                break;
            }
        }
    }

    public int getSelectionChangeDuration() {
        return this.selectionChangeDuration;
    }

    public void setSelectionChangeDuration(int selectionChangeDuration) {
        this.selectionChangeDuration = selectionChangeDuration;
    }

    public int getSelectionChangeRate() {
        return this.selectionChangeRate;
    }

    public void setSelectionChangeRate(int selectionChangeRate) {
        this.selectionChangeRate = selectionChangeRate;
    }

    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = super.keyPressed(component, keyCode, keyLocation);
        Keyboard.Modifier commandModifier = Platform.getCommandModifier();
        if (!consumed && Keyboard.isPressed((Keyboard.Modifier)commandModifier)) {
            TabPane tabPane = (TabPane)this.getComponent();
            TabPane.TabSequence tabs = tabPane.getTabs();
            int selectedIndex = -1;
            switch (keyCode) {
                case 49: 
                case 97: {
                    selectedIndex = 0;
                    break;
                }
                case 50: 
                case 98: {
                    selectedIndex = 1;
                    break;
                }
                case 51: 
                case 99: {
                    selectedIndex = 2;
                    break;
                }
                case 52: 
                case 100: {
                    selectedIndex = 3;
                    break;
                }
                case 53: 
                case 101: {
                    selectedIndex = 4;
                    break;
                }
                case 54: 
                case 102: {
                    selectedIndex = 5;
                    break;
                }
                case 55: 
                case 103: {
                    selectedIndex = 6;
                    break;
                }
                case 56: 
                case 104: {
                    selectedIndex = 7;
                    break;
                }
                case 57: 
                case 105: {
                    selectedIndex = 8;
                    break;
                }
            }
            if (selectedIndex >= 0 && selectedIndex < tabs.getLength() && tabs.get(selectedIndex).isEnabled()) {
                tabPane.setSelectedIndex(selectedIndex);
                consumed = true;
            }
        }
        return consumed;
    }

    public void tabInserted(TabPane tabPane, int index) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        Component tab = tabPane.getTabs().get(index);
        tab.setVisible(false);
        TabButton tabButton = new TabButton(tab);
        tabButton.setButtonGroup(this.tabButtonGroup);
        this.tabButtonBoxPane.insert((Component)tabButton, index);
        tabButton.setEnabled(tab.isEnabled());
        tab.getComponentStateListeners().add((Object)this.tabStateListener);
        if (tabPane.getTabs().getLength() == 1) {
            tabPane.setSelectedIndex(0);
        }
        this.invalidateComponent();
    }

    public Vote previewRemoveTabs(TabPane tabPane, int index, int count) {
        return Vote.APPROVE;
    }

    public void removeTabsVetoed(TabPane tabPane, Vote vote) {
    }

    public void tabsRemoved(TabPane tabPane, int index, Sequence<Component> removed) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        Sequence removedButtons = this.tabButtonBoxPane.remove(index, removed.getLength());
        int n = removed.getLength();
        for (int i = 0; i < n; ++i) {
            TabButton tabButton = (TabButton)((Object)removedButtons.get(i));
            tabButton.setButtonGroup(null);
            tabButton.tab.getComponentStateListeners().remove((Object)this.tabStateListener);
        }
        this.invalidateComponent();
    }

    public void cornerChanged(TabPane tabPane, Component previousCorner) {
        this.invalidateComponent();
    }

    public void tabDataRendererChanged(TabPane tabPane, Button.DataRenderer previousTabDataRenderer) {
        for (Component tabButton : this.tabButtonBoxPane) {
            tabButton.invalidate();
        }
    }

    public void closeableChanged(TabPane tabPane) {
        Button selectedTabButton = this.tabButtonGroup.getSelection();
        if (selectedTabButton != null) {
            selectedTabButton.invalidate();
        }
    }

    public void collapsibleChanged(TabPane tabPane) {
    }

    public Vote previewSelectedIndexChange(TabPane tabPane, int selectedIndex) {
        Vote vote;
        if (tabPane.isCollapsible()) {
            if (tabPane.isShowing() && this.selectionChangeTransition == null) {
                int previousSelectedIndex = tabPane.getSelectedIndex();
                if (selectedIndex == -1) {
                    this.selectionChangeTransition = new SelectionChangeTransition(previousSelectedIndex, false);
                } else if (previousSelectedIndex == -1) {
                    this.selectionChangeTransition = new SelectionChangeTransition(selectedIndex, true);
                }
                if (this.selectionChangeTransition != null) {
                    this.selectionChangeTransition.start(new TransitionListener(){

                        public void transitionCompleted(Transition transition) {
                            TabPane tabPaneLocal = (TabPane)TerraTabPaneSkin.this.getComponent();
                            SelectionChangeTransition selectionChangeTransitionLocal = (SelectionChangeTransition)transition;
                            int selectedIndexLocal = selectionChangeTransitionLocal.expand ? selectionChangeTransitionLocal.index : -1;
                            tabPaneLocal.setSelectedIndex(selectedIndexLocal);
                            TerraTabPaneSkin.this.selectionChangeTransition = null;
                        }
                    });
                }
            }
            vote = this.selectionChangeTransition == null || !this.selectionChangeTransition.isRunning() ? Vote.APPROVE : Vote.DEFER;
        } else {
            vote = Vote.APPROVE;
        }
        return vote;
    }

    public void selectedIndexChangeVetoed(TabPane tabPane, Vote reason) {
        if (reason == Vote.DENY && this.selectionChangeTransition != null) {
            this.selectionChangeTransition.stop();
            this.selectionChangeTransition = null;
            this.invalidateComponent();
        }
    }

    public void selectedIndexChanged(TabPane tabPane, int previousSelectedIndex) {
        int selectedIndex = tabPane.getSelectedIndex();
        if (selectedIndex != previousSelectedIndex) {
            Button button;
            if (selectedIndex == -1) {
                button = this.tabButtonGroup.getSelection();
                if (button != null) {
                    button.setSelected(false);
                }
            } else {
                button = (Button)this.tabButtonBoxPane.get(selectedIndex);
                button.setSelected(true);
                Component selectedTab = tabPane.getTabs().get(selectedIndex);
                selectedTab.setVisible(true);
                selectedTab.requestFocus();
                ApplicationContext.queueCallback((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        button.scrollAreaToVisible(0, 0, button.getWidth(), button.getHeight());
                    }
                });
            }
            if (previousSelectedIndex != -1) {
                Component previousSelectedTab = tabPane.getTabs().get(previousSelectedIndex);
                previousSelectedTab.setVisible(false);
            }
        }
        if (selectedIndex == -1 || previousSelectedIndex == -1) {
            this.invalidateComponent();
        }
    }

    public void tabDataChanged(TabPane tabPane, Component component, Object previousTabData) {
        int i = tabPane.getTabs().indexOf(component);
        this.tabButtonBoxPane.get(i).invalidate();
    }

    public void tooltipTextChanged(TabPane tabPane, Component component, String previousTooltipText) {
    }

    public class SelectionChangeTransition
    extends Transition {
        public final int index;
        public final boolean expand;
        private Easing easing;

        public SelectionChangeTransition(int index, boolean expand) {
            super(TerraTabPaneSkin.this.selectionChangeDuration, TerraTabPaneSkin.this.selectionChangeRate, false);
            this.easing = new Quadratic();
            this.index = index;
            this.expand = expand;
        }

        public Component getTab() {
            TabPane tabPane = (TabPane)TerraTabPaneSkin.this.getComponent();
            return tabPane.getTabs().get(this.index);
        }

        public float getScale() {
            int elapsedTime = this.getElapsedTime();
            int duration = this.getDuration();
            float scale = this.expand ? this.easing.easeOut((float)elapsedTime, 0.0f, 1.0f, (float)duration) : this.easing.easeIn((float)elapsedTime, 1.0f, -1.0f, (float)duration);
            return scale;
        }

        public void start(TransitionListener transitionListener) {
            TabPane tabPane = (TabPane)TerraTabPaneSkin.this.getComponent();
            if (this.expand) {
                this.getTab().setVisible(true);
            }
            this.getTab().getDecorators().add((Decorator)TerraTabPaneSkin.this.clipDecorator);
            tabPane.setEnabled(false);
            super.start(transitionListener);
        }

        public void stop() {
            TabPane tabPane = (TabPane)TerraTabPaneSkin.this.getComponent();
            if (!this.expand) {
                this.getTab().setVisible(false);
            }
            this.getTab().getDecorators().remove((Decorator)TerraTabPaneSkin.this.clipDecorator);
            tabPane.setEnabled(true);
            super.stop();
        }

        protected void update() {
            TerraTabPaneSkin.this.invalidateComponent();
        }
    }

    public class TabButtonSkin
    extends ButtonSkin {
        public int getPreferredWidth(int height) {
            Dimensions preferredSize = this.getPreferredSize();
            return preferredSize.width;
        }

        public int getPreferredHeight(int width) {
            Dimensions preferredSize = this.getPreferredSize();
            return preferredSize.height;
        }

        public Dimensions getPreferredSize() {
            TabButton tabButton = (TabButton)this.getComponent();
            TabPane tabPane = (TabPane)TerraTabPaneSkin.this.getComponent();
            Button.DataRenderer dataRenderer = tabButton.getDataRenderer();
            dataRenderer.render(tabButton.getButtonData(), (Button)tabButton, false);
            Dimensions preferredContentSize = dataRenderer.getPreferredSize();
            int preferredWidth = 0;
            int preferredHeight = 0;
            switch (TerraTabPaneSkin.this.tabOrientation) {
                case HORIZONTAL: {
                    preferredWidth = preferredContentSize.width + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.left + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.right + 2;
                    preferredHeight = preferredContentSize.height + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.bottom + 2;
                    if (!tabPane.isCloseable() || !tabButton.isSelected()) break;
                    preferredWidth += 6 + TerraTabPaneSkin.this.buttonSpacing;
                    break;
                }
                case VERTICAL: {
                    preferredWidth = preferredContentSize.height + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.bottom + 2;
                    preferredHeight = preferredContentSize.width + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.left + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.right + 2;
                    if (!tabPane.isCloseable() || !tabButton.isSelected()) break;
                    preferredHeight += 6 + TerraTabPaneSkin.this.buttonSpacing;
                    break;
                }
            }
            Dimensions preferredSize = new Dimensions(preferredWidth, preferredHeight);
            return preferredSize;
        }

        public int getBaseline(int width, int height) {
            TabButton tabButton = (TabButton)this.getComponent();
            Button.DataRenderer dataRenderer = tabButton.getDataRenderer();
            dataRenderer.render(tabButton.getButtonData(), (Button)tabButton, false);
            int clientWidth = Math.max(width - (((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.left + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.right + 2), 0);
            int clientHeight = Math.max(height - (((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.bottom + 2), 0);
            int baseline = dataRenderer.getBaseline(clientWidth, clientHeight);
            if (baseline != -1) {
                baseline += ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + 1;
            }
            return baseline;
        }

        public void paint(Graphics2D graphics) {
            Color buttonBevelColor;
            Color backgroundColor;
            boolean active;
            TabButton tabButton = (TabButton)this.getComponent();
            TabPane tabPane = (TabPane)TerraTabPaneSkin.this.getComponent();
            boolean bl = active = TerraTabPaneSkin.this.selectionChangeTransition != null && TerraTabPaneSkin.this.selectionChangeTransition.getTab() == tabButton.tab;
            if (tabButton.isSelected() || active) {
                backgroundColor = TerraTabPaneSkin.this.activeTabColor;
                buttonBevelColor = TerraTabPaneSkin.this.activeButtonBevelColor;
            } else {
                backgroundColor = TerraTabPaneSkin.this.inactiveTabColor;
                buttonBevelColor = TerraTabPaneSkin.this.inactiveButtonBevelColor;
            }
            int width = this.getWidth();
            int height = this.getHeight();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            switch (TerraTabPaneSkin.this.tabOrientation) {
                case HORIZONTAL: {
                    graphics.setPaint(new GradientPaint((float)width / 2.0f, 0.0f, buttonBevelColor, (float)width / 2.0f, (float)height / 2.0f, backgroundColor));
                    graphics.fill(new RoundRectangle2D.Double(0.5, 0.5, width - 1, height - 1 + TerraTabPaneSkin.this.buttonCornerRadius, TerraTabPaneSkin.this.buttonCornerRadius, TerraTabPaneSkin.this.buttonCornerRadius));
                    break;
                }
                case VERTICAL: {
                    graphics.setPaint(new GradientPaint(0.0f, (float)height / 2.0f, buttonBevelColor, (float)width / 2.0f, (float)height / 2.0f, backgroundColor));
                    graphics.fill(new RoundRectangle2D.Double(0.5, 0.5, width - 1 + TerraTabPaneSkin.this.buttonCornerRadius, height - 1, TerraTabPaneSkin.this.buttonCornerRadius, TerraTabPaneSkin.this.buttonCornerRadius));
                    break;
                }
            }
            graphics.setPaint(tabButton.isSelected() || active ? TerraTabPaneSkin.this.borderColor : TerraTabPaneSkin.this.inactiveBorderColor);
            graphics.setStroke(new BasicStroke(1.0f));
            switch (TerraTabPaneSkin.this.tabOrientation) {
                case HORIZONTAL: {
                    graphics.draw(new RoundRectangle2D.Double(0.5, 0.5, width - 1, height + TerraTabPaneSkin.this.buttonCornerRadius - 1, TerraTabPaneSkin.this.buttonCornerRadius, TerraTabPaneSkin.this.buttonCornerRadius));
                    break;
                }
                case VERTICAL: {
                    graphics.draw(new RoundRectangle2D.Double(0.5, 0.5, width + TerraTabPaneSkin.this.buttonCornerRadius - 1, height - 1, TerraTabPaneSkin.this.buttonCornerRadius, TerraTabPaneSkin.this.buttonCornerRadius));
                    break;
                }
            }
            if (!tabButton.isSelected() && !active) {
                graphics.setPaint(TerraTabPaneSkin.this.borderColor);
                switch (TerraTabPaneSkin.this.tabOrientation) {
                    case HORIZONTAL: {
                        graphics.draw(new Line2D.Double(0.5, (double)height - 0.5, (double)width - 0.5, (double)height - 0.5));
                        break;
                    }
                    case VERTICAL: {
                        graphics.draw(new Line2D.Double((double)width - 0.5, 0.5, (double)width - 0.5, (double)height - 0.5));
                        break;
                    }
                }
            }
            Button.DataRenderer dataRenderer = tabButton.getDataRenderer();
            dataRenderer.render(tabButton.getButtonData(), (Button)tabButton, false);
            Graphics2D contentGraphics = (Graphics2D)graphics.create();
            contentGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            switch (TerraTabPaneSkin.this.tabOrientation) {
                case HORIZONTAL: {
                    int contentWidth = this.getWidth() - (((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.left + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.right + 2);
                    if (tabPane.isCloseable() && tabButton.isSelected()) {
                        contentWidth -= 6 + TerraTabPaneSkin.this.buttonSpacing;
                    }
                    dataRenderer.setSize(Math.max(contentWidth, 0), Math.max(this.getHeight() - (((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.bottom + 2), 0));
                    contentGraphics.translate(((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.left + 1, ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + 1);
                    break;
                }
                case VERTICAL: {
                    int contentWidth = this.getHeight() - (((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.bottom + 2);
                    if (tabPane.isCloseable() && tabButton.isSelected()) {
                        contentWidth -= 6 + TerraTabPaneSkin.this.buttonSpacing;
                    }
                    dataRenderer.setSize(Math.max(contentWidth, 0), Math.max(this.getWidth() - (((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.left + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.right + 2), 0));
                    contentGraphics.translate(((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.top + 1, ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.left + 1);
                    contentGraphics.rotate(-1.5707963267948966);
                    contentGraphics.translate(-dataRenderer.getWidth(), 0);
                    break;
                }
            }
            contentGraphics.clipRect(0, 0, dataRenderer.getWidth(), dataRenderer.getHeight());
            dataRenderer.paint(contentGraphics);
            contentGraphics.dispose();
            if (tabPane.isCloseable() && tabButton.isSelected()) {
                graphics.setStroke(new BasicStroke(2.5f));
                int x = 0;
                int y = 0;
                switch (TerraTabPaneSkin.this.tabOrientation) {
                    case HORIZONTAL: {
                        x = width - (((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.right + 6 + 1);
                        y = (height - 6) / 2;
                        break;
                    }
                    case VERTICAL: {
                        x = (width - 6) / 2;
                        y = height - (((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.bottom + 6 + 1);
                        break;
                    }
                }
                graphics.draw(new Line2D.Double(x, y, x + 6 - 1, y + 6 - 1));
                graphics.draw(new Line2D.Double(x, y + 6 - 1, x + 6 - 1, y));
            }
        }

        public boolean isFocusable() {
            return false;
        }

        public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
            boolean consumed = super.mouseClick(component, button, x, y, count);
            TabButton tabButton = (TabButton)this.getComponent();
            TabPane tabPane = (TabPane)TerraTabPaneSkin.this.getComponent();
            if (tabPane.isCloseable() && tabButton.isSelected() && this.getCloseTriggerBounds().contains(x, y)) {
                tabPane.getTabs().remove(tabButton.tab);
            } else {
                tabButton.press();
            }
            return consumed;
        }

        public Font getFont() {
            return TerraTabPaneSkin.this.buttonFont;
        }

        public Color getColor() {
            return TerraTabPaneSkin.this.buttonColor;
        }

        public Color getDisabledColor() {
            return TerraTabPaneSkin.this.disabledButtonColor;
        }

        public void stateChanged(Button button, Button.State previousState) {
            super.stateChanged(button, previousState);
            this.invalidateComponent();
        }

        public Bounds getCloseTriggerBounds() {
            Bounds bounds = null;
            switch (TerraTabPaneSkin.this.tabOrientation) {
                case HORIZONTAL: {
                    bounds = new Bounds(this.getWidth() - (6 + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.right + 1) - 2, (this.getHeight() - 6) / 2 - 2, 10, 10);
                    break;
                }
                case VERTICAL: {
                    bounds = new Bounds((this.getWidth() - 6) / 2 - 2, this.getHeight() - (6 + ((TerraTabPaneSkin)TerraTabPaneSkin.this).buttonPadding.bottom + 1) - 2, 10, 10);
                    break;
                }
            }
            return bounds;
        }
    }

    public class TabButton
    extends Button {
        private final Component tab;

        public TabButton(Component tab) {
            this.tab = tab;
            super.setToggleButton(true);
            this.setSkin((Skin)new TabButtonSkin());
        }

        public Object getButtonData() {
            return TabPane.getTabData((Component)this.tab);
        }

        public void setButtonData(Object buttonData) {
            throw new UnsupportedOperationException();
        }

        public Button.DataRenderer getDataRenderer() {
            TabPane tabPane = (TabPane)TerraTabPaneSkin.this.getComponent();
            return tabPane.getTabDataRenderer();
        }

        public void setDataRenderer(Button.DataRenderer dataRenderer) {
            throw new UnsupportedOperationException();
        }

        public String getTooltipText() {
            return TabPane.getTooltipText((Component)this.tab);
        }

        public void setTooltipText(String tooltipText) {
            throw new UnsupportedOperationException();
        }

        public void setToggleButton(boolean toggleButton) {
            throw new UnsupportedOperationException();
        }

        public void setTriState(boolean triState) {
            throw new UnsupportedOperationException();
        }

        public void press() {
            TabPane tabPane = (TabPane)TerraTabPaneSkin.this.getComponent();
            this.setSelected(tabPane.isCollapsible() ? !this.isSelected() : true);
            super.press();
        }
    }
}

