/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.SortDirection;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TableViewColumnListener;
import org.apache.pivot.wtk.TableViewHeader;
import org.apache.pivot.wtk.TableViewHeaderListener;
import org.apache.pivot.wtk.TableViewSortListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.terra.TerraTableViewSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraTableViewHeaderSkin
extends ComponentSkin
implements TableViewHeader.Skin,
TableViewHeaderListener,
TableViewColumnListener,
TableViewSortListener {
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color backgroundColor;
    private Color disabledBackgroundColor;
    private Color borderColor;
    private Color disabledBorderColor;
    private boolean headersPressable;
    private boolean columnsResizable;
    private boolean includeTrailingVerticalGridLine;
    private Color bevelColor;
    private Color pressedBevelColor;
    private Color disabledBevelColor;
    private ArrayList<Integer> headerWidths = null;
    private int pressedHeaderIndex = -1;
    private int resizeHeaderIndex = -1;
    private static final int SORT_INDICATOR_PADDING = 2;
    private static final int RESIZE_HANDLE_SIZE = 6;
    public static final int MINIMUM_COLUMN_WIDTH = 2;
    private SortIndicatorImage sortAscendingImage = new SortIndicatorImage(SortDirection.ASCENDING);
    private SortIndicatorImage sortDescendingImage = new SortIndicatorImage(SortDirection.DESCENDING);

    public TerraTableViewHeaderSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.font = theme.getFont();
        this.color = theme.getColor(1);
        this.disabledColor = theme.getColor(7);
        this.backgroundColor = theme.getColor(10);
        this.disabledBackgroundColor = theme.getColor(10);
        this.borderColor = theme.getColor(7);
        this.disabledBorderColor = theme.getColor(7);
        this.headersPressable = true;
        this.columnsResizable = true;
        this.includeTrailingVerticalGridLine = false;
        this.bevelColor = TerraTheme.brighten(this.backgroundColor);
        this.pressedBevelColor = TerraTheme.darken(this.backgroundColor);
        this.disabledBevelColor = this.disabledBackgroundColor;
    }

    public void install(Component component) {
        super.install(component);
        TableViewHeader tableViewHeader = (TableViewHeader)component;
        tableViewHeader.getTableViewHeaderListeners().add((Object)this);
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            tableView.getTableViewColumnListeners().add((Object)this);
            tableView.getTableViewSortListeners().add((Object)this);
        }
    }

    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            preferredWidth = TerraTableViewSkin.getPreferredWidth(tableView, this.includeTrailingVerticalGridLine);
        }
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            TableView.ColumnSequence columns = tableView.getColumns();
            int n = columns.getLength();
            for (int i = 0; i < n; ++i) {
                TableView.Column column = columns.get(i);
                TableView.HeaderDataRenderer headerDataRenderer = column.getHeaderDataRenderer();
                headerDataRenderer.render(column.getHeaderData(), i, tableViewHeader, column.getName(), false);
                preferredHeight = Math.max(preferredHeight, headerDataRenderer.getPreferredHeight(-1));
            }
            ++preferredHeight;
        }
        return preferredHeight;
    }

    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    public int getBaseline(int width, int height) {
        int baseline = -1;
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            ArrayList<Integer> headerWidthsLocal = TerraTableViewSkin.getColumnWidths(tableView, width);
            int rowHeight = this.getPreferredHeight(width) - 1;
            TableView.ColumnSequence columns = tableView.getColumns();
            int n = columns.getLength();
            for (int i = 0; i < n; ++i) {
                TableView.Column column = columns.get(i);
                TableView.HeaderDataRenderer headerDataRenderer = column.getHeaderDataRenderer();
                headerDataRenderer.render(column.getHeaderData(), i, tableViewHeader, column.getName(), false);
                baseline = Math.max(baseline, headerDataRenderer.getBaseline(((Integer)headerWidthsLocal.get(i)).intValue(), rowHeight));
            }
        }
        return baseline;
    }

    public void layout() {
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        TableView tableView = tableViewHeader.getTableView();
        this.headerWidths = tableView != null ? TerraTableViewSkin.getColumnWidths(tableView, this.getWidth()) : null;
    }

    public void paint(Graphics2D graphics) {
        int width = this.getWidth();
        int height = this.getHeight();
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        Color backgroundColorLocal = null;
        Color bevelColorLocal = null;
        Color borderColorLocal = null;
        if (tableViewHeader.isEnabled()) {
            backgroundColorLocal = this.backgroundColor;
            bevelColorLocal = this.bevelColor;
            borderColorLocal = this.borderColor;
        } else {
            backgroundColorLocal = this.disabledBackgroundColor;
            bevelColorLocal = this.disabledBevelColor;
            borderColorLocal = this.disabledBorderColor;
        }
        graphics.setPaint(new GradientPaint((float)width / 2.0f, 0.0f, bevelColorLocal, (float)width / 2.0f, height, backgroundColorLocal));
        graphics.fillRect(0, 0, width, height);
        graphics.setPaint(borderColorLocal);
        graphics.setStroke(new BasicStroke(1.0f));
        graphics.draw(new Line2D.Double(0.5, (double)height - 0.5, (double)width - 0.5, (double)height - 0.5));
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            TableView.ColumnSequence columns = tableView.getColumns();
            int headerX = 0;
            int columnCount = columns.getLength();
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                TableView.Column column = columns.get(columnIndex);
                int headerWidth = (Integer)this.headerWidths.get(columnIndex);
                if (columnIndex == this.pressedHeaderIndex) {
                    graphics.setPaint(new GradientPaint((float)width / 2.0f, 0.0f, this.pressedBevelColor, (float)width / 2.0f, height, backgroundColorLocal));
                    graphics.fillRect(headerX, 0, headerWidth, height - 1);
                }
                Object headerData = column.getHeaderData();
                TableView.HeaderDataRenderer headerDataRenderer = column.getHeaderDataRenderer();
                headerDataRenderer.render(headerData, columnIndex, tableViewHeader, column.getName(), false);
                headerDataRenderer.setSize(headerWidth, height - 1);
                Graphics2D rendererGraphics = (Graphics2D)graphics.create(headerX, 0, headerWidth, height - 1);
                headerDataRenderer.paint(rendererGraphics);
                rendererGraphics.dispose();
                SortIndicatorImage sortImage = null;
                String columnName = column.getName();
                SortDirection sortDirection = tableView.getSort().get(columnName);
                if (sortDirection != null) {
                    switch (sortDirection) {
                        case ASCENDING: {
                            sortImage = this.sortAscendingImage;
                            break;
                        }
                        case DESCENDING: {
                            sortImage = this.sortDescendingImage;
                            break;
                        }
                    }
                }
                if (sortImage != null) {
                    int sortImageMargin = sortImage.getWidth() + 4;
                    if (headerWidth >= headerDataRenderer.getPreferredWidth(-1) + sortImageMargin) {
                        Graphics2D sortImageGraphics = (Graphics2D)graphics.create();
                        sortImageGraphics.translate(headerX + headerWidth - sortImageMargin, (height - sortImage.getHeight()) / 2);
                        sortImage.paint(sortImageGraphics);
                        sortImageGraphics.dispose();
                    }
                }
                headerX += headerWidth;
                if (columnIndex < columnCount - 1 || this.includeTrailingVerticalGridLine) {
                    graphics.setPaint(borderColorLocal);
                    graphics.draw(new Line2D.Double((double)headerX + 0.5, 0.5, (double)headerX + 0.5, (double)height - 0.5));
                }
                ++headerX;
            }
        }
    }

    public int getHeaderAt(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("x is negative");
        }
        int headerIndex = -1;
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            int headerX;
            int i = 0;
            int n = tableView.getColumns().getLength();
            for (headerX = 0; i < n && x > headerX; headerX += (Integer)this.headerWidths.get(i) + 1, ++i) {
            }
            if (x <= headerX) {
                headerIndex = i - 1;
            }
        }
        return headerIndex;
    }

    public Bounds getHeaderBounds(int headerIndex) {
        Bounds headerBounds = null;
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            if (headerIndex < 0 || headerIndex >= this.headerWidths.getLength()) {
                throw new IndexOutOfBoundsException();
            }
            int cellX = 0;
            for (int i = 0; i < headerIndex; ++i) {
                cellX += (Integer)this.headerWidths.get(i) + 1;
            }
            headerBounds = new Bounds(cellX, 0, ((Integer)this.headerWidths.get(headerIndex)).intValue(), this.getHeight() - 1);
        }
        return headerBounds;
    }

    public boolean isFocusable() {
        return false;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraTableViewHeaderSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public final void setColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setColor(theme.getColor(color));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public final void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public final void setDisabledColor(int disabledColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(theme.getColor(disabledColor));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.backgroundColor = backgroundColor;
        this.bevelColor = TerraTheme.brighten(backgroundColor);
        this.pressedBevelColor = TerraTheme.darken(backgroundColor);
        this.repaintComponent();
    }

    public final void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)backgroundColor));
    }

    public final void setBackgroundColor(int backgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(backgroundColor));
    }

    public Color getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    public void setDisabledBackgroundColor(Color disabledBackgroundColor) {
        if (disabledBackgroundColor == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.disabledBackgroundColor = disabledBackgroundColor;
        this.disabledBevelColor = disabledBackgroundColor;
        this.repaintComponent();
    }

    public final void setDisabledBackgroundColor(String disabledBackgroundColor) {
        if (disabledBackgroundColor == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.setDisabledBackgroundColor(GraphicsUtilities.decodeColor((String)disabledBackgroundColor));
    }

    public final void setDisabledBackgroundColor(int disabledBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledBackgroundColor(theme.getColor(disabledBackgroundColor));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = borderColor;
        this.repaintComponent();
    }

    public final void setBorderColor(String borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)borderColor));
    }

    public final void setBorderColor(int borderColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBorderColor(theme.getColor(borderColor));
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color disabledBorderColor) {
        if (disabledBorderColor == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.disabledBorderColor = disabledBorderColor;
        this.repaintComponent();
    }

    public final void setDisabledBorderColor(String disabledBorderColor) {
        if (disabledBorderColor == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.setDisabledBorderColor(GraphicsUtilities.decodeColor((String)disabledBorderColor));
    }

    public final void setDisabledBorderColor(int disabledBorderColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledBorderColor(theme.getColor(disabledBorderColor));
    }

    public boolean getHeadersPressable() {
        return this.headersPressable;
    }

    public void setHeadersPressable(boolean headersPressable) {
        this.headersPressable = headersPressable;
        this.pressedHeaderIndex = -1;
        this.repaintComponent();
    }

    public boolean getColumnsResizable() {
        return this.columnsResizable;
    }

    public void setColumnsResizable(boolean columnsResizable) {
        this.columnsResizable = columnsResizable;
    }

    public boolean getIncludeTrailingVerticalGridLine() {
        return this.includeTrailingVerticalGridLine;
    }

    public void setIncludeTrailingVerticalGridLine(boolean includeTrailingVerticalGridLine) {
        this.includeTrailingVerticalGridLine = includeTrailingVerticalGridLine;
        this.invalidateComponent();
    }

    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.pressedHeaderIndex = -1;
        this.resizeHeaderIndex = -1;
        this.repaintComponent();
    }

    public boolean mouseMove(Component component, int x, int y) {
        boolean consumed = super.mouseMove(component, x, y);
        TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
        TableView tableView = tableViewHeader.getTableView();
        if (tableView != null) {
            if (this.resizeHeaderIndex != -1 && Mouse.getCapturer() != tableViewHeader) {
                Mouse.capture((Component)tableViewHeader);
            }
            if (Mouse.getCapturer() == tableViewHeader) {
                TableView.Column column = tableView.getColumns().get(this.resizeHeaderIndex);
                Bounds headerBounds = this.getHeaderBounds(this.resizeHeaderIndex);
                int columnWidth = Math.max(x - headerBounds.x, 2);
                column.setWidth(columnWidth, false);
            } else {
                int headerIndex = this.getHeaderAt(x);
                if (headerIndex != -1 && this.columnsResizable) {
                    Bounds headerBounds = this.getHeaderBounds(headerIndex);
                    TableView.Column column = tableView.getColumns().get(headerIndex);
                    if (!column.isRelative() && column.getWidth() != -1 && x > headerBounds.x + headerBounds.width - 6) {
                        tableViewHeader.setCursor(Cursor.RESIZE_EAST);
                    } else {
                        tableViewHeader.setCursor((Cursor)null);
                    }
                } else {
                    tableViewHeader.setCursor((Cursor)null);
                }
            }
        }
        return consumed;
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        if (this.pressedHeaderIndex != -1) {
            this.repaintComponent(this.getHeaderBounds(this.pressedHeaderIndex));
        }
        this.pressedHeaderIndex = -1;
    }

    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        int headerIndex;
        TableViewHeader tableViewHeader;
        TableView tableView;
        boolean consumed = super.mouseDown(component, button, x, y);
        if (button == Mouse.Button.LEFT && (tableView = (tableViewHeader = (TableViewHeader)this.getComponent()).getTableView()) != null && (headerIndex = this.getHeaderAt(x)) != -1) {
            Bounds headerBounds = this.getHeaderBounds(headerIndex);
            TableView.Column column = tableView.getColumns().get(headerIndex);
            if (this.columnsResizable && !column.isRelative() && column.getWidth() != -1 && x > headerBounds.x + headerBounds.width - 6) {
                this.resizeHeaderIndex = headerIndex;
            } else if (this.headersPressable) {
                this.pressedHeaderIndex = headerIndex;
                this.repaintComponent(headerBounds);
            }
        }
        return consumed;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        if (button == Mouse.Button.LEFT) {
            if (this.resizeHeaderIndex != -1) {
                if (Mouse.getCapturer() == component) {
                    Mouse.release();
                    this.resizeHeaderIndex = -1;
                }
            } else if (this.pressedHeaderIndex != -1) {
                this.repaintComponent(this.getHeaderBounds(this.pressedHeaderIndex));
            }
        }
        return consumed;
    }

    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        boolean consumed = super.mouseClick(component, button, x, y, count);
        if (button == Mouse.Button.LEFT) {
            TableViewHeader tableViewHeader = (TableViewHeader)this.getComponent();
            TableView tableView = tableViewHeader.getTableView();
            if (this.resizeHeaderIndex != -1) {
                TableView.Column column = tableView.getColumns().get(this.resizeHeaderIndex);
                if (count == 2 && !column.isRelative() && column.getWidth() != -1) {
                    int columnWidth = 0;
                    TableView.CellRenderer cellRenderer = column.getCellRenderer();
                    List tableData = tableView.getTableData();
                    int rowIndex = 0;
                    for (Object rowData : tableData) {
                        cellRenderer.render(rowData, rowIndex++, this.resizeHeaderIndex, tableView, column.getName(), false, false, false);
                        columnWidth = Math.max(cellRenderer.getPreferredWidth(-1), columnWidth);
                    }
                    column.setWidth(columnWidth);
                }
            } else if (this.pressedHeaderIndex != -1) {
                tableViewHeader.pressHeader(this.pressedHeaderIndex);
                TableViewHeader.SortMode sortMode = tableViewHeader.getSortMode();
                if (sortMode != TableViewHeader.SortMode.NONE) {
                    TableView.Column column = tableView.getColumns().get(this.pressedHeaderIndex);
                    String columnName = column.getName();
                    SortDirection sortDirection = tableView.getSort().get(columnName);
                    sortDirection = sortDirection == null ? SortDirection.ASCENDING : (sortDirection == SortDirection.ASCENDING ? SortDirection.DESCENDING : SortDirection.ASCENDING);
                    if (sortMode == TableViewHeader.SortMode.MULTI_COLUMN && Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                        tableView.getSort().put(columnName, sortDirection);
                    } else {
                        tableView.setSort(columnName, sortDirection);
                    }
                    consumed = true;
                }
            }
            this.resizeHeaderIndex = -1;
            this.pressedHeaderIndex = -1;
        }
        return consumed;
    }

    public void tableViewChanged(TableViewHeader tableViewHeader, TableView previousTableView) {
        TableView tableView;
        if (previousTableView != null) {
            previousTableView.getTableViewColumnListeners().remove((Object)this);
            previousTableView.getTableViewSortListeners().remove((Object)this);
        }
        if ((tableView = tableViewHeader.getTableView()) != null) {
            tableView.getTableViewColumnListeners().add((Object)this);
            tableView.getTableViewSortListeners().add((Object)this);
        }
        this.invalidateComponent();
    }

    public void sortModeChanged(TableViewHeader tableViewHeader, TableViewHeader.SortMode previousSortMode) {
    }

    public void columnInserted(TableView tableView, int index) {
        this.invalidateComponent();
    }

    public void columnsRemoved(TableView tableView, int index, Sequence<TableView.Column> columns) {
        this.invalidateComponent();
    }

    public void columnNameChanged(TableView.Column column, String previousName) {
    }

    public void columnHeaderDataChanged(TableView.Column column, Object previousHeaderData) {
        this.invalidateComponent();
    }

    public void columnHeaderDataRendererChanged(TableView.Column column, TableView.HeaderDataRenderer previousHeaderDataRenderer) {
        this.invalidateComponent();
    }

    public void columnWidthChanged(TableView.Column column, int previousWidth, boolean previousRelative) {
        this.invalidateComponent();
    }

    public void columnWidthLimitsChanged(TableView.Column column, int previousMinimumWidth, int previousMaximumWidth) {
        this.invalidateComponent();
    }

    public void columnFilterChanged(TableView.Column column, Object previousFilter) {
    }

    public void columnCellRendererChanged(TableView.Column column, TableView.CellRenderer previousCellRenderer) {
    }

    public void sortAdded(TableView tableView, String columnName) {
        this.repaintComponent();
    }

    public void sortUpdated(TableView tableView, String columnName, SortDirection previousSortDirection) {
        this.repaintComponent();
    }

    public void sortRemoved(TableView tableView, String columnName, SortDirection sortDirection) {
        this.repaintComponent();
    }

    public void sortChanged(TableView tableView) {
        this.repaintComponent();
    }

    private class SortIndicatorImage
    extends Image {
        private SortDirection sortDirection = null;

        public SortIndicatorImage(SortDirection sortDirection) {
            this.sortDirection = sortDirection;
        }

        public int getWidth() {
            return 7;
        }

        public int getHeight() {
            return 4;
        }

        public void paint(Graphics2D graphics) {
            GeneralPath shape = new GeneralPath();
            switch (this.sortDirection) {
                case ASCENDING: {
                    shape.moveTo(0.0f, 3.0f);
                    shape.lineTo(3.0f, 0.0f);
                    shape.lineTo(6.0f, 3.0f);
                    break;
                }
                case DESCENDING: {
                    shape.moveTo(0.0f, 0.0f);
                    shape.lineTo(3.0f, 3.0f);
                    shape.lineTo(6.0f, 0.0f);
                    break;
                }
            }
            shape.closePath();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setStroke(new BasicStroke(0.0f));
            graphics.setPaint(TerraTableViewHeaderSkin.this.borderColor);
            graphics.draw(shape);
            graphics.fill(shape);
        }
    }
}

