/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableList;
import org.apache.pivot.util.Filter;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.SortDirection;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TableViewColumnListener;
import org.apache.pivot.wtk.TableViewListener;
import org.apache.pivot.wtk.TableViewRowListener;
import org.apache.pivot.wtk.TableViewSelectionListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraTableViewSkin
extends ComponentSkin
implements TableView.Skin,
TableViewListener,
TableViewColumnListener,
TableViewRowListener,
TableViewSelectionListener {
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color backgroundColor;
    private Color selectionColor;
    private Color selectionBackgroundColor;
    private Color inactiveSelectionColor;
    private Color inactiveSelectionBackgroundColor;
    private Color highlightBackgroundColor;
    private Color alternateRowBackgroundColor;
    private Color columnSelectionColor;
    private Color columnSelectionHorizontalGridColor;
    private Color horizontalGridColor;
    private Color verticalGridColor;
    private boolean showHighlight;
    private boolean showHorizontalGridLines;
    private boolean showVerticalGridLines;
    private boolean includeTrailingVerticalGridLine;
    private boolean includeTrailingHorizontalGridLine;
    private boolean variableRowHeight;
    private boolean editOnMouseDown;
    private ArrayList<Integer> columnWidths = null;
    private ArrayList<Integer> rowBoundaries = null;
    private int fixedRowHeight = -1;
    private int defaultWidthColumnCount = 0;
    private int highlightIndex = -1;
    private int selectIndex = -1;
    private boolean validateSelection = false;

    public TerraTableViewSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.font = theme.getFont();
        this.color = theme.getColor(1);
        this.disabledColor = theme.getColor(7);
        this.backgroundColor = theme.getColor(4);
        this.selectionColor = theme.getColor(4);
        this.selectionBackgroundColor = theme.getColor(14);
        this.inactiveSelectionColor = theme.getColor(1);
        this.inactiveSelectionBackgroundColor = theme.getColor(9);
        this.highlightBackgroundColor = theme.getColor(10);
        this.alternateRowBackgroundColor = theme.getColor(11);
        this.columnSelectionColor = null;
        this.columnSelectionHorizontalGridColor = null;
        this.horizontalGridColor = theme.getColor(11);
        this.verticalGridColor = theme.getColor(11);
        this.showHighlight = true;
        this.showHorizontalGridLines = true;
        this.showVerticalGridLines = true;
        this.includeTrailingVerticalGridLine = false;
        this.includeTrailingHorizontalGridLine = false;
        this.editOnMouseDown = false;
    }

    public void install(Component component) {
        super.install(component);
        TableView tableView = (TableView)component;
        tableView.getTableViewListeners().add((Object)this);
        tableView.getTableViewColumnListeners().add((Object)this);
        tableView.getTableViewRowListeners().add((Object)this);
        tableView.getTableViewSelectionListeners().add((Object)this);
    }

    public int getPreferredWidth(int height) {
        return TerraTableViewSkin.getPreferredWidth((TableView)this.getComponent(), this.includeTrailingVerticalGridLine);
    }

    public static int getPreferredWidth(TableView tableView, boolean includeTrailingVerticalGridLine) {
        int preferredWidth = 0;
        TableView.ColumnSequence columns = tableView.getColumns();
        List tableData = tableView.getTableData();
        int n = columns.getLength();
        for (int i = 0; i < n; ++i) {
            TableView.Column column = columns.get(i);
            if (!column.isRelative()) {
                int columnWidth = column.getWidth();
                if (columnWidth == -1) {
                    columnWidth = 0;
                    TableView.CellRenderer cellRenderer = column.getCellRenderer();
                    int rowIndex = 0;
                    for (Object rowData : tableData) {
                        cellRenderer.render(rowData, rowIndex++, i, tableView, column.getName(), false, false, false);
                        columnWidth = Math.max(cellRenderer.getPreferredWidth(-1), columnWidth);
                    }
                }
                preferredWidth += Math.min(Math.max(columnWidth, column.getMinimumWidth()), column.getMaximumWidth());
                continue;
            }
            preferredWidth += column.getMinimumWidth();
        }
        preferredWidth += n - 1;
        if (includeTrailingVerticalGridLine) {
            ++preferredWidth;
        }
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        TableView tableView = (TableView)this.getComponent();
        int n = tableView.getTableData().getLength();
        if (this.variableRowHeight) {
            ArrayList<Integer> columnWidthsLocal = TerraTableViewSkin.getColumnWidths(tableView, width);
            for (int i = 0; i < n; ++i) {
                preferredHeight += this.getVariableRowHeight(i, columnWidthsLocal);
            }
        } else {
            int fixedRowHeightLocal = TerraTableViewSkin.calculateFixedRowHeight(tableView);
            preferredHeight = fixedRowHeightLocal * n;
        }
        preferredHeight += n - 1;
        if (this.includeTrailingHorizontalGridLine) {
            ++preferredHeight;
        }
        return preferredHeight;
    }

    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    public int getBaseline(int width, int height) {
        TableView tableView = (TableView)this.getComponent();
        List tableData = tableView.getTableData();
        int baseline = -1;
        TableView.ColumnSequence columns = tableView.getColumns();
        ArrayList<Integer> columnWidthsLocal = TerraTableViewSkin.getColumnWidths(tableView, width);
        if (this.variableRowHeight) {
            int rowHeight = this.getVariableRowHeight(0, columnWidthsLocal);
            Object rowData = tableData.get(0);
            int n = columns.getLength();
            for (int i = 0; i < n; ++i) {
                TableView.Column column = columns.get(i);
                TableView.CellRenderer cellRenderer = column.getCellRenderer();
                cellRenderer.render(rowData, 0, i, tableView, column.getName(), false, false, false);
                baseline = Math.max(baseline, cellRenderer.getBaseline(((Integer)columnWidthsLocal.get(i)).intValue(), rowHeight));
            }
        } else {
            int rowHeight = TerraTableViewSkin.calculateFixedRowHeight(tableView);
            int n = columns.getLength();
            for (int i = 0; i < n; ++i) {
                TableView.Column column = columns.get(i);
                TableView.CellRenderer cellRenderer = column.getCellRenderer();
                cellRenderer.render(null, -1, i, tableView, column.getName(), false, false, false);
                baseline = Math.max(baseline, cellRenderer.getBaseline(((Integer)columnWidthsLocal.get(i)).intValue(), rowHeight));
            }
        }
        return baseline;
    }

    public void layout() {
        ImmutableList selectedRanges;
        this.columnWidths = TerraTableViewSkin.getColumnWidths((TableView)this.getComponent(), this.getWidth());
        TableView tableView = (TableView)this.getComponent();
        TableView.ColumnSequence columns = tableView.getColumns();
        if (this.variableRowHeight) {
            List tableData = tableView.getTableData();
            int n = tableData.getLength();
            this.rowBoundaries = new ArrayList(n);
            int rowY = 0;
            for (int i = 0; i < n; ++i) {
                Object rowData = tableData.get(i);
                int rowHeight = 0;
                int columnCount = columns.getLength();
                for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                    TableView.Column column = columns.get(columnIndex);
                    TableView.CellRenderer cellRenderer = column.getCellRenderer();
                    int columnWidth = (Integer)this.columnWidths.get(columnIndex);
                    cellRenderer.render(rowData, i, columnIndex, tableView, column.getName(), false, false, false);
                    rowHeight = Math.max(rowHeight, cellRenderer.getPreferredHeight(columnWidth));
                }
                this.rowBoundaries.add((Object)(rowY += rowHeight));
                ++rowY;
            }
        } else {
            this.fixedRowHeight = TerraTableViewSkin.calculateFixedRowHeight(tableView);
        }
        if (this.validateSelection && (selectedRanges = tableView.getSelectedRanges()).getLength() > 0) {
            int rangeStart = ((Span)selectedRanges.get((int)0)).start;
            int rangeEnd = ((Span)selectedRanges.get((int)(selectedRanges.getLength() - 1))).end;
            Bounds selectionBounds = this.getRowBounds(rangeStart);
            Bounds visibleSelectionBounds = tableView.getVisibleArea(selectionBounds = selectionBounds.union(this.getRowBounds(rangeEnd)));
            if (visibleSelectionBounds != null && visibleSelectionBounds.height < selectionBounds.height) {
                tableView.scrollAreaToVisible(selectionBounds);
            }
        }
        this.validateSelection = false;
    }

    private static int calculateFixedRowHeight(TableView tableView) {
        int fixedRowHeight = 0;
        TableView.ColumnSequence columns = tableView.getColumns();
        int n = columns.getLength();
        for (int i = 0; i < n; ++i) {
            TableView.Column column = columns.get(i);
            TableView.CellRenderer cellRenderer = column.getCellRenderer();
            cellRenderer.render(null, -1, i, tableView, column.getName(), false, false, false);
            fixedRowHeight = Math.max(fixedRowHeight, cellRenderer.getPreferredHeight(-1));
        }
        return fixedRowHeight;
    }

    public void paint(Graphics2D graphics) {
        int columnIndex;
        TableView tableView = (TableView)this.getComponent();
        List tableData = tableView.getTableData();
        TableView.ColumnSequence columns = tableView.getColumns();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.backgroundColor != null) {
            graphics.setPaint(this.backgroundColor);
            graphics.fillRect(0, 0, width, height);
        }
        int rowStart = 0;
        int rowEnd = tableData.getLength() - 1;
        Rectangle clipBounds = graphics.getClipBounds();
        if (clipBounds != null) {
            if (this.variableRowHeight) {
                rowStart = this.getRowAt(clipBounds.y);
                if (rowStart == -1) {
                    rowStart = tableData.getLength();
                }
                if (rowEnd != -1) {
                    int clipBottom = clipBounds.y + clipBounds.height - 1;
                    clipBottom = Math.min(clipBottom, (Integer)this.rowBoundaries.get(rowEnd) - 1);
                    rowEnd = this.getRowAt(clipBottom);
                }
            } else {
                rowStart = Math.max(rowStart, (int)Math.floor((double)clipBounds.y / (double)(this.fixedRowHeight + 1)));
                rowEnd = Math.min(rowEnd, (int)Math.ceil((double)(clipBounds.y + clipBounds.height) / (double)(this.fixedRowHeight + 1)) - 1);
            }
        }
        if (this.alternateRowBackgroundColor != null) {
            for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
                int rowY = this.getRowY(rowIndex);
                int rowHeight = this.getRowHeight(rowIndex);
                if (rowIndex % 2 <= 0) continue;
                graphics.setPaint(this.alternateRowBackgroundColor);
                graphics.fillRect(0, rowY, width, rowHeight + 1);
            }
        }
        int columnX = 0;
        if (this.columnSelectionColor != null) {
            graphics.setColor(this.columnSelectionColor);
            columnX = 0;
            int columnCount = columns.getLength();
            for (columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                TableView.Column column = columns.get(columnIndex);
                int columnWidth = (Integer)this.columnWidths.get(columnIndex);
                String columnName = column.getName();
                SortDirection sortDirection = tableView.getSort().get(columnName);
                if (sortDirection != null) {
                    graphics.fillRect(columnX, 0, columnWidth, height);
                }
                columnX += columnWidth + 1;
            }
        }
        for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
            Object rowData = tableData.get(rowIndex);
            boolean rowHighlighted = rowIndex == this.highlightIndex && tableView.getSelectMode() != TableView.SelectMode.NONE;
            boolean rowSelected = tableView.isRowSelected(rowIndex);
            boolean rowDisabled = tableView.isRowDisabled(rowIndex);
            int rowY = this.getRowY(rowIndex);
            int rowHeight = this.getRowHeight(rowIndex);
            Color rowBackgroundColor = null;
            if (rowSelected) {
                rowBackgroundColor = tableView.isFocused() ? this.selectionBackgroundColor : this.inactiveSelectionBackgroundColor;
            } else if (rowHighlighted && this.showHighlight && !rowDisabled) {
                rowBackgroundColor = this.highlightBackgroundColor;
            }
            if (rowBackgroundColor != null) {
                graphics.setPaint(rowBackgroundColor);
                graphics.fillRect(0, rowY, width, rowHeight);
            }
            columnX = 0;
            int columnCount = columns.getLength();
            for (int columnIndex2 = 0; columnIndex2 < columnCount; ++columnIndex2) {
                TableView.Column column = columns.get(columnIndex2);
                TableView.CellRenderer cellRenderer = column.getCellRenderer();
                int columnWidth = (Integer)this.columnWidths.get(columnIndex2);
                Graphics2D rendererGraphics = (Graphics2D)graphics.create(columnX, rowY, columnWidth, rowHeight);
                cellRenderer.render(rowData, rowIndex, columnIndex2, tableView, column.getName(), rowSelected, rowHighlighted, rowDisabled);
                cellRenderer.setSize(columnWidth, rowHeight);
                cellRenderer.paint(rendererGraphics);
                rendererGraphics.dispose();
                columnX += columnWidth + 1;
            }
        }
        graphics.setPaint(this.verticalGridColor);
        if (this.showVerticalGridLines) {
            columnX = 0;
            int columnCount = columns.getLength();
            for (columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                columnX += ((Integer)this.columnWidths.get(columnIndex)).intValue();
                if (columnIndex < columnCount - 1 || this.includeTrailingVerticalGridLine) {
                    GraphicsUtilities.drawLine((Graphics2D)graphics, (int)columnX, (int)0, (int)height, (Orientation)Orientation.VERTICAL);
                }
                ++columnX;
            }
        }
        graphics.setPaint(this.horizontalGridColor);
        if (this.showHorizontalGridLines) {
            int rowCount = tableData.getLength();
            for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
                int gridY = this.getRowY(rowIndex + 1) - 1;
                if (rowIndex >= rowCount - 1 && !this.includeTrailingHorizontalGridLine) continue;
                GraphicsUtilities.drawLine((Graphics2D)graphics, (int)0, (int)gridY, (int)width, (Orientation)Orientation.HORIZONTAL);
            }
            if (this.columnSelectionHorizontalGridColor != null) {
                graphics.setColor(this.columnSelectionHorizontalGridColor);
                columnX = 0;
                int columnCount = columns.getLength();
                for (int columnIndex3 = 0; columnIndex3 < columnCount; ++columnIndex3) {
                    TableView.Column column = columns.get(columnIndex3);
                    int columnWidth = (Integer)this.columnWidths.get(columnIndex3);
                    String columnName = column.getName();
                    SortDirection sortDirection = tableView.getSort().get(columnName);
                    if (sortDirection != null) {
                        for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
                            int gridY = this.getRowY(rowIndex + 1) - 1;
                            if (rowIndex >= rowCount - 1 && !this.includeTrailingHorizontalGridLine) continue;
                            GraphicsUtilities.drawLine((Graphics2D)graphics, (int)columnX, (int)gridY, (int)columnWidth, (Orientation)Orientation.HORIZONTAL);
                        }
                    }
                    columnX += columnWidth + 1;
                }
            }
        }
    }

    private int getRowY(int rowIndex) {
        int rowY = this.variableRowHeight ? (rowIndex == 0 ? 0 : (Integer)this.rowBoundaries.get(rowIndex - 1)) : rowIndex * (this.fixedRowHeight + 1);
        return rowY;
    }

    private int getRowHeight(int rowIndex) {
        int rowHeight;
        if (this.variableRowHeight) {
            rowHeight = (Integer)this.rowBoundaries.get(rowIndex);
            if (rowIndex > 0) {
                rowHeight -= ((Integer)this.rowBoundaries.get(rowIndex - 1)).intValue();
            }
        } else {
            rowHeight = this.fixedRowHeight;
        }
        return rowHeight;
    }

    protected int getVariableRowHeight(int rowIndex, ArrayList<Integer> columnWidthsArgument) {
        TableView tableView = (TableView)this.getComponent();
        List tableData = tableView.getTableData();
        TableView.ColumnSequence columns = tableView.getColumns();
        Object rowData = tableData.get(rowIndex);
        int rowHeight = 0;
        int n = columns.getLength();
        for (int i = 0; i < n; ++i) {
            TableView.Column column = columns.get(i);
            TableView.CellRenderer cellRenderer = column.getCellRenderer();
            cellRenderer.render(rowData, rowIndex, i, tableView, column.getName(), false, false, false);
            rowHeight = Math.max(rowHeight, cellRenderer.getPreferredHeight(((Integer)columnWidthsArgument.get(i)).intValue()));
        }
        return rowHeight;
    }

    public int getRowAt(int y) {
        int rowIndex;
        if (y < 0) {
            throw new IllegalArgumentException("y is negative");
        }
        TableView tableView = (TableView)this.getComponent();
        if (this.variableRowHeight) {
            if (y == 0) {
                rowIndex = 0;
            } else {
                rowIndex = ArrayList.binarySearch(this.rowBoundaries, (Comparable)Integer.valueOf(y));
                if (rowIndex < 0) {
                    rowIndex = -(rowIndex + 1);
                }
            }
        } else {
            rowIndex = y / (this.fixedRowHeight + 1);
        }
        List tableData = tableView.getTableData();
        if (rowIndex >= tableData.getLength()) {
            rowIndex = -1;
        }
        return rowIndex;
    }

    public int getColumnAt(int x) {
        int columnX;
        if (x < 0) {
            throw new IllegalArgumentException("x is negative");
        }
        TableView tableView = (TableView)this.getComponent();
        int columnIndex = -1;
        int i = 0;
        int n = tableView.getColumns().getLength();
        for (columnX = 0; i < n && x > columnX; columnX += (Integer)this.columnWidths.get(i) + 1, ++i) {
        }
        if (x <= columnX) {
            columnIndex = i - 1;
        }
        return columnIndex;
    }

    public Bounds getRowBounds(int rowIndex) {
        return new Bounds(0, this.getRowY(rowIndex), this.getWidth(), this.getRowHeight(rowIndex));
    }

    public Bounds getColumnBounds(int columnIndex) {
        int columnX = 0;
        for (int i = 0; i < columnIndex; ++i) {
            columnX += (Integer)this.columnWidths.get(i) + 1;
        }
        return new Bounds(columnX, 0, ((Integer)this.columnWidths.get(columnIndex)).intValue(), this.getHeight());
    }

    public Bounds getCellBounds(int rowIndex, int columnIndex) {
        TableView tableView = (TableView)this.getComponent();
        List tableData = tableView.getTableData();
        if (rowIndex < 0 || rowIndex >= tableData.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        int cellX = 0;
        for (int i = 0; i < columnIndex; ++i) {
            cellX += (Integer)this.columnWidths.get(i) + 1;
        }
        int rowHeight = this.getRowHeight(rowIndex);
        return new Bounds(cellX, rowIndex * (rowHeight + 1), ((Integer)this.columnWidths.get(columnIndex)).intValue(), rowHeight);
    }

    public static ArrayList<Integer> getColumnWidths(TableView tableView, int width) {
        int fixedWidth = 0;
        int relativeWidth = 0;
        TableView.ColumnSequence columns = tableView.getColumns();
        int n = columns.getLength();
        ArrayList columnWidths = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            TableView.Column column = columns.get(i);
            if (column.isRelative()) {
                columnWidths.add((Object)0);
                relativeWidth += column.getWidth();
                continue;
            }
            int columnWidth = column.getWidth();
            if (columnWidth == -1) {
                columnWidth = 0;
                TableView.CellRenderer cellRenderer = column.getCellRenderer();
                List tableData = tableView.getTableData();
                int rowIndex = 0;
                for (Object rowData : tableData) {
                    cellRenderer.render(rowData, rowIndex++, i, tableView, column.getName(), false, false, false);
                    columnWidth = Math.max(cellRenderer.getPreferredWidth(-1), columnWidth);
                }
            }
            columnWidth = Math.min(Math.max(columnWidth, column.getMinimumWidth()), column.getMaximumWidth());
            columnWidths.add((Object)columnWidth);
            fixedWidth += columnWidth;
        }
        int variableWidth = Math.max(width - (fixedWidth += n - 1), 0);
        for (int i = 0; i < n; ++i) {
            TableView.Column column = columns.get(i);
            if (!column.isRelative()) continue;
            int columnWidth = (int)Math.round((double)(column.getWidth() * variableWidth) / (double)relativeWidth);
            columnWidths.update(i, (Object)Math.min(Math.max(columnWidth, column.getMinimumWidth()), column.getMaximumWidth()));
        }
        return columnWidths;
    }

    public boolean isFocusable() {
        TableView tableView = (TableView)this.getComponent();
        return tableView.getSelectMode() != TableView.SelectMode.NONE;
    }

    public boolean isOpaque() {
        return this.backgroundColor != null && this.backgroundColor.getTransparency() == 1;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraTableViewSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public final void setColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setColor(theme.getColor(color));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public final void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public final void setDisabledColor(int disabledColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(theme.getColor(disabledColor));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.repaintComponent();
    }

    public final void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)backgroundColor));
    }

    public final void setBackgroundColor(int backgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(backgroundColor));
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        if (selectionColor == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.selectionColor = selectionColor;
        this.repaintComponent();
    }

    public final void setSelectionColor(String selectionColor) {
        if (selectionColor == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.setSelectionColor(GraphicsUtilities.decodeColor((String)selectionColor));
    }

    public final void setSelectionColor(int selectionColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setSelectionColor(theme.getColor(selectionColor));
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color selectionBackgroundColor) {
        if (selectionBackgroundColor == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.selectionBackgroundColor = selectionBackgroundColor;
        this.repaintComponent();
    }

    public final void setSelectionBackgroundColor(String selectionBackgroundColor) {
        if (selectionBackgroundColor == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.setSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)selectionBackgroundColor));
    }

    public final void setSelectionBackgroundColor(int selectionBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setSelectionBackgroundColor(theme.getColor(selectionBackgroundColor));
    }

    public Color getInactiveSelectionColor() {
        return this.inactiveSelectionColor;
    }

    public void setInactiveSelectionColor(Color inactiveSelectionColor) {
        if (inactiveSelectionColor == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.inactiveSelectionColor = inactiveSelectionColor;
        this.repaintComponent();
    }

    public final void setInactiveSelectionColor(String inactiveSelectionColor) {
        if (inactiveSelectionColor == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.setInactiveSelectionColor(GraphicsUtilities.decodeColor((String)inactiveSelectionColor));
    }

    public final void setInactiveSelectionColor(int inactiveSelectionColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setInactiveSelectionColor(theme.getColor(inactiveSelectionColor));
    }

    public Color getInactiveSelectionBackgroundColor() {
        return this.inactiveSelectionBackgroundColor;
    }

    public void setInactiveSelectionBackgroundColor(Color inactiveSelectionBackgroundColor) {
        if (inactiveSelectionBackgroundColor == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.inactiveSelectionBackgroundColor = inactiveSelectionBackgroundColor;
        this.repaintComponent();
    }

    public final void setInactiveSelectionBackgroundColor(String inactiveSelectionBackgroundColor) {
        if (inactiveSelectionBackgroundColor == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.setInactiveSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)inactiveSelectionBackgroundColor));
    }

    public final void setInactiveSelectionBackgroundColor(int inactiveSelectionBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setInactiveSelectionBackgroundColor(theme.getColor(inactiveSelectionBackgroundColor));
    }

    public Color getHighlightBackgroundColor() {
        return this.highlightBackgroundColor;
    }

    public void setHighlightBackgroundColor(Color highlightBackgroundColor) {
        if (highlightBackgroundColor == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.highlightBackgroundColor = highlightBackgroundColor;
        this.repaintComponent();
    }

    public final void setHighlightBackgroundColor(String highlightBackgroundColor) {
        if (highlightBackgroundColor == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.setHighlightBackgroundColor(GraphicsUtilities.decodeColor((String)highlightBackgroundColor));
    }

    public final void setHighlightBackgroundColor(int highlightBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setHighlightBackgroundColor(theme.getColor(highlightBackgroundColor));
    }

    public Color getAlternateRowBackgroundColor() {
        return this.alternateRowBackgroundColor;
    }

    public void setAlternateRowBackgroundColor(Color alternateRowBackgroundColor) {
        this.alternateRowBackgroundColor = alternateRowBackgroundColor;
        this.repaintComponent();
    }

    public final void setAlternateRowBackgroundColor(String alternateRowBackgroundColor) {
        if (alternateRowBackgroundColor == null) {
            throw new IllegalArgumentException("alternateRowBackgroundColor is null.");
        }
        this.setAlternateRowBackgroundColor(GraphicsUtilities.decodeColor((String)alternateRowBackgroundColor));
    }

    public final void setAlternateRowBackgroundColor(int alternateRowBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setAlternateRowBackgroundColor(theme.getColor(alternateRowBackgroundColor));
    }

    public Color getColumnSelectionColor() {
        return this.columnSelectionColor;
    }

    public void setColumnSelectionColor(Color columnSelectionColor) {
        this.columnSelectionColor = columnSelectionColor;
        this.repaintComponent();
    }

    public final void setColumnSelectionColor(String columnSelectionColor) {
        if (columnSelectionColor == null) {
            throw new IllegalArgumentException("columnSelectionColor is null.");
        }
        this.setColumnSelectionColor(GraphicsUtilities.decodeColor((String)columnSelectionColor));
    }

    public final void setColumnSelectionColor(int columnSelectionColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setColumnSelectionColor(theme.getColor(columnSelectionColor));
    }

    public Color getColumnSelectionHorizontalGridColor() {
        return this.columnSelectionHorizontalGridColor;
    }

    public void setColumnSelectionHorizontalGridColor(Color columnSelectionHorizontalGridColor) {
        if (columnSelectionHorizontalGridColor == null) {
            throw new IllegalArgumentException("columnSelectionHorizontalGridColor is null.");
        }
        this.columnSelectionHorizontalGridColor = columnSelectionHorizontalGridColor;
        this.repaintComponent();
    }

    public final void setColumnSelectionHorizontalGridColor(String columnSelectionHorizontalGridColor) {
        if (columnSelectionHorizontalGridColor == null) {
            throw new IllegalArgumentException("columnSelectionHorizontalGridColor is null.");
        }
        this.setColumnSelectionHorizontalGridColor(GraphicsUtilities.decodeColor((String)columnSelectionHorizontalGridColor));
    }

    public final void setColumnSelectionHorizontalGridColor(int columnSelectionHorizontalGridColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setColumnSelectionHorizontalGridColor(theme.getColor(columnSelectionHorizontalGridColor));
    }

    public Color getHorizontalGridColor() {
        return this.horizontalGridColor;
    }

    public void setHorizontalGridColor(Color horizontalGridColor) {
        if (horizontalGridColor == null) {
            throw new IllegalArgumentException("horizontalGridColor is null.");
        }
        this.horizontalGridColor = horizontalGridColor;
        this.repaintComponent();
    }

    public final void setHorizontalGridColor(String horizontalGridColor) {
        if (horizontalGridColor == null) {
            throw new IllegalArgumentException("horizontalGridColor is null.");
        }
        this.setHorizontalGridColor(GraphicsUtilities.decodeColor((String)horizontalGridColor));
    }

    public final void setHorizontalGridColor(int horizontalGridColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setHorizontalGridColor(theme.getColor(horizontalGridColor));
    }

    public Color getVerticalGridColor() {
        return this.verticalGridColor;
    }

    public void setVerticalGridColor(Color verticalGridColor) {
        if (verticalGridColor == null) {
            throw new IllegalArgumentException("verticalGridColor is null.");
        }
        this.verticalGridColor = verticalGridColor;
        this.repaintComponent();
    }

    public final void setVerticalGridColor(String verticalGridColor) {
        if (verticalGridColor == null) {
            throw new IllegalArgumentException("verticalGridColor is null.");
        }
        this.setVerticalGridColor(GraphicsUtilities.decodeColor((String)verticalGridColor));
    }

    public final void setVerticalGridColor(int verticalGridColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setVerticalGridColor(theme.getColor(verticalGridColor));
    }

    public boolean getShowHighlight() {
        return this.showHighlight;
    }

    public void setShowHighlight(boolean showHighlight) {
        this.showHighlight = showHighlight;
        this.repaintComponent();
    }

    public boolean getShowHorizontalGridLines() {
        return this.showHorizontalGridLines;
    }

    public void setShowHorizontalGridLines(boolean showHorizontalGridLines) {
        this.showHorizontalGridLines = showHorizontalGridLines;
        this.repaintComponent();
    }

    public boolean getShowVerticalGridLines() {
        return this.showVerticalGridLines;
    }

    public void setShowVerticalGridLines(boolean showVerticalGridLines) {
        this.showVerticalGridLines = showVerticalGridLines;
        this.repaintComponent();
    }

    public boolean getIncludeTrailingVerticalGridLine() {
        return this.includeTrailingVerticalGridLine;
    }

    public void setIncludeTrailingVerticalGridLine(boolean includeTrailingVerticalGridLine) {
        this.includeTrailingVerticalGridLine = includeTrailingVerticalGridLine;
        this.invalidateComponent();
    }

    public boolean getIncludeTrailingHorizontalGridLine() {
        return this.includeTrailingHorizontalGridLine;
    }

    public void setIncludeTrailingHorizontalGridLine(boolean includeTrailingHorizontalGridLine) {
        this.includeTrailingHorizontalGridLine = includeTrailingHorizontalGridLine;
        this.invalidateComponent();
    }

    public boolean isVariableRowHeight() {
        return this.variableRowHeight;
    }

    public void setVariableRowHeight(boolean variableRowHeight) {
        this.variableRowHeight = variableRowHeight;
        this.rowBoundaries = null;
        this.fixedRowHeight = -1;
        this.invalidateComponent();
    }

    public boolean isEditOnMouseDown() {
        return this.editOnMouseDown;
    }

    public void setEditOnMouseDown(boolean editOnMouseDown) {
        this.editOnMouseDown = editOnMouseDown;
    }

    public boolean mouseMove(Component component, int x, int y) {
        boolean consumed = super.mouseMove(component, x, y);
        TableView tableView = (TableView)this.getComponent();
        int previousHighlightIndex = this.highlightIndex;
        this.highlightIndex = this.getRowAt(y);
        if (previousHighlightIndex != this.highlightIndex && tableView.getSelectMode() != TableView.SelectMode.NONE && this.showHighlight) {
            if (previousHighlightIndex != -1) {
                this.repaintComponent(this.getRowBounds(previousHighlightIndex));
            }
            if (this.highlightIndex != -1) {
                this.repaintComponent(this.getRowBounds(this.highlightIndex));
            }
        }
        return consumed;
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        TableView tableView = (TableView)this.getComponent();
        if (this.highlightIndex != -1 && tableView.getSelectMode() != TableView.SelectMode.NONE && this.showHighlight) {
            this.repaintComponent(this.getRowBounds(this.highlightIndex));
        }
        this.highlightIndex = -1;
        this.selectIndex = -1;
    }

    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        TableView.RowEditor rowEditor;
        boolean consumed = super.mouseDown(component, button, x, y);
        TableView tableView = (TableView)this.getComponent();
        int rowIndex = this.getRowAt(y);
        if (rowIndex >= 0 && !tableView.isRowDisabled(rowIndex)) {
            TableView.SelectMode selectMode = tableView.getSelectMode();
            if (button == Mouse.Button.LEFT) {
                Keyboard.Modifier commandModifier = Platform.getCommandModifier();
                if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && selectMode == TableView.SelectMode.MULTI) {
                    Filter disabledRowFilter = tableView.getDisabledRowFilter();
                    if (disabledRowFilter == null) {
                        int startIndex = tableView.getFirstSelectedIndex();
                        int endIndex = tableView.getLastSelectedIndex();
                        if (startIndex == -1) {
                            tableView.addSelectedIndex(rowIndex);
                        } else {
                            Span selectedRange = rowIndex > startIndex ? new Span(startIndex, rowIndex) : new Span(rowIndex, endIndex);
                            ArrayList selectedRanges = new ArrayList();
                            selectedRanges.add((Object)selectedRange);
                            tableView.setSelectedRanges((Sequence)selectedRanges);
                        }
                    }
                } else if (Keyboard.isPressed((Keyboard.Modifier)commandModifier) && selectMode == TableView.SelectMode.MULTI) {
                    if (tableView.isRowSelected(rowIndex)) {
                        tableView.removeSelectedIndex(rowIndex);
                    } else {
                        tableView.addSelectedIndex(rowIndex);
                    }
                } else if (Keyboard.isPressed((Keyboard.Modifier)commandModifier) && selectMode == TableView.SelectMode.SINGLE) {
                    if (tableView.isRowSelected(rowIndex)) {
                        tableView.setSelectedIndex(-1);
                    } else {
                        tableView.setSelectedIndex(rowIndex);
                    }
                } else if (selectMode != TableView.SelectMode.NONE) {
                    if (!tableView.isRowSelected(rowIndex)) {
                        tableView.setSelectedIndex(rowIndex);
                    }
                    this.selectIndex = rowIndex;
                }
            }
        }
        tableView.requestFocus();
        if (this.editOnMouseDown && this.selectIndex != -1 && button == Mouse.Button.LEFT && (rowEditor = tableView.getRowEditor()) != null) {
            if (rowEditor.isEditing()) {
                rowEditor.endEdit(true);
            }
            rowEditor.beginEdit(tableView, this.selectIndex, this.getColumnAt(x));
        }
        return consumed;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        TableView tableView = (TableView)this.getComponent();
        if (this.selectIndex != -1 && tableView.getFirstSelectedIndex() != tableView.getLastSelectedIndex()) {
            tableView.setSelectedIndex(this.selectIndex);
            this.selectIndex = -1;
        }
        return consumed;
    }

    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        boolean consumed = super.mouseClick(component, button, x, y, count);
        if (!this.editOnMouseDown) {
            TableView.RowEditor rowEditor;
            TableView tableView = (TableView)this.getComponent();
            if (this.selectIndex != -1 && count == 2 && button == Mouse.Button.LEFT && (rowEditor = tableView.getRowEditor()) != null) {
                if (rowEditor.isEditing()) {
                    rowEditor.endEdit(true);
                }
                rowEditor.beginEdit(tableView, this.selectIndex, this.getColumnAt(x));
            }
        }
        this.selectIndex = -1;
        return consumed;
    }

    public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
        TableView tableView = (TableView)this.getComponent();
        if (this.highlightIndex != -1) {
            Bounds rowBounds = this.getRowBounds(this.highlightIndex);
            this.highlightIndex = -1;
            if (tableView.getSelectMode() != TableView.SelectMode.NONE && this.showHighlight) {
                this.repaintComponent(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height, true);
            }
        }
        return super.mouseWheel(component, scrollType, scrollAmount, wheelRotation, x, y);
    }

    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = super.keyPressed(component, keyCode, keyLocation);
        TableView tableView = (TableView)this.getComponent();
        TableView.SelectMode selectMode = tableView.getSelectMode();
        switch (keyCode) {
            case 38: {
                if (selectMode == TableView.SelectMode.NONE) break;
                int index = tableView.getFirstSelectedIndex();
                while (--index >= 0 && tableView.isRowDisabled(index)) {
                }
                if (index >= 0) {
                    if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && tableView.getSelectMode() == TableView.SelectMode.MULTI) {
                        tableView.addSelectedIndex(index);
                    } else {
                        tableView.setSelectedIndex(index);
                    }
                }
                consumed = true;
                break;
            }
            case 40: {
                if (selectMode == TableView.SelectMode.NONE) break;
                int index = tableView.getLastSelectedIndex();
                int count = tableView.getTableData().getLength();
                while (++index < count && tableView.isRowDisabled(index)) {
                }
                if (index < count) {
                    if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && tableView.getSelectMode() == TableView.SelectMode.MULTI) {
                        tableView.addSelectedIndex(index);
                    } else {
                        tableView.setSelectedIndex(index);
                    }
                }
                consumed = true;
                break;
            }
        }
        if (this.highlightIndex != -1 && tableView.getSelectMode() != TableView.SelectMode.NONE && this.showHighlight && consumed) {
            this.repaintComponent(this.getRowBounds(this.highlightIndex));
        }
        this.highlightIndex = -1;
        return consumed;
    }

    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.repaintComponent();
    }

    public void focusedChanged(Component component, Component obverseComponent) {
        super.focusedChanged(component, obverseComponent);
        this.repaintComponent();
    }

    public void tableDataChanged(TableView tableView, List<?> previousTableData) {
        this.invalidateComponent();
    }

    public void columnSourceChanged(TableView tableView, TableView previousColumnSource) {
        TableView columnSource;
        if (previousColumnSource != null) {
            previousColumnSource.getTableViewColumnListeners().remove((Object)this);
        }
        if ((columnSource = tableView.getColumnSource()) != null) {
            columnSource.getTableViewColumnListeners().add((Object)this);
        }
        this.invalidateComponent();
    }

    public void rowEditorChanged(TableView tableView, TableView.RowEditor previousRowEditor) {
    }

    public void selectModeChanged(TableView tableView, TableView.SelectMode previousSelectMode) {
        this.repaintComponent();
    }

    public void disabledRowFilterChanged(TableView tableView, Filter<?> previousDisabledRowFilter) {
        this.repaintComponent();
    }

    public void columnInserted(TableView tableView, int index) {
        TableView.Column column = tableView.getColumns().get(index);
        if (column.getWidth() == -1) {
            ++this.defaultWidthColumnCount;
        }
        this.invalidateComponent();
    }

    public void columnsRemoved(TableView tableView, int index, Sequence<TableView.Column> columns) {
        int n = columns.getLength();
        for (int i = 0; i < n; ++i) {
            TableView.Column column = (TableView.Column)columns.get(i);
            if (column.getWidth() != -1) continue;
            --this.defaultWidthColumnCount;
        }
        this.invalidateComponent();
    }

    public void columnNameChanged(TableView.Column column, String previousName) {
        this.invalidateComponent();
    }

    public void columnHeaderDataChanged(TableView.Column column, Object previousHeaderData) {
    }

    public void columnHeaderDataRendererChanged(TableView.Column column, TableView.HeaderDataRenderer previousHeaderDataRenderer) {
    }

    public void columnWidthChanged(TableView.Column column, int previousWidth, boolean previousRelative) {
        this.defaultWidthColumnCount = column.getWidth() == -1 ? ++this.defaultWidthColumnCount : --this.defaultWidthColumnCount;
        this.invalidateComponent();
    }

    public void columnWidthLimitsChanged(TableView.Column column, int previousMinimumWidth, int previousMaximumWidth) {
        this.invalidateComponent();
    }

    public void columnFilterChanged(TableView.Column column, Object previousFilter) {
    }

    public void columnCellRendererChanged(TableView.Column column, TableView.CellRenderer previousCellRenderer) {
        this.invalidateComponent();
    }

    public void rowInserted(TableView tableView, int index) {
        this.invalidateComponent();
    }

    public void rowsRemoved(TableView tableView, int index, int count) {
        this.invalidateComponent();
    }

    public void rowUpdated(TableView tableView, int index) {
        if (this.variableRowHeight || this.defaultWidthColumnCount > 0) {
            this.invalidateComponent();
        } else {
            this.repaintComponent(this.getRowBounds(index));
        }
    }

    public void rowsCleared(TableView listView) {
        this.invalidateComponent();
    }

    public void rowsSorted(TableView tableView) {
        if (this.variableRowHeight) {
            this.invalidateComponent();
        } else {
            this.repaintComponent();
        }
    }

    public void selectedRangeAdded(TableView tableView, int rangeStart, int rangeEnd) {
        if (tableView.isValid()) {
            Bounds selectionBounds = this.getRowBounds(rangeStart);
            selectionBounds = selectionBounds.union(this.getRowBounds(rangeEnd));
            this.repaintComponent(selectionBounds);
            Bounds visibleSelectionBounds = tableView.getVisibleArea(selectionBounds);
            if (visibleSelectionBounds.height < selectionBounds.height) {
                tableView.scrollAreaToVisible(selectionBounds);
            }
        } else {
            this.validateSelection = true;
        }
    }

    public void selectedRangeRemoved(TableView tableView, int rangeStart, int rangeEnd) {
        if (tableView.isValid()) {
            Bounds selectionBounds = this.getRowBounds(rangeStart);
            selectionBounds = selectionBounds.union(this.getRowBounds(rangeEnd));
            this.repaintComponent(selectionBounds);
        }
    }

    public void selectedRangesChanged(TableView tableView, Sequence<Span> previousSelectedRanges) {
        if (previousSelectedRanges != null && previousSelectedRanges != tableView.getSelectedRanges()) {
            if (tableView.isValid()) {
                ImmutableList selectedRanges;
                if (previousSelectedRanges.getLength() > 0) {
                    int rangeStart = ((Span)previousSelectedRanges.get((int)0)).start;
                    int rangeEnd = ((Span)previousSelectedRanges.get((int)(previousSelectedRanges.getLength() - 1))).end;
                    Bounds previousSelectionBounds = this.getRowBounds(rangeStart);
                    previousSelectionBounds = previousSelectionBounds.union(this.getRowBounds(rangeEnd));
                    this.repaintComponent(previousSelectionBounds);
                }
                if ((selectedRanges = tableView.getSelectedRanges()).getLength() > 0) {
                    int rangeStart = ((Span)selectedRanges.get((int)0)).start;
                    int rangeEnd = ((Span)selectedRanges.get((int)(selectedRanges.getLength() - 1))).end;
                    Bounds selectionBounds = this.getRowBounds(rangeStart);
                    selectionBounds = selectionBounds.union(this.getRowBounds(rangeEnd));
                    this.repaintComponent(selectionBounds);
                    Bounds visibleSelectionBounds = tableView.getVisibleArea(selectionBounds);
                    if (visibleSelectionBounds != null && visibleSelectionBounds.height < selectionBounds.height) {
                        this.repaintComponent();
                        tableView.scrollAreaToVisible(selectionBounds);
                    }
                }
            } else {
                this.validateSelection = true;
            }
        }
    }

    public void selectedRowChanged(TableView tableView, Object previousSelectedRow) {
    }
}

