/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Map;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.wtk.Accordion;
import org.apache.pivot.wtk.ActivityIndicator;
import org.apache.pivot.wtk.Alert;
import org.apache.pivot.wtk.Border;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Calendar;
import org.apache.pivot.wtk.CalendarButton;
import org.apache.pivot.wtk.Checkbox;
import org.apache.pivot.wtk.ColorChooser;
import org.apache.pivot.wtk.ColorChooserButton;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dialog;
import org.apache.pivot.wtk.Expander;
import org.apache.pivot.wtk.FileBrowser;
import org.apache.pivot.wtk.FileBrowserSheet;
import org.apache.pivot.wtk.Form;
import org.apache.pivot.wtk.Frame;
import org.apache.pivot.wtk.GridPane;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.LinkButton;
import org.apache.pivot.wtk.ListButton;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuBar;
import org.apache.pivot.wtk.MenuButton;
import org.apache.pivot.wtk.MenuPopup;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.Meter;
import org.apache.pivot.wtk.Palette;
import org.apache.pivot.wtk.Panel;
import org.apache.pivot.wtk.Panorama;
import org.apache.pivot.wtk.Prompt;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.RadioButton;
import org.apache.pivot.wtk.Rollup;
import org.apache.pivot.wtk.ScrollBar;
import org.apache.pivot.wtk.ScrollPane;
import org.apache.pivot.wtk.Separator;
import org.apache.pivot.wtk.Sheet;
import org.apache.pivot.wtk.Slider;
import org.apache.pivot.wtk.Spinner;
import org.apache.pivot.wtk.SplitPane;
import org.apache.pivot.wtk.SuggestionPopup;
import org.apache.pivot.wtk.TabPane;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TableViewHeader;
import org.apache.pivot.wtk.TextArea;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.TextPane;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Tooltip;
import org.apache.pivot.wtk.TreeView;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.terra.TerraAccordionSkin;
import org.apache.pivot.wtk.skin.terra.TerraActivityIndicatorSkin;
import org.apache.pivot.wtk.skin.terra.TerraAlertSkin;
import org.apache.pivot.wtk.skin.terra.TerraBorderSkin;
import org.apache.pivot.wtk.skin.terra.TerraBoxPaneSkin;
import org.apache.pivot.wtk.skin.terra.TerraCalendarButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraCalendarSkin;
import org.apache.pivot.wtk.skin.terra.TerraCheckboxSkin;
import org.apache.pivot.wtk.skin.terra.TerraColorChooserButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraColorChooserSkin;
import org.apache.pivot.wtk.skin.terra.TerraDialogSkin;
import org.apache.pivot.wtk.skin.terra.TerraExpanderSkin;
import org.apache.pivot.wtk.skin.terra.TerraFileBrowserSheetSkin;
import org.apache.pivot.wtk.skin.terra.TerraFileBrowserSkin;
import org.apache.pivot.wtk.skin.terra.TerraFormSkin;
import org.apache.pivot.wtk.skin.terra.TerraFrameSkin;
import org.apache.pivot.wtk.skin.terra.TerraGridPaneSkin;
import org.apache.pivot.wtk.skin.terra.TerraLabelSkin;
import org.apache.pivot.wtk.skin.terra.TerraLinkButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraListButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraListViewSkin;
import org.apache.pivot.wtk.skin.terra.TerraMenuBarItemSkin;
import org.apache.pivot.wtk.skin.terra.TerraMenuBarSkin;
import org.apache.pivot.wtk.skin.terra.TerraMenuButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraMenuItemSkin;
import org.apache.pivot.wtk.skin.terra.TerraMenuPopupSkin;
import org.apache.pivot.wtk.skin.terra.TerraMenuSkin;
import org.apache.pivot.wtk.skin.terra.TerraMeterSkin;
import org.apache.pivot.wtk.skin.terra.TerraPaletteSkin;
import org.apache.pivot.wtk.skin.terra.TerraPanelSkin;
import org.apache.pivot.wtk.skin.terra.TerraPanoramaSkin;
import org.apache.pivot.wtk.skin.terra.TerraPromptSkin;
import org.apache.pivot.wtk.skin.terra.TerraPushButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraRadioButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraRollupSkin;
import org.apache.pivot.wtk.skin.terra.TerraScrollBarSkin;
import org.apache.pivot.wtk.skin.terra.TerraScrollPaneCornerSkin;
import org.apache.pivot.wtk.skin.terra.TerraScrollPaneSkin;
import org.apache.pivot.wtk.skin.terra.TerraSeparatorSkin;
import org.apache.pivot.wtk.skin.terra.TerraSheetSkin;
import org.apache.pivot.wtk.skin.terra.TerraSliderSkin;
import org.apache.pivot.wtk.skin.terra.TerraSpinnerSkin;
import org.apache.pivot.wtk.skin.terra.TerraSplitPaneSkin;
import org.apache.pivot.wtk.skin.terra.TerraSuggestionPopupSkin;
import org.apache.pivot.wtk.skin.terra.TerraTabPaneSkin;
import org.apache.pivot.wtk.skin.terra.TerraTablePaneSkin;
import org.apache.pivot.wtk.skin.terra.TerraTableViewHeaderSkin;
import org.apache.pivot.wtk.skin.terra.TerraTableViewSkin;
import org.apache.pivot.wtk.skin.terra.TerraTextAreaSkin;
import org.apache.pivot.wtk.skin.terra.TerraTextInputSkin;
import org.apache.pivot.wtk.skin.terra.TerraTextPaneSkin;
import org.apache.pivot.wtk.skin.terra.TerraTooltipSkin;
import org.apache.pivot.wtk.skin.terra.TerraTreeViewSkin;

public final class TerraTheme
extends Theme {
    private Font font = null;
    private ArrayList<Color> colors = null;
    private int numberOfPaletteColors = 0;
    private HashMap<MessageType, Image> messageIcons = null;
    private HashMap<MessageType, Image> smallMessageIcons = null;
    private static float colorMultiplier = 0.1f;
    public static final String LOCATION_PROPERTY = "location";
    public static final String COMMAND_BUTTON_STYLE = "commandButton";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerraTheme() {
        URL locationURL;
        this.componentSkinMap.put(Accordion.class, TerraAccordionSkin.class);
        this.componentSkinMap.put(ActivityIndicator.class, TerraActivityIndicatorSkin.class);
        this.componentSkinMap.put(Alert.class, TerraAlertSkin.class);
        this.componentSkinMap.put(Border.class, TerraBorderSkin.class);
        this.componentSkinMap.put(Checkbox.class, TerraCheckboxSkin.class);
        this.componentSkinMap.put(Calendar.class, TerraCalendarSkin.class);
        this.componentSkinMap.put(CalendarButton.class, TerraCalendarButtonSkin.class);
        this.componentSkinMap.put(ColorChooser.class, TerraColorChooserSkin.class);
        this.componentSkinMap.put(ColorChooserButton.class, TerraColorChooserButtonSkin.class);
        this.componentSkinMap.put(Dialog.class, TerraDialogSkin.class);
        this.componentSkinMap.put(Expander.class, TerraExpanderSkin.class);
        this.componentSkinMap.put(FileBrowser.class, TerraFileBrowserSkin.class);
        this.componentSkinMap.put(FileBrowserSheet.class, TerraFileBrowserSheetSkin.class);
        this.componentSkinMap.put(Form.class, TerraFormSkin.class);
        this.componentSkinMap.put(BoxPane.class, TerraBoxPaneSkin.class);
        this.componentSkinMap.put(Frame.class, TerraFrameSkin.class);
        this.componentSkinMap.put(GridPane.class, TerraGridPaneSkin.class);
        this.componentSkinMap.put(Label.class, TerraLabelSkin.class);
        this.componentSkinMap.put(LinkButton.class, TerraLinkButtonSkin.class);
        this.componentSkinMap.put(ListButton.class, TerraListButtonSkin.class);
        this.componentSkinMap.put(ListView.class, TerraListViewSkin.class);
        this.componentSkinMap.put(Menu.class, TerraMenuSkin.class);
        this.componentSkinMap.put(Menu.Item.class, TerraMenuItemSkin.class);
        this.componentSkinMap.put(MenuBar.class, TerraMenuBarSkin.class);
        this.componentSkinMap.put(MenuBar.Item.class, TerraMenuBarItemSkin.class);
        this.componentSkinMap.put(MenuButton.class, TerraMenuButtonSkin.class);
        this.componentSkinMap.put(MenuPopup.class, TerraMenuPopupSkin.class);
        this.componentSkinMap.put(Meter.class, TerraMeterSkin.class);
        this.componentSkinMap.put(Palette.class, TerraPaletteSkin.class);
        this.componentSkinMap.put(Panel.class, TerraPanelSkin.class);
        this.componentSkinMap.put(Panorama.class, TerraPanoramaSkin.class);
        this.componentSkinMap.put(Prompt.class, TerraPromptSkin.class);
        this.componentSkinMap.put(PushButton.class, TerraPushButtonSkin.class);
        this.componentSkinMap.put(RadioButton.class, TerraRadioButtonSkin.class);
        this.componentSkinMap.put(Rollup.class, TerraRollupSkin.class);
        this.componentSkinMap.put(ScrollBar.class, TerraScrollBarSkin.class);
        this.componentSkinMap.put(ScrollPane.class, TerraScrollPaneSkin.class);
        this.componentSkinMap.put(ScrollPane.Corner.class, TerraScrollPaneCornerSkin.class);
        this.componentSkinMap.put(Separator.class, TerraSeparatorSkin.class);
        this.componentSkinMap.put(Sheet.class, TerraSheetSkin.class);
        this.componentSkinMap.put(Slider.class, TerraSliderSkin.class);
        this.componentSkinMap.put(Spinner.class, TerraSpinnerSkin.class);
        this.componentSkinMap.put(SplitPane.class, TerraSplitPaneSkin.class);
        this.componentSkinMap.put(SuggestionPopup.class, TerraSuggestionPopupSkin.class);
        this.componentSkinMap.put(TablePane.class, TerraTablePaneSkin.class);
        this.componentSkinMap.put(TableViewHeader.class, TerraTableViewHeaderSkin.class);
        this.componentSkinMap.put(TableView.class, TerraTableViewSkin.class);
        this.componentSkinMap.put(TabPane.class, TerraTabPaneSkin.class);
        this.componentSkinMap.put(TextArea.class, TerraTextAreaSkin.class);
        this.componentSkinMap.put(TextPane.class, TerraTextPaneSkin.class);
        this.componentSkinMap.put(TextInput.class, TerraTextInputSkin.class);
        this.componentSkinMap.put(Tooltip.class, TerraTooltipSkin.class);
        this.componentSkinMap.put(TreeView.class, TerraTreeViewSkin.class);
        this.componentSkinMap.put(TerraCalendarSkin.DateButton.class, TerraCalendarSkin.DateButtonSkin.class);
        this.componentSkinMap.put(TerraExpanderSkin.ShadeButton.class, TerraExpanderSkin.ShadeButtonSkin.class);
        this.componentSkinMap.put(TerraFrameSkin.FrameButton.class, TerraFrameSkin.FrameButtonSkin.class);
        this.componentSkinMap.put(TerraRollupSkin.RollupButton.class, TerraRollupSkin.RollupButtonSkin.class);
        this.componentSkinMap.put(TerraScrollBarSkin.ScrollButton.class, TerraScrollBarSkin.ScrollButtonSkin.class);
        this.componentSkinMap.put(TerraScrollBarSkin.Handle.class, TerraScrollBarSkin.HandleSkin.class);
        this.componentSkinMap.put(TerraSliderSkin.Thumb.class, TerraSliderSkin.ThumbSkin.class);
        this.componentSkinMap.put(TerraSpinnerSkin.SpinButton.class, TerraSpinnerSkin.SpinButtonSkin.class);
        this.componentSkinMap.put(TerraSpinnerSkin.SpinnerContent.class, TerraSpinnerSkin.SpinnerContentSkin.class);
        this.componentSkinMap.put(TerraSplitPaneSkin.Splitter.class, TerraSplitPaneSkin.SplitterSkin.class);
        this.componentSkinMap.put(TerraSplitPaneSkin.SplitterShadow.class, TerraSplitPaneSkin.SplitterShadowSkin.class);
        this.componentSkinMap.put(TerraTabPaneSkin.TabButton.class, TerraTabPaneSkin.TabButtonSkin.class);
        String packageName = ((Object)((Object)this)).getClass().getPackage().getName();
        String location = null;
        try {
            String locationKey = ((Object)((Object)this)).getClass().getPackage().getName() + "." + LOCATION_PROPERTY;
            location = System.getProperty(locationKey);
        }
        catch (SecurityException exception) {
            // empty catch block
        }
        if (location == null) {
            locationURL = ((Object)((Object)this)).getClass().getResource("TerraTheme_default.json");
        } else {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            locationURL = location.startsWith("/") ? classLoader.getResource(location.substring(1)) : classLoader.getResource(packageName.replace('.', '/') + "/" + location);
        }
        if (locationURL == null) {
            throw new RuntimeException("Unable to locate color scheme resource \"" + location + "\".");
        }
        this.load(locationURL);
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("terra_theme_styles.json");
            try {
                JSONSerializer serializer = new JSONSerializer();
                Map terraThemeStyles = (Map)serializer.readObject(inputStream);
                for (String name : terraThemeStyles) {
                    Component.getNamedStyles().put((Object)(packageName + "." + name), (Object)((Map)terraThemeStyles.get((Object)name)));
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        catch (SerializationException exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(URL location) {
        if (location == null) {
            throw new IllegalArgumentException("location URL is null");
        }
        try {
            InputStream inputStream = location.openStream();
            try {
                JSONSerializer serializer = new JSONSerializer();
                Map properties = (Map)serializer.readObject(inputStream);
                this.font = Font.decode((String)properties.get((Object)"font"));
                List colorCodes = (List)properties.get((Object)"colors");
                this.numberOfPaletteColors = colorCodes.getLength();
                int numberOfColors = this.numberOfPaletteColors * 3;
                this.colors = new ArrayList(numberOfColors);
                colorMultiplier = ((Double)properties.get((Object)"colorMultiplier")).floatValue();
                for (String colorCode : colorCodes) {
                    Color baseColor = Color.decode(colorCode);
                    this.colors.add((Object)TerraTheme.darken(baseColor));
                    this.colors.add((Object)baseColor);
                    this.colors.add((Object)TerraTheme.brighten(baseColor));
                }
                Map messageIconNames = (Map)properties.get((Object)"messageIcons");
                this.messageIcons = new HashMap();
                this.loadMessageIcons((Map<String, String>)messageIconNames, this.messageIcons);
                Map smallMessageIconNames = (Map)properties.get((Object)"smallMessageIcons");
                this.smallMessageIcons = new HashMap();
                this.loadMessageIcons((Map<String, String>)smallMessageIconNames, this.smallMessageIcons);
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        catch (SerializationException exception) {
            throw new RuntimeException(exception);
        }
    }

    private void loadMessageIcons(Map<String, String> messageIconNames, HashMap<MessageType, Image> messageIconsLocal) {
        for (String messageIconType : messageIconNames) {
            Image messageIcon;
            String messageIconName = (String)messageIconNames.get((Object)messageIconType);
            try {
                messageIcon = Image.load((URL)((Object)((Object)this)).getClass().getResource(messageIconName));
            }
            catch (TaskExecutionException exception) {
                throw new RuntimeException(exception);
            }
            messageIconsLocal.put((Object)MessageType.valueOf((String)messageIconType.toUpperCase(Locale.ENGLISH)), (Object)messageIcon);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException();
        }
        this.font = font;
    }

    public Color getColor(int index) {
        return (Color)this.colors.get(index);
    }

    public void setColor(int index, Color color) {
        if (color == null) {
            throw new IllegalArgumentException();
        }
        this.colors.update(index, (Object)color);
    }

    public Color getBaseColor(int index) {
        return (Color)this.colors.get(index * 3 + 1);
    }

    public void setBaseColor(int index, Color baseColor) {
        if (baseColor == null) {
            throw new IllegalArgumentException();
        }
        int offset = index * 3;
        this.colors.update(offset, (Object)TerraTheme.darken(baseColor));
        this.colors.update(offset + 1, (Object)baseColor);
        this.colors.update(offset + 2, (Object)TerraTheme.brighten(baseColor));
    }

    public int getNumberOfPaletteColors() {
        return this.numberOfPaletteColors;
    }

    public int getNumberOfColors() {
        return this.colors == null ? 0 : this.colors.getLength();
    }

    public Image getMessageIcon(MessageType messageType) {
        return (Image)this.messageIcons.get((Object)messageType);
    }

    public void setMessageIcon(MessageType messageType, Image messageIcon) {
        if (messageType == null || messageIcon == null) {
            throw new IllegalArgumentException();
        }
        this.messageIcons.put((Object)messageType, (Object)messageIcon);
    }

    public Image getSmallMessageIcon(MessageType messageType) {
        return (Image)this.smallMessageIcons.get((Object)messageType);
    }

    public void setSmallMessageIcon(MessageType messageType, Image smallMessageIcon) {
        if (messageType == null || smallMessageIcon == null) {
            throw new IllegalArgumentException();
        }
        this.smallMessageIcons.put((Object)messageType, (Object)smallMessageIcon);
    }

    public static Color brighten(Color color) {
        return TerraTheme.adjustBrightness(color, colorMultiplier);
    }

    public static Color darken(Color color) {
        return TerraTheme.adjustBrightness(color, colorMultiplier * -1.0f);
    }

    public static Color brighten(Color color, float adjustment) {
        return TerraTheme.adjustBrightness(color, adjustment);
    }

    public static Color darken(Color color, float adjustment) {
        return TerraTheme.adjustBrightness(color, adjustment * -1.0f);
    }

    private static Color adjustBrightness(Color color, float adjustment) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        hsb[2] = Math.min(Math.max(hsb[2] + adjustment, 0.0f), 1.0f);
        int rgb = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        return new Color(color.getAlpha() << 24 | rgb & 0xFFFFFF, true);
    }
}

