/*
 * Decompiled with CFR 0.152.
 */
package tw.com.chttl;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Vector;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CertUtil {
    private static Hashtable a = new Hashtable();
    private static Hashtable if;

    protected CertUtil() {
    }

    public static String getCertType(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "NULL Certificate";
        }
        String string = x509Certificate.getIssuerDN().getName();
        String string2 = (String)if.get(string);
        return string2 == null ? "UNKNOWN" : string2;
    }

    public static String getSubjectTypeOID(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "NULL Certificate";
        }
        try {
            byte[] byArray = x509Certificate.getExtensionValue("2.5.29.9");
            if (byArray == null) {
                return null;
            }
            byte[] byArray2 = new Oid("2.16.886.1.100.2.1").getDER();
            int n2 = CertUtil.a(byArray, byArray2);
            if (n2 == -1) {
                return null;
            }
            n2 = n2 + byArray2.length + 2;
            byte by = byArray[n2 - 1];
            byte[] byArray3 = new byte[by];
            System.arraycopy(byArray, n2, byArray3, 0, by);
            return new Oid(byArray3).toString();
        }
        catch (GSSException gSSException) {
            return "";
        }
    }

    public static String getSubjectType(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "NULL Certificate";
        }
        try {
            byte[] byArray = x509Certificate.getExtensionValue("2.5.29.9");
            if (byArray == null) {
                return null;
            }
            byte[] byArray2 = new Oid("2.16.886.1.100.2.1").getDER();
            int n2 = CertUtil.a(byArray, byArray2);
            if (n2 == -1) {
                return null;
            }
            n2 = n2 + byArray2.length + 2;
            byte by = byArray[n2 - 1];
            byte[] byArray3 = new byte[by];
            System.arraycopy(byArray, n2, byArray3, 0, by);
            String string = (String)a.get(new Oid(byArray3).toString());
            return string == null ? "UNKNOWN" : string;
        }
        catch (GSSException gSSException) {
            return "";
        }
    }

    public static String getCardType(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "NULL Certificate";
        }
        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.9");
        if (byArray == null) {
            return null;
        }
        try {
            byte[] byArray2 = new Oid("2.16.886.1.100.2.2").getDER();
            int n2 = CertUtil.a(byArray, byArray2);
            if (n2 == -1) {
                return null;
            }
            n2 = n2 + byArray2.length + 4;
            byte by = byArray[n2 - 1];
            return new String(byArray, n2, (int)by);
        }
        catch (GSSException gSSException) {
            return "";
        }
    }

    public static String getOrgOID(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "NULL Certificate";
        }
        try {
            byte[] byArray = x509Certificate.getExtensionValue("2.5.29.9");
            if (byArray == null) {
                return null;
            }
            byte[] byArray2 = new Oid("2.16.886.1.100.2.102").getDER();
            int n2 = CertUtil.a(byArray, byArray2);
            if (n2 == -1) {
                return null;
            }
            n2 = n2 + byArray2.length + 2;
            byte by = byArray[n2 - 1];
            byte[] byArray3 = new byte[by];
            System.arraycopy(byArray, n2, byArray3, 0, by);
            return new Oid(byArray3).toString();
        }
        catch (GSSException gSSException) {
            return "";
        }
    }

    public static String getEnterpriseId(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "NULL Certificate";
        }
        try {
            byte[] byArray = x509Certificate.getExtensionValue("2.5.29.9");
            if (byArray == null) {
                return null;
            }
            byte[] byArray2 = new Oid("2.16.886.1.100.2.101").getDER();
            int n2 = CertUtil.a(byArray, byArray2);
            if (n2 == -1) {
                return null;
            }
            n2 = n2 + byArray2.length + 4;
            byte by = byArray[n2 - 1];
            return new String(byArray, n2, (int)by);
        }
        catch (GSSException gSSException) {
            return null;
        }
    }

    public static String getPersonId(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "NULL Certificate";
        }
        try {
            byte[] byArray = x509Certificate.getExtensionValue("2.5.29.9");
            if (byArray == null) {
                return null;
            }
            byte[] byArray2 = new Oid("2.16.886.1.100.2.51").getDER();
            int n2 = CertUtil.a(byArray, byArray2);
            if (n2 == -1) {
                return null;
            }
            n2 = n2 + byArray2.length + 4;
            byte by = byArray[n2 - 1];
            return new String(byArray, n2, (int)by);
        }
        catch (GSSException gSSException) {
            return null;
        }
    }

    public static String getCRLDistributionPoint(X509Certificate x509Certificate) {
        Vector vector = CertUtil.getCRLDistributionPoints(x509Certificate);
        if (vector == null) {
            return null;
        }
        return (String)vector.get(0);
    }

    public static Vector getCRLDistributionPoints(X509Certificate x509Certificate) {
        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.31");
        if (byArray == null) {
            return null;
        }
        String string = null;
        try {
            string = new String(byArray, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Vector<String> vector = new Vector<String>();
        if (string.indexOf("http") == -1) {
            return null;
        }
        int n2 = 0;
        while ((n2 = string.indexOf("http", n2)) != -1) {
            byte by = byArray[n2 - 1];
            String string2 = new String(byArray, n2, (int)by);
            vector.add(string2);
            ++n2;
        }
        return vector;
    }

    public static String getOCSP(X509Certificate x509Certificate) {
        byte[] byArray = x509Certificate.getExtensionValue("1.3.6.1.5.5.7.1.1");
        if (byArray == null) {
            return null;
        }
        try {
            byte[] byArray2 = new Oid("1.3.6.1.5.5.7.48.1").getDER();
            int n2 = CertUtil.a(byArray, byArray2);
            if (n2 == -1) {
                return null;
            }
            n2 = n2 + byArray2.length + 2;
            byte by = byArray[n2 - 1];
            return new String(byArray, n2, (int)by);
        }
        catch (GSSException gSSException) {
            return null;
        }
    }

    public static String getIssuerURL(X509Certificate x509Certificate) {
        byte[] byArray = x509Certificate.getExtensionValue("1.3.6.1.5.5.7.1.1");
        if (byArray == null) {
            return null;
        }
        try {
            byte[] byArray2 = new Oid("1.3.6.1.5.5.7.48.2").getDER();
            int n2 = CertUtil.a(byArray, byArray2);
            if (n2 == -1) {
                return null;
            }
            n2 = n2 + byArray2.length + 2;
            byte by = byArray[n2 - 1];
            return new String(byArray, n2, (int)by);
        }
        catch (GSSException gSSException) {
            return null;
        }
    }

    public static X509Certificate generateCert(InputStream inputStream) throws CertificateException {
        return (X509Certificate)CertificateFactory.getInstance("X509").generateCertificate(inputStream);
    }

    public static X509Certificate generateCert(byte[] byArray) throws CertificateException {
        return CertUtil.generateCert(new ByteArrayInputStream(byArray));
    }

    public static boolean verifyCert(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        try {
            x509Certificate.verify(x509Certificate2.getPublicKey());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static int a(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < byArray.length - byArray2.length; ++i2) {
            int n2;
            for (n2 = 0; n2 < byArray2.length && byArray[i2 + n2] == byArray2[n2]; ++n2) {
            }
            if (n2 != byArray2.length) continue;
            return i2;
        }
        return -1;
    }

    public static void main(String[] stringArray) {
        try {
            String string = "moica.cer";
            if (stringArray.length == 1) {
                string = stringArray[0];
            }
            if (stringArray.length == 1) {
                string = stringArray[0];
            }
            FileInputStream fileInputStream = new FileInputStream(string);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
            System.out.println("\u6548\u671f\u59cb=" + x509Certificate.getNotBefore());
            System.out.println("\u6548\u671f\u6b62=" + x509Certificate.getNotAfter());
            System.out.println("SN=" + x509Certificate.getSerialNumber().toString(16));
            System.out.println("CRL\u767c\u4f48\u9ede=" + CertUtil.getCRLDistributionPoint(x509Certificate));
            System.out.println("\u767c\u884c\u8005\u6191\u8b49\u767c\u4f48\u9ede=" + CertUtil.getIssuerURL(x509Certificate));
            System.out.println("OCSP\u767c\u4f48\u9ede=" + CertUtil.getOCSP(x509Certificate));
            System.out.println("\u6b63\u9644\u5361\u8a3b\u8a18=" + CertUtil.getCardType(x509Certificate));
            System.out.println("\u6191\u8b49\u7a2e\u985e=" + CertUtil.getCertType(x509Certificate));
            System.out.println("\u7d71\u4e00\u7de8\u865f=" + CertUtil.getEnterpriseId(x509Certificate));
            System.out.println("\u7d44\u7e54OID=" + CertUtil.getOrgOID(x509Certificate));
            System.out.println("\u8eab\u4efd\u8b49\u672b\u78bc=" + CertUtil.getPersonId(x509Certificate));
            System.out.println("\u4e3b\u9ad4\u5f62\u5f0f=" + CertUtil.getSubjectType(x509Certificate));
            System.out.println("\u4e3b\u9ad4OID=" + CertUtil.getSubjectTypeOID(x509Certificate));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        a.put("2.16.886.1.100.3.2.1.1", "\u653f\u5e9c\u6a5f\u95dc");
        a.put("2.16.886.1.100.3.2.1.2", "\u653f\u5e9c\u55ae\u4f4d");
        a.put("2.16.886.1.100.3.2.2.1.1", "\u516c\u53f8");
        a.put("2.16.886.1.100.3.2.3.3.1", "\u5206\u516c\u53f8");
        a.put("2.16.886.1.100.3.2.3.1", "\u5546\u865f");
        a.put("2.16.886.1.100.3.2.2.2.1", "\u793e\u5718\u6cd5\u4eba");
        a.put("2.16.886.1.100.3.2.2.2.2", "\u8ca1\u5718\u6cd5\u4eba");
        a.put("2.16.886.1.100.3.2.11", "\u5b78\u6821");
        a.put("2.16.886.1.100.3.2.3.4", "\u81ea\u7531\u8077\u696d\u4e8b\u52d9\u6240");
        a.put("2.16.886.1.100.3.2.49", "\u5176\u4ed6\u7d44\u7e54\u6216\u5718\u9ad4");
        a.put("2.16.886.1.100.3.1.1", "\u570b\u6c11");
        a.put("2.16.886.1.100.3.3.1", "Server AP");
        if = new Hashtable();
        if.put("OU=\u5de5\u5546\u6191\u8b49\u7ba1\u7406\u4e2d\u5fc3, O=\u884c\u653f\u9662, C=TW", "MOEACA");
        if.put("OU=\u5167\u653f\u90e8\u6191\u8b49\u7ba1\u7406\u4e2d\u5fc3, O=\u884c\u653f\u9662, C=TW", "MOICA");
        if.put("OU=\u653f\u5e9c\u6191\u8b49\u7ba1\u7406\u4e2d\u5fc3, O=\u884c\u653f\u9662, C=TW", "GCA");
        if.put("OU=\u7d44\u7e54\u53ca\u5718\u9ad4\u6191\u8b49\u7ba1\u7406\u4e2d\u5fc3, O=\u884c\u653f\u9662, C=TW", "XCA");
        if.put("OU=\u653f\u5e9c\u6e2c\u8a66\u6191\u8b49\u7ba1\u7406\u4e2d\u5fc3, O=\u884c\u653f\u9662, C=TW", "GTESTCA");
    }
}

