<?
define('IN_SITE', true);
define('IN_ADMIN', true);
$path = './';
require($path.'includes/page_header.php');
$lang_db->admin();

if($userdata['userlevel'] != 1) die_message($lang['System_message'], $lang_db->group(array($lang['Not_admin_auth'], $lang['Nav_index'])), '');

$cid = ( isset($HTTP_GET_VARS['cid']) ) ? trim($HTTP_GET_VARS['cid']) : '';
$fid = ( isset($HTTP_GET_VARS['fid']) ) ? trim($HTTP_GET_VARS['fid']) : '';
$mode = (isset($HTTP_GET_VARS['mode'])) ? $HTTP_GET_VARS['mode'] : '';

// ********************************************************************************
// [AF-01] Function: Authorization Seletion
// ********************************************************************************
	function select_auth($auth, $forum_id = 0, $option_list, $result_auth){
		$tag = ($forum_id > 0) ? '['.$forum_id.']' : '';
		$select_auth = '<select name="'.$auth.$tag.'">';
		$i = 0;
		foreach($option_list as $var){
			$i++;
			$s = ($result_auth == $i) ? ' selected="selected"' : '';
			$select_auth .= '<option value="'.$i.'"'.$s.'>'.$var."</option>";
		}
		$select_auth .= '</select>';

		return $select_auth;
	}
// [AF-01] END <<<<

if($mode == 'addcat'){
	$cat_name = ( isset($HTTP_POST_VARS['cat_name']) ) ? encoding($HTTP_POST_VARS['cat_name']) : '';
	$cat_description = ( isset($HTTP_POST_VARS['cat_description']) ) ? encoding($HTTP_POST_VARS['cat_description']) : '';
	$cat_order = ( isset($HTTP_POST_VARS['cat_description']) ) ? $HTTP_POST_VARS['cat_order'] : '';
	$cat_banner = ( isset($HTTP_POST_VARS['cat_banner']) ) ? $HTTP_POST_VARS['cat_banner'] : '';

	// ********************************************************************************
	// [AF-02] Adding: Checking Category
	// ********************************************************************************
		if(empty($cat_name)) die_message($lang['System_error'], $lang_db->group(array($lang['Category_error_name'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if(empty($cat_description)) die_message($lang['System_error'], $lang_db->group(array($lang['Category_error_desc'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if(empty($cat_order)) die_message($lang['System_error'], $lang_db->group(array($lang['Category_error_order'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
	// [AF-02] END <<<<

	if(!$query = $db->query("INSERT INTO " . CAT_TABLE . " (cat_name, cat_description, cat_order, cat_banner) VALUES ('$cat_name', '$cat_description', '$cat_order', '$cat_banner')")){
		die_message($lang['System_error'], $lang_db->group(array($lang['Category_add_error'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
	}else{
		@unlink($path."sqlcache/cat_data.php");
		@unlink($path."sqlcache/catnav_data.php");
		@unlink($path."sqlcache/forumnav_data");
		die_message($lang['System_message'], $lang_db->group(array($lang['Category_add_successful'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
	}
}elseif($mode == 'updatecat'){
	$query = $db->query("SELECT COUNT(cat_id) AS total FROM " . CAT_TABLE . " WHERE cat_id = $cid", 'UNBUFFERED');
	$result = $db->fetch_array($query);
	if($result['total'] == 0) die_message($lang['System_error'], $lang_db->group(array($lang['Cat_not_found'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	$db->free_result($query);

	$cat_name = ( isset($HTTP_POST_VARS['cat_name']) ) ? encoding($HTTP_POST_VARS['cat_name']) : '';
	$cat_description = ( isset($HTTP_POST_VARS['cat_description']) ) ? encoding($HTTP_POST_VARS['cat_description']) : '';
	$cat_order = ( isset($HTTP_POST_VARS['cat_description']) ) ? $HTTP_POST_VARS['cat_order'] : '';
	$cat_banner = ( isset($HTTP_POST_VARS['cat_banner']) ) ? $HTTP_POST_VARS['cat_banner'] : '';

	// ********************************************************************************
	// [AF-03] Updating: Checking Category
	// ********************************************************************************
		if(empty($cat_name)) die_message($lang['System_error'], $lang_db->group(array($lang['Category_error_name'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if(empty($cat_description)) die_message($lang['System_error'], $lang_db->group(array($lang['Category_error_desc'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if(empty($cat_order)) die_message($lang['System_error'], $lang_db->group(array($lang['Category_error_order'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
	// [AF-02] END <<<<

	if(!$query = $db->query("UPDATE " . CAT_TABLE . " SET cat_name = '$cat_name', cat_description = '$cat_description', cat_order = '$cat_order', cat_banner = '$cat_banner' WHERE cat_id = '$cid'")){
		die_message($lang['System_error'], $lang_db->group(array($lang['Category_update_error'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
	}else{
		@unlink($path."sqlcache/cat_data.php");
		@unlink($path."sqlcache/catnav_data.php");
		@unlink($path."sqlcache/forumnav_data");
		die_message($lang['System_message'], $lang_db->group(array($lang['Category_update_successful'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
	}
}elseif($mode == 'removecat'){
	// ********************************************************************************
	// [AF-04] Category Selection
	// ********************************************************************************
		$query = $db->query("SELECT * FROM " . CAT_TABLE . " WHERE cat_id <> $cid", 'UNBUFFERED');
		$select_to = '<select name="move_id">';
		$select_to .= '<option value="0">'.$lang['Category_delete_forum']."</option>";
		while($result = $db->fetch_array($query)){
			$select_to .= '<option value="'.$result['cat_id'].'">'.$result['cat_name']."</option>\n";
			$CAT_EXIST = TRUE;
		}
		$select_to .= '</select>';
		$db->free_result($query);
	// [AF-04] END <<<<

	$query = $db->query("SELECT COUNT(forum_id) AS total FROM " . FORUM_TABLE . " WHERE cat_id = $cid");
	$result = $db->fetch_array($query, 'UNBUFFERED');
	$db->free_result($query);
	$select_to = ($result['total'] == 0) ? '' : $select_to;

	die_message($lang['System_message'], $lang_db->group(array($lang['Category_remove'], sprintf($lang['Category_remove_select'], $select_to), sprintf($lang['Category_apply_remove'], $cid), $lang['Category_disapply_remove'])),'');
}elseif($mode == 'catdelete'){
	$move_id = intval($HTTP_POST_VARS['move_id']);
	$query = $db->query("SELECT COUNT(cat_id) AS total FROM " . CAT_TABLE . " WHERE cat_id = $cid", 'UNBUFFERED');
	$result = $db->fetch_array($query);
	if($result['total'] == 0) die_message($lang['System_error'], $lang_db->group(array($lang['Cat_not_found'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	$db->free_result($query);

	$query = $db->query("SELECT COUNT(forum_id) AS total FROM " . FORUM_TABLE . " WHERE cat_id = $cid", 'UNBUFFERED');
	$forumresult = $db->fetch_array($query);
	$db->free_result($query);

	if($result['total'] > 0 && $move_id > 0){
		$query = $db->query("UPDATE " . FORUM_TABLE . " SET cat_id = $move_id WHERE cat_id = $cid");
	}elseif($move_id == 0){
		$query = $db->query("SELECT forum_id FROM " . FORUM_TABLE . " WHERE cat_id = $cid");
		while($result = $db->fetch_array($query)){
			$delete_forum_id .= (!empty($delete_forum_id)) ? ",".$result['forum_id'] : $result['forum_id'];
		}
		if(!empty($delete_forum_id)){
			$query = $db->query("SELECT forum_id FROM " . FORUM_TABLE . " WHERE forum_on IN($delete_forum_id)");
			while($result = $db->fetch_array($query)){
				$delete_forum_id .= (!empty($delete_forum_id)) ? ",".$result['forum_id'] : $result['forum_id'];
			}
		}
		$query = $db->query("DELETE FROM " . FORUM_TABLE . " WHERE cat_id = $cid");
		$query = $db->query("UPDATE " . INFO_TABLE . " SET info_value = info_value-".$forumresult['total']." WHERE info_name = 'forum'");

		if(!empty($delete_forum_id)){
			$query = $db->query("DELETE FROM " . FORUM_TABLE . " WHERE forum_id IN($delete_forum_id)");
			$query = $db->query("DELETE FROM " . TOPIC_TABLE . " WHERE forum_id IN($delete_forum_id)");
			$query = $db->query("DELETE FROM " . POST_TABLE . " WHERE forum_id IN($delete_forum_id)");
		}

		$info_post = 0;
		$query = $db->query("SELECT COUNT(post_id) AS total FROM " . POST_TABLE);
		$result = $db->fetch_array($query);
		$info_post = $result['total'];

		$query = $db->query("UPDATE " . INFO_TABLE . " SET info_value = '$info_post' WHERE info_name = 'archive'");
	}

	if(!$query = $db->query("DELETE FROM " . CAT_TABLE . " WHERE cat_id = $cid")){
		die_message($lang['System_error'], $lang_db->group(array($lang['Category_delete_error'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	}else{
		@unlink($path."sqlcache/cat_data.php");
		@unlink($path."sqlcache/catnav_data.php");
		@unlink($path."sqlcache/forumnav_data");
		die_message($lang['System_message'], $lang_db->group(array($lang['Category_delete_successful'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	}
}elseif($mode == 'editcat'){
	$tpl = new TemplatePower($path.$style_tpl."adm_cat_edit_body.tpl");
	$tpl->prepare();

	$query = $db->query("SELECT * FROM " . CAT_TABLE . " WHERE cat_id = $cid", 'UNBUFFERED');
	$cats_row = $db->fetch_array($query);
	if(count($cats_row) == 0) die_message($lang['System_error'], $lang_db->group(array($lang['Cat_not_found'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	$db->free_result($query);

	$tpl->assign(array(
		'CATNAME' => decoding($cats_row['cat_name']),
		'CATDESC' => decoding($cats_row['cat_description']),
		'CATORDER' => $cats_row['cat_order'],
		'CATBANNER' => $cats_row['cat_banner'],
		'L_NAME' => $lang['Name'],
		'L_DESC' => $lang['Description'],
		'L_ORDER' => $lang['Order'],
		'L_BANNER' => $lang['Category_banner'],
		'L_SUBMIT' => $lang['Submit'],
		'L_EDIT_CAT_TITLE' => $lang['Forum_cat_edit_title'],
		'L_ADMIN_PANEL' => $lang['Administrator_panel'],
		'A_ACTION' => 'adm_forum.php?mode=updatecat&amp;cid='.$cid
	));
}elseif($mode == 'createforum'){
	$tpl = new TemplatePower($path.$style_tpl."adm_forum_add_body.tpl");
	$tpl->prepare();

	// ********************************************************************************
	// [AF-05] Getting Icon Selection (Add)
	// ********************************************************************************
		$dir = @opendir("./images/icons/");
		while( $file = @readdir($dir) ){
			if( preg_match("/^.*?\gif|jpg|bmp|png$/", $file) ) $forum_icon[] = basename($file);
		}
		@closedir($dir);

		$select_icon = '<select name="forum_icon">';
		$select_icon .= '<option value="">' . $lang['Forum_select_icon'] . '</option>';
		if(count($forum_icon) > 0){
			foreach($forum_icon as $var){
				$select_icon .= '<option value="'.$var.'">'.$var.'</option>';
			}
		}
		$select_icon .= '</select>';
	// [AF-05] END <<<<

	// ********************************************************************************
	// [AF-06] Getting Group Selection (Add)
	// ********************************************************************************
		$query = $db->query("SELECT * FROM " . GROUP_TABLE, 'UNBUFFERED');
		$select_group = '<select name="forum_group">';
		$select_group .= '<option value="0">'.$lang['Forum_no_group'].'</option>';
		while($result = $db->fetch_array($query)){
			$select_group .= '<option value="'.$result['group_id'].'">'.decoding($result['group_name']).'</option>';
		}
		$select_group .= '</select>';
	// [AF-06] END <<<<

	// ********************************************************************************
	// [AF-07] Getting Forum Selection (Add)
	// ********************************************************************************
		$query = $db->query("SELECT * FROM " . FORUM_TABLE . " WHERE forum_on = 0 AND cat_id = $cid", 'UNBUFFERED');
		$select_forum = '<select name="forum_on">';
		$select_forum .= '<option value="0">'.$lang['Forum_not_sub'].'</option>';
		while($result = $db->fetch_array($query)){
			$select_forum .= '<option value="'.$result['forum_id'].'">'.decoding($result['forum_name']).'</option>';
		}
		$select_forum .= '</select>';
	// [AF-07] END <<<<

	$tpl->assign(array(
		'S_FORUM_GROUP' => $select_group,
		'S_FORUM_SUB' => $select_forum,
		'L_FORUM_SUB' => $lang['Forum_sub'],
		'L_FORUM_GROUP_ADDON' => $lang['Forum_group_addon'],
		'L_FORUM_GROUP_VIEW' => $lang['Forum_group_hide'],
		'L_FORUM_GROUP_HIDE' => $lang['Forum_group_view'],
		'L_FORUM_GROUP' => $lang['Forum_group'],
		'L_FORUM_VIEW' => $lang['Forum_group_hide'],
		'L_FORUM_HIDE' => $lang['Forum_group_hide'],
		'L_FORUM_GROUP' => $lang['Forum_group'],
		'L_FORUM_PASSWORD' => $lang['Forum_password'],
		'L_VIEW_AUTH' => $lang['Forum_auth_view'],
		'L_ATTACH_AUTH' => $lang['Forum_auth_attach'],
		'L_POLL_AUTH' => $lang['Forum_auth_poll'],
		'L_REPLY_AUTH' => $lang['Forum_auth_reply'],
		'L_TOPIC_AUTH' => $lang['Forum_auth_topic'],
		'L_NAME' => $lang['Name'],
		'L_DESC' => $lang['Description'],
		'L_RULE' => $lang['Forum_rule'],
		'L_ACCESS' => $lang['Forum_access'],
		'L_TOPICCC' => $lang['Forum_topic_cc'],
		'L_POSTCC' => $lang['Forum_post_cc'],
		'L_TOPICACCESS' => $lang['Forum_topic_access'],
		'L_POSTACCESS' => $lang['Forum_post_access'],
		'L_FORUM_VIEW_ADDON' => $lang['Forum_view_addon'],
		'L_FORUM_VIEW_TYPE' => $lang['Forum_view_type'],
		'L_STATUS' => $lang['Forum_status'],
		'L_CLOSE' => $lang['Status_close'],
		'L_OPEN' => $lang['Status_open'],
		'L_ICON' => $lang['Forum_icon'],
		'L_ADMIN' => $lang['Level_admin'],
		'L_MOD' => $lang['Level_mod'],
		'L_EDITOR' => $lang['Level_editor'],
		'L_VIP' => $lang['Level_vip'],
		'L_PAYMENT' => $lang['Level_payment'],
		'L_FREE' => $lang['Level_free'],
		'L_UNREGISTER' => $lang['Level_unregister'],
		'L_GUEST' => $lang['Level_guest'],
		'L_MODNOTE' => $lang['Forum_modnote'],
		'L_BANNER' => $lang['Forum_banner'],
		'L_ORDER' => $lang['Order'],
		'L_SUBMIT' => $lang['Submit'],
		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],
		'L_TOPIC_TAG' => $lang['Topic_tag'],
		'L_FORUM_ADD_TITLE' => $lang['Forum_add_title'],
		'L_ADMIN_PANEL' => $lang['Administrator_panel'],
		'S_ICON' => $select_icon,
		'A_ACTION' => 'adm_forum.php?mode=addforum&amp;cid='.$cid,
	));
}elseif($mode == 'addforum'){
	$forum_name = ( isset($HTTP_POST_VARS['forum_name']) ) ? encoding($HTTP_POST_VARS['forum_name']) : '';
	$forum_description = ( isset($HTTP_POST_VARS['forum_desc']) ) ? encoding($HTTP_POST_VARS['forum_desc']) : '';
	$forum_rule = ( isset($HTTP_POST_VARS['forum_rule']) ) ? encoding($HTTP_POST_VARS['forum_rule'], 1) : '';
	$forum_access = ( isset($HTTP_POST_VARS['forum_access']) ) ? intval(trim($HTTP_POST_VARS['forum_access'])) : '';
	$forum_cc_topic = ( isset($HTTP_POST_VARS['forum_cc_topic']) ) ? intval(trim($HTTP_POST_VARS['forum_cc_topic'])) : '';
	$forum_cc_post = ( isset($HTTP_POST_VARS['forum_cc_post']) ) ? intval(trim($HTTP_POST_VARS['forum_cc_post'])) : '';
	$forum_status = ( isset($HTTP_POST_VARS['forum_status']) ) ? trim($HTTP_POST_VARS['forum_status']) : '';
	$forum_topic_auth = ( isset($HTTP_POST_VARS['forum_topic_auth']) ) ? trim($HTTP_POST_VARS['forum_topic_auth']) : '';
	$forum_reply_auth = ( isset($HTTP_POST_VARS['forum_reply_auth']) ) ? trim($HTTP_POST_VARS['forum_reply_auth']) : '';
	$forum_view_auth = ( isset($HTTP_POST_VARS['forum_view_auth']) ) ? trim($HTTP_POST_VARS['forum_view_auth']) : '';
	$forum_attach_auth = ( isset($HTTP_POST_VARS['forum_attach_auth']) ) ? trim($HTTP_POST_VARS['forum_attach_auth']) : '';
	$forum_poll_auth = ( isset($HTTP_POST_VARS['forum_poll_auth']) ) ? trim($HTTP_POST_VARS['forum_poll_auth']) : '';
	$forum_mod_note = ( isset($HTTP_POST_VARS['forum_mod_note']) ) ? encoding($HTTP_POST_VARS['forum_mod_note'], 1) : '';
	$forum_banner = ( isset($HTTP_POST_VARS['forum_banner']) ) ? trim($HTTP_POST_VARS['forum_banner']) : '';
	$forum_order = ( isset($HTTP_POST_VARS['forum_order']) ) ? intval($HTTP_POST_VARS['forum_order']) : '';
	$forum_icon = ( isset($HTTP_POST_VARS['forum_icon']) ) ? $HTTP_POST_VARS['forum_icon'] : '';
	$forum_access_topic = ( isset($HTTP_POST_VARS['forum_access_topic']) ) ? intval($HTTP_POST_VARS['forum_access_topic']) : '';
	$forum_access_post = ( isset($HTTP_POST_VARS['forum_access_post']) ) ? intval($HTTP_POST_VARS['forum_access_post']) : '';
	$topic_tag = ( isset($HTTP_POST_VARS['topic_tag']) ) ? encoding($HTTP_POST_VARS['topic_tag']) : '';
	$forum_password = ( isset($HTTP_POST_VARS['forum_password']) ) ? $HTTP_POST_VARS['forum_password'] : '';
	$forum_view_type = ( isset($HTTP_POST_VARS['forum_view_type']) ) ? $HTTP_POST_VARS['forum_view_type'] : 0;
	$forum_group = ( isset($HTTP_POST_VARS['forum_group']) ) ? $HTTP_POST_VARS['forum_group'] : 0;
	$forum_group_view = ( isset($HTTP_POST_VARS['forum_group_view']) ) ? $HTTP_POST_VARS['forum_group_view'] : 0;
	$forum_group_hide = ( isset($HTTP_POST_VARS['forum_group_hide']) ) ? $HTTP_POST_VARS['forum_group_hide'] : 0;
	$forum_on = ( isset($HTTP_POST_VARS['forum_on']) ) ? intval($HTTP_POST_VARS['forum_on']) : 0;

	// ********************************************************************************
	// [AF-08] Adding: Checking Forum
	// ********************************************************************************
		if(empty($forum_name)) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_error_name'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if(empty($forum_description)) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_error_description'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if($forum_cc_topic < 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_error_topic_cc'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if($forum_cc_post < 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_error_post_cc'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if($forum_order < 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_error_oeder'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if($forum_access_topic < 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_error_topic_access'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if($forum_access_post < 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_error_post_access'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
	// [AF-08] END <<<<

	if(!$query = $db->query("INSERT INTO " . FORUM_TABLE . " (forum_name, forum_description, forum_rule, forum_access, forum_cc_topic, forum_cc_post, forum_access_topic, forum_access_post, forum_status, cat_id, forum_topic_auth, forum_reply_auth, forum_view_auth, forum_attach_auth, forum_poll_auth, forum_mod_note, forum_order, forum_banner, forum_icon, topic_tag, forum_password, forum_view_type, forum_group, forum_group_view, forum_group_hide, forum_on) VALUES ('$forum_name', '$forum_description', '$forum_rule', '$forum_access', '$forum_cc_topic', '$forum_cc_post', '$forum_access_topic', '$forum_access_post', '$forum_status', '$cid', '$forum_topic_auth', '$forum_reply_auth', '$forum_view_auth', '$forum_attach_auth', '$forum_poll_auth', '$forum_mod_note', '$forum_order', '$forum_banner', '$forum_icon', '$topic_tag', '$forum_password', '$forum_view_type', '$forum_group', '$forum_group_view', '$forum_group_hide', '$forum_on')")){
		die_message($lang['System_error'], $lang_db->group(array($lang['Forum_add_error'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	}else{
		@unlink($path."sqlcache/cat_data.php");
		@unlink($path."sqlcache/catnav_data.php");
		@unlink($path."sqlcache/forumnav_data");
		$query = $db->query("UPDATE " . INFO_TABLE . " SET info_value = info_value+1 WHERE info_name = 'forum'");
		die_message($lang['System_message'], $lang_db->group(array($lang['Forum_add_successful'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	}
}elseif($mode == 'advauth'){
	$tpl = new TemplatePower($path.$style_tpl."adm_forum_advauth_body.tpl");
	$tpl->prepare();

	// ********************************************************************************
	// [AF-09] Advanced Authorization List
	// ********************************************************************************
		$option_list = array($lang['Level_guest'], $lang['Level_unregister'], $lang['Level_free'], $lang['Level_payment'], $lang['Level_vip'], $lang['Level_mod'], $lang['Level_editor'], $lang['Level_admin']);
		$query = $db->query("SELECT * FROM " . FORUM_TABLE . " ORDER BY forum_order, forum_id ASC", 'UNBUFFERED');
		while($result = $db->fetch_array($query)){
			$tpl->newBlock("forum_row");
			$tpl->assign(array(
				'FORUM_NAME' => decoding($result['forum_name']),
				'S_TOPIC_AUTH' => select_auth('forum_topic_auth', $result['forum_id'], $option_list, $result['forum_topic_auth']),
				'S_REPLY_AUTH' => select_auth('forum_reply_auth', $result['forum_id'], $option_list, $result['forum_reply_auth']),
				'S_VIEW_AUTH' => select_auth('forum_view_auth', $result['forum_id'], $option_list, $result['forum_view_auth']),
				'S_ATTACH_AUTH' => select_auth('forum_attach_auth', $result['forum_id'], $option_list, $result['forum_attach_auth']),
				'S_POLL_AUTH' => select_auth('forum_poll_auth', $result['forum_id'], $option_list, $result['forum_poll_auth']),
			));
			$FORUM_EXIST = TRUE;
		}
		$db->free_result($query);
		if(!$FORUM_EXIST){
			$tpl->newBlock('noforum');
			$tpl->assign(array(
				'NO_FORUM' => $lang['No_forum']
			));
		}
	// [AF-09] END <<<<

	$tpl->gotoBlock("_ROOT");
	$tpl->assign(array(
		'L_FORUM_AUTH_TITLE'=> $lang['Forum_auth_title'],
		'L_ADMIN_PANEL' => $lang['Administrator_panel'],
		'L_VIEW_AUTH' => $lang['Forum_auth_view'],
		'L_ATTACH_AUTH' => $lang['Forum_auth_attach'],
		'L_POLL_AUTH' => $lang['Forum_auth_poll'],
		'L_REPLY_AUTH' => $lang['Forum_auth_reply'],
		'L_TOPIC_AUTH' => $lang['Forum_auth_topic'],
		'L_ADMIN_PANEL' => $lang['Administrator_panel'],
		'A_ACTION' => 'adm_forum.php?mode=updateauth',
		'L_SUBMIT' => $lang['Submit'],
	));
}elseif($mode == 'updateauth'){
	$forum_topic_auth = ( isset($HTTP_POST_VARS['forum_topic_auth']) ) ? $HTTP_POST_VARS['forum_topic_auth'] : '';
	$forum_reply_auth = ( isset($HTTP_POST_VARS['forum_reply_auth']) ) ? $HTTP_POST_VARS['forum_reply_auth'] : '';
	$forum_attach_auth = ( isset($HTTP_POST_VARS['forum_attach_auth']) ) ? $HTTP_POST_VARS['forum_attach_auth'] : '';
	$forum_view_auth = ( isset($HTTP_POST_VARS['forum_view_auth']) ) ? $HTTP_POST_VARS['forum_view_auth'] : '';
	$forum_poll_auth = ( isset($HTTP_POST_VARS['forum_poll_auth']) ) ? $HTTP_POST_VARS['forum_poll_auth'] : '';

	// ********************************************************************************
	// [AF-10] Setting Authorization
	// ********************************************************************************
		if(!empty($forum_topic_auth)){
			foreach($forum_topic_auth as $key => $var){
				if(!empty($var)) $forum_sql[$key] .= (!empty($forum_sql[$key])) ? ", forum_topic_auth = $var" : "forum_topic_auth = $var";
			}
		}

		if(!empty($forum_reply_auth)){
			foreach($forum_reply_auth as $key => $var){
				if(!empty($var)) $forum_sql[$key] .= (!empty($forum_sql[$key])) ? ", forum_reply_auth = $var" : "forum_reply_auth = $var";
			}
		}

		if(!empty($forum_attach_auth)){
			foreach($forum_attach_auth as $key => $var){
				if(!empty($var)) $forum_sql[$key] .= (!empty($forum_sql[$key])) ? ", forum_attach_auth = $var" : "forum_attach_auth = $var";
			}
		}

		if(!empty($forum_view_auth)){
			foreach($forum_view_auth as $key => $var){
				if(!empty($var)) $forum_sql[$key] .= (!empty($forum_sql[$key])) ? ", forum_view_auth = $var" : "forum_view_auth = $var";
			}
		}

		if(!empty($forum_poll_auth)){
			foreach($forum_poll_auth as $key => $var){
				if(!empty($var)) $forum_sql[$key] .= (!empty($forum_sql[$key])) ? ", forum_poll_auth = $var" : "forum_poll_auth = $var";
			}
		}

		foreach($forum_sql as $key => $var){
			if(!empty($var)) $query = $db->query("UPDATE " . FORUM_TABLE . " SET $var WHERE forum_id = $key", 'UNBUFFERED');
		}
	// [AF-10] END <<<<

	die_message($lang['System_message'], $lang_db->group(array($lang['Forum_update_auth_successful'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
}elseif($mode == 'editforum'){
	$tpl = new TemplatePower($path.$style_tpl."adm_forum_edit_body.tpl");
	$tpl->prepare();

	$query = $db->query("SELECT * FROM " . FORUM_TABLE . " WHERE forum_id = $fid", 'UNBUFFERED');
	$forums_row = $db->fetch_array($query);
	if(count($forums_row) == 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_not_found'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	$db->free_result($query);

	$mod_note = decoding($forums_row['forum_mod_note'], '', 1);
	$forum_rule = decoding($forums_row['forum_rule'], '', 1);

	// ********************************************************************************
	// [AF-11] Getting
	// ********************************************************************************
		$query = $db->query("SELECT * FROM " . CAT_TABLE, 'UNBUFFERED');
		$select_to = '<select name="cat_id">';
		while ($result = $db->fetch_array($query))	{
			$s = ($result['cat_id'] == $forums_row['cat_id']) ? ' selected="selected"' : '';
			$select_to .= '<option value="'.$result['cat_id'].'"'.$s.'>'.$result['cat_name'].'</option>';
		}
		$select_to .= '</select>';
	// [AF-11] END <<<<

	// ********************************************************************************
	// [AF-12] Getting Icon Selection (Edit)
	// ********************************************************************************
		$dir = @opendir("./images/icons/");
		while( $file = @readdir($dir) ){
			if( preg_match("/^.*?\gif|jpg|bmp|png$/", $file) ) $forum_icon[] = basename($file);
		}
		@closedir($dir);

		$select_icon = '<select name="forum_icon">';
		$select_icon .= '<option value="">' . $lang['Forum_select_icon'] . '</option>';
		if(count($forum_icon) > 0){
			foreach($forum_icon as $var){
				$s = ($forums_row['forum_icon'] == $var) ? ' selected="selected"' : '';
				$select_icon .= '<option value="'.$var.'"'.$s.'>'.$var.'</option>';
			}
		}
		$select_icon .= '</select>';
	// [AF-12] END <<<<

	// ********************************************************************************
	// [AF-13] Getting Group Selection (Edit)
	// ********************************************************************************
		$query = $db->query("SELECT * FROM " . GROUP_TABLE, 'UNBUFFERED');
		$select_group = '<select name="forum_group">';
		$select_group .= '<option value="0">'.$lang['Forum_no_group'].'</option>';
		while($result = $db->fetch_array($query)){
			$s = ($result['group_id'] == $forums_row['forum_group']) ? ' selected="selected"' : '';
			$select_group .= '<option value="'.$result['group_id'].'"'.$s.'>'.decoding($result['group_name']).'</option>';
		}
		$select_group .= '</select>';
	// [AF-13] END <<<<

	// ********************************************************************************
	// [AF-14] Getting Forum Selection (Edit)
	// ********************************************************************************
		$query = $db->query("SELECT * FROM " . FORUM_TABLE . " WHERE forum_on = 0 AND forum_id <> $fid", 'UNBUFFERED');
		$select_forum = '<select name="forum_on">';
		$select_forum .= '<option value="0">'.$lang['Forum_not_sub'].'</option>';
		while($result = $db->fetch_array($query)){
			$s = ($result['forum_id'] == $forums_row['forum_on']) ? 'selected="selected"' : '';
			$select_forum .= '<option value="'.$result['forum_id'].'"'.$s.'>'.decoding($result['forum_name']).'</option>';
		}
		$select_forum .= '</select>';
	// [AF-14] END <<<<

	$option_list = array($lang['Level_guest'], $lang['Level_unregister'], $lang['Level_free'], $lang['Level_payment'], $lang['Level_vip'], $lang['Level_mod'], $lang['Level_editor'], $lang['Level_admin']);
	$tpl->assign(array(
		'S_TOPIC_AUTH' => select_auth('forum_topic_auth', 0, $option_list, $forums_row['forum_topic_auth']),
		'S_POST_AUTH' => select_auth('forum_reply_auth', 0, $option_list, $forums_row['forum_reply_auth']),
		'S_VIEW_AUTH' => select_auth('forum_view_auth', 0, $option_list, $forums_row['forum_view_auth']),
		'S_ATTACH_AUTH' => select_auth('forum_attach_auth', 0, $option_list, $forums_row['forum_attach_auth']),
		'S_POLL_AUTH' => select_auth('forum_poll_auth', 0, $option_list, $forums_row['forum_poll_auth']),
		'S_CATSELECT' => $select_to,
		'S_ICON' => $select_icon,
		'S_FORUM_GROUP' => $select_group,
		'S_FORUM_SUB' => $select_forum,
		'A_ACTION' => 'adm_forum.php?mode=updateforum&amp;fid='.$fid,
		'L_FORUM_SUB' => $lang['Forum_sub'],
		'L_FORUM_GROUP_ADDON' => $lang['Forum_group_addon'],
		'L_FORUM_GROUP_VIEW' => $lang['Forum_group_hide'],
		'L_FORUM_GROUP_HIDE' => $lang['Forum_group_view'],
		'L_FORUM_GROUP' => $lang['Forum_group'],
		'L_FORUM_EDIT_TITLE' => $lang['Forum_edit_title'],
		'FORUM_HIDE_YES' => ($forums_row['forum_group_hide'] == 1) ? 'checked=/"checked/"' : '',
		'FORUM_HIDE_NO' => ($forums_row['forum_group_hide'] == 0) ? 'checked=/"checked/"' : '',
		'FORUM_VIEW_YES' => ($forums_row['forum_group_view'] == 1) ? 'checked=/"checked/"' : '',
		'FORUM_VIEW_NO' => ($forums_row['forum_group_view'] == 0) ? 'checked=/"checked/"' : '',
		'FORUMNAME' => decoding($forums_row['forum_name']),
		'FORUMDESC' => decoding($forums_row['forum_description']),
		'FORUMRULE' => $forum_rule,
		'TOPIC_TAG' => decoding($forums_row['topic_tag']),
		'FORUMACCESS' => $forums_row['forum_access'],
		'FORUMCCTOPIC' => $forums_row['forum_cc_topic'],
		'FORUMCCPOST' => $forums_row['forum_cc_post'],
		'FORUMACCESSTOPIC' => $forums_row['forum_access_topic'],
		'FORUMACCESSPOST' => $forums_row['forum_access_post'],
		'FORUMMODNOTE' => $mod_note,
		'FORUMBANNER' => $forums_row['forum_banner'],
		'FORUMORDER' => $forums_row['forum_order'],
		'FORUM_PASSWORD' => $forums_row['forum_password'],
		'FVT_YES' => ($forums_row['forum_view_type'] == 1) ? 'checked=/"checked/"' : '',
		'FVT_NO' => ($forums_row['forum_view_type'] == 0) ? 'checked=/"checked/"' : '',
		'SO' => ($forums_row['forum_status'] == 0) ? 'checked=/"checked/"' : '',
		'SC' => ($forums_row['forum_status'] == 1) ? 'checked=/"checked/"' : '',
		'L_FORUM_VIEW_ADDON' => $lang['Forum_view_addon'],
		'L_FORUM_VIEW_TYPE' => $lang['Forum_view_type'],
		'L_FORUM_PASSWORD' => $lang['Forum_password'],
		'L_ICON' => $lang['Forum_icon'],
		'L_NAME' => $lang['Name'],
		'L_DESC' => $lang['Description'],
		'L_RULE' => $lang['Forum_rule'],
		'L_ACCESS' => $lang['Forum_access'],
		'L_TOPICCC' => $lang['Forum_topic_cc'],
		'L_POSTCC' => $lang['Forum_post_cc'],
		'L_TOPICACCESS' => $lang['Forum_topic_access'],
		'L_POSTACCESS' => $lang['Forum_post_access'],
		'L_STATUS' => $lang['Forum_status'],
		'L_REPLY_AUTH' => $lang['Forum_admin_reply_auth'],
		'L_TOPIC_AUTH' => $lang['Forum_admin_topic_auth'],
		'L_VIEW_AUTH' => $lang['Forum_admin_view_auth'],
		'L_ATTACH_AUTH' => $lang['Forum_admin_attach_auth'],
		'L_POLL_AUTH' => $lang['Forum_admin_poll_auth'],
		'L_CLOSE' => $lang['Status_close'],
		'L_OPEN' => $lang['Status_open'],
		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],
		'L_SUBMIT' => $lang['Submit'],
		'L_CAT' => $lang['Forum_cat'],
		'L_MODNOTE' => $lang['Forum_modnote'],
		'L_BANNER' => $lang['Forum_banner'],
		'L_ORDER' => $lang['Order'],
		'L_TOPIC_TAG' => $lang['Topic_tag'],
		'L_ADMIN_PANEL' => $lang['Administrator_panel']
	));
}elseif($mode == 'updateforum'){
	$query = $db->query("SELECT * FROM " . FORUM_TABLE . " WHERE forum_id = $fid OR forum_on = $fid", 'UNBUFFERED');
	while($result = $db->fetch_array($query)){
		if($result['forum_on'] > 0 && $result['forum_id'] != $fid){
			$subforum_row++;
		}else $forum_row = $result;
	}
	if(count($forum_row) == 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_not_found'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	$db->free_result($query);

	$forum_name = ( isset($HTTP_POST_VARS['forum_name']) ) ? encoding($HTTP_POST_VARS['forum_name']) : '';
	$forum_description = ( isset($HTTP_POST_VARS['forum_desc']) ) ? encoding($HTTP_POST_VARS['forum_desc']) : '';
	$forum_rule = ( isset($HTTP_POST_VARS['forum_rule']) ) ? encoding($HTTP_POST_VARS['forum_rule'], 1) : '';
	$forum_access = ( isset($HTTP_POST_VARS['forum_access']) ) ? intval(trim($HTTP_POST_VARS['forum_access'])) : '';
	$forum_cc_topic = ( isset($HTTP_POST_VARS['forum_cc_topic']) ) ? intval(trim($HTTP_POST_VARS['forum_cc_topic'])) : '';
	$forum_cc_post = ( isset($HTTP_POST_VARS['forum_cc_post']) ) ? intval(trim($HTTP_POST_VARS['forum_cc_post'])) : '';
	$forum_status = ( isset($HTTP_POST_VARS['forum_status']) ) ? trim($HTTP_POST_VARS['forum_status']) : '';
	$cat_id = ( isset($HTTP_POST_VARS['cat_id']) ) ? trim($HTTP_POST_VARS['cat_id']) : '';
	$forum_topic_auth = ( isset($HTTP_POST_VARS['forum_topic_auth']) ) ? trim($HTTP_POST_VARS['forum_topic_auth']) : '';
	$forum_reply_auth = ( isset($HTTP_POST_VARS['forum_reply_auth']) ) ? trim($HTTP_POST_VARS['forum_reply_auth']) : '';
	$forum_view_auth = ( isset($HTTP_POST_VARS['forum_view_auth']) ) ? trim($HTTP_POST_VARS['forum_view_auth']) : '';
	$forum_attach_auth = ( isset($HTTP_POST_VARS['forum_attach_auth']) ) ? trim($HTTP_POST_VARS['forum_attach_auth']) : '';
	$forum_poll_auth = ( isset($HTTP_POST_VARS['forum_poll_auth']) ) ? trim($HTTP_POST_VARS['forum_poll_auth']) : '';
	$forum_mod_note = ( isset($HTTP_POST_VARS['forum_mod_note']) ) ? encoding($HTTP_POST_VARS['forum_mod_note'], 1) : '';
	$forum_banner = ( isset($HTTP_POST_VARS['forum_banner']) ) ? trim($HTTP_POST_VARS['forum_banner']) : '';
	$forum_order = ( isset($HTTP_POST_VARS['forum_order']) ) ? trim($HTTP_POST_VARS['forum_order']) : '';
	$forum_icon = ( isset($HTTP_POST_VARS['forum_icon']) ) ? $HTTP_POST_VARS['forum_icon'] : '';
	$forum_access_topic = ( isset($HTTP_POST_VARS['forum_access_topic']) ) ? intval($HTTP_POST_VARS['forum_access_topic']) : '';
	$forum_access_post = ( isset($HTTP_POST_VARS['forum_access_post']) ) ? intval($HTTP_POST_VARS['forum_access_post']) : '';
	$topic_tag = ( isset($HTTP_POST_VARS['topic_tag']) ) ? encoding($HTTP_POST_VARS['topic_tag']) : '';
	$forum_password = ( isset($HTTP_POST_VARS['forum_password']) ) ? $HTTP_POST_VARS['forum_password'] : '';
	$forum_view_type = ( isset($HTTP_POST_VARS['forum_view_type']) ) ? $HTTP_POST_VARS['forum_view_type'] : 0;
	$forum_group = ( isset($HTTP_POST_VARS['forum_group']) ) ? $HTTP_POST_VARS['forum_group'] : 0;
	$forum_group_view = ( isset($HTTP_POST_VARS['forum_group_view']) ) ? $HTTP_POST_VARS['forum_group_view'] : 0;
	$forum_group_hide = ( isset($HTTP_POST_VARS['forum_group_hide']) ) ? $HTTP_POST_VARS['forum_group_hide'] : 0;
	$forum_on = ( isset($HTTP_POST_VARS['forum_on']) ) ? intval($HTTP_POST_VARS['forum_on']) : 0;


	// ********************************************************************************
	// [AF-15] Updating: Checking Forum
	// ********************************************************************************
		if(empty($forum_name)) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_error_name'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if(empty($forum_description)) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_error_description'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if($forum_cc_topic < 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_error_topic_cc'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if($forum_cc_post < 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_error_post_cc'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if($forum_order < 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_error_oeder'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if($forum_access_topic < 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_error_topic_access'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
		if($forum_access_post < 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_error_post_access'], $lang['Nav_admin_forum'], $lang['Nav_index'])),'');
	// [AF-15] END <<<<

	if(!$query = $db->query("UPDATE " . FORUM_TABLE . " SET forum_name = '$forum_name', forum_description = '$forum_description', forum_rule = '$forum_rule', forum_access = '$forum_access', forum_cc_topic = '$forum_cc_topic', forum_topic_auth = '$forum_topic_auth', forum_reply_auth = '$forum_reply_auth', forum_access_topic = '$forum_access_topic', forum_access_post = '$forum_access_post', forum_cc_post = '$forum_cc_post', forum_status = '$forum_status', cat_id = '$cat_id', forum_banner = '$forum_banner', forum_order = '$forum_order', forum_mod_note = '$forum_mod_note', forum_view_auth = '$forum_view_auth', forum_attach_auth = '$forum_attach_auth', forum_poll_auth = '$forum_poll_auth', forum_icon = '$forum_icon', topic_tag = '$topic_tag', forum_password = '$forum_password', forum_view_type = '$forum_view_type', forum_group = '$forum_group', forum_group_view = '$forum_group_view', forum_group_hide = '$forum_group_hide', forum_on = '$forum_on' WHERE forum_id = '$fid'")){
		die_message($lang['System_error'], $lang_db->group(array($lang['Forum_update_error'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	}else{
		if($forum_row['forum_id'] > 0 && $forum_row['forum_on'] != $forum_on){
			$query = $db->query("UPDATE " . FORUM_TABLE . " SET forum_topics = forum_topics - ".$forum_row['forum_topics'].", forum_posts = forum_posts - ".$forum_row['forum_posts']." WHERE forum_id = ".$forum_row['forum_on']);
			$query = $db->query("UPDATE " . FORUM_TABLE . " SET forum_topics = forum_topics + ".$forum_row['forum_topics'].", forum_posts = forum_posts + ".$forum_row['forum_posts']." WHERE forum_id = ".$forum_on);
		}
		@unlink($path."sqlcache/moderator_".$fid."_data.php.php");
		@unlink($path."sqlcache/forumnav_data");
		die_message($lang['System_message'], $lang_db->group(array($lang['Forum_update_successful'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	}
}elseif($mode == 'removeforum'){
	$query = $db->query("SELECT * FROM " . FORUM_TABLE . " WHERE forum_id = $fid OR forum_on = $fid");
	while($result = $db->fetch_array($query)){
		if($result['forum_on'] > 0 && $result['forum_id'] != $fid){
			$subforum_row++;
		}else $forums_row = $result;
	}
	if($db->num_rows($query) == 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_not_found'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	if($subforum_row > 0 && $forums_row['forum_on'] == 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_exist_sub'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	$db->free_result($query);

	die_message($lang['System_message'], $lang_db->group(array($lang['Forum_remove'], sprintf($lang['Forum_apply_remove'], $fid), $lang['Forum_disapply_remove'])),'');
}elseif($mode == 'forumdelete'){
	$query = $db->query("SELECT * FROM " . FORUM_TABLE . " WHERE forum_id = $fid OR forum_on = $fid");
	while($result = $db->fetch_array($query)){
		if($result['forum_on'] > 0 && $result['forum_id'] != $fid){
			$subforum_row++;
		}else $forums_row = $result;
	}
	if($db->num_rows($query) == 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_not_found'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	if($subforum_row > 0 && $forums_row['forum_on'] == 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_exist_sub'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	$db->free_result($query);

	// ********************************************************************************
	// [AF-16] Deleting: Deleting Forum and Update Information
	// ********************************************************************************
		$query = $db->query("DELETE FROM " . FORUM_TABLE . " WHERE forum_id = $fid");
		$query = $db->query("UPDATE " . INFO_TABLE . " SET info_value = info_value-1 WHERE info_name = 'forum'");
		$query = $db->query("DELETE FROM " . TOPIC_TABLE . " WHERE forum_id = $fid");
		$total_topics_deleted = $db->affected_rows($query);
		$query = $db->query("DELETE FROM " . POST_TABLE . " WHERE forum_id = $fid");
		$total_posts_deleted = $db->affected_rows($query);
		if($forums_row['forum_on'] > 0) $query = $db->query("UPDATE " . FORUM_TABLE . " SET forum_topics = forum_topics - $total_topics_deleted, forum_posts = forum_posts - $total_posts_deleted WHERE forum_id = ".$forums_row['forum_on']);
	// [AF-16] END <<<<

	if(!$query = $db->query("UPDATE " . INFO_TABLE . " SET info_value = info_value - $total_posts_deleted WHERE info_name = 'archive'")){
		die_message($lang['System_error'], $lang_db->group(array($lang['Forum_delete_error'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	}else{
		@unlink($path."sqlcache/moderator_".$fid."_data.php.php");
		@unlink($path."sqlcache/forumnav_data");
		die_message($lang['System_message'], $lang_db->group(array($lang['Forum_delete_successful'], $lang['Nav_admin_forum'], $lang['Nav_index'])), '');
	}
}else{
	$tpl = new TemplatePower($path.$style_tpl."adm_forum_index_body.tpl");
	$tpl->prepare();

	$query = $db->query("SELECT * FROM " . CAT_TABLE . " ORDER BY cat_order, cat_id ASC", 'UNBUFFERED');
	$cat_row = array();
	while ($result = $db->fetch_array($query)){
		$cat_row[] = $result;
	}

	$query = $db->query("SELECT * FROM " . FORUM_TABLE . " ORDER BY forum_order, forum_id ASC", 'UNBUFFERED');
	$forum_row = array();
	while($result = $db->fetch_array($query)){
		if($result['forum_on'] > 0){
			$subforum_id[$result['forum_on']][] = $result['forum_id'];
			$subforum_row[$result['forum_id']] = $result;
		}else $forum_row[] = $result;
	}

	// ********************************************************************************
	// [AF-17] Output Category and Forum list
	// ********************************************************************************
		if(count($cat_row) == 0){
			$tpl->newBlock('nocategary');
			$tpl->assign(array(
				'NO_CAT' => $lang['No_cat']
			));
		}else{
			foreach($cat_row as $catarray){
				$tpl->newBlock('cat_row');
				$tpl->assign(array(
					'CAT_NAME' => decoding($catarray['cat_name']),
					'ADDFORUM' => '<a href="adm_forum.php?mode=createforum&amp;cid='.$catarray['cat_id'].'">'.$lang['Forum_create'].'</a>',
					'EDIT' => '<a href="adm_forum.php?mode=editcat&amp;cid='.$catarray['cat_id'].'">'.$lang['Edit'].'</a>',
					'DELETE' => '<a href="adm_forum.php?mode=removecat&amp;cid='.$catarray['cat_id'].'">'.$lang['Delete'].'</a>',
					'TOPIC' => $lang['Topic'],
					'POST' => $lang['Post'],
				));

				$forum = 0;
				foreach($forum_row as $forumarray){
					if($forumarray['cat_id'] == $catarray['cat_id']){
						$tpl->newBlock('forum_row');
						$tpl->assign(array(
							'FORUM_NAME' => decoding($forumarray['forum_name']),
							'FORUM_DESC' => decoding($forumarray['forum_description']),
							'FORUM_TOPICS' => $forumarray['forum_topics'],
							'FORUM_POSTS' => $forumarray['forum_posts'],
							'EDIT' => '<a href="adm_forum.php?mode=editforum&amp;fid='.$forumarray['forum_id'].'">'.$lang['Edit'].'</a>',
							'DELETE' => '<a href="adm_forum.php?mode=removeforum&amp;fid='.$forumarray['forum_id'].'">'.$lang['Delete'].'</a>',
						));
						$forum++;
						if(count($subforum_id[$forumarray['forum_id']]) > 0){
							foreach($subforum_id[$forumarray['forum_id']] as $var){
								$subforumarray = $subforum_row[$var];
								$tpl->newBlock('subforum_row');
								$tpl->assign(array(
									'FORUM_NAME' => decoding($subforumarray['forum_name']),
									'FORUM_DESC' => decoding($subforumarray['forum_description']),
									'FORUM_TOPICS' => $subforumarray['forum_topics'],
									'FORUM_POSTS' => $subforumarray['forum_posts'],
									'EDIT' => '<a href="adm_forum.php?mode=editforum&amp;fid='.$subforumarray['forum_id'].'">'.$lang['Edit'].'</a>',
									'DELETE' => '<a href="adm_forum.php?mode=removeforum&amp;fid='.$subforumarray['forum_id'].'">'.$lang['Delete'].'</a>',
								));
							}
						}
					}
				}
				if($forum == 0){
					$tpl->newBlock('noforum');
					$tpl->assign(array(
						'NO_FORUM' => $lang['No_forum']
					));
				}
			}
		}
	// [AF-17] END <<<<

	$tpl->gotoBlock('_ROOT');
	$tpl->assign(array(
		'L_PAGE_TITLE' => $lang['Forum_page_title'],
		'L_PAGE_EXPLAIN' => $lang['Forum_page_explain'],
		'L_CAT_NAME' => $lang['Name'],
		'L_CAT_DESC' => $lang['Description'],
		'L_CAT_ORDER' => $lang['Order'],
		'L_CAT_CREATE' => $lang['Category_create'],
		'L_CAT_BANNER' => $lang['Category_banner'],
		'L_FORUM_AUTH_TITLE'=> '<a href="adm_forum.php?mode=advauth">'.$lang['Forum_auth_title'].'</a>',
		'L_FORUM_AUTH_EXPLAIN'=> $lang['Forum_auth_explain'],
		'L_CAT_ADD_TITLE' => $lang['Forum_cat_add_title'],
		'L_FORUM_CAT_LIST' => $lang['Forum_and_cat_list'],
		'L_ADMIN_PANEL' => $lang['Administrator_panel'],
		'L_SUBMIT' => $lang['Submit'],
		'A_ACTION' => 'adm_forum.php?mode=addcat',
	));
}

$tpl->printToScreen();
require($path.'includes/page_footer.php');
?>