<?
define('IN_SITE', true);
define('IN_FORUM', true);
$path = './';
require($path.'includes/page_header.php');

$tpl = new TemplatePower($path.$style_tpl."forum_body.tpl");
$tpl->prepare();


// ********************************************************************************
// [FU-01] SQLcache: Getting Category data
// ********************************************************************************
	if(file_exists($path.'sqlcache/cat_data.php')){ 
		$cat_row = $cache->load_cat_cache();
	}else{
		$query = $db->query("SELECT * FROM ".CAT_TABLE." ORDER BY cat_order, cat_id ASC", 'UNBUFFERED');
		while ($result = $db->fetch_array($query)){
			$cache_cat_data[] = $cat_row[] = $result;
		}
		$cache->make_cat_cache($cache_cat_data);
		$db->free_result($query);
	}
// [FU-01] END <<<<

// ********************************************************************************
// [FU-02] Getting Forum view mode
// ********************************************************************************
	$forum_mode = ($userdata['userlevel'] == 200) ? $info['forum_mode'] : $userdata['forum_mode'];
	if($forum_mode == 1){
		$query = $db->query("SELECT f.forum_on, f.forum_last_post, f.forum_last_post, f.forum_access, f.forum_status, f.forum_id, f.cat_id, f.forum_name, f.forum_description, f.forum_topics, f.forum_icon, f.forum_posts, f.forum_topic_auth, f.forum_reply_auth, f.forum_view_auth, f.forum_group, f.forum_group_hide, f.forum_group_view, f.forum_password, t.topic_id, t.topic_subject, t.topic_last_post_time, u.username, u.id FROM (( " . FORUM_TABLE . " f LEFT JOIN " . TOPIC_TABLE . " t ON t.topic_id = f.forum_last_post) LEFT JOIN " . USERS_TABLE . " u ON u.id = t.topic_last_post_user) ORDER BY f.forum_order, f.forum_id ASC", 'UNBUFFERED');
		while($result = $db->fetch_array($query)){
			if($result['forum_on'] == 0) $forum_row[] = $result;
		}
		$db->free_result($query);
	}
// [FU-02] END <<<<

// ********************************************************************************
// [FU-03] Getting Category and Forum list
// ********************************************************************************
	if(count($cat_row) == 0){
		$tpl->newBlock('nocategary');
		$tpl->assign(array(
			'NO_CAT' => $lang['No_Cat']
		));
	}else{
		foreach($cat_row as $catarray){
			$tpl->newBlock('cat_row');
			$tpl->assign(array(
				'CAT_NAME' => '<a href="viewcat.php?cid='.$catarray['cat_id'].'">'.decoding($catarray['cat_name']).'</a>',
			));

			if($forum_mode == 1){
				$forum = 0;
				if(count($forum_row) > 0){
					foreach($forum_row as $forumarray){
						if($forumarray['cat_id'] == $catarray['cat_id']){
							if($forumarray['forum_group'] == 0 || ($forumarray['forum_group'] > 0 && ($forumarray['forum_group_hide'] == 0 || in_array($forumarray['forum_group'], explode(",", $userdata['group_id'])))) || $userdata['userlevel'] == 1){
								$topic_subject = $forumarray['topic_subject'];
								if(strlen($topic_subject) > 29) $topic_subject = substr($topic_subject, 0, 26).'...';
								$post_link = '<a href="viewtopic.php?tid='.$forumarray['topic_id'].'"><img src="'.$pointer.'"></a>';
								$last_post_data = ($forumarray['topic_last_post_time'] == 0) ? $lang['No_post'] : gmdate('Y/m/d H:i', $forumarray['topic_last_post_time']+gmtgen()).'<br /><a href="viewprofile.php?uid='.$forumarray['id'].'">'.$forumarray['username'].'</a>';
								$last_post = ($forumarray['forum_last_post'] > 0) ? $post_link.'<a href="viewtopic.php?tid='.$forumarray['forum_last_post'].'" title="' . decoding($forumarray['topic_subject']) . '">'.decoding($topic_subject).'</a>' : '';

								if($forumarray['forum_status'] == 1){
									$status_icon = '<img src="'.$status_close.'">';
								}else{
									if($userdata['userlevel'] < 100){
										$status_icon = '<img src="'.$status_all_auth.'">';
									}else{
										if(intval($userdata['access']) < $forumarray['forum_access']){
											$status_icon = '<img src="'.$status_no_auth.'">';
										}elseif(auth_checker($forumarray['forum_view_auth']) == 1){
											$status_icon = '<img src="'.$status_no_auth.'">';
										}elseif(auth_checker($forumarray['forum_view_auth']) == 0){
											if(auth_checker($forumarray['forum_topic_auth']) == 1 || auth_checker($forumarray['forum_reply_auth']) == 1){
												$status_icon = '<img src="'.$status_all_auth.'">';
											}else $status_icon = '<img src="'.$status_half_auth.'">';
										}else $status_icon = '<img src="'.$status_no_auth.'">';
									}
								}
								$forum_name = '<a href="viewindex.php?fid='.$forumarray['forum_id'].'">'.decoding($forumarray['forum_name']).'</a>';
								if($forumarray['forum_group'] > 0) $forum_name .= '&nbsp;<img src="'.$icon_group.'" title="'.$lang['Group_forum'].'">';
								if(!empty($forumarray['forum_password'])) $forum_name .= '&nbsp;<img src="'.$icon_password.'" title="'.$lang['Forum_password'].'">';

								$tpl->newBlock('forum_row');
								$tpl->assign(array(
									'FORUM_STATUS' => $status_icon,
									'FORUM_GOFORUM' => '<a href="viewforum.php?fid='.$forumarray['forum_id'].'"><img src="'.$arrow_icon.'"></a>',
									'FORUM_NAME' => $forum_name,
									'FORUM_DESC' => decoding($forumarray['forum_description']),
									'FORUM_TOPICS' => $forumarray['forum_topics'],
									'FORUM_POSTS' => $forumarray['forum_posts'],
									'FORUM_ICON' => (!empty($forumarray['forum_icon'])) ? '<a href="viewindex.php?fid='.$forumarray['forum_id'].'"><img src="./images/icons/'.$forumarray['forum_icon'].'"></a>' : '',
									'LAST_POST' => $last_post,
									'LAST_POST_DATA' => $last_post_data,
									'FORUM_ACCESS' => (intval($forumarray['forum_access']) > 0) ? sprintf($lang['Access_needed'], $forumarray['forum_access']) : '',
								));
							}
						}
					}
				}else{
					$tpl->newBlock('noforum');
					$tpl->assign(array(
						'NO_FORUM' => $lang['No_forum']
					));
				}
			}else{
				$tpl->newBlock('mode_cat_row');
				$tpl->assign(array(
					'CAT_DESC' => decoding($catarray['cat_description']),
					'CAT_BANNER' => (!empty($catarray['cat_banner'])) ? '<a href="viewcat.php?cid='.$catarray['cat_id'].'"><img src="'.$catarray['cat_banner'].'"></a>' : '<a href="viewcat.php?cid='.$catarray['cat_id'].'">'.$lang['Enter_cat'].'</a>',
				));
			}
		}
	}
	$tpl->gotoBlock('_ROOT');
// [FU-03] END <<<<

$tpl->assign(array(
	'L_WHOISONLINE' => $lang['Whoisonline'],
	'L_FORUM' => $lang['Forum'],
	'L_POST' => $lang['Post'],
	'L_TOPIC' => $lang['Topic'],
	'L_LASTPOST' => $lang['Last_post'],
	'L_DESCRIPTION' => $lang['Description'],
	'L_FORUM_TITLE' => $lang['Forum_index'],
	'USERLIST' => (!empty($userlist)) ? $userlist : $lang['No_user_online'],
	'MAX_ONLINE' => sprintf($lang['Max_online'], $info['max_online'], gmdate('Y/m/d H:i', $info['max_online_time']+gmtgen())),
	'ONLINE' => sprintf($lang['User_online'], ($login_user+$guest_count['total'])),
	'LOGIN_TIME' => ($userdata['login']) ? sprintf($lang['Login_time'], gmdate('Y/m/d H:i', $userdata['session']+gmtgen())) : '',
	'NOW_TIME' => sprintf($lang['Now_time'], gmdate('Y/m/d H:i', time()+gmtgen()))
));

$tpl->printToScreen();
require($path.'includes/page_footer.php');
?>