<?
define('IN_SITE', true);
$path = './';
require($path.'includes/page_header.php');
require($path.'includes/bbcode.php');
require($path.'includes/smile.php');
$g = intval($HTTP_GET_VARS['g']);
$start = intval($HTTP_GET_VARS['start']);

$tpl = new TemplatePower($path.$style_tpl."group_list_body.tpl");
$tpl->prepare();

$query = $db->query("SELECT COUNT(*) AS result FROM " . GROUP_TABLE);
$total = $db->fetch_array($query);
$db->free_result($query);
$pst_data = get_page_system_template($path.$style_tpl."common.pst");

// ********************************************************************************
// [GL-01] Getting Group List
// ********************************************************************************
$query = $db->query("SELECT g.*, u.id, u.username FROM (" . GROUP_TABLE . " g LEFT JOIN " . USERS_TABLE . " u ON g.group_leader = u.id) ORDER BY g.group_id ASC LIMIT $start, ".$info['topic_pre_page']);
while($result = $db->fetch_array($query)){
	$group_banned = 0;
	if(!empty($result['group_ban'])){
		if(in_array($userdata['id'], explode(",", $result['group_ban']))) $group_banned = 1;
	}
	if($result['group_leader'] == $userdata['id']){
		$group_action = $lang['Group_leader'];
	}elseif($group_banned == 1){
		$group_action = $lang['Group_banned'];
	}elseif($result['group_allow_join'] == 0){
		$group_action = $lang['Group_disallow_join'];
	}elseif($userdata['group_id'] == $result['group_id'] && $group_banned != 1 && $result['group_leader'] != $userdata['id']){
		$group_action = '<a href="group.php?mode=unjoin&amp;g='.$result['group_id'].'">'.$lang['Group_unjoin'].'</a>';
	}elseif($result['group_allow_join'] == 1){
		$group_action = '<a href="group.php?mode=join&amp;g='.$result['group_id'].'">'.$lang['Group_join'].'</a>';
	}else $group_action = '';

	$tpl->newBlock('group_row');
	$tpl->assign(array(
		'GROUP_NAME' => '<a href="group.php?g='.$result['group_id'].'">'.decoding($result['group_name']).'</a>',
		'GROUP_LEADER' => '<a href="viewprofile.php?uid='.$result['id'].'">'.decoding($result['username']).'</a>',
		'GROUP_POST' => $result['group_post'],
		'GROUP_MEMBER' => $result['group_member'],
		'GROUP_ACTION' => $group_action,
	));
	$GROUP_EXIST = TRUE;
}
if(!$GROUP_EXIST){
	$tpl->newBlock('nogroup');
	$tpl->assign(array(
		'NO_GROUP' => $lang['No_group'],
	));
}
$db->free_result($query);
$tpl->gotoBlock('_ROOT');
// [GL-01] END <<<<

// ********************************************************************************
// [GL-02] Getting User Group Data
// ********************************************************************************
if(!empty($userdata['group_id'])){
	$check_group = explode(",", $userdata['group_id']);
	$query = $db->query("SELECT * FROM " . GROUP_TABLE . " WHERE group_id IN(".$userdata['group_id'].")");
	while($result = $db->fetch_array($query)){
		$tpl->newBlock('your_group_row');
		$tpl->assign(array(
			'GROUP_NAME' => '<a href="group.php?g='.$result['group_id'].'">'.decoding($result['group_name']).'</a>',
			'GROUP_DESC' => decoding($result['group_desc']),
			'GROUP_ICON' => (!empty($result['group_icon'])) ? '<img src="'.$result['group_icon'].'">' : $lang['Group_noicon'],
			'GROUP_LEADER' => '<a href="viewprofile.php?uid='.$result['id'].'">'.decoding($result['username']).'</a>',
			'GROUP_POST' => $result['group_post'],
			'GROUP_MEMBER' => $result['group_member'],
			'L_GROUP_MANAGEMENT' => $lang['Group_management'],
			'L_GROUP_NAME' => $lang['Group_name'],
			'L_GROUP_DESC' => $lang['Group_desc'],
			'L_GROUP_ICON' => $lang['Group_icon'],
			'L_GROUP_POST' => $lang['Group_post'],
			'L_GROUP_MEMBER' => $lang['Group_member'],
		));
		if($userdata['id'] == $result['group_leader']){
			$tpl->newBlock('group_leader_row');
			$tpl->assign(array(
				'GROUP_MEMBER_MANAGEMENT' => '<a href="group_management.php?mode=member&amp;g='.$result['group_id'].'">'.$lang['Group_member_management'].'</a>',
				'GROUP_DELETE' => '<a href="group_management.php?mode=terminative&amp;g='.$result['group_id'].'">'.$lang['Group_terminative_now'].'</a>',
				'GROUP_CONFIG' => '<a href="group_management.php?mode=config&amp;g='.$result['group_id'].'">'.$lang['Group_config'].'</a>',
			));
			$GROUP_LEADER = TRUE;
		}
		$sql_update[] = $result['group_id'];
	}
	if(count($check_group) != count($sql_update) && count($sql_update) > 0) $query = $db->query("UPDATE " . USERS_TABLE . " SET group_id = '".implode(",", $sql_update)."' WHERE id = ".$userdata['id']);
	$tpl->gotoBlock('_ROOT');
}
// [GL-02] END <<<<

if($info['group_add'] == 1 && !$GROUP_LEADER && $userdata['userlevel'] < 109 && empty($userdata['group_id'])){
	$tpl->newBlock('allow_group_add');
	$tpl->assign(array(
		'A_ACTION' => 'group.php?mode=add',
		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],
		'L_GROUP_ADD' => $lang['Group_add'],
		'L_GROUP_NAME' => $lang['Group_name'],
		'L_GROUP_DESC' => $lang['Group_desc'],
		'L_GROUP_ICON' => $lang['Group_icon'],
		'L_GROUP_ALLOW_JOIN' => $lang['Group_allow_pub_join'],
		'L_GROUP_ALLOW_POST' => $lang['Group_allow_post'],
		'L_GROUP_ALLOW_VIEW_GUESTBOOK' => $lang['Group_allow_view_guestbook'],
		'L_SUBMIT' => $lang['Submit'],
	));
	$tpl->gotoBlock('_ROOT');
}

$tpl->assign(array(
	'L_GROUP' => $lang['Group'],
	'L_GROUP_NAME' => $lang['Group_name'],
	'L_GROUP_LEADER' => $lang['Group_leader'],
	'L_GROUP_POST' => $lang['Group_post'],
	'L_GROUP_MEMBER' => $lang['Group_member'],
	'L_GROUP_LIST' => $lang['Group_list'],
	'NAV' => '<a href="index.php">'.$lang['Index'].'</a> &raquo; <a href="group_list.php">'.$lang['Group_list'].'</a>',
	'PAGE_BOX' => page_box('group_list.php', $total['result'], $info['topic_pre_page'], $start, 1, $pst_data['page_box']),
));
$tpl->printToScreen();
require($path.'includes/page_footer.php');
?>