<?
// ********************************************************************************
// [BC-01] BBcode<Code>: Encoding
// ********************************************************************************
	function encode($code, $psd_code){
		global $lang;
		$code = preg_replace("#\[#is", "&open&", $code);
		$code = preg_replace("#\]#is", "&close&", $code);

		$code = str_replace("{TITLE}", addslashes($lang['Code']), str_replace("{CONTENT}", $code, $psd_code));

		return $code;
	}
// [BC-01] END <<<<

// ********************************************************************************
// [BC-02] BBcode<Code>: Decoding
// ********************************************************************************
	function decode($code){
		$code = preg_replace("#(&open&)#is", "[", $code);
		$code = preg_replace("#(&close&)#is", "]", $code);
		$code = preg_replace("#\[url\]#is", "", $code);
		$code = preg_replace("#\[/url\]#is", "", $code);

		return $code;
	}
// [BC-02] END <<<<

// ********************************************************************************
// [BC-03] BBcode<Image>: Convent
// ********************************************************************************
	function img($url){
		global $info;
		return "<img src=\"".(substr(strtolower($url), 0, 4) == 'www.' ? "http://$url" : $url)."\" onLoad=\"javascript:if(this.width > ".$info['images_width'].")this.width = ".$info['images_width']."\">";
	}
// [BC-03] END <<<<

// ********************************************************************************
// [BC-04] BBcode<Media>: Convent
// ********************************************************************************
	function media($url, $psd_code){
		$url = substr(strtolower($url), 0, 4) == 'www.' ? "http://$url" : $url;
		$media = str_replace("{URL}", $url, $psd_code);

		return $media;
	}
// [BC-04] END <<<<

// ********************************************************************************
// [BC-05] BBcode<RealPlayer>: Convent
// ********************************************************************************
	function realplayer($url, $psd_code){
		$url = substr(strtolower($url), 0, 4) == 'www.' ? "http://$url" : $url;
		$media = str_replace("{URL}", $url, $psd_code);

		return $media;
	}
// [BC-05] END <<<<

// ********************************************************************************
// [BC-06] BBcode<Hide>: Convent
// ********************************************************************************
	function hide($content, $show, $psd_code, $psd_code_false){
		global $lang;
		if($show == 0){
			return str_replace("{TITLE}", addslashes($lang['Hidden']), str_replace("{CONTENT}", addslashes($lang['Hidden_explain']), $psd_code_false));
		}elseif($show == 1) return str_replace("{TITLE}", addslashes($lang['Hidden']), str_replace("{CONTENT}", $content, $psd_code));
	}
// [BC-06] END <<<<

// ********************************************************************************
// [BC-07] BBcode<Hide Access>: Convent
// ********************************************************************************
	function hide_access($access, $content, $psd_code, $psd_code_false){
		global $userdata, $is_mod, $lang;

		if($access <= 0) return $content;
		if($is_mod || $userdata['access'] >= $access){
			return str_replace("{TITLE}", sprintf(addslashes($lang['Hide_access']), $access), str_replace("{CONTENT}", $content, $psd_code));
		}else return str_replace("{TITLE}", sprintf(addslashes($lang['Hide_access']), $access), str_replace("{CONTENT}", sprintf(addslashes($lang['Hide_content']), $access), $psd_code_false));

		return $code;
	}
// [BC-07] END <<<<

// ********************************************************************************
// [BC-08] BBcode<Hide Level>: Convent
// ********************************************************************************
	function hide_level($level, $content, $psd_code, $psd_code_false){
		global $lang, $userdata, $is_mod;

		switch($userdata['userlevel']){
			case '1';$userlevel = 'A';break;
			case '10';$userlevel = 'E';break;
			case '11';$userlevel = 'M';break;
			case '100';$userlevel = 'V';break;
			case '101';$userlevel = 'P';break;
			case '102';$userlevel = 'F';break;
			case '109';$userlevel = 'U';break;
			case '200';$userlevel = 'G';break;
		}

		$level_key_array = array('A', 'E', 'M', 'V', 'P', 'F', 'U', 'G');
		if(in_array($level, $level_key_array)){
			switch($level){
				case 'A';$userlevel_explain = addslashes($lang['Level_admin']);break;
				case 'E';$userlevel_explain = addslashes($lang['Level_editor']);break;
				case 'M';$userlevel_explain = addslashes($lang['Level_mod']);break;
				case 'V';$userlevel_explain = addslashes($lang['Level_vip']);break;
				case 'P';$userlevel_explain = addslashes($lang['Level_payment']);break;
				case 'F';$userlevel_explain = addslashes($lang['Level_free']);break;
				case 'U';$userlevel_explain = addslashes($lang['Level_unregister']);break;
				case 'G';$userlevel_explain = addslashes($lang['Level_guest']);break;
			}
			if($level == $userlevel){
				return str_replace("{TITLE}", addslashes($lang['Hidden_level']), str_replace("{CONTENT}", $content, $psd_code));
			}else return str_replace("{TITLE}", addslashes($lang['Hidden_level']), str_replace("{CONTENT}", sprintf(addslashes($lang['Hidden_level_explain']), $userlevel_explain), $psd_code_false));
		}elseif(ereg(",", $level)){
			$level_array = explode(",", $level);
			foreach($level_array as $var){
				switch($var){
					case 'A';$userlevel_explain = addslashes($lang['Level_admin']);break;
					case 'E';$userlevel_explain = addslashes($lang['Level_editor']);break;
					case 'M';$userlevel_explain = addslashes($lang['Level_mod']);break;
					case 'V';$userlevel_explain = addslashes($lang['Level_vip']);break;
					case 'P';$userlevel_explain = addslashes($lang['Level_payment']);break;
					case 'F';$userlevel_explain = addslashes($lang['Level_free']);break;
					case 'U';$userlevel_explain = addslashes($lang['Level_unregister']);break;
					case 'G';$userlevel_explain = addslashes($lang['Level_guest']);break;
				}
				$hide_level_explain .= (!empty($hide_level_explain)) ? ",".$userlevel_explain : $userlevel_explain;
			}

			if(in_array($userlevel, $level_array)){
				return str_replace("{TITLE}", addslashes($lang['Hidden_level']), str_replace("{CONTENT}", $content, $psd_code));
			}else return str_replace("{TITLE}", addslashes($lang['Hidden_level']), str_replace("{CONTENT}", sprintf(addslashes($lang['Hidden_level_explain']), $userlevel_explain), $psd_code_false));
		}else return $content;
	}
// [BC-08] END <<<<

// ********************************************************************************
// [BC-09] BBcode<Url>: Convent
// ********************************************************************************
	function url($url){
		return "<a href=\"".(substr(strtolower($url), 0, 4) == 'www.' ? "http://$url" : $url).'" target="_blank">'.$url.'</a>';
	}
// [BC-09] END <<<<

// ********************************************************************************
// [BC-10] Basic Covent
// ********************************************************************************
	function bbcode($text, $show = 0){
		global $info, $lang, $path, $style_tpl;
		$pst_data = get_page_system_template($path.$style_tpl."bbcode.pst", 'BBCODE');

		$patterns = array(
			"#\s*\[code\](.+?)\[\/code\]\s*#ies",
			"#\s*\[acode\](.+?)\[\/acode\]\s*#ies",
			"#\[center\](.*)\[/center\]#Uis",
			"#\[b\](.*)\[/b\]#Uis",
			"#\[u\](.*)\[/u\]#Uis",
			"#\[i\](.*)\[/i\]#Uis",
			"#\[s\](.*)\[/s\]#Uis",
			"#\[color=(\#[0-9A-F]{6}|[a-z\-]+)\](.*)\[/color\]#Uis",
			"#\[cdiv=(\#[0-9A-F]{6}|[a-z\-]+)\](.*)\[/cdiv\]#Uis",
			"#\[size=([0-9]*?)\](.*)\[/size\]#Uis",
			"#\[img\]\s*(www.|https?://|ftp://){1}([^\[\"']+?)\s*\[/img\]#ies",
			"#\[img\]([\w]+?://([^ \?&=\#\"\n\r\t<]*))\[/img\]#Uis",
			"#\[img\]www.([^\[\"']+?)\](.+?)\[/img\]#is",
			"#\[img=([^ \"\n\r\t<]*)\]([^ \?&=\#\"\n\r\t<]*)\[/img\]#Uis",
			"#\[url\]\s*(www.|https?:\/\/|ftp:\/\/|gopher:\/\/|news:\/\/|telnet:\/\/|rtsp:\/\/|mms:\/\/){1}([^\[\"']+?)\s*\[\/url\]#ies",
			"#\[url=www.([^\[\"']+?)\](.+?)\[\/url\]#is",
			"#\[url=(https?|ftp){1}://([^\[\"']+?)\](.+?)\[\/url\]#is",
			"#\[mp\]\s*(www.|https?://|ftp://){1}([^\[\"']+?)\[/mp\]#ies",
			"#\[real\]\s*(www.|https?://|ftp://){1}([^\[\"']+?)\s*\[/real\]#ies",
			"#\[hide\](.+?)\[/hide\]#ies",
			"#\[hide=(.+?)\](.+?)\[\/hide\]#ies",
			"#\[hide:(.+?)\](.+?)\[\/hide\]#ies",
		);
		$replacements = array(
			"encode('\\1', '".$pst_data['code']."')",
			"acode('\\1')",
			"<div align=\"center\">\\1</div>",
			"<b>\\1</b>",
			"<u>\\1</u>",
			"<i>\\1</i>",
			"<s>\\1</s>",
			"<font color=\"\\1\">\\2</font>",
			"<div style=\"background-color: \\1;padding: 4px;\">\\2</div>",
			"<font style=\"font-size: \\1px\">\\2</font>",
			"img('\\1\\2')",
			"<img src=\"\\1\" onLoad=\"javascript:if(this.width > ".$info['images_width'].")this.width = ".$info['images_width']."\">",
			"<img src=\"http://www.\\1\" onLoad=\"javascript:if(this.width > ".$info['images_width'].")this.width = ".$info['images_width']."\">",
			"<img src=\"\\2\" title=\"\\1\" onLoad=\"javascript:if(this.width > ".$info['images_width'].")this.width = ".$info['images_width']."\">",
			"url('\\1\\2')",
			"<a href=\"http://www.\\1\" target=\"_blank\">\\2</a>",
			"<a href=\"\\1://\\2\" target=\"_blank\">\\3</a>",
			"media('\\1\\2', '".$pst_data['embed']."')",
			"realplayer('\\1\\2', '".$pst_data['realp']."')",
			"hide('\\1', '$show', '".$pst_data['hide']."', '".$pst_data['hide_false']."')",
			"hide_access('\\1', '\\2', '".$pst_data['hide_ac']."', '".$pst_data['hide_ac_false']."')",
			"hide_level('\\1', '\\2', '".$pst_data['hide_lv']."', '".$pst_data['hide_lv_false']."')",
		);
		$text = preg_replace($patterns, $replacements, $text);

		$quote_table = str_replace("{TITLE}", addslashes($lang['Quote']), str_replace("{CONTENT}", "\\1", $pst_data['quote']));
		while(preg_match("#\s*\[quote\](.+?)\[/quote\]\s*#is", $text)){
			$patternsq = "#\s*\[quote\](.+?)\[/quote\]\s*#is";
			$text = preg_replace($patternsq, $quote_table, $text);
		}

		$user_quote_table = str_replace("{TITLE}", addslashes($lang['Quote']), str_replace("{NAME}", "\\1", str_replace("{CONTENT}", "\\2", $pst_data['user_quote'])));
		while(preg_match("#\[quote=\\\&quot;([^\[\"']+?)\\\&quot;\](.+?)\[/quote\]#is", $text)){
			$patternsq = "#\[quote=\\\&quot;([^\[\"']+?)\\\&quot;\](.+?)\[/quote\]#is";
			$text = preg_replace($patternsq, $user_quote_table, $text);
		}

		while(preg_match("#\s*\[block\](.+?)\[/block\]\s*#is", $text)){
			$patternsq = "#\s*\[block\](.+?)\[/block\]\s*#is";
			$replacementsq = "<blockquote>\\1</blockquote>";
			$text = preg_replace($patternsq, $replacementsq, $text);
		}
		$text = preg_replace($patterns, $replacements, $text);

		$text = preg_replace("/(?<=[^\]a-z0-9-=\"'\\/])((https?|ftp|gopher|news|telnet|mms|rtsp):\/\/|www\.)([a-z0-9\/\-_+=.~!%@?#%&;:$\\()|]+)/ies", "url('\\1\\3')", $text);

		return decode($text);
	}
// [BC-10] END <<<<

// ********************************************************************************
// [BC-11] Mini BBcode Covent
// ********************************************************************************
	function minibbcode($text){
		global $info, $lang;

		$pst_data = get_page_system_template($path.$style_tpl."bbcode.pst", 'BBCODE');
		$patterns = array(
			"#\s*\[code\](.+?)\[\/code\]\s*#ies",
			"#\[center\](.*)\[/center\]#Uis",
			"#\[block\](.*)\[/block\]#Uis",
			"#\[b\](.*)\[/b\]#Uis",
			"#\[u\](.*)\[/u\]#Uis",
			"#\[i\](.*)\[/i\]#Uis",
			"#\[s\](.*)\[/s\]#Uis",
			"#\[color=(\#[0-9A-F]{6}|[a-z\-]+)\](.*)\[/color\]#Uis",
			"#\[cdiv=(\#[0-9A-F]{6}|[a-z\-]+)\](.*)\[/cdiv\]#Uis",
			"#\[size=([0-9]*?)\](.*)\[/size\]#Uis",
			"#\[img\]\s*(www.|https?://|ftp://){1}([^\[\"']+?)\s*\[/img\]#ies",
			"#\[img\]([\w]+?://([^ \?&=\#\"\n\r\t<]*))\[/img\]#Uis",
			"#\[img\]www.([^\[\"']+?)\](.+?)\[/img\]#is",
			"#\[img=([^ \"\n\r\t<]*)\]([^ \?&=\#\"\n\r\t<]*)\[/img\]#Uis",
			"#\[url\]\s*(www.|https?:\/\/|ftp:\/\/|gopher:\/\/|news:\/\/|telnet:\/\/|rtsp:\/\/|mms:\/\/){1}([^\[\"']+?)\s*\[\/url\]#ies",
			"#\[url=www.([^\[\"']+?)\](.+?)\[\/url\]#is",
			"#\[url=(https?|ftp){1}://([^\[\"']+?)\](.+?)\[\/url\]#is",
		);
		$replacements = array(
			"encode('\\1', '".$pst_data['code']."')",
			"<div align=\"center\">\\1</div>",
			"<blockquote>\\1</blockquote>",
			"<b>\\1</b>",
			"<u>\\1</u>",
			"<i>\\1</i>",
			"<s>\\1</s>",
			"<font color=\"\\1\">\\2</font>",
			"<div style=\"background-color: \\1;padding: 4px;\">\\2</div>",
			"<font style=\"font-size: \\1px\">\\2</font>",
			"img('\\1\\2')",
			"<img src=\"\\1\" onLoad=\"javascript:if(this.width > ".$info['images_width'].")this.width = ".$info['images_width']."\">",
			"<img src=\"http://www.\\1\" onLoad=\"javascript:if(this.width > ".$info['images_width'].")this.width = ".$info['images_width']."\">",
			"<img src=\"\\2\" title=\"\\1\" onLoad=\"javascript:if(this.width > ".$info['images_width'].")this.width = ".$info['images_width']."\">",
			"url('\\1\\2')",
			"<a href=\"http://www.\\1\" target=\"_blank\">\\2</a>",
			"<a href=\"\\1://\\2\" target=\"_blank\">\\3</a>",
		);
		$text = preg_replace($patterns, $replacements, $text);

		$quote_table = str_replace("{TITLE}", addslashes($lang['Quote']), str_replace("{CONTENT}", "\\1", $pst_data['quote']));
		while(preg_match("#\s*\[quote\](.+?)\[/quote\]\s*#is", $text)){
			$patternsq = "#\s*\[quote\](.+?)\[/quote\]\s*#is";
			$text = preg_replace($patternsq, $quote_table, $text);
		}

		$user_quote_table = str_replace("{TITLE}", addslashes($lang['Quote']), str_replace("{NAME}", "\\1", str_replace("{CONTENT}", "\\2", $pst_data['user_quote'])));
		while(preg_match("#\[quote=\\\&quot;([^\[\"']+?)\\\&quot;\](.+?)\[/quote\]#is", $text)){
			$patternsq = "#\[quote=\\\&quot;([^\[\"']+?)\\\&quot;\](.+?)\[/quote\]#is";
			$text = preg_replace($patternsq, $user_quote_table, $text);
		}

		while(preg_match("#\s*\[block\](.+?)\[/block\]\s*#is", $text)){
			$patternsq = "#\s*\[block\](.+?)\[/block\]\s*#is";
			$replacementsq = "<blockquote>\\1</blockquote>";
			$text = preg_replace($patternsq, $replacementsq, $text);
		}
		$text = preg_replace("/(?<=[^\]a-z0-9-=\"'\\/])((https?|ftp|gopher|news|telnet|mms|rtsp):\/\/|www\.)([a-z0-9\/\-_+=.~!%@?#%&;:$\\()|]+)/ies", "url('\\1\\3')", $text);

		return $text;
	}
// [BC-11] END <<<<
?>