<?
// ********************************************************************************
// [FC-01] Function: Page generation time
// ********************************************************************************
	function phpTime(){
		$tTime = explode(' ', microtime());
		return round($tTime[1] + $tTime[0], 4);
	}
// [FC-01] END <<<<

// ********************************************************************************
// [FC-02] Function: Return Page generation time result
// ********************************************************************************
	function debuginfo(){
		global $db, $start_gen, $gzipcompress;

		$end_gen = phpTime();
		$totaltime = number_format(($end_gen - $start_gen), 4);
		$status = 'Processed in '.$totaltime.' second(s), '.$db->querynum.' queries'.($gzipcompress ? ', Gzip enabled' : NULL);

		return $status;
	}
// [FC-02] END <<<<

// ********************************************************************************
// [FC-03] Function: TimeZone Selection
// ********************************************************************************
	function tzselect($config){
		global $lang;

		$timezone = '<select name="GMT">';
		foreach($lang['tz'] as $keys => $var){
			$s = ($config == $keys) ? ' selected="selected"' : '';
			$timezone .= '<option value="'.$keys.'"'.$s.'>'.$var."</option>\n";
		}
		$timezone .= '</select>';

		return $timezone;
	}
// [FC-03] END <<<<

// ********************************************************************************
// [FC-04] Function: GM-Time generation
// ********************************************************************************
	function gmtgen(){
		global $info;
		return $info['GMT']*3600;
	}
// [FC-04] END <<<<

// ********************************************************************************
// [FC-05] Function: Page Box
// ********************************************************************************
	function page_box($base_url, $num_items, $per_page, $start_item, $no_vars = 0, $pst_table){
		global $lang, $info;
		$url_vars = ($no_vars == 1) ? '?' : '&amp;';
		$total_start = ceil($start_item/$per_page);
		$total_pages = ceil($num_items/$per_page);
		$page_tag = (intval($info['total_page_tag']) >= 3) ? $info['total_page_tag'] : 3;
		$page_set = floor($info['total_page_tag']/2);

		$pagebox_pst = array();
		preg_match('#<!-- START HEADER -->(.*)<!-- END HEADER -->#Uis', $pst_table, $matches);
		$pagebox_pst['header'] = $matches[1];
		preg_match('#<!-- START ST_URL -->(.*)<!-- END ST_URL -->#Uis', $pst_table, $matches);
		$pagebox_pst['st_url'] = $matches[1];
		preg_match('#<!-- START PR_URL -->(.*)<!-- END PR_URL -->#Uis', $pst_table, $matches);
		$pagebox_pst['pr_url'] = $matches[1];
		preg_match('#<!-- START LOOP -->(.*)<!-- END LOOP -->#Uis', $pst_table, $matches);
		$pagebox_pst['loop'] = $matches[1];
		preg_match('#<!-- START NX_URL -->(.*)<!-- END NX_URL -->#Uis', $pst_table, $matches);
		$pagebox_pst['nx_url'] = $matches[1];
		preg_match('#<!-- START END_URL -->(.*)<!-- END END_URL -->#Uis', $pst_table, $matches);
		$pagebox_pst['end_url'] = $matches[1];
		preg_match('#<!-- START FOOTER -->(.*)<!-- END FOOTER -->#Uis', $pst_table, $matches);
		$pagebox_pst['footer'] = $matches[1];

		if($total_pages <= 1){
			$page_box = '';
		}else{
			$page_box = str_replace("{TOTAL_PAGE}", $total_pages, str_replace("{TOTAL_ST}", ($total_start+1), str_replace("{NUM_ITEM}", $num_items, $pagebox_pst['header'])));

			$frist_start = ($total_pages - $total_start >= $page_set || $total_pages - $total_start+$page_set > 0) ? $total_start : $total_start-$page_set;
			$end_start = $frist_start;
			$on_page = floor($start_item/$per_page)+1;
			$page_box .= ($total_start > 0) ? str_replace("{ST_URL}", $base_url.$url_vars.'start=0', $pagebox_pst['st_url']) : '';
			$page_box .= ($total_start > 0) ? str_replace("{PR_URL}", $base_url.$url_vars.'start='.(($frist_start-1)*$per_page), $pagebox_pst['pr_url']) : '';
			$j = $page_tag;
			for($i = 1; $i <= $j;$i++){
				$pages = ($total_start == 0) ? $i+$frist_start : $i+$frist_start-$page_set;
				if($total_pages - $pages >= 0 && $pages > 0){
					$starter = ($pages == 1) ? '' : $url_vars."start=".(($pages-1)*$per_page);
					$page = ($on_page == $pages) ? '<b>'.$pages.'</b>' : $pages;
					$page_box .= str_replace("{LOOP_BASIC_URL}",$base_url.$starter, str_replace("{PAGE}", $page, $pagebox_pst['loop']));
				}elseif($pages <= 0) $j++;
			}

			$page_box .= ($total_pages - $total_start > 1 || $on_page == 1) ? str_replace("{NX_URL}", $base_url.$url_vars.'start='.(($end_start+1)*$per_page), $pagebox_pst['nx_url']) : '';
			$page_box .= ($total_pages - $total_start > 1 || $on_page == 1) ? str_replace("{END_URL}", $base_url.$url_vars.'start='.(($total_pages-1)*$per_page), $pagebox_pst['end_url']) : '';
			$page_box .= $pagebox_pst['footer'];
		}
		return $page_box;
	}
// [FC-05] END <<<<

// ********************************************************************************
// [FC-06] Function: Topic Page Box
// ********************************************************************************
	function topic_page_box($base_url, $num_items, $per_page, $start_item, $no_vars = 0){
		global $lang, $arrow_icon;
		$total_pages = ceil($num_items/$per_page);
		$url_vars = ($no_vars == 1) ? '?' : '&amp;';

		if($total_pages <= 1){
			$page_box = '';
		}else{
			$page_box = '[&nbsp;<img src="'.$arrow_icon.'">';
			$last = ($total_pages > 5) ? $total_pages-5 : 0;
			for($i = 1; $i <= 5;$i++){
				$starter = ($i == 1) ? '' : $url_vars."start=".(($i-1)*$per_page);
				if($i <= $total_pages) $page_box .= '&nbsp;<a href="'.$base_url.$starter.'">'.$i.'</a>';
			}
			$page_box .= ($total_pages > 5) ? '&nbsp;...&nbsp;' : '&nbsp;';
			for($i = 1; $i <= 5;$i++){
				$pages = $last+$i;
				if($pages > 5 && $pages <= $total_pages) $page_box .= '<a href="'.$base_url.$url_vars.'start='.(($pages-1)*$per_page).'">'.$pages.'</a>&nbsp;';
			}
			$page_box .= ']';
		}
		return $page_box;
	}
// [FC-06] END <<<<

// ********************************************************************************
// [FC-07] Function: Poll Bar
// ********************************************************************************
	function poll_bar($total, $result, $pst_table){
		global $poll_bar_start, $poll_bar_end, $poll_bar;

		$percentage = @round(($result/$total)*100);
		$pst_table = str_replace("{PREC}", $percentage, $pst_table);
		$pst_table = str_replace("{RESULT}", $result, $pst_table);
		$pst_table = str_replace("{START}", $poll_bar_start, $pst_table);
		$pst_table = str_replace("{END}", $poll_bar_end, $pst_table);
		$pst_table = str_replace("{BAR}", $poll_bar, $pst_table);
		return $pst_table;
	}
// [FC-07] END <<<<

// ********************************************************************************
// [FC-08] Function: Return File Size
// ********************************************************************************
	function file_size($attachment){
		if($attachment < 1024){
			$attachment = $attachment.' byte';
		}elseif($attachment < 1048576 && $attachment > 1024){
			$attachment = number_format(($attachment / 1024), 2).' KB';
		}elseif($attachment < 1073741824 && $attachment > 1048576) $attachment = number_format(($attachment / 1048576), 2).' MB';

		return $attachment;
	}
// [FC-08] END <<<<

// ********************************************************************************
// [FC-09] Function: Bandwidth Bar
// ********************************************************************************
	function bandwidth_bar($bandwidth, $pst_table){
		global $info, $poll_bar_start, $poll_bar_end, $poll_bar;

		$percentage = @round(($bandwidth/$info['attachment_bandwidth'])*100);
		$pst_table = str_replace("{PREC}", $percentage, $pst_table);
		$pst_table = str_replace("{START}", $poll_bar_start, $pst_table);
		$pst_table = str_replace("{END}", $poll_bar_end, $pst_table);
		$pst_table = str_replace("{BAR}", $poll_bar, $pst_table);

		return $pst_table;
	}
// [FC-09] END <<<<

// ********************************************************************************
// [FC-10] Function: Extension
// ********************************************************************************
	function check_ext($file_type, $check_type){
		global $info;

		if($check_type == 'attach_img'){
			$file_type = strtolower($file_type);
			if(in_array($file_type, explode(",", strtolower($info['attachment_image'])))) return 1;
		}elseif($check_type == 'attach'){
			$file_type = strtolower($file_type);
			if(in_array($file_type, explode(",", strtolower($info['attachment_ext'])))) return 1;
		}elseif($check_type == 'avatar'){
			$file_type = strtolower($file_type);
			if(in_array($file_type, explode(",", 'bmp,gif,png,jpg,jpeg'))) return 1;
		}
		return 0;
	}
// [FC-10] END <<<<

// ********************************************************************************
// [FC-11] Function: Allow attachment upload extension type
// ********************************************************************************
	function allow_type(){
		global $lang, $info;
		$type = explode(",", $info['attachment_ext']);
		$str = sprintf($lang['Forum_Topic_allow_type'], implode(", ", $type));
		return $str;
	}
// [FC-11] END <<<<

// ********************************************************************************
// [FC-12] Function: Encoding and fix Multibyte-Character Processing
// ********************************************************************************
	function encoding($text, $br = 0){
		$text = addslashes($text);
		$text = htmlspecialchars($text);
		$text = ereg_replace("&amp;", "&", $text);
		$text = ($br == 1) ? str_replace(chr(13).chr(10), "<br>", $text) : $text;
		return $text;
	}
// [FC-12] END <<<<

// ********************************************************************************
// [FC-13] Function: Decoding and fix Multibyte-Character Processing
// ********************************************************************************
	function decoding($text, $editing = 0, $edit = 0){
		global $lang;
		if($editing == 1){
			$text = preg_replace("#\s*\[hide\](.+?)\[\/hide\]\s*#is", $lang['Quote_no_hide'], $text);
			$text = preg_replace("#\s*\[hide=(.+?)\](.+?)\[\/hide\]\s*#is", $lang['Quote_no_hide'], $text);
			$text = preg_replace("#\s*\[hide:(.+?)\](.+?)\[\/hide\]\s*#is", $lang['Quote_no_hide'], $text);
		}
		$text = stripslashes($text);
		$text = ($edit == 1) ? str_replace("<br>", chr(13).chr(10), $text) : $text;
		return $text;
	}
// [FC-13] END <<<<

// ********************************************************************************
// [FC-14] Function: Checking Authorization
// ********************************************************************************
	function auth_checker($auth){
		global $userdata;

		if($auth == 1){
			return 0;
		}elseif($auth == 2 && $userdata['userlevel'] <= 109){
			return 0;
		}elseif($auth == 3 && $userdata['userlevel'] <= 102){
			return 0;
		}elseif($auth == 4 && $userdata['userlevel'] <= 101){
			return 0;
		}elseif($auth == 5 && $userdata['userlevel'] <= 100){
			return 0;
		}elseif($auth == 6 && $userdata['userlevel'] <= 11){
			return 0;
		}elseif($auth == 7 && $userdata['userlevel'] <= 10){
			return 0;
		}elseif($auth == 8 && $userdata['userlevel'] == 1){
			return 0;
		}
		return 1;
	}
// [FC-14] END <<<<

// ********************************************************************************
// [FC-15] Function: Topic Style
// ********************************************************************************
	function topic_style($text, $bold, $color){
		if($bold) $text = '<b>'.$text.'</b>';
		if(!empty($color)) $text = '<font color="#'.$color.'">'.$text.'</font>';
		return $text;
	}
// [FC-15] END <<<<

// ********************************************************************************
// [FC-16] Function: Getting Client IP
// ********************************************************************************
	function get_ip(){
		if(empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
		    $ip = $_SERVER['REMOTE_ADDR'];
		}else{
		    $ip = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
		    $ip = $ip[0];
		}
		return $ip;
	}
// [FC-16] END <<<<

// ********************************************************************************
// [FC-17] Function: Attachment Upload
// ********************************************************************************
	function posting_attachment($attachment_file, $attach_hide, $attach_access, $posting_type, $tid, $fid, $attachment_desc = ''){
		global $db, $lang, $lang_db, $info;

		switch($posting_type){
			case 'reply';$ptype = sprintf($lang['Nav_reply'], $tid, $fid);break;
			case 'newtopic';$ptype = sprintf($lang['Nav_newtopic'], $tid, $fid);break;
			case 'edit';$ptype = sprintf($lang['Nav_editpost'], $tid, $fid);break;
		}
		$attach_hide = (isset($attach_hide)) ? 1 : 0;
		$attach_access = (isset($attach_access)) ? intval($attach_access) : 0;
		if($attach_access < 0) die_message($lang['System_error'], $lang_db->group(array($lang['Posting_error_attachment_access'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), $ptype)), '');
		if(filesize($attachment_file['tmp_name']) >= $info['attachment_size']){
			@unlink($attachment_file['tmp_name']);
			die_message($lang['Syste_error'], $lang_db->group(array($lang['Posting_error_attachment_size'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), $ptype)), '');
		}else{
			$file_name = time().'_'.basename($attachment_file['name']);
			$file_Sname = substr($attachment_file['name'], strrpos($attachment_file['name'], ".")+1);
			$attach_basename = substr($attachment_file['name'], file_Sname);
			$attachment_size = filesize($attachment_file['tmp_name']);
			$attach_id = time();

			if(check_ext($file_Sname, 'attach') == 0){
				@unlink($attachment_file['tmp_name']);
				die_message($lang['System_error'], $lang_db->group(array($lang['Posting_error_attachment_type'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), $ptype)), '');
			}

			if(!copy($attachment_file['tmp_name'], "./attachment/".$file_name)){
				@unlink($attachment_file['tmp_name']);
				die_message($lang['System_error'], $lang_db->group(array($lang['Posting_error_upload'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), $ptype)), '');
			}

			if(!$query = $db->query("INSERT INTO " . ATTACHMENT_TABLE . " (attach_id, attach_name, attach_size, attach_type, attach_time, attach_basename, attach_hide, attach_access, attach_bandwidth, attach_desc) VALUES ('$attach_id', '$file_name', '$attachment_size', '$file_Sname', '".time()."', '$attach_basename', '$attach_hide', '$attach_access', '".$info['attachment_bandwidth']."', '".encoding($attachment_desc)."')")){
				@unlink("./attachment/".$file_name);
				die_message($lang['System_error'], $lang_db->group(array($lang['Posting_error_attachment_insert'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), $ptype)), '');
			}
		}

		return $attach_id;
	}
// [FC-17] END <<<<

// ********************************************************************************
// [FC-18] Function: Return User Level Language Key (Forum)
// ********************************************************************************
	function auth_level($authdata){
		global $lang;

		switch($authdata){
			case '8';$authlevel = $lang['Level_admin'];break;
			case '7';$authlevel = $lang['Level_editor'];break;
			case '6';$authlevel = $lang['Level_mod'];break;
			case '5';$authlevel = $lang['Level_vip'];break;
			case '4';$authlevel = $lang['Level_payment'];break;
			case '3';$authlevel = $lang['Level_free'];break;
			case '2';$authlevel = $lang['Level_unregister'];break;
			case '1';$authlevel = $lang['Level_guest'];break;
		}
		return $authlevel;
	}
// [FC-18] END <<<<

// ********************************************************************************
// [FC-19] Function: Return User Level Language Key
// ********************************************************************************
	function userlevel($leveldata){
		global $lang;

		switch($leveldata){
			case '1';$userlevel = $lang['Level_admin'];break;
			case '10';$userlevel = $lang['Level_editor'];break;
			case '11';$userlevel = $lang['Level_mod'];break;
			case '100';$userlevel = $lang['Level_vip'];break;
			case '101';$userlevel = $lang['Level_payment'];break;
			case '102';$userlevel = $lang['Level_free'];break;
			case '109';$userlevel = $lang['Level_unregister'];break;
			default;$userlevel = $lang['Level_free'];break;
		}
		return $userlevel;
	}
// [FC-19] END <<<<

// ********************************************************************************
// [FC-20] Function: Rank Selection
// ********************************************************************************
	function rankselect($rank_date, $userrank, $cc, $access, $is_mod = 0, $sp_rank){
		global $lang, $userdata;

		$sp_rank = explode(";", $sp_rank);
		if(count($sp_rank) > 0){
			foreach($sp_rank as $var){
				$check_rank[$var] = TRUE;
			}
		}

		$rankselect = '<select name="rank">';
		$rankselect .= '<option value="0">'.$lang['Custom_rank']."</option>\n";
		if(count($rank_date) > 0){
			foreach($rank_date as $var){
				if(($cc >= $var['rank_cc'] && $access >= $var['rank_access'] && $var['special_rank'] == 0) || $is_mod == 1 || $userdata['userlevel'] == 1){
					$s = ($userrank == $var['rank_id']) ? ' selected="selected"' : '';
					$rankselect .= '<option value="'.$var['rank_id'].'"'.$s.'>'.$var['rank_name']."</option>\n";
				}
				if($var['special_rank'] == 1 && $check_rank[$var['rank_id']] == TRUE){
					$s = ($userrank == $var['rank_id']) ? ' selected="selected"' : '';
					$rankselect .= '<option value="'.$var['rank_id'].'"'.$s.'>'.$var['rank_name']."</option>\n";
				}
			}
		}
		$rankselect .= '</select>';
		return $rankselect;
	}
// [FC-20] END <<<<

// ********************************************************************************
// [FC-21] Function: Show Rank
// ********************************************************************************
	function showrank($rank_date, $userrank, $nickname, $cc, $access, $sp_rank){
		global $rank_star, $is_mod;

		if($userrank == 0){
			return $nickname;
		}else{
			$sp_rank = explode(";", $sp_rank);
			if(count($sp_rank) > 0){
				foreach($sp_rank as $var){
					$check_rank[$var] = TRUE;
				}
			}

			if(count($rank_date) > 0){
				foreach($rank_date as $var){
					if($userrank == $var['rank_id']){
						if(($cc >= $var['rank_cc'] && $access >= $var['rank_access']) || ($var['special_rank'] == 1 && ($check_rank[$var['rank_id']] == TRUE || $is_mod))) return (!empty($var['rank_image'])) ? '<img src="'.$var['rank_image'].'" title="'.$var['rank_name'].'">' : '<img src="'.$rank_star.'" align="absmiddle"> '.$var['rank_name'];
					}
				}
			}
		}
		return $nickname;
	}
// [FC-21] END <<<<

// ********************************************************************************
// [FC-22] Function: Topic Tag Selection
// ********************************************************************************
	function topic_tag($topic_tag){
		global $lang;

		if(empty($topic_tag)) return '';
		$tag_select = '<select name="topic_tag">';
		$tag_select .= '<option value="">'.$lang['No_topic_tag']."</option>\n";
		foreach(explode(",", $topic_tag) as $var){
			$tag_select .= '<option value="['.trim($var).']">['.trim($var)."]</option>\n";
		}
		$tag_select .= '</select> ';

		return decoding($tag_select);
	}
// [FC-22] END <<<<

// ********************************************************************************
// [FC-23] Function: Emailer
// ********************************************************************************
	function emailer($to, $subject, $headers = array(), $body){
		if(!empty($headers)) $mime .= implode("\n", $headers)."\n";

		return @mail($to, $subject, $body, $mime);
	}
// [FC-23] END <<<<

// ********************************************************************************
// [FC-23] Function: Size Box
// ****************************************************************************
	function size_box($max_vars, $vars, $title, $pst_table){
		global $size_bar_start, $size_bar_end, $size_bar;

		$percentage = ceil(($vars/$max_vars)*100);
		$bar_width = $percentage.'%';
		$pst_table = str_replace("{TITLE}", $title, $pst_table);
		$pst_table = str_replace("{SIZE_B_ST}", $size_bar_start, $pst_table);
		$pst_table = str_replace("{SIZE_B}", $size_bar, $pst_table);
		$pst_table = str_replace("{BAR_WIDTH}", $bar_width, $pst_table);
		$pst_table = str_replace("{PREC_C}", (100-$percentage), $pst_table);
		$pst_table = str_replace("{SIZE_B_END}", $size_bar_end, $pst_table);
		$pst_table = str_replace("{VAR}", $vars, $pst_table);
		$pst_table = str_replace("{MAX_VAR}", $max_vars, $pst_table);
		$pst_table = str_replace("{PREC}", $percentage, $pst_table);

		return $pst_table;
	}
// [FC-23] END <<<<

// ********************************************************************************
// [FC-24] Function: Get Page System Template
// ********************************************************************************
	function get_page_system_template($local, $type = ''){
		$fd = @fopen($local, "r");
		$pst = @fread($fd, filesize($local));
		@fclose($fd);

		if($type == 'PAGE'){
				$pst_array = array();
				preg_match('#<!-- START HEADER -->(.*)<!-- END HEADER -->#Uis', $pst, $matches);
				$pst_array['header'] = $matches[1];
				preg_match('#<!-- START FIELD_HEADER -->(.*)<!-- END FIELD_HEADER -->#Uis', $pst, $matches);
				$pst_array['field_header'] = $matches[1];
				preg_match('#<!-- START MOD_COL_HEADER -->(.*)<!-- END MOD_COL_HEADER -->#Uis', $pst, $matches);
				$pst_array['mod_col_header'] = $matches[1];
				preg_match('#<!-- START FIELD -->(.*)<!-- END FIELD -->#Uis', $pst, $matches);
				$pst_array['field'] = $matches[1];
				preg_match('#<!-- START MOD_COL -->(.*)<!-- END MOD_COL -->#Uis', $pst, $matches);
				$pst_array['mod_col'] = $matches[1];
				preg_match('#<!-- START EMPTY -->(.*)<!-- END EMPTY -->#Uis', $pst, $matches);
				$pst_array['empty'] = $matches[1];
				preg_match('#<!-- START FOOTER -->(.*)<!-- END FOOTER -->#Uis', $pst, $matches);
				$pst_array['footer'] = $matches[1];
				preg_match('#<!-- START TR_ON -->(.*)<!-- END TR_ON -- >#Uis', $pst, $matches);
				$pst_array['tr_on'] = $matches[1];
				preg_match('#<!-- START TR_OFF -->(.*)<!-- END TR_OFF -->#Uis', $pst, $matches);
				$pst_array['tr_off'] = $matches[1];
		}elseif($type == 'BBCODE'){
				$pst_array = array();
				preg_match('#<!-- START QUOTE -->(.*)<!-- END QUOTE -->#Uis', $pst, $matches);
				$pst_array['quote'] = $matches[1];
				preg_match('#<!-- START USER_QUOTE -->(.*)<!-- END USER_QUOTE -->#Uis', $pst, $matches);
				$pst_array['user_quote'] = $matches[1];
				preg_match('#<!-- START CODE -->(.*)<!-- END CODE -->#Uis', $pst, $matches);
				$pst_array['code'] = $matches[1];
				preg_match('#<!-- START EMBED -->(.*)<!-- END EMBED -->#Uis', $pst, $matches);
				$pst_array['embed'] = $matches[1];
				preg_match('#<!-- START REALPLAY -->(.*)<!-- END REALPLAY -->#Uis', $pst, $matches);
				$pst_array['realp'] = $matches[1];
				preg_match('#<!-- START HIDE -->(.*)<!-- END HIDE -->#Uis', $pst, $matches);
				$pst_array['hide'] = $matches[1];
				preg_match('#<!-- START HIDE_FALSE -->(.*)<!-- END HIDE_FALSE -->#Uis', $pst, $matches);
				$pst_array['hide_false'] = $matches[1];
				preg_match('#<!-- START HIDE_AC -->(.*)<!-- END HIDE_AC -->#Uis', $pst, $matches);
				$pst_array['hide_ac'] = $matches[1];
				preg_match('#<!-- START HIDE_AC_FALSE -->(.*)<!-- END HIDE_AC_FALSE -->#Uis', $pst, $matches);
				$pst_array['hide_ac_false'] = $matches[1];
				preg_match('#<!-- START HIDE_LV -->(.*)<!-- END HIDE_LV -->#Uis', $pst, $matches);
				$pst_array['hide_lv'] = $matches[1];
				preg_match('#<!-- START HIDE_LV_FALSE -->(.*)<!-- END HIDE_LV_FALSE -->#Uis', $pst, $matches);
				$pst_array['hide_lv_false'] = $matches[1];
		}else{
				$pst_array = array();
				preg_match('#<!-- START PAGEBOX -->(.*)<!-- END PAGEBOX -->#Uis', $pst, $matches);
				$pst_array['page_box'] = $matches[1];
				preg_match('#<!-- START SIZEBOX -->(.*)<!-- END SIZEBOX -->#Uis', $pst, $matches);
				$pst_array['size_box'] = $matches[1];
				preg_match('#<!-- START BANDWIDTH -->(.*)<!-- END BANDWIDTH -->#Uis', $pst, $matches);
				$pst_array['bandwidth'] = $matches[1];
				preg_match('#<!-- START POLL -->(.*)<!-- END POLL -->#Uis', $pst, $matches);
				$pst_array['poll'] = $matches[1];
				preg_match('#<!-- START TYPEBOX -->(.*)<!-- END TYPEBOX -->#Uis', $pst, $matches);
				$pst_array['type_box'] = $matches[1];
		}

		return $pst_array;
	}
// [FC-24] END <<<<
?>