<?
class cachestuff{
	// ********************************************************************************
	// [SC-01] Function: Loading Moderator Cache Data
	// ********************************************************************************
		function load_mod_cache($forum_id){
			global $userdata, $path;

			require($path.'sqlcache/moderator_'.$forum_id.'_data.php');
			return $mod_data;
		}
	// [SC-01] END <<<<

	// ********************************************************************************
	// [SC-02] Function: Creating Moderator Cache Data
	// ********************************************************************************
		function make_mod_cache($cache_data, $forum_id){
			global $path;

			if($forum_id <= 0) return FALSE;
			$file_moderator_data_text = array();
			$file_moderator_data_text[] = '<?';
			if(count($cache_data) > 0){
				foreach($cache_data as $var){
					$file_moderator_data_text[] = '$mod_data[] = array("id" => "'.$var['id'].'", "username" => "'.$var['username'].'");';
				}
			}
			$file_moderator_data_text[] = '?>';
			$file_moderator_data = fopen($path.'sqlcache/moderator_'.$forum_id.'_data.php', 'w'); 
			fwrite($file_moderator_data, implode("\n", $file_moderator_data_text));
			fclose($file_moderator_data);

			unset($cache_data);
		}
	// [SC-02] END <<<<

	// ********************************************************************************
	// [SC-03] Function: Loading Category Cache Data
	// ********************************************************************************
		function load_cat_cache(){
			global $path;

			require($path.'sqlcache/cat_data.php');
			return $cat_data;
		}
	// [SC-03] END <<<<

	// ********************************************************************************
	// [SC-04] Function: Creating Category Cache Data
	// ********************************************************************************
		function make_cat_cache($cache_data){
			global $path;

			$file_cat_data_text = array();
			$file_cat_data_text[] = '<?';
			if(count($cache_data) > 0){
				foreach($cache_data as $var){
					$file_cat_data_text[] = '$cat_data[] = array("cat_id" => "'.$var['cat_id'].'", "cat_name" => "'.$var['cat_name'].'", "cat_description" => "'.$var['cat_description'].'", "cat_banner" => "'.$var['cat_banner'].'");';
				}
			}
			$file_cat_data_text[] = '?>';
			$file_cat_data = fopen($path.'sqlcache/cat_data.php', 'w'); 
			fwrite ($file_cat_data, implode("\n", $file_cat_data_text));
			fclose ($file_cat_data);

			unset($cache_data);
		}
	// [SC-04] END <<<<

	// ********************************************************************************
	// [SC-05] Function: Loading Link Cache Data
	// ********************************************************************************
		function load_link_cache($forum_id){
			global $path;

			if($forum_id == 'global'){
				require($path.'sqlcache/link_global_data.php');
			}else require($path.'sqlcache/link_'.$forum_id.'_data.php');
			return $link_data;
		}
	// [SC-05] END <<<<

	// ********************************************************************************
	// [SC-06] Function: Creating Link Cache Data
	// ********************************************************************************
		function make_link_cache($cache_data, $forum_id){
			global $path;
			$file_link_data_text = array();
			$file_link_data_text[] = '<?';
			if($forum_id == 'global' || intval($forum_id) > 0){
				if(count($cache_data) > 0){
					foreach($cache_data as $var){
						$file_link_data_text[] = '$link_data[] = array("link_url" => "'.htmlspecialchars($var['link_url']).'", "link_name" => "'.$var['link_name'].'", "link_logo" => "'.htmlspecialchars($var['link_logo']).'");';
					}
				}
			}
			$file_link_data_text[] = '?>';
			$file_link_data = fopen($path.'sqlcache/link_'.$forum_id.'_data.php', 'w'); 
			fwrite ($file_link_data, implode("\n", $file_link_data_text));
			fclose ($file_link_data);

			unset($cache_data);
		}
	// [SC-06] END <<<<

	// ********************************************************************************
	// [SC-07] Function: Loading Page Cache Data
	// ********************************************************************************
		function load_page_cache(){
			global $path;

			require($path.'sqlcache/page_data.php');
			return $page_data;
		}
	// [SC-07] END <<<<

	// ********************************************************************************
	// [SC-08] Function: Creating Page Cache Data
	// ********************************************************************************
		function make_page_cache($cache_data){
			global $path;

			$file_page_data_text = array();
			$file_page_data_text[] = '<?';
			if(count($cache_data) > 0){
				foreach($cache_data as $var){
					$file_page_data_text[] = '$page_data[] = array("page_cat" => "'.$var['page_cat'].'", "page_title" => "'.$var['page_title'].'", "page_name" => "'.$var['page_name'].'", "page_link" => "'.$var['page_link'].'");';
				}
			}
			$file_page_data_text[] = '?>';
			$file_page_data = fopen($path.'sqlcache/page_data.php', 'w'); 
			fwrite ($file_page_data, implode("\n", $file_page_data_text));
			fclose ($file_page_data);

			unset($cache_data);
		}
	// [SC-08] END <<<<

	// ********************************************************************************
	// [SC-09] Function: Loading Block Cache Data
	// ********************************************************************************
		function load_block_cache(){
			global $path;

			require($path.'sqlcache/block_data.php');
			return $block_cache;
		}
	// [SC-09] END <<<<

	// ********************************************************************************
	// [SC-10] Function: Creating Block Cache Data
	// ********************************************************************************
		function make_block_cache($cache_data){
			global $path;

			$file_block_data_text = array();
			$file_block_data_text[] = '<?';
			if(count($cache_data) > 0){
				foreach($cache_data as $var){
					$file_block_data_text[] = $var;
				}
			}
			$file_block_data_text[] = '?>';
			$file_block_data = fopen($path.'sqlcache/block_data.php', 'w'); 
			fwrite ($file_block_data, implode("\n", $file_block_data_text));
			fclose ($file_block_data);

			unset($cache_data);
		}
	// [SC-10] END <<<<

	// ********************************************************************************
	// [SC-11] Function: Loading Smile Cache Data
	// ********************************************************************************
		function load_smile_cache(){
			global $path;

			require($path.'sqlcache/smile_data.php');
			$smile_data['patterns'] = $smile_patterns;
			$smile_data['replacements'] = $smile_replacements;
			unset($smile_patterns, $smile_replacements);
			return $smile_data;
		}
	// [SC-11] END <<<<

	// ********************************************************************************
	// [SC-12] Function: Creating Smile Cache Data
	// ********************************************************************************
		function make_smile_cache($cache_data){
			global $path;

			$file_smile_data_text = array();
			$file_smile_data_text[] = '<?';
			if(count($cache_data) > 0){
				foreach($cache_data as $var){
					$file_smile_data_text[] = '$smile_patterns[] = \''.$var['smile_replace'].'\';';
					$file_smile_data_text[] = '$smile_replacements[] = "<img src='.$var['smile_pic'].' alt='.$var['smile_name'].'>";';
				}
			}
			$file_smile_data_text[] = '?>';
			$file_smile_data = fopen($path.'sqlcache/smile_data.php', 'w'); 
			fwrite ($file_smile_data, implode("\n", $file_smile_data_text));
			fclose ($file_smile_data);

			unset($cache_data);
		}
	// [SC-12] END <<<<

	// ********************************************************************************
	// [SC-13] Function: Loading Rank Cache Data
	// ********************************************************************************
		function load_rank_cache(){
			global $path;
			require($path.'sqlcache/rank_data.php');

			return $rank_date_cache;
		}
	// [SC-13] END <<<<

	// ********************************************************************************
	// [SC-14] Function: Creating Rank Cache Data
	// ********************************************************************************
		function make_rank_cache($cache_data){
			global $path;

			$file_rank_data_text = array();
			$file_rank_data_text[] = '<?';
			if(count($cache_data) > 0){
				foreach($cache_data as $var){
					$file_rank_data_text[] = "\$rank_date_cache[] = array('rank_id' => '".$var['rank_id']."','rank_name' => '".$var['rank_name']."','rank_image' => '".$var['rank_image']."','rank_cc' => '".$var['rank_cc']."','rank_access' => '".$var['rank_access']."','special_rank' => '".$var['special_rank']."');";
				}
			}else $file_rank_data_text[] = '';
			$file_rank_data_text[] = '?>';
			$file_rank_data = fopen($path.'sqlcache/rank_data.php', 'w'); 
			fwrite ($file_rank_data, implode("\n", $file_rank_data_text));
			fclose ($file_rank_data);

			unset($cache_data);
		}
	// [SC-14] END <<<<

	// ********************************************************************************
	// [SC-15] Function: Loading Forum Shortcut(Category) Cache Data
	// ********************************************************************************
		function load_catnav_cache(){
			global $path;

			require($path.'sqlcache/catnav_data.php');
			return $catnav_data;
		}
	// [SC-15] END <<<<

	// ********************************************************************************
	// [SC-16] Function: Creating Forum Shortcut(Category) Cache Data
	// ********************************************************************************
		function make_catnav_cache($cache_data){
			global $path;

			$file_catnav_data_text = array();
			$file_catnav_data_text[] = '<?';
			if(count($cache_data) > 0){
				foreach($cache_data as $var){
					$file_catnav_data_text[] = '$catnav_data[] = array("cat_id" => "'.$var['cat_id'].'", "cat_name" => "'.$var['cat_name'].'");';
				}
			}
			$file_catnav_data_text[] = '?>';
			$file_catnav_data = fopen($path.'sqlcache/catnav_data.php', 'w'); 
			fwrite ($file_catnav_data, implode("\n", $file_catnav_data_text));
			fclose ($file_catnav_data);

			unset($cache_data);
		}
	// [SC-16] END <<<<

	// ********************************************************************************
	// [SC-17] Function: Loading Forum Shortcut(Forum) Cache Data
	// ********************************************************************************
		function load_forumnav_cache(){
			global $path;

			require($path.'sqlcache/forumnav_data.php');
			$forumnav_return['forum_nav'] = $forumnav_data;
			$forumnav_return['subforum_id'] = $subforum_id_data;
			$forumnav_return['subforum_nav'] = $subforumnav_data;

			return $forumnav_return;
		}
	// [SC-17] END <<<<

	// ********************************************************************************
	// [SC-18] Function: Creating Forum Shortcut(Forum) Cache Data
	// ********************************************************************************
		function make_forumnav_cache($cache_data, $subforum_id, $subforum_data){
			global $path;

			$file_forumnav_data_text = array();
			$file_forumnav_data_text[] = '<?';
			if(count($cache_data) > 0){
				foreach($cache_data as $var){
					$file_forumnav_data_text[] = '$forumnav_data[] = array("forum_id" => "'.$var['forum_id'].'", "forum_name" => "'.$var['forum_name'].'", "cat_id" => "'.$var['cat_id'].'", "forum_group" => "'.$var['forum_group'].'", "forum_group_view" => "'.$var['forum_group_view'].'", "forum_group_hide" => "'.$var['forum_group_hide'].'");';
				}
			}
			if(count($subforum_id) > 0){
				foreach($subforum_id as $key => $var){
					if(count($var) > 0){
						foreach($var as $cache_text){
							$insert_cache_text .= (!empty($insert_cache_text)) ? ", '".$cache_text."'" : "'".$cache_text."'";
						}
					}
					$file_forumnav_data_text[] = '$subforum_id_data['.$key.'] = array('.$insert_cache_text.');';
					unset($insert_cache_text);
				}
			}
			if(count($subforum_data) > 0){
				foreach($subforum_data as $key => $var){
					$file_forumnav_data_text[] = '$subforumnav_data['.$key.'] = array("forum_id" => "'.$var['forum_id'].'", "forum_name" => "'.$var['forum_name'].'", "cat_id" => "'.$var['cat_id'].'", "forum_group" => "'.$var['forum_group'].'", "forum_group_view" => "'.$var['forum_group_view'].'", "forum_group_hide" => "'.$var['forum_group_hide'].'");';
				}
			}
			$file_forumnav_data_text[] = '?>';
			$file_forumnav_data = fopen($path.'sqlcache/forumnav_data.php', 'w'); 
			fwrite ($file_forumnav_data, implode("\n", $file_forumnav_data_text));
			fclose ($file_forumnav_data);

			unset($cache_data);
		}
	// [SC-18] END <<<<

	// ********************************************************************************
	// [SC-19] Function: Loading Type Cache Data
	// ********************************************************************************
		function load_type_cache($forum_id){
			global $path;
			require($path.'sqlcache/type_'.$forum_id.'_data.php');

			return $type_date_cache;
		}
	// [SC-19] END <<<<

	// ********************************************************************************
	// [SC-20] Function: Creating Type Cache Data
	// ********************************************************************************
		function make_type_cache($cache_data, $forum_id){
			global $path;

			$file_type_data_text = array();
			$file_type_data_text[] = '<?';
			if(count($cache_data) > 0){
				foreach($cache_data as $var){
					$file_type_data_text[] = "\$type_date_cache[] = array('type_id' => '".$var['type_id']."','type_name' => '".$var['type_name']."','type_img' => '".$var['type_img']."');";
				}
			}else $file_type_data_text[] = '';
			$file_type_data_text[] = '?>';
			$file_type_data = fopen($path.'sqlcache/type_'.$forum_id.'_data.php', 'w'); 
			fwrite ($file_type_data, implode("\n", $file_type_data_text));
			fclose ($file_type_data);

			unset($cache_data);
		}
	// [SC-20] END <<<<
}
?>