## iwebsystem_attachment
CREATE TABLE iwebsystem_attachment (
	attach_id int(11) NOT NULL default '0',
	attach_name varchar(255) NOT NULL default '',
	attach_size int(15) NOT NULL default '0',
	attach_type varchar(255) NOT NULL default '',
	attach_time int(11) NOT NULL default '0',
	attach_basename varchar(255) NOT NULL default '',
	attach_hits mediumint(8) NOT NULL default '0',
	attach_access mediumint(8) NOT NULL default '0',
	attach_hide mediumint(8) NOT NULL default '0',
	attach_bandwidth varchar(255) NOT NULL default '',
	attach_decs varchar(255) NOT NULL default '',
	PRIMARY KEY (attach_id)
);

## iwebsystem_page
CREATE TABLE iwebsystem_page (
	page_id mediumint(8) NOT NULL auto_increment,
	page_name varchar(255) NOT NULL default '',
	page_email tinyint(2) NOT NULL default '0',
	page_mail_to varchar(255) NOT NULL default '',
	page_editor varchar(255) NOT NULL default '0',
	page_pm_to varchar(255) NOT NULL default '',
	page_pm tinyint(2) NOT NULL default '0',
	page_title varchar(255) NOT NULL default '',
	page_mail_title varchar(255) NOT NULL default '',
	page_pm_title varchar(255) NOT NULL default '',
	page_on mediumint(8) NOT NULL default '0',
	page_cat varchar(255) NOT NULL default '',
	page_link varchar(255) NOT NULL default '',
	page_sql varchar(255) NOT NULL default '',
	field_display varchar(255) NOT NULL default '',
	field_row mediumint(8) NOT NULL default '0',
	page_sql_title varchar(255) NOT NULL default '',
	field_width varchar(255) NOT NULL default '',
	page_position tinyint(2) NOT NULL default '0',
	field_type varchar(255) NOT NULL default '',
	field_title varchar(255) NOT NULL default '',
	field_align varchar(255) NOT NULL default '',
	PRIMARY KEY (page_id)
);

## iwebsystem_block
CREATE TABLE iwebsystem_block (
	block_id mediumint(8) NOT NULL auto_increment,
	block_name varchar(255) NOT NULL default '',
	block_content text NOT NULL,
	block_position mediumint(8) NOT NULL default '0',
	block_order mediumint(8) NOT NULL default '0',
	PRIMARY KEY (block_id)
);

## iwebsystem_ban
CREATE TABLE iwebsystem_ban (
	id mediumint(8) NOT NULL auto_increment,
	user_id mediumint(8) NOT NULL default '0',
	ban_start int(11) NOT NULL default '0',
	ban_end int(11) NOT NULL default '0',
	ban_reason varchar(255) NOT NULL default '',
	forum_id mediumint(8) NOT NULL default '0',
	PRIMARY KEY (id)
);

## iwebsystem_categary
CREATE TABLE iwebsystem_categary (
	cat_id mediumint(8) NOT NULL auto_increment,
	cat_name varchar(255) NOT NULL default '',
	cat_description varchar(255) NOT NULL default '',
	cat_order mediumint(8) NOT NULL default '0',
	cat_banner varchar(255) NOT NULL default '',
	PRIMARY KEY (cat_id)
);

## iwebsystem_categary
INSERT INTO iwebsystem_categary VALUES (1, 'This a test category.', 'This is a test category for your new install.', 1, '');

## iwebsystem_comment
CREATE TABLE iwebsystem_comment (
	id mediumint(8) NOT NULL auto_increment,
	user_id mediumint(8) NOT NULL default '0',
	news_id mediumint(8) NOT NULL default '0',
	comment varchar(255) NOT NULL default '',
	comment_time int(11) NOT NULL default '0',
	PRIMARY KEY (id)
);

## iwebsystem_download
CREATE TABLE iwebsystem_download (
	file_id mediumint(8) NOT NULL auto_increment,
	file_name varchar(255) NOT NULL default '',
	file_basename varchar(255) NOT NULL default '',
	file_showname varchar(255) NOT NULL default '',
	file_download mediumint(8) NOT NULL default '0',
	file_time int(11) NOT NULL default '0',
	file_desc text NOT NULL,
	file_author varchar(255) NOT NULL default '',
	file_image varchar(255) NOT NULL default '',
	file_homepage varchar(255) NOT NULL default '',
	cat_id mediumint(8) NOT NULL default '0',
	file_payment text NOT NULL,
	file_other_link text NOT NULL,
	PRIMARY KEY (file_id)
);

## iwebsystem_download_cat
CREATE TABLE iwebsystem_download_cat (
	dl_cat_id mediumint(8) NOT NULL auto_increment,
	dl_cat_name varchar(255) NOT NULL default '',
	dl_cat_file mediumint(8) NOT NULL default '0',
	dl_cat_cc mediumint(8) NOT NULL default '0',
	dl_cat_desc varchar(255) NOT NULL default '',
	dl_cat_access mediumint(8) NOT NULL default '0',
	dl_cat_order mediumint(8) NOT NULL default '0',
	PRIMARY KEY (dl_cat_id)
);

## iwebsystem_group
CREATE TABLE iwebsystem_group (
	group_id mediumint(8) NOT NULL auto_increment,
	group_name varchar(255) NOT NULL default '',
	group_desc text NOT NULL,
	group_leader mediumint(8) NOT NULL default '0',
	group_icon varchar(255) NOT NULL default '',
	group_post mediumint(8) NOT NULL default '0',
	group_member mediumint(8) NOT NULL default '0',
	group_ban text NOT NULL,
	group_allow_join tinyint(2) NOT NULL default '0',
	group_allow_view_guestbook tinyint(2) NOT NULL default '0',
	group_allow_post tinyint(2) NOT NULL default '0',
	group_announce text NOT NULL,
	PRIMARY KEY (group_id),
	KEY group_id (group_id)
);

## iwebsystem_group_guestbook
CREATE TABLE iwebsystem_group_guestbook (
	post_id mediumint(8) NOT NULL auto_increment,
	post_subject varchar(255) NOT NULL default '',
	post_content text NOT NULL,
	user_id mediumint(8) NOT NULL default '0',
	group_id mediumint(8) NOT NULL default '0',
	post_time int(15) NOT NULL default '0',
	post_reply mediumint(8) NOT NULL default '0',
	PRIMARY KEY (post_id)
);

## iwebsystem_group_member
CREATE TABLE iwebsystem_group_member (
	member_id mediumint(8) NOT NULL auto_increment,
	member_request TINYINT(2) NOT NULL default '0',
	user_id mediumint(8) NOT NULL default '0',
	group_id mediumint(8) NOT NULL default '0',
	PRIMARY KEY (member_id)
);

## iwebsystem_forum
CREATE TABLE iwebsystem_forum (
	forum_id mediumint(8) NOT NULL auto_increment,
	forum_topics mediumint(8) NOT NULL default '0',
	forum_posts mediumint(8) NOT NULL default '0',
	forum_name varchar(255) NOT NULL default '',
	forum_description varchar(255) NOT NULL default '',
	forum_last_post mediumint(8) NOT NULL default '0',
	forum_status mediumint(8) NOT NULL default '0',
	cat_id mediumint(8) NOT NULL default '0',
	forum_access mediumint(8) NOT NULL default '0',
	forum_cc_topic mediumint(8) NOT NULL default '0',
	forum_topic_auth tinyint(2) NOT NULL default '0',
	forum_cc_post mediumint(8) NOT NULL default '0',
	forum_rule text NOT NULL,
	forum_mod_note text NOT NULL,
	forum_banner varchar(255) NOT NULL default '',
	forum_order mediumint(8) NOT NULL default '0',
	forum_reply_auth tinyint(2) NOT NULL default '1',
	forum_view_auth tinyint(2) NOT NULL default '1',
	forum_attach_auth tinyint(2) NOT NULL default '1',
	forum_icon varchar(255) NOT NULL default '',
	forum_access_topic mediumint(8) NOT NULL default '0',
	forum_access_post mediumint(8) NOT NULL default '0',
	forum_poll_auth tinyint(2) NOT NULL default '1',
	forum_password varchar(255) NOT NULL default '',
	topic_tag varchar(255) NOT NULL default '',
	forum_view_type tinyint(2) NOT NULL default '0',
	forum_group_hide tinyint(2) NOT NULL default '0',
	forum_group_view tinyint(2) NOT NULL default '0',
	forum_group mediumint(8) NOT NULL default '0',
	forum_on mediumint(8) NOT NULL default '0',
	PRIMARY KEY (forum_id),
	KEY forum_id (forum_id),
	KEY cat_id (cat_id),
	KEY forum_last_post (forum_last_post),
	KEY forum_group (forum_group)
);

INSERT INTO iwebsystem_forum VALUES (1, 0, 0, 'This is a test forum.', 'You can post a topic in this forum.', 0, 0, 1, 0, 0, 1, 0, '', '', '', 0, 1, 1, 1, '', 0, 0, 1, '', '', 0, 0, 0, 0, 0);

## iwebsystem_forum_dl
CREATE TABLE iwebsystem_forum_dl (
	file_id mediumint(8) NOT NULL auto_increment,
	file_name varchar(255) NOT NULL default '',
	file_basename varchar(255) NOT NULL default '',
	file_showname varchar(255) NOT NULL default '',
	file_download mediumint(8) NOT NULL default '0',
	file_time int(11) NOT NULL default '0',
	file_desc varchar(255) NOT NULL default '0',
	file_author mediumint(255) NOT NULL default '0',
	file_payment text NOT NULL,
	cat_id mediumint(8) NOT NULL default '0',
	file_other_link text NOT NULL,
	PRIMARY KEY (file_id)
);

## iwebsystem_forum_dl_cat

CREATE TABLE iwebsystem_forum_dl_cat (
	dl_cat_id mediumint(8) NOT NULL auto_increment,
	dl_cat_name varchar(255) NOT NULL default '',
	dl_cat_file mediumint(8) NOT NULL default '0',
	dl_cat_cc mediumint(8) NOT NULL default '0',
	dl_cat_desc varchar(255) NOT NULL default '',
	dl_cat_access mediumint(8) NOT NULL default '0',
	dl_cat_order mediumint(8) NOT NULL default '0',
	forum_id mediumint(8) NOT NULL default '0',
	PRIMARY KEY (dl_cat_id),
	KEY forum_id (forum_id)
);

## iwebsystem_info
CREATE TABLE iwebsystem_info (
	info_name varchar(255) NOT NULL default '',
	info_value varchar(255) NOT NULL default '',
	PRIMARY KEY (info_name)
);

## iwebsystem_info
INSERT INTO iwebsystem_info VALUES ('members', '1');
INSERT INTO iwebsystem_info VALUES ('archive', '0');
INSERT INTO iwebsystem_info VALUES ('forum', '1');
INSERT INTO iwebsystem_info VALUES ('tuitional', '0');
INSERT INTO iwebsystem_info VALUES ('file', '0');
INSERT INTO iwebsystem_info VALUES ('news_banner', '');
INSERT INTO iwebsystem_info VALUES ('event_banner', '');
INSERT INTO iwebsystem_info VALUES ('site_name', 'i-Web System');
INSERT INTO iwebsystem_info VALUES ('site_description', 'i-Web System developing by iOptional.comC');
INSERT INTO iwebsystem_info VALUES ('comment_pre_page', '15');
INSERT INTO iwebsystem_info VALUES ('topic_pre_page', '20');
INSERT INTO iwebsystem_info VALUES ('post_pre_page', '10');
INSERT INTO iwebsystem_info VALUES ('news_banner_id', '');
INSERT INTO iwebsystem_info VALUES ('event_banner_id', '');
INSERT INTO iwebsystem_info VALUES ('flood', '10');
INSERT INTO iwebsystem_info VALUES ('session', '60');
INSERT INTO iwebsystem_info VALUES ('max_sig', '210');
INSERT INTO iwebsystem_info VALUES ('sig_line', '__________________________________');
INSERT INTO iwebsystem_info VALUES ('max_link', '10');
INSERT INTO iwebsystem_info VALUES ('max_dl_cat', '5');
INSERT INTO iwebsystem_info VALUES ('forum_banner_width', '400');
INSERT INTO iwebsystem_info VALUES ('forum_banner_height', '120');
INSERT INTO iwebsystem_info VALUES ('max_online', '');
INSERT INTO iwebsystem_info VALUES ('max_online_time', '');
INSERT INTO iwebsystem_info VALUES ('news_banner_url', '');
INSERT INTO iwebsystem_info VALUES ('event_banner_url', '');
INSERT INTO iwebsystem_info VALUES ('hot_topic', '25');
INSERT INTO iwebsystem_info VALUES ('attachment_size', '10485760');
INSERT INTO iwebsystem_info VALUES ('smile_show', '15');
INSERT INTO iwebsystem_info VALUES ('images_width', '400');
INSERT INTO iwebsystem_info VALUES ('avatar_width', '120');
INSERT INTO iwebsystem_info VALUES ('avatar_height', '120');
INSERT INTO iwebsystem_info VALUES ('forum_mode', '1');
INSERT INTO iwebsystem_info VALUES ('admin_email', '');
INSERT INTO iwebsystem_info VALUES ('smtp_server', '');
INSERT INTO iwebsystem_info VALUES ('register_mail', '');
INSERT INTO iwebsystem_info VALUES ('close', '0');
INSERT INTO iwebsystem_info VALUES ('close_message', 'Server is updating, please wait until finish the update.');
INSERT INTO iwebsystem_info VALUES ('attachment_ext', 'zip,rar,jpg,jpeg,png,gif,mid,mp3,rm,rmvb,txt');
INSERT INTO iwebsystem_info VALUES ('attachment_image', 'jpg,jpeg,png,gif');
INSERT INTO iwebsystem_info VALUES ('ban_list', '');
INSERT INTO iwebsystem_info VALUES ('ban_user_list', '');
INSERT INTO iwebsystem_info VALUES ('attachment_bandwidth', '0');
INSERT INTO iwebsystem_info VALUES ('attachment_update', '3600');
INSERT INTO iwebsystem_info VALUES ('attachment_timer', '0');
INSERT INTO iwebsystem_info VALUES ('total_page_tag', '5');
INSERT INTO iwebsystem_info VALUES ('version', '%%%version%%%');
INSERT INTO iwebsystem_info VALUES ('version_md5', '%%%version_md5%%%');
INSERT INTO iwebsystem_info VALUES ('GMT', '+0');
INSERT INTO iwebsystem_info VALUES ('allow_forumnav', '0');
INSERT INTO iwebsystem_info VALUES ('group', '0');
INSERT INTO iwebsystem_info VALUES ('group_post', '0');
INSERT INTO iwebsystem_info VALUES ('group_add', '0');
INSERT INTO iwebsystem_info VALUES ('max_poll', '5');
INSERT INTO iwebsystem_info VALUES ('allow_forum_announce', '5');
INSERT INTO iwebsystem_info VALUES ('link_display', '5');
INSERT INTO iwebsystem_info VALUES ('allow_authcode', '1');
INSERT INTO iwebsystem_info VALUES ('allow_registration', '0');
INSERT INTO iwebsystem_info VALUES ('allow_registration_day', '');
INSERT INTO iwebsystem_info VALUES ('inhibition_name', '');
INSERT INTO iwebsystem_info VALUES ('max_private_message', '20');
INSERT INTO iwebsystem_info VALUES ('allow_basic_style', 'freestyle');
INSERT INTO iwebsystem_info VALUES ('allow_user_style', '0');
INSERT INTO iwebsystem_info VALUES ('post_verify', '0');

## iwebsystem_link
CREATE TABLE iwebsystem_link (
	link_id mediumint(8) NOT NULL auto_increment,
	link_name varchar(255) NOT NULL default '',
	link_url varchar(255) NOT NULL default '',
	forum_id mediumint(8) NOT NULL default '0',
	link_logo varchar(255) NOT NULL default '0',
	link_order mediumint(8) NOT NULL default '0',
	PRIMARY KEY (link_id)
);

## iwebsystem_moderator
CREATE TABLE iwebsystem_moderator (
	mod_id mediumint(8) NOT NULL auto_increment,
	forum_id mediumint(8) NOT NULL default '0',
	mod_time int(11) NOT NULL default '0',
	user_id mediumint(8) NOT NULL default '0',
	PRIMARY KEY (mod_id)
);

## iwebsystem_news
CREATE TABLE iwebsystem_news (
	news_id mediumint(8) NOT NULL auto_increment,
	news_title varchar(255) NOT NULL default '',
	news_content text NOT NULL,
	news_type TINYINT(2) NOT NULL default '0',
	news_time varchar(255) NOT NULL default '',
	news_view mediumint(8) NOT NULL default '0',
	news_stitle varchar(255) NOT NULL default '',
	news_comment mediumint(8) NOT NULL default '0',
	news_img text NOT NULL,
	news_banner varchar(255) NOT NULL default '',
	news_announcer mediumint(8) NOT NULL default '0',
	PRIMARY KEY (news_id)
);

## iwebsystem_post
CREATE TABLE iwebsystem_post (
	post_id mediumint(8) NOT NULL auto_increment,
	topic_id mediumint(8) NOT NULL default '0',
	post_subject varchar(255) NOT NULL default '',
	post_content text NOT NULL,
	user_id mediumint(8) NOT NULL default '0',
	post_time int(11) NOT NULL default '0',
	frist_post mediumint(8) NOT NULL default '0',
	forum_id mediumint(8) NOT NULL default '0',
	post_attach int(15) NOT NULL default '0',
	post_ip varchar(255) NOT NULL default '0',
	payment_fee mediumint(8) NOT NULL default '0',
	payment_result text NOT NULL,
	post_gp text NOT NULL default '',
	PRIMARY KEY (post_id),
	KEY post_id (post_id),
	KEY topic_id (topic_id),
	KEY user_id (user_id),
	KEY forum_id (forum_id)
);

## iwebsystem_private_message
CREATE TABLE iwebsystem_private_message (
	pm_id mediumint(8) NOT NULL auto_increment,
	from_user mediumint(8) NOT NULL default '0',
	to_user mediumint(8) NOT NULL default '0',
	pm_title varchar(255) NOT NULL default '',
	pm_content text NOT NULL,
	pm_time int(15) NOT NULL default '0',
	pm_read tinyint(2) NOT NULL default '0',
	max_id mediumint(8) NOT NULL default '0',
	PRIMARY KEY (pm_id),
	KEY from_user (from_user),
	KEY to_user (to_user)
);

## iwebsystem_smile
CREATE TABLE iwebsystem_smile (
	smile_id mediumint(8) NOT NULL auto_increment,
	smile_name varchar(255) NOT NULL default '',
	smile_pic varchar(255) NOT NULL default '',
	smile_replace varchar(255) NOT NULL default '',
	PRIMARY KEY (smile_id)
);

## iwebsystem_smile
INSERT INTO iwebsystem_smile VALUES (1, 'Smile', 'images/smile/icon_arrow1.gif', '$:)$');
INSERT INTO iwebsystem_smile VALUES (3, 'Good', 'images/smile/icon_biggrin1.gif', '$:]$');
INSERT INTO iwebsystem_smile VALUES (4, 'Nothing', 'images/smile/icon_confused1.gif', '$:|$');
INSERT INTO iwebsystem_smile VALUES (5, 'Cool!', 'images/smile/icon_cool1.gif', '$;/$');
INSERT INTO iwebsystem_smile VALUES (6, 'Crying', 'images/smile/icon_cry1.gif', '$;($');
INSERT INTO iwebsystem_smile VALUES (7, 'What!?', 'images/smile/icon_eek1.gif', '$:o$');
INSERT INTO iwebsystem_smile VALUES (8, 'Evil', 'images/smile/icon_evil1.gif', '$!:[$');
INSERT INTO iwebsystem_smile VALUES (9, '...', 'images/smile/icon_exclaim1.gif', '$:x$');
INSERT INTO iwebsystem_smile VALUES (10, 'I have a idea!', 'images/smile/icon_idea1.gif', '$*:)$');
INSERT INTO iwebsystem_smile VALUES (11, 'Hahahaha!', 'images/smile/icon_lol1.gif', '$:D$');
INSERT INTO iwebsystem_smile VALUES (12, 'Oh, mad...', 'images/smile/icon_mad1.gif', '$X|$');
INSERT INTO iwebsystem_smile VALUES (13, 'Zzzzz....', 'images/smile/icon_mrgreen1.gif', '$|Z$');
INSERT INTO iwebsystem_smile VALUES (14, 'haha...', 'images/smile/icon_neutral1.gif', '$:@$');
INSERT INTO iwebsystem_smile VALUES (15, 'What?', 'images/smile/icon_question1.gif', '$[...]$');
INSERT INTO iwebsystem_smile VALUES (16, 'Sad', 'images/smile/icon_razz1.gif', '$;(($');
INSERT INTO iwebsystem_smile VALUES (17, 'Angry!', 'images/smile/icon_redface1.gif', '$:[$');
INSERT INTO iwebsystem_smile VALUES (18, 'What!?', 'images/smile/icon_rolleyes1.gif', '$:-o$');
INSERT INTO iwebsystem_smile VALUES (19, ':(', 'images/smile/icon_sad1.gif', '$:($');
INSERT INTO iwebsystem_smile VALUES (20, 'happy', 'images/smile/icon_smile1.gif', '$XD$');
INSERT INTO iwebsystem_smile VALUES (21, 'Surprised!', 'images/smile/icon_surprised1.gif', '$:u$');
INSERT INTO iwebsystem_smile VALUES (22, 'Twisted', 'images/smile/icon_twisted1.gif', '$;@$');
INSERT INTO iwebsystem_smile VALUES (23, 'Wink...', 'images/smile/icon_wink1.gif', '$:-|$');

## iwebsystem_topic
CREATE TABLE iwebsystem_topic (
	topic_id mediumint(8) NOT NULL auto_increment,
	post_id mediumint(8) NOT NULL default '0',
	topic_access mediumint(8) NOT NULL default '0',
	forum_id mediumint(8) NOT NULL default '0',
	topic_last_post_time int(11) NOT NULL default '0',
	topic_last_post_user mediumint(8) NOT NULL default '0',
	topic_view mediumint(8) NOT NULL default '0',
	topic_post mediumint(8) NOT NULL default '0',
	topic_subject varchar(255) NOT NULL default '',
	topic_type tinyint(2) NOT NULL default '0',
	topic_knowledge tinyint(2) NOT NULL default '0',
	topic_locked tinyint(2) NOT NULL default '0',
	topic_bold tinyint(2) NOT NULL default '0',
	topic_color varchar(6) NOT NULL default '',
	topic_class mediumint(8) NOT NULL default '0',
	poll_object text NOT NULL,
	poll_result text NOT NULL,
	poll_subject varchar(255) NOT NULL default '',
	poll_type tinyint(2) NOT NULL default '0',
	topic_tag varchar(255) NOT NULL default '',
	PRIMARY KEY (topic_id),
	KEY forum_id (forum_id),
	KEY topic_id (topic_id),
	KEY post_id (post_id),
	KEY topic_last_post_time (topic_last_post_time),
	KEY topic_last_post_user (topic_last_post_user)
);

## iwebsystem_user
CREATE TABLE iwebsystem_user (
	id mediumint(8) NOT NULL auto_increment,
	username varchar(255) NOT NULL default '',
	nickname varchar(255) NOT NULL default '',
	password varchar(255) NOT NULL default '',
	email varchar(255) NOT NULL default '',
	gender mediumint(8) NOT NULL default '0',
	cc int(11) NOT NULL default '0',
	act_key varchar(255) NOT NULL default '',
	session int(11) NOT NULL default '0',
	userlevel mediumint(8) NOT NULL default '0',
	icq varchar(15) default NULL,
	msnm varchar(255) default NULL,
	avatar_height varchar(5) default NULL,
	avatar_width varchar(5) default NULL,
	avatar text,
	comments mediumint(8) NOT NULL default '0',
	posts mediumint(8) NOT NULL default '0',
	access mediumint(8) NOT NULL default '0',
	topics mediumint(8) NOT NULL default '0',
	sig text NOT NULL,
	avatar_upload tinyint(2) NOT NULL default '0',
	show_sig tinyint(2) NOT NULL default '0',
	forum_mode tinyint(2) NOT NULL default '0',
	www varchar(255) NOT NULL default '',
	ip varchar(255) NOT NULL default '',
	brith varchar(255) DEFAULT '0000-00-00',
	deadline varchar(255) DEFAULT '0000-00-00',
	rank MEDIUMINT(8) NOT NULL,
	favorite_topic varchar(255) NOT NULL,
	group_id varchar(255) NOT NULL,
	read_pm varchar(255) NOT NULL,
	auto_reply varchar(255) NOT NULL default '',
	allow_auto_reply tinyint(2) NOT NULL default '0',
	user_style varchar(255) NOT NULL default '',
	gp mediumint(8) NOT NULL default '0',
	sp_rank varchar(255) NOT NULL default '',
	allow_news tinyint(2) NOT NULL default '0',
	pm_delete text,
	PRIMARY KEY (id),
	KEY id (id)
);

## iwebsystem_rank
CREATE TABLE iwebsystem_rank (
	rank_id mediumint(8) NOT NULL auto_increment,
	rank_name varchar(255) NOT NULL default '',
	rank_cc mediumint(8) NOT NULL default '0',
	rank_access mediumint(8) NOT NULL default '0',
	rank_image varchar(255) NOT NULL default '',
	special_rank tinyint(2) NOT NULL default '0',
	PRIMARY KEY (rank_id)
);

## iwebsystem_guest
CREATE TABLE iwebsystem_guest (
	guest_id mediumint(8) NOT NULL auto_increment,
	guest_ip varchar(15) NOT NULL default '',
	guest_session int(11) NOT NULL default '0',
	PRIMARY KEY (guest_id)
);

## iwebsystem_type
CREATE TABLE iwebsystem_type (
	type_id mediumint(8) NOT NULL auto_increment,
	type_name varchar(255) NOT NULL,
	type_img varchar(255) NOT NULL,
	forum_id mediumint(8) NOT NULL,
	PRIMARY KEY (type_id)
);