<?
define('IN_SITE', true);
$path = './';
require($path.'includes/page_header.php');

$fid = intval($HTTP_GET_VARS['fid']);
$tid = intval($HTTP_GET_VARS['tid']);
$pid = intval($HTTP_GET_VARS['pid']);
$post = ( isset($HTTP_GET_VARS['post']) ) ? trim($HTTP_GET_VARS['post']) : '';
$quote = ( isset($HTTP_GET_VARS['quote']) ) ? TRUE : FALSE;

$mode = (isset($HTTP_GET_VARS['mode'])) ? $HTTP_GET_VARS['mode'] : '';

// ********************************************************************************
// [PO-01] SQLcache: Getting Moderation Permission
// ********************************************************************************
	$is_mod = FALSE;
	if(file_exists($path.'sqlcache/moderator_'.$fid.'_data.php')){ 
		$mod_data = $cache->load_mod_cache($fid);
		if(count($mod_data) > 0){
			foreach($mod_data as $var){
				if($var['id'] == $userdata['id']) $is_mod = TRUE;
				$mod_list .= (!empty($mod_list)) ? ', '.$var['username'] : $var['username'];
			}
		}
	}else{
		$query = $db->query("SELECT m.*, u.username, u.id FROM (" . MOD_TABLE . " m LEFT JOIN " . USERS_TABLE . " u ON u.id = m.user_id) WHERE forum_id = $fid", 'UNBUFFERED');
		while($result = $db->fetch_array($query)){
			if($result['id'] == $userdata['id']) $is_mod = TRUE;
			$mod_list .= (!empty($mod_list)) ? ', ' . $result['username'] : $result['username'];
			$cache_mod[] = $result;
		}
		$cache->make_mod_cache($cache_mod, $fid);
		$db->free_result($query);
	}
	if($forum_row['forum_on'] > 0){
		$is_mod = FALSE;
		if(file_exists($path.'sqlcache/moderator_'.$forum_row['forum_on'].'_data.php')){ 
			$mod_data = $cache->load_mod_cache($forum_row['forum_on']);
			if(count($mod_data) > 0){
				foreach($mod_data as $var){
					if($var['id'] == $userdata['id']) $is_mod = TRUE;
					$mod_list .= (!empty($mod_list)) ? ', <b>*' . $var['username'].'</b>' : '<b>*'.$var['username'].'</b>';
				}
			}
		}else{
			$query = $db->query("SELECT m.*, u.username, u.id FROM (" . MOD_TABLE . " m LEFT JOIN " . USERS_TABLE . " u ON u.id = m.user_id) WHERE forum_id = ".$forum_row['forum_on'], 'UNBUFFERED');
			while($result = $db->fetch_array($query)){
				if($result['id'] == $userdata['id']) $is_mod = TRUE;
				$mod_list .= (!empty($mod_list)) ? ', <b>*' . $result['username'].'</b>' : '<b>*'.$result['username'].'</b>';
				$cache_mod[] = $result;
			}
			$cache->make_mod_cache($cache_mod, $forum_row['forum_on']);
			$db->free_result($query);
		}
	}
	if($userdata['userlevel'] <= 10) $is_mod = TRUE;
	$modlist = (!empty($mod_list)) ? sprintf($lang['Modlist'], $mod_list) : sprintf($lang['Modlist'], $lang['No_mod']);
// [PO-01] END <<<<

// ********************************************************************************
// [PO-02] Getting Ban List
// ********************************************************************************
	$query = $db->query("SELECT b.*, u.* FROM (" . BAN_TABLE . " b LEFT JOIN " . USERS_TABLE . " u ON u.id = b.user_id) WHERE b.forum_id = $fid");
	if($db->num_rows($query) > 0){
		while ($result = $db->fetch_array($query)){
			if($userdata['id'] == $result['user_id']){
				if(time() > $result['ban_end']){
					$sql = "DELETE FROM " . BAN_TABLE . " WHERE user_id = ".$userdata['id'];
					$query = $db->query($sql);
				}else die_message($lang['System_message'], $lang_db->group(array($lang['Banned'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $fid), sprintf($lang['Nav_forum_viewforum'], $fid))), '');
			}
		}
	}
	$db->free_result($query);
// [PO-02] END <<<<

$query = $db->query("SELECT f.*, c.cat_id, c.cat_name FROM ( " . FORUM_TABLE . " f LEFT JOIN " . CAT_TABLE . " c ON c.cat_id = f.cat_id) WHERE f.forum_id = $fid");
$forum_row = $db->fetch_array($query);
if($db->num_rows($query) == 0 || $fid <= 0) die_message($lang['System_error'], $lang_db->group(array($lang['Forum_not_found'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
$db->free_result($query);

// ********************************************************************************
// [PO-03] Getting Sub-Forum data
// ********************************************************************************
	if($forum_row['forum_on'] > 0){
		$query = $db->query("SELECT * FROM " . FORUM_TABLE ." sf WHERE sf.forum_id = ".$forum_row['forum_on'], 'UNBUFFERED');
		$forum_on = $db->fetch_array($query);
		$db->free_result($query);
	}
// [PO-03] END <<<<

// ********************************************************************************
// [PO-04] Checking Forum Premission
// ********************************************************************************
	if(intval($userdata['access']) >= 0 && ($forum_row['forum_access'] > intval($userdata['access'])) && $forum_row['forum_access'] != 0 && !$is_mod) die_message($lang['System_error'], $lang_db->group(array($lang['Posting_error_topicaccess'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
	if($forum_row['forum_status'] == 1) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_closed'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
	if(auth_checker($forum_row['forum_reply_auth']) == 1) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_view_auth'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
	if(($forum_row['forum_group'] > 0 && $forum_row['forum_group_hide'] == 1 && !in_array($forum_row['forum_group'], explode(",", $userdata['group_id']))) && $userdata['userlevel'] != 1) die_message($lang['System_message'], $lang_db->group(array($lang['Forum_for_group'], $lang['Nav_index'], $lang['Nav_forum'])), '');
	if(!empty($forum_row['forum_password']) && $_SESSION['forum_password-'.$fid] != $forum_row['forum_password'] && !$is_mod) header("Location: ".$path."forum_password.php?fid=$fid");
	if($forum_on['forum_id'] > 0){
		if(($forum_on['forum_access'] > intval($userdata['access'])) && $forum_on['forum_access'] != 0 && !$is_mod) die_message($lang['System_error'], $lang_db->group(array($lang['Posting_error_topicaccess'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_on['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_on['forum_id']))), '');
		if($forum_on['forum_status'] == 1) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_closed'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_on['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_on['forum_id']))), '');
		if(auth_checker($forum_on['forum_reply_auth']) == 1) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_view_auth'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_on['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_on['forum_id']))), '');
		if(($forum_on['forum_group'] > 0 && $forum_on['forum_group_hide'] == 1 && !in_array($forum_on['forum_group'], explode(",", $userdata['group_id']))) && $userdata['userlevel'] != 1) die_message($lang['System_message'], $lang_db->group(array($lang['Forum_for_group'], $lang['Nav_index'], $lang['Nav_forum'])), '');
		if(!empty($forum_on['forum_password']) && $_SESSION['forum_password-'.$forum_on['forum_id']] != $forum_on['forum_password'] && !$is_mod) header("Location: ".$path."forum_password.php?fid=".$forum_on['forum_id']);
	}
// [PO-04] END <<<<

$cc_topic = $forum_row['forum_cc_topic'];
$cc_post = $forum_row['forum_cc_post'];
$access_topic = $forum_row['forum_access_topic'];
$access_post = $forum_row['forum_access_post'];

if($mode == 'newtopic' || $mode == 'edit' || $mode == 'newreply'){
	$tpl = new TemplatePower($path.$style_tpl."posting_body.tpl");
	$tpl->prepare();
}elseif($mode == 'delete'){
	$tpl = new TemplatePower($path.$style_tpl."post_delete_body.tpl");
	$tpl->prepare();
}

// ********************************************************************************
// [PO-05] Getting Topic data
// ********************************************************************************
	if($mode == 'edit' || $mode == 'newreply'){
		$query = $db->query("SELECT t.*, u.id, u.username, u.userlevel, p.post_content, p.post_id, p.payment_fee, user_id FROM (( " . TOPIC_TABLE . " t LEFT JOIN " . POST_TABLE . " p ON p.post_id = $pid) LEFT JOIN " . USERS_TABLE . " u ON u.id = p.user_id) WHERE t.topic_id = $tid");
		$re_topic = $db->fetch_array($query);
		if($db->num_rows($query) == 0) die_message($lang['System_error'], $lang_db->group(array($lang['Topic_not_found'], $lang['Nav_index'])), '');
		$db->free_result($query);
		if($post == 'frist' && $re_topic['frist_post'] == 1) $post = '';

		$up_forum = ($forum_on['forum_id'] > 0) ? ' &raquo; <a href="viewindex.php?fid='.$forum_on['forum_id'].'">'.$forum_on['forum_name'].$lang['Forum_portal'].'</a> &raquo; <a href="viewforum.php?fid='.$forum_on['forum_id'].'">'.$forum_on['forum_name'].'</a>' : '';
		$nav = '<a href="forum.php">'.$lang['Forum_portal'].'</a> &raquo; <a href="viewcat.php?cid='.$forum_row['cat_id'].'">'.decoding($forum_row['cat_name']).'</a>'.$up_forum.' &raquo; <a href="viewindex.php?fid='.$forum_row['forum_id'].'">'.$forum_row['forum_name'].$lang['Forum_portal'].'</a>';
	}
// [PO-05] END <<<<

if($mode == 'reply'){
	if(($forum_row['forum_group'] > 0 && $forum_row['forum_group_hide'] == 1 && !in_array($forum_row['forum_group'], explode(",", $userdata['group_id']))) && $userdata['userlevel'] != 1) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_reply_group'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
	if(auth_checker($forum_row['forum_reply_auth']) == 1) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_reply_auth'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
	if(time() - $post_time < $info['flood']){
		die_message($lang['System_message'], $lang_db->group(array(sprintf($lang['Flood_error'], $info['flood']), $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_reply'], $tid, $fid))), '');
	}else setcookie($cookiename.'_login[post_time]', '', time());

	$subject = ( isset($HTTP_POST_VARS['subject']) ) ? encoding($HTTP_POST_VARS['subject']) : '';
	$content = ( isset($HTTP_POST_VARS['content']) ) ? encoding($HTTP_POST_VARS['content'], 1) : '';
	$payment_fee = ( isset($HTTP_POST_VARS['payment_fee']) ) ? intval($HTTP_POST_VARS['payment_fee']) : '';

	if($info['post_verify'] == 1){
		$post_verify = ( isset($HTTP_POST_VARS['post_verify']) ) ? $HTTP_POST_VARS['post_verify'] : '';
		if($_SESSION['check_post_verify'] != $post_verify) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_post_verify_incorrect'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_reply'], $tid, $fid))), '');
	}

	// ********************************************************************************
	// [PO-06] Reply: Getting Last post position
	// ********************************************************************************
		$query = $db->query("SELECT * FROM " . TOPIC_TABLE . " WHERE topic_id = $tid", 'UNBUFFERED');
		$topic_row = $db->fetch_array($query);
		$db->free_result($query);
		$starter_var = floor(($topic_row['topic_post']+1)/$info['post_pre_page']);
		$starter = ($starter_var == 0) ? '' : '&amp;start='.$starter_var*$info['post_pre_page'];
	// [PO-06] END <<<<

	// ********************************************************************************
	// [PO-07] Reply: Checking Post
	// ********************************************************************************
		if($topic_row['topic_locked'] == 1 && !$is_mod) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_locked'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
		if($userdata['access'] < $topic_row['topic_access']) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_access'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
		if(empty($subject)) $subject = 'RE: '.decoding($topic_row['topic_subject']);
		if(empty($content)) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_content'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_reply'], $tid, $fid))), '');
		if($payment_fee < 0) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_payment_fee'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_reply'], $tid, $fid))), '');
	// [PO-07] END <<<<

	// ********************************************************************************
	// [PO-08] Reply: Uploading Attachment
	// ********************************************************************************
		if($_FILES['attachment']['tmp_name'] != ''){
			$attach_id = posting_attachment($_FILES['attachment'], $HTTP_POST_VARS['attach_hide'], $HTTP_POST_VARS['attach_access'], 'reply', $tid, $fid, $HTTP_POST_VARS['attach_desc']);
			$sql = "INSERT INTO " . POST_TABLE . " (post_subject, post_content, topic_id, user_id, post_time, forum_id, payment_fee, post_attach, post_ip) VALUES ('$subject', '$content', '$tid', '".$userdata['id']."', '".time()."', '$fid', '$payment_fee', '$attach_id', '$ip')";
		}else $sql = "INSERT INTO " . POST_TABLE . " (post_subject, post_content, topic_id, user_id, post_time, forum_id, payment_fee, post_ip) VALUES ('$subject', '$content', '$tid', '".$userdata['id']."', '".time()."', '$fid', '$payment_fee', '$ip')";
	// [PO-08] END <<<<

	if(!$query = $db->query($sql)){
		die_message($lang['System_error'], $lang_db->group(array($lang['Posting_reply_error'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_reply'], $tid, $fid))), '');
	}else{
		// ********************************************************************************
		// [PO-09] Reply: Updating Forum and Sub-Forum data
		// ********************************************************************************
			$post_id = $db->insert_id($sql);
			setcookie($cookiename.'_login[post_time]', time(), time()+604800);
			$query = $db->query("UPDATE " . INFO_TABLE . " SET info_value = info_value+1 WHERE info_name = 'archive'");
			$query = $db->query("UPDATE " . TOPIC_TABLE . " SET topic_post = topic_post + 1, topic_last_post_time = '".time()."', topic_last_post_user = '".$userdata['id']."' WHERE topic_id = '$tid'");
			$query = $db->query("UPDATE " . USERS_TABLE . " SET posts = posts + 1, cc = cc + $cc_post, access = access + $access_post WHERE id = ".$userdata['id']);
			$query = $db->query("UPDATE " . FORUM_TABLE . " SET forum_posts = forum_posts + 1, forum_last_post = $tid WHERE forum_id = ".$topic_row['forum_id']);
			if($forum_on['forum_id'] > 0) $query = $db->query("UPDATE " . FORUM_TABLE . " SET forum_posts = forum_posts + 1, forum_last_post = $tid WHERE forum_id = ".$forum_on['forum_id']);
		// [PO-09] END <<<<
		die_message($lang['System_message'], $lang_db->group(array($lang['Posting_reply_successful'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid))), '', "viewtopic.php?tid=".$tid.$starter."#".$post_id);
	}
}elseif($mode == 'newpost'){
	// ********************************************************************************
	// [PO-10] New Topic: Checking Flood and Forum Premission
	// ********************************************************************************
		if(($forum_row['forum_group'] > 0 && $forum_row['forum_group_hide'] == 1 && !in_array($forum_row['forum_group'], explode(",", $userdata['group_id']))) && $userdata['userlevel'] != 1) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_topic_group'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
		if(auth_checker($forum_row['forum_topic_auth']) == 1) die_message($lang['System_message'], $lang_db->group(array($lang['Forum_Error_topic_auth'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
		if(time() - $post_time < $info['flood']){
			die_message($lang['System_message'], $lang_db->group(array(sprintf($lang['Posting_Flood'], $info['flood']), $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_reply'], $tid, $fid))), '');
		}else setcookie($cookiename.'_login[post_time]', '', time());
	// [PO-10] END <<<<

	$subject = ( isset($HTTP_POST_VARS['subject']) ) ? encoding($HTTP_POST_VARS['subject']) : '';
	$content = ( isset($HTTP_POST_VARS['content']) ) ? encoding($HTTP_POST_VARS['content'], 1) : '';
	$access = ( isset($HTTP_POST_VARS['access']) ) ? trim($HTTP_POST_VARS['access']) : '';
	$payment_fee = ( isset($HTTP_POST_VARS['payment_fee']) ) ? intval($HTTP_POST_VARS['payment_fee']) : '';
	$bold = intval($HTTP_POST_VARS['bold']);
	$color = ( isset($HTTP_POST_VARS['color']) ) ? trim($HTTP_POST_VARS['color']) : '';
	$topic_tag = ( isset($HTTP_POST_VARS['topic_tag']) ) ? $HTTP_POST_VARS['topic_tag'] : '';
	$topic_class = ( isset($HTTP_POST_VARS['topic_class']) ) ? intval($HTTP_POST_VARS['topic_class']) : '';
	$subject = (empty($topic_tag)) ? $subject : $topic_tag.$subject;

	if($info['post_verify'] == 1){
		$post_verify = ( isset($HTTP_POST_VARS['post_verify']) ) ? $HTTP_POST_VARS['post_verify'] : '';
		if($_SESSION['check_post_verify'] != $post_verify) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_post_verify_incorrect'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_reply'], $tid, $fid))), '');
	}

	// ********************************************************************************
	// [PO-10] New Topic: Checking Post
	// ********************************************************************************
		if($bold == 1 && !$is_mod) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_bold'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_newtopic'], $tid, $fid))), '');
		if(!empty($color) && $color != 'nochange' && !$is_mod) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_color'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_newtopic'], $tid, $fid))), '');
		if($subject == '' || empty($subject)) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_subject'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_newtopic'], $tid, $fid))), '');
		if($access > $userdata['access']) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_user_access'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_newtopic'], $tid, $fid))), '');
		if($content == '' || empty($content)) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_content'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_newtopic'], $tid, $fid))), '');
		if($access < 0) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_access_negative'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_newtopic'], $tid, $fid))), '');
		if($payment_fee < 0) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_payment_fee'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_newtopic'], $tid, $fid))), '');
		$color = ($color == 'nochange') ? '' : $color;
	// [PO-10] END <<<<

	// ********************************************************************************
	// [PO-11] New Topic: Checking Poll
	// ********************************************************************************
		$poll_subject = ( isset($HTTP_POST_VARS['poll_subject']) ) ? encoding($HTTP_POST_VARS['poll_subject']) : '';
		for($i = 0; $i < $info['max_poll']; $i++){
			$object_vars = ( isset($HTTP_POST_VARS['poll'][$i]) ) ? encoding($HTTP_POST_VARS['poll'][$i]) : '';
			if(!empty($object_vars)) $object_insert .= (!empty($object_insert)) ? "\n".$object_vars : $object_vars;
		}
		if(!empty($object_insert) && empty($poll_subject)) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_poll_subject'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_newtopic'], $tid, $fid))), '');
		$poll_type = ( isset($HTTP_POST_VARS['poll_type']) ) ? intval($HTTP_POST_VARS['poll_type']) : 0;
	// [PO-11] END <<<<

	// ********************************************************************************
	// [PO-12] New Topic: Checking Topic Type
	// ********************************************************************************
		$locked = ( isset($HTTP_POST_VARS['locked']) ) ? 1 : 0;
		$type = ( isset($HTTP_POST_VARS['type']) ) ? $HTTP_POST_VARS['type'] : '';
		$knowledge = 0;
		if($type == 3){
			$type = 0;
			$knowledge = 1;
		}
	// [PO-12] END <<<<

	// ********************************************************************************
	// [PO-13] New Topic: Uploading Attachment
	// ********************************************************************************
		if($_FILES['attachment']['tmp_name'] != '') $attach_id = posting_attachment($_FILES['attachment'], $HTTP_POST_VARS['attach_hide'], $HTTP_POST_VARS['attach_access'], 'newtopic', $tid, $fid, $HTTP_POST_VARS['attach_desc']);
	// [PO-13] END <<<<

	$query = $db->query("INSERT INTO " . TOPIC_TABLE . " (topic_subject, topic_access, forum_id, topic_last_post_time, topic_last_post_user, topic_type, topic_knowledge, topic_locked, topic_bold, topic_color, poll_subject, poll_object, poll_type, topic_class) VALUES ('$subject', '$access', '$fid', '".time()."', '".$userdata['id']."', '$type', '$knowledge', '$locked', '$bold', '$color', '$poll_subject', '$object_insert', '$poll_type', '$topic_class')");
	$topic_id = $db->insert_id("INSERT INTO " . TOPIC_TABLE . " (topic_subject, topic_access, forum_id, topic_last_post_time, topic_last_post_user, topic_type, topic_knowledge, topic_locked, topic_bold, topic_color) VALUES ('$subject', '$access', '$fid', '".time()."', '".$userdata['id']."', '$type', '$knowledge', '$locked', '$bold', '$color')");

	if(!$query = $db->query("INSERT INTO " . POST_TABLE . " (post_subject, post_content, topic_id, user_id, post_time, forum_id, frist_post, payment_fee, post_attach, post_ip) VALUES ('$subject', '$content', '$topic_id', '".$userdata['id']."', '".time()."', '$fid', '1', '$payment_fee', '$attach_id', '$ip')")){
		die_message($lang['System_error'], $lang_db->group(array($lang['Posting_newtopic_error'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_newtopic'], $tid, $fid))), '');
	}else{
		// ********************************************************************************
		// [PO-14] New Topic: Updating Forum and Sub-Forum data
		// ********************************************************************************
			$post_id = $db->insert_id($sql);
			setcookie($cookiename.'_login[post_time]', time(), time()+604800);
			$query = $db->query("UPDATE " . INFO_TABLE . " SET info_value = info_value+1 WHERE info_name = 'archive'");
			$query = $db->query("UPDATE " . TOPIC_TABLE . " SET post_id = $post_id WHERE topic_id = $topic_id");
			$query = $db->query("UPDATE " . USERS_TABLE . " SET topics = topics + 1, posts = posts + 1, cc = cc + $cc_topic, access = access + $access_topic WHERE id = ".$userdata['id']);
			$query = $db->query("UPDATE " . FORUM_TABLE . " SET forum_topics = forum_topics + 1, forum_posts = forum_posts + 1, forum_last_post = $topic_id WHERE forum_id = $fid");
			if($forum_on['forum_id'] > 0) $query = $db->query("UPDATE " . FORUM_TABLE . " SET forum_topics = forum_topics + 1, forum_posts = forum_posts + 1, forum_last_post = $topic_id WHERE forum_id = ".$forum_on['forum_id']);
		// [PO-14] END <<<<
		die_message($lang['System_message'], $lang_db->group(array($lang['Posting_newtopic_successful'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $topic_id))), '', "viewtopic.php?tid=".$topic_id);
	}
}elseif($mode == 'edit' && $pid > 0){
	$query = $db->query("SELECT t.*, p.*, a.* FROM (( " . POST_TABLE . " p LEFT JOIN " . ATTACHMENT_TABLE . " a ON a.attach_id = p.post_attach ) LEFT JOIN " . TOPIC_TABLE . " t ON t.topic_id = p.topic_id) WHERE p.post_id = $pid", 'UNBUFFERED');
	$post_row = $db->fetch_array($query);
	$db->free_result($query);

	if($post_row['user_id'] != $userdata['id'] && !$is_mod) die_message($lang['System_error'], $lang_db->group(array($lang['Posting_error_edit'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid))), '');

	// ********************************************************************************
	// [PO-15] Edit: Checking Attachment
	// ********************************************************************************
		if($post_row['post_attach'] > 0){
			$tpl->newBlock('edit_attach');
			$tpl->assign(array(
				'L_ATTACH' => $lang['Attachment'],
				'S_ATTACH_DESC' => decoding($post_row['attach_desc']),
				'ATTACH_NAME' => sprintf($lang['Attachment_basename'], '<a href="file.php?aid='.$post_row['attach_id'].'">'.$post_row['attach_basename'].'</a>'),
				'ATTACH_DESC' => sprintf($lang['Attachment_desc'], decoding($post_row['attach_desc'])),
				'ATTACH_SIZE' => sprintf($lang['Attachment_size'], file_size($post_row['attach_size'])),
				'ATTACH_TIME' => sprintf($lang['Attachment_time'], gmdate('Y/m/d H:i', $post_row['attach_time']+gmtgen())),
				'ATTACH_HITS' => sprintf($lang['Attachment_hits'], $post_row['attach_hits']),
				'ATTACH_HIDE' => ($post_row['attach_hide'] == 1) ? 'checked="checked"' : '',
				'ATTACH_ACCESS' => intval($post_row['attach_access']),
				'ALLOW_TYPE' => allow_type(),
				'LOCKED' => ($post_row['topic_locked'] == 1) ? 'checked="checked"' : '',
				'MAX_SIZE' => sprintf($lang['Forum_Max_attach_size'], file_size($info['attachment_size'])),
				'L_ATTACH_FILE' => $lang['Attachment_file'],
				'L_ATTACH_DESC' => $lang['Attachment_description'],
				'L_ATTACH_ACCESS' => $lang['Attachment_access'],
				'L_ATTACH_HIDE' => $lang['Attachment_hide'],
				'L_ATTACH_UPDATE' => $lang['Attachment_update'],
				'L_DELETE' => $lang['Delete'],
			));
		}else{
			$tpl->newBlock('allow_attach');
			$tpl->assign(array(
				'ALLOW_TYPE' => allow_type(),
				'MAX_SIZE' => sprintf($lang['Posting_max_attach_size'], file_size($info['attachment_size'])),
				'L_ATTACH' => $lang['Attachment'],
				'L_ATTACH_ACCESS' => $lang['Attachment_access'],
				'L_ATTACH_HIDE' => $lang['Attachment_hide'],
				'L_ATTACH_DESC' => $lang['Attachment_description'],
			));
		}
		$tpl->gotoBlock('_ROOT');
	// [PO-15] END <<<<
}elseif($mode == 'delete' && $pid > 0){
	$query = $db->query("SELECT * FROM  " . POST_TABLE . " WHERE post_id = $pid", 'UNBUFFERED');
	$post_row = $db->fetch_array($query);
	$db->free_result($query);

	// ********************************************************************************
	// [PO-16] Delete: Checking Delete Premission and type
	// ********************************************************************************
		if($post_row['user_id'] != $userdata['id'] && !$is_mod) die_message($lang['System_error'], $lang_db->group(array($lang['Posting_delete_error'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid))), '');
		if(empty($fid) || empty($tid)) die_message($lang['System_error'], $lang_db->group(array($lang['Posting_id_error'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid))), '');
		$nav_delete = ($post == 'frist') ? sprintf($lang['Posting_apply_remove_frist'], $tid, $fid, $pid) : sprintf($lang['Posting_apply_remove'], $tid, $fid, $pid);
	// [PO-16] END <<<<

	if($is_mod){
		$tpl->newBlock("mod_choice");
		$tpl->assign(array(
			'DEFAULT' => $lang['Posting_remove_default'],
			'CUSTOM' => $lang['Posting_remove_custom'],
			'MOD_TITLE' => $lang['Posting_remove_mod_title'],
		));
		$tpl->gotoBlock("_ROOT");

		$tpl->newBlock("pm_choice");
		$tpl->assign(array(
			'PM_TITLE' => $lang['Posting_remove_pm_title'],
			'REASON' => $lang['Posting_remove_reason'],
		));
	}

	if($cc_topic == 0 && $access_topic == 0){
		$tpl->newBlock("no_decrease");
		$tpl->assign(array(
			'ACC_TOPIC' => $lang['Posting_remove_no_de'],
		));
	}

	if($cc_topic > 0 || $is_mod){
		$tpl->newBlock("decrease_cc");
		$tpl->assign(array(
			'CC_TOPIC' => $lang['Posting_remove_de_cctopic_title'],
			'CC_MSG' => sprintf($lang['Posting_remove_de_cctopic'], $cc_topic),
		));
		if($is_mod){
			$tpl->newBlock("decrease_cc_mod");
			$tpl->assign(array(
				'CC_TOPIC_MOD' => $lang['Posting_remove_de_cctopic_mod_title'],
			));
		}
	}

	if($access_topic > 0 || $is_mod){
		$tpl->newBlock("decrease_acc");
		$tpl->assign(array(
			'ACC_TOPIC' => $lang['Posting_remove_de_acctopic_title'],
			'ACC_MSG' => sprintf($lang['Posting_remove_de_acctopic'], $access_topic),
		));
		if($is_mod){
			$tpl->newBlock("decrease_acc_mod");
			$tpl->assign(array(
				'ACC_TOPIC_MOD' => $lang['Posting_remove_de_acctopic_mod_title'],
			));
		}
	}

	$first_tag = ($post == 'frist') ? '&amp;post=frist' : '';
	$tpl->gotoBlock("_ROOT");
	$tpl->assign(array(
		'TITLE' => $lang['Posting_remove_title'],
		'LOST_TITLE' => $lang['Posting_remove_lost_title'],
		'EXPLAIN' => ($is_mod) ? $lang['Posting_remove_mod'] : $lang['Posting_remove'],
		'L_YES' => $lang['Yes'],
		'L_NO' =>  $lang['No'],
		'TOPIC_URL' => "viewtopic.php?mode=remove&amp;tid=$tid",
		'A_ACTION' => "posting.php?mode=remove&amp;tid=$tid&amp;fid=$fid&amp;pid=$pid$first_tag"
	));
}elseif($mode == 'remove' && $pid > 0){
	if(empty($tid) || empty($fid)) die_message($lang['System_error'], $lang_db->group(array($lang['Posting_id_error'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid))), '');
	$query = $db->query("SELECT * FROM  " . TOPIC_TABLE . " WHERE topic_id = $tid", 'UNBUFFERED');
	$topic_row = $db->fetch_array($query);
	$db->free_result($query);

	$query = $db->query("SELECT * FROM  " . POST_TABLE . " WHERE post_id = $pid", 'UNBUFFERED');
	$post_row = $db->fetch_array($query);
	$db->free_result($query);

	$reason = ( isset($HTTP_POST_VARS['reason']) ) ? encoding($HTTP_POST_VARS['reason']) : '';
	$send_pm = ( isset($HTTP_POST_VARS['send_pm']) ) ? TRUE : FALSE;
	$lost_type = ( isset($HTTP_POST_VARS['lost_type']) ) ? intval($HTTP_POST_VARS['payment_fee']) : 1;
	$cc_topic_mod = ( isset($HTTP_POST_VARS['cc_topic_mod']) ) ? intval($HTTP_POST_VARS['cc_topic_mod']) : 0;
	$acc_topic_mod = ( isset($HTTP_POST_VARS['acc_topic_mod']) ) ? intval($HTTP_POST_VARS['acc_topic_mod']) : 1;
	$lost_cc = 0;
	$lost_access = 0;

	if($is_mod){
		if($lost_type == 1){
			$lost_cc = $cc_topic;
			$lost_access = $access_topic;
		}else{
			$lost_cc = $cc_topic_mod;
			$lost_access = $acc_topic_mod;
		}

		if($send_pm){
			$pm_content = sprintf($lang['Posting_remove_pm'], encoding($topic_row['topic_subject']));
			$pm_content .= (!empty($reason)) ? '<br /><br />'.sprintf($lang['Posting_remove_pm_reason'], $reason) : '';

			if(!$db->query("INSERT INTO " . PRIVATE_MSG_TABLE . " (to_user, from_user, pm_title, pm_content, pm_time) VALUES ('".$post_row['user_id']."', '".$userdata['id']."', '".$lang['Posting_remove_pm_subject']."', '$pm_content', '".time()."')")){
				die_message($lang['System_error'], $lang_db->group(array($lang['Cannot_send_pm'], $lang['Nav_index'])), '');
			}
		}
	}

	if($post == 'frist'){
		// ********************************************************************************
		// [PO-17] Start Delete: Getting Topict data
		// ********************************************************************************
			$query = $db->query("SELECT user_id FROM " . POST_TABLE . " WHERE topic_id = $tid", 'UNBUFFERED');
			$topic_info = $db->fetch_array($query);
			$db->free_result($query);
			if(($topic_info['user_id'] != $userdata['id']) && $userdata['userlevel'] > 10 && !$is_mod) die_message($lang['System_error'], $lang_db->group(array($lang['Posting_delete_error'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid))), '');
			$query = $db->query("DELETE FROM " . TOPIC_TABLE . " WHERE topic_id = ".$tid);
		// [PO-17] END <<<<

		// ********************************************************************************
		// [PO-18] Start Delete: Remove Attachment and Post data
		// ********************************************************************************
			$query = $db->query("SELECT p.*, a.* FROM (" . POST_TABLE . " p LEFT JOIN " . ATTACHMENT_TABLE . " a ON a.attach_id = p.post_attach) WHERE p.topic_id = $tid", 'UNBUFFERED');
			while($result = $db->fetch_array($query)){
				$delete_attachment_id .= (!empty($delete_attachment_id)) ? ",".$result['post_attach'] : $result['post_attach'];
				$delete_post_id .= (!empty($delete_post_id)) ? ",".$result['post_id'] : $result['post_id'];
				$deleted_post++;
				$update_user_post[$result['user_id']]++;
				@unlink("./attachment/".$result['attach_name']);
			}
			if(!empty($delete_attachment_id)) $query = $db->query("DELETE FROM " . ATTACHMENT_TABLE . " WHERE attach_id IN(".$delete_attachment_id.")");
			if(!empty($delete_post_id)) $query = $db->query("DELETE FROM " . POST_TABLE . " WHERE post_id IN(".$delete_post_id.")");
			$query = $db->query("UPDATE " . INFO_TABLE . " SET info_value = info_value - $deleted_post WHERE info_name = 'archive'");
		// [PO-18] END <<<<

		// ********************************************************************************
		// [PO-19] Start Delete: Update User data
		// ********************************************************************************
			if(count($update_user_post) > 0){
				foreach($update_user_post as $key => $var){
					if($var > 0) $query = $db->query("UPDATE " . USERS_TABLE . " SET topics = topics-1, posts = posts-$var, cc = cc-($lost_cc*$var), access = access - ($lost_access*$var) WHERE id = $key");
				}
			}
		// [PO-19] END <<<<
		$topic_deleted = 1;
		$post_delete = $deleted_post;
	}else{
		// ********************************************************************************
		// [PO-20] Start Delete: Getting Topict data
		// ********************************************************************************
			$query = $db->query("SELECT p.*, a.* FROM ( " . POST_TABLE . " p LEFT JOIN " . ATTACHMENT_TABLE . " a ON a.attach_id = p.post_attach ) WHERE p.post_id = $pid", 'UNBUFFERED');
			$post_info = $db->fetch_array($query);
			$db->free_result($query);
			if(($post_info['user_id'] != $userdata['id']) && $userdata['userlevel'] != 1 && !$is_mod) die_message($lang['System_error'], $lang_db->group(array($lang['Posting_delete_error'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid))), '');
		// [PO-20] END <<<<

		// ********************************************************************************
		// [PO-21] Start Delete: Remove Attachment and Post data
		// ********************************************************************************
			$query = $db->query("UPDATE " . INFO_TABLE . " SET info_value = info_value - 1 WHERE info_name = 'archive'");
			$query = $db->query("DELETE FROM " . POST_TABLE . " WHERE post_id = ".$pid);
			if(!empty($post_info['post_attach'])){
				$query = $db->query("DELETE FROM " . ATTACHMENT_TABLE . " WHERE attach_id = ".$post_info['post_attach']);
				@unlink("./attachment/".$post_info['attach_name']);
			}
		// [PO-21] END <<<<

		// ********************************************************************************
		// [PO-22] Start Delete: Update Topic and User data
		// ********************************************************************************
			$query = $db->query("SELECT post_id, post_time, user_id FROM  " . POST_TABLE . " WHERE topic_id = $tid ORDER BY post_time DESC LIMIT 0, 1");
			$last_post = $db->fetch_array($query);
			$last_post_id = $last_post['post_id'];
			$query = $db->query("UPDATE " . TOPIC_TABLE . " SET topic_post = topic_post-1, topic_last_post_time = ".$last_post['post_time'].", topic_last_post_user = ".$last_post['user_id']." WHERE topic_id = ".$tid);
			$query = $db->query("UPDATE " . USERS_TABLE . " SET posts = posts-1, cc = cc-$lost_cc, access = access-$lost_access WHERE id = ".$post_info['user_id']);
		// [PO-22] END <<<<
		$post_delete = 1;
		$topic_deleted = 0;
	}

	$query = $db->query("SELECT * FROM  " . TOPIC_TABLE . " WHERE forum_id = $fid ORDER BY topic_last_post_time DESC LIMIT 0, 1", 'UNBUFFERED');
	$last_topic = $db->fetch_array($query);
	if(!$query = $db->query("UPDATE " . FORUM_TABLE . " SET forum_posts = forum_posts - $post_delete, forum_topics = forum_topics - $topic_deleted, forum_last_post = '".$last_topic['topic_id']."' WHERE forum_id = ".$fid)){
		die_message($lang['System_error'], $lang_db->group(array($lang['Posting_remove_error'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
	}else{
		if($forum_on['forum_id'] > 0) $query = $db->query("UPDATE " . FORUM_TABLE . " SET forum_posts = forum_posts - $post_delete, forum_topics = forum_topics - $topic_deleted, forum_last_post = '".$last_topic['topic_id']."' WHERE forum_id = ".$forum_on['forum_id']);
		die_message($lang['System_message'], $lang_db->group(array($lang['Posting_remove_successful'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
	}
}elseif($mode == 'update' && $pid > 0){
	if(empty($fid) || empty($tid)) die_message($lang['System_error'], $lang_db->group(array($lang['Posting_id_error'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid))), '');

	$query = $db->query("SELECT p.*, a.* FROM ( " . POST_TABLE . " p LEFT JOIN " . ATTACHMENT_TABLE . " a ON a.attach_id = p.post_attach ) WHERE p.post_id = $pid", 'UNBUFFERED');
	$post_row = $db->fetch_array($query);
	$db->free_result($query);

	if(($post_row['user_id'] != $userdata['id']) && $userdata['userlevel'] != 1 && !$is_mod) die_message($lang['System_error'], $lang_db->group(array($lang['Posting_Delete_error'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid))), '');

	$subject = ( isset($HTTP_POST_VARS['subject']) ) ? encoding($HTTP_POST_VARS['subject']) : '';
	$content = ( isset($HTTP_POST_VARS['content']) ) ? encoding($HTTP_POST_VARS['content'], 1) : '';
	$access = ( isset($HTTP_POST_VARS['access']) ) ? intval($HTTP_POST_VARS['access']) : '';
	$delete_attach = ( isset($HTTP_POST_VARS['delete_attach']) ) ? TRUE : FALSE;
	$payment_fee = ( isset($HTTP_POST_VARS['payment_fee']) ) ? intval($HTTP_POST_VARS['payment_fee']) : '';
	$topic_tag = ( isset($HTTP_POST_VARS['topic_tag']) ) ? $HTTP_POST_VARS['topic_tag'] : '';
	$topic_class = ( isset($HTTP_POST_VARS['topic_class']) ) ? intval($HTTP_POST_VARS['topic_class']) : '';
	$subject = (empty($topic_tag)) ? $subject : $topic_tag.$subject;

	// ********************************************************************************
	// [PO-23] Update: Setting Topic Type and Style
	// ********************************************************************************
		$locked = ( isset($HTTP_POST_VARS['locked']) ) ? 1 : 0;
		if($is_mod){
			$type = ( isset($HTTP_POST_VARS['type']) ) ? $HTTP_POST_VARS['type'] : '';
			$knowledge = 0;
			if($type == 3){
				$type = 0;
				$knowledge = 1;
			}
		}else{
			$type = 'topic_type';
			$knowledge = 'topic_knowledge';
		}
		$bold = intval($HTTP_POST_VARS['bold']);
		$color = ( isset($HTTP_POST_VARS['color']) ) ? trim($HTTP_POST_VARS['color']) : '';
	// [PO-23] END <<<<

	// ********************************************************************************
	// [PO-24] Update: Checking Topic
	// ********************************************************************************
		if($bold == 1 && !$is_mod) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_bold'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_editpost'], $tid, $fid))), '');
		if(!empty($color) && $color != 'nochange' && !$is_mod) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_Error_color'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_editpost'], $tid, $fid))), '');
		if($subject == '' || empty($subject)) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_Eerror_subject'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_editpost'], $tid, $fid))), '');
		if($access > $userdata['access']) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_user_access'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_editpost'], $tid, $fid))), '');
		if($content == '' || empty($content)) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_content'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_editpost'], $tid, $fid))), '');
		if($access < 0 && $post == 'frist') die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_access_negative'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_editpost'], $tid, $fid))), '');
		if($payment_fee < 0) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_payment_fee'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_editpost'], $tid, $fid))), '');
		$color = ($color == 'nochange') ? 'topic_color' : "'".$color."'";
	// [PO-24] END <<<<

	// ********************************************************************************
	// [PO-25] Update: Checking Poll
	// ********************************************************************************
		$poll_reset = ( isset($HTTP_POST_VARS['poll_reset']) ) ? TRUE : FALSE;
		$poll_subject = ( isset($HTTP_POST_VARS['poll_subject']) ) ? encoding($HTTP_POST_VARS['poll_subject']) : '';
		for($i = 0; $i < $info['max_poll']; $i++){
			$object_vars = ( isset($HTTP_POST_VARS['poll'][$i]) ) ? encoding($HTTP_POST_VARS['poll'][$i]) : '';
			if(!empty($object_vars)) $object_insert .= (!empty($object_insert)) ? "\n".$object_vars : $object_vars;
		}
		if(!empty($object_insert) && empty($poll_subject)) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_poll_subject'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_newtopic'], $tid, $fid))), '');
		$poll_type = ( isset($HTTP_POST_VARS['poll_type']) ) ? intval($HTTP_POST_VARS['poll_type']) : 0;
		$reset_result = ($poll_reset) ? ", poll_result = ''" : '';
	// [PO-25] END <<<<

	// ********************************************************************************
	// [PO-26] Update: Update Attachment and Upload Attachment or Delete Attachment
	// ********************************************************************************
		$attach_hide = ( isset($HTTP_POST_VARS['attach_hide']) ) ? 1 : 0;
		$attach_access = ( isset($HTTP_POST_VARS['attach_access']) ) ? intval($HTTP_POST_VARS['attach_access']) : 0;
		$attach_desc = ( isset($HTTP_POST_VARS['attach_desc']) ) ? encoding($HTTP_POST_VARS['attach_desc']) : '';
		if($attach_access < 0) die_message($lang['System_error'], $lang_db->group(array($lang['Posting_error_attachment_access'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid), sprintf($lang['Nav_editpost'], $tid, $fid))), '');
		$remove_id = true;
		if($_FILES['attachment']['tmp_name'] != ''){
			$attach_id = posting_attachment($_FILES['attachment'], $HTTP_POST_VARS['attach_hide'], $HTTP_POST_VARS['attach_access'], 'edit', $tid, $fid, $HTTP_POST_VARS['attach_desc']);

			$update_attach = ', post_attach = '.$attach_id;
			$delete_attach = false;
			$remove_id = false;
		}elseif($_FILES['attachmentupdate']['tmp_name'] != ''){
			$attach_id = posting_attachment($_FILES['attachmentupdate'], $HTTP_POST_VARS['attach_hide'], $HTTP_POST_VARS['attach_access'], 'edit', $tid, $fid, $HTTP_POST_VARS['attach_desc']);

			$update_attach = ', post_attach = '.$attach_id;
			$delete_attach = true;
			$remove_id = false;
		}

		if($delete_attach){
			if($remove_id) $update_post_attach = ', post_attach = 0';
			$query = $db->query("DELETE FROM " . ATTACHMENT_TABLE . " WHERE attach_id = ".$post_row['post_attach']);
			@unlink("./attachment/".$post_row['attach_name']);
		}

		if($post_row['post_attach'] > 0) $query = $db->query("UPDATE " . ATTACHMENT_TABLE . " SET attach_hide = '$attach_hide', attach_access = '$attach_access', attach_desc = '$attach_desc' WHERE attach_id = ".$post_row['post_attach']);
	// [PO-26] END <<<<

	$starter = ceil(($forum_row['topic_post']+1)/$info['post_pre_page']);
	if(!$query = $db->query("UPDATE " . POST_TABLE . " SET post_subject = '$subject', payment_fee = '$payment_fee', post_content = '$content'$update_attach$update_post_attach WHERE post_id = $pid")){
		die_message($lang['System_error'], $lang_db->group(array($lang['Posting_update_error'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid))), '');
	}else{
		if($post == 'frist') $query = $db->query("UPDATE " . TOPIC_TABLE . " SET topic_subject = '$subject', topic_type = $type, topic_knowledge = $knowledge, topic_locked = '$locked', topic_access = '$access', topic_bold = '$bold', topic_color = $color, poll_subject = '$poll_subject', poll_object = '$object_insert', poll_type = '$poll_type', topic_class = '$topic_class'$reset_result WHERE topic_id = $tid");
		die_message($lang['System_message'], $lang_db->group(array($lang['Posting_update_successful'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']), sprintf($lang['Nav_viewtopic'], $tid))), '', "viewtopic.php?tid=".$tid);
	}
}elseif(empty($mode)) die_message($lang['System_error'], $lang_db->group(array($lang['Posting_attack'], $lang['Nav_index'])), '');

if($mode == 'newtopic' || $mode == 'edit' || $mode == 'newreply'){
	if($mode != 'edit'){
		// ********************************************************************************
		// [PO-27] Editing: Allow attachment
		// ********************************************************************************
			$tpl->newBlock('allow_attach');
			$tpl->assign(array(
				'ALLOW_TYPE' => allow_type(),
				'MAX_SIZE' => sprintf($lang['Posting_max_attach_size'], file_size($info['attachment_size'])),
				'L_ATTACH' => $lang['Attachment'],
				'L_ATTACH_ACCESS' => $lang['Attachment_access'],
				'L_ATTACH_HIDE' => $lang['Attachment_hide'],
				'L_ATTACH_DESC' => $lang['Attachment_description'],
			));
			$tpl->gotoBlock('_ROOT');
		// [PO-27] END <<<<
	}

	if($mode == 'newtopic'){
		$up_forum = ($forum_on['forum_id'] > 0) ? ' &raquo; <a href="viewindex.php?fid='.$forum_on['forum_id'].'">'.$forum_on['forum_name'].$lang['Forum_portal'].'</a> &raquo; <a href="viewforum.php?fid='.$forum_on['forum_id'].'">'.$forum_on['forum_name'].'</a>' : '';
		$nav = '<a href="forum.php">'.$lang['Forum_portal'].'</a> &raquo; <a href="viewcat.php?cid='.$forum_row['cat_id'].'">'.decoding($forum_row['cat_name']).'</a>'.$up_forum.' &raquo; <a href="viewindex.php?fid='.$forum_row['forum_id'].'">'.$forum_row['forum_name'].$lang['Forum_portal'].'</a>';
	}
	if($mode == 'edit' || $mode == 'newreply') $action .= '&amp;tid='.$tid;
	$action .= '&amp;fid='.$fid;

	if($mode == 'edit'){
		// ********************************************************************************
		// [PO-28] Editing: Getting Topic Data
		// ********************************************************************************
			$subject = decoding($post_row['post_subject']);
			$content = decoding($post_row['post_content'], '', 1);
			$payment = intval($post_row['payment_fee']);
			$form_action = ($post == 'frist') ? 'posting.php?mode=update&post=frist'.$action.'&amp;pid='.$pid : 'posting.php?mode=update'.$action.'&amp;pid='.$pid;
		// [PO-28] END <<<<

		// ********************************************************************************
		// [PO-29] Editing: Getting Topic Type
		// ********************************************************************************
			if($re_topic['topic_knowledge'] == 1){
				$type_knowledge = 'checked="checked"';
			}else{
				$type_normal = ($re_topic['topic_type'] == 0) ? 'checked="checked"' : '';
				$type_sticty = ($re_topic['topic_type'] == 1) ? 'checked="checked"' : '';
				$type_announce = ($re_topic['topic_type'] == 2) ? 'checked="checked"' : '';
			}
		// [PO-29] END <<<<

		if($post == 'frist'){
			// ********************************************************************************
			// [PO-30] Editing: Allow Access Topic
			// ********************************************************************************
				$tpl->newBlock('access');
				$tpl->assign(array(
					'L_ACCESS' => $lang['Posting_access'],
					'L_TOPIC_LOCK' => $lang['Posting_lock_topic'],
					'ACCESS' => intval($re_topic['topic_access']),
					'TOPIC_LOCKED' => ($re_topic['topic_locked'] == 1) ? 'checked="checked"' : '',
				));
				$tpl->gotoBlock('_ROOT');
			// [PO-30] END <<<<

			// ********************************************************************************
			// [PO-31] Editing: Topic Type/Class
			// ********************************************************************************
				if(file_exists($path.'sqlcache/type_'.$fid.'_data.php')){
					$type_date = $cache->load_type_cache($fid);
				}else{
					$query = $db->query("SELECT * FROM ".TYPE_TABLE." WHERE forum_id = $fid", 'UNBUFFERED');
					while($result = $db->fetch_array($query)){
						$cache_type_data[] = $type_date[] = $result;
					}
					$cache->make_type_cache($cache_type_data, $fid);
				}

				if(!empty($type_date)){
					$s_type = '<select name="topic_class">';
					$s_type .= '<option value="0">'.$lang['Type_no_class'].'</option>';
					foreach($type_date as $var){
						$s = ($re_topic['topic_class'] == $var['type_id']) ? ' selected="selected"' : '';
						$s_type .= '<option value="'.$var['type_id'].'"'.$s.'>'.$var['type_name'].'</option>';
					}
					$s_type .= '</select>';
				}

				$tpl->newBlock('class');
				$tpl->assign(array(
					'L_CLASS' => $lang['Type_title'],
					'S_TYPE' => $s_type,
				));
				$tpl->gotoBlock('_ROOT');
			// [PO-31] END <<<<

			// ********************************************************************************
			// [PO-32] Editing: Getting Poll data and Output Form
			// ********************************************************************************
				if($info['max_poll'] > 0 && auth_checker($forum_row['forum_poll_auth']) == 0){
					$tpl->newBlock('poll');
					$tpl->assign(array(
						'L_POLL' => $lang['Posting_poll'],
						'L_POLL_SUBJECT' => $lang['Posting_poll_subject'],
						'L_POLL_TYPE' => $lang['Posting_poll_type'],
						'POLL_SUBJECT' => (!empty($HTTP_POST_VARS['poll_subject'])) ? decoding($HTTP_POST_VARS['poll_subject']) : decoding($re_topic['poll_subject']),
						'L_POLL_SINGLE' => $lang['Posting_single'],
						'L_POLL_MULTIPLE' => $lang['Posting_multiple'],
						'POLL_SINGLE' => ($re_topic['poll_type'] == 0 || $HTTP_POST_VARS['poll_type'] == 0) ? 'checked="checked"' : '',
						'POLL_MULTIPLE' => ($re_topic['poll_type'] == 1 || $HTTP_POST_VARS['poll_type'] == 1) ? 'checked="checked"' : '',
						'ADD_POLL' => '<input type="submit" onClick="document.topic.action=\'posting.php?mode=edit&amp;tid='.$tid.'&amp;pid='.$pid.'&amp;post=frist&amp;fid='.$fid.'\'" value="'.$lang['Add'].'" name="edit_poll">',
					));
					$tpl->newBlock('poll_reset');
					$tpl->assign(array(
						'L_POLL_RESET' => $lang['Posting_poll_reset'],
					));

					$tpl->gotoBlock('poll');
					if(!empty($HTTP_POST_VARS['poll'])){
						foreach($HTTP_POST_VARS['poll'] as $var){
							if(empty($var)) continue;
							if($i >= $info['max_poll']) continue;
							$tpl->newBlock('poll_row');
							$tpl->assign(array(
								'NUMBER' => $i+1,
								'POLL_INPUT' => '<input type="text" name="poll['.$i.']" value="'.decoding($var).'" size="30" maxlength="255">',
							));
							$i++;
						}
					}else{
						$poll_object = @explode("\n",$re_topic['poll_object']);
						if(!empty($re_topic['poll_object'])){
							for($i = 0; $i < $info['max_poll'] && $i < count($poll_object); $i++){
								$tpl->newBlock('poll_row');
								$tpl->assign(array(
									'NUMBER' => $i+1,
									'POLL_INPUT' => '<input type="text" name="poll['.$i.']" value="'.decoding($poll_object[$i]).'" size="30" maxlength="255">',
								));
							}
						}
					}

					if($i < $info['max_poll']){
						$tpl->newBlock('poll_row');
						$tpl->assign(array(
							'NUMBER' => $i+1,
							'POLL_INPUT' => '<input type="text" name="poll['.$i.']" value="" size="30" maxlength="255">',
						));
					}
					$tpl->gotoBlock('_ROOT');
				}
			// [PO-32] END <<<<
		}

		// ********************************************************************************
		// [PO-33] Editing: Moderation Mode
		// ********************************************************************************
			if($is_mod){
				$tpl->gotoBlock('_ROOT');
				$tpl->newBlock('type');
				$tpl->assign(array(
					'L_TYPE' => $lang['Posting_type'],
					'L_NORMAL' => $lang['Type_normal'],
					'L_STICKY' => $lang['Type_sticky'],
					'L_ANNOUNCE' => $lang['Type_announce'],
					'L_KNOWLEDGE' => $lang['Type_knowledge'],
					'TYPE_NORMAL' => $type_normal,
					'TYPE_STICKY' => $type_sticty,
					'TYPE_ANNOUNCE' => $type_announce,
					'TYPE_KNOWLEDGE' => $type_knowledge,
				));
				$tpl->gotoBlock('_ROOT');

				$tpl->newBlock('style');
				$tpl->assign(array(
					'L_NO_CHANGE' => $lang['Posting_nochange'],
					'L_BOLD' => $lang['Posting_bold'],
					'L_COLOR' => $lang['Posting_color'],
					'L_RESET_COLOR' => $lang['Posting_reset_color'],
					'L_YES' => $lang['Yes'],
					'L_NO' => $lang['No'],
					'BOLD_YES' => ($re_topic['topic_bold'] == 1) ? 'checked="checked"' : '',
					'BOLD_NO' => ($re_topic['topic_bold'] == 0) ? 'checked="checked"' : '',
				));
				$tpl->gotoBlock('_ROOT');
			}
		// [PO-33] END <<<<
	}elseif($mode == 'newtopic'){
		// ********************************************************************************
		// [PO-34] New Topic: Getting Posting Premission
		// ********************************************************************************
			if(($forum_row['forum_group'] > 0 && $forum_row['forum_group_hide'] == 1 && !in_array($forum_row['forum_group'], explode(",", $userdata['group_id']))) && $userdata['userlevel'] != 1) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_topic_group'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
			if(auth_checker($forum_row['forum_topic_auth']) == 1) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_topic_auth'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
		// [PO-34] END <<<<

		// ********************************************************************************
		// [PO-35] New Topic: Getting Posting Premission
		// ********************************************************************************
			$tpl->newBlock('access');
			$tpl->assign(array(
				'L_ACCESS' => $lang['Posting_access'],
				'L_TOPIC_LOCK' => $lang['Posting_lock_topic'],
				'ACCESS' => intval($re_topic['topic_access']),
			));
		// [PO-35] END <<<<

		// ********************************************************************************
		// [PO-36] New Topic: Topic Type/Class
		// ********************************************************************************
			if(file_exists($path.'sqlcache/type_'.$fid.'_data.php')){
				$type_date = $cache->load_type_cache($fid);
			}else{
				$query = $db->query("SELECT * FROM ".TYPE_TABLE." WHERE forum_id = $fid", 'UNBUFFERED');
				while($result = $db->fetch_array($query)){
					$cache_type_data[] = $type_date[] = $result;
				}
				$cache->make_type_cache($cache_type_data, $fid);
			}

			if(!empty($type_date)){
				$s_type = '<select name="topic_class">';
				$s_type .= '<option value="0">'.$lang['Type_no_class'].'</option>';
				foreach($type_date as $var){
					$s_type .= '<option value="'.$var['type_id'].'">'.$var['type_name'].'</option>';
				}
				$s_type .= '</select>';
			}

			$tpl->newBlock('class');
			$tpl->assign(array(
				'L_CLASS' => $lang['Type_title'],
				'S_TYPE' => $s_type,
			));
			$tpl->gotoBlock('_ROOT');
		// [PO-36] END <<<<

		$subject = decoding($post_row['post_subject']);
		$form_action = 'posting.php?mode=newpost'.$action;
		// ********************************************************************************
		// [PO-37] New Topic: Moderation Mode
		// ********************************************************************************
			if($is_mod){
				$tpl->gotoBlock('_ROOT');
				$tpl->newBlock('type');
				$tpl->assign(array(
					'L_TYPE' => $lang['Posting_type'],
					'L_NORMAL' => $lang['Type_normal'],
					'L_STICKY' => $lang['Type_sticky'],
					'L_ANNOUNCE' => $lang['Type_announce'],
					'L_KNOWLEDGE' => $lang['Type_knowledge'],
					'TYPE_NORMAL' => 'checked = "checked"',
				));
				$tpl->gotoBlock('_ROOT');

				$tpl->newBlock('style');
				$tpl->assign(array(
					'L_NO_CHANGE' => $lang['Posting_nochange'],
					'L_RESET_COLOR' => $lang['Posting_reset_color'],
					'L_BOLD' => $lang['Posting_bold'],
					'L_COLOR' => $lang['Posting_color'],
					'L_YES' => $lang['Yes'],
					'L_NO' => $lang['No'],
					'BOLD_NO' => 'checked="checked"',
				));
				$tpl->gotoBlock('_ROOT');
			}
		// [PO-37] END <<<<

		// ********************************************************************************
		// [PO-38] New Topic: Getting Poll data and Output Form
		// ********************************************************************************
			if($info['max_poll'] > 0 && auth_checker($forum_row['forum_poll_auth']) == 0){
				$tpl->newBlock('poll');
				$tpl->assign(array(
					'L_POLL' => $lang['Posting_poll'],
					'L_POLL_SUBJECT' => $lang['Posting_poll_subject'],
					'L_POLL_TYPE' => $lang['Posting_poll_type'],
					'L_POLL_SINGLE' => $lang['Posting_single'],
					'L_POLL_MULTIPLE' => $lang['Posting_multiple'],
					'POLL_SINGLE' => 'checked="checked"',
					'POLL_SUBJECT' => (!empty($HTTP_POST_VARS['poll_subject'])) ? decoding($HTTP_POST_VARS['poll_subject']) : '',
					'POLL_SINGLE' => ($HTTP_POST_VARS['poll_type'] == 0) ? 'checked="checked"' : '',
					'POLL_MULTIPLE' => ($HTTP_POST_VARS['poll_type'] == 1) ? 'checked="checked"' : '',
					'ADD_POLL' => '<input type="submit" onClick="document.topic.action=\'posting.php?mode=newtopic&amp;tid='.$tid.'&amp;pid='.$pid.'&amp;post=frist&amp;fid='.$fid.'\'" value="'.$lang['Add'].'" name="edit_poll">',
				));

				if(!empty($HTTP_POST_VARS['poll'])){
					foreach($HTTP_POST_VARS['poll'] as $var){
						if(empty($var)) continue;
						if($i >= $info['max_poll']) continue;
						$tpl->newBlock('poll_row');
						$tpl->assign(array(
							'NUMBER' => $i+1,
							'POLL_INPUT' => '<input type="text" name="poll['.$i.']" value="'.decoding($var).'" size="30" maxlength="255">',
						));
						$i++;
					}
				}
				if($i < $info['max_poll']){
					$tpl->newBlock('poll_row');
					$tpl->assign(array(
						'NUMBER' => $i+1,
						'POLL_INPUT' => '<input type="text" name="poll['.$i.']" value="" size="30" maxlength="255">',
					));
				}
				$tpl->gotoBlock('_ROOT');
			}
		// [PO-38] END <<<<

		if($info['post_verify'] == 1){
			$_SESSION['check_post_verify'] = str_pad(rand(0, 9999), 4, "0", STR_PAD_LEFT);
			$tpl->newBlock('post_verify');
			$tpl->assign(array(
				'L_POST_VERIFY' => $lang['Posting_post_verify'],
				'POST_VERIFY' => $_SESSION['check_post_verify'],
			));
			$tpl->gotoBlock('_ROOT');
		}
	}else{
		// ********************************************************************************
		// [PO-39] Reply: Getting Posting Premission
		// ********************************************************************************
			if(($forum_row['forum_group'] > 0 && $forum_row['forum_group_hide'] == 1 && !in_array($forum_row['forum_group'], explode(",", $userdata['group_id']))) && $userdata['userlevel'] != 1) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_reply_group'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
			if(auth_checker($forum_row['forum_reply_auth']) == 1) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_reply_auth'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
			if($re_topic['topic_locked'] == 1 && !$is_mod) die_message($lang['System_message'], $lang_db->group(array($lang['Posting_error_locked'], $lang['Nav_index'], sprintf($lang['Nav_forum_portal'], $forum_row['forum_id']), sprintf($lang['Nav_forum_viewforum'], $forum_row['forum_id']))), '');
		// [PO-39] END <<<<

		// ********************************************************************************
		// [PO-40] Reply: Getting Post data
		// ********************************************************************************
			$editing = ($quote) ? 1 : 0;
			$username_inedit = ($re_topic['user_id'] == -1) ? $lang['Level_guest'] : $re_topic['username'];
			$subject = 'RE: '.decoding($re_topic['topic_subject']);
			if($re_topic['payment_fee'] > 0){
				$content = '[quote="'.$username_inedit.'"]'.$lang['Post_payment_no_quote'].'[/quote]';
			}else $content = ($quote) ? '[quote="'.$username_inedit.'"]'.decoding($re_topic['post_content'], $editing, 1).'[/quote]' : decoding($re_topic['post_content'], 1);
			$form_action = ($post == 'frist') ? 'posting.php?mode=reply&post=frist'.$action : 'posting.php?mode=reply'.$action;
		// [PO-40] END <<<<

		if($info['post_verify'] == 1){
			$_SESSION['check_post_verify'] = str_pad(rand(0, 9999), 4, "0", STR_PAD_LEFT);
			$tpl->newBlock('post_verify');
			$tpl->assign(array(
				'L_POST_VERIFY' => $lang['Posting_post_verify'],
				'POST_VERIFY' => $_SESSION['check_post_verify'],
			));
			$tpl->gotoBlock('_ROOT');
		}
	}

	require($path.'includes/smile.php');
	$tpl->gotoBlock('_ROOT');
	$tpl->assign(array(
		'ACTION' => $form_action,

		'SUBJECT' => (!empty($HTTP_POST_VARS['subject'])) ? decoding($HTTP_POST_VARS['subject']) : $subject,
		'CONTENT' => (!empty($HTTP_POST_VARS['content'])) ? decoding($HTTP_POST_VARS['content']) : $content,
		'PAYMENT' => $payment,
		'POST_SMILE' => smile_gen(0, $fid),
		'POST_HIDE_SMILE' => smile_gen(1, $fid),
		'NAV' => $nav,
		'TOPIC_TAG' => ($post == 'frist') ? topic_tag($forum_row['topic_tag']) : '',
		'L_POSTING_SETTING' => $lang['Posting_setting'],
		'L_POSTING' => $lang['Posting_title'],
		'L_PAYMENT' => $lang['Posting_payment'],
		'L_SUBMIT' => $lang['Submit'],
		'L_SUBJECT' => $lang['Subject'],
		'L_BBCODE' => $lang['BBcode'],
		'L_POST_SMILE' => $lang['Smile'],
		'L_CONTENT' => $lang['Content'],
		'L_REPLY' => $lang['Reply'],
		'L_CONTENT_EMPTY' => $lang['Posting_content_empty'],
		'L_SHOW_SMILE' => $lang['Posting_show_smile'],
		'L_HIDE_SMILE' => $lang['Posting_hide_smile'],
		'L_INSERT' => $lang['Posting_insert'],
	));
}

$tpl->printToScreen();

require($path.'includes/page_footer.php');
?>