<?php

/******************************************************************************
 * iLogin - Member login system                                               *
 *                                                                            *
 * Visit the iLogin homepage at http://www.z-host.com/scripts/ilogin          *
 *                                                                            *
 * Copyright (C) 2003 Ian Willis. All rights reserved.                        *
 *                                                                            *
 * This script is free to use for non-commercial individual use.              *
 *                                                                            *
 * Use of this script by companies or on commercial web sites requires a      *
 * commercial license. For commercial licence details, please visit:          *
 *     http://www.z-host.com/scripts/ilogin                                   *
 *                                                                            *
 ******************************************************************************/

require_once("ilogin_core.inc.php");

$action = ilogin_get_post("action");

if ("$action" == "edit")
{
    $ilogin_title = "iLogin - Edit Details";
}
else if ("$action" == "update")
{
    $ilogin_title = "iLogin - Update";
}
else if ("$action" == "delete")
{
    $ilogin_title = "iLogin - Update";
}
else if ("$action" == "updatepasswd")
{
    $ilogin_title = "iLogin - Update .htpasswd";
}
else
{
    $action = "admin";
    $ilogin_title = "iLogin - Administration";
}

$ilogin_password = "";
if (isset($_POST['ilogin_password']))
{
    $ilogin_password = md5($_POST['ilogin_password']);

    /* Remember the password in a session cookie */
    setcookie("iLoginAdmin", $ilogin_password);
}
else if (isset($_COOKIE['iLoginAdmin']))
{
    $ilogin_password = $_COOKIE['iLoginAdmin'];
}

echo <<<EOF
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML>
<HEAD>
<TITLE>$ilogin_title</TITLE>
<META HTTP-EQUIV="Content-Type" content="text/html; charset=utf-8">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<META NAME="copyright" CONTENT="Copyright Ian Willis. All rights reserved.">
</HEAD>

<BODY BGCOLOR="#ffffc0" TEXT="#000000">

<CENTER>

<H1>$ilogin_title</H1>

EOF;

/* Check password cookie */

if (md5($login_adminPassword) != $ilogin_password)
{
    if (isset($_POST['ilogin_password']))
    {
        sleep(5);    /* Delay to help prevent password cracking */
        echo "<P>Incorrect password\n";
    }

    /* Prompt for admin password */
    echo <<<EOF

<P>Please enter your iLogin administrator password:
<TABLE BGCOLOR="#c0ffff" CELLPADDING="5">
<FORM method="post" action="$_SERVER[PHP_SELF]">
<TR>
<TD><B>iLogin Administrator Password:</B></TD>
<TD><INPUT MAXLENGTH="20" TYPE="password" NAME="ilogin_password" SIZE="20"></TD>
</TR>

<TR>
<TD COLSPAN=2 ALIGN="CENTER"><INPUT TYPE="submit" VALUE="OK"></TD>
</TR>
</FORM>
</TABLE>

EOF;

/*************************************************************************
 * The following line must not be removed or commented out. Doing so     *
 * invalidates your license to use iLogin.                               *
 *************************************************************************/
echo "<P>Powered&nbsp;by&nbsp;<a href=\"http://www.z-host.com/scripts/ilogin\" target=\"_blank\">iLogin</a><BR>\n";

echo <<<EOF

</CENTER>

</BODY>
</HTML>

EOF;
    exit;
}

if ("$action" == "admin")
{
    $result = mysql_query ("SELECT * FROM $ilogin_table", $ilogin_db);

    echo <<<EOF
<P>The following users are registered:
<P>
<TABLE BORDER=1>
<TR><TH>Username</TH><TH>Actual Name</TH><TH>Email</TH><TH>Password</TH><TH>Status</TH><TH>Edit</TH></TR>
EOF;
    while ($item = mysql_fetch_object($result))
    {
        $edit = "<A HREF=\"$PHP_SELF?action=edit&username=$item->username\">Edit</A>";
        $delete = "<A HREF=\"$PHP_SELF?action=delete&username=$item->username\">Delete</A>";
        echo "<TR><TD>$item->username</TD><TD>$item->firstname $item->lastname</TD><TD>$item->email</TD><TD>$item->password</TD><TD>$item->status</TD><TD>$edit</TD></TR>";
    }
    echo <<<EOF
</TABLE>

<P><A HREF="$PHP_SELF?action=updatepasswd">Click here to update the .htpasswd file.</A>
EOF;
}
else if ("$action" == "edit")
{
    $username = ilogin_get_post("username");
    $result = mysql_query ("SELECT * FROM $ilogin_table WHERE username='$username'", $ilogin_db);

    if (($result) && ($item = mysql_fetch_object($result)))
    {
        echo <<<EOF

<FORM ACTION="$PHP_SELF" METHOD="POST">
  <CENTER>
    <TABLE BORDER="0" WIDTH="350" NOWRAP="NOWRAP">
      <TR>
        <TD><B>Editing User :$item->username</TD></TR>
      </TR>

      <TR><TD><INPUT TYPE="TEXT" NAME="firstname" VALUE="$item->firstname">First Name</TD></TR>
      <TR><TD><INPUT TYPE="TEXT" NAME="lastname" VALUE="$item->lastname">Last Name</TD></TR>
      <TR><TD><INPUT TYPE="TEXT" NAME="email" VALUE="$item->email">E-Mail Address</TD></TR>
      <TR><TD><B>Change Password</B><BR>
              <INPUT TYPE="password" NAME="password" VALUE="">Password<BR>
              <INPUT TYPE="password" NAME="password_confirm" VALUE="">Verify Password</TD></TR>
      <TR><TD><B>Postal Address</B><BR>
              <INPUT TYPE="text" NAME="addr1" VALUE="$item->addr1">Address Line 1<BR>
              <INPUT TYPE="text" NAME="addr2" VALUE="$item->addr2">Address Line 2<BR>
              <INPUT TYPE="text" NAME="addr3" VALUE="$item->addr3">City<BR>
              <INPUT TYPE="text" NAME="addr4" VALUE="$item->addr4">State/Province/County<BR>
              <INPUT TYPE="text" NAME="addr5" VALUE="$item->addr5">Postal/Zip Code<BR>
              <INPUT TYPE="text" NAME="addr6" VALUE="$item->addr6">Country</TD></TR>
      <TR><TD><B>Other Details</B><BR>
              <INPUT TYPE="text" NAME="phone" VALUE="$item->phone">Telephone Number<BR>
              <INPUT TYPE="text" NAME="icq" VALUE="$item->icq">ICQ</TD></TR>
      <TR><TD><B>Status</B><BR>
              <SELECT NAME="status">

EOF;

echo "<OPTION";
if ($item->status == "New") echo " SELECTED";
echo ">New";

echo "<OPTION";
if ($item->status == "Active") echo " SELECTED";
echo ">Active";

echo "<OPTION";
if ($item->status == "Disabled") echo " SELECTED";
echo ">Disabled";

echo <<<EOF
              </SELECT>
      <TR><TD><INPUT TYPE="SUBMIT" NAME="process" VALUE="- Update -"><INPUT TYPE="RESET" NAME=""></TD></TR>
    </TABLE>
  </CENTER>
  <INPUT TYPE="hidden" NAME="action" VALUE="update">
  <INPUT TYPE="hidden" NAME="username" VALUE="$item->username">
</FORM>

<P><A HREF="$PHP_SELF?action=delete&username=$username">Delete this user</A> <FONT color="red">Warning - User will be permanently deleted</FONT>
<P><A HREF="$PHP_SELF">Return to Main Admin Page</A>
EOF;
    }
}
else if ("$action" == "update")
{
    $user = strip_tags(strtolower(ilogin_get_post("username")));
    $pass = strtolower(ilogin_get_post("password"));
    $pass_confirm = strtolower(ilogin_get_post("password_confirm"));
    $firstname = strip_tags(ilogin_get_post("firstname"));
    $lastname = strip_tags(ilogin_get_post("lastname"));
    $email = ilogin_get_post("email");
    $addr1 = ilogin_get_post("addr1");
    $addr2 = ilogin_get_post("addr2");
    $addr3 = ilogin_get_post("addr3");
    $addr4 = ilogin_get_post("addr4");
    $addr5 = ilogin_get_post("addr5");
    $addr6 = ilogin_get_post("addr6");
    $phone = ilogin_get_post("phone");
    $status = ilogin_get_post("status");
    $icq = ilogin_get_post("icq");

    if (("$pass" != "") || ("$pass_confirm" != ""))
    {
        if ("$pass" != "$pass_confirm")
        {
            echo "<P>ERROR: Passwords do not match!";
        }
        else
        {
            if ($ilogin_demoMode)
            {
                echo "<P>In Demo Mode - Password will not be updated.";
            }
            else
            {
                mysql_query("UPDATE $ilogin_table SET " .
                            "password='" . mysql_escape_string($password) . "' " .
                            "WHERE username='$user'", $ilogin_db);
                echo "<P>Password updated.";
            }
        }
    }

    if ($ilogin_demoMode)
    {
        echo "<P>In Demo Mode - User details will not be updated.";
    }
    else
    {
        mysql_query("UPDATE $ilogin_table SET " .
                    "status='" . mysql_escape_string($status) . "', " .
                    "firstname='" . mysql_escape_string($firstname) . "', " .
                    "lastname='" . mysql_escape_string($lastname) . "', " .
                    "email='" . mysql_escape_string($email) . "', " .
                    "addr1='" . mysql_escape_string($addr1) . "', " .
                    "addr2='" . mysql_escape_string($addr2) . "', " .
                    "addr3='" . mysql_escape_string($addr3) . "', " .
                    "addr4='" . mysql_escape_string($addr4) . "', " .
                    "addr5='" . mysql_escape_string($addr5) . "', " .
                    "addr6='" . mysql_escape_string($addr6) . "', " .
                    "phone='" . mysql_escape_string($phone) . "', " .
                    "icq='" . mysql_escape_string($icq) . "' " .
                    "WHERE username='$user'", $ilogin_db);

        if (ilogin_write_htpasswd())
        {
            echo "<P>User updated.";
        }
        else
        {
            echo "<P>An error ocurred. Password file could not be updated.";
        }
    }

    echo <<<EOF
<P><A HREF="$PHP_SELF">Return to Main Admin Page</A>
<P><A HREF="$PHP_SELF?action=edit&username=$user">Return to Editing $user</A>

EOF;
}
else if ("$action" == "delete")
{
    $user = strip_tags(strtolower(ilogin_get_post("username")));

    if ($ilogin_demoMode)
    {
        echo "<P>In demo mode. User $user will not be deleted.";
    }
    else
    {
        mysql_query("DELETE FROM $ilogin_table WHERE username='$user'", $ilogin_db);
        if (ilogin_write_htpasswd())
        {
            echo "<P>User $user deleted.";
        }
        else
        {
            echo "<P>User could not be deleted from .htpasswd file.";
        }
    }
    echo <<<EOF
<P><A HREF="$PHP_SELF">Return to Main Admin Page</A>

EOF;
}
else if ("$action" == "updatepasswd")
{
    if ($ilogin_demoMode)
    {
        echo "<P>In demo mode. File $ilogin_htpasswd_path will not be updated.";
    }
    else
    {
        if (ilogin_write_htpasswd())
        {
            echo "<P>File $ilogin_htpasswd_path updated.";
        }
        else
        {
            echo "<P>File $ilogin_htpasswd_path could not be updated.";
        }
    }
echo <<<EOF
<P><A HREF="$PHP_SELF">Return to Main Admin Page</A>
EOF;
}

/*************************************************************************
 * The following line must not be removed or commented out. Doing so     *
 * invalidates your license to use iLogin.                               *
 *************************************************************************/
echo "<P>Powered&nbsp;by&nbsp;<a href=\"http://www.z-host.com/scripts/ilogin\" target=\"_blank\">iLogin</a><BR>\n";

echo <<<EOF

</CENTER>

</BODY>
</HTML>

EOF;

if (!$ilogin_demoMode)
{
    mysql_close($ilogin_db);
}

?>
