<?php

/******************************************************************************
 * iLogin - Member login system                                               *
 *                                                                            *
 * Visit the iLogin homepage at http://www.z-host.com/scripts/ilogin          *
 *                                                                            *
 * Copyright (C) 2003 Ian Willis. All rights reserved.                        *
 *                                                                            *
 * This script is free to use for non-commercial individual use.              *
 *                                                                            *
 * Use of this script by companies or on commercial web sites requires a      *
 * commercial license. For commercial licence details, please visit:          *
 *     http://www.z-host.com/scripts/ilogin                                   *
 *                                                                            *
 ******************************************************************************/

/******************************************************************************
 *                    START OF BASIC CONFIGURATION OPTIONS                    *
 *                                                                            *
 * You must set these options for iLogin to work.                             *
 ******************************************************************************/


/* Fill in the following as applicable for your MySQL configuration. If you
 * do not know what to put here, please contact your hosting service provider.
 */
$ilogin_sql_server = "localhost";
$ilogin_sql_username = "user_name";
$ilogin_sql_password = "password";
$ilogin_sql_database = "database_name";


/* The "friendly" name that you want your site to be known as. This can either
 * be you domain name (e.g. "YourSite.com") or a name (e.g. "Your Site).
 */
$ilogin_siteName = "Your Site";

/* The email address that confirmation emails should be sent from. This
 * email address will not by published on your web site, and is only used
 * for sending confirmation emails.
 */
$ilogin_adminEmail = "you@yoursite.com";


/* URL of a password protected page on your site. When a new user signs up
 * they are given a link to this page. This can be a full URL
 * ("http://www.yoursite.com/members") or relative to the iLogin installation
 * directory.
 */
$ilogin_protectedUrl = "/members";

/* Password used to access the iLogin administration page. Change this to a
 * secret password.
 */
$login_adminPassword = "secret";


/******************************************************************************
 *                   START OF ADVANCED CONFIGURATION OPTIONS                  *
 *                                                                            *
 * These options allow you to fine tune some aspects of iLogin for your       *
 * site. It is not normally necessary to change these.                        *
 ******************************************************************************/


/* You can change the table name that iLogin uses.
 *
 * Recommended value is "ilogin".
 */
$ilogin_table = "ilogin";


/* Path to your .htpasswd file. This is relative to the directory in which
 * iLogin is installed.
 *
 * Recommended value is ".htpasswd" (.htpasswd is in the ilogin directory)
 */
$ilogin_htpasswd_path = ".htpasswd";


/* Define some fields that iLogin asks new users to provide. If these are set to
 * True new users will be prompted to enter the relevant information. If set to
 * False, they will not be prompted for this information.
 *
 * $ilogin_recordPostalAddress    - When True, new users are prompted for a full
 *                                  postal address
 * $ilogin_recordPhoneNumber      - When True, new users are prompted for a
 *                                  telephone number.
 * $ilogin_recordIcq              - When True, new users are prompted for an ICQ
 *                                  handle.
 *
 * The iLogin administrator can always provide this informaiton for a user after
 * they have registered.
 */
$ilogin_recordPostalAddress = True;
$ilogin_recordPhoneNumber = True;
$ilogin_recordIcq = True;


/* Define whether or not email addresses are verified, or whether we trust the
 * visitor to provide us with a valid email address.
 *
 * When set to True, a user will be sent an email when they sign up. They must
 * click on the link provided within this email to activate their account. When
 * set to False, new accounts will be activated immediately.
 *
 * Recommended value is True.
 */
$ilogin_verifyEmailAddresses = True;


/* When set to True user accounts will not be created or altered and the
 * .htpasswd file will not be changed. This is used to show the demo at
 * http://www.z-host.com/scripts/ilogin/demo
 *
 * Recommended value is False.
 */
$ilogin_demoMode = False;

/* Set colours for page background, form background and text
 */
$ilogin_pageBackgroundColour = "#c0e0ff";
$ilogin_formBackgroundColour = "#ffffff";
$ilogin_textColour = "#000000";

/* Set to true if your web server requires passwords to be stored in MD5 format.
 * If set to False, the old crypt method will be used.
 *
 * If you have problems with user authentication (no passwords are accepted),
 * try changing this setting.
 *
 * Default value is False.
 */
$ilogin_useMd5 = False;

?>