<?php

/******************************************************************************
 * iLogin - Member login system                                               *
 *                                                                            *
 * Visit the iLogin homepage at http://www.z-host.com/scripts/ilogin          *
 *                                                                            *
 * Copyright (C) 2003 Ian Willis. All rights reserved.                        *
 *                                                                            *
 * This script is free to use for non-commercial individual use.              *
 *                                                                            *
 * Use of this script by companies or on commercial web sites requires a      *
 * commercial license. For commercial licence details, please visit:          *
 *     http://www.z-host.com/scripts/ilogin                                   *
 *                                                                            *
 ******************************************************************************/

require_once("ilogin_config.inc.php");

/* Die function - called on a fatal error */
function ilogin_die( $error = "unknown" )
{
    echo "<H1>iLogin Error:". $error."</H1>";
    exit;
}

function ilogin_write_htpasswd()
{
    global $ilogin_table;
    global $ilogin_db;
    global $ilogin_htpasswd_path;
    global $ilogin_demoMode;
    global $ilogin_useMd5;

    if ($ilogin_demoMode)
    {
        return True;
    }

    $result = mysql_query ("SELECT * FROM $ilogin_table WHERE status='Active'", $ilogin_db);

    $content = "";
    if ($result)
    {
        while ($item = mysql_fetch_object($result))
        {
            if ($ilogin_useMd5)
            {
                $crypted_password = md5($item->password);
            }
            else
            {
                $crypted_password = crypt($item->password, "aa");
            }
            $content .= "$item->username:$crypted_password\n";
        }
    }

    $fh = fopen($ilogin_htpasswd_path, "a+");
    if (!$fh)
    {
        echo "<P>An error ocurred. Unable to open password file for writing. Please check the file permissions on your password file.\n";
        return False;
    }

    if (!flock($fh, LOCK_EX))
    {
        echo "<P>An error ocurred. Unable to lock password file. Please try again.\n";
        fclose($fh);
        return False;
    }

    fseek($fh, 0);
    ftruncate($fh, 0);

    fwrite($fh, $content);

    fflush($fh);
    flock($fh, LOCK_UN);
    fclose($fh);

    return True;
}

function ilogin_get_post($varname)
{
    if (isset($_GET[$varname]))
    {
        return $_GET[$varname];
    }
    else if (isset($_POST[$varname]))
    {
        return $_POST[$varname];
    }
    else if (isset($$varname))
    {
        return $$varname;
    }
    return "";
}

if (!$ilogin_demoMode)
{
    $ilogin_db = mysql_connect($ilogin_sql_server, $ilogin_sql_username, $ilogin_sql_password) or ilogin_die("Unable to connect to database. Please check your iLogin MySQL server, username and password configuration options.");
    mysql_select_db($ilogin_sql_database, $ilogin_db) or ilogin_die("Unable to select the database. Please check your iLogin MySQL database configuration option.");
}

//mysql_query("DROP TABLE $ilogin_table");

if (!$ilogin_demoMode)
{
    /* Check whether table exists */
    if (! mysql_query("DESCRIBE $ilogin_table", $ilogin_db))
    {
        /* Create the table */
        mysql_query("CREATE TABLE $ilogin_table (id INT(10) NOT NULL primary key auto_increment, username VARCHAR(255) NOT NULL, password VARCHAR(255) NOT NULL, email VARCHAR(255) NOT NULL, firstname VARCHAR(255) NOT NULL, lastname VARCHAR(255) NOT NULL, addr1 VARCHAR(255) NOT NULL, addr2 VARCHAR(255) NOT NULL, addr3 VARCHAR(255) NOT NULL, addr4 VARCHAR(255) NOT NULL, addr5 VARCHAR(255) NOT NULL, addr6 VARCHAR(255) NOT NULL, phone VARCHAR(255) NOT NULL, icq VARCHAR(255) NOT NULL, status VARCHAR(255) NOT NULL, confirm VARCHAR(255) NOT NULL)", $ilogin_db);

        /* Write the (empty) .htpasswd file */
        ilogin_write_htpasswd();
    }
}

/* Determine the server name */
if (isset($_SERVER["HTTP_HOST"]))
{
    $ilogin_serverName = $_SERVER["HTTP_HOST"];
}
else if (isset($_SERVER["SERVER_NAME"]))
{
    $ilogin_serverName = $_SERVER["SERVER_NAME"];
}
else
{
    $ilogin_serverName = "$ilogin_siteName";
}

if (isset($_SERVER['PHP_SELF']))
{
    $PHP_SELF=$_SERVER['PHP_SELF'];
}

?>
