<?php

/******************************************************************************
 * iLogin - Member login system                                               *
 *                                                                            *
 * Visit the iLogin homepage at http://www.z-host.com/scripts/ilogin          *
 *                                                                            *
 * Copyright (C) 2003 Ian Willis. All rights reserved.                        *
 *                                                                            *
 * This script is free to use for non-commercial individual use.              *
 *                                                                            *
 * Use of this script by companies or on commercial web sites requires a      *
 * commercial license. For commercial licence details, please visit:          *
 *     http://www.z-host.com/scripts/ilogin                                   *
 *                                                                            *
 ******************************************************************************/

require_once("ilogin_core.inc.php");

//
// Generates a random string with the specified length
// Chars are chosen from the provided [optional] list
//
function simpleRandString($length=16, $list="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ")
{
    mt_srand((double)microtime()*1000000);
    $newstring="";

    if($length>0)
    {
        while(strlen($newstring)<$length)
        {
            $newstring.=$list[mt_rand(0, strlen($list)-1)];
        }
    }
    return $newstring;
}


$action = ilogin_get_post("action");

$ilogin_title = "$ilogin_siteName - New User Signup";
if (("$action" == "confirm") && (!$ilogin_demoMode))
{
    $ilogin_title = "$ilogin_siteName - New User Confirmation";
}
else if ("$action" == "add")
{
    $ilogin_title = "$ilogin_siteName - New User Signup";
}
else
{
    $action = "signup";
    $ilogin_title = "$ilogin_siteName - New User Signup";
}

echo <<<EOF
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML>
<HEAD>
<TITLE>$ilogin_title</TITLE>
<META HTTP-EQUIV="Content-Type" content="text/html; charset=utf-8">
<META HTTP-EQUIV="Content-Language" CONTENT="EN">
<META NAME="copyright" CONTENT="Copyright Ian Willis. All rights reserved.">
</HEAD>

<BODY BGCOLOR="$ilogin_pageBackgroundColour" TEXT="$ilogin_textColour">

<CENTER>

<H1>$ilogin_title</H1>

EOF;

if ("$action" == "signup")
{
    echo <<<EOF

<FORM ACTION="$PHP_SELF" METHOD="POST">
  <TABLE BORDER="0" WIDTH="350" NOWRAP="NOWRAP" BGCOLOR="$ilogin_formBackgroundColour">
   <TR>
    <TD><B>To create an acount, please enter the following information</B><BR>
        <FONT COLOR="#FF0000"><B>Fields marked with an asterisk are<BR>required input fields.</B></FONT><BR><BR>
    </TD>
   </TR>

   <TR><TD><INPUT TYPE="text" NAME="firstname"> First Name *</TD></TR>
   <TR><TD><INPUT TYPE="text" NAME="lastname"> Last Name *</TD></TR>
   <TR><TD><INPUT TYPE="text" NAME="email"> E-Mail Address *</TD></TR>
   <TR><TD><B>Choose a User Name</B><BR>
           <INPUT TYPE="text" NAME="username"> User Name *</TD></TR>
   <TR><TD><B>Choose a Password</B><BR>
           <INPUT TYPE="password" NAME="password"> Password *<BR>
           <INPUT TYPE="password" NAME="password_confirm"> Verify Password *</TD></TR>

EOF;


if ($ilogin_recordPostalAddress)
{
    echo <<<EOF
   <TR><TD><B>Your Postal Address</B><BR>
           <INPUT TYPE="text" NAME="addr1"> Address Line 1 *<BR>
           <INPUT TYPE="text" NAME="addr2"> Address Line 2<BR>
           <INPUT TYPE="text" NAME="addr3"> City *<BR>
           <INPUT TYPE="text" NAME="addr4"> State/Province/County<BR>
           <INPUT TYPE="text" NAME="addr5"> Postal/Zip Code<BR>
           <INPUT TYPE="text" NAME="addr6"> Country *</TD></TR>

EOF;

}

if (($ilogin_recordPhoneNumber) || ($ilogin_recordIcq))
{
    echo "   <TR><TD><B>Other Details</B><BR>\n";
    if ($ilogin_recordPhoneNumber)
    {
        echo "           <INPUT TYPE=\"text\" NAME=\"phone\"> Telephone Number<BR>\n";
    }
    if ($ilogin_recordIcq)
    {
        echo "           <INPUT TYPE=\"text\" NAME=\"icq\"> ICQ</TD></TR>\n";
    }
}

echo <<<EOF
   <TR><TD><INPUT TYPE="submit" VALUE="- Sign Up -"><INPUT TYPE="RESET" VALUE="- Clear Form -"></TD></TR>
  </TABLE>
 <INPUT TYPE="hidden" NAME="action" VALUE="add">
</FORM>

EOF;

}
else if ("$action" == "add")
{
    $user = strip_tags(strtolower(ilogin_get_post("username")));
    $pass = strtolower(ilogin_get_post("password"));
    $pass_confirm = strtolower(ilogin_get_post("password_confirm"));
    $firstname = strip_tags(ilogin_get_post("firstname"));
    $lastname = strip_tags(ilogin_get_post("lastname"));
    $email = ilogin_get_post("email");
    if ($ilogin_recordPostalAddress)
    {
        $addr1 = ilogin_get_post("addr1");
        $addr2 = ilogin_get_post("addr2");
        $addr3 = ilogin_get_post("addr3");
        $addr4 = ilogin_get_post("addr4");
        $addr5 = ilogin_get_post("addr5");
        $addr6 = ilogin_get_post("addr6");
    }
    if ($ilogin_recordPhoneNumber)
    {
        $phone = ilogin_get_post("phone");
    }
    if ($ilogin_recordIcq)
    {
        $icq = ilogin_get_post("icq");
    }

    $signupError = "";

    if ($user == "")
    {
        $signupError .= "<P>An empty username is not allowed.";
    }
    else if (!ereg("^[a-z0-9]+$", $user))
    {
        $signupError .= "<P>The username you chose contains invalid characters. Only letters and numbers may be used.";
    }
    else if (!$ilogin_demoMode)
    {
        $result = mysql_query("select * from $ilogin_table where username='$user'", $ilogin_db);

        /* check that at least one row was returned */
        if (($result) && ($row = mysql_fetch_object($result)))
        {
            $signupError .= "<P>The username you chose has already been used.";
        }
    }

    if (strlen($pass) < 6)
    {
        $signupError .= "<P>Your password must be at least 6 characters long.";
    }
    else if (ereg($user, $pass))
    {
        $signupError .= "<P>Your password must not match your username.";
    }
    else if (!ereg("^[a-z0-9]+$", $pass))
    {
        $signupError .= "<P>Your password contains invalid characters. Only letters and numbers may be used.";
    }
    else if ($pass != $pass_confirm)
    {
        $signupError .= "<P>Your password and confirmation password do not match.";
    }

    if ($email == "")
    {
        $signupError .= "<P>You must provide your email address.";
    }
    else if (!eregi( '^[-_\.a-z0-9]+@([-a-z0-9]+\.)+[a-z]{2,}$', $email))
    {
        $signupError .= "<P>The email address given is not valid.";
    }

    if (("$firstname" == "") || ("$lastname" == ""))
    {
        $signupError .= "<P>You must supply your full name.";
    }

    if (($ilogin_recordPostalAddress) &&
        (("$addr1" == "") || ("$addr3" == "") || ("$addr6" == "")))
    {
        $signupError .= "<P>You must supply your postal address.";
    }

    if ("$signupError" == "")
    {
        if ($ilogin_demoMode)
        {
            echo <<<EOF
<P>In Demo Mode. User account will not be created or verification email sent.

EOF;
        }
        else
        {
            mysql_query ("INSERT INTO $ilogin_table (username, password, email, firstname, lastname, status) VALUES ('$user', '$pass', '$email', '" . mysql_escape_string($firstname) . "', '" . mysql_escape_string($lastname) . "', 'New' )", $ilogin_db);

            if (($result = mysql_query ("SELECT id FROM $ilogin_table WHERE username='$user'")) &&
                ($item = mysql_fetch_object($result)))
            {
                $id = $item->id;
            }

            if ($ilogin_recordPostalAddress)
            {
                mysql_query("UPDATE $ilogin_table SET " .
                            "addr1='" . mysql_escape_string($addr1) . "', " .
                            "addr2='" . mysql_escape_string($addr2) . "', " .
                            "addr3='" . mysql_escape_string($addr3) . "', " .
                            "addr4='" . mysql_escape_string($addr4) . "', " .
                            "addr5='" . mysql_escape_string($addr5) . "', " .
                            "addr6='" . mysql_escape_string($addr6) . "' " .
                            "WHERE username='$user'", $ilogin_db);
            }
            if ($ilogin_recordPhoneNumber)
            {
                mysql_query("UPDATE $ilogin_table SET " .
                            "phone='" . mysql_escape_string($phone) . "' " .
                            "WHERE username='$user'", $ilogin_db);
            }
            if ($ilogin_recordIcq)
            {
                mysql_query("UPDATE $ilogin_table SET " .
                            "icq='" . mysql_escape_string($icq) . "' " .
                            "WHERE username='$user'", $ilogin_db);
            }

            if ($ilogin_verifyEmailAddresses)
            {
                $confirm = simpleRandString();

                /* Store the confirmation string in the database. Table has the structure:
                 *  id          unique ID
                 *  email       email address of voter
                 *  confirm     random confirmation string
                 *  confirmed   'n' or 'y'
                 *  siteid      ID in link table
                 *  rating      rating that this voter has given
                 */
                mysql_query("UPDATE $ilogin_table SET confirm='$confirm' WHERE username='$user'", $ilogin_db);

                /* Send a confirmation email to the user */
                $mailSubject = "$ilogin_siteName - confirm your membership";
                $mailBody =  "Hi $firstname,\n";
                $mailBody .= "\n";
                $mailBody .= "Thankyou for joining $ilogin_siteName.\n";
                $mailBody .= "\n";
                $mailBody .= "Please click the following link to confirm your membership. If clicking does\n";
                $mailBody .= "not work, please copy and paste into your browser manually.\n";
                $mailBody .= "\n";
                $mailBody .= "http://$ilogin_serverName$PHP_SELF?action=confirm&id=$id&confirm=$confirm\n";
                $mailBody .= "\n";
                $mailBody .= "Thankyou.\n";
                $mailHeaders = "From: $ilogin_adminEmail\n";
                $mailHeaders = "ReplyTo: $ilogin_adminEmail\n";
                mail($email, $mailSubject, $mailBody, $mailHeaders);

                echo("<P>You will soon receive an email. Please click on the link contained within it to confirm your membership.");
            }
            else
            {
                if (!$ilogin_demoMode)
                {
                    mysql_query("UPDATE $ilogin_table SET status='Active' WHERE username='$user'", $ilogin_db);
                    ilogin_write_htpasswd();
                }
                echo <<<EOF
<P>Your member account has been created. You can now login to the <A HREF="$ilogin_protectedUrl">password protected pages</A> on this site.

EOF;
            }
        }
    }
    else
    {
        echo <<<EOF
<P>The following errors ocurred. Please

<SCRIPT LANGUAGE="JavaScript">
<!--
document.write("<A HREF=\"javascript:history.back()\">go back</A>");
// -->
</SCRIPT>

<NOSCRIPT>
use your browsers back button to go back
</NOSCRIPT>

and fix them.

$signupError

EOF;
    }
}
else if ("$action" == "confirm")
{
    $id = ilogin_get_post("id");
    $confirm = ilogin_get_post("confirm");

    $result = mysql_query ("SELECT * FROM $ilogin_table WHERE id='$id' AND confirm='$confirm' AND status='New'");
    if ((! $result) || (mysql_num_rows($result) < 1))
    {
        echo <<<EOF
<H1>ERROR</H1>
<P>Invalid confirmation. Did you already confirm your membership?

EOF;
    }
    else
    {
        mysql_query("UPDATE $ilogin_table SET status='Active' WHERE id='$id'", $ilogin_db);
        ilogin_write_htpasswd();
        echo <<<EOF
<P>Thankyou for confirming your membership.
<P>Your member account has been created. You can now login to the <A HREF="$ilogin_protectedUrl">password protected pages</A> on this site.

EOF;
    }
}

/*************************************************************************
 * The following line must not be removed or commented out. Doing so     *
 * invalidates your license to use iLogin.                               *
 *************************************************************************/
echo "<P>Powered&nbsp;by&nbsp;<a href=\"http://www.z-host.com/scripts/ilogin\" target=\"_blank\">iLogin</a><BR>\n";

echo <<<EOF

</CENTER>
</BODY>
</HTML>

EOF;

if (!$ilogin_demoMode)
{
    mysql_close($ilogin_db);
}

?>
