<?php
// File : dutch/localized.chat.php - plus version (04.11.2017 - rev.50)
// Original translation by Hans Paijmans <paai@kub.nl>, Kasper Souren <guaka@industree.org> and Sander Corbesir <rock@jascrc.com>
// Updates, corrections and additions for the Plus version by DJE.Amesz & Romanesko <Genieusdanny@gmail.com> and Bert Moorlag <berbia@hotmail.com>
// Fine tuning by Ciprian Murariu <ciprianmp@yahoo.com>
// Do not use ' ; use ’ instead (utf-8 edit bug)

// extra meta-tag for charset
$Charset = "utf-8";

// medium font size in pt.
$FontSize = 10;

// welcome page
define("L_TUTORIAL", "Handleiding");

define("L_WEL_1", "Berichten worden gewist na %s %s");
define("L_WEL_2", "en namen na %s %s");

define("L_CUR_1", "Er");
define("L_CUR_1a", "zijn momenteel");
define("L_CUR_1b", "is nu");
define("L_CUR_2", "in de chat");
define("L_CUR_3", "op dit ogenblik in de chatkamer");
define("L_CUR_4", "in de privé kamers");
define("L_CUR_5", "gebruikers die momenteel gluren<br />(gluren op de chatpagina):");

define("L_SET_1", "Geef");
define("L_SET_2", "Uw naam");
define("L_SET_3", "Aantal zichtbare berichten");
define("L_SET_4", "tijd tussen twee updates");
define("L_SET_5", "Kies een chat kamer...");
define("L_SET_6", "Standaard gebruikers kamer");
define("L_SET_7", "Kies...");
define("L_SET_8", "Openbare kamer door gebruikers aangemaakt");
define("L_SET_9", "Maak uw eigen");
define("L_SET_10", "publiek");
define("L_SET_11", "privé");
define("L_SET_12", "kamer");
define("L_SET_13", "En dan maar");
define("L_SET_14", "chatten");
define("L_SET_15", "Standaard privé kamer");
define("L_SET_16", "Privé kamers gemaakt door gebruikers ");
define("L_SET_17", "Kies uw avatar");
define("L_SET_18", "Markeer deze page: druk \"Ctrl+D\".");
define("L_SET_19", "Onthoud mijn login details");

define("L_SRC", "vrijelijk verkrijgbaar op");

define("L_SEC", "seconde");
define("L_SECS", "seconden");
define("L_MIN", "minuut");
define("L_MINS", "minuten");
define("L_HOUR", "uur");
define("L_HOURS", "uren");
define("L_DAY", "dag");
define("L_DAYS", "dagen");

// registration stuff:
define("L_REG_1", "Wachtwoord");
define("L_REG_2", "Geregistreerde gebruikers");
define("L_REG_3", "Registreer");
define("L_REG_4", "Pas gebruikersprofiel aan");
define("L_REG_5", "Wis gebruiker");
define("L_REG_6", "Gebruikers registratie");
define("L_REG_7", "alleen als je geregistreerd bent");
define("L_REG_8", "E-mail adres");
define("L_REG_9", "Je bent geregistreerd.");
define("L_REG_10", "Terug");
define("L_REG_11", "Bekijken");
define("L_REG_12", "Verander gebruikersinformatie");
define("L_REG_13", "Gebruiker wissen");
define("L_REG_14", "Inloggen");
define("L_REG_15", "Inloggen");
define("L_REG_16", "Veranderen");
define("L_REG_17", "Je informatie is gewijzigd.");
define("L_REG_18", "U bent verwijderd door een moderator uit deze kamer.");
define("L_REG_18a", "U bent verwijderd uit deze kamer door a moderator.<br />De reden hiervoor is: %s");
define("L_REG_19", "Wil je echt verwijderd worden?");
define("L_REG_20", "Ja");
define("L_REG_21", "Je bent verwijderd.");
define("L_REG_22", "Nee");
define("L_REG_25", "Sluiten");
define("L_REG_30", "Voornaam");
define("L_REG_31", "Achternaam");
define("L_REG_32", "WEB");
define("L_REG_33", "laat e-mail zien met /whois commando");
define("L_REG_34", "Gebruikersprofiel wijzigen");
define("L_REG_35", "Administratie");
define("L_REG_36", "Lokatie/Land");
define("L_REG_37", "Velden met: <span class=\"error\">*</span> moeten worden ingevuld.");
define("L_REG_39", "De kamer waar je in ben geweest is verwijderd door administratie.");
define("L_REG_43", "Vertrouwelijk");
define("L_REG_44", "Stelletje");
define("L_REG_45", "Geslacht");
define("L_REG_46", "Man");
define("L_REG_47", "Vrouw");
define("L_REG_48", "Niet aangegeven");
define("L_REG_49", "Registratie vereist!");
define("L_REG_50", "Registratie opgeschort!");
define("L_REG_51", "Nooit"); //rev.48
define("L_REG_52", "Recente locatie"); //rev.48
define("L_REG_53", "zet geluid voor meldingen aan"); //rev.48

// e-mail validation stuff
define("L_EMAIL_VAL_1", "Uw instellingen");
define("L_EMAIL_VAL_2", "Welkom in deze chatkamer.");
define("L_EMAIL_VAL_Err", "Interne fout, neem contact op met een admin: <a href=\"mailto:%s\">%s</a>.");
define("L_EMAIL_VAL_Done", "Uw wachtwoord is verstuurd naar uw e-mail address.<br />U kunt uw wachtwoord wijzigen op de inlogpagina, bij pas uw profiel aan.");
define("L_EMAIL_VAL_PENDING_Done", "Je registratie gegevens zijn toegevoegd en kan je bekijken.");
define("L_EMAIL_VAL_PENDING_Done1", "Je ontvangt een wachtwoord, zodra je account is goed gekeurd door de beheerder.");
define("L_EMAIL_VAL_3", "Je registratie is ingediend voor %s");
define("L_EMAIL_VAL_31", "Gefeliciteerd! Jou registratie is ontvangen en goed gekeurd!");
define("L_EMAIL_VAL_32", "Dit zijn jou registratie gegevens voor %s op %s:"); //chat name at chaturl
define("L_EMAIL_VAL_4", "Je bent nu geregistreerd voor %s op %s:"); //chat name at chaturl
define("L_EMAIL_VAL_41", "Je hebt zojuist belangrijke gegevens veranderd voor %s op %s (account betreft: %s)."); //chat name at chaturl (username)
define("L_EMAIL_VAL_5", "Jou - %s - account details voor %s"); //username - chatname
define("L_EMAIL_VAL_51", "Jou - %s - account updated details voor %s"); //username - chatname
define("L_EMAIL_VAL_6", "Geregistreerd op %s");
define("L_EMAIL_VAL_61", "Updated op %s");
define("L_EMAIL_VAL_7", "Hieronder zijn jou %s updated account info:"); //username
define("L_EMAIL_VAL_8", "Bewaar deze mail als toekomstige referentie.\nMaak deze veilig en houd deze voor jezelf.\nDank u voor de inschrijving! Veel plezier!");
define("L_EMAIL_VAL_81", "U kunt uw wachtwoord wijzigen op de inlogpagina, bij pas uw profiel aan.");

// admin stuff
define("L_ADM_1", "%s is geen moderator in deze kamer.");
define("L_ADM_2", "Je bent niet meer geregistreerd.");

//error messages
define("L_ERR_USR_1", "Naam is al in gebruik. Kies een andere.");
define("L_ERR_USR_2", "Een naam is verplicht.");
define("L_ERR_USR_3", "Deze gebruikersnaam is al geregistreerd. Geef het wachtwoord of kies een andere gebruikersnaam.");
define("L_ERR_USR_4", "Je hebt een verkeerd wachtwoord ingevoerd.");
define("L_ERR_USR_5", "Je bent je gebruikersnaam vergeten.");
define("L_ERR_USR_6", "Je bent je wachtwoord vergeten.");
define("L_ERR_USR_7", "Je bent je email vergeten.");
define("L_ERR_USR_8", "Je moet het juiste emailadres invoeren.");
define("L_ERR_USR_9", "Deze gebruikersnaam wordt al gebruikt.");
define("L_ERR_USR_10", "Verkeerde wachtwoord of gebruikersnaam.");
define("L_ERR_USR_11", "Je moet administrator zijn.");
define("L_ERR_USR_12", "Je ben zelf administrator, dus je kunt jezelf niet verwijderen.");
define("L_ERR_USR_13", "Om je eigen kamer te maken, moet je geregistreerd zijn.");
define("L_ERR_USR_14", "Je moet geregistreerd zijn voordat je kan chatten.");
define("L_ERR_USR_15", "Je moet je naam voluit typen.");
define("L_ERR_USR_16", "Alleen de volgende extra karakters zijn toegestaan:\\n".$REG_CHARS_ALLOWED."\\nSpaties, komma’s of backslashes (\\) zijn niet toegestaan.\\nCheck the sintax.");
define("L_ERR_USR_16a", "Alleen de volgende extra karakters zijn toegestaan:<br />".$REG_CHARS_ALLOWED."<br />Spaties, komma’s of backslashes (\\) zijn niet toegestaan. Check the sintax.");
define("L_ERR_USR_17", "Deze kamer is niet beschikbaar en je bent niet bevoegd om een nieuwe kamer te maken.");
define("L_ERR_USR_18", "verboden woord gevonden in je gebruikersnaam.");
define("L_ERR_USR_19", "Je kunt niet in meer dan 1 kamer tegelijk zijn.");
define("L_ERR_USR_20", "Je bent verbannen.");
define("L_ERR_USR_20a", "Je bent verbannen uit deze kamer en of chatbox .<br />De reden hiervoor is: %s");
define("L_ERR_USR_21", "Omdat je niet actief bent geweest de afgelopen ".C_USR_DEL." minuten,<br />ben je uit de kamer verwijderd.");
define("L_ERR_USR_22", "Dit commando is niet beschikbaar in\\nde browser die u gebruikt (IE engine).");
define("L_ERR_USR_23", "Om in een privé kamer te komen moet je je registreren.");
define("L_ERR_USR_24", "Om een eigen kamer te maken moet je jezelf registreren.");
define("L_ERR_USR_25", "Alleen een administrator of moderator kan de kleuren gebruiken ".$COLORNAME." !<br />gebruik geen ".COLOR_CA.", ".COLOR_CA1.", ".COLOR_CM." or ".COLOR_CM1.".<br />deze zijn gereserveerd voor power users!");
define("L_ERR_USR_26", "Alleen een administrator of moderator kan de kleuren gebruiken ".$COLORNAME." !<br />gebruik geen! ".COLOR_CA.", ".COLOR_CA1.", ".COLOR_CM." or ".COLOR_CM1.".<br />deze zijn gereserveerd voor power users!");
define("L_ERR_USR_27", "Je kunt niet privé tegen jezelf praten.\\nDoe dat in stilte...\\nKies een andere gebruikersnaam.");
define("L_ERR_USR_28", "Jou toegang tot %s is beperkt!<br />Kies een andere kamer a.u.b."); // room name
define("L_ERR_USR_29", "Vul je geboortedatum in, alsjeblieft!<br />Onvolledige gegevens niet geaccepteerd."); //rev.49
define("L_ERR_ROM_1", "Kamernaam kan niet met komma en backslash (\\).");
define("L_ERR_ROM_2", "Verboden woord gevonden in de naam van de kamer die je wil maken.");
define("L_ERR_ROM_3", "Deze kamer is al in gebruik als openbare kamer.");
define("L_ERR_ROM_4", "Onbruikbare naam.");

// users frame or popup
define("L_EXIT", "Verlaat de chat");
define("L_DETACH", "Maak de gebruikerslijst los");
define("L_EXPCOL_ALL", "Alles uit-/inklappen");
define("L_CONN_STATE", "Vernieuw de verbindingsstatus");
define("L_CHAT", "Chat");
define("L_USER", "gebruiker");
define("L_USERS", "gebruikers");
define("L_LURKER", "gluurder");
define("L_LURKERS", "gluurders");
define("L_NO_USER", "Geen gebruiker");
define("L_ROOM", "kamer");
define("L_ROOMS", "kamers");
define("L_EXPCOL", "Kamer in-/uit laten klappen");
define("L_BEEP", "Geluid/geen geluid als gebruiker binnenkomt");
define("L_PROFILE", "Laat profiel zien");
define("L_NO_PROFILE", "Geen profiel");

// input frame
define("L_HLP", "Help");
define("L_MODERATOR", "%s is nu moderator van deze kamer.");
define("L_KICKED", "%s is succesvol verwijderd.");
define("L_KICKED_REASON", "%s is succesvol verwijderd. (Reden: %s)");
define("L_KICKED_ALL", "Alle gebruikers zijn succesvol verwijderd.");
define("L_KICKED_ALL_REASON", "Alle gebruikers zijn succesvol verwijderd. (Reden: %s)");
define("L_BANISHED", "%s is succesvol verbannen.");
define("L_BANISHED_REASON", "%s is succesvol verbannen. (Reden: %s)");
define("L_ANNOUNCE", "MEDEDELING");
define("L_INVITE", "%s vraag hem of haar je te vergezellen in <a href=\"#\" onClick=\"window.parent.runCmd('%s','%s')\">%s</a> kamer.");
define("L_INVITE_REG", "Je moet je registreren om deze kamer in te kunnen.");
define("L_INVITE_DONE", "Uw uitnodiging is verzonden aan %s.");
define("L_OK", "Verstuur");
define("L_BUZZ", "Buzzes Gallerij");
define("L_BAD_CMD", "Onjuiste opdracht!");
define("L_ADMIN", "%s is al administrator!");
define("L_IS_MODERATOR", "%s is al moderator!");
define("L_NO_MODERATOR", "Alleen moderator van deze kamer kan die gebruiken.");
define("L_NONEXIST_USER", "%s is niet in de kamer aanwezig.");
define("L_NONREG_USER", "%s is niet geregisteerd.");
define("L_NONREG_USER_IP", "Zijn of haar IP is: %s.");
define("L_NO_KICKED", "%s is moderator of administrator en kan niet worden weggestemd.");
define("L_NO_BANISHED", "%s is moderator of administrator en kan niet verbannen worden.");
define("L_SVR_TIME", "Server tijd: ");
define("L_NO_SAVE", "Geen boodschappen om te bewaren!");
define("L_NO_ADMIN", "Alleen een administrator kan dit commando gebruiken.");
define("L_NO_REG_USER", "Om dit commando te gebruiken moet je je registreren.");

// help popup
define("L_HELP_TIT_1", "Lachen");
define("L_HELP_TIT_2", "Tekst codes voor de berichten");
define("L_HELP_FMT_1", "Je kan de tekst vet, cursief en onderstrepen in een bericht in de HTML codes zoals &lt;B&gt; &lt;/B&gt;, &lt;I&gt; &lt;/I&gt; of &lt;U&gt; &lt;/U&gt; tags.<br />Ter voorbeeld, &lt;B&gt;deze tekst&lt;/B&gt; wordt <B>deze tekst</B>.");
define("L_HELP_FMT_2", "Om een link te maken (voor e-mail of URL) in jouw bericht, kun je jou adres zonder alle tags in te voeren. De URL wordt dan automatisch aangemaakt.");
define("L_HELP_TIT_3", "Commando’s");
define("L_HELP_NOTE", "Alle commando’s zijn in het Engels!");
define("L_HELP_MSG", "bericht");
define("L_HELP_MSGS", "berichten");
define("L_HELP_ROOM", "kamer");
define("L_HELP_BUZZ", "~geluidsnaam");
define("L_HELP_BUZZ1", "Buzz..."); //alert, sound alert, ring, whirr
define("L_HELP_REASON", "de reden");
define("L_HELP_MR", "Dhr. %s"); // Mister (can be short or entire word)
define("L_HELP_MS", "Mvr. %s"); // Mistress (- neutral of Miss, Mrs.)
define("L_HELP_CMD_0", "{} is voor een verplichte instelling, [] voor een optionele.");
define("L_HELP_CMD_1a", "Zet aantal berichten dat gezien wordt bij binnenkomst, minimum en standaard is 5.");
define("L_HELP_CMD_1b", "Рerlaad het berichtenvenster met aantal berichten dat gezien wordt, minimum en standaard is 5..");
define("L_HELP_CMD_2a", "Tussenpozen voor het bijwerken van de lijst (in seconden).<br />Als n niet opgegeven of als kleiner dan 3, verspringt het tussen geen bijwerken en bijwerken om de tien seconden.");
define("L_HELP_CMD_2b", "Tussenpozen voor het bijwerken van de lijst (in seconden).<br />Als n niet opgegeven of als kleiner dan 3, verspringt het tussen geen bijwerken en bijwerken om de tien seconden.");
define("L_HELP_CMD_3", "Omkeren van de bericht volgorde (niet in alle browsers).");
define("L_HELP_CMD_4", "Ga naar een andere kamer en maak hem indien nodig automatisch aan (als je dat mag tenminste).<br />n is 0 voor een privé kamer en 1 voor een openbare, standaard is 1 (openbaar).");
define("L_HELP_CMD_5", "Verlaat het chatten, eventueel met achterlaten van een bericht.");
define("L_HELP_CMD_6", "Vermijdt het tonen van de berichten van een gebruiker als de nickname is aangegeven.<br />Zet het negeren uit voor een gebruiker als nick en - beiden zijn aangegeven, voor alle gebruikers als - is aangegeven maar de nick niet.<br />Als geen optie is gegeven laat dit commando een venster zien met alle genegeerde nicks.");
define("L_HELP_CMD_7", "Haal de vorige regel terug (commando of bericht).");
define("L_HELP_CMD_8", "De tijd voor het bericht weglaten of laten zien.");
define("L_HELP_CMD_9", "Schop een gebruiker van de chatbox. Deze commando kan alleen gebruikt worden door de administrator of moderator.<br />Met de optie , [".L_HELP_REASON."] een rede op te geven van de verwijdering (reden).<br />Als * optie is gebruikt, de commando zorgt ervoor dat alle gebruikers uit de chat worden verwijderd, die geen bepaalde power hebben (alleen gasten en ongeregistreerde gebruikers). Dit kan zinvol zijn als de server connective problemen ondervindt en alle gebruikers hun chat aan het verversen is. In de tweede plaats, een [".L_HELP_REASON."] is aanbevolen om de gebruikers te laten weten dat zij zijn verwijderd.");
define("L_HELP_CMD_10", "Stuur een privé bericht naar de gespecificeerde gebruiker (andere gebruikers krijgen het niet te zien).");
define("L_HELP_CMD_11", "Laat de informatie zien van gekozen gebruiker.");
define("L_HELP_CMD_12", "Popup venster om gebruikersprofiel aan te passen.");
define("L_HELP_CMD_13", "Schakel tussen andere gebruikers, uitloggen van een bestaande kamer.");
define("L_HELP_CMD_14", "Alleen administrator en moderator van de huidige kamer kan promoten naar ander kamer te gaan.");
define("L_HELP_CMD_15", "Мerwijder alle berichten en laat alleen de laatste 5 zien.");
define("L_HELP_CMD_16", "Bewaar de laatste n berichten (mededelingen niet meegeteld) in een HTML file. als n niet is ingesteld, zullen alle boodschappen worden bewaard.");
define("L_HELP_CMD_17", "Hiermee kan de admin een boodschap sturen aan alle gebruikers in een kamer.");
define("L_HELP_CMD_18", "Stel voor aan een andere gebruiker in een andere kamer om bij jou te komen.");
define("L_HELP_CMD_19", "Staat een administrator of moderator om te \"verbannen\" van een gebruiker op een door de administrator ingestelde tijd..<br />om een gebruiker van de chat te bannen en niet alleen van een kamer gebruik dan het ’*’ teken.<br />Met de optie , [".L_HELP_REASON."] een reden op te geven van de verbannen (reden).");
define("L_HELP_CMD_20", "Vertel wat je doet zonder jezelf prijs te geven.");
define("L_HELP_CMD_21", "Dit laat iedereen zien in de kamer en iedereen die jou een bericht stuurt<br /> Dat je afwezig bent van je pc, als je weer terug komt kun je gewoon beginnen met typen.");
define("L_HELP_CMD_22", "Stuurt een buzzer aan de kamer met eventueel een boodschap<br />- gebruik:<br />- oude boodschap: \"/buzz\" of \"/buzz en dan boodschap\" - dit speelt de vooraf ingestelde tune dat is ingesteld in het Admin paneel;<br />- extern gebruik: \"/buzz ".L_HELP_BUZZ."\" of \"/buzz ".L_HELP_BUZZ." en de boodschap\" - deze speelt dan de geluidsnaam.wav vanaf de plus/sounds folder; denk eraan dat het teken \"~\" vooraan het geluidsfragment moet staan. ");
define("L_HELP_CMD_23", "Stuur een <i>fluister</i> (privé bericht). het bericht zal altijd aankomen ook als de geadresseerde niet aanwezig is, of in een andere kamer.");
define("L_HELP_CMD_24", "Dit commando veranderd het onderwerp van de huidige kamer. Probeer niet om onderwerpen van andere gebruikers te onderdruken. Gebruik belangrijke onderwerpen.<br />Standaard, dit is een moderator/admin commando.<br />gebruik \"/topic reset\" dit commado zal het huidige onderwerp wissen en terug zetten naar het standaard onderwerp.<br />Optioneel, \"/topic * {onderwerp}\" en \"/topic * reset\" doet precies hetzelfde alleen nu in alle kamers (gemeenschappelijk onderwerp en gemeenschappelijk onderwerp reset).");
define("L_HELP_CMD_25", "Een spel met dobbelstenen.<br />Gebruik: /dice of /dice [n];<br />n kan elke waarde zijn <b>tussen 1 en %s</b> (deze waarde bepaald het aantal dobbelstenen). Als er geen waarde word gekozen zal het standaard aantal worden gebruik.");
define("L_HELP_CMD_26", "Dit is een meer ingewikkelde versie van het commando /dice (dobbelstenen).<br />gebruik: /{n1}d[n2] of /{n1}d;<br />n1 Kan elke waarde zijn <b>tussen 1 en %s</b> (deze waarde is het aantal wordpen ).<br />n2 kan elke waarde zijn <b>tussen 1 en %s</b> (it represents the number of rolling dices per throw).");
define("L_HELP_CMD_27", "Deze functie laat alle boodschappen van een gebruikers oplichten.<br />gebruik: /high {gebruiker} of druk op <img src=./images/highlightOff.gif> vierkantje rechts van de gebruikersnaam(in the kamers/gebruikerslijst)");
define("L_HELP_CMD_28", "Hiermee kunt u <i>een enkele foto</i> als plaatje.<br />gebruik: De afbeelding moet op een openbare kamer staan op internet, anders zal het niet werken<br />Voledige link is benodigd! V.B.<b>/img&nbsp;http://ciprianmp.com/images/CIPRIAN.jpg</b><br />toegestane extensies: .jpg .bmp .gif .png. de link is hoofdletter gevoelig!<br />HINTS: typ /img dan een spatie en plak dan de url ; om een goede url te krijgen van een afbeelding:, rechtsklikken op de afbeelding dat je wil , dan selecteer het hele adres (dus vanaf HTTP://) en copy de tekst en plak deze in de regel bij je chat.");
define("L_HELP_CMD_29", "Het tweede commando laat toe dat de administrator of moderator(s) van de huidige kamer om moderators te degraderen naar gewone gebruikers.<br />de * optie doet dit voor alle kamers.");
define("L_HELP_CMD_30", "Het tweede commando doet hetzelfde als het /me commando maar zal nu ook je geslacht laten weten.<br />B.V. * ".sprintf(L_HELP_MR, "Ciprian")." is tv aan het kijken of * ".sprintf(L_HELP_MS, "Dana")." is blij.");
define("L_HELP_CMD_31", "Verander de volgorde van de gebruikers in een kamer: op binnenkomst of naam.");
define("L_HELP_CMD_32", "Dit is de derde versie van de dobbelstenen.<br />Gebruik: /d{n1}[tn2] of /d{n1};<br />n1 kan elke waarde zijn <b>tussen 1 en 100</b> (het geeft aan hoeveel beurten per dobbelsteen).<br />n2 kan elke waarde zijn <b>tussen 1 en %s</b> (dit geeft aan het antal dobbelstenen).");
define("L_HELP_CMD_33", "Veranderd de grote van de letters door de gebruikers gekozen grote (toegestane waardes n: <b>tussen 7 en 15</b>); het /size commando resets alles weer na de standard waardes (<b>".$FontSize."</b>).");
define("L_HELP_CMD_34", "Dit maakt het mogelijk om de tekst te specificeren] (ltr = links naar rechts, rtl = rechts naar links).");
define("L_HELP_CMD_35", "Hiermee post je <i>&eacute;&eacute;n video</i> of <i>&eacute;&eacute;n audio bestand</i> in een kleine Flash player per keer.<br />Gebruik: Plak gewoon de URL van het te posten bestand! Bijv. <b>/video&nbsp;http://www.youtube.com/watch?v=ypAvUNiZG5k</b><br />Shockwave Flash Player moet op je systeem geinstalleerd zijn. De link is hoofdlettergevoelig!<br />TIP: type /video gevolgd door een spatie en plak de URL er achter.");
define("L_HELP_CMD_35a", "De tweede opdracht werkt alleen met youtube.com als video bron.<br />Bijv. <b>/tube&nbsp;http://www.youtube.com/watch?v=ypAvUNiZG5k</b>");
define("L_HELP_CMD_36", "Hiermee post je <i>&eacute;&eacute;n youtube video</i> in een kleine Flash player per keer.<br />Gebruik: Plak gewoon de url van het te posten bestand! Bijv. <b>/tube&nbsp;http://www.youtube.com/watch?v=ypAvUNiZG5k</b><br />Shockwave Flash Player moet op je systeem geinstalleerd zijn. De link is hoofdlettergevoelig!<br />TIP: type /tube gevolgd door een spatie en plak de URL er achter.");
define("L_HELP_CMD_37", "It allows posting of <i>MathJax Equations/Formulas</i> in chat.<br />Usage: Just paste the TeX or MathML (original) codes! E.g. <b>/math&nbsp;\sqrt{3x-1}+(1+x)^2</b><br />For more code samples and instructions go to: <a href=\"http://www.mathjax.org/demos/\" target=\"_blank\">http://www.mathjax.org/demos</a>. Get the code by right-clicking on the formulas.<br />HINTS: type /math followed by a space and paste the code into the box.");
define("L_HELP_CMD_VAR", "Synoniemen: %s"); // a list of English and/or translated alternatives for each command, provided in help.
define("L_HELP_ETIQ_1", "Chat regels");
define("L_HELP_ETIQ_2", "We willen deze site leuk en netjes houden, dus graag de volgende regels volgen. als je je niet aan de regels kunt houden loop je kans door een moderator of administrator eruit gegooid te worden of zelfs geband.<br /><br />Dank u wel,");
define("L_HELP_ETIQ_3", "Onze chat regels");
define("L_HELP_ETIQ_4", "<li>Ga niet \"spammen\" door bijvoorbeeld constant onzin te typen.</li>
<li>Gebruik geen rare teksten zoals HaLlO AllEmAl.</li>
<li>Let erop dat je caps uitstaan (hoofdletters) dit word gezien als schreeuwen.</li>
<li>Houdt er rekening mee dat er mensen van over de hele wereld hier kunnen chatten, hou er dus rekening mee dat er verschillende geloven kunnen zijn, respecteer ook deze mensen.</li>
<li>DISCRIMINATIE WORD NIET GETOLEREERD!!</li>
<li>Spreek gebruikers aan met hun gebruikersnaam en niet (indien men elkaar kent) met de echte namen, men kan dit vervelend vinden!!</li>");

// message frame
define("L_NO_MSG", "Geen bericht");
define("L_TODAY_DWN", "De berichten van vandaag beginnen onder de lijn");
define("L_TODAY_UP", "De berichten die gisteren verstuurd zijn starten boven de lijn.");

// message colors
$TextColors = array(	"Zwart" => "#000000",
				"Rood" => "#FF0000",
				"Groen" => "#009900",
				"Blauw" => "#0000FF",
				"Paars" => "#990099",
				"Donker rood" => "#990000",
				"Donker groen" => "#006600",
				"Donker blauw" => "#000099",
				"Maroen" => "#996633",
				"Zee blauw" => "#006699",
				"Oranje" => "#F5671B");

// ignored popup
define("L_IGNOR_TIT", "Niet uitgevoerd");
define("L_IGNOR_NON", "Geen genegeerde gebruiker");

// whois popup
define("L_WHOIS_ADMIN", "Administrator");
define("L_WHOIS_OWNER", "Eigenaar");
define("L_WHOIS_TOPMOD", "Top Moderator");
define("L_WHOIS_MODER", "Moderator");
define("L_WHOIS_MODERS", "Moderators");
define("L_WHOIS_OTHERS", "Andere gebruikers");
define("L_WHOIS_USER", "Gebruiker");
define("L_WHOIS_GUEST", "Gast");
define("L_WHOIS_REG", "Geregistreerd");
define("L_WHOIS_BOT", "Bot");

// Notification messages of user entrance/exit
define("ENTER_ROM", "%s komt binnen in deze kamer.");
define("L_EXIT_ROM", "%s is uitgelogd.");
if ((ALLOW_ENTRANCE_SOUND == "1" || ALLOW_ENTRANCE_SOUND == "3") && ENTRANCE_SOUND != "") define("L_ENTER_ROM", ENTER_ROM.L_ENTER_SND);
else define("L_ENTER_ROM", ENTER_ROM);
define("L_ENTER_ROM_NOSOUND", ENTER_ROM);

// Clean mod/fix by Ciprian
define("L_BOOT_ROM", "%s is uit de kamer verwijderd wegens het niet actief deelnemen in de chat.");
define("L_CLOSED_ROM", "%s heeft het chatvenster gesloten.");

// Text for /away command notification string:
define("L_AWAY", "%s is niet aan de toetsen...");
define("L_BACK", "%s is terug!");

// Quick Menu mod
define("L_QUICK", "Snel Menu");

// Topic Banner mod
define("L_TOPIC", "heeft het onderwerp gezet op:");
define("L_TOPIC_RESET", "heeft het onderwerp gereset");
define("L_HELP_TOP", "minimaal 2 woorden als onderwerp aub");
define("L_BANNER_WELCOME", "Welkom in de %s!"); // room name
define("L_BANNER_TOPIC", "Allemaal:");
define("L_DEFAULT_TOPIC_1", "Dit is de standaard topic. Open localization/_owner/owner.php om dit te veranderen!");

// Img cmd mod
define("L_PIC", "Afbeelding geplaatst door");
define("L_PIC_RESIZED", "Grootte aangepast aan");
define("L_HELP_IMG", "volledige url adres van de afbeelding");
define("L_NO_IMAGE", "Dit is geen juist URL of een publieke afbeelding.\\nProbeer opnieuw!");

// Demote command by Ciprian
define("L_IS_NO_MOD_ALL", "%s is geen moderator meer voor de kamers van deze chatbox.");
define("L_IS_NO_MODERATOR", "%s is geen moderator.");
define("L_ERR_IS_ADMIN", "%s is de administrator!\\nje kunt zijn rechten niet wijzigen.");

// Info mod by Ciprian - displays a list of all the features & mods, including Bot's name, on the welcome page
define("INFO_CMDS", "Extra commando’s beschikbaar:");
define("INFO_MODS", "Extra onderdelen beschikbaar:");
define("INFO_BOT", "Onze beschikbare bot is:");

// Profile mod
define("L_PRO_1", "Moedertaal");
define("L_PRO_1a", "Taal");
define("L_PRO_2", "Favoriete link 1");
define("L_PRO_3", "Favoriete link 2");
define("L_PRO_4", "Omschrijving");
define("L_PRO_5", "URL afbeelding");
define("L_PRO_6", "Uw naam/text kleuren");

// Avatar mod
define("L_AVATAR", "Avatar");
define("L_ERR_AV", "Verkeerd adres.");
define("L_TITLE_AV", "Uw huidige avatar: ");
define("L_CHG_AV", "Clik \"".L_REG_16."\" het profiel<br />om uw Avatar op te slaan.");
define("L_SEL_NEW_AV", "Selecteer een nieuwe Avatar");
define("L_EX_AV", "voorbeeld");
define("L_URL_AV", "URL: ");
define("L_EXPL_AV", "(Enter URL, daarna ENTER om te kijken)");
define("L_CANCEL", "Annuleren");
define("L_AVA_REG", "Je moet geregistreerd zijn\\nom je avatar te veranderen");
define("L_SEL_NEW_AV_CONFIRM", "Dit formulier is niet toegevoegd.\\nWanneer je nu naar avatars gaat, verlies je\\nveranderingen die je tot nu hebt gedaan!\\n\\nWeet je het zeker?");

// PlusBot bot mod (based on Alice bot)
define("BOT_TIPS", "TIPS: Onze bot is actief in de kamers, om te praten, type <b>hello ".C_BOT_NAME."</b>. om te stoppen, type: <b>bye ".C_BOT_NAME."</b>. (private: /to <b>".C_BOT_NAME."</b> Message)"); //make sure uw translation don't go too long here; it must fit to one line on the banner (under topic)
define("BOT_PRIV_TIPS", "TIPS: Onze bot is actief in de kamers %s. u kunt privé met de bot chatten. (commando: /wisp <b>".C_BOT_NAME."</b> Message)"); //make sure uw translation don't go too long here; it must fit to one line on the banner (under topic)
define("BOT_PRIVONLY_TIPS", "TIPS: Onze bot is niet publiek aanwezig. alleen privé gesprekken mogelijk. (commands: /to <b>".C_BOT_NAME."</b> Message or /wisp <b>".C_BOT_NAME."</b> Message)"); //make sure uw translation don't go too long here; it must fit to one line on the banner (under topic)
define("BOT_STOP_ERROR", "Bot niet aanwezig in deze kamer!");
define("BOT_START_ERROR", "Bot aanwezig in deze kamer!");
define("BOT_DISABLED_ERROR", "Bot is uitgeschakeld!");

// Dice v.1, v.2 and v.3 modes
define("DICE_RESULTS", "heeft de dobbelstenen gegooid:");
define("DICE_WRONG", "Geef aan hoeveel dobbelstenen\\n(kies a nummer tussen 1 en ".MAX_ROLLS.").\\n type /dice aantal dobbelstenen ".MAX_ROLLS." dices.");
define("DICE2_WRONG", "De tweede waarde moet tussen 1 en ".MAX_ROLLS.".\\nleeg om ze allemaal te gebruiken ".MAX_ROLLS." dices\\n(e.g. /".MAX_DICES."d of /".MAX_DICES."d".MAX_ROLLS.").");
define("DICE2_WRONG1", "De eerste waarde moet tussen 1 en ".MAX_DICES.".\\n(e.g. /".MAX_DICES."d of /".MAX_DICES."d".MAX_ROLLS.").");
define("DICE3_WRONG", "De tweede waarde moet tussen 1 en ".MAX_ROLLS.".\\nleeg om ze allemaal te gebruiken ".MAX_ROLLS." dices\\n(e.g. /d50 of /d100t".MAX_ROLLS.").");

// Private Message Popup mod by Ciprian
define("L_REG_POPUP", "popups voor privé berichten");
define("L_REG_POPUP_NOTE", "Jou pop-up blokker moet uitgezet worden!");
define("L_PRIV_MSG", "Nieuwe privébericht versturen!");
define("L_PRIV_MSGS", "%s nieuwe privébericht ontvangen!");
define("L_PRIV_MSGSa", "Hier zijn de eerste 10 berichtenen!<br />gebruik de link onderaan om de rest te zien.");
define("L_PRIV_MSG1", "Van:");
define("L_PRIV_MSG2", "Kamer:");
define("L_PRIV_MSG3", "Aan:");
define("L_PRIV_MSG4", "Bericht:");
define("L_PRIV_MSG5", "Geplaatst:");
define("L_PRIV_REPLY", "Beantwoord");
define("L_PRIV_READ", "Klik op de ’".L_REG_25."’ link om alles als gelezen te markeren!");
define("L_PRIV_POPUP", "Je kunt deze popup functie altijd aan of uit zetten<br />door uw");
define("L_PRIV_POPUP1", "Profiel</a> te raadplegen (alleen geregistreerde gebruikers)");
define("L_NOT_ONLINE", "%s is niet online.");
define("L_PRIV_NOT_ONLINE", "%s is niet online,\\nMaar zal uw boodschap ontvangen wanneer deze weer inlogt.");
define("L_PRIV_NOT_INROOM", "%s is niet in deze kamer.\\nals je deze gebruiker toch een boodschap wil sturen,\\ngebruik het commando: /wisp %s boodschap.");
define("L_PRIV_AWAY", "%s is afwezig,\\nmaar zal wel je boodschap ontvangen\\nals deze terug komt.");
define("PM_DISABLED_ERROR", "Fluisteren (Privé berichten)\\nis uitgeschakeld in deze chat.");
define("L_NEXT_PAGE", "Ga naar de volgende pagina");
define("L_NEXT_READ", "Lees het volgende bericht %s"); // message / 10 messages
define("L_ROOM_ALL", "Alle Kamers");
define("L_PRIV_NO_MSGS", "Geen privé berichten ontvangen");
define("L_PRIV_READ_MSG", "1 privé bericht ontvangen"); //singular
define("L_PRIV_READ_MSGS", "%s privé bericht ontvangen"); //plural
define("L_PRIV_MSGS_NEW", "Nieuw"); //singular form
define("L_PRIV_MSGS_READ", "Gelezen"); //singular form
define("L_PRIV_MSG6", "Status:");
define("L_PRIV_RELOAD", "Pagina verversen");
define("L_PRIV_MARK_ALL", "Markeer als Gelezen");
define("L_PRIV_MARK_SEL", "Markeer Gelezen berichten");
define("L_PRIV_REMOVE", "Verwijder Gelezen berichten"); // or selected
define("L_PRIV_PM", "(privé)");
define("L_PRIV_WISP", "(fluister)");

// Color Input Box mod by Ciprian
define("L_ENABLED", "Aan");
define("L_DISABLED", "Uit");
define("L_COLOR_HEAD_SETTINGS", "Huidige Instellingen:");
define("L_COLOR_HEAD_SETTINGSa", "Standaard Kleuren:");
define("L_COLOR_HEAD_SETTINGSb", "Standaard Kleur:");
define("L_COL_HELP_TITLE", "Kleuren raster");
define("L_COL_HELP_SUB1", "Gebruik:");
define("L_COL_HELP_P1", "Je kan je eigen kleuren instellen via jou profiel. Je kan altijd een andere kleur kiezen. Om terug te keren naar de standaard kleur, moet je gewoon de standaard kleur kiezen (Null) - dit is de eerste optie in de lijst.");
define("L_COL_HELP_SUB2", "Hints:");
define("L_COL_HELP_P2", "<u>Kleur bereik</u><br />Dit is afhankelijk van uw browser, het kan zijn dat sommige kleuren niet zichtbaar zijn. Standaard zijn er 16 kleuren ondersteund.:");
define("L_COL_HELP_P2a", "Als een gebruiker klaagt dat deze uw teksten niet kan zien, gebruikt deze waarschijnlijk een oudere browser.");
define("L_COL_HELP_SUB3", "Instellingen van deze chatbox:");
define("L_COL_HELP_P3", "<u>Kleuren voor admin en moderator</u>:<br />1. Administrator kan elke kleur gebruiken.<br />De standaard kleur voor de administrator is <SPAN style=\"color:".COLOR_CA."\">".COLOR_CA."</SPAN>.<br />2. Moderators kunnen elke kleur gebruiken behalve: <SPAN style=\"color:".COLOR_CA."\">".COLOR_CA."</SPAN> en <SPAN style=\"color:".COLOR_CA1."\">".COLOR_CA1."</SPAN>.<br />De standaard kleur voor moderators is <SPAN style=\"color:".COLOR_CM."\">".COLOR_CM."</SPAN>.<br />3. Andere gebruikers kunnen alle kleuren kiezen behalve <SPAN style=\"color:".COLOR_CA."\">".COLOR_CA."</SPAN>, <SPAN style=\"color:".COLOR_CA1."\">".COLOR_CA1."</SPAN>, <SPAN style=\"color:".COLOR_CM."\">".COLOR_CM."</SPAN> en <SPAN style=\"color:".COLOR_CM1."\">".COLOR_CM1."</SPAN>.");
define("L_COL_HELP_P3a", "De standaard kleur is <u><SPAN style=\"color:".COLOR_CD."\">".COLOR_CD."</SPAN></u>.<br /><br /><u>Technisch handeling</u>: deze kleuren zijn door de administrator gereserveerd in admin panel.<br />Als er iets fout gaat of je vind de kleur niets, neem dan contact op met de <b>administrator</b> en niet met andere gebruikers, omdat deze toch niets kunnen doen. :-)");
define("L_COL_HELP_USER_STATUS", "Uw status");
define("L_COL_TUT", "Gebruik makend van een kleuren tekst raster");
define("L_NULL", "Niets");
define("L_NULL_F", ""); // feminine word, if it's the case
define("L_ROOM_COLOR", "kleur kamers");
define("L_PRO_COLOR", "kleur profielen");

// Alert messages on errors for Color Input Box mod by Ciprian
define("COL_ERROR_BOX_MODA", "Alleen een admin kan gebruik maken van: ".COLOR_CA." color!\\n\\nUw tekst kleur reset naar ".COLOR_CM."!\\n\\nKies een andere kleur.");
define("COL_ERROR_BOX_USRA", "Alleen een admin kan gebruik maken van: ".COLOR_CA." color!\\n\\nGebruik geen ".COLOR_CA.", ".COLOR_CA1.", ".COLOR_CM." or ".COLOR_CM1.".\\n\\nDze zijn gereserveerd voor admin en mods!\\n\\nUw tekst kleur reset naar ".COLOR_CD."!\\n\\nKies een andere kleur.");
define("COL_ERROR_BOX_USRM", "Je moet een moderator zijn om gebruik te maken van ".COLOR_CM." color!\\n\\nGebruik geen ".COLOR_CA.", ".COLOR_CA1.", ".COLOR_CM." or ".COLOR_CM1.".\\n\\nDze zijn gereserveerd voor admin en mods!\\n\\nUw tekst kleur reset naar ".COLOR_CD."!\\n\\nKies een andere kleur.");

//Welcome message to be displayed on login
define("L_WELCOME_MSG", "Welkom op deze chatbox, wees netjes en aardig voor iedereen, volg de regels van de chatbox: <I>blijf netjes en aardig</I>.");
if ((ALLOW_ENTRANCE_SOUND == "2" || ALLOW_ENTRANCE_SOUND == "3") && WELCOME_SOUND != "") define("WELCOME_MSG", L_WELCOME_MSG.L_WELCOME_SND);
else define("WELCOME_MSG", L_WELCOME_MSG);
define("WELCOME_MSG_NOSOUND", L_WELCOME_MSG);

// Send alert to users in chat when important settings are changed in admin panel
define("L_RELOAD_CHAT", "De instellingen van deze chatkamer zijn zojuist veranderd. Om fouten te voorkomen graag op F5 drukken of uitloggen en weer opnieuw inloggen.");

//Size command error by Ciprian
define("L_ERR_SIZE", "De grote van de letters kunnen alleen\\nnul (zijn voor een reset) of tussen 7 en 15");

// Password reset form by Ciprian
define("L_PASS_0", "Forumulier verander wachtwoord");
define("L_PASS_1", "Geheime vraag");
define("L_PASS_2", "Wat was je eerste auto?"); // Don't change this question! Just translate it!
define("L_PASS_3", "Naam van je lievelings dier?"); // Don't change this question! Just translate it!
define("L_PASS_4", "Wat is je favoriete drankje?"); // Don't change this question! Just translate it!
define("L_PASS_5", "Wat is je geboortedatum?"); // Don't change this question! Just translate it!
define("L_PASS_6", "Geheime antwoord");
define("L_PASS_7", "Verander wachtwoord");
define("L_PASS_8", "Je wachtwoord is succesvol veranderd.");
define("L_PASS_9", "Jou nieuwe wachtwoord om de chat binnen te gaan");
define("L_PASS_10", "Uw nieuwe wachtwoord voor deze chat: %s");
define("L_PASS_11", "Welkom terug in onze chatkamer!");
define("L_PASS_12", "Kies je vraag ...");
define("L_ERR_PASS_1", "Verkeerde gebruikersnaam. Kies die van jou.");
define("L_ERR_PASS_2", "Verkeerde email. Probeer opnieuw!");
define("L_ERR_PASS_3", "Verkeerde geheime vraag.<br />Antwoord één van de onderstaande!");
define("L_ERR_PASS_4", "Verkeerde geheime antwoord. Probeer opnieuw!");
define("L_ERR_PASS_5", "Je hebt nog niet de juiste privé/geheime data ingesteld.");
define("L_ERR_PASS_6", "Je hebt nog niet jou privé/geheime data ingesteld.<br />Je kan niet dit formulier gebruiken.<br />Neem contact op met de admin!");

// admin stuff - added for administrators promotions/demotions in admin panel - by Ciprian
define("L_ADM_3", "%s is administrator geworden van deze chat.");
define("L_ADM_4", "%s is geen administrator meer van deze chat.");

// Links popup page by Alex
define("L_LINKS_1", "Geplaatste links");
define("L_LINKS_2", "Hier krijg je toegang tot de geplaatste links");

// Javascript Status/title messages on links/images mouseover
define("L_CLICKS", "Klik hier %s %s");
define("L_CLICK", "Klik hier %s");
define("L_LINKS_3", "om link te openen");
define("L_LINKS_4", "om auteurs site te openen");
define("L_LINKS_5", "om een smiley toe te voegen");
define("L_LINKS_6", "om contact");
define("L_LINKS_7", "om %s Homepagina te bezoeken");
define("L_LINKS_8", "om lid te worden bij %s Group");
define("L_LINKS_9", "om je feedback te sturen");
define("L_LINKS_10", "om %s te downloaden");
define("L_LINKS_11", "voor controle wie aan het chatten is");
define("L_LINKS_12", "om de Chat Login Pagina te openen");
define("L_LINKS_13", "om geluid te verzenden"); // Click to blablabla : it can also be translated as "to play this sound", if buzz has no translation.
define("L_LINKS_14", "om deze commando te gebruiken");
define("L_LINKS_15", "om te openen"); // to open/see Posted Links window
define("L_LINKS_16", "Smiley Gallerij");
define("L_LINKS_17", "om oplopend te sorteren");
define("L_LINKS_18", "om aflopend te sorteren");
define("L_LINKS_19", "om aan te passen/veranderen van jou Gravatar");
define("L_LINKS_20", "Geplaatste vergelijkingen"); //Click here to open Posted Equations
define("L_SWITCH", "Schakel over naar %s");
define("L_SELECTED", "selecteer");
define("L_SELECTED_F", ""); // feminine word, if it's the case
define("L_NOT_SELECTED", "niet geselecteerd");
define("L_NOT_SELECTED_F", ""); // feminine word, if it's the case
define("L_EMAIL_1", "om een email te versturen");
define("L_FULLSIZE_PIC", "om de afbeelding op ware grootte te zien");
define("L_AUTHOR", "de auteur");
define("L_DEVELOPER", "de ontwikkelaar van deze chat");
define("L_OWNER", "de eigenaar van deze chat");
define("L_TRANSLATOR", "de vertaler");
define("L_COOKIE", "%s maakt gebruik van cookies om het fuctioneren en het gebruik van deze website te verbeteren.<br />Er zal op geen enkele wijze contact kunnen worden gemaakt met gebruikers door middel van de cookies."); //app name //rev.50
define("L_PRIVACY", "Voorwaarden"); //rev.50
define("L_READ_PRIVACY", "om lees de ".L_PRIVACY.""); //rev.50
define("L_AGREE", "Begrepen!"); //rev.50

// Counter on login
define("L_VISITOR_REPORT", "... bezoekers sinds %s"); // install date

// Status bar messages
define("L_JOIN_ROOM", "Bezoek deze kamer");
define("L_USE_NAME", "Gebruik deze gebruikersnaam");
define("L_USE_NAME1", "Adres van deze gebruikersnaam");
define("L_WHSP", "Fluister");
define("L_SEND_WHSP", "Verstuur een fluister");
define("L_SEND_PM_1", "Verstuur PM");
define("L_SEND_PM_2", "Verstuur een privé bericht");
define("L_HIGHLIGHT", "Oplichten/Niet oplichten");
define("L_HIGHLIGHT_SB", "Oplichten/Niet oplichten deze gebruikers post");

//Lurking frame popup
define("L_LURKING_2", "Gluurders pagina");
define("L_LURKING_3", "is aan het gluren");
define("L_LURKING_4", "lid sinds");
define("L_LURKING_5", "Onbekend");

// Extra options by Ciprian
define("L_EXTRA_OPT", "Extra Optie´s");
define("L_ARCHIVE", "Open archieven");
define("L_SOUNDFIX_IE_1", "Geluid fix voor IE");
define("L_SOUNDFIX_IE_2", "Download een geluid fix voor IE");
define("L_LURKING_1", "Open de gluurders pagina");
define("L_REG_BRB", "brb (Ik ga me eerst regestreren)");
define("L_DEL_BYE", "wacht niet op mij");
define("L_EXTRA_PRIV1", "Lees PMs"); // keep it short
define("L_EXTRA_PRIV2", "Nieuwe PMs"); // keep it short

// Set the first day of the week in your language (0 for Sunday, 1 for Monday)
define("FIRST_DAY", "1");

// Months Long Names
define("L_JAN", "januari");
define("L_FEB", "februari");
define("L_MAR", "maart");
define("L_APR", "april");
define("L_MAY", "mei");
define("L_JUN", "juni");
define("L_JUL", "juli");
define("L_AUG", "augustus");
define("L_SEP", "september");
define("L_OCT", "oktober");
define("L_NOV", "november");
define("L_DEC", "december");
// Months Short Names
define("L_S_JAN", "jan");
define("L_S_FEB", "feb");
define("L_S_MAR", "mrt");
define("L_S_APR", "apr");
define("L_S_MAY", "mei");
define("L_S_JUN", "jun");
define("L_S_JUL", "jul");
define("L_S_AUG", "aug");
define("L_S_SEP", "sep");
define("L_S_OCT", "okt");
define("L_S_NOV", "nov");
define("L_S_DEC", "dec");
// Week days Long Names
define("L_MON", "maandag");
define("L_TUE", "dinsdag");
define("L_WED", "woensdag");
define("L_THU", "donderdag");
define("L_FRI", "vrijdag");
define("L_SAT", "zaterdag");
define("L_SUN", "zondag");
// Week days Short Names
define("L_S_MON", "ma");
define("L_S_TUE", "di");
define("L_S_WED", "wo");
define("L_S_THU", "do");
define("L_S_FRI", "vr");
define("L_S_SAT", "za");
define("L_S_SUN", "zo");

// Localized date format - read the parameters here: http://www.php.net/manual/en/function.strftime.php
if (stristr(PHP_OS,'win')) {
setlocale(LC_ALL, "dutch.UTF-8", "dutch");
} else {
setlocale(LC_ALL, "nl_NL.UTF-8", "nl_NL.UTF-8@euro", "nld_nld.UTF-8", "nld.UTF-8");
}
define("L_LANG", "nl_NL");
define("ISO_DEFAULT", "iso-8859-1");
define("WIN_DEFAULT", "windows-1252");
define("L_SHORT_DATE", "%d-%m-%Y"); //Change this to your local desired date only format (keep the short form)
define("L_LONG_DATE", "%A %d %B %Y"); //Change this to your local desired date only format (keep the long form)
define("L_SHORT_DATETIME", "%d-%m-%Y %H:%M:%S"); //Change this to your local desired date&time format (keep the short form)
define("L_LONG_DATETIME", "%A %d %B %Y %H:%M:%S"); //Change this to your local desired date&time format (keep the long form)
define("L_CAL_FORMAT", "%d %B %Y"); // Calendar format

// Chat Activity displayed on remote web pages
define("LOGIN_LINK", "<A HREF='".C_CHAT_URL."?L=".$L."' TITLE='".sprintf(L_CLICK,L_LINKS_12)."' onMouseOver=\"window.status='".sprintf(L_CLICK,L_LINKS_12).".'; return true;\" TARGET=_blank>");
define("NB_USERS_IN","gebruikers zijn ".LOGIN_LINK."aan het chatten</A> op dit moment.");
define("USERS_LOGIN","1 gebruiker is ".LOGIN_LINK."aan het chatten</A> op dit moment.");
define("NO_USER","Niemand ".LOGIN_LINK."aanwezig</A> op dit moment.");
define("L_PRIV_REPLY_LOGIN", "Login in chat wanneer je een ".LOGIN_LINK."bericht wilt beantwoorden</A> aan iemand van de nieuwe PMs lijst hierboven");

// Language names
define("L_LANG_AR", "Spaans Argentijns");
define("L_LANG_BR", "Braziliaans Portugees");
define("L_LANG_BG", "Bulgaars - Cyrillic");
define("L_LANG_CA", "Catalaans"); 
define("L_LANG_CNS", "Chinees (Eenvoudig)"); 
define("L_LANG_CNT", "Chinees (Traditioneel)");
define("L_LANG_CZ", "Tjechisch");
define("L_LANG_DA", "Deens");
define("L_LANG_DE", "Duits");
define("L_LANG_EN", "Engels");
define("L_LANG_ES", "Spaans");
define("L_LANG_ENUK", "Engels UK");
define("L_LANG_ENUS", "Engels US");
define("L_LANG_FA", "Farsi");
define("L_LANG_FI", "Fins");
define("L_LANG_FR", "Frans");
define("L_LANG_GR", "Grieks");
define("L_LANG_HE", "Hebreeuws");
define("L_LANG_HI", "Hindi");
define("L_LANG_HU", "Hongaars");
define("L_LANG_ID", "Indonesch");
define("L_LANG_IT", "Italiaans");
define("L_LANG_JA", "Japans (Kanji)");
define("L_LANG_KA", "Georgië");
define("L_LANG_NB", "Noors (Bokmål)");
define("L_LANG_NN", "Noors (Nynorsk)");
define("L_LANG_NE", "Nepalees");
define("L_LANG_NL", "Nederlands");
define("L_LANG_PL", "Pools");
define("L_LANG_PT", "Portugees");
define("L_LANG_RO", "Roemeens");
define("L_LANG_RU", "Russisch - Cyrillic");
define("L_LANG_SK", "Slovaaks");
define("L_LANG_SRL", "Servië - Latin");
define("L_LANG_SRC", "Servië - Cyrillic");
define("L_LANG_SV", "Zweeds");
define("L_LANG_TH", "Thais");
define("L_LANG_TR", "Turks");
define("L_LANG_UK", "Ukrainsch - Cyrillic");
define("L_LANG_UR", "Indisch");
define("L_LANG_VI", "Vietnamees");
define("L_LANG_YO", "Yoruba"); //Nigeria&Congo

// Skins preview page
define("L_SKINS_TITLE", "Voorbeeld bekijken");
define("L_SKINS_TITLE1", "Voorbeelden %s om te %s bekijken"); // Skins 1 to 4 preview
define("L_SKINS_AV", "Beschikbare ontwerpen");
define("L_SKINS_NONAV", "Er zijn geen stijlen omschreven in de \"skins\" (ontwerp) directorie");
define("L_SKINS_COPY", "&copy; %s Ontwerp door %s"); //© 2008 Skin by AuthorName

// Swap image titles by Ciprian
define("L_GEN_ICON", "Geslacht icoon");

// Ghost mode by Ciprian
define("L_GHOST", "Spook");
define("L_SUPER_GHOST", "Super Spook");
define("L_NO_GHOST", "Zichtbaar");

// Sorting options by Ciprian
define("L_ASC", "Oplopend");
define("L_DESC", "Aflopend");

// Returning visitors counter on profiles by Ciprian
define("L_LOGIN_COUNT", "Totaal bezocht");

// Gravatar from email mod by Ciprian
define("L_GRAV_USE", "gebruik de Gravatar");

// Uploader mod by Ciprian
define("L_UPLOAD", "Upload %s"); // Upload Image, Upload Sound or Upload File
define("L_UPLOAD_IMG", "Foto bestand"); // used to upload Avatars and /img command
define("L_UPLOAD_SND", "Geluids bestand"); // used to upload Buzz sounds
define("L_UPLOAD_FLS", "Bestanden"); // used to upload multiple files at once
define("L_UPLOAD_SUCCESS", "%s succesvol geupload als %s."); // original filename, destination filename
define("L_FILES_TITLE", "Uploads Beheer");

// Room restriction mod by Ciprian
define("L_RESTRICTED", "Beperking");
define("L_RESTRICTED_ROM", "%s is succeslvol een beperking opgelegd voor deze kamer.");

// OpenID login mod by Ciprian
define("L_OPID_SIGN", "Inschrijven met een OpenID");
define("L_OPID_REG", "Importeer jou OpenID profiel");

// Support buttons
define("L_SUPP_WARN", "Je hebt gekozen om een donatie te schenken\\n".APP_NAME." aan de maker van dit programma.\\nDank u voor uw steun!\\n\\nLet op: de ontvanger is niet de eigenaar van deze chat.\\nVul nu uw gift in op de volgende pagina.\\n\\nDoorgaan?");
define("L_SUPP_ALT", "Ondersteuning d.m.v. van PayPal voor ".APP_NAME." - dit is Snel, Gratis en Veilig!");

// Video & Audio & Youtube cmds (Embevi & YouTube player class) – same approach as in // Img cmd mod section!
define("L_AUDIO", "Audio bestand geplaatst door");
define("L_VIDEO", "Video geplaatst door");
define("L_HELP_VIDEO", "volledig pad/URL naar de video of het audio bestand dat geplaatst wordt");
define("L_NO_VIDEO", "De URL kan niet gebruikt worden voor embedden.\\nDit is niet een geldige URL voor een geaccepteerde bron van een publieke video of audio bestand.\\nProbeer opnieuw!");
define("L_ORIG_VIDEO", "om dit bestand te openen in de oorspronkelijke site"); //it sounds like: Click here to open the…

// Birthday mod - by Ciprian
define("L_PRO_7", "Geboortedatum");
define("L_PRO_8", "laat geboortedatum zien in publieke info");
define("L_PRO_9", "laat leeftijd zien in publieke info");
define("L_PRO_10", "Leeftijd");
define("L_PRO_11", "%1\$d jaren, %2\$d maanden en %3\$d dagen");	//you can also change the order here 
define("L_DOB_TIT_1", "Verjaardagenlijst");
$L_DOB_SUBJ = "Gefeliciteerd met je verjaardag, %s!"; 

// MathJax (MathML/TeX) formulas rendering in chat - by Ciprian
define("L_EQUATION", "Vergelijking");
define("L_MATH", "%s geplaatst door %s"); //e.g. "Equation posted by username" (defined above); the word "Equation" will render as a url to show popup with the posted formulas
define("L_LINKS_20", "Post Vergelijkingen"); //Click here to open Posted Equations
define("L_HELP_CMD_37", "Het is toegestaan om posting van <i><b>MathJax</b> vergelijkingen & formules</i> in chat.<br />Gebruik: Plak de TeX or MathML (origineel) codes! Bijv. <b>/math&nbsp;\sqrt{3x-1}+(1+x)^2</b><br />Voor meer code voorbeelden en instructies ga naar: <a href=\"http://www.mathjax.org/demos/\" target=\"_blank\">http://www.mathjax.org/demos</a>. Kopieer de code door rechts te klikken op de formule.<br />HINTS: type /math gevolgd door een spatie en plak de code in de kader.");

?>