<?php

/**
*    EmbeVi - Auto Embed Video From Link - PHP Class
*    http://www.embevi.com
*    Copyright (C) 2009  darkyndy
*
*    This program is free software: you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation, either version 3 of the License, or
*    (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*    Developer contact: darkyndy@gmail.com
*
*    Thanks to all contributors:
*    ciprianmp (ciprianmp@yahoo.com)
*/

/**
*  ChangeLog (last version)
*  Version 1.4b1
*  - minor fixes on embedded parameters;
*
*  - added flag for accepting providers that need page parsing for embedded code;
*  - added 3 new methods for the above flag:
*  	-> setAcceptExtendedSupport() -> for accepting to parse the extended list with providers
*   -> unsetAcceptExtendedSupport() -> to stop parsing extended list;
*   -> getAcceptExtendedSupport() -> to get the value of the flag;
*   - by default the flag is false
*   - added getProviderImageIdentifier() method that will return the path to a unique image identifier
*   		for the provider, by default is the provider icon, but if the provider doesn't have an icon
*   		then it will be a custom image;
*
*   - added default provider icon when the provider doesn't have one 
*   - refactoring on parseUrl method;
*   - fixed JavaScript warnings for IE;
*   - fixed fullScreen support;
*   
*
*  Added support for:
*  - videonews.ro
*  - vidivodo.com
*  - akilli.tv
*  - catavencu.ro
*  - adsoftheworld.com
*  - blip.tv
*  - tare.ro
*  - break.com
*  - flickr.com
*  - yourdiscovery.com
*  - animal.discovery.com
*  - atom.com
*  - islandticklevideo.com
*  - bofunk.com
*  - ebaumsworld.com
*  - photobucket.com
*  - streetfire.net
*  - ted.com
*  - theonion.com
*  - traileraddict.com
*  - qq.com
*  - v.sina.com.cn
*  - yourfilehost.com
*  - 6.cn
*  - 56.com
*  - vision.ameba.jp
*  - twiturm.com
*  - esnips.com
*  - pandora.tv
*  - wat.tv
*  - heeloo.ro
*  
*/

/**
 * EmbeVi
 *
 * An open source tool for PHP 5 or newer
 *
 * @author    Comanici Paul <darkyndy@gmail.com>
 * @copyright Copyright (c) 2009, darkyndy
 * @license   http://www.gnu.org/licenses/
 * @link      http://www.embevi.com
 * @package   EmbeVi
 *
 */
class EmbeVi{
  const VERSION = '1.4b1'; //EmbeVi version
  private $copyright = '<!-- Generated by EmbeVi (http://www.embevi.com) -->';
  private $objectAttr = array(); //object attributes
  private $objectParam = array(); //object parameters
  private $embedAttr = array(); //parameters
  //HTML that will appear before the embedded code if you use parseText method
  private $beforeHtml = "<br />";
  //HTML that will appear after the embedded code if you use parseText method
  private $afterHtml = "<br />";
  //setting the same width to all embedded codes if $globalWidth is >0
  private $globalWidth = 0;
  //setting the same height to all embedded codes if $globalHeight is >0
  private $globalHeight = 0;
  //setting maximum width to all embedded codes if $globalWidth is >0
  private $globalMaxWidth = 0;
  //setting maximum height to all embedded codes if $globalHeight is >0
  private $globalMaxHeight = 0;
  //set maximum importance
  private $globalMaxImportant = false;
  //setting for keeping ratio
  private $keepRatio = false;
  //set embevi width
  private $embeviWidth = 0;
  //set embevi height
  private $embeviHeight = 0;
  //set default video width
  private $baseWidth = 0;
  //set default video height
  private $baseHeight = 0;
  //default ratio value
  private $ratio = 1;
  //accept shorten URLs (default is false)
  private $acceptShortUrl = false;
  //use function htmlspecialchars_decode for parseHtml method
  private $specialCharDecode = true;
  //site from where you get the embedded code
  private $embeviProvider = '';
  //default provider icon
  private $embeviDefaultProviderIcon = 'https://sites.google.com/a/embevi.com/icons/embevi.png';
  //provider icon
  private $embeviProviderIcon = '';
  //provider icon source flag (if true then get from real site if false then get it from address)
  private $embeviProviderIconSource = true;
  //provider icon URL to your file
  private $embeviProviderIconUrl = 'https://sites.google.com/a/embevi.com/icons/';
  //provider icon extension
  private $embeviProviderIconExtension = '.png';
  //provider name
  private $embeviProviderName = '';
  //EmbeVi info about embedded code
  private $embeviInfo = '';
  //accept extended list (default is false)
  private $acceptExtendedSupport = false;
  //default embevi icon/identifier image name
  private $embeviImageName = 'embevi';
  //provider image identifier
  private $embeviProviderImageIdentifier = '';

  //list of short URLs services supported
  private $shortUrlServices = array(
    '2su.de/',
    '2.gp/',
    '2.ly/',
    '2ze.us/',
    '3.ly/',
    '301.to/',
    '9mp.com/',
    'a.gd/',
    'a.nf/',
    'abbr.com/',
    'bit.ly/',
    'bloat.me/',
    'buk.me/',
    'chilp.it/',
    'cli.gs/',
    'clk.my/',
    'coge.la/',
    'durl.me/',
    'fly2.ws/',
    'fon.gs/',
    'foxyurl.com/',
    'fwd4.me/',
    'goo.gl/',
    'good.ly/',
    'gurl.es/',
    'hao.jp/',
    'hex.io/',
    'hop.im/',
    'hurl.no/',
    'idek.net/',
    'is.gd/',
    'ir.pe/',
    'irt.me/',
    'j.mp/',
    'j2j.de/',
    'kissa.be/',
    'kl.am/',
    'kore.us/',
    'kots.nu/',
    'krz.ch/',
    'ktzr.us/',
    'lin.cr/',
    'l.pr/',
    'linxfix.de/',
    'linkee.com/',
    'lnk.by/',
    'lnk.ly/',
    'lnk.sk/',
    'lt.tl/',
    'lurl.no/',
    'metamark.net/',
    'migre.me/',
    'micurl.com/',
    'min2.me/',
    'minilink.org/',
    'lnk.nu/',
    'minurl.fr/',
    'moourl.com/',
    'myurl.in/',
    'nbx.ch/',
    'pendek.in/',
    'pic.gd/',
    'piko.me/',
    'piurl.com/',
    'pnt.me/',
    'poprl.com/',
    'pt2.me/',
    'puke.it/',
    'qr.cx/',
    'qurl.com/',
    'qux.in/',
    'r.im/',
    'rde.me/',
    'p.ly/',
    'redir.ec/',
    'ri.ms/',
    'rnk.me/',
    'rubyurl.com/',
    'sai.ly/',
    'sl.ly/',
    'sfu.ca/',
    'short.ie/',
    'short.to/',
    'shortn.me/',
    'shrtn.com/',
    'shw.me/',
    'siteo.us/',
    'smallr.net/',
    'smfu.in/',
    'snipie.com/',
    'snipurl.com/',
    'snkr.me/',
    'srnk.net/',
    'tighturl.com/',
    'timesurl.at/',
    'tini.us/',
    'tiny.cc/',
    'tiny.pl/',
    'tinyurl.com/',
    'to.ly/',
    'to.vg/',
    'tr.im/',
    'tsort.us/',
    'tweet.me/',
    'tweetburner.com/',
    'twip.us/',
    'twirl.at/',
    'u.nu/',
    'uiop.me/',
    'ur.ly/',
    'url.ag/',
    'url.ie/',
    'unfaker.it/',
    'urlborg.com/',
    'urlg.info/',
    'ooqx.com/',
    'u.mavrev.com/',
    'urlu.ms/',
    'urlzen.com/',
    'vb.ly/',
    'vid.ly/',
    'vl.am/',
    'vtc.es/',
    'xrt.me/',
    'xr.com/',
    'xrl.in/',
    'x.vu/',
    'xxsurl.de/',
    'youtu.be/',
    'z.pe/',
    'zi.pe/',
    'zipmyurl.com/',
    'zz.gd/'
  );

  /**
   * EmbeVi Constructor
   * Set default values for the object attributes, object param and embed attributes
   */
  public function __construct() {
    $pluginspage = 'https://get.adobe.com/flashplayer/';
    $allowScriptAccess = 'sameDomain';
    $allowFullScreen = 'true';
    $wmode = 'window';
    $videoSrc = '';

    /**
     * Embed Attributes
     */
    $this->embedAttr = array(
      'type' => 'application/x-shockwave-flash',
      'src' => $videoSrc,
      'width' => $this->embeviWidth,
      'height' => $this->embeviHeight,
      'wmode' => $wmode,
      'allowScriptAccess' => $allowScriptAccess,
      'allowFullScreen' => $allowFullScreen,
      'pluginspage' => $pluginspage,
      'flashvars' => '',
      'quality' => 'high',
      'loop' => 'false',
      'autoplay' => 'false',
      'autostart' => 'false',
      'scale' => 'exactfit',
      'align' => 'middle',
    );

    /**
     * Object Param
     */
    $this->objectParam = array(
      'movie' => $videoSrc,
      'wmode' => $wmode,
      'allowScriptAccess' => $allowScriptAccess,
      'pluginspage' => $pluginspage,
      'allowFullScreen' => $allowFullScreen,
    );

    /**
     * Object Attributes
     */
    $this->objectAttr = array(
      'classid' => 'clsid:D27CDB6E-AE6D-11cf-96B8-444553540000',
      'codebase' => 'https://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,0,0',
      'type' => 'application/x-shockwave-flash',
      'width' => $this->embeviWidth,
      'height' => $this->embeviHeight,
    );
  }

  /**
   * EmbeVi Support List (Array)
   * Example:
   * array(
   *   'provider'     => Direct link to site provider
   *   'providerName' => Name of the provider
   *   'providerIcon' => (optional) if set it will use his value for provider icon source
   *   'info'         => Support information (site and support type)
   *   'width'        => Default width (for object and embed tag)
   *   'height'       => Default height (for object and embed tag)
   *   'src'          => Source of the media to embed. Replace ~to_replace1~, ~to_replace2~, ... with matches from the matchExpr regular expression
   *   'matchExpr'    => Regular expression for matching url
   *   'flashvars'    => (optional) if set, will be passed in the embed tag. Replace ~to_replace1~, ~to_replace2~, ... etc with matches from the matchExpr
   * )
   */
  private $embeviSupport = array(
    array(
      'provider' => array('https://www.youtube.com/'),
      'providerName' => 'youtube',
      'info' => 'youtube.com playlist',
      'width' => 530,
      'height' => 370,
      'src' => 'https://www.youtube.com/p/~to_replace1~&hl=en&fs=1',
      'matchExpr' => 'youtube\\.com\\/watch(?:\\?|#!)v=[a-z0-9-_]+&feature=PlayList&p=([a-z0-9-_]+)',
    ),
    array(
      'provider' => array('https://www.youtube.com/'),
      'providerName' => 'youtube',
      'info' => 'youtube.com video',
      'width' => 425,
      'height' => 344,
      'src' => 'https://www.youtube.com/v/~to_replace2~&f=videos&app=youtube_gdata&hl=en&fs=1',
      'matchExpr' => 'youtube\\.com\\/(watch(?:\\?|#!)v=|v\\/|watch(?:\\?|#!)v=[a-z0-9-_]+&feature=PlayList&p=)([a-z0-9-_]+)',
    ),
    array(
      'provider' => array('http://www.220.ro/'),
      'providerName' => '220',
      'info' => '220.ro video v2',
      'width' => 450,
      'height' => 366,
      'src' => 'http://www.220.ro/emb/~to_replace3~',
      'matchExpr' => '220\\.ro\\/([a-z0-9-_]+)\\/([a-z0-9-_]+)\\/([a-z0-9-_]+)',
    ),
    array(
      'provider' => array('http://www.220.ro/'),
      'providerName' => '220',
      'info' => '220.ro video v1',
      'width' => 450,
      'height' => 366,
      'src' => 'http://www.220.ro/emb/~to_replace1~',
      'matchExpr' => '220\\.ro\\/([a-z0-9-_]+)\\/',
    ),
    array(
      'provider' => array('https://video.google.com/'),
      'providerName' => 'google',
      'info' => 'google video',
      'width' => 400,
      'height' => 326,
      'src' => 'https://video.google.com/googleplayer.swf?docid=~to_replace1~&hl=en&fs=true',
      'matchExpr' => 'video\\.google\\.com\\/videoplay\\?docid=([a-z0-9-_]+)',
    ),
    array(
      'provider' => array('https://www.dailymotion.com/'),
      'providerName' => 'dailymotion',
      'info' => 'dailymotion.com video',
      'width' => 420,
      'height' => 399,
      'src' => 'https://www.dailymotion.com/swf/~to_replace1~',
      'matchExpr' => 'dailymotion\\.com.*\\/video\\/([a-z0-9]+)_',
    ),
    array(
      'provider' => array('http://www.trilulilu.ro/'),
      'providerName' => 'trilulilu',
      'info' => 'trilulilu.ro video',
      'width' => 440,
      'height' => 362,
      'src' => 'http://embed.trilulilu.ro/source/go2player.php?type=video&hash=~to_replace2~&userid=~to_replace1~&src=hi5',
      'matchExpr' => 'trilulilu\\.ro\\/([a-z0-9-_]+)\\/([a-z0-9-_]+)',
    ),
    array(
      'provider' => array('https://www.metacafe.com/'),
      'providerName' => 'metacafe',
      'info' => 'metacafe.com video',
      'width' => 400,
      'height' => 345,
      'src' => 'https://www.metacafe.com/fplayer/~to_replace1~/~to_replace2~.swf',
      'matchExpr' => 'metacafe\\.com\\/watch\\/([a-z0-9-_]+)\\/([a-z0-9-_]+)',
    ),
    array(
      'provider' => array('https://www.youtube.com/'),
      'providerName' => 'youtube',
      'info' => 'youtube.com playlist v2',
      'width' => 530,
      'height' => 370,
      'src' => 'https://www.youtube.com/p/~to_replace1~',
      'matchExpr' => 'youtube\\.com\\/view_play_list\\?p=([a-z0-9-_]+)',
    ),
    array(
      'provider' => array('http://www.collegehumor.com/'),
      'providerName' => 'collegehumor',
      'info' => 'collegehumor.com video',
      'width' => 480,
      'height' => 360,
      'src' => 'http://www.collegehumor.com/moogaloop/moogaloop.swf?clip_id=~to_replace1~&fullscreen=1',
      'matchExpr' => 'collegehumor\\.com\\/video:([a-z0-9-_]+)',
    ),
    array(
      'provider' => array('http://www.cnet.com/'),
      'providerName' => 'cnet',
      'info' => 'cnet.com video',
      'width' => 364,
      'height' => 280,
      'src' => 'http://www.cnet.com/av/video/flv/universalPlayer/universalSmall.swf?playerType=embedded&type=id&value=~to_replace4~',
      'matchExpr' => 'cnettv\\.cnet\\.com\\/([a-z0-9-_]+)\\/([0-9]+)-([0-9_]+)-([0-9]+)',
    ),
    array(
      'provider' => array('http://www.glumbert.com/'),
      'providerName' => 'glumbert',
      'info' => 'glumbert.com video',
      'width' => 448,
      'height' => 336,
      'src' => 'http://www.glumbert.com/embed/~to_replace1~',
      'matchExpr' => 'glumbert\\.com\\/media\\/([0-9a-z]+)',
    ),
    array(
      'provider' => array('http://www.myvideo.at/', 'http://www.myvideo.de/', 'http://www.myvideo.ch/', 'http://www.myvideo.be/',
        'http://www.myvideo.nl/', 'http://www.myvideo.ro/'),
      'providerName' => 'myvideo',
      'info' => 'myvideo video',
      'width' => 470,
      'height' => 406,
      'src' => 'http://www.myvideo.~to_replace1~/movie/~to_replace2~',
      'matchExpr' => 'myvideo\\.(at|be|ch|de|nl|ro)\\/(?:watch|movie)\\/([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('https://video.yahoo.com/'),
      'providerName' => 'yahoo',
      'info' => 'video.yahoo.com video',
      'flashvars' => 'id=~to_replace2~&vid=~to_replace1~&lang=en-us&intl=us',
      'width' => 512,
      'height' => 322,
      'src' => 'https://d.yimg.com/static.video.yahoo.com/yep/YV_YEP.swf?ver=2.2.46&id=~to_replace2~&vid=~to_replace1~&lang=en-us&intl=us',
      'matchExpr' => 'video\\.yahoo\\.com\\/watch\\/([0-9a-z]+)\\/([0-9a-z]+)',
    ),
    array(
      'provider' => array('http://vids.myspace.com/'),
      'providerName' => 'myspace',
      'info' => 'myspace.com video',
      'width' => 425,
      'height' => 360,
      'src' => 'http://mediaservices.myspace.com/services/media/embed.aspx/m=~to_replace1~,t=1,mt=video',
      'matchExpr' => 'vids\\.myspace\\.com\\/.*VideoID=([0-9a-z]+)',
    ),
    array(
      'provider' => array('http://www.liveleak.com/'),
      'providerName' => 'liveleak',
      'info' => 'liveleak.com video',
      'width' => 450,
      'height' => 370,
      'src' => 'http://www.liveleak.com/e/~to_replace1~',
      'matchExpr' => 'liveleak\\.com\\/view\\?i=([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('https://vimeo.com/'),
      'providerName' => 'vimeo',
      'info' => 'vimeo.com video',
      'width' => 400,
      'height' => 255,
      'src' => 'https://vimeo.com/moogaloop.swf?clip_id=~to_replace1~&server=vimeo.com&show_title=1&show_byline=1&show_portrait=0&color=&fullscreen=1',
      'matchExpr' => 'vimeo\\.com\\/(?:[^#]*#)?([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.gametrailers.com/'),
      'providerName' => 'gametrailers',
      'info' => 'gametrailers.com video',
      'width' => 480,
      'height' => 392,
      'src' => 'http://www.gametrailers.com/remote_wrap.php?mid=~to_replace2~',
      'matchExpr' => 'gametrailers\\.com\\/(player|video.*)\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.ustream.tv/'),
      'providerName' => 'ustream',
      'providerIcon' => 'http://cdn2.ustream.tv/static/images/favicon:1.ico',
      'info' => 'ustream.tv video',
      'flashvars' => 'viewcount=true&autoplay=false&brand=embed',
      'width' => 400,
      'height' => 320,
      'src' => 'http://www.ustream.tv/flash/video/~to_replace1~',
      'matchExpr' => 'ustream\\.tv\\/recorded\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://clipshack.com/'),
      'providerName' => 'clipshack',
      'providerIcon' => 'none',
      'info' => 'clipshack.com video',
      'width' => 430,
      'height' => 370,
      'src' => 'http://clipshack.com/player.swf?key=~to_replace1~',
      'matchExpr' => 'clipshack\\.com\\/Clip\\.aspx\\?key=([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://funnyordie.com/'),
      'providerName' => 'funnyordie',
      'info' => 'funnyordie.com video',
      'width' => 480,
      'height' => 400,
      'src' => 'http://funnyordie.com/public/flash/fodplayer.swf?key=~to_replace1~',
      'matchExpr' => 'funnyordie\\.com\\/videos\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.filebox.ro/'),
      'providerName' => 'filebox',
      'info' => 'filebox.ro video',
      'flashvars' => 'source_script=http://videoserver273.filebox.ro/get_video.php&key=~to_replace1~&autostart=0&getLink=http://fbx.ro/v/~to_replace1~&splash=http://imageserver.filebox.ro/get_splash.php?key=~to_replace1~&link=http://fbx.ro/v/~to_replace1~',
      'width' => 420,
      'height' => 315,
      'src' => 'http://www.filebox.ro/video/FileboxPlayer_provider.php',
      'matchExpr' => 'filebox\\.ro\\/video\\/play_video\\.php\\?key=([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.last.fm/'),
      'providerName' => 'last',
      'info' => 'last.fm video',
      'flashvars' => 'uniqueName=~to_replace1~&autostart=&FSSupport=false&track=false&http://userserve-ak.last.fm/serve/image:320/~to_replace1~.jpg&title=&albumArt=&duration=&creator=',
      'width' => 450,
      'height' => 373,
      'src' => 'http://cdn.last.fm/videoplayer/l/15/VideoPlayer.swf?autostart=false',
      'matchExpr' => 'last\\.fm\\/music\\/.*\\/\\+videos\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.youku.com/'),
      'providerName' => 'youku',
      'info' => 'youku.com video',
      'width' => 480,
      'height' => 400,
      'src' => 'http://player.youku.com/player.php/sid/~to_replace1~/v.swf',
      'matchExpr' => 'youku\\.com\\/v_show\\/id_([0-9a-z-_=]+)\\.html',
    ),
    array(
      'provider' => array('http://ishare.rediff.com/'),
      'providerName' => 'rediff',
      'info' => 'rediff.com video',
      'flashvars' => 'videoURL=http://ishare.rediff.com/embedcodeplayer_config_REST.php?content_id=~to_replace1~&x=3',
      'width' => 400,
      'height' => 322,
      'src' => 'http://ishare.rediff.com/images/player_ad_20090416.swf',
      'matchExpr' => 'ishare\\.rediff\\.com\\/video\\/.*\\/([0-9a-z-_=]+)',
    ),
    array(
      'provider' => array('http://vision.rambler.ru/'),
      'providerName' => 'rambler',
      'info' => 'vision.rambler.ru video',
      'width' => 390,
      'height' => 370,
      'src' => 'http://vision.rambler.ru/i/e.swf?id=~to_replace1~/~to_replace2~/~to_replace3~&logo=1',
      'matchExpr' => 'vision\\.rambler\\.ru\\/users\\/([0-9a-z-_=]+)\\/([0-9a-z-_=]+)\\/([0-9a-z-_=]+)',
    ),
    array(
      'provider' => array('http://www.tudou.com/'),
      'providerName' => 'tudou',
      'info' => 'tudou.com video',
      'width' => 400,
      'height' => 340,
      'src' => 'http://www.tudou.com/v/~to_replace2~',
      'matchExpr' => 'tudou\\.com\\/(programs\\/view|v)\\/([0-9a-z-_=]+)',
    ),
    array(
      'provider' => array('http://www.ku6.com/'),
      'providerName' => 'ku6',
      'info' => 'ku6.com video',
      'width' => 414,
      'height' => 305,
      'src' => 'http://player.ku6.com/refer/~to_replace1~/v.swf',
      'matchExpr' => 'ku6\\.com\\/.*show.*\\/([0-9a-z-_=]+)\\.html',
    ),
    array(
      'provider' => array('http://www.tinypic.com/'),
      'providerName' => 'tinypic',
      'info' => 'tinypic.com video',
      'width' => 440,
      'height' => 420,
      'src' => 'http://v5.tinypic.com/player.swf?file=~to_replace1~&s=~to_replace2~',
      'matchExpr' => 'tinypic\\.com\\/player.php\\?v=([0-9a-z-_]+)&s=([0-9]+)',
    ),
    array(
      'provider' => array('http://video.libero.it/'),
      'providerName' => 'libero',
      'info' => 'libero.it video',
      'width' => 440,
      'height' => 420,
      'src' => 'http://video.libero.it/static/swf/eltvplayer.swf?id=~to_replace1~.flv&ap=0',
      'matchExpr' => 'video\\.libero\\.it\\/app\\/play\\?id=([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://espn.go.com/'),
      'providerName' => 'espn',
      'info' => 'espn.go.com video',
      'width' => 440,
      'height' => 361,
      'src' => 'http://espn.go.com/broadband/player.swf?mediaId=~to_replace1~',
      'matchExpr' => 'espn\\.go\\.com\\/video\\/clip\\?id=([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.nfl.com/'),
      'providerName' => 'nfl',
      'info' => 'nfl.com video',
      'flashvars' => 'autoplay=0&contentId=~to_replace2~&channelId=~to_replace1~',
      'width' => 768,
      'height' => 432,
      'src' => 'http://static.nfl.com/static/site/flash/video/video-detail-player.swf',
      'matchExpr' => 'nfl\\.com\\/videos\\/([0-9a-z-_]+)\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://video.web.de/'),
      'providerName' => 'web',
      'providerIcon' => 'http://img.web.de/v/web.ico',
      'info' => 'web.de video',
      'width' => 470,
      'height' => 406,
      'src' => 'http://video.web.de/movie/~to_replace1~',
      'matchExpr' => 'video\\.web\\.de\\/watch\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://video.eksenim.mynet.com/'),
      'providerName' => 'mynet',
      'providerIcon' => 'http://img3.mynet.com/eksenim/favicon.ico',
      'info' => 'eksenim.mynet.com video',
      'flashvars' => 'videolist=http://video.eksenim.mynet.com/batch/video_xml_embed.php?video_id=~to_replace1~&adxml=&autoplay=0',
      'width' => 400,
      'height' => 344,
      'src' => 'http://video.eksenim.mynet.com/flvplayers/vplayer17.swf',
      'matchExpr' => 'video\\.eksenim\\.mynet\\.com\\/[0-9a-z-_\\.]+\\/[0-9a-z-_]+\\/([0-9]+)',
    ),
    array(
      'provider' => array('http://video.mynet.com/'),
      'providerName' => 'mynet',
      'providerIcon' => 'none',
      'info' => 'video.mynet.com video',
      'width' => 400,
      'height' => 344,
      'src' => 'http://video.mynet.com/~to_replace1~/~to_replace2~/~to_replace3~.swf',
      'matchExpr' => 'video\\.mynet\\.com\\/([0-9a-z-_\\.]+)\\/([0-9a-z-_]+)\\/([0-9]+)',
    ),
    array(
      'provider' => array('http://www.rutube.ru/'),
      'providerName' => 'rutube',
      'info' => 'rutube.ru video',
      'width' => 470,
      'height' => 353,
      'src' => 'http://video.rutube.ru/~to_replace1~',
      'matchExpr' => 'rutube\\.ru\\/tracks\\/[0-9+]+\\.html\\?.*&?v=([0-9a-z-_=]+)',
    ),
    array(
      'provider' => array('http://www.livevideo.com/'),
      'providerName' => 'livevideo',
      'info' => 'livevideo.com video',
      'width' => 445,
      'height' => 369,
      'src' => 'http://www.livevideo.com/flvplayer/embed/~to_replace2~&autoStart=0',
      'matchExpr' => 'livevideo\\.com\\/video(.*|.{0})\\/([0-9a-z]+)\\/.*\\.aspx',
    ),
    array(
      'provider' => array('http://www.vbox7.com/'),
      'providerName' => 'vbox7',
      'info' => 'vbox7.com video',
      'width' => 450,
      'height' => 403,
      'src' => 'http://i48.vbox7.com/player/ext.swf?vid=~to_replace1~',
      'matchExpr' => 'vbox7\\.com\\/play:([0-9a-z-_=]+)',
    ),
    array(
      'provider' => array('http://www.revver.com/'),
      'providerName' => 'revver',
      'providerIcon' => 'http://static2.revver.com/images/favicon.ico',
      'info' => 'revver.com video',
      'width' => 480,
      'height' => 392,
      'src' => 'http://flash.revver.com/player/1.0/player.swf?mediaId=~to_replace1~',
      'matchExpr' => 'revver\\.com\\/video\\/([0-9a-z-_=]+)',
    ),
    array(
      'provider' => array('http://current.com/'),
      'providerName' => 'current',
      'info' => 'current.com video',
      'width' => 400,
      'height' => 286,
      'src' => 'http://current.com/e/~to_replace1~/en_US',
      'matchExpr' => 'current\\.com\\/items\\/([0-9a-z-=]+)_',
    ),
    array(
      'provider' => array('http://www.dalealplay.com/'),
      'providerName' => 'dalealplay',
      'info' => 'dalealplay.com video',
      'width' => 464,
      'height' => 380,
      'src' => 'http://www.dalealplay.com/smarty/dap/embedplayer.swf?file=~to_replace1~/busadoraWisinYandel.flv&videoValoracion=0.00&autoStart=false',
      'matchExpr' => 'dalealplay\\.com\\/informaciondecontenido\\.php\\?con=([0-9a-z-_=]+)',
    ),
    array(
      'provider' => array('http://www.clipfish.de/'),
      'providerName' => 'clipfish',
      'providerIcon' => 'http://bilder.clipfish.de/v2/favicon.ico',
      'info' => 'clipfish.de video',
      'width' => 450,
      'height' => 390,
      'src' => 'http://www.clipfish.de/videoplayer.swf?as=0&vid=~to_replace1~&r=1',
      'matchExpr' => 'clipfish\\.de.*\\/video\\/([0-9a-z-_=]+)\\/',
    ),
    array(
      'provider' => array('http://clip.vn/'),
      'providerName' => 'clip',
      'info' => 'clip.vn video',
      'width' => 450,
      'height' => 390,
      'src' => 'http://clip.vn/w/~to_replace1~',
      'matchExpr' => 'clip\\.vn\\/watch\\/[0-9a-z-_=]+,([0-9a-z-_=]+)',
    ),
    array(
      'provider' => array('http://livestream.com/'),
      'providerName' => 'livestream',
      'info' => 'livestream.com video',
      'width' => 400,
      'height' => 400,
      'src' => 'http://static.livestream.com/grid/PlayerV2.swf?channel=~to_replace1~&layout=playerEmbedDefault&backgroundColor=0xffffff&backgroundAlpha=1&backgroundGradientStrength=0&chromeColor=0x000000&headerBarGlossEnabled=true&controlBarGlossEnabled=true&chatInputGlossEnabled=false&uiWhite=true&uiAlpha=0.5&uiSelectedAlpha=1&dropShadowEnabled=true&dropShadowHorizontalDistance=10&dropShadowVerticalDistance=10&paddingLeft=10&paddingRight=10&paddingTop=10&paddingBottom=10&cornerRadius=10&backToDirectoryURL=null&showViewers=true&embedEnabled=true&chatEnabled=true&onDemandEnabled=true&programGuideEnabled=false&fullScreenEnabled=true&reportAbuseEnabled=false&gridEnabled=false&initialIsOn=true&initialIsMute=false&initialVolume=10&contentId=null&initThumbUrl=null&playeraspectwidth=4&playeraspectheight=3&mogulusLogoEnabled=true',
      'matchExpr' => 'livestream\\.com\\/([0-9a-z-_=]+)',
    ),
    array(
      'provider' => array('http://www.tangle.com/'),
      'providerName' => 'tangle',
      'info' => 'tangle.com video',
      'flashvars' => 'viewkey=~to_replace2~',
      'width' => 330,
      'height' => 270,
      'src' => 'http://www.tangle.com/flash/swf/flvplayer.swf',
      'matchExpr' => 'tangle\\.com\\/view_video(\\.php|.*)\\?viewkey=([0-9a-z-_=]+)',
    ),
    array(
      'provider' => array('http://www.vidiac.com/'),
      'providerName' => 'vidiac',
      'info' => 'vidiac.com video',
      'width' => 400,
      'height' => 350,
      'src' => 'http://www.vidiac.com/vidiac.swf?video=~to_replace1~&servicecfg=386',
      'matchExpr' => 'vidiac\\.com\\/video\\/([0-9a-z-_=]+)\\.htm',
    ),
    array(
      'provider' => array('http://www.5min.com/'),
      'providerName' => '5min',
      'info' => '5min.com video',
      'width' => 480,
      'height' => 401,
      'src' => 'http://www.5min.com/Embeded/~to_replace1~/',
      'matchExpr' => '5min\\.com\\/Video\\/.*-([0-9]+)',
    ),
    array(
      'provider' => array('http://video.vol.at/'),
      'providerName' => 'vol',
      'info' => 'vol.at video',
      'width' => 480,
      'height' => 388,
      'src' => 'http://video.vol.at/media_tp/custom/flowplayer/swf/FlowPlayerDark.swf?config={embedded:true,baseURL:\'http://video.vol.at/media_tp/custom/flowplayer/swf\',loop:false,playList:[{suggestedClipsInfoUrl:\'http://video.vol.at/suggestions.php?id=~to_replace1~\',url:\'http://video.vol.at/media/video_at/~to_replace1~.flv\'}],initialScale:\'scale\',controlBarBackgroundColor:\'0x000000\',autoBuffering:true,autoPlay:false}',
      'matchExpr' => 'video\\.vol\\.at\\/video\\/([0-9a-z-_=]+)',
    ),
    array(
      'provider' => array('http://www.wegame.com/'),
      'providerName' => 'wegame',
      'info' => 'wegame.com video',
      'flashvars' => 'xmlrequest=http://www.wegame.com/player/video/~to_replace1~&embedPlayer=true',
      'width' => 480,
      'height' => 387,
      'src' => 'http://www.wegame.com/static/flash/player.swf?xmlrequest=http://www.wegame.com//player/video/~to_replace0~',
      'matchExpr' => 'wegame\\.com\\/watch\\/([0-9a-z-_=]+)',
    ),
    array(
      'provider' => array('http://ikbis.com/'),
      'providerName' => 'ikbis',
      'info' => 'ikbis.com video',
      'width' => 425,
      'height' => 344,
      'src' => 'http://ikbis.com/swf/embded_flv.swf?video_id=~to_replace1~&fullscreenmode=false&file=http://ikbis.com/playlist_feed/~to_replace1~&image=http://shots.ikbis.com/video_thumbnail/~to_replace1~/screen/video.jpg&autostart=false&overstretch=fit&ply_color=undefined',
      'matchExpr' => 'ikbis\\.com\\/[0-9a-z-_=]+\\/shot\\/([0-9a-z-_=]+)',
    ),
    array(
      'provider' => array('http://www.youmaker.com/'),
      'providerName' => 'youmaker',
      'providerIcon' => 'none',
      'info' => 'youmaker.com video',
      'flashvars' => 'file=http://www.youmaker.com/video/v?id=~to_replace1~%26nu%3Dnu&showdigits=true&overstretch=fit&autostart=false&rotatetime=12&linkfromdisplay=false&repeat=list&shuffle=false&&showfsbutton=false&fsreturnpage=&fullscreenpage=',
      'width' => 450,
      'height' => 358,
      'src' => 'http://www.youmaker.com/v.swf',
      'matchExpr' => 'youmaker\\.com\\/video\\/sv\\?id=([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.snotr.com/'),
      'providerName' => 'snotr',
      'providerIcon' => 'http://s.mnstat.com/images/favicon.ico',
      'info' => 'snotr.com video',
      'flashvars' => 'video=~to_replace1~&autoload=false&autoplay=false&startat=0',
      'width' => 520,
      'height' => 390,
      'src' => 'http://www.snotr.com/player.swf?v6',
      'matchExpr' => 'snotr\\.com\\/video\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.onetruemedia.com/'),
      'providerName' => 'onetruemedia',
      'info' => 'onetruemedia.com video',
      'flashvars' => '&p=~to_replace2~&skin_id=&host=http://www.onetruemedia.com',
      'width' => 408,
      'height' => 382,
      'src' => 'http://www.onetruemedia.com/share_view_player?p=~to_replace2~',
      'matchExpr' => 'onetruemedia\\.com\\/(shared|otm_site\\/view_shared)\\?p=([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://clevver.com/'),
      'providerName' => 'clevver',
      'providerIcon' => 'none',
      'info' => 'clevver.com video',
      'width' => 428,
      'height' => 380,
      'src' => 'http://i.clevver.com/flash/clvembed.swf?vid=~to_replace2~',
      'matchExpr' => 'clevver.com(\\/.*|.?)\\/videof\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.kewego.com/'),
      'providerName' => 'kewego',
      'info' => 'kewego.com video',
      'flashvars' => 'playerKey=061ca722fea8&skinKey=&language_code=en&stat=internal&autoStart=false&sig=~to_replace1~',
      'width' => 400,
      'height' => 300,
      'src' => 'http://sa.kewego.com/swf/p3/epix.swf',
      'matchExpr' => 'kewego\\.com\\/video\\/([0-9a-z-_]+)\\.html',
    ),
    array(
      'provider' => array('http://www.clipser.com/'),
      'providerName' => 'clipser',
      'info' => 'clipser.com video',
      'width' => 425,
      'height' => 355,
      'src' => 'http://www.clipser.com/Play?vid=~to_replace1~',
      'matchExpr' => 'clipser\\.com\\/watch_video\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.dailyhaha.com/'),
      'providerName' => 'dailyhaha',
      'info' => 'dailyhaha.com video',
      'width' => 425,
      'height' => 350,
      'src' => 'http://www.dailyhaha.com/_vids/Whohah.swf?Vid=~to_replace1~.flv',
      'matchExpr' => 'dailyhaha\\.com\\/_vids\\/([0-9a-z-_]+)\\.htm',
    ),
    array(
      'provider' => array('http://www.howcast.com/'),
      'providerName' => 'howcast',
      'info' => 'howcast.com video',
      'width' => 432,
      'height' => 276,
      'src' => 'http://www.howcast.com/flash/howcast_player.swf?file=~to_replace1~&theme=black',
      'matchExpr' => 'howcast\\.com\\/videos\\/([0-9]+)',
    ),
    array(
      'provider' => array('http://www.aniboom.com/'),
      'providerName' => 'aniboom',
      'info' => 'aniboom.com video',
      'width' => 594,
      'height' => 334,
      'src' => 'http://api.aniboom.com/e/~to_replace1~',
      'matchExpr' => 'aniboom\\.com\\/animation-video\\/([0-9]+)',
    ),
    array(
      'provider' => array('http://www.bragster.com/'),
      'providerName' => 'bragster',
      'info' => 'bragster.com video',
      'flashvars' => 'autoPlay=false&brag_id=~to_replace1~',
      'width' => 420,
      'height' => 315,
      'src' => 'http://www.bragster.com/flash/bragster_player_embed.swf',
      'matchExpr' => 'bragster\\.com\\/brags\\/([0-9]+)-',
    ),
    array(
      'provider' => array('http://www.teachertube.com/'),
      'providerName' => 'teachertube',
      'info' => 'teachertube.com video',
      'flashvars' => 'file=http://www.teachertube.com/embedFLV.php?pg=video_~to_replace1~&menu=false&frontcolor=ffffff&lightcolor=FF0000&logo=http://www.teachertube.com/www3/images/greylogo.swf&skin=http://www.teachertube.com/embed/overlay.swf&volume=80&controlbar=over&displayclick=link&viral.link=http://www.teachertube.com/viewVideo.php?video_id=~to_replace1~&stretching=exactfit&plugins=viral-1&viral.callout=none&viral.onpause=false',
      'width' => 470,
      'height' => 260,
      'src' => 'http://www.teachertube.com/embed/player.swf',
      'matchExpr' => 'teachertube\\.com\\/viewVideo\\.php\\?video_id=([0-9]+)',
    ),
    array(
      'provider' => array('http://www.shredordie.com/'),
      'providerName' => 'shredordie',
      'info' => 'shredordie.com video',
      'flashvars' => 'key=~to_replace1~&vert=shredordie',
      'width' => 480,
      'height' => 400,
      'src' => 'http://player.ordienetworks.com/flash/fodplayer.swf',
      'matchExpr' => 'shredordie\\.com\\/videos\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.talentrun.com/'),
      'providerName' => 'talentrun',
      'info' => 'talentrun.com video',
      'flashvars' => 'autostart=false&id=~to_replace1~&mode=splay&extUrl=http://www.talentrun.com/',
      'width' => 454,
      'height' => 421,
      'src' => 'http://www.talentrun.com/player/trp/',
      'matchExpr' => 'talentrun\\.com\\/player\\/index\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.autsch.de/'),
      'providerName' => 'autsch',
      'info' => 'autsch.de video',
      'flashvars' => 'pk=~to_replace1~&displayheight=338&autostart=false',
      'width' => 450,
      'height' => 370,
      'src' => 'http://www.autsch.de/playerext/~to_replace1~',
      'matchExpr' => 'autsch\\.de\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://tvbvideo.de/'),
      'providerName' => 'tvbvideo',
      'providerIcon' => 'none',
      'info' => 'tvbvideo.de video',
      'flashvars' => 'playerKey=a67dd9fb6a97&skinKey=&language_code=de&stat=internal&advertise=false&autoStart=false&sig=~to_replace1~',
      'width' => 400,
      'height' => 300,
      'src' => 'http://sa.kewego.com/swf/p3/epix.swf',
      'matchExpr' => 'tvbvideo\\.de\\/video\\/([0-9a-z-_]+)\\.html',
    ),
    array(
      'provider' => array('http://www.clipmoon.com/'),
      'providerName' => 'clipmoon',
      'info' => 'clipmoon.com video',
      'flashvars' => 'config=http://www.clipmoon.com/flvplayer.php?viewkey=~to_replace1~&external=no',
      'width' => 500,
      'height' => 357,
      'src' => 'http://www.clipmoon.com/flvplayer.swf',
      'matchExpr' => 'clipmoon\\.com\\/videos\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.viddyou.com/'),
      'providerName' => 'viddyou',
      'info' => 'viddyou.com video',
      'width' => 640,
      'height' => 480,
      'src' => 'http://www.viddyou.com/get/v2_full/~to_replace1~.swf',
      'matchExpr' => 'viddyou\\.com\\/viddstream\\?videoid=([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.mindbites.com/'),
      'providerName' => 'mindbites',
      'info' => 'mindbites.com video',
      'width' => 554,
      'height' => 316,
      'src' => 'http://www.mindbites.com/v/~to_replace1~',
      'matchExpr' => 'mindbites\\.com\\/lesson\\/([0-9a-z_]+)-',
    ),
    array(
      'provider' => array('http://www.jujunation.com/'),
      'providerName' => 'jujunation',
      'info' => 'jujunation.com video',
      'flashvars' => 'config=http://www.jujunation.com/videoConfigXmlCode.php?pg=video_~to_replace1~_no_0_extsite&autoPlay=false',
      'width' => 450,
      'height' => 370,
      'src' => 'http://www.jujunation.com/flvplayer_elite.swf',
      'matchExpr' => 'jujunation\\.com\\/viewVideo\\.php\\?video_id=([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.rooftopcomedy.com/'),
      'providerName' => 'rooftopcomedy',
      'info' => 'rooftopcomedy.com video',
      'flashvars' => 'baseURL=http://www.rooftopcomedy.com&clipCode=~to_replace1~',
      'width' => 448,
      'height' => 292,
      'src' => 'http://www.rooftopcomedy.com/flash/fmpv3/RooftopPlayerEmbedded.swf',
      'matchExpr' => 'rooftopcomedy\\.com\\/watch\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://hamburg1video.de/'),
      'providerName' => 'hamburg1video',
      'providerIcon' => 'http://www.hamburg1video.de/img/hamburg1video/favicon.ico',
      'info' => 'hamburg1video.de video',
      'flashvars' => 'playerKey=acd17bc8b8f7&skinKey=&language_code=de&stat=internal&advertise=false&autoStart=false&sig=~to_replace1~',
      'width' => 400,
      'height' => 300,
      'src' => 'http://sa.kewego.com/swf/p3/epix.swf',
      'matchExpr' => 'hamburg1video\\.de\\/video\\/([0-9a-z-_]+)\\.html',
    ),
    array(
      'provider' => array('http://videos.caught-on-video.com/'),
      'providerName' => 'caught-on-video',
      'info' => 'caught-on-video.com video',
      'flashvars' => 'video=~to_replace1~',
      'width' => 428,
      'height' => 352,
      'src' => 'http://videos.caught-on-video.com/vidiac.swf',
      'matchExpr' => 'videos\\.caught-on-video\\.com\\/.*\\/[0-9]+\\/([0-9a-z-_]+)\\.htm',
    ),
    array(
      'provider' => array('http://bubblare.se/'),
      'providerName' => 'bubblare',
      'providerIcon' => 'http://bubblare.se/public/images/favicon.ico',
      'info' => 'bubblare.se video',
      'width' => 425,
      'height' => 350,
      'src' => 'http://bubblare.se/v/~to_replace1~/',
      'matchExpr' => 'bubblare\\.se\\/movie\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://jaycut.com/'),
      'providerName' => 'jaycut',
      'providerIcon' => 'http://jaycut.com/sites/all/themes/jaycut/images/favicon.ico',
      'info' => 'jaycut.com video v1',
      'flashvars' => 'file=http://jaycut.com/videos/send_preview/~to_replace1~&type=flv&returnUrl=http://jaycut.com/&locale=en&author=Toffan&autostart=false&mixerUrl=http://jaycut.com/mixer&inviteFriendsUrl=http://jaycut.com/myjaycut/friends/invite&createGroupUrl=http://jaycut.com/group/create&image=http://jaycut.com/video/~to_replace1~/thumbnail_big.jpeg&profileUrl=',
      'width' => 408,
      'height' => 324,
      'src' => 'http://jaycut.com/flash/preview.swf',
      'matchExpr' => 'jaycut\\.com\\/video\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://jaycut.com/'),
      'providerName' => 'jaycut',
      'providerIcon' => 'http://jaycut.com/sites/all/themes/jaycut/images/favicon.ico',
      'info' => 'jaycut.com video v2',
      'flashvars' => 'file=http://jaycut.com/mixes/send_preview/~to_replace1~&type=flv&returnUrl=http://jaycut.com/&locale=en&author=Toffan&autostart=false&mixerUrl=http://jaycut.com/mixer&inviteFriendsUrl=http://jaycut.com/myjaycut/friends/invite&createGroupUrl=http://jaycut.com/group/create&image=http://jaycut.com/video/~to_replace1~/thumbnail_big.jpeg&profileUrl=',
      'width' => 408,
      'height' => 324,
      'src' => 'http://jaycut.com/flash/preview.swf',
      'matchExpr' => 'jaycut\\.com\\/mix\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.spotn.de/'),
      'providerName' => 'spotn',
      'info' => 'spotn.de video',
      'flashvars' => 'config=http://www.spotn.de/flvplayer.php?viewkey=~to_replace1~',
      'width' => 450,
      'height' => 370,
      'src' => 'http://www.spotn.de/videoplayer.swf',
      'matchExpr' => 'spotn\\.de\\/watch\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.thexvid.com/'),
      'providerName' => 'thexvid',
      'info' => 'thexvid.com video',
      'width' => 600,
      'height' => 369,
      'src' => 'http://www.thexvid.com/plr/~to_replace1~/video.swf',
      'matchExpr' => 'thexvid\\.com\\/video\\/([0-9a-z-_]+)-',
    ),
    array(
      'provider' => array('http://www.scivee.tv/'),
      'providerName' => 'scivee',
      'info' => 'scivee.tv video',
      'flashvars' => 'id=~to_replace1~&type=4',
      'width' => 480,
      'height' => 400,
      'src' => 'http://www.scivee.tv/flash/embedCast.swf',
      'matchExpr' => 'scivee\\.tv\\/node\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.tvosz.com/'),
      'providerName' => 'tvosz',
      'info' => 'tvosz.com video',
      'width' => 470,
      'height' => 380,
      'src' => 'http://www.tvosz.com/gtembed.swf?key=~to_replace1~',
      'matchExpr' => 'tvosz\\.com\\/view_video\\.php\\?viewkey=([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.dailycomedy.com/'),
      'providerName' => 'dailycomedy',
      'providerIcon' => 'none',
      'info' => 'dailycomedy.com video',
      'width' => 320,
      'height' => 240,
      'src' => 'http://www.dailycomedy.com/videos/DCVideoPlayerII_HTTP.swf?videoid=~to_replace1~',
      'matchExpr' => 'dailycomedy\\.com\\/videos\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.deutschlandreporter.de/'),
      'providerName' => 'deutschlandreporter',
      'info' => 'deutschlandreporter.de video',
      'width' => 480,
      'height' => 360,
      'src' => 'http://www.deutschlandreporter.de/flvplayer.swf?mediaid=~to_replace1~&hosturl=http://www.deutschlandreporter.de/&themecolor=0x99B3CC&symbolcolor=0x000000&backgroundcolor=0xFFFFFF&autostart=false&loop=false&overlay=http://www.deutschlandreporter.de//media/custom/player_emb.png',
      'matchExpr' => 'deutschlandreporter\\.de\\/videos\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.motorsportmad.com/'),
      'providerName' => 'motorsportmad',
      'info' => 'motorsportmad.com video',
      'width' => 320,
      'height' => 260,
      'src' => 'http://www.motorsportmad.com/flvplayer.swf?file=http://media.motorsportmad.net.s3.amazonaws.com/~to_replace1~.flv&showfsbutton=true',
      'matchExpr' => 'motorsportmad\\.com\\/view\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.rheinvideo.de/'),
      'providerName' => 'rheinvideo',
      'info' => 'rheinvideo.de video',
      'flashvars' => 'apiHost=apiwww.rheinvideo.de',
      'width' => 425,
      'height' => 350,
      'src' => 'http://www.rheinvideo.de/pl/~to_replace1~/425x350/swf',
      'matchExpr' => 'rheinvideo\\.de\\/videos\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.selfcasttv.com/'),
      'providerName' => 'selfcasttv',
      'providerIcon' => 'none',
      'info' => 'selfcasttv.com video',
      'width' => 340,
      'height' => 283,
      'src' => 'http://www.selfcasttv.com/Selfcast/selfcast.swf?video_1=/~to_replace1~',
      'matchExpr' => 'selfcasttv\\.com\\/Selfcast\\/playVideo\\.do\\?ref=([0-9a-z-_\\/]+)',
    ),
    array(
      'provider' => array('http://myubo.com/', 'http://myubo.sk/'),
      'providerName' => 'myubo',
      'providerIcon' => 'none',
      'info' => 'myubo.com video',
      'width' => 470,
      'height' => 386,
      'src' => 'http://myubo.com/storage/cms/flashPlayer/player.swf?movieURL=http://www.myubo.sk/videa/1/VideoDisk/Media/~to_replace1~/~to_replace2~/flv_~to_replace1~~to_replace2~~to_replace3~~to_replace4~~to_replace5~~to_replace6~~to_replace7~.flv',
      'matchExpr' => 'myubo\\.(?:sk|com)\\/page\\/media_detail\\.html\\?movieid=([0-9a-z]{2})([0-9a-z]{2})([0-9a-z]+)-([0-9a-z]+)-([0-9a-z]+)-([0-9a-z]+)-([0-9a-z]+)',
    ),
    array(
      'provider' => array('http://www.gettyload.de/'),
      'providerName' => 'gettyload',
      'providerIcon' => 'none',
      'info' => 'gettyload.de video',
      'width' => 425,
      'height' => 350,
      'src' => 'http://www.gettyload.de/flashplayer/video_embed.swf?xmlFile=~to_replace1~',
      'matchExpr' => 'gettyload\\.de\\/video\\/[a-z0-9-_]+\\/([0-9a-z]+)',
    ),
    array(
      'provider' => array('http://www.cliphost24.com/'),
      'providerName' => 'cliphost24',
      'info' => 'cliphost24.com video',
      'flashvars' => 'config=http://www.cliphost24.com/share/~to_replace1~/',
      'width' => 400,
      'height' => 320,
      'src' => 'http://www.cliphost24.com/flashplayer',
      'matchExpr' => 'cliphost24\\.com\\/videoclip-([0-9a-z]+)\\.html',
    ),
    array(
      'provider' => array('http://ka.uvuvideo.org/'),
      'providerName' => 'uvuvideo',
      'info' => 'uvuvideo.org video',
      'flashvars' => 'affiliateSiteId=~to_replace2~&widgetId=110617&width=510&height=419&revision=12&kaShare=1&mediaType_mediaID=video_~to_replace1~&autoPlay=0',
      'width' => 510,
      'height' => 419,
      'src' => 'http://serve.a-widget.com/service/getWidgetSwf.kickAction',
      'matchExpr' => 'ka\\.uvuvideo\\.org\\/[0-9a-z-_]+\\/video\\/([0-9a-z]+)\\/([0-9a-z]+)\\.html',
    ),
    array(
      'provider' => array('http://www.crovideos.com/'),
      'providerName' => 'crovideos',
      'info' => 'crovideos.com video',
      'flashvars' => '&file=http://www.crovideos.com/flvideo/~to_replace1~.flv&height=260&width=320&frontcolor=0xCCCCCC&backcolor=0x6666FF&lightcolor=0xEEEEEE&logo=http://www.crovideos.com/crovideos-logo-player.png',
      'width' => 320,
      'height' => 260,
      'src' => 'http://www.crovideos.com/player.swf?file=http://www.crovideos.com/flvideo/~to_replace1~.flv&height=260&width=320&frontcolor=0xCCCCCC&backcolor=0x6666FF&lightcolor=0xEEEEEE&logo=http://www.crovideos.com/crovideos-logo-player.png',
      'matchExpr' => 'crovideos\\.com\\/video\\/([0-9a-z]+)',
    ),
    array(
      'provider' => array('http://www.qubetv.tv/'),
      'providerName' => 'qubetv',
      'providerIcon' => 'none',
      'info' => 'qubetv.tv video',
      'flashvars' => 'file=/videos/~to_replace1~/~to_replace1~.flv&autostart=false',
      'width' => 320,
      'height' => 240,
      'src' => 'http://www.qubetv.tv/swf/flvplayer.swf',
      'matchExpr' => 'qubetv\\.tv\\/videos\\/detail\\/([0-9a-z]+)',
    ),
    array(
      'provider' => array('http://citytube.de/'),
      'providerName' => 'citytube',
      'providerIcon' => 'none',
      'info' => 'citytube.de video',
      'width' => 450,
      'height' => 390,
      'src' => 'http://stream.city-tube.de/player.swf?m=~to_replace2~',
      'matchExpr' => 'citytube\\.de\\/(\\?m=|tube\\/movie\\/)([0-9a-z]+)',
    ),
    array(
      'provider' => array('http://constantcomedy.com/'),
      'providerName' => 'constantcomedy',
      'info' => 'constantcomedy.com video',
      'width' => 430,
      'height' => 360,
      'src' => 'http://constantcomedy.com/swfs/embedPlayer.swf?ccVideo=~to_replace1~',
      'matchExpr' => 'constantcomedy\\.com\\/Video\\.aspx\\?id=([0-9a-z]+)',
    ),
    array(
      'provider' => array('http://www.luegmol.ch/'),
      'providerName' => 'luegmol',
      'info' => 'luegmol.ch video',
      'flashvars' => 'config=http://www.luegmol.ch/player/luegmol_player_config_ext.php?vkey=~to_replace1~',
      'width' => 500,
      'height' => 395,
      'src' => 'http://www.luegmol.ch/player/luegmol_player.swf',
      'matchExpr' => 'luegmol\\.ch\\/video\\/([0-9a-z]+)',
    ),
    array(
      'provider' => array('http://www.mantoutv.com/'),
      'providerName' => 'mantoutv',
      'providerIcon' => 'none',
      'info' => 'mantoutv.com video',
      'flashvars' => 'config=http://www.mantoutv.com/flvplayer.php?viewkey=~to_replace1~',
      'width' => 450,
      'height' => 370,
      'src' => 'http://www.mantoutv.com/videoplayer.swf',
      'matchExpr' => 'mantoutv\\.com\\/videoview_([0-9a-z]+)\\.html',
    ),
    array(
      'provider' => array('http://www.clonevideos.com/'),
      'providerName' => 'clonevideos',
      'info' => 'clonevideos.com video',
      'width' => 450,
      'height' => 375,
      'src' => 'http://www.clonevideos.com/videowatchproplayer.swf?file=http://www.clonevideos.com/vdata/~to_replace1~.flv&vid=~to_replace1~&baseurl=http://www.clonevideos.com/&e=y',
      'matchExpr' => 'clonevideos\\.com\\/videos\\/([0-9a-z]+)',
    ),
    array(
      'provider' => array('http://www.realitatea.net/'),
      'providerName' => 'realitatea',
      'info' => 'realitatea.net video',
      'width' => 480,
      'height' => 380,
      'src' => 'http://www.realitatea.net/images/player/playlist_player.swf?url=1&id=~to_replace1~&autostart=false&showdigits=true&bufferlength=10&allowscriptaccess=always&recommendations=http://www.realitatea.net/feed_recommendations.php?id=~to_replace1~',
      'matchExpr' => 'realitatea\\.net\\/video_([0-9a-z]+)_',
    ),
    array(
      'provider' => array('http://www.mtv.com/'),
      'providerName' => 'mtv',
      'info' => 'mtv.com video v1',
      'flashvars' => 'configParams=id=~to_replace2~&vid=~to_replace0~&uri=mgid:uma:video:mtv.com:~to_replace1~&startUri=(startUri)',
      'width' => 512,
      'height' => 319,
      'src' => 'http://media.mtvnservices.com/mgid:uma:video:mtv.com:~to_replace1~',
      'matchExpr' => 'mtv\\.com\\/videos\\/.*\\/([0-9a-z]+)\\/.*#id=([0-9a-z]+)',
    ),
    array(
      'provider' => array('http://www.mtv.com/'),
      'providerName' => 'mtv',
      'info' => 'mtv.com video v2',
      'flashvars' => 'configParams=vid=~to_replace1~',
      'width' => 512,
      'height' => 319,
      'src' => 'http://media.mtvnservices.com/mgid:uma:video:mtv.com:~to_replace1~',
      'matchExpr' => 'mtv\\.com\\/videos\\/.*\\/([0-9]+)\\/',
    ),
    array(
      'provider' => array('http://www.rocktube.us/'),
      'providerName' => 'rocktube',
      'providerIcon' => 'none',
      'info' => 'rocktube.us video',
      'width' => 450,
      'height' => 366,
      'src' => 'http://www.rocktube.us/embedded/~to_replace1~',
      'matchExpr' => 'rocktube\\.us\\/([0-9a-z]+)',
    ),
    array(
      'provider' => array('http://myplay.com/'),
      'providerName' => 'myplay',
      'info' => 'myplay.com video',
      'flashvars' => 'videoId=~to_replace1~&playerId=271548504&viewerSecureGatewayURL=https://console.brightcove.com/services/amfgateway&servicesURL=http://services.brightcove.com/services&cdnURL=http://admin.brightcove.com&domain=embed&autoStart=false&',
      'width' => 425,
      'height' => 344,
      'src' => 'http://c.brightcove.com/services/viewer/federated_f8/271548504',
      'matchExpr' => 'myplay\\.com\\/video-player\\/[0-9a-z-_]+\\/\\?bcpid=[0-9a-z-_]+&bclid=[0-9a-z-_]+&bctid=([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.123video.nl/'),
      'providerName' => '123video',
      'info' => '123video.nl video',
      'width' => 420,
      'height' => 339,
      'src' => 'http://www.123video.nl/123video_share.swf?mediaSrc=~to_replace2~',
      'matchExpr' => '123video\\.nl\\/(playvideos\\.asp\\?MovieID|123video_share\\.swf\\?mediaSrc)=([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.9you.com/'),
      'providerName' => '9you',
      'info' => '9You.com video',
      'width' => 960,
      'height' => 480,
      'src' => 'http://v.9you.com/fplayer/player_watch.swf?flvID=~to_replace1~',
      'matchExpr' => '9you\\.com\\/watch\\/([0-9a-z-_]+)',
    ),
    array(
      'provider' => array('http://www.blastro.com/'),
      'providerName' => 'blastro',
      'info' => 'blastro.com video',
      'width' => 512,
      'height' => 408,
      'src' => 'http://images.blastro.com/images/flashplayer/flvPlayer.swf?site=www.blastro.com&filename=~to_replace1~&pageID=&soundLevel=100&embed=&user_ID=-1&playlistMode=ondemand&playlist_id=&adsource=&channel=&keywords=&vid_pos=&artist_name=&quality=700&content_provider=&player_mode=&player_size=&autoplay=false&shuffle=&preroll_provider=&overlay_provider=&endcap_provider=&paidContent=&syndicated_pos=&getVars=detect_mediatype%3Dflv;detect_bitrate%3D_700;big%3D1;&redirect=http://www.blastro.com/player/~to_replace1~.html?detect_mediatype=flv&detect_bitrate=_700&big=1',
      'matchExpr' => 'blastro\\.com\\/player\\/([a-z0-9-_]+)',
    ),
    array(
      'provider' => array('http://www.cellfish.com/'),
      'providerName' => 'cellfish',
      'providerIcon' => 'none',
      'info' => 'cellfish.com video',
      'width' => 420,
      'height' => 315,
      'src' => 'http://static.cellfish.com/static/swf/player8.swf',
      'matchExpr' => 'cellfish\\.com\\/(video|ringtone|multimedia)\\/([a-z0-9-_]+)',
      'flashvars' => 'Id=~to_replace2~&autoplay=false&widget=true&mediaPage=true&domain=cellfish.com&showProfileName=true',
    ),
    array(
      'provider' => array('http://videos.clarin.com/'),
      'providerName' => 'clarin',
      'info' => 'clarin.com videos',
      'width' => 533,
      'height' => 438,
      'src' => 'http://www.clarin.com/shared/v9/swf/clarinvideos/player.swf',
      'matchExpr' => 'videos\\.clarin\\.com\\/index\\.html\\?id=([a-z0-9-_]+)',
      'flashvars' => 'SEARCH=http://www.videos.clarin.com/decoder/buscador_getMtmYRelacionados/~to_replace1~|CLARIN_VIDEOS|VIDEO|EMBEDDED|10|1|10|null.xml&RUTAS=http://www.clarin.com/shared/v9/swf/clarinvideos/rutas.xml&autoplay=false',
    ),
    array(
      'provider' => array('http://www.clipjunkie.com/'),
      'providerName' => 'clipjunkie',
      'providerIcon' => 'none',
      'info' => 'clipjunkie.com video',
      'width' => 495,
      'height' => 370,
      'src' => 'http://www.clipjunkie.com/flvplayer/flvplayer.swf',
      'matchExpr' => 'clipjunkie\\.com\\/([a-z0-9-_]+)\\.htm',
      'flashvars' => 'config=http://www.clipjunkie.com/skin/config.xml&playList=http://www.clipjunkie.com/playlist.php&themes=http://www.clipjunkie.com/flvplayer/themes.xml&flv=http://videos.clipjunkie.com/videos/~to_replace1~.flv&autoplay=false',
    ),
    array(
      'provider' => array('http://thedailyshow.com/'),
      'providerName' => 'thedailyshow',
      'info' => 'thedailyshow.com video',
      'width' => 480,
      'height' => 383,
      'src' => 'http://media.mtvnservices.com/mgid:cms:video:comedycentral.com:~to_replace1~',
      'matchExpr' => 'thedailyshow\\.com\\/.*\\.jhtml\\?videoId=([a-z0-9-_]+)',
      'flashvars' => 'autoPlay=false&endCapAutoPlay=false&nextvideo=off&loop=false',
    ),
    array(
      'provider' => array('http://comedycentral.com/'),
      'providerName' => 'comedycentral',
      'info' => 'comedycentral.com video',
      'width' => 480,
      'height' => 383,
      'src' => 'http://media.mtvnservices.com/mgid:cms:video:comedycentral.com:~to_replace2~',
      'matchExpr' => 'comedycentral\\.com\\/.*\\.jhtml\\?(videoId|episodeId)=([a-z0-9-_]+)',
      'flashvars' => 'autoPlay=false&endCapAutoPlay=false&nextvideo=off&loop=false',
    ),
    array(
      'provider' => array('http://colbertnation.com/'),
      'providerName' => 'colbertnation',
      'info' => 'colbertnation.com video',
      'width' => 480,
      'height' => 383,
      'src' => 'http://media.mtvnservices.com/mgid:cms:item:comedycentral.com:~to_replace1~',
      'matchExpr' => 'colbertnation\\.com\\/.*\\/([0-9]+)',
      'flashvars' => 'autoPlay=false&endCapAutoPlay=false&nextvideo=off&loop=false',
    ),
    array(
      'provider' => array('http://www.crunchyroll.com/'),
      'providerName' => 'crunchyroll',
      'info' => 'crunchyroll.com video',
      'width' => 624,
      'height' => 328,
      'src' => 'http://static.crunchyroll.com/flash/20090921112226.d65e2ddb80363cc34004bd6214de692b/StandardVideoPlayer.swf',
      'matchExpr' => 'crunchyroll\\.com\\/.*(media-|\\?mediaid=|\\?videoid=)([0-9]+)',
      'flashvars' => 'config_url=http%3A%2F%2Fwww.crunchyroll.com%2Fxml%2F%3Freq%3DRpcApiVideoPlayer_GetStandardConfig%26media_id%3D~to_replace2~%26auto_play%3D0',
    ),
    array(
      'provider' => array('http://dotsub.com/'),
      'providerName' => 'dotsub',
      'providerIcon' => 'http://dotsub.com/images/icon16.png',
      'info' => 'dotsub.com video',
      'width' => 420,
      'height' => 347,
      'src' => 'http://dotsub.com/static/players/portalplayer.swf',
      'matchExpr' => 'dotsub\\.com\\/(media|view)\\/((?:(?:[0-9a-z]+)-?){5})',
      'flashvars' => 'uuid=~to_replace2~&lang=eng&type=video&plugins=dotsub&embedded=true',
    ),
    array(
      'provider' => array('http://www.divshare.com/'),
      'providerName' => 'divshare',
      'info' => 'divshare.com video',
      'width' => 425,
      'height' => 319,
      'src' => 'http://www.divshare.com/flash/video2?myId=~to_replace1~',
      'matchExpr' => 'divshare\\.com\\/download\\/([a-z0-9-_]+)',
    ),
    array(
      'provider' => array('http://www.kaltura.com/'),
      'providerName' => 'fandome',
      'info' => 'fandome.com video',
      'width' => 400,
      'height' => 400,
      'src' => 'http://www.kaltura.com/index.php/kwidget/wid/_35168/uiconf_id/1002330',
      'matchExpr' => 'fandome\\.com\\/video\\/([a-z0-9-_]+)',
      'flashvars' => 'entryId=http://s3.amazonaws.com/lazyjock/~to_replace1~.flv&autoplay=false&volume=100&stretching=exactfit',
    ),
    array(
      'provider' => array('http://www.g4tv.com/'),
      'providerName' => 'g4tv',
      'info' => 'g4tv.com video',
      'width' => 611,
      'height' => 341,
      'src' => 'http://www.g4tv.com/lv3/~to_replace2~',
      'matchExpr' => 'g4tv\\.com\\/(xplay|videos|lv3|sv3)\\/([a-z0-9-_]+)',
      'flashvars' => 'phoenixBase=http%3A//g4tv.com/&colorTheme=0xff9933%2C0x492b0e%2C0xff620e%2C0xffc46f&videokey=~to_replace2~&image=&playerName=videodetail&autoplay=n&leftBarButtons=hidden&rightBarButtons=link%2Ccode%2Cdim&hdContent=false&showSDHD=false&sideBarsOverlap=false&endVideoCallback=VideoPlayer.playNextVideo&showContinuousPlay=false',
    ),
    array(
      'provider' => array('http://gamespot.com/'),
      'providerName' => 'gamespot',
      'info' => 'gamespot.com video',
      'width' => 480,
      'height' => 310,
      'src' => 'http://image.com.com/gamespot/images/cne_flash/production/media_player/proteus/gs/proteus2_gs.swf',
      'matchExpr' => 'gamespot\\.com\\/.*video\\/([a-z0-9-_]+)',
      'flashvars' => 'playerMode=in_page&movieAspect=16.9&allowFullScreen=1&showOptions=1&menu_mode=&cs_id=3002244&flavor=480Version&skin=http://image.com.com/gamespot/images/cne_flash/production/media_player/proteus/one/skins/gamespot.png&autoPlay=false&embeddingAllowed=true&paramsURI=http%3A%2F%2Fwww.gamespot.com%2Fpages%2Fvideo_player%2Fxml.php%3Fid%3D~to_replace1~%26pid%3D972793%26ads%3Dnone%26ad_freq%3D0%26ontology%3D36%26ptype%3D6475%26mode%3Din_page%26width%3D480%26height%3D310',
    ),
    array(
      'provider' => array('http://www.gametube.org/'),
      'providerName' => 'gametube',
      'info' => 'gametube.org video',
      'width' => 451,
      'height' => 372,
      'src' => 'http://www.gametube.org/miniPlayer.swf?vidId=~to_replace2~',
      'matchExpr' => 'gametube\\.org\\/.*(\#\\/video\\/|htmlVideo\\.jsp\\?id=|miniPlayer\\.swf\\?vidId=)([\\/a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.gloria.tv/'),
      'providerName' => 'gloria',
      'info' => 'gloria.tv video',
      'width' => 494,
      'height' => 400,
      'src' => 'http://www.gloria.tv/?media=~to_replace1~&amp;embed',
      'matchExpr' => 'gloria\\.tv\\/\\?media=([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://video.gotgame.com/'),
      'providerName' => 'gotgame',
      'info' => 'gotgame.com video',
      'width' => 600,
      'height' => 418,
      'src' => 'http://video.gotgame.com/public/flash/flash_gordon.swf?vid=~to_replace1~',
      'matchExpr' => 'video\\.gotgame\\.com\\/index\\.php\\/video\\/view\\/([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.guzer.com/'),
      'providerName' => 'guzer',
      'info' => 'guzer.com video',
      'width' => 486,
      'height' => 382,
      'src' => 'http://www.guzer.com/player/4-4player-licensed.swf',
      'matchExpr' => 'guzer\\.com\\/videos\\/(.*)\\.php',
      'flashvars' => '&file=http://www.guzer.com/videos/~to_replace1~.flv&image=http://www.guzer.com/videos/s~to_replace1~.jpg&stretching=exactfit',
    ),
    array(
      'provider' => array('http://www.izlesene.com/'),
      'providerName' => 'izlesene',
      'info' => 'izlesene.com video',
      'width' => 465,
      'height' => 355,
      'src' => 'http://www.izlesene.com/player2.swf?video=~to_replace2~',
      'matchExpr' => 'izlesene\\.com\\/(player2\\.swf\\?video=|video\\/(?:[a-z0-9-_]+)?\\/)([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.joost.com/'),
      'providerName' => 'joost',
      'info' => 'joost.com video',
      'width' => 640,
      'height' => 360,
      'src' => 'http://www.joost.com/embed/~to_replace1~',
      'matchExpr' => 'joost\\.com\\/([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.justin.tv/'),
      'providerName' => 'justin',
      'info' => 'justin.tv video',
      'width' => 400,
      'height' => 300,
      'src' => 'http://www.justin.tv/widgets/live_embed_player.swf',
      'matchExpr' => 'justin\\.tv\\/([a-z0-9-_=]+)',
      'flashvars' => 'channel=~to_replace1~&auto_play=false&start_volume=50',
    ),
    array(
      'provider' => array('http://www.koreus.com/'),
      'providerName' => 'koreus',
      'info' => 'koreus.com video',
      'width' => 400,
      'height' => 320,
      'src' => 'http://www.koreus.com/video/~to_replace1~',
      'matchExpr' => 'koreus\\.com\\/video\\/([a-z0-9-_=]+)\\.html',
    ),
    array(
      'provider' => array('http://www.machinima.com/'),
      'providerName' => 'machinima',
      'info' => 'machinima.com video',
      'width' => 450,
      'height' => 300,
      'src' => 'http://www.machinima.com/flv_player_master/player/waPlayer.swf?VideoID=~to_replace1~&Style=&PlaylistID=&path=http://www.machinima.com/flv_player_master&playerID=0&ra=',
      'matchExpr' => 'machinima\\.com(?::80)?\\/(?:film\\/view(?:&|&amp;)id=|#details_)([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://msnbc.msn.com/'),
      'providerName' => 'msn',
      'info' => 'msnbc.msn.com video',
      'width' => 425,
      'height' => 339,
      'matchExpr' => 'msnbc\\.msn\\.com\\/id\\/[a-z0-9-_=]+\\/vp\\/((?:[a-z0-9-_=]+#)?([a-z0-9-_=]+))',
      'src' => 'http://msnbcmedia.msn.com/i/MSNBC/Components/Video/_Player/swfs/embedPlayer/ey073009.swf?domain=www.msnbc.msn.com&settings=22425448&useProxy=true&wbDomain=www.msnbc.msn.com&launch=~to_replace2~&sw=1280&sh=800&EID=oVPEFC&playerid=22425001',
    ),
    array(
      'provider' => array('http://video.mail.ru/'),
      'providerName' => 'mail',
      'info' => 'mail.ru video',
      'width' => 585,
      'height' => 387,
      'src' => 'http://img.mail.ru/r/video2/player_v2.swf?ver=8&par=http://content.video.mail.ru/mail/~to_replace1~/~to_replace2~/$~to_replace3~$0$',
      'matchExpr' => 'video\\.mail\\.ru\\/mail\\/([a-z0-9-_=]+)\\/([a-z0-9-_=]+)\\/([a-z0-9-_=]+)\\.html',
    ),
    array(
      'provider' => array('http://www.madnessvideo.net/'),
      'providerName' => 'madnessvideo',
      'info' => 'madnessvideo.net video',
      'width' => 400,
      'height' => 320,
      'src' => 'http://www.madnessvideo.net/emb.aspx/~to_replace2~',
      'matchExpr' => 'madnessvideo\\.net\\/((?:videos.aspx\\/)?(video~.*))',
    ),
    array(
      'provider' => array('http://video.milliyet.com.tr/'),
      'providerName' => 'milliyet',
      'providerIcon' => 'none',
      'info' => 'milliyet.com.tr video',
      'width' => 340,
      'height' => 325,
      'src' => 'http://video.milliyet.com.tr/m.swf?prm=~to_replace1~,~to_replace2~&kanal=~to_replace3~&id=~to_replace4~&tarih=~to_replace5~&get=~to_replace6~',
      'matchExpr' => 'video\\.milliyet\\.com\\.tr\\/default\\.asp\\?prm=([0-9]+),([0-9]+)&kanal=([0-9]+)&id=([0-9]+)&tarih=([0-9\\/]+)&get=([0-9\\.]+)',
      'flashvars' => '&id=~to_replace4~&tarih=~to_replace5~',
    ),
    array(
      'provider' => array('http://tv.mofile.com/'),
      'providerName' => 'mofile',
      'info' => 'mofile.com video',
      'width' => 500,
      'height' => 370,
      'src' => 'http://tv.mofile.com/cn/xplayer.swf?v=~to_replace1~',
      'matchExpr' => 'mofile\\.com\\/(?:show\\/)?([a-z0-9-_=]+)',
      'flashvars' => 'v=~to_replace1~&fadshow=0&fadshowtime=8000&fadurl=http://v.mofile.com/v.mofile.com/swf/xbsg_500x358.swf&c=1&b=2&p=&autoplay=0&vTitle=&vtid=6&qDomain=tv.mofile.com&ad=0&ipregion=unknown&ipcity=unknown',
    ),
    array(
      'provider' => array('http://www.seehaha.com/'),
      'providerName' => 'seehaha',
      'providerIcon' => 'http://www.myshows.cn/image/favicon.ico',
      'info' => 'seehaha.com video',
      'width' => 480,
      'height' => 400,
      'src' => 'http://www.seehaha.com/flash/player.swf?vidFileName=~to_replace1~.flv',
      'matchExpr' => 'seehaha\\.com\\/flash\\/player\\.swf\\?vidFileName=([a-z0-9-_=]+)\\.flv',
    ),
    array(
      'provider' => array('http://video.mpora.com/'),
      'providerName' => 'mpora',
      'providerIcon' => 'http://mpora.com/favicon.ico',
      'info' => 'mpora.com video',
      'width' => 480,
      'height' => 315,
      'src' => 'http://video.mpora.com/ep/~to_replace1~/',
      'matchExpr' => 'video\\.mpora\\.com\\/watch\\/([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://video.mthai.com/'),
      'providerName' => 'mthai',
      'info' => 'mthai.com video',
      'width' => 407,
      'height' => 342,
      'src' => 'http://video.mthai.com/Flash_player/player.swf?idMovie=~to_replace1~',
      'matchExpr' => 'video\\.mthai\\.com\\/player\\.php\\?.*id=([0-9a-z]+)',
    ),
    array(
      'provider' => array('http://videos.onsmash.com/'),
      'providerName' => 'onsmash',
      'info' => 'onsmash.com video',
      'width' => 448,
      'height' => 374,
      'src' => 'http://videos.onsmash.com/e/~to_replace1~',
      'matchExpr' => 'videos\\.onsmash\\.com\\/(?:v|e)\\/([a-z0-9-_=]+)',
      'flashvars' => 'autoplay=0',
    ),
    array(
      'provider' => array('http://playlist.com/'),
      'providerName' => 'playlist',
      'info' => 'playlist.com playlist',
      'width' => 506,
      'height' => 300,
      'src' => 'http://static.pplaylist.com/players/mp3player_new_v103.swf',
      'matchExpr' => 'playlist\\.com\\/playlist\\/([0-9]+)',
      'flashvars' => 'baseurl=http://www.playlist.com&config=site_noautostart&sopath=ppl-103&loginjs=false&autologin=never&getCode=gigya&movie=http://static.pplaylist.com/players/mp3player_new_v103.swf&enablejs=false&javascriptid=playerTop&playlist_id=~to_replace1~&apibaseurl=http://www.playlist.com/api&domain_pre_xspf=http://pl.playlist.com/pl.php?e=1%26playlist=&tracking=true&bgcolor=#ffffff&myheight=300&mywidth=506&wid=si&loc=playlist_audio&getcode=&promo=&meebo=false&userid=&debug=false',
    ),
    array(
      'provider' => array('http://www.rawvegas.tv/'),
      'providerName' => 'rawvegas',
      'info' => 'rawvegas.tv video',
      'width' => 427,
      'height' => 300,
      'src' => 'http://www.rawvegas.tv/ext.php?uniqueVidID=~to_replace1~',
      'matchExpr' => 'rawvegas\\.tv\\/watch\\/[a-z0-9-_]*\\/([a-z0-9-_=]+)',
      'flashvars' => 'uniqueVidID=~to_replace1~',
    ),
    array(
      'provider' => array('http://www.screentoaster.com/'),
      'providerName' => 'screentoaster',
      'info' => 'screentoaster.com video',
      'width' => 425,
      'height' => 344,
      'src' => 'http://www.screentoaster.com/swf/STPlayer.swf',
      'matchExpr' => 'screentoaster\\.com\\/watch\\/([a-z0-9]+)',
      'flashvars' => 'video=~to_replace1~',
    ),
    array(
      'provider' => array('http://www.sevenload.com/'),
      'providerName' => 'sevenload',
      'info' => 'sevenload.com video',
      'width' => 500,
      'height' => 408,
      'src' => 'http://static.sevenload.com/swf/player/player.swf?v=143',
      'matchExpr' => 'sevenload\\.com\\/(?:videos?|videolar|filmy)\\/([a-z0-9]{1,7})',
      'flashvars' => 'configPath=http://flash.sevenload.com/player?itemId=~to_replace1~&portalId=&screenlink=0&autoplay=0&environment=sevenload&autoPlayNext=0&locale=en_US',
    ),
    array(
      'provider' => array('http://www.sevenload.com/'),
      'providerName' => 'sevenload',
      'info' => 'sevenload.com shows',
      'width' => 500,
      'height' => 408,
      'src' => 'http://sevenload.com/pl/~to_replace1~/500x408/swf',
      'matchExpr' => 'sevenload\\.com\\/.*(?:episodes|folgen|puntate)\\/([a-z0-9]{1,7})',
      'flashvars' => 'configPath=http://flash.sevenload.com/player?itemId=~to_replace1~&portalId=&screenlink=0&autoplay=0&environment=sevenload&autoPlayNext=0&locale=en_US',
    ),
    array(
      'provider' => array('http://www.shareview.us/'),
      'providerName' => 'shareview',
      'providerIcon' => 'none',
      'info' => 'shareview.us video',
      'width' => 540,
      'height' => 380,
      'src' => 'http://www.shareview.us/nvembed.swf?key=~to_replace1~',
      'matchExpr' => 'shareview\\.us\\/(?:video\\/|nvembed\\.swf\\?key=)([a-z0-9-_=]+)\\/',
    ),
    array(
      'provider' => array('http://smotri.com/'),
      'providerName' => 'smotri',
      'info' => 'smotri.com video',
      'width' => 400,
      'height' => 330,
      'src' => 'http://pics.smotri.com/scrubber_custom8.swf?file=~to_replace1~&bufferTime=3&autoStart=false&str_lang=eng&xmlsource=http%3A%2F%2Fpics.smotri.com%2Fcskins%2Fblue%2Fskin_color_lightaqua.xml&xmldatasource=http%3A%2F%2Fpics.smotri.com%2Fskin_ng.xml',
      'matchExpr' => 'smotri\\.com\\/video\\/view\\/\\?id=([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.southparkstudios.com/'),
      'providerName' => 'southparkstudios',
      'info' => 'southparkstudios.com video clip',
      'width' => 480,
      'height' => 400,
      'src' => 'http://media.mtvnservices.com/mgid:cms:item:southparkstudios.com:~to_replace1~',
      'matchExpr' => 'southparkstudios\\.com\\/clips\\/([0-9]+)',
      'flashvars' => 'autoPlay=false&configParams=location%3Dhomepage&soWmode=window&soTargetDivId=video_player_box',
    ),
    array(
      'provider' => array('http://www.spike.com/'),
      'providerName' => 'spike',
      'info' => 'spike.com video',
      'width' => 640,
      'height' => 480,
      'src' => 'http://www.spike.com/efp',
      'matchExpr' => 'spike\\.com\\/(?:video\\/(?:[0-9a-z_-]+\\/)?|efp\\?flvbaseclip=)([0-9]+)',
      'flashvars' => 'flvbaseclip=~to_replace1~',
    ),
    array(
      'provider' => array('http://www.cbssports.com/'),
      'providerName' => 'cbssports',
      'info' => 'cbssports.com video',
      'width' => 500,
      'height' => 380,
      'src' => 'http://www.cbs.com/thunder/swf30can10cbssports/rcpHolderCbs-3-4x3.swf?releaseURL=http://release.theplatform.com/content.select?pid=~to_replace1~&amp;Tracking=true&amp;Embedded=True&autoPlayVid=false',
      'matchExpr' => 'cbssports\\.com\\/video\\/player\\/(?:play|embed)\\/[a-z0-9-_]+\\/([0-9a-z_-]+)',
    ),
    array(
      'provider' => array('http://www.tagtele.com/'),
      'providerName' => 'tagtele',
      'info' => 'tagtele.com video',
      'width' => 425,
      'height' => 350,
      'src' => 'http://www.tagtele.com/v/~to_replace1~',
      'matchExpr' => 'tagtele\\.com\\/(?:v|videos\\/voir)\\/([0-9]+)',
    ),
    array(
      'provider' => array('http://www.tm-tube.com/'),
      'providerName' => 'tm-tube',
      'info' => 'tm-tube.com video',
      'width' => 480,
      'height' => 360,
      'src' => 'http://www.tm-tube.com/vimp.swf?playlistmode=media&amp;mediaid=~to_replace1~&amp;webtv=false&amp;hosturl=http%3A%2F%2Fwww.tm-tube.com%2Fflashcomm.php',
      'matchExpr' => 'tm-tube\\.com\\/video\\/([0-9]+)',
    ),
    array(
      'provider' => array('http://www.trtube.com/'),
      'providerName' => 'trtube',
      'info' => 'trtube.com video',
      'width' => 425,
      'height' => 350,
      'src' => 'http://www.trtube.com/mediaplayer_3_15.swf?file=http://www.trtube.com/playlist.php?v=~to_replace1~&image=http://www.trtube.com/vi/~to_replace1~.gif&logo=http://www.trimg.com/img/logoembed.gif&linkfromdisplay=false&linktarget=_blank&autostart=false',
      'matchExpr' => 'trtube\\.com\\/(?:izle\\.php\\?v=|[a-z0-9-_]+-)([a-z0-9]+)(\\.html)?',
    ),
    array(
      'provider' => array('http://videolog.uol.com.br/'),
      'providerName' => 'uol',
      'info' => 'uol.com.br video',
      'width' => 424,
      'height' => 318,
      'src' => 'http://www.videolog.tv/ajax/codigoPlayer.php?id_video=~to_replace1~&relacionados=S&default=S&lang=PT_BR&cor_fundo=000000&swf=1&width=424&height=318',
      'matchExpr' => 'videolog\\.uol\\.com\\.br\\/video(?:\\?|\\.php\\?id=)([0-9]+)',
    ),
    array(
      'provider' => array('http://www.u-tube.ru/'),
      'providerName' => 'u-tube',
      'info' => 'u-tube.ru video',
      'width' => 400,
      'height' => 300,
      'src' => 'http://www.u-tube.ru/upload/others/flvplayer.swf?file=http://www.u-tube.ru/playlist.php?id=~to_replace1~&width=400&height=300',
      'matchExpr' => 'u-tube\\.ru\\/(?:playlist\\.php\\?id=|pages\\/video\\/)([0-9]+)',
    ),
    array(
      'provider' => array('http://videos.sapo.pt/'),
      'providerName' => 'sapo',
      'info' => 'sapo.pt video',
      'width' => 410,
      'height' => 281,
      'src' => 'http://rd3.videos.sapo.pt/play?file=http://rd3.videos.sapo.pt/~to_replace1~/mov/1',
      'matchExpr' => 'videos\\.sapo\\.pt\\/([0-9a-z]{20})',
    ),
    array(
      'provider' => array('http://videonuz.ensonhaber.com/'),
      'providerName' => 'ensonhaber',
      'providerIcon' => 'none',
      'info' => 'ensonhaber.com video',
      'width' => 468,
      'height' => 379,
      'src' => 'http://videonuz.ensonhaber.com/mediaplayer2.swf?settings=http://videonuz.ensonhaber.com/player2.config.php?vid=~to_replace1~',
      'matchExpr' => 'videonuz\\.ensonhaber\\.com\\/(?:medyaizle\\.php\\?haber_id=|haber-|.*?)([0-9]+)',
    ),
    array(
      'provider' => array('http://vidmax.com/'),
      'providerName' => 'vidmax',
      'providerIcon' => 'none',
      'info' => 'vidmax.com video',
      'width' => 475,
      'height' => 356,
      'src' => 'http://vidmax.com/player.swf',
      'matchExpr' => 'vidmax\\.com\\/(?:index\\.php\\/)?videos?\\/(?:view\\/)?([0-9]+)',
      'flashvars' => '&file=http://www.vidmax.com/media/video/~to_replace1~.mp4&streamer=lighttpd&autostart=false&stretching=fill',
    ),
    array(
      'provider' => array('http://www.vsocial.com/'),
      'providerName' => 'vsocial',
      'providerIcon' => 'none',
      'info' => 'vsocial.com video v1',
      'width' => 400,
      'height' => 330,
      'src' => 'http://static.vsocial.com/flash/upsl3.0.2/ups3.0.2.swf?d=~to_replace1~&a=0&s=false&url=http://www.vsocial.com/xml/upsl/vsocial/template.php',
      'matchExpr' => 'vsocial\\.com\\/(?:video\\/|flash\\/ups\\.swf)\\?d=([0-9]+)',
    ),
    array(
      'provider' => array('http://www.vsocial.com/'),
      'providerName' => 'vsocial',
      'providerIcon' => 'none',
      'info' => 'vsocial.com video v2',
      'width' => 410,
      'height' => 400,
      'src' => 'http://www.vsocial.com/ups/~to_replace1~',
      'matchExpr' => 'vsocial\\.com\\/(?:ups|pdk)\\/([0-9a-z]+)',
    ),
    array(
      'provider' => array('http://www.goear.com/'),
      'providerName' => 'goear',
      'providerIcon' => 'http://www.goear.com/img/ic.ico',
      'info' => 'goear.com audio',
      'width' => 353,
      'height' => 132,
      'src' => 'http://www.goear.com/files/external.swf?file=~to_replace2~',
      'matchExpr' => 'goear\\.com\\/listen(\\.php\\?v=|\\/)([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.ijigg.com/'),
      'providerName' => 'ijigg',
      'info' => 'ijigg.com audio',
      'width' => 315,
      'height' => 80,
      'src' => 'http://www.ijigg.com/jiggPlayer.swf?songID=~to_replace2~&Autoplay=0',
      'matchExpr' => 'ijigg\\.com\\/(jiggPlayer\\.swf\\?songID=|songs\\/|trackback\\/)([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.jamendo.com/'),
      'providerName' => 'jamendo',
      'info' => 'jamendo.com audio',
      'width' => 200,
      'height' => 300,
      'src' => 'http://widgets.jamendo.com/en/~to_replace1~/?playertype=2008&~to_replace1~_id=~to_replace2~',
      'matchExpr' => 'jamendo\\.com\\/.*(playlist|track|album)\\/([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.jujunation.com/'),
      'providerName' => 'jujunation',
      'info' => 'jujunation.com audio',
      'width' => 220,
      'height' => 66,
      'src' => 'http://www.jujunation.com/player.swf?configXmlPath=http://www.jujunation.com/musicConfigXmlCode.php?pg=music_~to_replace1~&playListXmlPath=http://www.jujunation.com/musicPlaylistXmlCode.php?pg=music_~to_replace1~',
      'matchExpr' => 'jujunation\\.com\\/music\\.php\\?music_id=([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://last.fm/'),
      'providerName' => 'last',
      'info' => 'last.fm audio',
      'width' => 300,
      'height' => 211,
      'matchExpr' => 'last\\.fm\\/music\\/([a-z0-9-_=\\+%]+)\\/_\\/([a-z0-9-_=\\+]+)',
      'src' => 'http://cdn.last.fm/webclient/s12n/s/53/lfmPlayer.swf',
      'flashvars' => 'lang=en&amp;lfmMode=playlist&amp;FOD=true&amp;resname=~to_replace2~&amp;restype=track&amp;artist=~to_replace1~',
    ),
    array(
      'provider' => array('http://www.nhaccuatui.com/'),
      'providerName' => 'nhaccuatui',
      'providerIcon' => 'http://img1.nhaccuatui.com/Images/favicon.ico',
      'info' => 'nhaccuatui.com audio',
      'width' => 300,
      'height' => 270,
      'src' => 'http://www.nhaccuatui.com/m/~to_replace1~',
      'matchExpr' => 'nhaccuatui\\.com\\/(?:nghe\\?M=|m\\/)([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://vplay.ro/'),
      'providerName' => 'vplay',
      'info' => 'vplay.ro video',
      'width' => 450,
      'height' => 320,
      'src' => 'http://hot.vplay.ro/embed.swf?key=~to_replace1~',
      'matchExpr' => 'vplay\\.ro\\/watch\\/([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.4shared.com/'),
      'providerName' => '4shared',
      'info' => '4shared.com video',
      'width' => 470,
      'height' => 320,
      'src' => 'http://www.4shared.com/embed/~to_replace1~/~to_replace2~',
      'matchExpr' => '4shared\\.com\\/file\\/([a-z0-9-_=]+)\\/([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://webtv.money.ro/'),
      'providerName' => 'money',
      'info' => 'webtv.money.ro video',
      'width' => 460,
      'height' => 365,
      'src' => 'http://webtv.money.ro/news/~to_replace1~/onlyPlayer/1/autoPlay/false',
      'matchExpr' => 'webtv\\.money\\.ro\\/news\\/([a-z0-9-_=]+)(\\?)?',
    ),
    array(
      'provider' => array('http://www.travelistic.com/'),
      'providerName' => 'travelistic',
      'providerIcon' => 'http://img.travelistic.com/trv/images/favicon.ico',
      'info' => 'travelistic.com video',
      'width' => 440,
      'height' => 363,
      'src' => 'http://media.travelistic.com/flash/diversionplayer.swf',
      'matchExpr' => 'travelistic\\.com\\/video\\/show\\/([a-z0-9-_=]+)',
      'flashvars' => 'vidID=~to_replace1~&amp;remote=true',
    ),
    array(
      'provider' => array('http://www.peteava.ro/'),
      'providerName' => 'peteava',
      'providerIcon' => 'http://www.peteava.ro/static/images/teava_icon.png',
      'info' => 'peteava.ro video',
      'width' => 624,
      'height' => 384,
      'src' => 'http://www.peteava.ro/static/swf/player.swf',
      'matchExpr' => 'peteava\\.ro\\/id-([a-z0-9_=]+)-',
      'flashvars' => 'id=__peteava_player_~to_replace1~_624_384__&streamer=http://content06.peteava.ro/stream.php&file=~to_replace1~_standard.mp4&image=http://storage2.peteava.ro/serve/thumbnail/~to_replace1~/playerstandard&hd_file=&hd_image=&autostart=false',
    ),
    array(
      'provider' => array('http://www.videoplayer.hu/'),
      'providerName' => 'videoplayer',
      'info' => 'videoplayer.hu video',
      'width' => 425,
      'height' => 350,
      'src' => 'http://www.videoplayer.hu/videos/embed/~to_replace1~',
      'matchExpr' => 'videoplayer\\.hu\\/videos\\/play\\/([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('https://www.facebook.com/'),
      'providerName' => 'facebook',
      'info' => 'facebook.com video',
      'width' => 425,
      'height' => 350,
      'src' => 'https://www.facebook.com/v/~to_replace1~',
      'matchExpr' => 'facebook\\.com\\/(?:(?:\\?sk=video#!\\/video)|(?:video))\\/video\\.php\\?v=([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.ebaumsworld.com/'),
      'providerName' => 'ebaumsworld',
      'info' => 'ebaumsworld.com video v1',
      'width' => 425,
      'height' => 345,
      'src' => 'http://www.ebaumsworld.com/player.swf',
      'matchExpr' => 'ebaumsworld\\.com\\/mediaFiles\\/video\\/([a-z0-9-_=]+)\\/([a-z0-9-_=]+)\\.flv',
      'flashvars' => 'pageurl=http://www.ebaumsworld.com/video/watch/~to_replace2~/&amp;file=http://media.ebaumsworld.com/mediaFiles/video/~to_replace1~/~to_replace2~.flv&amp;mediaid=~to_replace2~&amp;title=video&amp;displayheight=325&amp;backcolor=0x0d0d0d&amp;lightoclor=0x336699&amp;frontcolor=0xcccccc&amp;image=',
    ),
    array(
      'provider' => array('http://www.qq.com/'),
      'providerName' => 'qq',
      'info' => 'qq.com video',
      'width' => 500,
      'height' => 418,
      'src' => 'http://static.video.qq.com/v1/res/QQPlayer.swf',
      'matchExpr' => 'video\\.qq\\.com\\/v1\\/videopl\\?v=([a-z0-9-_=]+)',
      'flashvars' => 'vid=~to_replace1~&skin=http://static.video.qq.com/v1/res/skins/QQPlayerSkin.swf&autoplay=false&gourl=http://video.qq.com/v1/videopl?v=~to_replace1~&list=0&title=',
    ),
    array(
      'provider' => array('http://v.sina.com.cn/'),
      'providerName' => 'sina',
      'info' => 'v.sina.com.cn video',
      'width' => 480,
      'height' => 370,
      'src' => 'http://p.you.video.sina.com.cn/player/outer_player.swf?auto=1&vid=~to_replace1~&uid=~to_replace2~',
      'matchExpr' => 'you\\.video\\.sina\\.com\\.cn\\/.*\\/([a-z0-9_=]+)-([a-z0-9_=]+)\\.htm',
    ),
    array(
      'provider' => array('http://56.com/'),
      'providerName' => '56',
      'info' => '56.com video',
      'width' => 480,
      'height' => 395,
      'src' => 'http://player.56.com/v_~to_replace1~.swf',
      'matchExpr' => '56\\.com\\/(?:.*)(?:-|_)([a-z0-9]+)\\.htm',
    ),
    array(
      'provider' => array('http://twiturm.com/'),
      'providerName' => 'twiturm',
      'info' => 'twiturm.com audio',
      'width' => 402,
      'height' => 48,
      'src' => 'http://twiturm.com/flash/twiturm_mp3.swf?playerID=0&sf=~to_replace1~',
      'matchExpr' => 'twiturm\\.com\\/([a-z0-9]+)',
    ),
    array(
      'provider' => array('http://www.esnips.com/'),
      'providerName' => 'esnips',
      'info' => 'esnips.com video',
      'width' => 400,
      'height' => 300,
      'src' => 'http://www.esnips.com//3rd/flvplayer/esnips_flvplayer12.swf',
      'matchExpr' => 'esnips\\.com\\/doc\\/([a-z0-9\-_]+)',
      'flashvars' => 'linkfromdisplay=true&amp;height=300&amp;width=400&amp;xmlURL=http://www.esnips.com//flashxml/1/~to_replace1~&amp;autostart=false&amp;image=http://www.esnips.com/http://docthumb0.esnips.com/imageable/medium/~to_replace1~',
    ),
    array(
      'provider' => array('http://www.pandora.tv/'),
      'providerName' => 'pandora',
      'info' => 'pandora.tv video v1',
      'width' => 500,
      'height' => 402,
      'src' => 'http://flvr.pandora.tv/flv2pan/flvmovie.dll/userid=~to_replace1~&amp;prgid=~to_replace2~&amp;skin=1&countryChk=en',
      'matchExpr' => 'pandora\\.tv\\/my\\.([a-z0-9_]+)\\/([a-z0-9_]+)',
    ),
    array(
      'provider' => array('http://www.pandora.tv/'),
      'providerName' => 'pandora',
      'info' => 'pandora.tv video v2',
      'width' => 500,
      'height' => 402,
      'src' => 'http://flvr.pandora.tv/flv2pan/flvmovie.dll/userid=~to_replace1~&amp;prgid=~to_replace2~&amp;skin=1&countryChk=en',
      'matchExpr' => 'channel\\.pandora\\.tv\\/channel\\/(?:.*)?ch_userid=([a-z0-9_]+)(?:.*)?prgid=([a-z0-9_]+)',
    ),
    array(
      'provider' => array('http://tv.heeloo.ro/'),
      'providerName' => 'heeloo',
      'info' => 'heeloo.ro video/tv',
      'width' => 342,
      'height' => 279,
      'src' => 'http://video.heeloo.ro/play/~to_replace1~',
      'matchExpr' => 'heeloo\\.ro\\/([0-9]+)',
    ),
  );

  /**
   * EmbeVi Support Extended List (Array)
   * Example:
   * array(
   *   'provider'     => Direct link to site provider
   *   'providerName' => Name of the provider
   *   'providerIcon' => (optional) if set it will use his value for provider icon source
   *   'info'         => Support information (site and support type)
   *   'width'        => Default width (for object and embed tag)
   *   'height'       => Default height (for object and embed tag)
   *   'src'          => Source of the media to embed. Replace ~to_replace1~, ~to_replace2~, ... with matches from the matchExpr regular expression
   *   'matchUrl'     => Regular expression for matching site URL
   *   'matchExpr'    => Regular expression for matching site content
   *   'flashvars'    => (optional) if set, will be passed in the embed tag. Replace ~to_replace1~, ~to_replace2~, ... etc with matches from the matchExpr
   * )
   */
  private $embeviSupportExtended = array(
    array(
      'provider' => array('http://www.videonews.ro/'),
      'providerName' => 'videonews',
      'info' => 'videonews.ro video',
      'width' => 407,
      'height' => 324,
      'src' => 'http://videonews.ro/jwplayer/player.swf',
      'matchUrl' => 'videonews\\.ro\\/action\\/viewvideo\\/',
      'matchExpr' => 'file=(?:.*)\\/([a-z0-9-_]+)\\.flv',
      'flashvars' => 'width=407&height=324&autostart=false&showicons=true&file=http://videonews.ro/files/videos/videos/~to_replace1~.flv&image=http://videonews.ro/files/videos/thumbnails/~to_replace1~L.jpg&link=&skin=http://videonews.ro/jwplayer/nacht.swf&logo=http://videonews.ro/images/vn/vn_logo.png',
    ),
    array(
      'provider' => array('http://vidivodo.com/'),
      'providerName' => 'vidivodo',
      'providerIcon' => 'http://images.vidivodo.com/images/001/favicon.ico',
      'info' => 'vidivodo.com video',
      'width' => 440,
      'height' => 360,
      'src' => 'http://www.vidivodo.com/VideoPlayerShare.swf?u=~to_replace1~',
      'matchUrl' => 'vidivodo\\.com\\/([a-z0-9-_=]+)\\/',
      'matchExpr' => 'vidivodo\\.com\\/VideoPlayerShare\\.swf\\?u=([a-z0-9-_=]+)&',
    ),
    array(
      'provider' => array('http://www.akilli.tv/'),
      'providerName' => 'akilli',
      'providerIcon' => 'http://www.akilli.tv/images/icon.ico',
      'info' => 'akilli.tv video',
      'width' => 450,
      'height' => 370,
      'src' => 'http://services.akilli.tv/player3.swf?TYPE=2&URLX=http://services.akilli.tv/xmlProviderv4/query.aspx?ACTION=video&VDX=~to_replace1~',
      'matchUrl' => 'akilli\\.tv\\/video\\/',
      'matchExpr' => 'VDX=([a-z0-9-_=]+)(?:[^>]+)video_id=([a-z0-9-_=]+)',
    	'flashvars' => 'video_id=~to_replace2~',
    ),
    array(
      'provider' => array('http://www.catavencu.ro/'),
      'providerName' => 'catavencu',
      'info' => 'catavencu.ro video',
      'width' => 480,
      'height' => 420,
      'src' => 'http://www.catavencu.ro/player_no_prime_time.swf',
      'matchUrl' => 'catavencu\\.ro\\/video\\/',
      'matchExpr' => 'video\\/([a-z0-9-_=]+)\\/([a-z0-9-_=]+)\\.flv(?:[^>]+)channelIdentifier=([a-z0-9-_=%]+)',
    	'flashvars' => 'autoplay=false&playerWidth=480&playerHeight=420&file=http://media2.gruprc.ro/video/~to_replace1~/~to_replace2~.flv.flv&image=http://media2.gruprc.ro/video/~to_replace1~/~to_replace2~.flv.jpg&channelIdentifier=~to_replace3~',
    ),
    array(
      'provider' => array('http://adsoftheworld.com/'),
      'providerName' => 'adsoftheworld',
      'info' => 'adsoftheworld.com video',
      'width' => 590,
      'height' => 476,
      'src' => 'http://adsoftheworld.com/sites/all/library/flash/FlowPlayerLight.swf?config=%7Bembedded%3Atrue%2Cloop%3Afalse%2CbufferLength%3A5%2CautoBuffering%3Atrue%2CautoPlay%3Afalse%2CvideoFile%3A%27~to_replace1~%27%2CbaseURL%3A%27http%3A%2F%2Fadsoftheworld%2Enet%2Fvideos%27%7D',
      'matchUrl' => 'adsoftheworld\\.com\\/media\\/tv\\/([a-z0-9-_=]+)',
      'matchExpr' => 'videoFile:\'([a-z0-9-_=\\.]+)',
    ),
    array(
      'provider' => array('http://www.blip.tv/'),
      'providerName' => 'blip',
      'info' => 'blip.tv video',
      'width' => 480,
      'height' => 300,
      'src' => 'http://blip.tv/play/~to_replace1~',
      'matchUrl' => 'blip\\.tv\\/file\\/([a-z0-9-_=]+)',
      'matchExpr' => 'blip\\.tv\\/play\\/([a-z0-9-_=%\\.\\+]+)',
    ),
    array(
      'provider' => array('http://www.tare.ro/'),
      'providerName' => 'tare',
      'info' => 'tare.ro video',
      'width' => 500,
      'height' => 326,
      'src' => 'http://cache.apropo.ro/~to_replace1~/videoplayer.swf?key=~to_replace2~',
      'matchUrl' => 'tare\\.ro\\/([a-z0-9-_=]+)\\/([a-z0-9-_=]+)',
      'matchExpr' => 'cache\\.apropo\\.ro\\/([a-z0-9-_=]+)\\/videoplayer\\.swf\\?key=([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.break.com/'),
      'providerName' => 'break',
      'info' => 'break.com video',
      'width' => 464,
      'height' => 353,
      'src' => 'http://embed.break.com/~to_replace1~',
      'matchUrl' => 'break\\.com\\/([a-z0-9-_=]+)\\/',
      'matchExpr' => 'sGlobalContentID=\'([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.flickr.com/'),
      'providerName' => 'flickr',
      'info' => 'flickr.com video',
      'width' => 500,
      'height' => 375,
      'src' => 'http://www.flickr.com/apps/video/stewart.swf.v71377',
      'matchUrl' => 'flickr\\.com\\/([a-z0-9-_=]+)\\/',
      'matchExpr' => 'photo_secret=([a-z0-9-_=]+)&photo_id=([a-z0-9-_=]+)',
    	'flashvars' => 'intl_lang=en-us&div_id=stewart_swf3291175448_div&flickr_notracking=true&flickr_target=_self&flickr_h=375&flickr_w=500&flickr_no_logo=true&onsite=true&flickr_noAutoPlay=true&in_photo_gne=true&photo_secret=~to_replace1~&photo_id=~to_replace2~&flickr_doSmall=true'
    ),
    array(
      'provider' => array('http://www.yourdiscovery.com/'),
      'providerName' => 'yourdiscovery',
      'info' => 'yourdiscovery.com video v1',
      'width' => 657,
      'height' => 370,
      'src' => 'http://c.brightcove.com/services/viewer/federated_f9?&width=657&height=370&flashID=&bgcolor=%23FFFFFF&playerID=56343446001&publisherID=1378939881&isVid=true&isUI=true&autoStart=false&%40videoPlayer=~to_replace1~&linkBaseURL=&wmode=transparent&allowScriptAccess=always',
      'matchUrl' => 'yourdiscovery\\.com\\/video\\/playlists\\/([a-z0-9-_=]+)',
      'matchExpr' => 'videoIds\\.push\\("([a-z0-9-_=]+)',
    	'flashvars' => 'playerID=56343446001&domain=embed&',
    ),
    array(
      'provider' => array('http://www.yourdiscovery.com/'),
      'providerName' => 'yourdiscovery',
      'info' => 'yourdiscovery.com video v2',
      'width' => 657,
      'height' => 370,
      'src' => 'http://c.brightcove.com/services/viewer/federated_f9?&width=657&height=370&flashID=&bgcolor=%23FFFFFF&playerID=56343446001&publisherID=1378939881&isVid=true&isUI=true&autoStart=false&%40videoPlayer=~to_replace1~&linkBaseURL=&wmode=transparent&allowScriptAccess=always',
      'matchUrl' => 'yourdiscovery\\.com\\/video\\/([a-z0-9-_=]+)',
      'matchExpr' => 'videoPlayer" value="([a-z0-9-_=]+)',
    	'flashvars' => 'playerID=56343446001&domain=embed&',
    ),
    array(
      'provider' => array('http://animal.discovery.com/'),
      'providerName' => 'discovery',
      'providerIcon' => 'http://animal.discovery.com/images/icons/favicon.ico',
      'info' => 'animal.discovery.com video',
      'width' => 662,
      'height' => 390,
      'src' => 'http://animal.discovery.com/shared/swf/video-players/monetized/video-asset-page-player.swf',
      'matchUrl' => 'animal\\.discovery\\.com\\/videos\\/([a-z0-9-_=]+)',
      'matchExpr' => '_clipId: "([a-z0-9-_=]+)',
    	'flashvars' => '_configName=video-per-page-player&_dataXML=&_screen_w=&_screen_h=&_myURL=http://animal.discovery.com/videos/cats-101-american-curl.html&_myBgCol=000000&_playerId=1459183575&_clipId=~to_replace1~&_adCode=&_adOpsTestCode=&_localConnectRand=&_seriesId=',
    ),
    array(
      'provider' => array('http://www.atom.com/'),
      'providerName' => 'atom',
      'info' => 'atom.com video',
      'width' => 425,
      'height' => 354,
      'src' => 'http://media.mtvnservices.com/mgid:hcx:content:atom.com:~to_replace1~',
      'matchUrl' => 'atom\\.com\\/([a-z0-9-_=]+)',
      'matchExpr' => 'mgid:hcx:content:atom.com:([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.islandticklevideo.com/'),
      'providerName' => 'islandticklevideo',
      'providerIcon' => 'none',
      'info' => 'islandticklevideo.com video',
      'width' => 480,
      'height' => 385,
      'src' => 'http://www.islandticklevideo.com/mediashare/modules/vPlayer/vPlayer.swf?f=http://www.islandticklevideo.com/mediashare/modules/vPlayer/vPlayercfg.php?id=~to_replace1~',
      'matchUrl' => 'islandticklevideo\\.com\\/mediashare\\/video\\/([a-z0-9-_=]+)',
      'matchExpr' => 'vPlayercfg.php\\?id=([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.islandticklevideo.com/'),
      'providerName' => 'islandticklevideo',
      'providerIcon' => 'none',
      'info' => 'islandticklevideo.com audio',
      'width' => 480,
      'height' => 385,
      'src' => 'http://www.islandticklevideo.com/mediashare/fmp3player.swf',
      'matchUrl' => 'islandticklevideo\\.com\\/mediashare\\/audio\\/([a-z0-9-_=]+)',
      'matchExpr' => 'fmp3player.php\\?id=([a-z0-9-_=]+)',
      'flashvars' => 'file=http://www.islandticklevideo.com/mediashare/fmp3player.php?id=~to_replace1~&autostart=false&skin=http://www.islandticklevideo.com/mediashare/modules/aPlayer/skins/nacht.swf',
    ),
    array(
      'provider' => array('http://www.bofunk.com/'),
      'providerName' => 'bofunk',
      'info' => 'bofunk.com video',
      'width' => 446,
      'height' => 370,
      'src' => 'http://www.bofunk.com/e/~to_replace1~',
      'matchUrl' => 'bofunk\\.com\\/video\\/([a-z0-9-_=]+)\\/',
      'matchExpr' => 'embed src="\\/w\\/([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.ebaumsworld.com/'),
      'providerName' => 'ebaumsworld',
      'info' => 'ebaumsworld.com video v2',
      'width' => 425,
      'height' => 345,
      'src' => 'http://www.ebaumsworld.com/player.swf',
      'matchUrl' => 'ebaumsworld\\.com\\/video\\/watch\\/([a-z0-9-_=]+)',
      'matchExpr' => 'embed src=&quot;([^>]*)&quot;',
      'flashvars' => '~to_replace1~',
    ),
    array(
      'provider' => array('http://www.photobucket.com/'),
      'providerName' => 'photobucket',
      'info' => 'photobucket.com video',
      'width' => 600,
      'height' => 361,
      'src' => 'http://static.photobucket.com/player.swf?file=~to_replace1~&amp;sr=1',
      'matchUrl' => 'photobucket\\.com\\/(?:video|albums|popular)\\/([a-z0-9-_=]+)',
      'matchExpr' => 'file=([a-z0-9-_=\.\/:]+)',
    ),
    array(
      'provider' => array('http://www.streetfire.net/'),
      'providerName' => 'streetfire',
      'info' => 'streetfire.net video',
      'width' => 428,
      'height' => 352,
      'src' => 'http://www.streetfire.net/flash/SPlayer.swf',
      'matchUrl' => 'streetfire\\.net\\/video\\/([a-z0-9-_=]+)',
      'matchExpr' => 'video=([a-z0-9-_=]+)',
      'flashvars' => 'video=~to_replace1~&servicecfg=386',
    ),
    array(
      'provider' => array('http://www.ted.com/'),
      'providerName' => 'ted',
      'info' => 'ted.com video',
      'width' => 446,
      'height' => 326,
      'src' => 'http://video.ted.com/assets/player/swf/EmbedPlayer.swf',
      'matchUrl' => 'ted\\.com\\/(index.php\\/)?talks\\/([a-z0-9-_=]+)',
      'matchExpr' => 'ms:"talks\\/dynamic\\/([a-z0-9-_=]+)-medium\\.flv',
      'flashvars' => 'vu=http://video.ted.com/talks/dynamic/~to_replace1~-medium.flv&su=http://images.ted.com/images/ted/tedindex/embed-posters/~to_replace1~.embed_thumbnail.jpg&vw=432&vh=240',
    ),
    array(
      'provider' => array('http://www.theonion.com/'),
      'providerName' => 'theonion',
      'info' => 'theonion.com video',
      'width' => 480,
      'height' => 430,
      'src' => 'http://media.theonion.com/flash/video/embedded_player.swf?&videoid=~to_replace1~',
      'matchUrl' => 'theonion\\.com\\/video\\/([a-z0-9-_=]+)',
      'matchExpr' => 'videoid=([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.traileraddict.com/'),
      'providerName' => 'traileraddict',
      'info' => 'traileraddict.com video',
      'width' => 480,
      'height' => 430,
      'src' => 'http://www.traileraddict.com/emd/~to_replace1~',
      'matchUrl' => 'traileraddict\\.com\\/trailer\\/([a-z0-9-_=]+)',
      'matchExpr' => 'emd\\/([a-z0-9-_=]+)',
    ),
    array(
      'provider' => array('http://www.yourfilehost.com/'),
      'providerName' => 'yourfilehost',
      'info' => 'yourfilehost.com video',
      'width' => 470,
      'height' => 399,
      'src' => 'http://www.yourfilehost.com/adcontent/flvplayer9.swf?geo=OTHER&adult=0&autoStart=false&no_skin_menu=1&video=http%3A%2F%2Fwww.yourfilehost.com%2Fvideo-embed-code-new.php%3Fvidlink%3D%26cid%3D~to_replace1~%26adult%3D%26cat%3Dvideo%26file%3D~to_replace2~%26family%3Don%26key%3D217.156.73%26%26cdn%3D1%26geo%3Dother&videoembed_id=http%3A%2F%2Fwww.yourfilehost.com%2Fmedia.php%3Fcat%3Dvideo%26file%3D~to_replace2~&search_url=http%3A%2F%2Fwww.flurl.com%2Fsearch%3F1%26site_id%3D147&src_ip=&postroll=0',
      'matchUrl' => 'yourfilehost\\.com\\/media\\.php\\?cat=video&file=([a-z0-9_=\.]+)',
      'matchExpr' => 'cid%3D([a-z0-9_=]+)(?:[^>]*)file%3D([a-z0-9_=\.]+)',
    ),
    array(
      'provider' => array('http://6.cn/'),
      'providerName' => '6',
      'info' => '6.cn video',
      'width' => 480,
      'height' => 385,
      'src' => 'http://6.cn/p/~to_replace1~.swf',
      'matchUrl' => '6\\.cn\\/([a-z0-9_=]+)',
      'matchExpr' => 'vid=([a-z0-9_=]+)',
    ),
    array(
      'provider' => array('http://vision.ameba.jp/'),
      'providerName' => 'ameba',
      'info' => 'vision.ameba.jp video',
      'width' => 480,
      'height' => 392,
      'src' => 'http://vm2-2.vision.ameba.jp/mcs.swf?id=~to_replace1~&width=&height=&skin=',
      'matchUrl' => 'vision\\.ameba\\.jp\\/watch\\.do\\?movie=([a-z0-9_=]+)',
      'matchExpr' => 'id=([a-z0-9_\-=:]+)',
    ),
    array(
      'provider' => array('http://www.wat.tv/'),
      'providerName' => 'wat',
      'info' => 'wat.tv video',
      'width' => 470,
      'height' => 312,
      'src' => 'http://www.wat.tv/swf2/~to_replace1~',
      'matchUrl' => 'wat\\.tv\\/video\\/([a-z0-9_=]+)',
      'matchExpr' => 'swf2\\/([a-z0-9_=]+)',
    ),
  );

  /**
   * Set the height of the object and embed
   *
   * @param integer $height - height to set the object and embed
   *
   * @return boolean - true, if the value was set,
   *                 - false, if objectAttr and embedAttr aren't array's
   */
  public function setHeight($height) {
    $height = intval($height);
    if($height <= 0) {
      $height = $this->baseHeight;
    }
    $this->embeviHeight = $height;
    
    return $this->setObjectAttr('height', $height) && $this->setEmbedAttr('height', $height);
  }

  /**
   * Get height of the embedded code
   */
  public function getHeight() {
    return $this->embeviHeight;
  }

  /**
   * Set the global height of the object and embed
   *
   * @param integer $height - height to set the object and embed
   * - this will be used for all the embedded codes
   */
  public function setGlobalHeight($height) {
    $this->globalHeight = intval($height);
  }

  /**
   * Unset the global height of the object and embed
   */
  public function unsetGlobalHeight() {
    $this->globalHeight = 0;
  }

  /**
   * Set maximum height of the object and embed
   *
   * @param integer $height - height to set the object and embed
   *
   * @return boolean - true, if the value was set,
   *                 - false, if objectAttr and embedAttr aren't array's
   */
  public function setGlobalMaxHeight($maxHeight) {
    $this->globalMaxHeight = intval($maxHeight);
  }

  /**
   * Unset maximum global height of the object and embed
   */
  public function unsetGlobalMaxHeight() {
    $this->globalMaxHeight = 0;
  }

  /**
   * Set the width of the object and embed
   *
   * @param integer $width - width to set the object and embed
   * - this will be used for all the embedded codes
   *
   * @return boolean - true, if the value was set,
   *                 - false, if objectAttr and embedAttr aren't array's
   */
  public function setWidth($width) {
    $width = intval($width);
    if($width <= 0) {
      $width = $this->baseWidth;
    }
    $this->embeviWidth = $width;
    
    return $this->setObjectAttr('width', $width) && $this->setEmbedAttr('width', $width);
  }

  /**
   * Get width of the embedded code
   */
  public function getWidth() {
    return $this->embeviWidth;
  }

  /**
   * Set the global width of the object and embed
   *
   * @param integer $width - width to set the object and embed
   */
  public function setGlobalWidth($width) {
    $this->globalWidth = intval($width);
  }

  /**
   * Unset the global width of the object and embed
   */
  public function unsetGlobalWidth() {
    $this->globalWidth = 0;
  }

  /**
   * Set maximum global width of the object and embed
   *
   * @param integer $width - width to set the object and embed
   */
  public function setGlobalMaxWidth($maxWidth) {
    $this->globalMaxWidth = intval($maxWidth);
  }

  /**
   * Unset maximum global width of the object and embed
   */
  public function unsetGlobalMaxWidth() {
    $this->globalMaxWidth = 0;
  }

  /**
   * Set keep ratio calculation
   *
   * @param bool $keepRatio - flag for generating width/height by keeping ratio
   */
  public function setKeepRatio() {
    $this->keepRatio = true;
  }

  /**
   * Unset auto generation width or height using ratio
   */
  public function unsetKeepRatio() {
    $this->keepRatio = false;
  }

  /**
   * Set max dimensions with the highest importance
   */
  public function setMaxImportant() {
    $this->globalMaxImportant = true;
  }

  /**
   * Set defaul dimensions importance
   */
  public function unsetMaxImportant() {
    $this->globalMaxImportant = false;
  }

  /**
   * Use function htmlspecialchars_decode in parseHtml method
   */
  public function setHtmlDecode() {
    $this->specialCharDecode = true;
  }

  /**
   * Don't use function htmlspecialchars_decode in parseHtml method
   */
  public function unsetHtmlDecode() {
    $this->specialCharDecode = false;
  }

  /**
   * Get provider, site from where is used the embedded code
   *
   * @return array
   */
  public function getEmbeddedProvider() {
    return $this->embeviProvider;
  }

  /**
   * Get informations about embedded code
   *
   * @return string
   */
  public function getEmbeddedInfo() {
    return $this->embeviInfo;
  }

  /**
   * Set object attribute value
   *
   * @param mixed $param - the name of the object attribute to be set or an array of multiple object attributes to set
   * @param string $value - (optional) the value to set the object attribute, if only one object attribute is being set
   *
   * @return boolean - true, if the value was set
   *                 - false, if objectAttr isn't array
   */
  public function setObjectAttr($param, $value = '') {
    if (!is_array($this->objectAttr)) return false;

    if ( is_array($param) ) {
      foreach ($param AS $k => $v) {
        $this->objectAttr[$k] = $v;
      }
    }
    else {
      $this->objectAttr[$param] = $value;
    }

    return true;
  }

  /**
   * Set embed attribute value
   *
   * @param mixed $param - the name of the embed attribute to be set or an array of multiple embed attributes to set
   * @param string $value - (optional) the value to set the embed attribute, if only one embed attribute is being set
   *
   * @return boolean - true, if the value was set
   *                 - false, if embedAttr isn't array
   */
  public function setEmbedAttr($param, $value = '') {
    if (!is_array($this->embedAttr)){
      return false;
    }

    if ( is_array($param) ) {
      foreach ($param AS $k => $v) {
        $this->embedAttr[$k] = $v;
      }
    }
    else {
      $this->embedAttr[$param] = $value;
    }

    return true;
  }

  /**
   * Set object param value
   *
   * @param mixed $param - the name of the param to be set or an array of multiple params to set
   * @param string $value - (optional) the value to set the param, if only one param is being set
   *
   * @return boolean - true, if the value was set
   *                 - false, if objectParam isn't array
   */
  public function setObjectParam($param, $value = '') {
    if (!is_array($this->objectParam)) return false;

    if ( is_array($param) ) {
      foreach ($param AS $k => $v) {
        $this->objectParam[$k] = $v;
      }
    }
    else {
      $this->objectParam[$param] = $value;
    }

    return true;
  }

  /**
   * Parse URL
   *
   * @param string $url - Link to check for embeded video
   *
   * @return boolean - true, if the link is supported for embedding
   *                 - false, if the link isn't supported for embedding
   */
  public function parseUrl($url) {
    $goodLink = false;
    $url = trim($url);

    if( $this->acceptShortUrl && preg_match($this->returnShortUrlServicesRegExpr(), $url) ) {
      $url = $this->realUrl($url);
    }

    foreach ($this->embeviSupport as $k=>$v) {
      $goodLink = $this->matchUrl($url, $v);
      if ($goodLink) {
        break;
      }
    }

    if (!$goodLink && $this->getAcceptExtendedSupport()) {
      foreach ($this->embeviSupportExtended as $k=>$v) {
        $goodLink = $this->matchUrl($url, $v, true);
        if ($goodLink) {
          break;
        }
      }
    }

    if($goodLink) {
      //set width and height that will be used for generated code
      $this->setDimensions();
    }
    return $goodLink;
  }

  /**
   * Get the HTML code for the video
   *
   * @param boolean $addHtmlBefore - false, doesn't do anything
   *                               - true, adds <br /> before the embedded code
   * @param boolean $addHtmlAfter - false, doesn't do anything
   *                              - true, adds <br /> after the embedded code
   *
   * @return string - HTML code for the video
   */
  public function getCode($addHtmlBefore = false, $addHtmlAfter = false) {
    $objectAttributes = '';
    $objectParams = '';
    $embedAttributes = '';
    foreach ($this->objectAttr AS $k => $v) {
      $objectAttributes .= ' '.$k.'="'.$v.'"';
    }

    foreach ($this->objectParam AS $k => $v) {
      $objectParams .= '<param name="'.$k.'" value="'.$v.'" ></param>';
    }

    foreach ($this->embedAttr AS $k => $v) {
      $embedAttributes .= ' '.$k.'="'.$v.'"';
    }

    $beforeHtml = "";
    if($addHtmlBefore) {
      $beforeHtml = $this->beforeHtml;
    }
    $afterHtml = "";
    if($addHtmlAfter) {
      $afterHtml = $this->afterHtml;
    }

    return trim(sprintf("%s%s<object%s>%s<embed%s ></embed></object>%s", $beforeHtml, $this->copyright,
        $objectAttributes, $objectParams, $embedAttributes, $afterHtml));
  }

  /**
   * Parse text
   *
   * @param string $text - Text to check for embeded video
   * @param boolean $keepLink - false, the embedded link will be removed
   *                          - true, the embedded link will be returned
   * @param boolean $addHtmlBefore - false, doesn't do anything
   *                                  - true, adds <br /> before the embedded code
   * @param boolean $addHtmlAfter - false, doesn't do anything
   *                                 - true, adds <br /> after the embedded code
   *
   * @return string - text with embeded code
   *
   */
  public function parseText($text, $keepLink = false, $addHtmlBefore = false, $addHtmlAfter = false) {
    if(preg_match_all('/(https?[\S]+)/i', $text, $result)){
      foreach($result[1] AS $link) {
        if($this->parseUrl($link)) {
          $linkReplacement = $this->getCode($addHtmlBefore, $addHtmlAfter);
          if($keepLink) {
            $linkReplacement .= $link;
          }
          $text = preg_replace('/'.preg_quote($link, '/').'/i', $linkReplacement, $text);
        }
      }
    }
    return $text;
  }

  /**
   * Parse HTML
   *
   * @param string $html - HTML to check for embeded video
   * @param boolean $keepLink - false, the embedded link will be removed
   *                          - true, the embedded link will be returned
   * @param boolean $addHtmlBefore - false, doesn't do anything
   *                                  - true, adds <br /> before the embedded code
   * @param boolean $addHtmlAfter - false, doesn't do anything
   *                                 - true, adds <br /> after the embedded code
   *
   * @return string - text with embeded code
   *
   */
  public function parseHtml($html, $keepLink = false, $addHtmlBefore = false, $addHtmlAfter = false) {
    if($this->specialCharDecode) {
      $html = htmlspecialchars_decode($html);
    }
    if( preg_match_all('@(?<atag><a[^>]*?href ?= ?(?:"|\')(?<href>https?(?:.|\n)*?)(?:"|\').*?>(?<text>.*?)</a(?:[\s]+)?>)@i', $html, $result) ) {

      for($i =0; $i<count($result['atag']); $i++){
        $link = $result['href'][$i];
        if($this->parseUrl($link)) {
          $linkReplacement = $this->getCode($addHtmlBefore, $addHtmlAfter);
          if($keepLink) {
            $linkReplacement .= $result['atag'][$i];
          }
          $html = preg_replace('/'.preg_quote($result['atag'][$i], '/').'/i', $linkReplacement, $html);
        }
      }

    }
    return $html;
  }

  /**
   * Set Before HTML
   *
   * @param string $beforeHtml - string that will appear before the embedded code
   *                           when you use parseText method
   */
  public function setBeforeHtml($beforeHtml) {
    $this->beforeHtml = $beforeHtml;
  }

  /**
   * Set After HTML
   *
   * @param string $afterHtml - string that will appear after the embedded code
   *                           when you use parseText method
   */
  public function setAfterHtml($afterHtml) {
    $this->afterHtml = $afterHtml;
  }

  /**
   * Set Preference for accepting Short URL
   *
   */
  public function setAcceptShortUrl() {
    $this->acceptShortUrl = true;
  }

  /**
   * Unset Preference for accepting Short URL
   *
   */
  public function unsetAcceptShortUrl() {
    $this->acceptShortUrl = false;
  }

  /**
   * Get Embedded Provider Icon
   */
  public function getProviderIcon() {
    return $this->embeviProviderIcon;
  }

  /**
   * Get Embedded Provider Name
   */
  public function getProviderName() {
    return $this->embeviProviderName;
  }

  /**
   * Set Provider Icon source to be from a specified address
   */
  public function setProviderIconLocal() {
    $this->embeviProviderIconSource = false;
  }

  /**
   * Set Provider Icon source to be from the site that is embedded
   */
  public function setProviderIconReal() {
    $this->embeviProviderIconSource = true;
  }

  /**
   * Set Provider Icon URL
   */
  public function setProviderIconUrl($url) {
    $this->embeviProviderIconUrl = $url;
  }

  /**
   * Set Provider Icon extension
   */
  public function setProviderIconExtension($extension) {
    $this->embeviProviderIconExtension = $extension;
  }

  /**
   * Set setup for accepting extended support list to be parsed
   */
  public function setAcceptExtendedSupport() {
    $this->acceptExtendedSupport = true;
  }

  /**
   * Unset setup for accepting extended support list to be parsed
   */
  public function unsetAcceptExtendedSupport() {
    $this->acceptExtendedSupport = false;
  }

  /**
   * Get setup for accepting extended support list to be parsed
   */
  public function getAcceptExtendedSupport() {
    return $this->acceptExtendedSupport;
  }
  
  /**
   * Set provider image identifier
   * 
   */
  private function setProviderImageIdentifier() {
    $this->embeviProviderImageIdentifier = $this->embeviProviderIconUrl . $this->embeviProviderName .
      $this->embeviProviderIconExtension;
  }
  
  /**
   * Get provider image identifier
   *  - if provider has icon then it will return path to that icon
   *  - if it doens't have an icon then it will return a path to that
   *  	image, from $embeviProviderIconUrl
   */
  public function getProviderImageIdentifier() {
    return $this->embeviProviderImageIdentifier;
  }

  /**
   * Return real URL
   *
   * @param string $url
   * @return string
   */
  private function realUrl($url){

    if(!function_exists('get_headers')) {
      /**
       * Same functionality as PHP5 get_headers
       *
       * Source code for function: http://php.net/manual/en/function.get-headers.php
       *
       * @author info at marc-gutt dot de
       * @param string $url
       * @param int $format
       * @return array
       */
      function get_headers($url, $format=0) {
        $headers = array();
        $url = parse_url($url);
        $host = isset($url['host']) ? $url['host'] : '';
        $port = isset($url['port']) ? $url['port'] : 80;
        $path = (isset($url['path']) ? $url['path'] : '/') . (isset($url['query']) ? '?' . $url['query'] : '');
        $fp = fsockopen($host, $port, $errno, $errstr, 3);
        if ($fp) {
          $hdr = "GET $path HTTP/1.1\r\n";
          $hdr .= "Host: $host \r\n";
          $hdr .= "Connection: Close\r\n\r\n";
          fwrite($fp, $hdr);
          while (!feof($fp) && $line = trim(fgets($fp, 1024))) {
            if ($line == "\r\n") {
            	break;
            }
            list($key, $val) = explode(': ', $line, 2);
            if ($format) {
              if ($val) {
                $headers[$key] = $val;
              }
              else {
                $headers[] = $key;
              }
            }
            else {
              $headers[] = $line;
            }
          }
          fclose($fp);
          return $headers;
        }
        return false;
      }
    }

    $urlHeaders =get_headers($url, 1);
    if(isset($urlHeaders['Location'])){
      if(is_array($urlHeaders['Location'])){
        $url = $urlHeaders['Location'][count($urlHeaders['Location'])-1];
      }
      else{
        $url = $urlHeaders['Location'];
      }
    }

    return $url;
  }

  /**
   * Return shorten url services regular expression
   *
   * @return string
   */
  private function returnShortUrlServicesRegExpr(){
    $shortUrlServices = $this->shortUrlServices;
    foreach($shortUrlServices AS $key => $value){
      $shortUrlServices[$key] = preg_quote($value, '/');
    }
    $shortUrlServices = implode("|", $shortUrlServices);
    return '/https?:\\/\\/(w{3}\\.)?('.$shortUrlServices.')/i';
  }

  /**
   * Set dimensions for embedded code
   *
   */
  private function setDimensions(){
    $useWidth = $this->embeviWidth;
    $useHeight = $this->embeviHeight;

    if($useWidth <= 0 ){
      if($this->globalWidth > 0){
        $useWidth = $this->globalWidth;
      }
      if ( $this->globalMaxImportant && $this->globalMaxWidth > 0 &&
          ( ($useWidth > $this->globalMaxWidth) || ($useWidth == 0 && $this->baseWidth > $this->globalMaxWidth) ) ){
        $useWidth = $this->globalMaxWidth;
      }
    }

    if($useHeight <= 0){
      if($this->globalHeight > 0){
        $useHeight = $this->globalHeight;
      }
      if ( $this->globalMaxImportant && $this->globalMaxHeight > 0 &&
          ( ($useHeight > $this->globalMaxHeight) || ($useHeight == 0 && $this->baseHeight > $this->globalMaxHeight) ) ){
        $useHeight = $this->globalMaxHeight;
      }
    }

    if($this->globalMaxImportant){
      if($this->globalMaxWidth > 0){
        if($useWidth > $this->globalMaxWidth){
          $useWidth = $this->globalMaxWidth;
        }
        elseif($useWidth == 0 && $this->baseWidth > $this->globalMaxWidth){
          $useWidth = $this->globalMaxWidth;
        }
      }
    }

    if($this->keepRatio && $useWidth === 0 && $useHeight !== 0 ){
      $useWidth = round($useHeight*$this->baseWidth/$this->baseHeight, 0);
    }

    if($this->globalMaxImportant){
      if($this->globalMaxHeight > 0){
        if($useHeight > $this->globalMaxHeight){
          $useHeight = $this->globalMaxHeight;
        }
        elseif($useWidth == 0 && $this->baseHeight > $this->globalMaxHeight){
          $useHeight = $this->globalMaxHeight;
        }
      }
    }

    if($this->keepRatio && $useWidth !== 0 && $useHeight === 0 ){
      $useHeight = round($useWidth*$this->baseHeight/$this->baseWidth, 0);
    }

    //set width
    $this->setWidth($useWidth);
    //set height
    $this->setHeight($useHeight);

  }
  
  private function setDataSource($newSource) {
    $newSource = htmlspecialchars($newSource, ENT_QUOTES, null, false);
    $this->setEmbedAttr('src', $newSource);
    $this->setObjectParam('movie', $newSource);
  }

  /**
   * Function to match provided URL with a supported provider
   *
   * @param string $url
   * @param array $v
   */
  private function matchUrl($url, $v, $extended = false) {
    $doMatch = true;
    if ($extended) {
      $doMatch = false;
      if (preg_match('/'.$v['matchUrl'].'/i', $url)) {
        //var_dump('extended match url');
        $doMatch = true;
        $url = preg_replace('/[^(\x20-\x7F)]*/','', file_get_contents($url));
        //var_dump($url);
      }
    }

    $goodLink = false;
    if ($doMatch && preg_match('/'.$v['matchExpr'].'/i', $url, $result)) {
      //var_dump($result);
      $this->baseWidth = $v['width'];
      $this->baseHeight = $v['height'];
      $this->embeviProvider = $v['provider'];
      $this->embeviInfo = $v['info'];
      $this->setEmbedAttr('src', $v['src']);
      $this->setWidth(0);
      $this->setHeight(0);
      $this->embeviProviderIcon = $this->embeviDefaultProviderIcon;
      $this->embeviProviderName = '';
      $this->embeviProviderImageIdentifier = '';

      if (isset($v['flashvars'])) {
        $this->setEmbedAttr('flashvars', $v['flashvars']);
        for($regCount = 0; $regCount<count($result); $regCount++){
          $this->embedAttr['src'] = str_ireplace("~to_replace".$regCount."~", $result[$regCount], $this->embedAttr['src']);
          $this->embedAttr['flashvars'] = str_ireplace("~to_replace".$regCount."~", $result[$regCount], $this->embedAttr['flashvars']);
        }
        $this->embedAttr['flashvars'] = htmlspecialchars($this->embedAttr['flashvars'], ENT_QUOTES, null, false);
        $this->setObjectParam('flashvars', $this->embedAttr['flashvars']);
      }
      else {
        for ($regCount = 0; $regCount<count($result); $regCount++) {
          $this->embedAttr['src'] = str_ireplace("~to_replace".$regCount."~", $result[$regCount], $this->embedAttr['src']);
        }
        $this->embedAttr['flashvars'] = null;
      }
      $this->setDataSource($this->embedAttr['src']);
      
      $icoName = $v['providerName'];
      if (isset($v['providerIcon']) && $v['providerIcon'] === 'none') {
        $icoName = $this->embeviImageName;
      }
      
      if ($this->embeviProviderIconSource) {
        if (isset($v['providerIcon'])) {
          if ($v['providerIcon'] !== 'none') {
            $this->embeviProviderIcon = $v['providerIcon'];
          }
        }
        else{
          $this->embeviProviderIcon = $v['provider'][0].'favicon.ico';
        }
      }
      else {
        $this->embeviProviderIcon = $this->embeviProviderIconUrl . $icoName . $this->embeviProviderIconExtension;
      }
      $this->embeviProviderName = $v['providerName'];
      $this->setProviderImageIdentifier();
      $goodLink = true;
    }

    return $goodLink;
  }

}

?>