<?
//
// +------------------------------------------------------------------------+
// | phpMyMailer version 0.3                                                |
// +------------------------------------------------------------------------+
// | Copyright (c) 2000 The phpHeaven-team                                  |
// +------------------------------------------------------------------------+
// | This library sends plain text or html e-mails with                     |
// | - a valid date format according to the RFC 822;                        |
// | - and proxies of the quoted printable values of the sender full name,  |
// |   the recipients full names and the mail subject.                      |
// |                                                                        |
// | usage:    - case1: defines the variables $senderAddress, $senderName   |
// |                    and $senderNameCharset a few lines below            |
// |                or                                                      |
// |             case2: skip to next stage                                  |
// |           - include this library to the top of your files              |
// |           - create new mail handlers like this:                        |
// |               case1: $mailHandler = new PHPMYMAILER;                   |
// |                   or                                                   |
// |               case2: $mailHandler = new PHPMYMAILER($senderAddress,    |
// |                                                     $senderName,       |
// |                                                     $senderNameCharset |
// |                                                    );					|
// |           - inside your file define an associative array containing    |
// |             informations about the addresses. Each line should like:   |
// |                'e-mail' => array('nick', 'charset for this nick')      |
// |                    or                                                  |
// |                'e-mail' => array('nick', '')                           |
// |                    or                                                  |
// |                'e-mail' => array('', '')                               |
// |           - call the 'pmmSendEmail' method                             |
// |                                                                        |
// | required: the 'mail()' PHP function must be enabled                    |
// +------------------------------------------------------------------------+
// | From the phpHeaven libraries:                                          |
// |    http://www.phpheaven.net/resources/libraries/                       |
// |                                                                        |
// | Authors: The phpHeaven-team <phpHeaven-team@yahoogroups.com>           |
// +------------------------------------------------------------------------+
//
// $Id: phpMyMailer.lib.php3,v 0.3 2001/02/03
//
// PHP mail sender.
//



if (!defined('_LIB_PHPMYMAILER_LOADED'))
{
	/**
	 * Ensure the PHPMYMAILER class is defined only once
	 *
	 * @const _LIB_PHPMYMAILER_LOADED
	 */
	define('_LIB_PHPMYMAILER_LOADED', true);


	// -------------- CONFIGURATION --------------
	/**
	 * CONFIGURATION: Whether to display error messages or not
	 *
 	 * @const PHPMYMAILER_SHOW_ERROR_MESSAGES
	 */
	define('PHPMYMAILER_SHOW_ERROR_MESSAGES', true);
	// -------------------------------------------

	/**
	 * This class allows to send plain text or html e-mails with:
	 * 	- a valid date format according to the RFC 822;
	 *	- proxies of the quoted printable values of the sender full name, the
	 *    recipients full names and the mail subject.
	 *
	 * Attachments aren't supported yet.
	 *
	 * Note: All the charset values used inside this class should look like
	 * 'iso-8859-1', 'us-ascii', 'utf-8', 'utf-16'....
	 *
	 * @access		public
	 * @todo		add an attachments feature
	 * @version		0.3
	 * @package		phpMyMailer
	 * @author		the phpHeaven-team <phpHeaven-team@egroups.com>
	 * @copyright	the phpHeaven-team
	 */
	class PHPMYMAILER
	{
		/** 
		 * E-mail address of the sender
		 *
		 * @var	string	$senderAddress
		 */
		var $senderAddress;

		/**
		 * Full sender name
		 *
		 * @var	string	$senderName
		 */
		var $senderName;
		
		/**
		 * Charset associated to the sender name
		 *
		 * @var	string	$senderNameCharset
		 */
		var $senderNameCharset;

		/**
		 * The current php version
		 *
		 * @var	string	$phpVer
		 */
		var $phpVer;

		/**
		 * The common e-mail headers
		 *
		 * @var	array	$commonHeaders
		 */
		var $commonHeaders	= array();
		
		/**
		 * Whether the mail has been sent or not
		 *
		 * @var	boolean	$isSent
		 */
		var $isSent			= false;
		
		/**
		 * Error message
		 *
		 * @var	string	$errorMessage
		 */
		var	$errorMessage;


		/**
         * Constructor
		 *
		 * @param	string	the e-mail address of the sender
		 * @param	string	the full name of the sender
		 * @param	string	the charset associated to the sender name
		 *
		 * @access	public
		 */
		function PHPMYMAILER($senderAddress = '', $senderName = '', $senderNameCharset = '')
		{
			if ($senderAddress != '')
				$this->senderAddress		= $senderAddress;
			if ($senderName != '')
				$this->senderName			= $senderName;
			if ($senderNameCharset != '')
				$this->senderNameCharset	= $senderNameCharset;
			$this->phpVer					= phpversion();

		} // end of the 'PHPMYMAILER()' method


		/**
         * Handle and display error messages
		 *
		 * @param	integer		the error number
		 */
		function pmmSetErrorMsg($errorNumber = 0)
		{
			switch ($errorNumber)
			{
				case 1:
					$this->errorMessage = 'The addressees list is not an associative array!';
					break;

				case 2:
					$this->errorMessage = 'There is no addressee!';
					break;

				case 3:
					$this->errorMessage = 'Invalid adressees list for carbon copy!';
					break;

				case 4:
					$this->errorMessage = 'Invalid adressees list for blink carbon copy!';
					break;

				case 5:
					$this->errorMessage = 'There is no subject for the mail!';
					break;

				case 6:
					$this->errorMessage = 'There is no message to send!';
					break;

				case 7:
					$this->errorMessage = 'You forgot to define the sender address!';
					break;

				case 8:
					$this->errorMessage = 'The PHP \'mail()\' function seems to be disabled!';
					break;

				default:
					break;
			};

			if ($errorNumber && PHPMYMAILER_SHOW_ERROR_MESSAGES)
			{
				echo('<br /><b>Mail error:</b> ' . $this->errorMessage . '<br />');
				flush();
			};
		} // end of the 'pmmSetErrorMsg()' method


		/**
		 * Return a proxy of the quoted printable value of a string
		 *
		 * @param	string	the string to work on
		 * @param	string	the charset to use
		 * @return	string	the quoted printable proxy of the string
		 *
		 * @access	public
		 */
		function pmmQuotePrint($str = '', $whichCharset = '')
		{
			// Do the work only if the charset is defined and if the quoted-
			// printable format hasn't been applied to the string yet
			if ($whichCharset != '' && substr($str, 0, 2) != '=?')
			{
				$str = rawurlencode($str);
				$str = str_replace('%', '=', $str);
				$str = '=?' . $whichCharset . '?Q?' . $str . '?=';
			};
			return $str;
		} // end of the 'pmmQuotePrint()' method


		/**
		 * Return the formatted list of addressees
		 *
		 * @param	array	the associative array to use as input (passed by
		 *					reference)
		 * @return	string	the list of addressees
		 *
		 * @see		PHPMYMAILER::pmmQuotePrint()
		 */
		function pmmSetRecipientList(&$rcptArray)
		{
			$addresseesList = '';
			reset($rcptArray);
			
			while (list($eMail, $nickProp) = each($rcptArray))
			{
				if (!empty($addresseesList))
					$addresseesList	.= ', ';
					
				if (!empty($nickProp[0]))
				{
					$addresseesList	.= PHPMYMAILER::pmmQuotePrint($nickProp[0], $nickProp[1])
									 . ' <' . $eMail . '>';
				}
				else
				{
					$addresseesList	.= $eMail;
				};
			};

			reset($rcptArray);

			return $addresseesList;
		} // end of the 'pmmSetRecipientList()' method
		
		
		/**
 		 * Return the current date according to the RFC822 specifications
		 *
		 * The original script can be found here:
		 * www.zend.com/codex.php?id=307&single=1
		 *
		 * @return	string		the RFC822 formatted date
		 *
 		 * @author	fwancho <fwancho@whc.net>
		 * @author	the phpHeaven-team <phpHeaven-team@yahoogroups.com>
		 * @link	http://www.zend.com/codex.php?id=307&single=1	The original
		 *															script is here
		 */
		function pmmRfcDate()
		{
			// Translated from imap-4.7c/src/osdep/unix/env_unix.c
			// env-unix.c is Copyright 2000 by the University of Washington
			// localtime() not available in PHP3...

			$tn		= time(0);
			$t		= getdate($tn);
			$zone	= ($t['hours'] - gmdate('H', $tn))* 60
					+ ($t['minutes'] -  gmdate('i', $tn));

			// julian can be one of:
			//  36x  local time is December 31, UTC is January 1, offset -24 hours
			//    1  local time is 1 day ahead of UTC, offset +24 hours
			//    0  local time is same day as UTC, no offset
			//   -1  local time is 1 day behind UTC, offset -24 hours
			// -36x  local time is January 1, UTC is December 31, offset +24 hours
			$julian	= gmdate('z', $tn);
			if ($julian = $t['yday'] - $julian)
			{
				$zone += (($julian < 0) == (abs($julian) == 1)) ? -24 * 60 : 24 * 60;
			};

			$zoneSign	= ($zone > 0) ? '+' : '-';
			$zoneValue	= abs($zone);

			return	date('D, d M Y H:i:s ', $tn)
					. $zoneSign
					. sprintf('%02d%02d', $zoneValue / 60, $zoneValue % 60)
					. ' (' . strftime('%Z') . ')'; 
		} // end of the 'pmmRfcDate()' method


		/**
		 * Set the common headers for the e-mail
		 *
		 * Empty lines will be replaced by specific values inside the
		 * PHPMYMAILER::pmmSetHeadersList() method.
		 *
		 * @see		PHPMYMAILER::pmmSetHeadersList()
		 */
		function pmmSetCommonHeaders()
		{
			// Defines misc. headers
			$this->commonHeaders[1]		= 'From: ' . $this->senderName . ' <' . $this->senderAddress . '>';
			$this->commonHeaders[2]		= 'X-Sender: ' . $this->senderAddress;
			$this->commonHeaders[3]		= 'X-Mailer: PHP/' . $this->phpVer;
			
			// Defines headers for errors (may or may not work!)
			$this->commonHeaders[4]		= 'Errors-To: ' . $this->senderAddress;
			$this->commonHeaders[5]		= 'Reply-To: ' . $this->senderAddress;

			// Defines headers for content type of the body
			$this->commonHeaders[8]		= 'Mime-Version: 1.0';
			$this->commonHeaders[10]	= 'Content-Transfer-Encoding: 8bit';
		} // end of the 'pmmSetCommonHeaders()' method


		/**
		 * Set the complete headers list for the e-mail
		 *
		 * Parameters are passed by reference to reduce the memory consumption.
		 *
		 * @param	string	formatted list of the Cc addressees
		 * @param	string	formatted list of the Bcc addressees
		 * @param	string	charset to use for the subject and the body
		 * 					 of the e-mail
		 * @param	boolean	whether the body of the mail is an HTML
		 * 					 page or not
		 * @param	integer	priority of the mail (1 for urgent, 4 for low)
		 * @return	string	e-mail headers
		 *
		 * @see		PHPMYMAILER::pmmSetCommonHeaders(),
		 *			PHPMYMAILER::pmmRfcDate()
		 */
		function pmmSetHeadersList(	&$ccAdressees, &$bccAdressees,
									&$bodyCharset, &$isBodyHtml,
									&$xPriority
									)
		{
			// Define the common headers if it hasn't been done yet
			if (!count($this->commonHeaders))
				PHPMYMAILER::pmmSetCommonHeaders();

			// Set the specific headers
			$this->commonHeaders[0]		= 'Date: ' . PHPMYMAILER::pmmRfcDate();
			$this->commonHeaders[6]		= (!empty($ccAdressees))
										? 'Cc: ' . $ccAdressees
										: '';
			$this->commonHeaders[7]		= (!empty($bccAdressees))
										? 'Bcc: ' . $bccAdressees
										: '';
			$this->commonHeaders[9]		= 'Content-Type: text/'
										. (($isBodyHtml) ? 'html' : 'plain')
										. '; charset=' . $bodyCharset;
			if ($xPriority != 1 && $xPriority != 4)
				$xPriority				= 3;	// 'normal' priority as default
			$this->commonHeaders[11]	= 'X-Priority: ' . $xPriority;

			// Define the headers list
			$mailHeadersList = '';
			for ($i = 0; $i < 12; $i++)
			{
				if ($this->commonHeaders[$i] != '')
					$mailHeadersList .= $this->commonHeaders[$i] . " \r\n";
			};

			return $mailHeadersList;
		} // end of the 'pmmSetHeadersList()' method
		

		/**
		 * Do send the email
		 *
		 * Each recipient is defined as a row of an associative array where:
		 *	- the key is his e-mail address;
		 *	- the value is an array containing his nick and the charset associated.
		 * Arrays are passed by reference to reduce the memory consumption.
		 *
		 * @param	array	associative array containing addressee
		 * 					 informations
		 * @param	array	associative array containing Cc addressee
		 * 					 informations
		 * @param	array	associative array containing Bcc addressee
		 * 					 informations
		 * @param	string	charset to use for the subject and the body
		 * 					 of the e-mail
		 * @param	string	subject of the e-mail
		 * @param	string	body of the e-mail
		 * @param	boolean	whether the body of the mail is an HTML
		 * 					 page or not
		 * @param	integer	priority of the mail (1 for urgent, 4 for low)
		 * @return	boolean	whether the e-mail has been sent or not
		 *
		 * @access	public
		 * @see		PHPMYMAILER::pmmSetErrorMsg(),
		 *			PHPMYMAILER::pmmSetRecipientList(),
		 *			PHPMYMAILER::pmmSetHeadersList()
		 */
		function pmmSendEmail(	&$sendTo, &$sendToCc, &$sendToBcc,
								$mailCharset = '', $mailSubject = '', $mailBody = '', $isHtml = false,
								$priority = 3)
		{
			// Initialize the $isSent variables
			$this->isSent	= false;


			// Ensure function parameters are valid
			if (!is_array($sendTo))
				PHPMYMAILER::pmmSetErrorMsg(1);
			if (count($sendTo) == 0)
				PHPMYMAILER::pmmSetErrorMsg(2);
			if (!empty($sendToCc) && !is_array($sendToCc))
				PHPMYMAILER::pmmSetErrorMsg(3);
			if (!empty($sendToBcc) && !is_array($sendToBcc))
				PHPMYMAILER::pmmSetErrorMsg(4);
			if (empty($mailSubject))
				PHPMYMAILER::pmmSetErrorMsg(5);
			if (empty($mailBody))
				PHPMYMAILER::pmmSetErrorMsg(6);
			if (empty($this->senderAddress))
				PHPMYMAILER::pmmSetErrorMsg(7);
			if (!empty($this->errorMessage))
				return false;	
				

			// Transform to quoted printable format if this is required and
			// define the adressees list
			$sendToList			= PHPMYMAILER::pmmSetRecipientList($sendTo);
			if (!empty($sendToCc) && count($sendToCc) > 0)
				$sendToCcList	= PHPMYMAILER::pmmSetRecipientList($sendToCc);
			else
				$sendToCcList	= '';
			if (!empty($sendToBcc) && count($sendToBcc) > 0)
				$sendToBccList	= PHPMYMAILER::pmmSetRecipientList($sendToBcc);
			else
				$sendToBccList	= '';

			// Transform to quoted printable format the sender name and the
			// subject of the message
			$this->senderName	= PHPMYMAILER::pmmQuotePrint($this->senderName, $this->senderNameCharset);
			$mailSubject		= PHPMYMAILER::pmmQuotePrint($mailSubject, $mailCharset);


			// Set the headers
			$mailHeaders		= PHPMYMAILER::pmmSetHeadersList(	$sendToCcList, $sendToBccList,
																	$mailCharset, $isHtml,
																	$priority
																);

			// Send the mail and gets the result
			$this->isSent = @mail($sendToList, $mailSubject, $mailBody, $mailHeaders);
			if (!$this->isSent)
				$this->pmmSetErrorMsg(8);
		} // end of the 'pmmSendEmail()' method

	} // end of the 'PHPMYMAILER' class

};
?>
