<?php
//
// +------------------------------------------------------------------------+
// | phpMyMailer example of use version 0.3                                 |
// +------------------------------------------------------------------------+
// | Copyright (c) 2000 The phpHeaven-team                                  |
// +------------------------------------------------------------------------+
// | The purpose of this file is to give some examples on how to use the    |
// | phpMyMailer library.                                                   |
// | This script uses the 'case 2' method described inside the cartouche at |
// | the top of the 'phpMyMailer.lib.php3' library.                         |
// +------------------------------------------------------------------------+
// | From the phpHeaven libraries:                                          |
// |    http://www.phpheaven.net/resources/libraries/                       |
// |                                                                        |
// | Authors: The phpHeaven-team <phpHeaven-team@yahoogroups.com>           |
// +------------------------------------------------------------------------+
//
// $Id: phpMyMailer_example.php3,v 0.3 2001/02/03
//
// Example of use of phpMyMailer.
//



// ---------------- 1st stage : define a PHPMYMAIL instance ----------------

/**
 * Load the library if it hasn't been done yet
 *
 * As phpMyMail neither define HTTP headers nor cookies you may load the
 * phpMyMail library anywhere in your script.
 *
 * @include	Function: _include_
 */
if (!defined('_LIB_PHPMYMAILER_LOADED'))
	include('./phpMyMailer.lib.php3');


/**
 * Instantiate a new PHPMYMAILER object
 *
 * The sender name will be 'Zo', a name that requires the 'iso-8859-1' charset
 *
 * @var	object	$mailHandler
 */
$mailHandler = new PHPMYMAILER('zoe@test.fr', 'Zo', 'iso-8859-1');



// ------------- 2nd stage : define the list of the recipients -------------

/**
 * Set the list of the main recipients
 *
 * Each recipient is defined as a row of an associative array where:
 *	- the key is his e-mail address;
 *	- the value is an array containing his nick and the charset associated.
 *
 * Here are defined a korean guy, a chinese guy, a guy whose nick is not
 * associated with a charset and a last one whose nick is unknown.
 *
 * @var	array	$recipients
 */
$recipients = array(
	'recipient1@test.kr'	=> array(' ', 'euc-kr'), 	// a korean guy
	'recipient2@test.cn'	=> array('û', 'gb2312'),		// a chinese guy
	'recipient3@test.com'	=> array('user', ''),				// unknown charset
	'recipient4@test.net'	=> array('', '')					// no nick
);


/**
 * Set the list of the Cc recipients
 *
 * Same rules than the ones for the $recipients array (english guy here).
 *
 * @var	array	$recipientsCc
 *
 * @see $recipients
 */
$recipientsCc = array(
	'recipient5@test.uk'	=> array('user', 'us-ascii')	 	// an english guy
);


/**
 * Set the list of the Bcc recipients
 *
 * Same rules than the ones for the $recipients array (spanish guy here).
 *
 * @var	array	$recipientsBcc
 *
 * @see $recipients
 */
$recipientsBcc = array(
	'recipient6@test.es'	=> array('usuario', 'iso-8859-1')	// a spanish guy
);



// ------- 3rd stage : define the subject and the body of the e-mail -------

/**
 * Defines the charset to be used for the subject and the body of the mail
 *
 * Here a 'koi8-r' russian message will be sent.
 *
 * @var	string	$charset
 */
$charset	= 'koi8-r';


/**
 * Defines the subject of the mail
 *
 * @var	string	$subject
 */
$subject	= '';


/**
 * Defines the body of the mail
 *
 * @var	string	$body
 */
$body		= '    <b>;</b>)';



// ---------------------- 4th stage : Do send the mail ---------------------


/**
 *  I.	Send the e-mail to all the addressees at once (each one of the
 *		recipients may see the complete list -except Bcc ones- among the mail
 * 		headers)
 */


/**
 * I.1	Text format for the body of the mail and hight priority
 */
$mailHandler->pmmSendEmail(	$recipients, $recipientsCc, $recipientsBcc,
							$charset, $subject, $body, false,
							1
							);
echo('<p><b>I.1 All addressees at once, text format and hight priority:</b> The mail ');
echo(($mailHandler->isSent) ? 'has been' : 'can\'t be');
echo(' sent.</p>' . "\n" . '<br />' . "\n");


/**
 * I.2	HTML format for the body of the mail and low priority
 */
$mailHandler->pmmSendEmail(	$recipients, $recipientsCc, $recipientsBcc,
							$charset, $subject, $body, true,
							4
							);
echo('<p><b>I.2 All addressees at once, HTML format and low priority:</b> The mail ');
echo(($mailHandler->isSent) ? 'has been' : 'can\'t be');
echo(' sent.</p>' . "\n" . '<br />' . "\n");


/**
 * II.	Send the e-mail to each addressee independently (only Cc addressees are
 *		displayed inside the mail headers).
 *		Text format and normal priority
 */
echo('<p><b>II. Addressees one per one, text format and normal priority:</b></p>' . "\n" . '<ul>' . "\n");

// Format the subject to quoted printable so it won't be necessary to do this
// each time the 'PHPMYMAILER::pmmSendEmail' method is ran
$subject = $mailHandler->pmmQuotePrint($subject, $charset);

while (list($adr, $nick) = each($recipients))
{
	$oneRecipient = array($adr => $nick);
	$mailHandler->pmmSendEmail(	$oneRecipient, $recipientsCc, $recipientsBcc,
								$charset, $subject, $body, false,
								3
								);
						
	echo("\t" . '<li>The mail ');
	echo(($mailHandler->isSent) ? 'has been' : 'can\'t be');
	echo(' sent to ' . $adr . '</li>' . "\n");
};
echo('</ul>' . "\n");
?>
