/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Locale;
import netscape.javascript.JSObject;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.immutable.ImmutableMap;
import org.apache.pivot.wtk.Alert;
import org.apache.pivot.wtk.Application;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.TextArea;

public final class BrowserApplicationContext
extends ApplicationContext {
    private static ArrayList<HostApplet> hostApplets = new ArrayList();

    public static boolean isActive() {
        return hostApplets.getLength() > 0;
    }

    public static Application getApplication(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null.");
        }
        Application application = null;
        for (HostApplet hostApplet : hostApplets) {
            if (!hostApplet.getName().equals(name)) continue;
            application = hostApplet.getApplication();
            break;
        }
        return application;
    }

    public static Object eval(String script, Application application) {
        if (application == null) {
            throw new IllegalArgumentException("application is null.");
        }
        HostApplet applicationHostApplet = null;
        for (HostApplet hostApplet : hostApplets) {
            if (hostApplet.getApplication() != application) continue;
            applicationHostApplet = hostApplet;
            break;
        }
        if (applicationHostApplet == null) {
            throw new IllegalArgumentException("No applet is hosting the given application.");
        }
        try {
            JSObject window = JSObject.getWindow(applicationHostApplet);
            return window.eval(script);
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException(throwable);
        }
    }

    public static final class HostApplet
    extends Applet {
        private static final long serialVersionUID = -7710026348576806673L;
        private ApplicationContext.DisplayHost displayHost = null;
        private Application application = null;
        private HashMap<String, String> startupProperties = null;
        public static final String APPLICATION_CLASS_NAME_PARAMETER = "application_class_name";
        public static final String STARTUP_PROPERTIES_PARAMETER = "startup_properties";
        public static final String SYSTEM_PROPERTIES_PARAMETER = "system_properties";

        public Application getApplication() {
            return this.application;
        }

        @Override
        public void init() {
            InitCallback initCallback = new InitCallback();
            if (EventQueue.isDispatchThread()) {
                initCallback.run();
            } else {
                ApplicationContext.queueCallback(initCallback, true);
            }
        }

        @Override
        public void start() {
            StartCallback startCallback = new StartCallback();
            if (EventQueue.isDispatchThread()) {
                startCallback.run();
            } else {
                ApplicationContext.queueCallback(startCallback, true);
            }
        }

        @Override
        public void stop() {
            StopCallback stopCallback = new StopCallback();
            if (EventQueue.isDispatchThread()) {
                stopCallback.run();
            } else {
                ApplicationContext.queueCallback(stopCallback, true);
            }
        }

        @Override
        public void destroy() {
            DestroyCallback destroyCallback = new DestroyCallback();
            if (EventQueue.isDispatchThread()) {
                destroyCallback.run();
            } else {
                ApplicationContext.queueCallback(destroyCallback, true);
            }
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        private void displayException(Exception exception) {
            exception.printStackTrace();
            String message = exception.getClass().getName();
            TextArea body = null;
            String bodyText = exception.getMessage();
            if (bodyText != null && bodyText.length() > 0) {
                body = new TextArea();
                body.setText(bodyText);
                body.setEditable(false);
            }
            Alert alert = new Alert(MessageType.ERROR, message, null, body, false);
            alert.open(this.displayHost.getDisplay());
        }

        private class DestroyCallback
        implements Runnable {
            @Override
            public void run() {
                ApplicationContext.displays.remove((Object)HostApplet.this.displayHost.getDisplay());
                hostApplets.remove((Object)HostApplet.this);
                if (hostApplets.getLength() == 0) {
                    ApplicationContext.destroyTimer();
                }
            }
        }

        private class StopCallback
        implements Runnable {
            @Override
            public void run() {
                if (HostApplet.this.application != null) {
                    try {
                        HostApplet.this.application.shutdown(false);
                    }
                    catch (Exception exception) {
                        HostApplet.this.displayException(exception);
                    }
                    ApplicationContext.applications.remove((Object)HostApplet.this.application);
                    HostApplet.this.application = null;
                }
            }
        }

        private class StartCallback
        implements Runnable {
            @Override
            public void run() {
                if (HostApplet.this.application != null) {
                    try {
                        HostApplet.this.application.startup(HostApplet.this.displayHost.getDisplay(), (Map<String, String>)new ImmutableMap((Map)HostApplet.this.startupProperties));
                    }
                    catch (Exception exception) {
                        HostApplet.this.displayException(exception);
                    }
                    ApplicationContext.applications.add((Object)HostApplet.this.application);
                }
            }
        }

        private class InitCallback
        implements Runnable {
            @Override
            public void run() {
                String systemPropertiesParameter;
                URL codeBase = HostApplet.this.getCodeBase();
                if (codeBase != null) {
                    if (codeBase.getProtocol().equals("file")) {
                        File userHome = null;
                        try {
                            userHome = new File(System.getProperty("user.home"));
                        }
                        catch (SecurityException exception) {
                            // empty catch block
                        }
                        if (userHome != null) {
                            try {
                                ApplicationContext.origin = userHome.toURI().toURL();
                            }
                            catch (MalformedURLException exception) {}
                        }
                    } else {
                        try {
                            ApplicationContext.origin = new URL(codeBase.getProtocol(), codeBase.getHost(), codeBase.getPort(), "");
                        }
                        catch (MalformedURLException exception) {
                            // empty catch block
                        }
                    }
                }
                if ((systemPropertiesParameter = HostApplet.this.getParameter(HostApplet.SYSTEM_PROPERTIES_PARAMETER)) != null) {
                    String[] arguments = systemPropertiesParameter.split("&");
                    String language = null;
                    String region = null;
                    for (String argument : arguments) {
                        String[] property = argument.split("=");
                        if (property.length == 2) {
                            String value;
                            String key = property[0].trim();
                            try {
                                value = URLDecoder.decode(property[1].trim(), "UTF-8");
                            }
                            catch (UnsupportedEncodingException exception) {
                                throw new RuntimeException(exception);
                            }
                            if (key.equals("user.language")) {
                                language = value;
                                continue;
                            }
                            if (key.equals("user.region")) {
                                region = value;
                                continue;
                            }
                            System.setProperty(key, value);
                            continue;
                        }
                        System.err.println(argument + " is not a valid system property.");
                    }
                    if (language != null) {
                        Locale.setDefault(region == null ? new Locale(language) : new Locale(language, region));
                    }
                }
                HostApplet.this.startupProperties = new HashMap();
                String startupPropertiesParameter = HostApplet.this.getParameter(HostApplet.STARTUP_PROPERTIES_PARAMETER);
                if (startupPropertiesParameter != null) {
                    for (String argument : startupPropertiesParameter.split("&")) {
                        String[] property = argument.split("=");
                        if (property.length == 2) {
                            String value;
                            String key = property[0].trim();
                            try {
                                value = URLDecoder.decode(property[1].trim(), "UTF-8");
                            }
                            catch (UnsupportedEncodingException exception) {
                                throw new RuntimeException(exception);
                            }
                            HostApplet.this.startupProperties.put((Object)key, (Object)value);
                            continue;
                        }
                        System.err.println(argument + " is not a valid startup property.");
                    }
                }
                HostApplet.this.displayHost = new ApplicationContext.DisplayHost();
                HostApplet.this.setLayout(new BorderLayout());
                HostApplet.this.add(HostApplet.this.displayHost);
                ApplicationContext.displays.add((Object)HostApplet.this.displayHost.getDisplay());
                HostApplet.this.setFocusTraversalKeysEnabled(false);
                HostApplet.this.setFocusTraversalPolicyProvider(true);
                HostApplet.this.setFocusCycleRoot(true);
                HostApplet.this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

                    @Override
                    public Component getLastComponent(Container aContainer) {
                        return null;
                    }

                    @Override
                    public Component getFirstComponent(Container aContainer) {
                        return null;
                    }

                    @Override
                    public Component getDefaultComponent(Container aContainer) {
                        return null;
                    }

                    @Override
                    public Component getComponentBefore(Container aContainer, Component aComponent) {
                        return HostApplet.this.displayHost;
                    }

                    @Override
                    public Component getComponentAfter(Container aContainer, Component aComponent) {
                        return HostApplet.this.displayHost;
                    }
                });
                HostApplet.this.setBackground(null);
                if (hostApplets.getLength() == 0) {
                    ApplicationContext.createTimer();
                }
                hostApplets.add((Object)HostApplet.this);
                String applicationClassName = HostApplet.this.getParameter(HostApplet.APPLICATION_CLASS_NAME_PARAMETER);
                if (applicationClassName == null) {
                    System.err.println("application_class_name paramter is required.");
                } else {
                    try {
                        Class<?> applicationClass = Class.forName(applicationClassName);
                        HostApplet.this.application = (Application)applicationClass.newInstance();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
    }
}

