/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.LinkedList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.FrameListener;
import org.apache.pivot.wtk.MenuBar;
import org.apache.pivot.wtk.MenuHandler;
import org.apache.pivot.wtk.WTKListenerList;
import org.apache.pivot.wtk.Window;

public class Frame
extends Window {
    private MenuBar menuBar = null;
    private FrameListenerList frameListeners = new FrameListenerList();

    public Frame() {
        this(null, null);
    }

    public Frame(String title) {
        this(title, null);
    }

    public Frame(Component content) {
        this(null, content);
    }

    public Frame(String title, Component content) {
        super(content);
        this.setTitle(title);
        this.installSkin(Frame.class);
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setMenuBar(MenuBar menuBar) {
        MenuBar previousMenuBar = this.menuBar;
        if (previousMenuBar != menuBar) {
            this.menuBar = menuBar;
            if (previousMenuBar != null) {
                this.remove(previousMenuBar);
            }
            if (menuBar != null) {
                this.add(menuBar);
            }
            this.frameListeners.menuBarChanged(this, previousMenuBar);
        }
    }

    @Override
    public void moveToFront() {
        super.moveToFront();
        this.requestActive();
    }

    @Override
    protected void descendantGainedFocus(Component descendant, Component previousFocusedComponent) {
        if (this.menuBar != null) {
            LinkedList path = new LinkedList();
            Component ancestor = descendant;
            while (!(ancestor instanceof Display)) {
                path.insert((Object)ancestor, 0);
                ancestor = ancestor.getParent();
            }
            for (Component component : path) {
                MenuHandler menuHandler = component.getMenuHandler();
                if (menuHandler == null) continue;
                menuHandler.configureMenuBar(component, this.menuBar);
            }
        }
        super.descendantGainedFocus(descendant, previousFocusedComponent);
    }

    @Override
    protected void descendantLostFocus(Component descendant) {
        if (this.menuBar != null) {
            LinkedList path = new LinkedList();
            Component ancestor = descendant;
            while (!(ancestor instanceof Display)) {
                path.insert((Object)ancestor, 0);
                ancestor = ancestor.getParent();
            }
            for (Component component : path) {
                MenuHandler menuHandler = component.getMenuHandler();
                if (menuHandler == null) continue;
                menuHandler.cleanupMenuBar(component, this.menuBar);
            }
        }
        super.descendantLostFocus(descendant);
    }

    @Override
    public Sequence<Component> remove(int index, int count) {
        int n = index + count;
        for (int i = index; i < n; ++i) {
            Component component = this.get(i);
            if (component != this.menuBar) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(index, count);
    }

    public ListenerList<FrameListener> getFrameListeners() {
        return this.frameListeners;
    }

    private static class FrameListenerList
    extends WTKListenerList<FrameListener>
    implements FrameListener {
        private FrameListenerList() {
        }

        @Override
        public void menuBarChanged(Frame frame, MenuBar previousMenuBar) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                FrameListener listener = (FrameListener)i$.next();
                listener.menuBarChanged(frame, previousMenuBar);
            }
        }
    }
}

