/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.Serializable;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;

public final class Limits
implements Serializable {
    private static final long serialVersionUID = -1420266625812552298L;
    public final int minimum;
    public final int maximum;
    public static final String MINIMUM_KEY = "minimum";
    public static final String MAXIMUM_KEY = "maximum";

    public Limits(int minimum, int maximum) {
        if (minimum > maximum) {
            throw new IllegalArgumentException("minimum is greater than maximum.");
        }
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public Limits(Limits limits) {
        if (limits == null) {
            throw new IllegalArgumentException("limits is null.");
        }
        this.minimum = limits.minimum;
        this.maximum = limits.maximum;
    }

    public Limits(Dictionary<String, ?> limits) {
        if (limits == null) {
            throw new IllegalArgumentException("limits is null.");
        }
        this.minimum = limits.containsKey((Object)MINIMUM_KEY) ? (Integer)limits.get((Object)MINIMUM_KEY) : Integer.MIN_VALUE;
        this.maximum = limits.containsKey((Object)MAXIMUM_KEY) ? (Integer)limits.get((Object)MAXIMUM_KEY) : Integer.MAX_VALUE;
        if (this.minimum > this.maximum) {
            throw new IllegalArgumentException("minimum is greater than maximum.");
        }
    }

    public int constrain(int value) {
        if (value < this.minimum) {
            return this.minimum;
        }
        if (value > this.maximum) {
            return this.maximum;
        }
        return value;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object instanceof Limits) {
            Limits limits = (Limits)object;
            equals = this.minimum == limits.minimum && this.maximum == limits.maximum;
        }
        return equals;
    }

    public int hashCode() {
        return 31 * this.minimum + this.maximum;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName());
        buf.append(" [");
        if (this.minimum == Integer.MIN_VALUE) {
            buf.append("MIN");
        } else {
            buf.append(this.minimum);
        }
        buf.append("-");
        if (this.maximum == Integer.MAX_VALUE) {
            buf.append("MAX");
        } else {
            buf.append(this.maximum);
        }
        buf.append("]");
        return buf.toString();
    }

    public static Limits decode(String value) {
        Limits limits;
        if (value == null) {
            throw new IllegalArgumentException();
        }
        try {
            limits = new Limits((Dictionary<String, ?>)JSONSerializer.parseMap((String)value));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
        return limits;
    }
}

