/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.LinkedList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.json.JSON;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.BindType;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Clipboard;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.LocalManifest;
import org.apache.pivot.wtk.Manifest;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TextAreaBindingListener;
import org.apache.pivot.wtk.TextAreaContentListener;
import org.apache.pivot.wtk.TextAreaListener;
import org.apache.pivot.wtk.TextAreaSelectionListener;
import org.apache.pivot.wtk.WTKListenerList;

public class TextArea
extends Component {
    private ArrayList<Paragraph> paragraphs = new ArrayList();
    private ParagraphSequence paragraphSequence = new ParagraphSequence();
    private int characterCount = 0;
    private int selectionStart = 0;
    private int selectionLength = 0;
    private boolean expandTabs = false;
    private int maximumLength = 1048575;
    private boolean editable = true;
    private String textKey = null;
    private BindType textBindType = BindType.BOTH;
    private TextBindMapping textBindMapping = null;
    private LinkedList<Edit> editHistory = new LinkedList();
    private TextAreaListenerList textAreaListeners = new TextAreaListenerList();
    private TextAreaContentListenerList textAreaContentListeners = new TextAreaContentListenerList();
    private TextAreaSelectionListenerList textAreaSelectionListeners = new TextAreaSelectionListenerList();
    private TextAreaBindingListenerList textAreaBindingListeners = new TextAreaBindingListenerList();
    private static final int INITIAL_PARAGRAPH_CAPACITY = 256;
    private static final int MAXIMUM_EDIT_HISTORY_LENGTH = 30;

    public TextArea() {
        this.installSkin(TextArea.class);
        try {
            this.setText(new StringReader(""));
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public String getText() {
        return this.getText(0, this.getCharacterCount());
    }

    public String getText(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException();
        }
        if (beginIndex < 0 || endIndex > this.characterCount) {
            throw new IndexOutOfBoundsException();
        }
        int count = endIndex - beginIndex;
        if (count == 0) {
            return "";
        }
        StringBuilder textBuilder = new StringBuilder(count);
        int paragraphIndex = this.getParagraphAt(beginIndex);
        Paragraph paragraph = (Paragraph)this.paragraphs.get(paragraphIndex);
        int characterOffset = beginIndex - paragraph.offset;
        for (int i = 0; i < count; ++i) {
            if (characterOffset == paragraph.characters.length() && i < this.characterCount) {
                textBuilder.append('\n');
                paragraph = (Paragraph)this.paragraphs.get(++paragraphIndex);
                characterOffset = 0;
                continue;
            }
            textBuilder.append(paragraph.characters.charAt(characterOffset++));
        }
        return textBuilder.toString();
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        if (text.length() > this.maximumLength) {
            throw new IllegalArgumentException("Text length is greater than maximum length.");
        }
        try {
            if (!text.equals(this.getText())) {
                this.setText(new StringReader(text));
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(URL textURL) throws IOException {
        if (textURL == null) {
            throw new IllegalArgumentException();
        }
        InputStream inputStream = null;
        try {
            inputStream = textURL.openStream();
            this.setText(new InputStreamReader(inputStream));
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public void setText(Reader textReader) throws IOException {
        if (textReader == null) {
            throw new IllegalArgumentException();
        }
        ArrayList paragraphsLocal = new ArrayList();
        int characterCountLocal = 0;
        Paragraph paragraph = new Paragraph();
        int tabPosition = 0;
        int tabWidth = ((Skin)((Object)this.getSkin())).getTabWidth();
        int c = textReader.read();
        while (c != -1) {
            if (++characterCountLocal > this.maximumLength) {
                throw new IllegalArgumentException("Text length is greater than maximum length.");
            }
            if (c == 10) {
                paragraphsLocal.add((Object)paragraph);
                paragraph = new Paragraph();
                tabPosition = 0;
            } else if (c == 9 && this.expandTabs) {
                int spaces = tabWidth - tabPosition % tabWidth;
                for (int i = 0; i < spaces; ++i) {
                    if (++characterCountLocal > this.maximumLength) {
                        throw new IllegalArgumentException("Text length is greater than maximum length.");
                    }
                    paragraph.append(' ');
                }
                tabPosition += spaces;
            } else {
                paragraph.append((char)c);
                ++tabPosition;
            }
            c = textReader.read();
        }
        paragraphsLocal.add((Object)paragraph);
        this.editHistory.clear();
        this.paragraphSequence.remove(0, this.paragraphSequence.getLength());
        int n = paragraphsLocal.getLength();
        for (int i = 0; i < n; ++i) {
            this.paragraphSequence.add((Paragraph)paragraphsLocal.get(i));
        }
    }

    public void insertText(CharSequence text, int index) {
        this.insertText(text, index, true);
    }

    private void insertText(CharSequence text, int index, boolean addToEditHistory) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        TextArea.indexBoundsCheck("index", index, 0, this.characterCount);
        if (text.length() > 0) {
            int characterOffset;
            int paragraphIndex = this.getParagraphAt(index);
            Paragraph paragraph = (Paragraph)this.paragraphs.get(paragraphIndex);
            int tabPosition = characterOffset = index - paragraph.offset;
            int tabWidth = ((Skin)((Object)this.getSkin())).getTabWidth();
            StringBuilder textBuilder = new StringBuilder();
            int n = text.length();
            for (int i = 0; i < n; ++i) {
                char c = text.charAt(i);
                if (c == '\n') {
                    int count = paragraph.characters.length();
                    CharSequence trailingCharacters = paragraph.characters.subSequence(characterOffset, count);
                    paragraph.removeText(characterOffset, count - characterOffset);
                    paragraph.insertText(textBuilder, characterOffset);
                    paragraph = new Paragraph();
                    paragraph.insertText(trailingCharacters, 0);
                    this.paragraphSequence.insert(paragraph, ++paragraphIndex);
                    characterOffset = 0;
                    tabPosition = 0;
                    textBuilder = new StringBuilder();
                    continue;
                }
                if (c == '\t' && this.expandTabs) {
                    int spaces = tabWidth - tabPosition % tabWidth;
                    for (int j = 0; j < spaces; ++j) {
                        textBuilder.append(' ');
                    }
                    tabPosition += spaces;
                    continue;
                }
                textBuilder.append(c);
                ++tabPosition;
            }
            paragraph.insertText(textBuilder, characterOffset);
            if (addToEditHistory) {
                this.addHistoryItem(new InsertTextEdit(text, index));
            }
        }
    }

    public void removeText(int index, int count) {
        this.removeText(index, count, true);
    }

    private void removeText(int index, int count, boolean addToEditHistory) {
        if (index < 0 || index + count > this.characterCount) {
            throw new IndexOutOfBoundsException();
        }
        if (count > 0) {
            if (addToEditHistory) {
                this.addHistoryItem(new RemoveTextEdit(index, count));
            }
            int endParagraphIndex = this.getParagraphAt(index + count);
            Paragraph endParagraph = (Paragraph)this.paragraphs.get(endParagraphIndex);
            int beginParagraphIndex = endParagraphIndex;
            Paragraph beginParagraph = endParagraph;
            while (beginParagraph.offset > index) {
                beginParagraph = (Paragraph)this.paragraphs.get(--beginParagraphIndex);
            }
            if (beginParagraphIndex == endParagraphIndex) {
                beginParagraph.removeText(index - beginParagraph.offset, count);
            } else {
                String leadingText = beginParagraph.characters.substring(0, index - beginParagraph.offset);
                endParagraph.removeText(0, index + count - endParagraph.offset);
                this.paragraphSequence.remove(beginParagraphIndex, endParagraphIndex - beginParagraphIndex);
                endParagraph.insertText(leadingText, 0);
            }
        }
    }

    private void updateParagraphOffsets(int from, int count) {
        if (count != 0) {
            int n = this.paragraphs.getLength();
            for (int i = from; i < n; ++i) {
                Paragraph paragraph = (Paragraph)this.paragraphs.get(i);
                paragraph.offset += count;
            }
        }
    }

    public ParagraphSequence getParagraphs() {
        return this.paragraphSequence;
    }

    public int getParagraphAt(int index) {
        TextArea.indexBoundsCheck("index", index, 0, this.characterCount);
        int paragraphIndex = this.paragraphs.getLength() - 1;
        Paragraph paragraph = (Paragraph)this.paragraphs.get(paragraphIndex);
        while (paragraph.offset > index) {
            paragraph = (Paragraph)this.paragraphs.get(--paragraphIndex);
        }
        return paragraphIndex;
    }

    public char getCharacterAt(int index) {
        TextArea.indexBoundsCheck("index", index, 0, this.characterCount - 1);
        int paragraphIndex = this.getParagraphAt(index);
        Paragraph paragraph = (Paragraph)this.paragraphs.get(paragraphIndex);
        int characterOffset = index - paragraph.offset;
        return characterOffset == paragraph.characters.length() ? (char)'\n' : paragraph.characters.charAt(characterOffset);
    }

    public int getCharacterCount() {
        return this.characterCount;
    }

    public void cut() {
        this.copy();
        this.removeText(this.selectionStart, this.selectionLength);
    }

    public void copy() {
        String selectedText = this.getSelectedText();
        if (selectedText.length() > 0) {
            LocalManifest clipboardContent = new LocalManifest();
            clipboardContent.putText(selectedText);
            Clipboard.setContent(clipboardContent);
        }
    }

    public void paste() {
        Manifest clipboardContent = Clipboard.getContent();
        if (clipboardContent != null && clipboardContent.containsText()) {
            String text = null;
            try {
                text = clipboardContent.getText();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (text != null) {
                if (this.characterCount + text.length() > this.maximumLength) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    this.removeText(this.selectionStart, this.selectionLength);
                    this.insertText(text, this.selectionStart);
                }
            }
        }
    }

    public void undo() {
        int n = this.editHistory.getLength();
        if (n > 0) {
            Edit edit = (Edit)this.editHistory.remove(n - 1, 1).get(0);
            edit.undo();
        }
    }

    private void addHistoryItem(Edit edit) {
        this.editHistory.add((Object)edit);
        if (this.editHistory.getLength() > 30) {
            this.editHistory.remove(0, 1);
        }
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionLength() {
        return this.selectionLength;
    }

    public Span getSelection() {
        return this.selectionLength == 0 ? null : new Span(this.selectionStart, this.selectionStart + this.selectionLength - 1);
    }

    public void setSelection(int selectionStart, int selectionLength) {
        if (selectionLength < 0) {
            throw new IllegalArgumentException("selectionLength is negative.");
        }
        if (selectionStart < 0 || selectionStart + selectionLength > this.characterCount) {
            throw new IndexOutOfBoundsException();
        }
        int previousSelectionStart = this.selectionStart;
        int previousSelectionLength = this.selectionLength;
        if (previousSelectionStart != selectionStart || previousSelectionLength != selectionLength) {
            this.selectionStart = selectionStart;
            this.selectionLength = selectionLength;
            this.textAreaSelectionListeners.selectionChanged(this, previousSelectionStart, previousSelectionLength);
        }
    }

    public final void setSelection(Span selection) {
        if (selection == null) {
            throw new IllegalArgumentException("selection is null.");
        }
        this.setSelection(Math.min(selection.start, selection.end), (int)selection.getLength());
    }

    public void selectAll() {
        this.setSelection(0, this.characterCount);
    }

    public void clearSelection() {
        this.setSelection(0, 0);
    }

    public String getSelectedText() {
        return this.getText(this.selectionStart, this.selectionStart + this.selectionLength);
    }

    public int getMaximumLength() {
        return this.maximumLength;
    }

    public void setMaximumLength(int maximumLength) {
        if (maximumLength < 0) {
            throw new IllegalArgumentException("maximumLength is negative.");
        }
        int previousMaximumLength = this.maximumLength;
        if (previousMaximumLength != maximumLength) {
            this.maximumLength = maximumLength;
            if (this.characterCount > maximumLength) {
                this.removeText(maximumLength, this.characterCount - maximumLength);
            }
            this.textAreaListeners.maximumLengthChanged(this, previousMaximumLength);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (this.editable != editable) {
            if (!editable && this.isFocused()) {
                TextArea.clearFocus();
            }
            this.editable = editable;
            this.textAreaListeners.editableChanged(this);
        }
    }

    public String getTextKey() {
        return this.textKey;
    }

    public void setTextKey(String textKey) {
        String previousTextKey = this.textKey;
        if (previousTextKey != textKey) {
            this.textKey = textKey;
            this.textAreaBindingListeners.textKeyChanged(this, previousTextKey);
        }
    }

    public BindType getTextBindType() {
        return this.textBindType;
    }

    public void setTextBindType(BindType textBindType) {
        if (textBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousTextBindType = this.textBindType;
        if (previousTextBindType != textBindType) {
            this.textBindType = textBindType;
            this.textAreaBindingListeners.textBindTypeChanged(this, previousTextBindType);
        }
    }

    public TextBindMapping getTextBindMapping() {
        return this.textBindMapping;
    }

    public void setTextBindMapping(TextBindMapping textBindMapping) {
        TextBindMapping previousTextBindMapping = this.textBindMapping;
        if (previousTextBindMapping != textBindMapping) {
            this.textBindMapping = textBindMapping;
            this.textAreaBindingListeners.textBindMappingChanged(this, previousTextBindMapping);
        }
    }

    @Override
    public void load(Object context) {
        if (this.textKey != null && JSON.containsKey((Object)context, (String)this.textKey) && this.textBindType != BindType.STORE) {
            Object value = JSON.get((Object)context, (String)this.textKey);
            value = this.textBindMapping == null ? (value == null ? "" : value.toString()) : this.textBindMapping.toString(value);
            this.setText((String)value);
        }
    }

    @Override
    public void store(Object context) {
        if (this.textKey != null && this.textBindType != BindType.LOAD) {
            String text = this.getText();
            JSON.put((Object)context, (String)this.textKey, (Object)(this.textBindMapping == null ? text : this.textBindMapping.valueOf(text)));
        }
    }

    @Override
    public void clear() {
        if (this.textKey != null) {
            this.setText("");
        }
    }

    public boolean getExpandTabs() {
        return this.expandTabs;
    }

    public void setExpandTabs(boolean expandTabs) {
        this.expandTabs = expandTabs;
    }

    public int getInsertionPoint(int x, int y) {
        Skin textAreaSkin = (Skin)((Object)this.getSkin());
        return textAreaSkin.getInsertionPoint(x, y);
    }

    public int getNextInsertionPoint(int x, int from, ScrollDirection direction) {
        Skin textAreaSkin = (Skin)((Object)this.getSkin());
        return textAreaSkin.getNextInsertionPoint(x, from, direction);
    }

    public int getRowAt(int index) {
        Skin textAreaSkin = (Skin)((Object)this.getSkin());
        return textAreaSkin.getRowAt(index);
    }

    public int getRowOffset(int index) {
        Skin textAreaSkin = (Skin)((Object)this.getSkin());
        return textAreaSkin.getRowOffset(index);
    }

    public int getRowLength(int index) {
        Skin textAreaSkin = (Skin)((Object)this.getSkin());
        return textAreaSkin.getRowLength(index);
    }

    public int getRowCount() {
        Skin textAreaSkin = (Skin)((Object)this.getSkin());
        return textAreaSkin.getRowCount();
    }

    public Bounds getCharacterBounds(int index) {
        this.validate();
        Skin textAreaSkin = (Skin)((Object)this.getSkin());
        return textAreaSkin.getCharacterBounds(index);
    }

    public ListenerList<TextAreaListener> getTextAreaListeners() {
        return this.textAreaListeners;
    }

    public ListenerList<TextAreaContentListener> getTextAreaContentListeners() {
        return this.textAreaContentListeners;
    }

    public ListenerList<TextAreaSelectionListener> getTextAreaSelectionListeners() {
        return this.textAreaSelectionListeners;
    }

    public ListenerList<TextAreaBindingListener> getTextAreaBindingListeners() {
        return this.textAreaBindingListeners;
    }

    private static class TextAreaBindingListenerList
    extends WTKListenerList<TextAreaBindingListener>
    implements TextAreaBindingListener {
        private TextAreaBindingListenerList() {
        }

        @Override
        public void textKeyChanged(TextArea textArea, String previousTextKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextAreaBindingListener listener = (TextAreaBindingListener)i$.next();
                listener.textKeyChanged(textArea, previousTextKey);
            }
        }

        @Override
        public void textBindTypeChanged(TextArea textArea, BindType previousTextBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextAreaBindingListener listener = (TextAreaBindingListener)i$.next();
                listener.textBindTypeChanged(textArea, previousTextBindType);
            }
        }

        @Override
        public void textBindMappingChanged(TextArea textArea, TextBindMapping previousTextBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextAreaBindingListener listener = (TextAreaBindingListener)i$.next();
                listener.textBindMappingChanged(textArea, previousTextBindMapping);
            }
        }
    }

    private static class TextAreaSelectionListenerList
    extends WTKListenerList<TextAreaSelectionListener>
    implements TextAreaSelectionListener {
        private TextAreaSelectionListenerList() {
        }

        @Override
        public void selectionChanged(TextArea textArea, int previousSelectionStart, int previousSelectionLength) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextAreaSelectionListener listener = (TextAreaSelectionListener)i$.next();
                listener.selectionChanged(textArea, previousSelectionStart, previousSelectionLength);
            }
        }
    }

    private static class TextAreaContentListenerList
    extends WTKListenerList<TextAreaContentListener>
    implements TextAreaContentListener {
        private TextAreaContentListenerList() {
        }

        @Override
        public void paragraphInserted(TextArea textArea, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextAreaContentListener listener = (TextAreaContentListener)i$.next();
                listener.paragraphInserted(textArea, index);
            }
        }

        @Override
        public void paragraphsRemoved(TextArea textArea, int index, Sequence<Paragraph> removed) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextAreaContentListener listener = (TextAreaContentListener)i$.next();
                listener.paragraphsRemoved(textArea, index, removed);
            }
        }

        @Override
        public void textChanged(TextArea textArea) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextAreaContentListener listener = (TextAreaContentListener)i$.next();
                listener.textChanged(textArea);
            }
        }
    }

    private static class TextAreaListenerList
    extends WTKListenerList<TextAreaListener>
    implements TextAreaListener {
        private TextAreaListenerList() {
        }

        @Override
        public void maximumLengthChanged(TextArea textArea, int previousMaximumLength) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextAreaListener listener = (TextAreaListener)i$.next();
                listener.maximumLengthChanged(textArea, previousMaximumLength);
            }
        }

        @Override
        public void editableChanged(TextArea textArea) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TextAreaListener listener = (TextAreaListener)i$.next();
                listener.editableChanged(textArea);
            }
        }
    }

    private class RemoveTextEdit
    implements Edit {
        private final int index;
        private final CharSequence text;

        public RemoveTextEdit(int index, int count) {
            this.index = index;
            this.text = TextArea.this.getText(index, index + count);
        }

        @Override
        public void undo() {
            TextArea.this.insertText(this.text, this.index, false);
        }
    }

    private class InsertTextEdit
    implements Edit {
        private final int index;
        private final int count;

        public InsertTextEdit(CharSequence text, int index) {
            this.index = index;
            this.count = text.length();
        }

        @Override
        public void undo() {
            TextArea.this.removeText(this.index, this.count, false);
        }
    }

    private static interface Edit {
        public void undo();
    }

    public final class ParagraphSequence
    implements Sequence<Paragraph>,
    Iterable<Paragraph> {
        public int add(Paragraph paragraph) {
            int index = this.getLength();
            this.insert(paragraph, index);
            return index;
        }

        public void insert(Paragraph paragraph, int index) {
            if (paragraph == null) {
                throw new IllegalArgumentException("paragraph is null.");
            }
            if (paragraph.textArea != null) {
                throw new IllegalArgumentException("paragraph is already in use by another text area.");
            }
            int characterCountLocal = paragraph.characters.length();
            if (this.getLength() > 0) {
                ++characterCountLocal;
            }
            if (TextArea.this.characterCount + characterCountLocal > TextArea.this.maximumLength) {
                throw new IllegalArgumentException("Insertion of text would exceed maximum length.");
            }
            if (index == TextArea.this.paragraphs.getLength()) {
                paragraph.offset = TextArea.this.characterCount;
                if (index > 0) {
                    paragraph.offset++;
                }
            } else {
                paragraph.offset = ((Paragraph)TextArea.this.paragraphs.get(index)).offset;
            }
            TextArea.this.paragraphs.insert((Object)paragraph, index);
            paragraph.textArea = TextArea.this;
            TextArea.this.updateParagraphOffsets(index + 1, characterCountLocal);
            TextArea.this.characterCount += characterCountLocal;
            int previousSelectionStart = TextArea.this.selectionStart;
            int previousSelectionLength = TextArea.this.selectionLength;
            TextArea.this.selectionStart = paragraph.offset + paragraph.characters.length();
            TextArea.this.selectionLength = 0;
            TextArea.this.textAreaContentListeners.paragraphInserted(TextArea.this, index);
            TextArea.this.textAreaContentListeners.textChanged(TextArea.this);
            if (TextArea.this.selectionStart != previousSelectionStart || TextArea.this.selectionLength != previousSelectionLength) {
                TextArea.this.textAreaSelectionListeners.selectionChanged(TextArea.this, TextArea.this.selectionStart, TextArea.this.selectionLength);
            }
        }

        public Paragraph update(int index, Paragraph paragraph) {
            throw new UnsupportedOperationException();
        }

        public int remove(Paragraph paragraph) {
            int index = this.indexOf(paragraph);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Paragraph> remove(int index, int count) {
            Sequence removed = TextArea.this.paragraphs.remove(index, count);
            if (count > 0) {
                int characterCountLocal = 0;
                int n = removed.getLength();
                for (int i = 0; i < n; ++i) {
                    Paragraph paragraph = (Paragraph)removed.get(i);
                    paragraph.textArea = null;
                    paragraph.offset = -1;
                    characterCountLocal += paragraph.characters.length() + 1;
                }
                if (this.getLength() == 0) {
                    --characterCountLocal;
                }
                TextArea.this.updateParagraphOffsets(index, -characterCountLocal);
                TextArea.this.characterCount -= characterCountLocal;
                int previousSelectionStart = TextArea.this.selectionStart;
                int previousSelectionLength = TextArea.this.selectionLength;
                TextArea.this.selectionStart = index == TextArea.this.paragraphs.getLength() ? TextArea.this.characterCount : ((Paragraph)TextArea.this.paragraphs.get(index)).offset;
                TextArea.this.selectionLength = 0;
                TextArea.this.textAreaContentListeners.paragraphsRemoved(TextArea.this, index, (Sequence<Paragraph>)removed);
                TextArea.this.textAreaContentListeners.textChanged(TextArea.this);
                if (TextArea.this.selectionStart != previousSelectionStart || TextArea.this.selectionLength != previousSelectionLength) {
                    TextArea.this.textAreaSelectionListeners.selectionChanged(TextArea.this, TextArea.this.selectionStart, TextArea.this.selectionLength);
                }
            }
            return removed;
        }

        public Paragraph get(int index) {
            return (Paragraph)TextArea.this.paragraphs.get(index);
        }

        public int indexOf(Paragraph paragraph) {
            return TextArea.this.paragraphs.indexOf((Object)paragraph);
        }

        public int getLength() {
            return TextArea.this.paragraphs.getLength();
        }

        @Override
        public Iterator<Paragraph> iterator() {
            return new ImmutableIterator((Iterator)TextArea.this.paragraphs.iterator());
        }
    }

    public static interface TextBindMapping {
        public String toString(Object var1);

        public Object valueOf(String var1);
    }

    public static interface Skin {
        public int getInsertionPoint(int var1, int var2);

        public int getNextInsertionPoint(int var1, int var2, ScrollDirection var3);

        public int getRowAt(int var1);

        public int getRowOffset(int var1);

        public int getRowLength(int var1);

        public int getRowCount();

        public Bounds getCharacterBounds(int var1);

        public int getTabWidth();
    }

    public static enum ScrollDirection {
        UP,
        DOWN;

    }

    public static interface ParagraphListener {
        public void textInserted(Paragraph var1, int var2, int var3);

        public void textRemoved(Paragraph var1, int var2, int var3);

        public static class Adapter
        implements ParagraphListener {
            @Override
            public void textInserted(Paragraph paragraph, int index, int count) {
            }

            @Override
            public void textRemoved(Paragraph paragraph, int index, int count) {
            }
        }
    }

    public static final class Paragraph {
        private StringBuilder characters = new StringBuilder(256);
        private TextArea textArea = null;
        private int offset = -1;
        private ParagraphListenerList paragraphListeners = new ParagraphListenerList();

        public CharSequence getCharacters() {
            return this.characters;
        }

        public TextArea getTextArea() {
            return this.textArea;
        }

        public void append(char character) {
            if (this.textArea != null) {
                throw new IllegalStateException();
            }
            this.characters.append(character);
        }

        public void clear() {
            if (this.textArea != null) {
                throw new IllegalStateException();
            }
            this.characters.delete(0, this.characters.length());
        }

        public void insertText(CharSequence text, int index) {
            if (text == null) {
                throw new IllegalArgumentException();
            }
            Component.indexBoundsCheck("index", index, 0, this.characters.length());
            int count = text.length();
            if (this.textArea != null && this.textArea.characterCount + count > this.textArea.maximumLength) {
                throw new IllegalArgumentException("Insertion of text would exceed maximum length.");
            }
            this.characters.insert(index, text);
            if (this.textArea != null) {
                this.textArea.updateParagraphOffsets(this.textArea.paragraphs.indexOf((Object)this) + 1, count);
                this.textArea.characterCount += count;
                int previousSelectionStart = this.textArea.selectionStart;
                int previousSelectionLength = this.textArea.selectionLength;
                this.textArea.selectionStart = this.offset + index + count;
                this.textArea.selectionLength = 0;
                this.paragraphListeners.textInserted(this, index, count);
                this.textArea.textAreaContentListeners.textChanged(this.textArea);
                if (this.textArea.selectionStart != previousSelectionStart || this.textArea.selectionLength != previousSelectionLength) {
                    this.textArea.textAreaSelectionListeners.selectionChanged(this.textArea, this.textArea.selectionStart, this.textArea.selectionLength);
                }
            }
        }

        public void removeText(int index) {
            this.removeText(index, this.characters.length() - index);
        }

        public void removeText(int index, int count) {
            if (index < 0 || index + count > this.characters.length()) {
                throw new IndexOutOfBoundsException();
            }
            this.characters.delete(index, index + count);
            if (this.textArea != null) {
                this.textArea.updateParagraphOffsets(this.textArea.paragraphs.indexOf((Object)this) + 1, -count);
                this.textArea.characterCount -= count;
                int previousSelectionStart = this.textArea.selectionStart;
                int previousSelectionLength = this.textArea.selectionLength;
                this.textArea.selectionStart = this.offset + index;
                this.textArea.selectionLength = 0;
                this.paragraphListeners.textRemoved(this, index, count);
                this.textArea.textAreaContentListeners.textChanged(this.textArea);
                if (this.textArea.selectionStart != previousSelectionStart || this.textArea.selectionLength != previousSelectionLength) {
                    this.textArea.textAreaSelectionListeners.selectionChanged(this.textArea, this.textArea.selectionStart, this.textArea.selectionLength);
                }
            }
        }

        public int getOffset() {
            return this.offset;
        }

        public ListenerList<ParagraphListener> getParagraphListeners() {
            return this.paragraphListeners;
        }

        private static class ParagraphListenerList
        extends ListenerList<ParagraphListener>
        implements ParagraphListener {
            private ParagraphListenerList() {
            }

            @Override
            public void textInserted(Paragraph paragraph, int index, int count) {
                Iterator i$ = this.iterator();
                while (i$.hasNext()) {
                    ParagraphListener listener = (ParagraphListener)i$.next();
                    listener.textInserted(paragraph, index, count);
                }
            }

            @Override
            public void textRemoved(Paragraph paragraph, int index, int count) {
                Iterator i$ = this.iterator();
                while (i$.hasNext()) {
                    ParagraphListener listener = (ParagraphListener)i$.next();
                    listener.textRemoved(paragraph, index, count);
                }
            }
        }
    }
}

