/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import java.awt.Font;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.content.ListItem;
import org.apache.pivot.wtk.media.Image;

public class ListViewItemRenderer
extends BoxPane
implements ListView.ItemRenderer {
    protected ImageView imageView = new ImageView();
    protected Label label = new Label();
    public static final int DEFAULT_ICON_WIDTH = 16;
    public static final int DEFAULT_ICON_HEIGHT = 16;
    public static boolean DEFAULT_SHOW_ICON = false;

    public ListViewItemRenderer() {
        this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
        this.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.getStyles().put("padding", (Object)new Insets(2, 3, 2, 3));
        this.add(this.imageView);
        this.add(this.label);
        this.imageView.setPreferredSize(16, 16);
        this.imageView.setVisible(DEFAULT_SHOW_ICON);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    @Override
    public void render(Object item, int index, ListView listView, boolean selected, boolean checked, boolean highlighted, boolean disabled) {
        this.renderStyles(listView, selected, highlighted, disabled);
        Image icon = null;
        String text = null;
        if (item instanceof ListItem) {
            ListItem listItem = (ListItem)item;
            icon = listItem.getIcon();
            text = listItem.getText();
        } else if (item instanceof Image) {
            icon = (Image)item;
        } else if (item != null) {
            text = item.toString();
        }
        this.imageView.setImage(icon);
        this.label.setText(text != null ? text : "");
    }

    protected void renderStyles(ListView listView, boolean selected, boolean highlighted, boolean disabled) {
        this.imageView.getStyles().put("opacity", (Object)Float.valueOf(listView.isEnabled() ? 1.0f : 0.5f));
        Font font = (Font)listView.getStyles().get("font");
        this.label.getStyles().put("font", (Object)font);
        Color color = listView.isEnabled() && !disabled ? (selected ? (listView.isFocused() ? (Color)listView.getStyles().get("selectionColor") : (Color)listView.getStyles().get("inactiveSelectionColor")) : (Color)listView.getStyles().get("color")) : (Color)listView.getStyles().get("disabledColor");
        this.label.getStyles().put("color", (Object)color);
    }

    @Override
    public String toString(Object item) {
        String string = null;
        if (item instanceof ListItem) {
            ListItem listItem = (ListItem)item;
            string = listItem.getText();
        } else if (item != null) {
            string = item.toString();
        }
        return string;
    }

    public int getIconWidth() {
        return this.imageView.getPreferredWidth(-1);
    }

    public void setIconWidth(int iconWidth) {
        this.imageView.setPreferredWidth(iconWidth);
    }

    public int getIconHeight() {
        return this.imageView.getPreferredHeight(-1);
    }

    public void setIconHeight(int iconHeight) {
        this.imageView.setPreferredHeight(iconHeight);
    }

    public boolean getShowIcon() {
        return this.imageView.isVisible();
    }

    public void setShowIcon(boolean showIcon) {
        this.imageView.setVisible(showIcon);
    }

    public boolean getFillIcon() {
        return (Boolean)this.imageView.getStyles().get("fill");
    }

    public void setFillIcon(boolean fillIcon) {
        this.imageView.getStyles().put("fill", (Object)fillIcon);
    }

    public Bounds getTextBounds() {
        return this.label.isVisible() ? this.label.getBounds() : null;
    }
}

