/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.util.Comparator;
import org.apache.pivot.beans.BeanAdapter;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.SortDirection;
import org.apache.pivot.wtk.TableView;

public class TableViewRowComparator
implements Comparator<Object> {
    private TableView tableView;

    public TableViewRowComparator(TableView tableView) {
        if (tableView == null) {
            throw new IllegalArgumentException();
        }
        this.tableView = tableView;
    }

    @Override
    public int compare(Object o1, Object o2) {
        int result;
        TableView.SortDictionary sort = this.tableView.getSort();
        if (sort.getLength() > 0) {
            SortDirection sortDirection;
            Object row1 = o1 instanceof Dictionary ? (Dictionary)o1 : new BeanAdapter(o1);
            Object row2 = o2 instanceof Dictionary ? (Dictionary)o2 : new BeanAdapter(o2);
            result = 0;
            int n = sort.getLength();
            for (int i = 0; i < n && result == 0; result *= sortDirection == SortDirection.ASCENDING ? 1 : -1, ++i) {
                Dictionary.Pair<String, SortDirection> pair = sort.get(i);
                String columnName = (String)pair.key;
                sortDirection = sort.get(columnName);
                Object value1 = row1.get((Object)columnName);
                Object value2 = row2.get((Object)columnName);
                if (value1 == null && value2 == null) {
                    result = 0;
                    continue;
                }
                if (value1 == null) {
                    result = -1;
                    continue;
                }
                if (value2 == null) {
                    result = 1;
                    continue;
                }
                if (value1 instanceof Comparable) {
                    result = ((Comparable)value1).compareTo(value2);
                    continue;
                }
                String s1 = value1.toString();
                String s2 = value2.toString();
                result = s1.compareTo(s2);
            }
        } else {
            result = 0;
        }
        return result;
    }
}

