/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Border;
import org.apache.pivot.wtk.BorderListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.CornerRadii;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class BorderSkin
extends ContainerSkin
implements BorderListener {
    private Font font;
    private Color color;
    private Color titleColor;
    private int thickness;
    private Insets padding;
    private CornerRadii cornerRadii;

    public BorderSkin() {
        Theme theme = Theme.getTheme();
        this.setBackgroundColor(Color.WHITE);
        this.font = theme.getFont().deriveFont(1);
        this.color = Color.BLACK;
        this.titleColor = Color.BLACK;
        this.thickness = 1;
        this.padding = Insets.NONE;
        this.cornerRadii = CornerRadii.NONE;
    }

    @Override
    public void install(Component component) {
        super.install(component);
        Border border = (Border)component;
        border.getBorderListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int height) {
        Component content;
        int preferredWidth = 0;
        Border border = (Border)this.getComponent();
        int topThickness = this.thickness;
        String title = border.getTitle();
        if (title != null && title.length() > 0) {
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            Rectangle2D headingBounds = this.font.getStringBounds(title, fontRenderContext);
            preferredWidth = (int)Math.ceil(headingBounds.getWidth());
            LineMetrics lm = this.font.getLineMetrics(title, fontRenderContext);
            topThickness = Math.max((int)Math.ceil(lm.getHeight()), topThickness);
        }
        if ((content = border.getContent()) != null) {
            int heightUpdated = height;
            if (heightUpdated != -1) {
                heightUpdated = Math.max(heightUpdated - (topThickness + this.thickness) - this.padding.top - this.padding.bottom, 0);
            }
            preferredWidth = Math.max(preferredWidth, content.getPreferredWidth(heightUpdated));
        }
        return preferredWidth += this.padding.left + this.padding.right + this.thickness * 2;
    }

    @Override
    public int getPreferredHeight(int width) {
        Component content;
        int preferredHeight = 0;
        Border border = (Border)this.getComponent();
        int topThickness = this.thickness;
        String title = border.getTitle();
        if (title != null && title.length() > 0) {
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            LineMetrics lm = this.font.getLineMetrics(title, fontRenderContext);
            topThickness = Math.max((int)Math.ceil(lm.getHeight()), topThickness);
        }
        if ((content = border.getContent()) != null) {
            int widthUpdated = width;
            if (widthUpdated != -1) {
                widthUpdated = Math.max(widthUpdated - this.thickness * 2 - this.padding.left - this.padding.right, 0);
            }
            preferredHeight = content.getPreferredHeight(widthUpdated);
        }
        return preferredHeight += this.padding.top + this.padding.bottom + (topThickness + this.thickness);
    }

    @Override
    public Dimensions getPreferredSize() {
        Component content;
        int preferredWidth = 0;
        int preferredHeight = 0;
        Border border = (Border)this.getComponent();
        int topThickness = this.thickness;
        String title = border.getTitle();
        if (title != null && title.length() > 0) {
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            Rectangle2D headingBounds = this.font.getStringBounds(title, fontRenderContext);
            preferredWidth = (int)Math.ceil(headingBounds.getWidth());
            LineMetrics lm = this.font.getLineMetrics(title, fontRenderContext);
            topThickness = Math.max((int)Math.ceil(lm.getHeight()), topThickness);
        }
        if ((content = border.getContent()) != null) {
            Dimensions preferredSize = content.getPreferredSize();
            preferredWidth = Math.max(preferredWidth, preferredSize.width);
            preferredHeight += preferredSize.height;
        }
        return new Dimensions(preferredWidth += this.padding.left + this.padding.right + this.thickness * 2, preferredHeight += this.padding.top + this.padding.bottom + (topThickness + this.thickness));
    }

    @Override
    public int getBaseline(int width, int height) {
        int baseline = -1;
        Border border = (Border)this.getComponent();
        int topThickness = this.thickness;
        Component content = border.getContent();
        if (content != null) {
            String title = border.getTitle();
            if (title != null && title.length() > 0) {
                FontRenderContext fontRenderContext = Platform.getFontRenderContext();
                LineMetrics lm = this.font.getLineMetrics(title, fontRenderContext);
                topThickness = Math.max((int)Math.ceil(lm.getHeight()), topThickness);
            }
            int clientWidth = Math.max(width - this.thickness * 2 - (this.padding.left + this.padding.right), 0);
            int clientHeight = Math.max(height - (topThickness + this.thickness) - (this.padding.top + this.padding.bottom), 0);
            baseline = content.getBaseline(clientWidth, clientHeight);
        }
        if (baseline != -1) {
            baseline += this.padding.top + topThickness;
        }
        return baseline;
    }

    @Override
    public void layout() {
        Component content;
        int width = this.getWidth();
        int height = this.getHeight();
        Border border = (Border)this.getComponent();
        int topThickness = this.thickness;
        String title = border.getTitle();
        if (title != null && title.length() > 0) {
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            LineMetrics lm = this.font.getLineMetrics(title, fontRenderContext);
            topThickness = Math.max((int)Math.ceil(lm.getHeight()), topThickness);
        }
        if ((content = border.getContent()) != null) {
            content.setLocation(this.padding.left + this.thickness, this.padding.top + topThickness);
            int contentWidth = Math.max(width - (this.padding.left + this.padding.right + this.thickness * 2), 0);
            int contentHeight = Math.max(height - (this.padding.top + this.padding.bottom + (topThickness + this.thickness)), 0);
            content.setSize(contentWidth, contentHeight);
        }
    }

    @Override
    public void paint(Graphics2D graphics) {
        Border border = (Border)this.getComponent();
        int topThickness = this.thickness;
        float titleAscent = 0.0f;
        String title = border.getTitle();
        if (title != null && title.length() > 0) {
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            LineMetrics lm = this.font.getLineMetrics(title, fontRenderContext);
            titleAscent = lm.getAscent();
            topThickness = Math.max((int)Math.ceil(lm.getHeight()), topThickness);
        }
        int cornerRadius = this.cornerRadii.topLeft;
        int width = this.getWidth();
        int height = this.getHeight();
        int strokeX = this.thickness / 2;
        int strokeY = topThickness / 2;
        int strokeWidth = Math.max(width - this.thickness, 0);
        int strokeHeight = Math.max(height - (int)Math.ceil((double)(topThickness + this.thickness) * 0.5), 0);
        Paint backgroundPaint = this.getBackgroundPaint();
        if (backgroundPaint != null) {
            graphics.setPaint(backgroundPaint);
            if (cornerRadius > 0) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.fillRoundRect(strokeX, strokeY, strokeWidth, strokeHeight, cornerRadius, cornerRadius);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            } else {
                graphics.fillRect(strokeX, strokeY, strokeWidth, strokeHeight);
            }
        }
        if (title != null) {
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, fontRenderContext.getAntiAliasingHint());
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, fontRenderContext.getFractionalMetricsHint());
            Rectangle2D titleBounds = this.font.getStringBounds(title, fontRenderContext);
            titleBounds = new Rectangle2D.Double(this.padding.left + this.thickness, ((double)topThickness - titleBounds.getHeight()) / 2.0, titleBounds.getWidth() + 1.0, titleBounds.getHeight());
            graphics.setFont(this.font);
            graphics.setPaint(this.titleColor);
            graphics.drawString(title, (int)titleBounds.getX(), (int)(titleBounds.getY() + (double)titleAscent));
            Area titleClip = new Area(graphics.getClip());
            titleClip.subtract(new Area(titleBounds));
            graphics.clip(titleClip);
        }
        if (this.thickness > 0) {
            graphics.setPaint(this.color);
            if (cornerRadius > 0) {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setStroke(new BasicStroke(this.thickness));
                graphics.draw(new RoundRectangle2D.Double(0.5 * (double)this.thickness, 0.5 * (double)topThickness, strokeWidth, strokeHeight, cornerRadius, cornerRadius));
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            } else {
                int y = (topThickness - this.thickness) / 2;
                GraphicsUtilities.drawRect(graphics, 0, y, width, Math.max(height - y, 0), this.thickness);
            }
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(BorderSkin.decodeFont(font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor(color));
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color titleColor) {
        if (titleColor == null) {
            throw new IllegalArgumentException("titleColor is null.");
        }
        this.titleColor = titleColor;
        this.repaintComponent();
    }

    public final void setTitleColor(String titleColor) {
        if (titleColor == null) {
            throw new IllegalArgumentException("titleColor is null.");
        }
        this.setTitleColor(GraphicsUtilities.decodeColor(titleColor));
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        if (thickness < 0) {
            throw new IllegalArgumentException("thickness is negative.");
        }
        this.thickness = thickness;
        this.invalidateComponent();
    }

    public void setThickness(Number thickness) {
        if (thickness == null) {
            throw new IllegalArgumentException("thickness is null.");
        }
        this.setThickness(thickness.intValue());
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(padding));
    }

    public CornerRadii getCornerRadii() {
        return this.cornerRadii;
    }

    public void setCornerRadii(CornerRadii cornerRadii) {
        if (cornerRadii == null) {
            throw new IllegalArgumentException("cornerRadii is null.");
        }
        this.cornerRadii = cornerRadii;
        this.repaintComponent();
    }

    public final void setCornerRadii(Dictionary<String, ?> cornerRadii) {
        if (cornerRadii == null) {
            throw new IllegalArgumentException("cornerRadii is null.");
        }
        this.setCornerRadii(new CornerRadii(cornerRadii));
    }

    public final void setCornerRadii(int cornerRadii) {
        this.setCornerRadii(new CornerRadii(cornerRadii));
    }

    public final void setCornerRadii(Number cornerRadii) {
        if (cornerRadii == null) {
            throw new IllegalArgumentException("cornerRadii is null.");
        }
        this.setCornerRadii(cornerRadii.intValue());
    }

    public final void setCornerRadii(String cornerRadii) {
        if (cornerRadii == null) {
            throw new IllegalArgumentException("cornerRadii is null.");
        }
        this.setCornerRadii(CornerRadii.decode(cornerRadii));
    }

    @Override
    public void titleChanged(Border border, String previousTitle) {
        this.invalidateComponent();
    }

    @Override
    public void contentChanged(Border border, Component previousContent) {
        this.invalidateComponent();
    }
}

