/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class DisplaySkin
extends ContainerSkin {
    public DisplaySkin() {
        this.setBackgroundColor(Color.LIGHT_GRAY);
    }

    @Override
    public void install(Component component) {
        if (!(component instanceof Display)) {
            throw new IllegalArgumentException("DisplaySkin can only be installed on instances of Display.");
        }
        super.install(component);
    }

    @Override
    public void layout() {
        Display display = (Display)this.getComponent();
        for (Component component : display) {
            Window window = (Window)component;
            if (!window.isVisible()) continue;
            if (window.isMaximized()) {
                window.setSize(display.getSize());
                continue;
            }
            Dimensions preferredSize = window.getPreferredSize();
            if (window.getWidth() == preferredSize.width && window.getHeight() == preferredSize.height) continue;
            window.setSize(preferredSize.width, preferredSize.height);
        }
    }
}

