/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.FillPane;
import org.apache.pivot.wtk.FillPaneListener;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class FillPaneSkin
extends ContainerSkin
implements FillPaneListener {
    private Insets padding = Insets.NONE;
    private int spacing = 4;

    @Override
    public void install(Component component) {
        super.install(component);
        FillPane fillPane = (FillPane)component;
        fillPane.getFillPaneListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int height) {
        FillPane fillPane = (FillPane)this.getComponent();
        int preferredWidth = 0;
        Orientation orientation = fillPane.getOrientation();
        if (orientation == Orientation.HORIZONTAL) {
            int heightUpdated = height;
            if (heightUpdated != -1) {
                heightUpdated = Math.max(heightUpdated - (this.padding.top + this.padding.bottom), 0);
            }
            int j = 0;
            int n = fillPane.getLength();
            for (int i = 0; i < n; ++i) {
                Component component = fillPane.get(i);
                if (!component.isVisible()) continue;
                preferredWidth += component.getPreferredWidth(heightUpdated);
                ++j;
            }
            if (j > 1) {
                preferredWidth += this.spacing * (j - 1);
            }
        } else {
            int n = fillPane.getLength();
            for (int i = 0; i < n; ++i) {
                Component component = fillPane.get(i);
                if (!component.isVisible()) continue;
                preferredWidth = Math.max(preferredWidth, component.getPreferredWidth());
            }
        }
        return preferredWidth += this.padding.left + this.padding.right;
    }

    @Override
    public int getPreferredHeight(int width) {
        FillPane fillPane = (FillPane)this.getComponent();
        int preferredHeight = 0;
        Orientation orientation = fillPane.getOrientation();
        if (orientation == Orientation.HORIZONTAL) {
            int n = fillPane.getLength();
            for (int i = 0; i < n; ++i) {
                Component component = fillPane.get(i);
                if (!component.isVisible()) continue;
                preferredHeight = Math.max(preferredHeight, component.getPreferredHeight());
            }
        } else {
            int widthUpdated = width;
            if (widthUpdated != -1) {
                widthUpdated = Math.max(widthUpdated - (this.padding.left + this.padding.right), 0);
            }
            int j = 0;
            int n = fillPane.getLength();
            for (int i = 0; i < n; ++i) {
                Component component = fillPane.get(i);
                if (!component.isVisible()) continue;
                preferredHeight += component.getPreferredHeight(widthUpdated);
                ++j;
            }
            if (j > 1) {
                preferredHeight += this.spacing * (j - 1);
            }
        }
        return preferredHeight += this.padding.top + this.padding.bottom;
    }

    @Override
    public Dimensions getPreferredSize() {
        FillPane fillPane = (FillPane)this.getComponent();
        int preferredWidth = 0;
        int preferredHeight = 0;
        switch (fillPane.getOrientation()) {
            case HORIZONTAL: {
                int j = 0;
                int n = fillPane.getLength();
                for (int i = 0; i < n; ++i) {
                    Component component = fillPane.get(i);
                    if (!component.isVisible()) continue;
                    Dimensions preferredSize = component.getPreferredSize();
                    preferredWidth += preferredSize.width;
                    preferredHeight = Math.max(preferredSize.height, preferredHeight);
                    ++j;
                }
                if (j <= true) break;
                preferredWidth += this.spacing * (j - 1);
                break;
            }
            case VERTICAL: {
                int j = 0;
                int n = fillPane.getLength();
                for (int i = 0; i < n; ++i) {
                    Component component = fillPane.get(i);
                    if (!component.isVisible()) continue;
                    Dimensions preferredSize = component.getPreferredSize();
                    preferredWidth = Math.max(preferredSize.width, preferredWidth);
                    preferredHeight += preferredSize.height;
                    ++j;
                }
                if (j <= true) break;
                preferredHeight += this.spacing * (j - 1);
                break;
            }
        }
        return new Dimensions(preferredWidth += this.padding.left + this.padding.right, preferredHeight += this.padding.top + this.padding.bottom);
    }

    @Override
    public int getBaseline(int width, int height) {
        FillPane fillPane = (FillPane)this.getComponent();
        int baseline = -1;
        int contentHeight = 0;
        switch (fillPane.getOrientation()) {
            case HORIZONTAL: {
                int clientHeight = Math.max(height - (this.padding.top + this.padding.bottom), 0);
                for (Component component : fillPane) {
                    if (!component.isVisible()) continue;
                    int componentWidth = component.getPreferredWidth(clientHeight);
                    baseline = Math.max(baseline, component.getBaseline(componentWidth, clientHeight));
                }
                break;
            }
            case VERTICAL: {
                int clientWidth = Math.max(width - (this.padding.left + this.padding.right), 0);
                for (Component component : fillPane) {
                    if (!component.isVisible()) continue;
                    Dimensions size = new Dimensions(clientWidth, component.getPreferredHeight(clientWidth));
                    if (baseline == -1 && (baseline = component.getBaseline(size.width, size.height)) != -1) {
                        baseline += contentHeight;
                    }
                    contentHeight += size.height + this.spacing;
                }
                break;
            }
        }
        if (baseline != -1) {
            baseline += this.padding.top;
        }
        return baseline;
    }

    @Override
    public void layout() {
        Orientation orientation;
        FillPane fillPane = (FillPane)this.getComponent();
        int n = 0;
        int len = fillPane.getLength();
        for (int i = 0; i < len; ++i) {
            Component component = fillPane.get(i);
            if (!component.isVisible()) continue;
            ++n;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0) {
            width = this.getPreferredWidth(-1);
        }
        if (height <= 0) {
            height = this.getPreferredHeight(-1);
        }
        if ((orientation = fillPane.getOrientation()) == Orientation.HORIZONTAL) {
            int x = this.padding.left;
            int totalWidth = width - (this.padding.left + this.padding.right);
            if (n > 1) {
                totalWidth -= this.spacing * (n - 1);
            }
            int dividedWidth = n == 0 ? 0 : totalWidth / n;
            int leftoverWidth = totalWidth - dividedWidth * n;
            int j = 0;
            for (int i = 0; i < len; ++i) {
                Component component = fillPane.get(i);
                if (!component.isVisible()) continue;
                int componentWidth = dividedWidth;
                if (j == n - 1) {
                    componentWidth += leftoverWidth;
                }
                int componentHeight = Math.max(height - (this.padding.top + this.padding.bottom), 0);
                int y = this.padding.top;
                component.setSize(componentWidth, componentHeight);
                component.setLocation(x, y);
                x += componentWidth + this.spacing;
                ++j;
            }
        } else {
            int y = this.padding.top;
            int totalHeight = height - (this.padding.top + this.padding.bottom);
            if (n > 1) {
                totalHeight -= this.spacing * (n - 1);
            }
            int dividedHeight = n == 0 ? 0 : totalHeight / n;
            int leftoverHeight = totalHeight - dividedHeight * n;
            int j = 0;
            for (int i = 0; i < len; ++i) {
                Component component = fillPane.get(i);
                if (!component.isVisible()) continue;
                int componentHeight = dividedHeight;
                if (j == n - 1) {
                    componentHeight += leftoverHeight;
                }
                int componentWidth = Math.max(width - (this.padding.left + this.padding.right), 0);
                int x = this.padding.left;
                component.setSize(componentWidth, componentHeight);
                component.setLocation(x, y);
                y += componentHeight + this.spacing;
                ++j;
            }
        }
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(padding));
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        if (spacing < 0) {
            throw new IllegalArgumentException("spacing is negative.");
        }
        this.spacing = spacing;
        this.invalidateComponent();
    }

    public final void setSpacing(Number spacing) {
        if (spacing == null) {
            throw new IllegalArgumentException("spacing is null.");
        }
        this.setSpacing(spacing.intValue());
    }

    @Override
    public void orientationChanged(FillPane fillPane) {
        this.invalidateComponent();
    }
}

