/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.TablePaneAttributeListener;
import org.apache.pivot.wtk.TablePaneListener;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class TablePaneSkin
extends ContainerSkin
implements TablePane.Skin,
TablePaneListener,
TablePaneAttributeListener {
    private Insets padding = Insets.NONE;
    private int horizontalSpacing = 0;
    private int verticalSpacing = 0;
    private boolean showHorizontalGridLines = false;
    private boolean showVerticalGridLines = false;
    private Color horizontalGridColor = Color.BLACK;
    private Color verticalGridColor = Color.BLACK;
    private Color highlightBackgroundColor = Color.GRAY;
    private int[] columnWidths = null;
    private int[] rowHeights = null;

    @Override
    public void install(Component component) {
        super.install(component);
        TablePane tablePane = (TablePane)component;
        tablePane.getTablePaneListeners().add((Object)this);
        tablePane.getTablePaneAttributeListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int height) {
        int columnWidth;
        int i;
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rows = tablePane.getRows();
        TablePane.ColumnSequence columns = tablePane.getColumns();
        int rowCount = rows.getLength();
        int columnCount = columns.getLength();
        int[] columnWidthsLocal = new int[columnCount];
        int[] relativeWeights = new int[columnCount];
        boolean[] defaultWidthColumns = new boolean[columnCount];
        int totalRelativeWeight = 0;
        for (i = 0; i < columnCount; ++i) {
            TablePane.Column column = columns.get(i);
            columnWidth = column.getWidth();
            boolean isRelative = column.isRelative();
            boolean bl = defaultWidthColumns[i] = columnWidth < 0;
            if (isRelative) {
                relativeWeights[i] = columnWidth;
                totalRelativeWeight += columnWidth;
            }
            if (columnWidth < 0 || isRelative) {
                columnWidth = this.getPreferredColumnWidth(i);
            }
            columnWidthsLocal[i] = columnWidth;
        }
        if (totalRelativeWeight > 0) {
            int i2;
            int totalRelativeWidth = 0;
            for (i2 = 0; i2 < columnCount; ++i2) {
                columnWidth = columnWidthsLocal[i2];
                int relativeWeight = relativeWeights[i2];
                if (relativeWeight <= 0) continue;
                float weightPercentage = (float)relativeWeight / (float)totalRelativeWeight;
                totalRelativeWidth = Math.max(totalRelativeWidth, (int)((float)columnWidth / weightPercentage));
            }
            for (i2 = 0; i2 < columnCount; ++i2) {
                int relativeWeight = relativeWeights[i2];
                if (relativeWeight <= 0) continue;
                float weightPercentage = (float)relativeWeight / (float)totalRelativeWeight;
                columnWidthsLocal[i2] = (int)(weightPercentage * (float)totalRelativeWidth);
            }
        }
        for (i = 0; i < rowCount; ++i) {
            TablePane.Row row = rows.get(i);
            int n = row.getLength();
            for (int j = 0; j < n && j < columnCount; ++j) {
                int rowHeight;
                int componentPreferredWidth;
                int columnSpan;
                Component component = row.get(j);
                if (component == null || !component.isVisible() || (columnSpan = TablePane.getColumnSpan(component)) <= 1) continue;
                int spannedDefaultWidthCellCount = 0;
                int spannedRelativeWeight = 0;
                int spannedWidth = 0;
                for (int k = 0; k < columnSpan && j + k < columnCount; ++k) {
                    if (defaultWidthColumns[j + k]) {
                        ++spannedDefaultWidthCellCount;
                    }
                    spannedRelativeWeight += relativeWeights[j + k];
                    spannedWidth += columnWidthsLocal[j + k];
                }
                if (spannedRelativeWeight <= 0 && spannedDefaultWidthCellCount <= 0 || (componentPreferredWidth = component.getPreferredWidth(rowHeight = row.isRelative() ? -1 : row.getHeight())) <= spannedWidth) continue;
                int adjustment = componentPreferredWidth - spannedWidth;
                if (spannedRelativeWeight > 0) {
                    float unitAdjustment = (float)adjustment / (float)spannedRelativeWeight;
                    for (int k = 0; k < columnCount; ++k) {
                        int relativeWeight = relativeWeights[k];
                        if (relativeWeight <= 0) continue;
                        int columnAdjustment = Math.round(unitAdjustment * (float)relativeWeight);
                        int n2 = k;
                        columnWidthsLocal[n2] = columnWidthsLocal[n2] + columnAdjustment;
                    }
                    continue;
                }
                for (int k = 0; k < columnSpan && j + k < columnCount; ++k) {
                    if (!defaultWidthColumns[j + k]) continue;
                    int columnAdjustment = adjustment / spannedDefaultWidthCellCount;
                    int n3 = j + k;
                    columnWidthsLocal[n3] = columnWidthsLocal[n3] + columnAdjustment;
                    adjustment -= columnAdjustment;
                    --spannedDefaultWidthCellCount;
                }
            }
        }
        boolean[][] occupiedCells = this.getOccupiedCells();
        int visibleColumnCount = 0;
        int preferredWidth = this.padding.left + this.padding.right;
        for (int j = 0; j < columnCount; ++j) {
            boolean columnVisible = false;
            for (int i3 = 0; i3 < rowCount; ++i3) {
                if (!occupiedCells[i3][j]) continue;
                columnVisible = true;
                break;
            }
            if (!columnVisible) continue;
            preferredWidth += columnWidthsLocal[j];
            ++visibleColumnCount;
        }
        if (visibleColumnCount > 1) {
            preferredWidth += (visibleColumnCount - 1) * this.horizontalSpacing;
        }
        return preferredWidth;
    }

    @Override
    public int getPreferredHeight(int width) {
        int rowHeight;
        int i;
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rows = tablePane.getRows();
        TablePane.ColumnSequence columns = tablePane.getColumns();
        int rowCount = rows.getLength();
        int columnCount = columns.getLength();
        int[] rowHeightsLocal = new int[rowCount];
        int[] relativeWeights = new int[rowCount];
        boolean[] defaultHeightRows = new boolean[rowCount];
        int totalRelativeWeight = 0;
        int widthUpdated = width;
        if (widthUpdated < 0) {
            widthUpdated = this.getPreferredWidth(-1);
        }
        int[] columnWidthsLocal = this.getColumnWidths(widthUpdated);
        for (i = 0; i < rowCount; ++i) {
            TablePane.Row row = rows.get(i);
            rowHeight = row.getHeight();
            boolean isRelative = row.isRelative();
            boolean bl = defaultHeightRows[i] = rowHeight < 0;
            if (isRelative) {
                relativeWeights[i] = rowHeight;
                totalRelativeWeight += rowHeight;
            }
            if (rowHeight < 0 || isRelative) {
                rowHeight = this.getPreferredRowHeight(i, columnWidthsLocal);
            }
            rowHeightsLocal[i] = rowHeight;
        }
        if (totalRelativeWeight > 0) {
            int i2;
            int totalRelativeHeight = 0;
            for (i2 = 0; i2 < rowCount; ++i2) {
                rowHeight = rowHeightsLocal[i2];
                int relativeWeight = relativeWeights[i2];
                if (relativeWeight <= 0) continue;
                float weightPercentage = (float)relativeWeight / (float)totalRelativeWeight;
                totalRelativeHeight = Math.max(totalRelativeHeight, (int)((float)rowHeight / weightPercentage));
            }
            for (i2 = 0; i2 < rowCount; ++i2) {
                int relativeWeight = relativeWeights[i2];
                if (relativeWeight <= 0) continue;
                float weightPercentage = (float)relativeWeight / (float)totalRelativeWeight;
                rowHeightsLocal[i2] = (int)(weightPercentage * (float)totalRelativeHeight);
            }
        }
        for (i = 0; i < rowCount; ++i) {
            TablePane.Row row = rows.get(i);
            int n = row.getLength();
            for (int j = 0; j < n && j < columnCount; ++j) {
                int componentPreferredHeight;
                int rowSpan;
                Component component = row.get(j);
                if (component == null || !component.isVisible() || (rowSpan = TablePane.getRowSpan(component)) <= 1) continue;
                int spannedDefaultHeightCellCount = 0;
                int spannedRelativeWeight = 0;
                int spannedHeight = 0;
                for (int k = 0; k < rowSpan && i + k < rowCount; ++k) {
                    if (defaultHeightRows[i + k]) {
                        ++spannedDefaultHeightCellCount;
                    }
                    spannedRelativeWeight += relativeWeights[i + k];
                    spannedHeight += rowHeightsLocal[i + k];
                }
                if (spannedRelativeWeight <= 0 && spannedDefaultHeightCellCount <= 0 || (componentPreferredHeight = component.getPreferredHeight(columnWidthsLocal[j])) <= spannedHeight) continue;
                int adjustment = componentPreferredHeight - spannedHeight;
                if (spannedRelativeWeight > 0) {
                    float unitAdjustment = (float)adjustment / (float)spannedRelativeWeight;
                    for (int k = 0; k < rowCount; ++k) {
                        int relativeWeight = relativeWeights[k];
                        if (relativeWeight <= 0) continue;
                        int rowAdjustment = Math.round(unitAdjustment * (float)relativeWeight);
                        int n2 = k;
                        rowHeightsLocal[n2] = rowHeightsLocal[n2] + rowAdjustment;
                    }
                    continue;
                }
                for (int k = 0; k < rowSpan && i + k < rowCount; ++k) {
                    if (!defaultHeightRows[i + k]) continue;
                    int rowAdjustment = adjustment / spannedDefaultHeightCellCount;
                    int n3 = i + k;
                    rowHeightsLocal[n3] = rowHeightsLocal[n3] + rowAdjustment;
                    adjustment -= rowAdjustment;
                    --spannedDefaultHeightCellCount;
                }
            }
        }
        boolean[][] occupiedCells = this.getOccupiedCells();
        int visibleRowCount = 0;
        int preferredHeight = this.padding.top + this.padding.bottom;
        for (int i3 = 0; i3 < rowCount; ++i3) {
            boolean rowVisible = false;
            for (int j = 0; j < columnCount; ++j) {
                if (!occupiedCells[i3][j]) continue;
                rowVisible = true;
                break;
            }
            if (!rowVisible) continue;
            preferredHeight += rowHeightsLocal[i3];
            ++visibleRowCount;
        }
        if (visibleRowCount > 1) {
            preferredHeight += (visibleRowCount - 1) * this.verticalSpacing;
        }
        return preferredHeight;
    }

    @Override
    public Dimensions getPreferredSize() {
        int preferredWidth = this.getPreferredWidth(-1);
        int preferredHeight = this.getPreferredHeight(preferredWidth);
        return new Dimensions(preferredWidth, preferredHeight);
    }

    @Override
    public int getBaseline(int width, int height) {
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rows = tablePane.getRows();
        TablePane.ColumnSequence columns = tablePane.getColumns();
        int rowCount = rows.getLength();
        int columnCount = columns.getLength();
        int[] columnWidthsLocal = this.getColumnWidths(width);
        int[] rowHeightsLocal = this.getRowHeights(height, columnWidthsLocal);
        boolean[][] occupiedCells = this.getOccupiedCells();
        int baseline = -1;
        int rowY = this.padding.top;
        for (int i = 0; i < rowCount && baseline == -1; ++i) {
            TablePane.Row row = rows.get(i);
            boolean rowVisible = false;
            int n = row.getLength();
            for (int j = 0; j < n && j < columnCount && baseline == -1; ++j) {
                Component component = row.get(j);
                if (component != null && component.isVisible()) {
                    int columnSpan = Math.min(TablePane.getColumnSpan(component), columnCount - j);
                    int componentWidth = (columnSpan - 1) * this.horizontalSpacing;
                    for (int k = 0; k < columnSpan && j + k < columnCount; ++k) {
                        componentWidth += columnWidthsLocal[j + k];
                    }
                    int rowSpan = Math.min(TablePane.getRowSpan(component), rowCount - i);
                    int componentHeight = (rowSpan - 1) * this.verticalSpacing;
                    for (int k = 0; k < rowSpan && i + k < rowCount; ++k) {
                        componentHeight += rowHeightsLocal[i + k];
                    }
                    baseline = component.getBaseline(Math.max(componentWidth, 0), Math.max(componentHeight, 0));
                    if (baseline != -1) {
                        baseline += rowY;
                    }
                }
                rowVisible |= occupiedCells[i][j];
            }
            if (!rowVisible) continue;
            rowY += rowHeightsLocal[i] + this.verticalSpacing;
        }
        return baseline;
    }

    @Override
    public void layout() {
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rows = tablePane.getRows();
        TablePane.ColumnSequence columns = tablePane.getColumns();
        int rowCount = rows.getLength();
        int columnCount = columns.getLength();
        int width = this.getWidth();
        int height = this.getHeight();
        this.columnWidths = this.getColumnWidths(width);
        this.rowHeights = this.getRowHeights(height, this.columnWidths);
        boolean[] visibleRows = new boolean[rowCount];
        boolean[] visibleColumns = new boolean[columnCount];
        boolean[][] occupiedCells = this.getOccupiedCells();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                if (!occupiedCells[i][j]) continue;
                visibleRows[i] = true;
                visibleColumns[j] = true;
            }
        }
        int componentY = this.padding.top;
        for (int i = 0; i < rowCount; ++i) {
            TablePane.Row row = rows.get(i);
            int componentX = this.padding.left;
            int n = row.getLength();
            for (int j = 0; j < n && j < columnCount; ++j) {
                Component child = row.get(j);
                if (child != null && child.isVisible()) {
                    child.setLocation(componentX, componentY);
                    int columnSpan = TablePane.getColumnSpan(child);
                    columnSpan = Math.min(columnSpan, columnCount - j);
                    int childWidth = (columnSpan - 1) * this.horizontalSpacing;
                    for (int k = 0; k < columnSpan && j + k < columnCount; ++k) {
                        childWidth += this.columnWidths[j + k];
                    }
                    int rowSpan = TablePane.getRowSpan(child);
                    rowSpan = Math.min(rowSpan, rowCount - i);
                    int childHeight = (rowSpan - 1) * this.verticalSpacing;
                    for (int k = 0; k < rowSpan && i + k < rowCount; ++k) {
                        childHeight += this.rowHeights[i + k];
                    }
                    child.setSize(Math.max(childWidth, 0), Math.max(childHeight, 0));
                }
                if (!visibleColumns[j]) continue;
                componentX += this.columnWidths[j] + this.horizontalSpacing;
            }
            if (!visibleRows[i]) continue;
            componentY += this.rowHeights[i] + this.verticalSpacing;
        }
    }

    @Override
    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rows = tablePane.getRows();
        TablePane.ColumnSequence columns = tablePane.getColumns();
        int rowCount = rows.getLength();
        int columnCount = columns.getLength();
        int width = this.getWidth();
        int height = this.getHeight();
        graphics.setPaint(this.highlightBackgroundColor);
        int rowY = this.padding.top;
        for (int i = 0; i < rowCount; ++i) {
            TablePane.Row row = rows.get(i);
            if (row.isHighlighted()) {
                graphics.fillRect(0, rowY, width, this.rowHeights[i]);
            }
            rowY += this.rowHeights[i] + this.verticalSpacing;
        }
        int columnX = this.padding.left;
        for (int j = 0; j < columnCount; ++j) {
            TablePane.Column column = columns.get(j);
            if (column.isHighlighted()) {
                graphics.fillRect(columnX, 0, this.columnWidths[j], height);
            }
            columnX += this.columnWidths[j] + this.horizontalSpacing;
        }
        if (this.showHorizontalGridLines && this.verticalSpacing > 0 || this.showVerticalGridLines && this.horizontalSpacing > 0) {
            Graphics2D gridGraphics = (Graphics2D)graphics.create();
            gridGraphics.setStroke(new BasicStroke());
            gridGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Area gridClip = null;
            int componentY = this.padding.top;
            for (int i = 0; i < rowCount; ++i) {
                int componentX = this.padding.left;
                for (int j = 0; j < columnCount; ++j) {
                    Component component = tablePane.getCellComponent(i, j);
                    if (component != null) {
                        int rowSpan = TablePane.getRowSpan(component);
                        int columnSpan = TablePane.getColumnSpan(component);
                        if (rowSpan > 1 || columnSpan > 1) {
                            int k;
                            int rowY2 = componentY;
                            int columnX2 = componentX;
                            int rowHeight = this.rowHeights[i];
                            int columnWidth = this.columnWidths[j];
                            for (k = i + 1; k < i + rowSpan && k < rowCount; ++k) {
                                rowHeight += this.rowHeights[k] + this.verticalSpacing;
                            }
                            for (k = j + 1; k < j + columnSpan && k < columnCount; ++k) {
                                columnWidth += this.columnWidths[k] + this.horizontalSpacing;
                            }
                            if (gridClip == null) {
                                gridClip = new Area(graphics.getClip());
                            }
                            if (this.horizontalSpacing > 1) {
                                columnWidth += this.horizontalSpacing - 1;
                                columnX2 -= (int)((float)this.horizontalSpacing * 0.5f - 0.5f);
                            }
                            if (this.verticalSpacing > 1) {
                                rowHeight += this.verticalSpacing - 1;
                                rowY2 -= (int)((float)this.verticalSpacing * 0.5f - 0.5f);
                            }
                            Rectangle2D.Float bounds = new Rectangle2D.Float(columnX2, rowY2, columnWidth, rowHeight);
                            gridClip.subtract(new Area(bounds));
                        }
                    }
                    componentX += this.columnWidths[j] + this.horizontalSpacing;
                }
                componentY += this.rowHeights[i] + this.verticalSpacing;
            }
            if (gridClip != null) {
                gridGraphics.clip(gridClip);
            }
            boolean[][] occupiedCells = this.getOccupiedCells();
            if (this.showHorizontalGridLines && this.verticalSpacing > 0 && rowCount > 1) {
                gridGraphics.setPaint(this.horizontalGridColor);
                int rowY3 = this.padding.top;
                int visibleRowCount = 0;
                for (int i = 0; i < rowCount; ++i) {
                    boolean rowVisible = false;
                    for (int j = 0; j < columnCount; ++j) {
                        if (!occupiedCells[i][j]) continue;
                        rowVisible = true;
                        break;
                    }
                    if (!rowVisible) continue;
                    if (visibleRowCount++ > 0) {
                        int gridY = Math.max(rowY3 - (int)Math.ceil((float)this.verticalSpacing * 0.5f), 0);
                        GraphicsUtilities.drawLine(gridGraphics, 0, gridY, width, Orientation.HORIZONTAL);
                    }
                    rowY3 += this.rowHeights[i] + this.verticalSpacing;
                }
            }
            if (this.showVerticalGridLines && this.horizontalSpacing > 0 && columnCount > 1) {
                gridGraphics.setPaint(this.verticalGridColor);
                int columnX3 = this.padding.left;
                int visibleColumnCount = 0;
                for (int j = 0; j < columnCount; ++j) {
                    boolean columnVisible = false;
                    for (int i = 0; i < rowCount; ++i) {
                        if (!occupiedCells[i][j]) continue;
                        columnVisible = true;
                        break;
                    }
                    if (!columnVisible) continue;
                    if (visibleColumnCount++ > 0) {
                        int gridX = Math.max(columnX3 - (int)Math.ceil((double)this.horizontalSpacing * 0.5), 0);
                        GraphicsUtilities.drawLine(gridGraphics, gridX, 0, height, Orientation.VERTICAL);
                    }
                    columnX3 += this.columnWidths[j] + this.horizontalSpacing;
                }
            }
            gridGraphics.dispose();
        }
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode(padding));
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        if (horizontalSpacing < 0) {
            throw new IllegalArgumentException("horizontalSpacing is negative");
        }
        this.horizontalSpacing = horizontalSpacing;
        this.invalidateComponent();
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(int verticalSpacing) {
        if (verticalSpacing < 0) {
            throw new IllegalArgumentException("verticalSpacing is negative");
        }
        this.verticalSpacing = verticalSpacing;
        this.invalidateComponent();
    }

    public boolean getShowHorizontalGridLines() {
        return this.showHorizontalGridLines;
    }

    public void setShowHorizontalGridLines(boolean showHorizontalGridLines) {
        this.showHorizontalGridLines = showHorizontalGridLines;
        this.repaintComponent();
    }

    public boolean getShowVerticalGridLines() {
        return this.showVerticalGridLines;
    }

    public void setShowVerticalGridLines(boolean showVerticalGridLines) {
        this.showVerticalGridLines = showVerticalGridLines;
        this.repaintComponent();
    }

    public Color getHorizontalGridColor() {
        return this.horizontalGridColor;
    }

    public void setHorizontalGridColor(Color horizontalGridColor) {
        if (horizontalGridColor == null) {
            throw new IllegalArgumentException("horizontalGridColor is null.");
        }
        this.horizontalGridColor = horizontalGridColor;
        if (this.showHorizontalGridLines || this.showVerticalGridLines) {
            this.repaintComponent();
        }
    }

    public final void setHorizontalGridColor(String horizontalGridColor) {
        if (horizontalGridColor == null) {
            throw new IllegalArgumentException("horizontalGridColor is null.");
        }
        this.setHorizontalGridColor(GraphicsUtilities.decodeColor(horizontalGridColor));
    }

    public Color getVerticalGridColor() {
        return this.verticalGridColor;
    }

    public void setVerticalGridColor(Color verticalGridColor) {
        if (verticalGridColor == null) {
            throw new IllegalArgumentException("verticalGridColor is null.");
        }
        this.verticalGridColor = verticalGridColor;
        if (this.showHorizontalGridLines || this.showVerticalGridLines) {
            this.repaintComponent();
        }
    }

    public final void setVerticalGridColor(String verticalGridColor) {
        if (verticalGridColor == null) {
            throw new IllegalArgumentException("verticalGridColor is null.");
        }
        this.setVerticalGridColor(GraphicsUtilities.decodeColor(verticalGridColor));
    }

    public Color getHighlightBackgroundColor() {
        return this.highlightBackgroundColor;
    }

    public void setHighlightBackgroundColor(Color highlightBackgroundColor) {
        if (highlightBackgroundColor == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.highlightBackgroundColor = highlightBackgroundColor;
        this.repaintComponent();
    }

    public final void setHighlightBackgroundColor(String highlightBackgroundColor) {
        if (highlightBackgroundColor == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.setHighlightBackgroundColor(GraphicsUtilities.decodeColor(highlightBackgroundColor));
    }

    private boolean[][] getOccupiedCells() {
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rows = tablePane.getRows();
        TablePane.ColumnSequence columns = tablePane.getColumns();
        int rowCount = rows.getLength();
        int columnCount = columns.getLength();
        boolean[][] occupiedCells = new boolean[rowCount][columnCount];
        for (int i = 0; i < rowCount; ++i) {
            TablePane.Row row = rows.get(i);
            int n = row.getLength();
            for (int j = 0; j < n && j < columnCount; ++j) {
                Component component = row.get(j);
                if (component == null || !component.isVisible()) continue;
                int rowSpan = TablePane.getRowSpan(component);
                int columnSpan = TablePane.getColumnSpan(component);
                for (int k = 0; k < rowSpan && i + k < rowCount; ++k) {
                    for (int l = 0; l < columnSpan && j + l < columnCount; ++l) {
                        occupiedCells[i + k][j + l] = true;
                    }
                }
            }
        }
        return occupiedCells;
    }

    private int getPreferredColumnWidth(int columnIndex) {
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rows = tablePane.getRows();
        int preferredWidth = 0;
        int n = rows.getLength();
        for (int i = 0; i < n; ++i) {
            Component component;
            TablePane.Row row = rows.get(i);
            if (row.getLength() <= columnIndex || (component = row.get(columnIndex)) == null || !component.isVisible() || TablePane.getColumnSpan(component) != 1) continue;
            preferredWidth = Math.max(preferredWidth, component.getPreferredWidth(-1));
        }
        return preferredWidth;
    }

    private boolean isColumnVisible(int columnIndex) {
        boolean visible = false;
        boolean[][] occupiedCells = this.getOccupiedCells();
        for (int i = 0; i < occupiedCells.length; ++i) {
            if (!occupiedCells[i][columnIndex]) continue;
            visible = true;
            break;
        }
        return visible;
    }

    private int getPreferredRowHeight(int rowIndex, int[] columnWidthsArgument) {
        if (columnWidthsArgument == null) {
            throw new IllegalArgumentException("columnWidths is null");
        }
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.ColumnSequence columns = tablePane.getColumns();
        TablePane.Row row = tablePane.getRows().get(rowIndex);
        int preferredHeight = 0;
        int n = row.getLength();
        int m = columns.getLength();
        for (int j = 0; j < n && j < m; ++j) {
            Component component = row.get(j);
            if (component == null || !component.isVisible() || TablePane.getRowSpan(component) != 1) continue;
            preferredHeight = Math.max(preferredHeight, component.getPreferredHeight(columnWidthsArgument[j]));
        }
        return preferredHeight;
    }

    private boolean isRowVisible(int rowIndex) {
        boolean visible = false;
        boolean[][] occupiedCells = this.getOccupiedCells();
        for (int j = 0; j < occupiedCells[rowIndex].length; ++j) {
            if (!occupiedCells[rowIndex][j]) continue;
            visible = true;
            break;
        }
        return visible;
    }

    private int[] getColumnWidths(int width) {
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rows = tablePane.getRows();
        TablePane.ColumnSequence columns = tablePane.getColumns();
        int rowCount = rows.getLength();
        int columnCount = columns.getLength();
        int[] columnWidthsLocal = new int[columnCount];
        boolean[] defaultWidthColumns = new boolean[columnCount];
        int totalRelativeWeight = 0;
        int visibleColumnCount = 0;
        int reservedWidth = this.padding.left + this.padding.right;
        for (int j = 0; j < columnCount; ++j) {
            if (this.isColumnVisible(j)) {
                TablePane.Column column = columns.get(j);
                int columnWidth = column.getWidth();
                if (column.isRelative()) {
                    columnWidthsLocal[j] = -columnWidth;
                    totalRelativeWeight += columnWidth;
                } else {
                    if (columnWidth < 0) {
                        columnWidth = this.getPreferredColumnWidth(j);
                        defaultWidthColumns[j] = true;
                    }
                    columnWidthsLocal[j] = columnWidth;
                    reservedWidth += columnWidth;
                }
                ++visibleColumnCount;
                continue;
            }
            columnWidthsLocal[j] = 0;
        }
        if (visibleColumnCount > 1) {
            reservedWidth += (visibleColumnCount - 1) * this.horizontalSpacing;
        }
        for (int i = 0; i < rowCount; ++i) {
            TablePane.Row row = rows.get(i);
            int n = row.getLength();
            for (int j = 0; j < n && j < columnCount; ++j) {
                int componentPreferredWidth;
                int columnSpan;
                Component component = row.get(j);
                if (component == null || !component.isVisible() || (columnSpan = TablePane.getColumnSpan(component)) <= 1) continue;
                boolean adjustCells = true;
                int spannedDefaultWidthCellCount = 0;
                int spannedWidth = 0;
                for (int k = 0; k < columnSpan && j + k < columnCount; ++k) {
                    if (columnWidthsLocal[j + k] < 0) {
                        adjustCells = false;
                        break;
                    }
                    if (defaultWidthColumns[j + k]) {
                        ++spannedDefaultWidthCellCount;
                    }
                    spannedWidth += columnWidthsLocal[j + k];
                }
                if (!adjustCells || spannedDefaultWidthCellCount <= 0 || (componentPreferredWidth = component.getPreferredWidth(-1)) <= spannedWidth) continue;
                int adjustment = componentPreferredWidth - spannedWidth;
                for (int k = 0; k < columnSpan && j + k < columnCount; ++k) {
                    if (!defaultWidthColumns[j + k]) continue;
                    int columnAdjustment = adjustment / spannedDefaultWidthCellCount;
                    int n2 = j + k;
                    columnWidthsLocal[n2] = columnWidthsLocal[n2] + columnAdjustment;
                    reservedWidth += columnAdjustment;
                    adjustment -= columnAdjustment;
                    --spannedDefaultWidthCellCount;
                }
            }
        }
        int remainingWidth = Math.max(width - reservedWidth, 0);
        if (totalRelativeWeight > 0 && remainingWidth > 0) {
            for (int j = 0; j < columnCount; ++j) {
                int columnWidth;
                if (columnWidthsLocal[j] >= 0) continue;
                int relativeWeight = -columnWidthsLocal[j];
                float weightPercentage = (float)relativeWeight / (float)totalRelativeWeight;
                columnWidthsLocal[j] = columnWidth = (int)((float)remainingWidth * weightPercentage);
                remainingWidth -= columnWidth;
                totalRelativeWeight -= relativeWeight;
            }
        }
        return columnWidthsLocal;
    }

    private int[] getRowHeights(int height, int[] columnWidthsArgument) {
        TablePane.Row row;
        int i;
        if (columnWidthsArgument == null) {
            throw new IllegalArgumentException("columnWidths is null");
        }
        TablePane tablePane = (TablePane)this.getComponent();
        TablePane.RowSequence rows = tablePane.getRows();
        int rowCount = tablePane.getRows().getLength();
        int columnCount = tablePane.getColumns().getLength();
        int[] rowHeightsLocal = new int[rowCount];
        boolean[] defaultHeightRows = new boolean[rowCount];
        int totalRelativeWeight = 0;
        int visibleRowCount = 0;
        int reservedHeight = this.padding.top + this.padding.bottom;
        for (i = 0; i < rowCount; ++i) {
            if (this.isRowVisible(i)) {
                row = rows.get(i);
                int rowHeight = row.getHeight();
                if (row.isRelative()) {
                    rowHeightsLocal[i] = -rowHeight;
                    totalRelativeWeight += rowHeight;
                } else {
                    if (rowHeight < 0) {
                        rowHeight = this.getPreferredRowHeight(i, columnWidthsArgument);
                        defaultHeightRows[i] = true;
                    }
                    rowHeightsLocal[i] = rowHeight;
                    reservedHeight += rowHeight;
                }
                ++visibleRowCount;
                continue;
            }
            rowHeightsLocal[i] = 0;
        }
        if (visibleRowCount > 1) {
            reservedHeight += (visibleRowCount - 1) * this.verticalSpacing;
        }
        for (i = 0; i < rowCount; ++i) {
            row = rows.get(i);
            int n = row.getLength();
            for (int j = 0; j < n && j < columnCount; ++j) {
                int componentPreferredHeight;
                int rowSpan;
                Component component = row.get(j);
                if (component == null || !component.isVisible() || (rowSpan = TablePane.getRowSpan(component)) <= 1) continue;
                boolean adjustCells = true;
                int spannedDefaultHeightCellCount = 0;
                int spannedHeight = 0;
                for (int k = 0; k < rowSpan && i + k < rowCount; ++k) {
                    if (rowHeightsLocal[i + k] < 0) {
                        adjustCells = false;
                        break;
                    }
                    if (defaultHeightRows[i + k]) {
                        ++spannedDefaultHeightCellCount;
                    }
                    spannedHeight += rowHeightsLocal[i + k];
                }
                if (!adjustCells || spannedDefaultHeightCellCount <= 0 || (componentPreferredHeight = component.getPreferredHeight(columnWidthsArgument[j])) <= spannedHeight) continue;
                int adjustment = componentPreferredHeight - spannedHeight;
                for (int k = 0; k < rowSpan && i + k < rowCount; ++k) {
                    if (!defaultHeightRows[i + k]) continue;
                    int rowAdjustment = adjustment / spannedDefaultHeightCellCount;
                    int n2 = i + k;
                    rowHeightsLocal[n2] = rowHeightsLocal[n2] + rowAdjustment;
                    reservedHeight += rowAdjustment;
                    adjustment -= rowAdjustment;
                    --spannedDefaultHeightCellCount;
                }
            }
        }
        int remainingHeight = height - reservedHeight;
        if (totalRelativeWeight > 0 && remainingHeight > 0) {
            for (int i2 = 0; i2 < rowCount; ++i2) {
                int rowHeight;
                if (rowHeightsLocal[i2] >= 0) continue;
                int relativeWeight = -rowHeightsLocal[i2];
                float weightPercentage = (float)relativeWeight / (float)totalRelativeWeight;
                rowHeightsLocal[i2] = rowHeight = (int)((float)remainingHeight * weightPercentage);
                remainingHeight -= rowHeight;
                totalRelativeWeight -= relativeWeight;
            }
        }
        boolean progress = true;
        block6: while (remainingHeight < 0 && progress) {
            progress = false;
            for (int i3 = 0; i3 < rowCount; ++i3) {
                TablePane.Row row2;
                if (!this.isRowVisible(i3) || (row2 = rows.get(i3)).isRelative() || rowHeightsLocal[i3] <= 0) continue;
                int n = i3;
                rowHeightsLocal[n] = rowHeightsLocal[n] - 1;
                progress = true;
                if (++remainingHeight >= 0) continue block6;
            }
        }
        return rowHeightsLocal;
    }

    @Override
    public int getRowAt(int y) {
        int rowHeight;
        if (this.rowHeights == null) {
            return -1;
        }
        int rowIndex = -1;
        int i = 0;
        for (int rowY = this.padding.top; rowY <= y && i < this.rowHeights.length; rowY += rowHeight + this.verticalSpacing, ++i) {
            rowHeight = this.rowHeights[i];
            if (y >= rowY + rowHeight) continue;
            rowIndex = i;
            break;
        }
        return rowIndex;
    }

    @Override
    public Bounds getRowBounds(int row) {
        if (this.rowHeights == null) {
            return new Bounds(0, 0, 0, 0);
        }
        if (row < 0 || row >= this.rowHeights.length) {
            throw new IndexOutOfBoundsException(String.valueOf(row));
        }
        int rowY = this.padding.top;
        for (int i = 0; i < row; ++i) {
            rowY += this.rowHeights[i] + this.verticalSpacing;
        }
        return new Bounds(0, rowY, this.getWidth(), this.rowHeights[row]);
    }

    @Override
    public int getColumnAt(int x) {
        int columnWidth;
        if (this.columnWidths == null) {
            return -1;
        }
        int columnIndex = -1;
        int j = 0;
        for (int columnX = this.padding.left; columnX <= x && j < this.columnWidths.length; columnX += columnWidth + this.horizontalSpacing, ++j) {
            columnWidth = this.columnWidths[j];
            if (x >= columnX + columnWidth) continue;
            columnIndex = j;
            break;
        }
        return columnIndex;
    }

    @Override
    public Bounds getColumnBounds(int column) {
        if (this.columnWidths == null) {
            return new Bounds(0, 0, 0, 0);
        }
        if (column < 0 || column >= this.columnWidths.length) {
            throw new IndexOutOfBoundsException(String.valueOf(column));
        }
        int columnX = this.padding.left;
        for (int j = 0; j < column; ++j) {
            columnX += this.columnWidths[j] + this.horizontalSpacing;
        }
        return new Bounds(columnX, 0, this.columnWidths[column], this.getHeight());
    }

    @Override
    public void rowInserted(TablePane tablePane, int index) {
        this.invalidateComponent();
    }

    @Override
    public void rowsRemoved(TablePane tablePane, int index, Sequence<TablePane.Row> rows) {
        this.invalidateComponent();
    }

    @Override
    public void rowHeightChanged(TablePane.Row row, int previousHeight, boolean previousRelative) {
        this.invalidateComponent();
    }

    @Override
    public void rowHighlightedChanged(TablePane.Row row) {
        TablePane tablePane = row.getTablePane();
        this.repaintComponent(this.getRowBounds(tablePane.getRows().indexOf(row)));
    }

    @Override
    public void columnInserted(TablePane tablePane, int index) {
        this.invalidateComponent();
    }

    @Override
    public void columnsRemoved(TablePane tablePane, int index, Sequence<TablePane.Column> columns) {
        this.invalidateComponent();
    }

    @Override
    public void columnWidthChanged(TablePane.Column column, int previousWidth, boolean previousRelative) {
        this.invalidateComponent();
    }

    @Override
    public void columnHighlightedChanged(TablePane.Column column) {
        TablePane tablePane = column.getTablePane();
        this.repaintComponent(this.getColumnBounds(tablePane.getColumns().indexOf(column)));
    }

    @Override
    public void cellInserted(TablePane.Row row, int column) {
        this.invalidateComponent();
    }

    @Override
    public void cellsRemoved(TablePane.Row row, int column, Sequence<Component> removed) {
        this.invalidateComponent();
    }

    @Override
    public void cellUpdated(TablePane.Row row, int column, Component previousComponent) {
        this.invalidateComponent();
    }

    @Override
    public void rowSpanChanged(TablePane tablePane, Component component, int previousRowSpan) {
        this.invalidateComponent();
    }

    @Override
    public void columnSpanChanged(TablePane tablePane, Component component, int previousColumnSpan) {
        this.invalidateComponent();
    }
}

