/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.validation;

import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.pivot.wtk.validation.Validator;

public class FormattedValidator<F extends Format>
implements Validator {
    protected final F format;
    protected final Locale locale;

    public FormattedValidator(F format) {
        this(format, null);
    }

    public FormattedValidator(F format, Locale locale) {
        if (format == null) {
            throw new IllegalArgumentException("format is null.");
        }
        this.format = format;
        this.locale = locale == null ? Locale.getDefault() : locale;
    }

    @Override
    public boolean isValid(String text) {
        Object obj;
        String textToParse = text;
        ParsePosition pos = new ParsePosition(0);
        if (this.format instanceof NumberFormat) {
            textToParse = textToParse.toUpperCase(this.locale);
        }
        return (obj = ((Format)this.format).parseObject(textToParse, pos)) != null && pos.getErrorIndex() == -1 && pos.getIndex() == text.length();
    }
}

