/*
 * Decompiled with CFR 0.152.
 */
package utils.privileged;

import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.log4j.Logger;
import tw.com.chttl.CertUtil;
import tw.com.chttl.Module;
import tw.com.chttl.OCSP;
import tw.com.chttl.Token;
import utils.MESSAGE;
import utils.TCCertUtil;
import utils.exchange.soap.Xcaexchange;
import utils.exchange.soap.Xcaexchange_Service;

public class CheckCard
implements PrivilegedAction<MESSAGE> {
    private static final Logger logger = Logger.getLogger(CheckCard.class);
    private String certtype;
    private String schoolid;
    private String schoolname;
    private String cardnumber;

    public CheckCard(String certtype, String schoolid, String schoolname) {
        this.certtype = certtype;
        this.schoolid = schoolid;
        this.schoolname = schoolname;
    }

    public CheckCard(String certtype) {
        this.certtype = certtype;
    }

    public CheckCard() {
    }

    public String getSchoolid() {
        return this.schoolid;
    }

    public void setSchoolid(String schoolid) {
        this.schoolid = schoolid;
    }

    public String getSchoolname() {
        return this.schoolname;
    }

    public void setSchoolname(String schoolname) {
        this.schoolname = schoolname;
    }

    public String getCardnumber() {
        return this.cardnumber;
    }

    public void setCardnumber(String cardnumber) {
        this.cardnumber = cardnumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MESSAGE run() {
        MESSAGE result = MESSAGE.CERTERROR_READER_NOT_EXIST;
        try {
            try {
                boolean init = Module.initialize();
                if (!init) return result;
                Module module = Module.getInstance();
                int[] tokIDs = module.getTokens();
                if (tokIDs.length != 0) {
                    result = MESSAGE.CERT_CHECK_SUCCESS;
                    X509Certificate xca = null;
                    Token token = module.getToken(tokIDs[0]);
                    this.cardnumber = token.getSerialNumber();
                    logger.debug((Object)("XCA\u5361\u865f : " + this.cardnumber));
                    xca = token.getCert(Token.ID_SIGN);
                    String type = CertUtil.getCertType(xca);
                    logger.debug((Object)("\u5361\u7247\u985e\u578b : " + type));
                    logger.debug((Object)("OCSP : " + CertUtil.getOCSP(xca)));
                    logger.debug((Object)("\u7c3d\u7ae0\u6191\u8b49\u5e8f\u865f : " + TCCertUtil.getSerialNumberFromHex(xca.getSerialNumber().toByteArray())));
                    if (!type.equals("XCA")) {
                        result = MESSAGE.CERTERROR_NOT_XCA;
                        return result;
                    }
                    if (this.schoolid != null) {
                        String regserial = CheckCard.doQueryXCASerial(this.schoolid, this.schoolname);
                        logger.debug((Object)("\u5df2\u8a3b\u518aXCA\u5361\u865f:" + regserial));
                        if (!this.cardnumber.equals(regserial)) {
                            result = MESSAGE.CERTERROR_NOT_REG_XCA;
                            return result;
                        }
                        if (OCSP.checkStatus(xca) == 0) return result;
                        result = MESSAGE.CERTERROR_OCSP_VERIFY_FAILED;
                        return result;
                    }
                    List<String> schoolinfo = CheckCard.doQuerySchoolid(this.cardnumber);
                    if (schoolinfo == null) {
                        result = MESSAGE.CERTERROR_NOT_REG_XCA;
                        return result;
                    }
                    if (OCSP.checkStatus(xca) != 0) {
                        result = MESSAGE.CERTERROR_OCSP_VERIFY_FAILED;
                        return result;
                    }
                    this.schoolid = schoolinfo.get(0);
                    this.schoolname = schoolinfo.get(1);
                    logger.debug((Object)("\u6559\u80b2\u90e8\u4ee3\u78bc:" + this.schoolid + ";\u5b78\u6821\u540d\u7a31:" + this.schoolname));
                    return result;
                }
                result = MESSAGE.CERTERROR_CARD_NOT_EXIST;
                return result;
            }
            catch (Exception e2) {
                result = MESSAGE.CERTERROR_EXCEPTION;
                logger.error((Object)e2.getMessage());
            }
        }
        finally {
            return result;
        }
    }

    private static String doQueryXCASerial(String schoolid, String schoolname) {
        Xcaexchange_Service service = new Xcaexchange_Service();
        Xcaexchange port = service.getXcaexchangePort();
        return port.doQueryXCASerial(schoolid, schoolname);
    }

    private static List<String> doQuerySchoolid(String xcaSerial) {
        Xcaexchange_Service service = new Xcaexchange_Service();
        Xcaexchange port = service.getXcaexchangePort();
        return port.doQuerySchoolid(xcaSerial);
    }
}

