/*
 * Decompiled with CFR 0.152.
 */
package utils.privileged;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import tw.com.chttl.CryptoUtil;
import tw.com.chttl.Module;
import tw.com.chttl.Token;

public class SignValue
implements PrivilegedAction<String> {
    private static final Logger logger = Logger.getLogger(SignValue.class);
    private String params;
    private final String password;
    private String cardnumber;

    public SignValue(String params, String password) {
        this.params = params;
        this.password = password;
    }

    public SignValue(String password) {
        this.password = password;
    }

    public String getCardnumber() {
        return this.cardnumber;
    }

    public void setCardnumber(String cardnumber) {
        this.cardnumber = cardnumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String run() {
        String signed = null;
        X509Certificate xca = null;
        Token tok = null;
        try {
            Module.initialize();
            Module module = Module.getInstance();
            int[] tokIDs = module.getTokens();
            if (tokIDs.length != 0) {
                tok = module.getToken(tokIDs[0]);
                if (tok.isTokenPresent()) {
                    if (tok.login(this.password)) {
                        xca = tok.getCert(Token.ID_SIGN);
                        this.cardnumber = tok.getSerialNumber();
                        logger.debug((Object)("XCA\u5361\u865f : " + this.cardnumber + " BASE64 :" + Base64.encodeBase64String(this.cardnumber.getBytes("UTF-8"))));
                        if (this.params == null) {
                            this.params = Base64.encodeBase64String(this.cardnumber.getBytes("UTF-8"));
                        }
                        logger.debug((Object)("\u539f\u59cb\u53c3\u6578(base64):\n" + this.params));
                        logger.debug((Object)("\u539f\u59cb\u53c3\u6578:\n" + new String(Base64.decodeBase64(this.params), "UTF-8")));
                        String ori = new String(Base64.decodeBase64(this.params), "UTF-8");
                        byte[] bparams = ori.getBytes("UTF-8");
                        byte[] sbparams = tok.sign(Token.ID_SIGN, bparams, "SHA256withRSA");
                        String b64 = Base64.encodeBase64String(sbparams);
                        logger.debug((Object)("\u7c3d\u7ae0\u904e\u5f8c\u5b57\u4e32BASE64:\n" + b64));
                        logger.debug((Object)("\u539f\u751f\u51fd\u5f0f\u5eabBase64:\n" + DatatypeConverter.printBase64Binary((byte[])bparams)));
                        if (logger.isDebugEnabled()) {
                            int n;
                            logger.info((Object)("\u9a57\u7c3d\u7d50\u679c:\n" + CryptoUtil.verify(xca, bparams, sbparams, "SHA256withRSA")));
                            URL website = new URL("http://xca.nat.gov.tw/PEXE_XCA/DownLoadCert.CEXE?CertNo=74251BD964A24327564F94FAC8F59E87");
                            byte[] buffer = new byte[4096];
                            ByteArrayOutputStream bais = new ByteArrayOutputStream();
                            InputStream is = website.openStream();
                            while ((n = is.read(buffer)) > 0) {
                                bais.write(buffer, 0, n);
                            }
                            bais.flush();
                            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(bais.toByteArray()));
                            Signature sig = Signature.getInstance("SHA256withRSA");
                            sig.initVerify(cert.getPublicKey());
                            sig.update(ori.getBytes("UTF-8"));
                            logger.info((Object)("Java\u539f\u751f\u51fd\u5f0f\u9a57\u7c3d\u7d50\u679c: " + sig.verify(Base64.decodeBase64(b64))));
                        }
                        signed = b64;
                    }
                    signed = "PIN\u78bc\u932f\u8aa4";
                    return signed;
                }
            }
        }
        catch (UnsupportedEncodingException | CertificateException e2) {
            logger.error((Object)e2.getMessage());
        }
        finally {
            tok.logout();
            return signed;
        }
    }
}

