/*
 * Decompiled with CFR 0.152.
 */
package misc;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.stage.Stage;
import javafx.stage.Window;
import jfx.messagebox.MessageBox;
import misc.AUX;
import misc.AUx;
import misc.AuX;
import misc.Aux;
import misc.aUX;
import misc.aUx;
import misc.auX;
import misc.aux;
import misc.con;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import sun.security.provider.certpath.OCSP;
import tw.com.chttl.Token;

public class SLUtils {
    public static final String CERTTPEXCA = "XCA";
    public static final String CERTYPEMOICA = "MOICA";
    public static final String CERTYPEGCA = "GCA";
    public static final String XCA_DOWNLOAD_URL = "http://xca.nat.gov.tw/PEXE_XCA/DownLoadCert.CEXE?CertNo=";
    public static final String GCA_DOWNLOAD_URL = "http://gca.nat.gov.tw/PEXE_GCA4/DownLoadCert.CEXE?CertNo=";
    public static final String MOICA_DOWNLOAD_URL = "http://moica.nat.gov.tw/PEXE_MOICA/DownLoadCert.CEXE?CertNo=";
    public static final String XCA_OCSP_URL = "http://xca.nat.gov.tw/cgi-bin/XCAOCSP/ocsp_server.exe";
    public static final String XCA2_OCSP_URL = "http://xca.nat.gov.tw/cgi-bin/OCSP2/ocsp_server.exe";
    public static final String GCA_OCSP_URL = "http://gca.nat.gov.tw/cgi-bin/OCSP/ocsp_server.exe";
    public static final String GCA2_OCSP_URL = "http://gca.nat.gov.tw/cgi-bin/OCSP2/ocsp_server.exe";
    public static final String TMP_FOLDER = System.getProperty("java.io.tmpdir");
    public static final String TMP_FILE_NAME = TMP_FOLDER + "9std.txt";
    public static final String TMP_B64_DEC_FILE_NAME = TMP_FOLDER + "9st_dec.b64";
    public static final String TMP_B64_ENC_FILE_NAME = TMP_FOLDER + "9st_enc.b64";
    public static final String TMP_ZIP_FILE_NAME = TMP_FOLDER + "9std.zip";
    public static final int AGENT_TIMEOUT = 3000000;
    public static final int FUTURE_TASK_TIMEOUT = 180;
    public static final String ACTIVATION_URL_POSTFIX = "/api/activation";
    public static final String REALIP_URL_POSTFIX = "/api/real-ip";
    public static final String KEYAGREEMENT_URL_POSTFIX = "/api/keyagreement";
    public static final String FILEUPLOAD_URL_POSTFIX = "/api/fileupload";
    public static final String EXCHANGE_STUDMOVECANCEL_URL_POSTFIX = "/api/studmove-cancel";
    public static final String EXCHANGE_FILEUPLOAD_URL_POSTFIX = "/api/exchange-fileupload";
    public static final String EXCHANGE_FILEAVAILABLE_URL_POSTFIX = "/api/exchange-file-available";
    public static final String EXCHANGE_FILE_GET_URL_POSTFIX = "/api/exchange-file-get";
    public static final String CARDINFO_ENCRYPTION_URL_POSTFIX = "/api/cardinfo/encryption";
    public static final String CARDINFO_SIGN_URL_POSTFIX = "/api/cardinfo/sign";
    public static final String CARDINFO_CARDNUMBER_URL_POSTFIX = "/api/cardinfo/cardnumber";
    public static final String EXCHANGE_FILE_GET_SUCCESS_URL_POSTFIX = "/api/exchange_get_file_success";
    public static final String CARDINFO_ERRORMSG = "\u55ae\u4f4d\u4ee3\u78bc\u4e0d\u53ef\u4ee5\u7a7a\u767d,\u5c1a\u672a\u8a3b\u518a,\u7121\u6b64\u55ae\u4f4d\u4ee3\u78bc,\u67e5\u8a62\u904e\u7a0b\u767c\u751f\u932f\u8aa4,\u7121\u6cd5\u5efa\u7acb\u8cc7\u6599\u5eab\u9023\u7dda";
    public static final Logger logger = Logger.getLogger(SLUtils.class);

    public static boolean checkBase64String(String string) {
        String string2 = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        logger.debug((Object)("IS BASE64 String : " + matcher.matches()));
        return matcher.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDomainName(String string) {
        String string2 = "";
        try {
            URI uRI = new URI(string);
            String string3 = uRI.getHost();
            string2 = string3.startsWith("www.") ? string3.substring(4) : string3;
            return string2;
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.error((Object)uRISyntaxException);
        }
        finally {
            return string2;
        }
    }

    public static String getSFSIP(String string) {
        String string2 = "127.0.0.1";
        try {
            InetAddress inetAddress = InetAddress.getByName(new URL(string).getHost());
            string2 = inetAddress.getHostAddress();
        }
        catch (MalformedURLException | UnknownHostException iOException) {
            logger.error((Object)iOException);
        }
        return string2;
    }

    public static X509Certificate getXCAX509Certificate(String string) throws MalformedURLException, IOException, CertificateException {
        return SLUtils.a(XCA_DOWNLOAD_URL, string);
    }

    public static X509Certificate getGCAX509Certificate(String string) throws MalformedURLException, IOException, CertificateException {
        return SLUtils.a(GCA_DOWNLOAD_URL, string);
    }

    public static X509Certificate getMOICAX509Certificate(String string) throws MalformedURLException, IOException, CertificateException {
        return SLUtils.a(MOICA_DOWNLOAD_URL, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate a(String string, String string2) {
        X509Certificate x509Certificate = null;
        try {
            int n;
            BigInteger bigInteger = new BigInteger(string2, 16);
            byte[] byArray = bigInteger.toByteArray();
            String string3 = SLUtils.a(byArray);
            if (string3.startsWith("00")) {
                string3 = string3.substring(2);
            }
            logger.debug((Object)("\u539f\u59cb\u5e8f\u865f:[" + string2 + "]-\u66f4\u65b0\u5e8f\u865f[" + string3 + "]\n"));
            URL uRL = new URL(string.concat(string3));
            byte[] byArray2 = new byte[4096];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = uRL.openStream();
            while ((n = inputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.flush();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            logger.debug((Object)("Cert DN : " + x509Certificate.getSubjectDN().getName()));
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)malformedURLException);
        }
        catch (IOException | CertificateException exception) {
            int n;
            logger.error((Object)exception);
            BigInteger bigInteger = new BigInteger(string2, 16);
            byte[] byArray = bigInteger.toByteArray();
            String string4 = SLUtils.a(byArray);
            if (string4.startsWith("00")) {
                string4 = string4.substring(2);
            }
            logger.debug((Object)("\u539f\u59cb\u5e8f\u865f:[" + string2 + "]-\u66f4\u65b0\u5e8f\u865f[" + string4 + "]\n"));
            URL uRL = new URL(GCA_DOWNLOAD_URL.concat(string4));
            byte[] byArray3 = new byte[4096];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = uRL.openStream();
            while ((n = inputStream.read(byArray3)) > 0) {
                byteArrayOutputStream.write(byArray3, 0, n);
            }
            byteArrayOutputStream.flush();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            logger.debug((Object)("Cert DN : " + x509Certificate.getSubjectDN().getName()));
        }
        finally {
            return x509Certificate;
        }
    }

    private static String a(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String string = "0123456789ABCDEF";
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (byte by : byArray) {
            stringBuilder.append("0123456789ABCDEF".charAt((by & 0xF0) >> 4)).append("0123456789ABCDEF".charAt(by & 0xF));
        }
        return stringBuilder.toString();
    }

    public static boolean doVerify(X509Certificate x509Certificate, String string, String string2) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, SignatureException, NoSuchProviderException {
        boolean bl = false;
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initVerify(x509Certificate);
        logger.debug((Object)("oristring :\n" + string));
        signature.update(string.getBytes("UTF-8"));
        logger.debug((Object)("signed :\n" + string2));
        bl = signature.verify(Base64.decodeBase64((String)string2));
        logger.debug((Object)("isValid : " + bl));
        return bl;
    }

    public static String getSerialNumberFromHex(byte[] byArray) {
        return new aux(byArray).a();
    }

    public static OCSP.RevocationStatus.CertStatus verifySMARTCARD2FromOCSP(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws IOException, CertPathValidatorException {
        return OCSP.check((X509Certificate)x509Certificate, (X509Certificate)x509Certificate2).getCertStatus();
    }

    public static OCSP.RevocationStatus.CertStatus verifySMARTCARDFromOCSP(X509Certificate x509Certificate, X509Certificate x509Certificate2) throws IOException, CertPathValidatorException {
        return OCSP.check((X509Certificate)x509Certificate, (X509Certificate)x509Certificate2).getCertStatus();
    }

    public static X509Certificate getCertFromInputStream(InputStream inputStream) {
        return new Aux(inputStream).a();
    }

    public static String getCurrentDateTime() {
        DateTime dateTime = new DateTime();
        String string = SLUtils.a(dateTime);
        return string;
    }

    private static String a(DateTime dateTime) {
        return new aUx(dateTime).a();
    }

    public static String generateSignData(Object object) {
        return new AUx(object).a();
    }

    public static String generateSignDataDigest(Object object) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return new auX(object).a();
    }

    public static String generateSignature(Token token, String string) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return new AuX(string, token).a();
    }

    public static String Obj2Json(Object object) throws JsonProcessingException {
        return new aUX(object).a();
    }

    public static void showMsg(Stage stage, String string, String string2, int n) {
        MessageBox.show((Window)stage, (String)string, (String)string2, (int)n);
    }

    public static void showErrorMsg(Stage stage, String string) {
        MessageBox.show((Window)stage, (String)string, (String)"\u57f7\u884c\u932f\u8aa4", (int)0x1000000);
    }

    public static void showSuccessMsg(Stage stage, String string) {
        MessageBox.show((Window)stage, (String)string, (String)"\u57f7\u884c\u5b8c\u7562", (int)0x4000000);
    }

    public static String authorizationHeader(String string, String string2) {
        String string3 = string + ":" + string2;
        byte[] byArray = Base64.encodeBase64((byte[])string3.getBytes(Charset.forName("US-ASCII")));
        String string4 = "Basic " + new String(byArray);
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void base64EncodeFile(String string, String string2) {
        con con2 = new con(string, string2);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future future = executorService.submit(con2);
        try {
            future.get(180L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            logger.error((Object)exception);
        }
        finally {
            executorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void base64DecodeFile(String string, String string2) {
        AUX aUX2 = new AUX(string, string2);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future future = executorService.submit(aUX2);
        try {
            future.get(180L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            logger.error((Object)exception);
        }
        finally {
            executorService.shutdown();
        }
    }

    public static String getCode(String string) {
        int n = string.indexOf("(");
        int n2 = string.indexOf(")");
        String string2 = string.substring(n + 1, n2);
        logger.debug((Object)("Code : " + string2));
        return string2;
    }

    public static String getCBPrefix(String string) {
        String string2 = string.substring(0, string.indexOf("("));
        logger.debug((Object)("CBPrefix : " + string2));
        return string2;
    }
}

