/*
 * Decompiled with CFR 0.152.
 */
package security;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.Map;
import javax.crypto.spec.DHParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import security.AESUtil;
import security.AppletPostSFS;
import security.ExchangeKey;
import security.ExchangeKeyTypes;

public final class AppletPost2SFS
extends AppletPostSFS {
    private final String a;
    private final String b;
    private Map c;
    private String d;
    private String e;
    private static final Logger f = Logger.getLogger(AppletPost2SFS.class);

    public AppletPost2SFS(String string, String string2, String string3, String string4, String string5) {
        super(string, string3, string5);
        this.a = string2;
        this.b = string4;
        this.g();
        if (string2.equals("true")) {
            this.e();
        } else {
            this.f();
        }
    }

    public String getSfsdata() {
        return this.e;
    }

    protected void a(String string) {
        this.e = string;
    }

    private final void e() {
        try {
            this.h();
            this.f();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | InvalidParameterSpecException generalSecurityException) {
            f.error((Object)generalSecurityException);
        }
        catch (InvalidKeyException | InvalidKeySpecException generalSecurityException) {
            f.equals(generalSecurityException);
            this.e();
        }
    }

    private void f() {
        String string = null;
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        arrayList.add(new BasicNameValuePair("sid", this.getSessionid()));
        if (this.a.equals("true")) {
            arrayList.add(new BasicNameValuePair("getkey", "false"));
        }
        try {
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(arrayList, "UTF-8");
            HttpPost httpPost = this.getHttpPost();
            httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
            HttpClientContext httpClientContext = HttpClientContext.create();
            httpClientContext.setAttribute("http.protocol.content-charset", (Object)"UTF-8");
            CloseableHttpClient closeableHttpClient = this.getHttpclient();
            HttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost, (HttpContext)httpClientContext);
            string = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
            f.debug((Object)("SFS Response (DATA): " + string));
            if (this.a.equals("true")) {
                this.a(AESUtil.decrypt(string, (String)this.c.get((Object)ExchangeKeyTypes.ShareAESKey)));
            } else {
                this.a(string);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            f.error((Object)unsupportedEncodingException);
        }
        catch (IOException iOException) {
            f.error((Object)iOException);
        }
    }

    protected Map b() {
        return this.c;
    }

    protected void a(Map map) {
        this.c = map;
    }

    protected String c() {
        return this.d;
    }

    protected void b(String string) {
        this.d = string;
    }

    private void g() {
        HttpPost httpPost = new HttpPost(this.getPostUrl());
        httpPost.setHeader("User-Agent", this.b);
        f.debug((Object)this.b);
        this.setHttpPost(httpPost);
    }

    private void h() throws InvalidKeySpecException, InvalidKeyException, NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException {
        String string = null;
        this.c = ExchangeKey.generateServerDHKey();
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        arrayList.add(new BasicNameValuePair("sid", this.getSessionid()));
        arrayList.add(new BasicNameValuePair("getkey", "true"));
        arrayList.add(new BasicNameValuePair("serverp", (String)this.c.get((Object)ExchangeKeyTypes.P)));
        arrayList.add(new BasicNameValuePair("serverg", (String)this.c.get((Object)ExchangeKeyTypes.G)));
        arrayList.add(new BasicNameValuePair("serverpk", (String)this.c.get((Object)ExchangeKeyTypes.PublicKey)));
        try {
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(arrayList, "UTF-8");
            HttpPost httpPost = this.getHttpPost();
            httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
            HttpClientContext httpClientContext = HttpClientContext.create();
            httpClientContext.setAttribute("http.protocol.content-charset", (Object)"UTF-8");
            CloseableHttpClient closeableHttpClient = this.getHttpclient();
            HttpResponse httpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost, (HttpContext)httpClientContext);
            string = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            f.debug((Object)("SFS Response (public key): " + string));
            byte[] byArray = ExchangeKey.generateShareKey(string, (DHParameterSpec)this.c.get((Object)ExchangeKeyTypes.DHParameterSpec), (KeyPair)this.c.get((Object)ExchangeKeyTypes.PublicKeyPair));
            f.debug((Object)("Server Secret Key :\n" + Base64.encodeBase64String((byte[])byArray) + "\n" + ExchangeKey.generateAESKey(byArray)));
            this.c.put(ExchangeKeyTypes.ShareSecretKey, Base64.encodeBase64String((byte[])byArray));
            this.c.put(ExchangeKeyTypes.ShareAESKey, ExchangeKey.generateAESKey(byArray));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            f.error((Object)unsupportedEncodingException);
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException exception) {
            f.error((Object)exception);
        }
    }

    static /* synthetic */ Logger d() {
        return f;
    }
}

