/*
 * Decompiled with CFR 0.152.
 */
package jfx.messagebox;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import jfx.messagebox.MessageIconBuilder;
import jfx.messagebox.Messages;

public class MessageBox {
    public static final int ICON_ERROR = 0x1000000;
    public static final int ICON_WARNING = 0x2000000;
    public static final int ICON_INFORMATION = 0x4000000;
    public static final int ICON_QUESTION = 0x8000000;
    public static final int OK = 65536;
    public static final int CANCEL = 131072;
    public static final int YES = 262144;
    public static final int NO = 524288;
    public static final int ABORT = 0x100000;
    public static final int RETRY = 0x200000;
    public static final int IGNORE = 0x400000;
    public static final int DEFAULT_BUTTON1 = 256;
    public static final int DEFAULT_BUTTON2 = 512;
    public static final int DEFAULT_BUTTON3 = 1024;
    public static final int DEFAULT_BUTTON4 = 2048;

    protected MessageBox() {
    }

    public static int show(Window parent, String message, String title, int option) {
        Group group;
        final int[] result = new int[]{131072};
        final Stage dialog = new Stage(StageStyle.UTILITY);
        dialog.setTitle(title);
        dialog.setResizable(false);
        dialog.initModality(Modality.WINDOW_MODAL);
        if (parent != null) {
            dialog.initOwner(parent);
        }
        VBox totalPane = new VBox();
        dialog.setScene(new Scene((Parent)totalPane));
        totalPane.setAlignment(Pos.CENTER);
        totalPane.setSpacing(2.0);
        HBox pane = new HBox();
        totalPane.getChildren().add((Object)pane);
        pane.setSpacing(10.0);
        pane.getChildren().add((Object)new Label(""));
        pane.getChildren().add((Object)new Label(""));
        VBox vbox = new VBox();
        pane.getChildren().add((Object)vbox);
        vbox.setAlignment(Pos.CENTER);
        if ((option & 0x1000000) == 0x1000000) {
            group = MessageIconBuilder.drawErrorIcon(3);
            vbox.getChildren().add((Object)group);
        } else if ((option & 0x2000000) == 0x2000000) {
            group = MessageIconBuilder.drawWarningIcon(3);
            vbox.getChildren().add((Object)group);
        } else if ((option & 0x4000000) == 0x4000000) {
            group = MessageIconBuilder.drawInformationIcon(3);
            vbox.getChildren().add((Object)group);
        } else if ((option & 0x8000000) == 0x8000000) {
            group = MessageIconBuilder.drawQuestionIcon(3);
            vbox.getChildren().add((Object)group);
        }
        vbox = new VBox();
        pane.getChildren().add((Object)vbox);
        vbox.setAlignment(Pos.CENTER);
        vbox.getChildren().add((Object)new Label(""));
        vbox.getChildren().add((Object)new Label(message));
        pane.getChildren().add((Object)new Label(""));
        pane.getChildren().add((Object)new Label(""));
        vbox.getChildren().add((Object)new Label(""));
        vbox.getChildren().add((Object)new Label(""));
        boolean isButtonExists = false;
        int[] BUTTON_LIST = new int[]{65536, 262144, 524288, 0x100000, 0x200000, 0x400000, 131072};
        String[] BUTTON_STRING_LIST = new String[]{Messages.getString("MessageBox.OK"), Messages.getString("MessageBox.YES"), Messages.getString("MessageBox.NO"), Messages.getString("MessageBox.ABORT"), Messages.getString("MessageBox.RETRY"), Messages.getString("MessageBox.IGNORE"), Messages.getString("MessageBox.CANCEL")};
        HBox hboxButtons = new HBox();
        totalPane.getChildren().add((Object)hboxButtons);
        hboxButtons.setSpacing(10.0);
        hboxButtons.setAlignment(Pos.CENTER);
        hboxButtons.getChildren().add((Object)new Label(""));
        int buttonCounter = 0;
        for (int index = 0; index < BUTTON_LIST.length; ++index) {
            if ((option & BUTTON_LIST[index]) != BUTTON_LIST[index]) continue;
            Button btnAdd = new Button();
            btnAdd.setText(BUTTON_STRING_LIST[index]);
            isButtonExists = true;
            final int resultValue = BUTTON_LIST[index];
            btnAdd.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    dialog.close();
                    result[0] = resultValue;
                }
            });
            hboxButtons.getChildren().add((Object)btnAdd);
            ++buttonCounter;
            if ((option & 0x20000) == 131072) {
                btnAdd.setCancelButton(true);
            }
            MessageBox.setupDefaultButton(option, buttonCounter, btnAdd);
        }
        if (!isButtonExists) {
            Button btnAdd = new Button();
            hboxButtons.getChildren().add((Object)btnAdd);
            btnAdd.setText(BUTTON_STRING_LIST[0]);
            btnAdd.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    dialog.close();
                    result[0] = 65536;
                }
            });
            btnAdd.setCancelButton(true);
        }
        hboxButtons.getChildren().add((Object)new Label(""));
        totalPane.getChildren().add((Object)new Label(""));
        dialog.showAndWait();
        return result[0];
    }

    private static void setupDefaultButton(int option, int buttonCounter, Button btnAdd) {
        switch (buttonCounter) {
            case 1: {
                if ((option & 0x100) != 256) break;
                btnAdd.setDefaultButton(true);
                break;
            }
            case 2: {
                if ((option & 0x200) != 512) break;
                btnAdd.setDefaultButton(true);
                break;
            }
            case 3: {
                if ((option & 0x400) != 1024) break;
                btnAdd.setDefaultButton(true);
                break;
            }
            case 4: {
                if ((option & 0x800) != 2048) break;
                btnAdd.setDefaultButton(true);
            }
        }
    }
}

